#!/usr/bin/python
# -*- coding: utf-8 -*-
############################################################
#print '======================='

#####################################################################################
# NIST-developed software is provided by NIST as a public service. You may use, 
# copy and distribute copies of the software in any medium, provided that you 
# keep intact this entire notice. You may improve, modify and create derivative 
# works of the software or any portion of the software, and you may copy and 
# distribute such modifications or works. Modified works should carry a notice 
# stating that you changed the software and should note the date and nature of 
# any such change. Please explicitly acknowledge the National Institute of 
# Standards and Technology as the source of the software.
# 
# NIST-developed software is expressly provided “AS IS.” NIST MAKES NO WARRANTY 
# OF ANY KIND, EXPRESS, IMPLIED, IN FACT OR ARISING BY OPERATION OF LAW, 
# INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT AND DATA ACCURACY. NIST NEITHER 
# REPRESENTS NOR WARRANTS THAT THE OPERATION OF THE SOFTWARE WILL BE 
# UNINTERRUPTED OR ERROR-FREE, OR THAT ANY DEFECTS WILL BE CORRECTED. NIST DOES 
# NOT WARRANT OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF THE SOFTWARE OR 
# THE RESULTS THEREOF, INCLUDING BUT NOT LIMITED TO THE CORRECTNESS, ACCURACY, 
# RELIABILITY, OR USEFULNESS OF THE SOFTWARE.
# 
# You are solely responsible for determining the appropriateness of using and 
# distributing the software and you assume all risks associated with its use, 
# including but not limited to the risks and costs of program errors, compliance 
# with applicable laws, damage to or loss of data, programs or equipment, and the 
# unavailability or interruption of operation. This software is not intended to 
# be used in any situation where a failure could cause risk of injury or damage 
# to property. The software developed by NIST employees is not subject to 
# copyright protection within the United States.
#####################################################################################

wb = 'B'
nowb = 'N'

import os
from ft_di_desc import *
os_info = os.uname()
ver = "Tool: @(#) ft_di_run.py Version 1.13 created 05/23/18 at 16:08:29\n"+"OS: %s Version %s\n"%(os_info[0],os_info[2])
html_head = '''
<html>
<TITLE>Disk Imaging Run Procedures</TITLE>
<body><H1>Run Procedures for Disk Imaging</H1>
<P>Federated Testing<P>Disk Imaging Tool Setup<p> 
'''
html_tail = '''
</body>
</html>
'''

tk_attach_media = '''
<li> If not already attached, attach and mount media-target drive for storing image files.
'''
#tk_attach_media = '''
#<li> Attach removable device for storing image files.
#<li> Mount the partition by clicking on its icon in the tool bar.
#<li> If the drive fails to mount, manually 
#<a href = "/diskimaging/commonprocedures.php?display=mountpartition">
#mount </a> the drive.
#'''

def mk_boot(sys,d,wb1,x,wd2):

	dn = {'s':'source','d':'destination','m':'media-target','e':'source-error',
	'r':'source-reference'}
	if d not in dn or (x != '' and x not in dn):
		return 'bad call to mk_boot: (%s) (%s)'%(d,x)

	m = '''<li> While the %s PC is powered off, if the %s drive must be
	attached to the PC before booting, then attach the drive now XXX.
	Usually drives attached to the PC by either the ATA or SCSI interface need to be attached
	before booting the PC.
	Sometimes drives attached by the USB interface
	 interfere with booting and should be attached after booting is
	finished.'''%(sys,dn[d])

	if wb1 == wb: m = m.replace('XXX','using a write blocker')
	else : m = m.replace('XXX','')
#	m = 'attach %s to %s PC and boot.'%(dn[d],sys)
	if x != '':
		m += ' Also XXXattach the %s drive at this time if appropriate.'%(dn[x])
		if wd2 == wb: m = m.replace('XXX','using a write blocker, ')
		else: m = m.replace('XXX','')
	return m


old_tk_boot_test_nosrc = '''
<li> While the Test PC is powered off, attach to the PC any drives that need to
be attached before booting and can't be attached later.
These are usually drives attached to the PC by either the ATA or SCSI interface.
Sometimes USB drives interfere with booting and should be attached after booting is
finished.
<li> Boot the Test PC into the tool run-time environment, i.e., the OS
you use to run your tool.
<li> If the system clock time is not correct, reset to current date and time.
'''

tk_boot_test_nosrc = '''
<li> Boot the Test PC into the tool run-time environment, i.e., the OS
you use to run your tool.
<li> If the system clock time is not correct, reset to current date and time.
'''

tk_boot_test = tk_boot_test_nosrc + '''
<li>If not already attached, attach source drive via write blocker.
'''

tk_interface = '''
<li>If the source drive is fixed, i.e., attached directly to the computer motherboard 
via the ATA, SATA or SCSI interface, the drive should be attached before powering on the
computer. If the source drive is attached by USB, Firewite or eSATA the drive 
should be attached after the computer is powered on and booted. 
'''

tk_switch_test = '''
<hr><center>SWITCH TO TEST ENVIRONMENT/REBOOT</center><hr>
'''

tk_switch_analysis = '''
<hr><center>SWITCH TO ANALYSIS ENVIRONMENT/REBOOT</center><hr>
'''

tk_switch = '''
<hr><center>SWITCH ENVIRONMENT/REBOOT</center><hr>
'''
#<li> While the analysis PC is powered off, attach any fixed drives
#(ATA, SCSI, etc.) to the analysis PC.

tk_use_wb = '''
<li>Both the source and destination drives should be attached to the Analysis
PC using write blockers.
'''

old_tk_boot_analysis = '''
<li> While the analysis PC is powered off, attach to the PC any drives that need to
be attached before booting and can't be attached later.
These are usually drives attached to the PC by either the ATA or SCSI interface.
Sometimes USB drives interfere with booting and should be attached after booting is
finished.
<li> Boot the analysis PC with the CFTT Federated Testing boot CD.
<li>Open a terminal window by clicking on the terminal icon in the
tool bar (you are automatically the root user).
<li> If the system clock time is not correct, 
 <a href =
	"/diskimaging/commonprocedures.php?display=clock">
reset </a> the system clock on the PC to current date and time.
<li> Attach the FT-LOGS log drive and mount the drive by clicking on the
device icon in the tool bar.
'''
# If this fails manually <a href =
#	"/diskimaging/commonprocedures.php?display=mountpartition">
#	mount </a> the FT-LOGS log drive.


tk_boot_analysis = '''
<li> Boot the Analysis PC with the CFTT Federated Testing boot CD.
<li>Open a terminal window by clicking on the terminal icon in the
tool bar (you are automatically the root user).
<li> If the system clock time is not correct, 
 <a href =
	"/diskimaging/commonprocedures.php?display=clock">
reset </a> the system clock on the PC to current date and time.
<li> Attach the FT-LOGS log drive and mount the drive by clicking on the
device icon in the tool bar.
'''
# If this fails manually <a href =
#	"/diskimaging/commonprocedures.php?display=mountpartition">
#	mount </a> the FT-LOGS log drive.


tk_part_src = '''
<li> Attach source drive, but don't mount. Because the objective of this test
is 
acquisition over the %(var)s interface, it is required that the PC
interface used to
access the source drive is the %(var)s interface (i.e., the cable coming
out of the 
PC is %(var)s. It is OK if there is a write blocker between the source drive
and the PC with 
a different interface between the blocker and the source drive).
'''


tk_src = '''
<li> When you attach the <strong>write blocker to the hard drive</strong>, you
MUST use the<strong> %(iface)s cable </strong>to ensure the blocker uses the
%(iface)s interface for access to the drive because the
test objectives specify access to a %(iface)s drive.
It does not matter which interface is used between the test PC and the
write blocker. You should connect the blocker to the test PC as you would in practice.
If there is no write blocker and the drive is connected directly to the PC
motherboard then the cable coming out of the 
PC and connecting with the source drive must be
%(iface)s.
'''

tk_cmp_drive = '''
<li> If not already attached, attach source drive via write blocker, but don't mount.
<li> If not already attached, attach destination drive via write blocker, but don't mount.
<li>
 <a href = "/diskimaging/commonprocedures.php?display=view">
List </a>
attached devices and determine the Linux device names (e.g., sdb) of the source OBJ and
destination OBJ.
<li>Compare source OBJ to destination OBJ.
<ul>
<li>In a terminal window type: <a href =
"/diskimaging/commonprocedures.php?display=cfttdi">
<tt>cftt-di</tt></a> then press return/enter
<li>Create user/host profile, if asked or if current profile needs revision.
You will be asked for three things:
<ol>
<li> Your name. This is used to identify who is operating the computer. If more than
one person is running the tests, you need to change the profile when you
change operators.
<li>The computer used to run the NIST CD.
<li>The computer used to run the test tool.
</ol>
You will be asked to confirm the values intered and you can reenter if you see
a problem.
<li> Select the "compare source to destination" option by
typing the code on the left 
("5") followed by return/enter.
<ul>
<li>A list of possible test cases is displayed. Type the test case you are running.
<li>Enter the drive id for the source drive.
<li>cftt-di will display a list of attached devices.
Select the source OBJ by typing the code letter
to the left of the source's Linux device name, e.g., EXX etc.
<li>Enter the drive id for the destination drive.
<li>cftt-di will display a list of attached devices.
Select the destination OBJ by typing the code letter
to the left of the destination's Linux device name, e.g., EXX etc.
<li>
This step may take several hours depending on the size of the drive.
The process will give progress feedback.
</ul>
</ul>
'''
#  e.g., a, b, c, a2, c1, etc. for /dev/sda, /dev/sdb, /dev/sdc, /dev/sda2, /dev/sdc1, etc. 
tk_xd = ' a, b, c, etc. for /dev/sda, /dev/sdb, /dev/sdc,'
tk_xp = 'a2, c1, etc. for /dev/sda2, /dev/sdc1,'
tk_cmp_part = tk_cmp_drive.replace('OBJ','partition').replace('EXX',tk_xp)
tk_cmp_device = tk_cmp_drive.replace('OBJ','drive').replace('EXX',tk_xd)

tk_image_drive = '''
<li> Configure the tool you are testing to make an image of the %(obj)s and
compute a hash value. Make sure to name the image file %(img)s.
After you run the tool and mount the FT-LOGS drive (in the next few steps),
if the tool doesn't create a log file with
a hash or hashes, manually record the hash or hashes in a text file
named <tt>tool-log.txt</tt>.
Save <tt>tool-log.txt</tt> to the test case directory on the FT-LOGS log drive 
%%(case)s.
'''
tk_image_01 = tk_image_drive%{'img':'image-01-%(var)s',
'next_case':'image-02-%(var)s','obj':'source drive'}
tk_image_03 = tk_image_drive%{'img':'image-03-%(var)s',
'next_case':'image-04-%(var)s','obj':'removable media device'}
tk_image_05 = tk_image_drive%{'img':'image-05-%(var)s',
'next_case':'image-06-%(var)s','obj':'partition on the source drive'}

tk_restore_drive = '''
<li> Configure the tool you are testing to 
restore a %(obj)s image from an image file to a destination drive using
image file %(var)s.
'''
tk_restore_02 = tk_restore_drive%{'var':'image-01-%(var)s','obj':'source drive'}
tk_restore_04 = tk_restore_drive%{'var':'image-03-%(var)s','obj':'removable media device'}
tk_restore_06 = tk_restore_drive%{'var':'image-05-%(var)s','obj':'partition'}
tk_restore_06 = tk_restore_06.replace('drive','drive partition')

tk_hash_image = '''
<li> Configure the tool you are testing.
<ul>
<li> Select: "Hash image file"
<li> Select: "Image file to hash"
</ul>
'''

tk_hash_drive = '''
<li> Configure the tool you are testing.
<ul>
<li> Select: "Hash drive"
<li> Select: "Source drive to hash"
</ul>
'''

tk_run_base = '''
<li> Run the tool (this may take several hours
depending on drive size).
<li> Attach and mount the FT-LOGS log drive.
MSG
<li> If any errors occur, 
record the error messages issued by the tool in a text file named:
<tt>errors.txt</tt>
<li> If your tool produces a log file(s), save it and any <tt>errors.txt</tt> file 
to the test case directory on the FT-LOGS log drive %(case)s.
<li> Unmount and remove the log drive.
<li> If you don't need the Test PC, you can shutdown the PC now.
'''
tk_run_tool = tk_run_base.replace('MSG','')

tk_save_mess_base = '''
<li>Any tool messages indicating insufficent space to OBJ 
should be
copied to a file named 'message.txt', saved to the test case directory, %(case)s on
the FT-LOGS log drive.
'''
tk_run_tool_msg = tk_run_base.replace('MSG',tk_save_mess_base)

tk_run_tool_src = '''
<li>If not already attached, attach source drive via write blocker.
''' + tk_run_tool

tk_hash_drive = '''
<li> Configure the tool you are testing
to compute the hash value of the source drive.
If the tool doesn't create a log file with
a hash or hashes, manually record the hash or hashes in a text file
named <tt>tool-log.txt</tt>.
Save <tt>tool-log.txt</tt> to the test case directory on the FT-LOGS log drive 
%(case)s.
'''


tk_hash_image = '''
<li> Configure the tool you are testing to
compute the hash value of the image file you selected.
If the tool doesn't create a log file with
a hash or hashes, manually record the hash or hashes in a text file
named <tt>tool-log.txt</tt>.
Save <tt>tool-log.txt</tt> to the test case directory on the FT-LOGS log drive 
%(case)s.
'''

tk_clone_drive = '''
<li> Configure the tool you are testing to
clone (copy) the source %(obj)s to the destination %(obj)s.
'''

tk_doc_case = '''
<li> In the terminal window,
type <a href = "/diskimaging/commonprocedures.php?display=cfttdi"><tt>cftt-di,</tt></a>
press return/enter
 and select "Record case information" to document the test case by answering the
questions in the dialog.
<li> Click on 
 <a href = "/diskimaging/viewtestcaseresults.php?path=/media/cftt/FT-LOGS">View Test Case Results</a> 
to see the results for the test cases run so far and 
use the "Evaluation Criteria" below to check your results for this test, %(caseupper)s.
You can also check your results manually by examining the log files in
the test case directory (see Evaluating Test Case below).
<li> When you've completed all the test cases, 
click <a href = "/generatefinalreport.php?ref=di&path=/media/cftt/FT-LOGS">
Generate Test Report</a> to generate a bare bones test report that you can open in 
a word processor to complete.
<li> If you don't need the Analysis PC, you can shutdown the PC now.
'''

tk_doc_case_old = '''
<li> In the terminal window,
type <a href = "/diskimaging/commonprocedures.php?display=cfttdi"><tt>cftt-di,</tt></a>
press return/enter
 and select "Record case information" to document the test case by answering the
questions in the dialog.
<li>Click on 
 <a href =
	"/diskimaging/generatefinalreport.php?path=/media/cftt/FT-LOGS">
Generate Test Report </a> to generate a test report for the cases run so far and 
use the "Evaluation Criteria" below to check your results.
<li>As an alternative to generating a test report you can manually examine the log files in
the test case directory (see Evaluating Test Case below).
<li> If you don't need the Analysis PC, you can shutdown the PC now.
'''

tk_dst_fig = '''
<br><br>
The following figure shows an Analysis PC, booted from the Federated Testing CD,
writing known content to a destination drive and recording a description of the destination
drive to the FT-LOGS log drive.
<p>
'''

tk_prep_dst = '''
<li>
 <a href = "/diskimaging/commonprocedures.php?display=view">
List </a>
attached devices and determine the Linux device name (e.g., sdb) of the destination drive.
<li>Write known content to destination drive (wipe drive).
<br><br>
The following figure shows an Analysis PC, booted from the Federated Testing CD,
writing known content to a destination drive and recording a description of the destination
drive to the FT-LOGS log drive.
<p>
	<img src="graphics/wipe-dst.jpg">
<ul>
<li> In a terminal window type: <a href =
"/diskimaging/commonprocedures.php?display=cfttdi"><tt>cftt-di</tt></a>
 then press return/enter.
<li>Create user/host profile, if asked or if current profile needs revision.
You will be asked for three things:
<ol>
<li> Your name. This is used to identify who is operating the computer. If more than
one person is running the tests, you need to change the profile when you
change operators.
<li>The computer used to run the NIST CD.
<li>The computer used to run the test tool.
</ol>
You will be asked to confirm the values intered and you can reenter if you see
a problem.
<li> Select the "Wipe destination drive with known content" option by
typing the code on the left 
("3") followed by return/enter.
<ul>
<li>A list of possible test cases is displayed. Type the test case you are running.
<li>Enter the destination device's drive id, e.g., D1, D2, etc.
<li>cftt-di will display a list of attached devices.
Select the destination device by typing the code letter
to the left of the destination's Linux device name, e.g., a, b, c, etc.
<li>Confirm that you really want to overwrite the device (type "y" or "yes").
<li>
This step may take several hours depending on the size of the drive.
The process will give progress feedback.
</ul>
</ul>
%(is_part)s
<li> If you don't need the Analysis PC, you can shutdown the PC now.
'''

tk_mk_part = '''
<li><a href =
	"/diskimaging/mediasetup.php?menuexpand=mediasetup&display=partition">
	Create a partition</a>
 of type %(var)s on the destination drive. The partition can be larger that the source partition, but
 should not be smaller than the source partition.
'''

tk_select_dst = '''
<li> Select a drive to use as a destination drive.
Each destination drive must have a unique name.
Assign D1 to the first destination drive you set up and D2, D3 so forth to
additional destination drives.
Write the name on a label and attach it to the outside of the drive.
This is used to track where the drive is used in testing.
Case is ignored, e.g., D1 is the same as d1.
'''

tk_attach_wb_dst = '''
<li>If not already attached, attach destination drive to the PC 
with a write blocker so
that the drive cannot be written to; any interface may be used.
'''

tk_attach_dst = '''
<li>If not already attached, attach destination drive to the PC so
that the drive can be written to; any interface may be used. For example,
connected via a read/write bridge.
'''

tk_clone_fig = '''
<br><br>
The following figure shows a Test PC, booted into the tool test environment,
acquiring content from a write blocked source drive, writing a clone of the source
to a destination drive, and writing a tool log file (that is then copied to the
FT-LOGS log drive).
<p>
'''

tk_image_fig = '''
<br><br>
The following figure shows a Test PC, booted into the tool test environment,
acquiring content from a write blocked source drive, writing an image file to
the media-target drive, and writing a tool log file (that is then copied to the
FT-LOGS log drive).
<p>
'''

tk_analyze_fig = '''
<br><br>
The following figure shows an Analysis PC, booted from the Federated Testing CD,
comparing content between a source drive and a clone, 
and writing a tool log file to the
FT-LOGS log drive).
<p>
'''

tk_rehash_image_fig = '''
<p>
The following figure shows a Test PC, booted into the tool test environment,
computing a hash of a source drive from an image of the source drive
and writing a tool log file (that is then copied to the
FT-LOGS log drive).
</p>
'''

tk_rehash_drive_fig = '''
<p>
The following figure shows a Test PC, booted into the tool test environment,
computing a hash of a source drive
and writing a tool log file (that is then copied to the
FT-LOGS log drive).
</p>
'''

tk_restore_fig = '''
<br><br>
The following figure shows a Test PC, booted into the tool test environment,
restoring content from a media-target drive to a clone, 
and writing a tool log file (that is then copied to the
FT-LOGS log drive).
<p>
'''

##########################################################

run_di_01 = (
	tk_src+
	mk_boot ('Test','s',wb,'m',nowb)+
	tk_boot_test + 
	tk_attach_media + 
	tk_image_01 + 
	tk_image_fig +
	'<img src="graphics/tool-image.jpg">' +
	tk_run_tool + 
	tk_switch_analysis +
	tk_boot_analysis + 
	tk_doc_case
#	+ '<br>THIS is CASE: %(case)s'
	)

run_di_02 = (
	tk_select_dst +
	mk_boot ('Analysis','d',nowb,'',nowb)+
	tk_boot_analysis + 
	tk_attach_dst + 
	tk_prep_dst%{'is_part':""} + 
	tk_switch_test +
	mk_boot ('Test','d',nowb,'m',nowb)+
	tk_boot_test_nosrc + 
	tk_attach_media + 
	tk_attach_dst + 
	tk_restore_02 + 
	tk_restore_fig +
	'<img src="graphics/tool-restore.jpg">' +
	tk_run_tool + 
	tk_switch_analysis +
	mk_boot ('Analysis','s',wb,'d',wb)+
	tk_use_wb +
	tk_boot_analysis + 
	tk_analyze_fig +
	'<img src="graphics/analyze-clone.jpg">' +
	tk_cmp_device + 
	tk_doc_case
	)


run_di_03 = (
	mk_boot ('Test','s',nowb,'m',nowb)+
	tk_boot_test + 
	tk_attach_media + 
	tk_image_03 + 
	tk_image_fig +
	'<img src="graphics/tool-image.jpg">' +
	tk_run_tool + 
	tk_switch_analysis +
	tk_boot_analysis + 
	tk_doc_case
	)

run_di_04 = (
	tk_select_dst +
	mk_boot ('Analysis','d',nowb,'',nowb)+
	tk_boot_analysis + 
	tk_attach_dst + 
	tk_prep_dst%{'is_part':""} + 
	tk_switch_test +
	mk_boot ('Test','d',nowb,'m',nowb)+
	tk_boot_test_nosrc + 
	tk_attach_media + 
	tk_attach_dst + 
	tk_restore_04 + 
	tk_restore_fig +
	'<img src="graphics/tool-restore.jpg">' +
	tk_run_tool + 
	tk_switch_analysis +
	mk_boot ('Analysis','s',wb,'d',wb)+
	tk_use_wb +
	tk_boot_analysis + 
	tk_analyze_fig +
	'<img src="graphics/analyze-clone.jpg">' +
	tk_cmp_device + 
	tk_doc_case
	)

run_di_05 = (
	mk_boot ('Test','s',wb,'m',nowb)+
	tk_boot_test + 
	tk_attach_media + 
	tk_image_05 + 
	tk_image_fig +
	'<img src="graphics/tool-image.jpg">' +
	tk_run_tool + 
	tk_switch_analysis +
	tk_boot_analysis + 
	tk_doc_case
	)

run_di_06 = (
	tk_select_dst +
	mk_boot ('Analysis','d',nowb,'',nowb)+
	tk_boot_analysis + 
	tk_attach_dst + 
	tk_prep_dst%{'is_part':tk_mk_part} + 
	tk_switch_test +
	mk_boot ('Test','d',nowb,'m',nowb)+
	tk_boot_test_nosrc + 
	tk_attach_media + 
	tk_attach_dst + 
	tk_restore_06 + 
	tk_restore_fig +
	'<img src="graphics/tool-restore.jpg">' +
	tk_run_tool + 
	tk_switch_analysis +
	mk_boot ('Analysis','s',wb,'d',wb)+
	tk_use_wb +
	tk_boot_analysis + 
	tk_analyze_fig +
	'<img src="graphics/analyze-clone.jpg">' +
	tk_cmp_part + 
	tk_doc_case
	)

#run_di_06 = (
#	tk_boot_analysis + '<HR>' +
#	tk_attach_dst + '<HR>' +
#	tk_prep_dst%{'is_part':tk_mk_part} + '<HR>' +
#	tk_boot_test + '<HR>' +
#	tk_attach_media + '<HR>' +
#	tk_attach_dst + '<HR>' +
#	tk_restore_06 + '<HR>' +
#	tk_run_tool + '<HR>' +
#	tk_boot_analysis + '<HR>' +
#	tk_cmp_drive + '<HR>' +
#	tk_doc_case
#	)

run_di_07 = (
	tk_select_dst +
	mk_boot ('Analysis','d',nowb,'',nowb)+
	tk_boot_analysis + 
	tk_attach_dst + 
	tk_prep_dst%{'is_part':""} + 
	tk_switch_test +
	tk_src+
	mk_boot ('Test','s',wb,'d',nowb)+
	tk_boot_test + 
	tk_attach_dst + 
	tk_clone_drive%{'obj':'drive'} + 
	tk_clone_fig +
	'<img src="graphics/tool-clone.jpg">' +
	tk_run_tool + 
	tk_switch_analysis +
	mk_boot ('Analysis','s',wb,'d',wb)+
	tk_use_wb +
	tk_boot_analysis + 
	tk_analyze_fig +
	'<img src="graphics/analyze-clone.jpg">' +
	tk_cmp_device + 
	tk_doc_case
	)

#run_di_07 = (
#	tk_boot_analysis + '<HR>' +
#	tk_attach_dst + '<HR>' +
#	tk_prep_dst%{'is_part':""} + '<HR>' +
#	tk_boot_test + '<HR>' +
#	tk_attach_dst + '<HR>' +
#	tk_clone_drive + '<HR>' +
#	tk_run_tool + '<HR>' +
#	tk_boot_analysis + '<HR>' +
#	tk_cmp_drive + '<HR>' +
#	tk_doc_case
#	)

run_di_08 = (
	tk_select_dst +
	mk_boot ('Analysis','d',nowb,'',nowb)+
	tk_boot_analysis + 
	tk_attach_dst + 
	tk_prep_dst%{'is_part':""} + 
	tk_switch_test +
	mk_boot ('Test','s',wb,'d',nowb)+
	tk_boot_test + 
	tk_attach_dst + 
	tk_clone_drive%{'obj':'drive'} + 
	tk_clone_fig +
	'<img src="graphics/tool-clone.jpg">' +
	tk_run_tool + 
	tk_switch_analysis +
	mk_boot ('Analysis','s',wb,'d',wb)+
	tk_use_wb +
	tk_boot_analysis + 
	tk_analyze_fig +
	'<img src="graphics/analyze-clone.jpg">' +
	tk_cmp_device + 
	tk_doc_case
	)

run_di_09 = (
	tk_select_dst +
	mk_boot ('Analysis','d',nowb,'',nowb)+
	tk_boot_analysis + 
	tk_attach_dst + 
	tk_prep_dst%{'is_part':tk_mk_part} + 
	tk_switch_test +
	mk_boot ('Test','s',wb,'d',nowb)+
	tk_boot_test + 
	tk_attach_dst + 
	tk_clone_drive%{'obj':'partition'} + 
	tk_run_tool + 
	tk_switch_analysis +
	mk_boot ('Analysis','s',wb,'d',wb)+
	tk_use_wb +
	tk_boot_analysis + 
	tk_cmp_part + 
	tk_doc_case
	)

#run_di_09 = (
#	tk_boot_analysis + '<HR>' +
#	tk_attach_dst + '<HR>' +
#	tk_prep_dst%{'is_part':tk_mk_part} + '<HR>' +
#	tk_boot_test + '<HR>' +
#	tk_attach_dst + '<HR>' +
#	tk_clone_drive + '<HR>' +
#	tk_run_tool + '<HR>' +
#	tk_boot_analysis + '<HR>' +
#	tk_cmp_drive + '<HR>' +
#	tk_doc_case
#	)

#run_di_10 = run_di_01
run_di_10 = (
#	tk_src+
	mk_boot ('Test','s',wb,'m',nowb)+
	tk_boot_test + 
	tk_attach_media + 
	tk_image_01.replace('image-01-%(var)s','image-10') +
	tk_image_fig +
	'<img src="graphics/tool-image.jpg">' +
	tk_run_tool_msg.replace('OBJ','save the image file') + 
	tk_switch_analysis +
	tk_boot_analysis + 
	tk_doc_case
	)


run_di_11 = (
	tk_select_dst +
	mk_boot ('Analysis','d',nowb,'',nowb)+
	tk_boot_analysis + 
	tk_attach_dst + 
	tk_prep_dst%{'is_part':""} + 
	tk_switch_test +
	mk_boot ('Test','d',nowb,'m',nowb)+
	tk_boot_test_nosrc + 
	tk_attach_media + 
	tk_attach_dst + 
	tk_restore_02 + 
	tk_restore_fig +
	'<img src="graphics/tool-restore.jpg">' +
	tk_run_tool_msg.replace('OBJ','restore the image file') +
	tk_switch_analysis +
	mk_boot ('Analysis','s',wb,'d',wb)+
	tk_use_wb +
	tk_boot_analysis + 
	tk_analyze_fig +
	'<img src="graphics/analyze-clone.jpg">' +
	tk_cmp_device + 
	tk_doc_case
	)
run_di_11 = run_di_11.replace('Each','''
The destination drive must be smaller than the source drive from the variation of FT-DI-02 you
selected to repeat. Each''').replace('image file image-01-','''the image file 
from the variation of FT-DI-02 you have selected to repeat''')

#run_di_12 = run_di_07
run_di_12 = (
	tk_select_dst +
	mk_boot ('Analysis','d',nowb,'',nowb)+
	tk_boot_analysis + 
	tk_attach_dst + 
	tk_prep_dst%{'is_part':""} + 
	tk_switch_test +
	mk_boot ('Test','s',wb,'d',nowb)+
	tk_boot_test + 
	tk_attach_dst + 
	tk_clone_drive%{'obj':'drive'} + 
	tk_clone_fig +
	'<img src="graphics/tool-clone.jpg">' +
	tk_run_tool_msg.replace('OBJ','clone the source drive') +
	tk_switch_analysis +
	mk_boot ('Analysis','s',wb,'d',wb)+
	tk_use_wb +
	tk_boot_analysis + 
	tk_analyze_fig +
	'<img src="graphics/analyze-clone.jpg">' +
	tk_cmp_device + 
	tk_doc_case
	)
run_di_12 = run_di_12.replace('Each','''
The destination drive must be smaller than the source drive from the variation of FT-DI-07 you
selected to repeat. Each''').replace('image file image-01-','''the image file 
from the variation of FT-DI-02 you have selected to repeat''')

run_di_13 = (
	tk_rehash_image_fig +
	'<img src="graphics/tool-hash-image.jpg">' +
	mk_boot ('Test','m',nowb,'',nowb)+
	tk_boot_test_nosrc + 
	tk_attach_media + 
	tk_hash_image + 
	tk_run_tool + 
	tk_switch_analysis +
	tk_boot_analysis + 
	tk_doc_case
	)

#run_di_13 = (
#	tk_boot_test + '<HR>' +
#	tk_attach_media + '<HR>' +
#	tk_hash_image + '<HR>' +
#	tk_run_tool + '<HR>' +
#	tk_doc_case
#	)

run_di_14 = (
	tk_rehash_drive_fig +
	'<img src="graphics/tool-hash-drive.jpg">' +
	mk_boot ('Test','s',wb,'',nowb)+
	tk_boot_test + 
	tk_hash_drive + 
	tk_run_tool + 
	tk_switch_analysis +
	tk_boot_analysis + 
	tk_doc_case
	)

#run_di_14 = (
#	tk_boot_test + '<HR>' +
#	"<li> Attach source drive, but don't mount."
#	+ '<HR>' +
#	tk_hash_drive + '<HR>' +
#	tk_run_tool + '<HR>' +
#	tk_doc_case
#	)

#run_di_15 = run_di_07%{'var':""}
run_di_15 = (
	mk_boot ('Analysis','d',nowb,'',nowb)+
	tk_boot_analysis + 
	tk_select_dst +
	tk_attach_dst + 
	tk_prep_dst%{'is_part':""} + 
	tk_switch_test +
	mk_boot ('Test','e',nowb,'d',nowb)+
	tk_boot_test + 
	tk_attach_dst + 
	tk_clone_drive%{'obj':'drive'} + 
	tk_run_tool + 
	tk_switch_analysis +
	mk_boot ('Analysis','r',wb,'d',wb)+
	tk_boot_analysis + 
#	tk_cmp_drive.replace('OBJ','drive').replace('EXX',tk_xd).replace('source','reference')+
	tk_cmp_drive.replace('source OBJ','reference OBJ').replace('OBJ','drive').replace('EXX',tk_xd)+
	tk_doc_case
	)%{'var':"USB",'case':'FT-DI-15','caseupper':'FT-DI-15'}

##########################################################
if __name__ == '__main__':
	dribble = open ("/tmp/gen-run.html","w")
	dribble.write (html_head)
	dribble.write ("<h1>FT-DI-01</h1>\n")
	dribble.write (html_tail)
	print '=========  D O N E  =============='
	print dir()
	vlist = dir()
	dribble.write("<h1>Micro Procedures</h1>"+'\n')
	for var in vlist:
		print var,type(vars()[var]),type(vars()[var]) is str
		if type(vars()[var]) is str and (var[0:3] == "tk_" or var[0:3] == "eva"):
			dribble.write("<h2>"+var+"</h2>"+'\n')
			dribble.write(eval(var))
	for var in vlist:
		print var,type(vars()[var]),type(vars()[var]) is str
		if type(vars()[var]) is str and var[0:7] == "run_di_":
			dribble.write("<h2>"+var+"</h2>"+'\n')
			dribble.write("<ol>\n")
			dribble.write(eval(var))
			dribble.write("</ol>\n")
