#!/usr/bin/python
# -*- coding: utf-8 -*-
case_dict = {
"FT-DI-01":
'''Acquire a drive to an image file. Test acquisition of a given drive type.
Test the ability to read all data accurately and correctly hash the data
while creating an image file.''',
"FT-DI-02":'''Restore an image file to create a clone of the imaged drive.
Test if the image files
created in test case FT-DI-01 are complete, accurate and can be used to
create a clone of the imaged drive.''',
"FT-DI-03":'''Acquire a removable media device to an image file. 
Test acquisition of selected removable media type. ''',
"FT-DI-04":'''Restore an image file to create a clone of the imaged removable media.
Test if the image files
created in test case FT-DI-03 are complete, accurate and can be used to
create a clone of the imaged removable media.''',
"FT-DI-05":"Acquire a partition to an image file. Test acquisition of selected partition type. ",
"FT-DI-06":'''Restore a partition image file to a destination clone.
Test if the image files
created in test case FT-DI-05 are complete, accurate and can be restored to
a clone of the imaged partition.''',
"FT-DI-06":'''Restore an image file to create a clone of the imaged partition.
Test if the image files
created in test case FT-DI-05 are complete, accurate and can be used to
create a clone of the imaged partition.''',
"FT-DI-07":'''Create a clone of a drive directly
from a source drive of a given type using a given write blocker connected
to a computer over a given interface.
Test ability to create a clone during 
acquisition of given drive type with the given write blocker
connected to a computer over the given interface.''',
"FT-DI-08":'''Create a clone of removable media directly
from source media of a given type using a given media reader connected
to a computer over a given interface.
Test ability to create a clone of removable media during 
acquisition of given media type with the given media reader
connected to a computer over the given interface.''',
"FT-DI-09":"Acquire a partition to a destination clone. Test acquisition of selected partition type.",
"FT-DI-09":'''Create a clone of a partition directly
from a source partition of a given type.
Test ability to create a clone during 
acquisition of given partition type.''',
"FT-DI-10":'''Acquire a drive to an image file without enough space
for the image file. Test the ability of the tool to notify the user
that the image file is incomplete.''',
"FT-DI-11":'''Restore an image file to a destination clone without enough space.
Test the ability of the tool to notify the user that the clone is incomplete.''',
"FT-DI-12":'''Acquire a drive to a destination clone without enough space.
Test the ability of the tool to notify the user that the clone is incomplete.''',
"FT-DI-13":'''Compute the hash value of the acquired data within an image file.
Test the ability of the tool to recompute the hash of an existing image file.''',
"FT-DI-14":'''Compute the hash value of a drive (without creating an image file).
Test the ability to read all data accurately and correctly hash the data.''',
"FT-DI-15":'''Acquire a drive with faulty sectors to a destination clone.
Characterize the behavior of the imaging tool if faulty sectors are encountered.
'''}

assert_01 = '''
Acquire %(obj)s of a given type %(wb)s to an image file and compute selected hashes for
the acquired data.
Test the ability to read a given %(obj)s type accurately and correctly hash the data
while creating an image file.
'''

assert_wb = '''
using a given write blocker connected to a computer with a given interface
'''
assert_mr = '''
using a given media reader connected to a computer with a given interface
'''

case_dict ['FT-DI-01'] = assert_01%{'obj':'drive','wb':assert_wb}
case_dict ['FT-DI-03'] = assert_01%{'obj':'removable media','wb':assert_mr}
case_dict ['FT-DI-05'] = assert_01%{'obj':'partition','wb':''}


##########################################################

eval_di_01 = '''
The hash values computed by the tool should match the reference hash
values computed for the source drive.
'''
eval_di_02 = '''
The comparison of the source to the destination should have no sectors differ.
'''
eval_di_03 = eval_di_01
eval_di_04 = eval_di_02
eval_di_05 = eval_di_01
eval_di_06 = eval_di_02
eval_di_07 = eval_di_02
eval_di_08 = eval_di_02
eval_di_09 = eval_di_02
eval_di_10 = '''
The tool should issue a message indicating not enough space for the image file.
'''
eval_di_11 = '''
The tool should issue a message indicating that the destination drive is too small.
The comparison of the source to the destination should indicate that the destination
is identical to the source for the space available on the destination.
'''
eval_di_12 = eval_di_11
eval_di_13 = '''
The hash values computed by the tool should match the reference hash
values computed for the source drive.
'''
eval_di_14 = eval_di_13
eval_di_15 = '''
The results of the compare between the destination drive and the reference drive indicates
the tool behavior when a drive with a faulty sector is acquired.
'''

##########################################################

eval_map = {
 "FT-DI-01":eval_di_01,
 "FT-DI-02":eval_di_02,
 "FT-DI-03":eval_di_03,
 "FT-DI-04":eval_di_04,
 "FT-DI-05":eval_di_05,
 "FT-DI-06":eval_di_06,
 "FT-DI-07":eval_di_07,
 "FT-DI-08":eval_di_08,
 "FT-DI-09":eval_di_09,
 "FT-DI-10":eval_di_10,
 "FT-DI-11":eval_di_11,
 "FT-DI-12":eval_di_12,
 "FT-DI-13":eval_di_13,
 "FT-DI-14":eval_di_14,
 "FT-DI-15":eval_di_15}


head = """<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
  <meta content="text/html; charset=ISO-8859-1"
 http-equiv="Content-Type">
  <title>Test Assertions for Disk Imaging and Write Blocking</title>
  <meta content="J Lyle NIST/CFTT" name="author">
  <meta content="Federated Testing Disk Imaging Test Report"
 name="description">
	<style>
	em.x {color: green;font-size: 100%;font-style:italic;font-weight:bold;}
	em.p {bgcolor: green;font-size: 100%;font-weight:bold;}
	th {
	   border-collapse: collapse;
	   border: 2px solid black;
	   text-align: center;
	   } 
	table, th, td {
	   border-collapse: collapse;
	   border: 2px solid black;
	   } 
	</style>
</head>
<body>
"""
tail = """
</body>
</html>
"""
table_head = """
<table style="text-align: left;" border="2" cellpadding="2" cellspacing="2">
<tbody>
"""

table_tail = """
</tbody>
</table>
"""
if __name__ == '__main__':
	html = open('/tmp/assert.html','wt')
	html.write (head)
	html.write ('<br>Assertions & Evaluation<br>\n')
	html.write ('<h1>Descriptions</h1>\n')
	html.write (table_head)
	html.write ("<caption><b>Test Case Descriptions</caption>"+'\n')
	klist = case_dict.keys()
	klist.sort()
	for k in klist:
		print k,": ",case_dict[k]
		html.write('<tr><td>'+k+"</td><td>"+case_dict[k]+'</td></tr>\n')
	html.write (table_tail)
	html.write ('<h1>Evaluation Criteria</h1>\n')
	html.write (table_head)
	html.write ("<caption><b>Test Evaluation Criteria</caption>"+'\n')
	klist = eval_map.keys()
	klist.sort()
	for k in klist:
		print k,": ",eval_map[k]
		html.write('<tr><td>'+k+"</td><td>"+eval_map[k]+'</td></tr>\n')
	html.write (table_tail)
	html.write (tail)
