#!/usr/bin/python
# -*- coding: utf-8 -*-
############################################################

#####################################################################################
# NIST-developed software is provided by NIST as a public service. You may use, 
# copy and distribute copies of the software in any medium, provided that you 
# keep intact this entire notice. You may improve, modify and create derivative 
# works of the software or any portion of the software, and you may copy and 
# distribute such modifications or works. Modified works should carry a notice 
# stating that you changed the software and should note the date and nature of 
# any such change. Please explicitly acknowledge the National Institute of 
# Standards and Technology as the source of the software.
# 
# NIST-developed software is expressly provided “AS IS.” NIST MAKES NO WARRANTY 
# OF ANY KIND, EXPRESS, IMPLIED, IN FACT OR ARISING BY OPERATION OF LAW, 
# INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT AND DATA ACCURACY. NIST NEITHER 
# REPRESENTS NOR WARRANTS THAT THE OPERATION OF THE SOFTWARE WILL BE 
# UNINTERRUPTED OR ERROR-FREE, OR THAT ANY DEFECTS WILL BE CORRECTED. NIST DOES 
# NOT WARRANT OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF THE SOFTWARE OR 
# THE RESULTS THEREOF, INCLUDING BUT NOT LIMITED TO THE CORRECTNESS, ACCURACY, 
# RELIABILITY, OR USEFULNESS OF THE SOFTWARE.
# 
# You are solely responsible for determining the appropriateness of using and 
# distributing the software and you assume all risks associated with its use, 
# including but not limited to the risks and costs of program errors, compliance 
# with applicable laws, damage to or loss of data, programs or equipment, and the 
# unavailability or interruption of operation. This software is not intended to 
# be used in any situation where a failure could cause risk of injury or damage 
# to property. The software developed by NIST employees is not subject to 
# copyright protection within the United States.
#####################################################################################

############################################################
common_procs = '''
<h1>Common Tasks</h1>
This section provides detailed instructions for some common tasks.<br><br>
<h2><a name = common_mount>Mounting a partition</a></h2>
<ol>
<li>Open a terminal window
<li>Become the root user, type <tt>sudo su</tt>
<li>Manually calibrate the system clock on the PC
<li>Attach device that contains the partition
<li>Determine the device name for the attached drive: <tt>fdisk -lu</tt>
<p>Look for a device with a matching size to the attached drive
<li>Mount the log thumb: <tt>mount /dev/sdxn /mnt</tt>
</ol>
<p>Replace /dev/sdxn with the device name of the partition you want to mount
<br><br><h2><a name = common_tool_session>Sample Tool Session</a></h2>
Here is a sample tool session to wipe a source drive:
<pre>

[jimmy@Stilton federated-testing]$ cftt-di.py 

Tool should be run as root, not as user jimmy

Running in TEST MODE <<<<<<<<<<<<<============

Welcome to the CFTT Disk Imaging Test Analysis Tool

Tool: @(#) ft_di_common.py Version 1.4 created 04/26/18 at 10:11:18
OS: Linux Version 2.6.32.26-175.fc12.i686

What do you want to do?
			Setup a source drive
	1	Setup source (wipe step)
	2	Setup source (hash step)
			Analyze a test run
	3	Setup destination for test case (wipe step)
	4	Verify source unchanged after test tool execution (rehash)
	5	Compare source to destination after test tool execution
	6	Record case information
	0	Quit
1
Who are you?
JRL
Which computer are you using?
Stilton
What is the path to the log file directory?
/tmp/mytool

Please verify this information:

You are JRL 
using Stilton
You want to run Initial source drive setup (wipe and fill)
The path to the log directory is /tmp/mytool

Is this correct?
yes

/tmp/mytool does not exist. Create? yes

Drive id is a string in the form: XX or XX-string
Where, XX is a two-digit hexadecimal value: 00-FF
What is the drive id?
A1-lab-203

Select the device to operate on:
a /tmp/sda 43040
b /tmp/sdb 43040
c /tmp/sdc 128000
d /tmp/sdd 63424
b

/tmp/mytool/setup/a1-lab-203 does not exist. Create? yes

Wipe device /tmp/sdb with a1-lab-203
Go ahead?
yes

Starting wipe

Start time: Thu Aug 22 14:28:05 2013

wipe 43040 sectors of a1-lab-203 on /tmp/sdb with A1
at 431 of 43040 (1%) Thu Aug 22 14:28:05 2013
at 861 of 43040 (2%) Thu Aug 22 14:28:05 2013
at 1292 of 43040 (3%) Thu Aug 22 14:28:05 2013
at 1722 of 43040 (4%) Thu Aug 22 14:28:06 2013
at 2152 of 43040 (5%) Thu Aug 22 14:28:06 2013
at 2583 of 43040 (6%) Thu Aug 22 14:28:06 2013
at 3013 of 43040 (7%) Thu Aug 22 14:28:06 2013
at 3444 of 43040 (8%) Thu Aug 22 14:28:06 2013
at 3874 of 43040 (9%) Thu Aug 22 14:28:06 2013
at 4304 of 43040 (10%) Thu Aug 22 14:28:06 2013
at 8608 of 43040 (20%) Thu Aug 22 14:28:06 2013
at 12912 of 43040 (30%) Thu Aug 22 14:28:06 2013
at 17216 of 43040 (40%) Thu Aug 22 14:28:06 2013
at 21520 of 43040 (50%) Thu Aug 22 14:28:06 2013
at 25824 of 43040 (60%) Thu Aug 22 14:28:06 2013
at 30128 of 43040 (70%) Thu Aug 22 14:28:06 2013
at 34432 of 43040 (80%) Thu Aug 22 14:28:06 2013
at 38736 of 43040 (90%) Thu Aug 22 14:28:06 2013
Wipe 43040 sectors of a1-lab-203 on /tmp/sdb with A1 complete
Wipe Finished
Finish time: Thu Aug 22 14:28:07 2013
Elapsed time: 0:00:01.157067

[jimmy@Stilton federated-testing]$ 
</pre>
<br><br><h2><a name = common_fdisk>Using fdisk </a></h2>
<p>This section explains how to use fdisk to determine the size in sectors of a device
and the device name of a particular device or device partition.</p> <p>Some things to
keep in mind:</p>
<ul>
<li>You must be root to run fdisk.
<li>Always run fdisk with the -lu options: '<strong><tt>fdisk -lu</tt></strong>'
<li>The command lists all attached devices: <tt>/dev/sdx</tt> where x is uniquely
assigned to each drive as it is attached.
<li>The command also lists all partitions present on an attached drive: <tt>/dev/sdxn</tt>
where n is uniquely assigned to each partition on a drive.
</ul>
A sample fdisk output follows:
<pre>

output of fdisk -lu

     1	Disk /dev/sda: 250.0 GB, 250000000000 bytes
     2	255 heads, 63 sectors/track, 30394 cylinders, total 488281250 sectors
     3	Units = sectors of 1 * 512 = 512 bytes
     4	Disk identifier: 0x0008df7e
     5	
     6	   Device Boot      Start         End      Blocks   Id  System
     7	/dev/sda1   *          63      409662      204800   83  Linux
     8	/dev/sda2          409663   488279609   243934973+  8e  Linux LVM
     9	
    10	Disk /dev/sdb: 505 MB, 505413632 bytes
    11	16 heads, 61 sectors/track, 1011 cylinders, total 987136 sectors
    12	Units = sectors of 1 * 512 = 512 bytes
    13	Disk identifier: 0xbbbbbbbb
    14	
    15	Disk /dev/sdc: 505 MB, 505413632 bytes
    16	16 heads, 61 sectors/track, 1011 cylinders, total 987136 sectors
    17	Units = sectors of 1 * 512 = 512 bytes
    18	Disk identifier: 0xbbbbbbbb
</pre>
<br>
<ul>
<li>Three devices are listed on lines 1, 10 and 15.</li>
<li>Device sizes are listed on lines 2, 11 and 16.</li>
<li>Device /dev/sda has two partitions reported on lines 7 and 8</li>
</ul>
<br>
<h2><a name = common_df>Using df </a></h2>
<p>This section explains how to use df command to determine the mounted devices.</p>
<p>Some things to keep in mind:</p>
<ul>
<li>You don't have to be root.
</ul>
<pre>
     1	Filesystem           1K-blocks      Used Available Use% Mounted on
     2	/dev/mapper/vg_stilton-lv_root
     3	                     234734432 147379276  84970876  64% /
     4	tmpfs                  1673328       420   1672908   1% /dev/shm
     5	/dev/sda1               198337     54854    133243  30% /boot
     6	/dev/sdd1              7545436     71968   7473468   1% /media/LOG-3
</pre>
'''
calibrate_clock = '''
<h2> Calibrate System Clock </h2>
<p>
The system clock should be set to the correct time. The clock can be reset from
either the command line or from the desktop interface.
<p> Determine standard time from a reliable source, e.g., visit the NIST
time page from another computer connected to the internet: http://nist.time.gov/
<p> If system time is not close enough to standard time, reset the system time.
<h3>Command line interface</h3>
<ol>
<li> Open a terminal window
<li> Determine system time by typing: <tt>date</tt>
<li> If system time is not close enough to standard time, reset system time by typing: <tt>date mmddHHMM</tt>
<li> For example, to set to December 13 at 2:15PM type: <tt>date 12131415</tt>
</ol>
<h3>Desktop interface</h3>
<ol>
<li>THERE IS A KNOWN BUG IN UBUNTU LINUX (the run environment for the NIST Boot CD) 
and the time/date may not update. SEE Workaround Below.
<li>Click on the time displayed in the title bar on the top right corner of the screen.
<li>A calender should display. Click on "Time & Date Settings..."
<li>Click the "Set the time: Manually" radio button
<li>Adjust Time and Date as needed
<li>WORKAROUND: If the date/time does not immediately propogate to the title bar
do the following:
<ol>
<li>Adjust the time with the +/- buttons
<li>Click on the Clock tab
<li>Toggle the seconds on and off
<li>Verify that the clock updated
<li>Now adjust the date with the +/- buttons
<li>Click on the Clock tab
<li>Toggle the seconds on and off
<li>Verify that the date updated
</ol>
<li>Close window
</ol>
'''
format_log = '''
<h2> Format Case Log Flash Drive </h2>

<ol>
<li>Insert the removable drive that you’re going to be using to keep test logs for this tool. 
On the left-hand side of the screen you should see a toolbar.
<li> Find the disk utility program. 
 The disk utility program looks like a hard drive with a crescent wrench on it.
<li> Click on the disk utility icon.
<li> Format drive presents a pop-up window to select the type of partition
table for the device.
<li>select Master Boot Record so
that the drive can be recognized by most operating systems.
<li> Click format and then confirm that you are sure you want to format.
<li> To create a partition, select the type of partition. 
<li> Select "FAT"
<li> Set the partition name to be FT–LOGS.
Federated testing tools expect this
name for the log files. This way the tools can find the log files without
the user having to type in a path.
The partition label has space to have four more characters.
You can use them to make the flash drive unique if you are using more than one log drive.
</ol>
<p> We are finished setting up a device to record test run logs. 
'''
view_dev = '''
<h2> View Attached & Mounted Devices </h2>
<p>The currently attached devices. If a partition is mounted, the mount point is listed.
<p>
'''
mount_fs = '''
<h2> Mount a Partition (File System) </h2>
<p>
Identify the file system icon for the file system/partition you want to mount.
For each file system of an
attached device there is an icon in the tool bar on the right edge of the screen.
Just click on the file system icon in the tool bar to mount the file system. 
<p>
You can unmount the file system by right clicking on the icon and select "Safely remove".
'''

create_partition = '''
<h2> Create a Partition </h2>
<p>The details of creating a partition are different depending on the partition type.
Specific platforms are required for each type.
<p>
<table width="30%" border="1" cellpadding="2" cellspacing="2">
<tbody>
<tr>
<th valign="top" align="center"><b>Type</b><b><br>
</b></th>
<th valign="top" align="center"><b>Preferred Environment (or Alternate) </b><b><br>
</b></th>
</tr>
<tr> <td valign="top">FAT<br> </td> <td valign="top">Any </td> </tr>
<tr> <td valign="top">NTFS<br> </td> <td valign="top">Windows or Linux<br> </td> </tr>
<tr> <td valign="top">ExFAT<br> </td> <td valign="top">Windows or Mac OS X<br> </td> </tr>
<tr> <td valign="top">ext<br> </td> <td valign="top">Linux<br> </td> </tr>
<tr> <td valign="top">HFS+<br> </td> <td valign="top">Mac OS X<br> </td> </tr>
</tbody>
</table>
<p>If you need any of ext, FAT or NTFS partitions, you can use a Linux host to create the partition.
If you need HSF+ or ExFAT, you should use a Mac with OS X (for HSF+ or ExFAT) or Microsoft WIndows (For ExFAT).
<h3>Creating a partition on a Linux host.</h3>
<ol>
<li>On a Linux host you can format several types of file systems these include: EXT, FAT and in NTFS. 
<li>Look at the menu bar on the left side of the screen.
You should click on the icon that looks like a disk drive with a crescent wrench.
This opens the disk utility program.
<li>Move the mouse to the top bar of the window and click on the little box icon
to expand the window to full screen.
<li>Attach the drive you want to format.
<li>Select the drive you want to format.
<li>Select “Format Drive”. You will see a menu of several possible drive formats.
You should select either Master Boot Record format or GUID format. If you have more than
one test case imaging partitions you should use each format at least once.
<li>Select “Create Partition”
<li>Select the type of file system you need for this test.
<li>Name of the file system something like FAT-TEST for fat file system or NTFS–Test for NTFS file systems.
This way you know the file system type from the file system name.
<li>Wait for the format operation to finish.
<li>File system is now formatted and ready to use. 

</ol>
<br>
<h3>Creating a partition on a Mac OSX host.</h3>
<p>Creating a partition on a device can be done with the <strong>Disk Utility</strong> program.
The exact procedure may vary depending on your version OSX.
<h3>Creating a partition on a Microsoft Windows host.</h3>
<p>Creating a partition on a device can be done from the <em>Computer Management</em> screen.
The exact procedure may vary depending on your version Microsoft Windows (XP, Vista, 7, 8, etc.).
'''
sample_session = '''
<h2> Sample CFTT-DI session </h2>
<p>The following is a transcript from a run of cftt-di to load known content 
to a test drive. The test drive will be used as a source drive for testing disk imaging, i.e., a drive
that the imaging tool will acquire to an image file or clone. Setting up a drive is a two step process, first 
load known content and then compute hashes of the drive content. This transcript covers just
the first step of loading known content.
<table width="80%" border="1" cellpadding="2" cellspacing="2">
<tbody>
<tr>
<th colspan="2" align="center"><b>Notes on Transcript</b></th>
</tr>
<tr>
<th valign="top" align="center"><b>Lines</b><b></th>
<th valign="top" align="center"><b>Comments</b><b></th>
</tr>
<tr> <td valign="top">2<br> </td> <td valign="top">
Run cftt-di from the command line</td> </tr>
<tr> <td valign="top">10-11<br> </td> <td valign="top">
<p>Versions for cftt-di & Ubuntu</td> </tr>
<tr> <td valign="top">22-37<br> </td> <td valign="top">
<p>The first time you run cftt-di you need to identify yourself,
the computer used to run the NIST CD (analysis PC)
and the computer used to run the tool you want to test
(test PC).
<p>This is stored on the FT-LOGS flash drive. If you make
a change, then you need to update this information in the profile.
</td> </tr>
<tr> <td valign="top">43-61<br> </td> <td valign="top">
<p>List of tasks that you can select from:
<p>Setup a source drive with known content or hash the contents
<p>Setup a destination drive (for a clone or restore), 
analyze a test run or document a test case
<p>Other tasks: hash part of a drive or change profile
</td> </tr>
<tr> <td valign="top">63-114<br> </td> <td valign="top">
<p>Loading known content to a source drive
</td> </tr>
<tr> <td valign="top">66-70<br> </td> <td valign="top">
<p>Pick a name for your drive. We picked A1 because it is the first
source drive we are setting up.
</td> </tr>
<tr> <td valign="top">72-78<br> </td> <td valign="top">
<p>We have to identify the actual physical device where A1 is located. 
Be careful here. The selected device is completely overwritten
with our known content. Be dubious of /dev/sda, this is likely
to contain content you want to keep (like an operating system).

</td> </tr>
<tr> <td valign="top">73-77<br> </td> <td valign="top">
<p>This is a table of devices, i.e., hard drives and flash drives
that cftt-di can see. If the FT-LOGS flash drive is mounted,
it will not be listed; if it is attached, but not mounted then
it will be listed. If so you do not want to select it (and overwrite
any content).
</td> </tr>
<tr> <td valign="top">82-85<br> </td> <td valign="top">
<p>We call loading known content "wiping" sometimes
</td> </tr>
<tr> <td valign="top">89-112<br> </td> <td valign="top">
<p>We give feedback as the process continues. Initially every 1% and after 
reaching 10%, every 10% thereafter.
</td> </tr>
</tbody>
</table>
	 <pre>
     1
     2	root@ubuntu:/home/ubuntu# cftt-di
     3	
     4	Using "fast C program mode," beware this sometimes fails to be able to access drives
     5	If there is a problem recognizing drives, run as "cftt-di.py alt"
     6	The "alt" mode is more robust, but a lot slower.
     7	
     8	Welcome to the CFTT Disk Imaging Test Analysis Tool
     9	
    10	Tool: @(#) cftt-di Version 1.11 created 05/14/15 at 08:40:28
    11	OS: Linux Version 3.2.0-51-generic
    12	
    13	
    14	For yes/no questions:
    15		type "yes" or "y" to go ahead
    16		type "no" or "return/enter" cancel the operation
    17	You can type "quit" or "q" at any input prompt to exit this program
    18	
    19	Log file path: /media/cftt/FT-LOGS
    20	
    21	
    22	You need to set a profile (who are you, your analysis computer and your imaging tool computer).
    23	Type your name or initials (the person running the test case): Jim
    24	 
    25	Type the name of the computer you are using to run the NIST CD
    26	(no spaces or special characters in the name): xena
    27	 
    28	Type the name of the computer you are using to run the tool you are testing
    29	(no spaces or special characters in the name): bastet
    30	 
    31	Please verify this information:
    32	
    33	You are JIM 
    34	You are using Xena to run the CD
    35	You are using Bastet to run the forensic tool
    36	
    37	Is this correct: y
    38	
    39	
    40	Current profile -- User: JIM, Analysis Host Computer: Xena, Test Host Computer: Bastet
    41	
    42	
    43	What do you want to do? Type the code number for the operation you want or "quit": 
    44	
    45	
    46				Setup a source drive
    47		1	Write known content (based on two digit hex value in drive label)
    48		2	Compute reference hash values
    49	
    50				Analyze a test run
    51		3	Wipe destination drive with known content
    52		4	Verify source unchanged after test tool execution (rehash)
    53		5	Compare source to destination after test tool execution
    54		6	Record case information
    55	
    56				Other operations and tasks
    57		7	Compute hash values for part of a drive or partition
    58		8	Change profile (user & host)
    59		quit	Quit
    60	Enter Choice: 1
    61	
    62	
    63	Set up log at:  /media/cftt/FT-LOGS
    64	Source Drives Setup so Far:
    65	
    66	Each test drive needs to be assigned a unique drive id.
    67	SOURCE drives should be assigned A1, A2, A3 and so forth.
    68	DESTINATION drives should be assigned D1, D2, D3 and so forth.
    69	
    70	Type the drive id assigned to this source drive: a1
    71	
    72	Select the device to operate on (type the code to the left of the device name):
    73	a /dev/sda 8,388,608 (4.29 GB, 4.00 GiB)
    74	b /dev/sdb 10,485,760 (5.37 GB, 5.00 GiB)
    75	c /dev/sdc 10,485,760 (5.37 GB, 5.00 GiB)
    76	d /dev/sdd 11,534,336 (5.91 GB, 5.50 GiB)
    77	e /dev/sde 2,097,152 (1.07 GB, 1.00 GiB)
    78	Enter code to the left of device name: b
    79	
    80	/media/cftt/FT-LOGS/setup/a1 does not exist. Type 'yes' to create the log directory: yes
    81	
    82	Wipe device /dev/sdb with a1
    83	Go ahead (yes): y
    84	
    85	Starting wipe
    86	
    87	Start time: Tue Jul  7 19:09:38 2015
    88	
    89	Feedback every 104857/1048576 sectors (10%) of 10485760
    90	at 104857 of 10485760   1.0%    0:06:36 remains on Tue Jul  7 19:09:42 2015
    91	at 209714 of 10485760   2.0%    0:05:43 remains on Tue Jul  7 19:09:45 2015
    92	at 314571 of 10485760   3.0%    0:06:28 remains on Tue Jul  7 19:09:50 2015
    93	at 419428 of 10485760   4.0%    0:05:12 remains on Tue Jul  7 19:09:51 2015
    94	at 524285 of 10485760   5.0%    0:04:26 remains on Tue Jul  7 19:09:52 2015
    95	at 629142 of 10485760   6.0%    0:04:10 remains on Tue Jul  7 19:09:54 2015
    96	at 733999 of 10485760   7.0%    0:03:45 remains on Tue Jul  7 19:09:55 2015
    97	at 838856 of 10485760   8.0%    0:03:27 remains on Tue Jul  7 19:09:56 2015
    98	at 943713 of 10485760   9.0%    0:03:22 remains on Tue Jul  7 19:09:58 2015
    99	at 1048570 of 10485760  10.0%    0:03:18 remains on Tue Jul  7 19:10:00 2015
   100	at 1048576 of 10485760  10.0%    0:03:18 remains on Tue Jul  7 19:10:00 2015
   101	at 2097152 of 10485760  20.0%    0:02:56 remains on Tue Jul  7 19:10:22 2015
   102	at 3145728 of 10485760  30.0%    0:02:34 remains on Tue Jul  7 19:10:44 2015
   103	at 4194304 of 10485760  40.0%    0:02:12 remains on Tue Jul  7 19:11:06 2015
   104	at 5242880 of 10485760  50.0%    0:01:40 remains on Tue Jul  7 19:11:18 2015
   105	at 6291456 of 10485760  60.0%    0:01:30 remains on Tue Jul  7 19:11:54 2015
   106	at 7340032 of 10485760  70.0%    0:01:06 remains on Tue Jul  7 19:12:12 2015
   107	at 8388608 of 10485760  80.0%    0:00:45 remains on Tue Jul  7 19:12:38 2015
   108	at 9437184 of 10485760  90.0%    0:00:21 remains on Tue Jul  7 19:12:49 2015
   109	at 10485760 of 10485760 100.0%    0:00:00 remains on Tue Jul  7 19:13:20 2015
   110	Wipe Finished
   111	Finish time: Tue Jul  7 19:13:20 2015
   112	Elapsed time: 0:03:41.558290
   113	
   114	root@ubuntu:/home/ubuntu#
   </pre>
'''


