#!/usr/bin/python

import datetime
now = datetime.datetime.now()
import cgi
import sys
import sap_di
from ft_di_common import *

fs_dict = {
"media_sd" : "SD",
"media_cf" : "CF",
"p_fat16" : "FAT16",
"p_fat32" : "FAT32",
"p_exfat" : "ExFAT",
"p_ext2" : "Ext2",
"p_ext3" : "Ext3",
"p_ext4" : "Ext4",
"p_ntfs" : "NTFS",
"p_osx" : "OSX",
"p_osxj" : "OSXJ",
"p_osxc" : "OSXC",
"p_osxjc" : "OSXJC"
}


i_dict = {
"if_ata" : "ATA",
"if_ata28" : "ATA28",
"if_ata48" : "ATA48",
"if_sata" : "SATA",
"if_sata28" : "SATA28",
"if_sata48" : "SATA48",
"if_scsi" : "SCSI",
"if_usb" : "USB",
"if_fw" : "FW"
}


def x_set_list (form,xkey):
	if not form.has_key(xkey):
		ops_list = []
#		print "<P>No values for %s<P>"%(xkey)
	else:
		ops_items = form.getvalue(xkey)
#		print "<P>%s values:"%(xkey),ops_items,"<P>"
		if type(ops_items).__name__ == 'list' :
			ops_list = ops_items
		else:
			ops_list = [ ops_items ]
	return ops_list


tmp = False
if tmp: dribble = open ("/tmp/dribble.html","w")
form = {}
form = cgi.FieldStorage()
#form = {}
# Required header that tells the browser how to render the text.
print "Content-Type: text/html\n\n"
if not form.has_key('toolname'):
	x = 'No tool Specified'
else:
	x = form.getvalue('toolname')
if not form.has_key('toolversion'):
	xv = 'No tool version Specified'
else:
	xv = form.getvalue('toolversion')
print "<html>"
print "<TITLE>Test Plan: %s V %s</TITLE>" % (x,xv)
print "<body><H1>Test Plan for disk imaging tool %s version %s</H1>" % (x,xv)
print "<P>Federated Testing<P>Disk Imaging Tool: "
print x,xv
#dribble.write(x+" "+xv+"\n")
#print "<p>Done: %s" % now.strftime("%A, %B %d, %Y at %H:%M")
#print "</body>"
#print "</html>"
#exit(0)
if tmp:
	dribble.write("<html>"+'\n')
	dribble.write("<TITLE>Test Plan: %s V %s</TITLE>" % (x,xv)+'\n')
	dribble.write("<body><H1>Test Plan for disk imaging tool %s version %s</H1>" % (x,xv)+'\n')
	dribble.write("<P>Federated Testing<P>Disk Imaging Tool: "+'\n')
#	dribble.write(x+xv+'\n')
	dribble.write(x+" "+xv+"\n")
	dribble.write("<p>Done: %s" % now.strftime("%A, %B %d, %Y at %H:%M")+'\n')
	dribble.write("</body>"+'\n')
	dribble.write("</html>"+'\n')
#exit(0)
print "<p>"
print_trace = False
if print_trace:
	print "Form Keys <br>"
	print form.keys()
	print "<br>"
	print "Start Trace <br>"
	for dongxi in form:
		print dongxi,form[dongxi],form.getvalue(dongxi)
		print "<br>"
	print "End Trace <br>"
print "<p>"
case_list = []
if not form.has_key('interface'):
	print "<p>No Interfaces selected"
	i_list = []
	x_list = []
else:
	inter = form.getvalue('interface')
	if type(inter).__name__ == 'list' :
		i_list = inter
	else:
		i_list = [ inter ]
	x_list = []
	for interface in i_list:
		if interface == 'if_ata':
			x_list.append('if_ata28')
			x_list.append('if_ata48')
		elif interface == 'if_sata':
			x_list.append('if_sata28')
			x_list.append('if_sata48')
		else:
			x_list.append(interface)


if not form.has_key('ops'):
	ops_list = []
else:
	ops_items = form.getvalue('ops')
	if type(ops_items).__name__ == 'list' :
		ops_list = ops_items
	else:
		ops_list = [ ops_items ]

	print "<h3>Interfaces to test:</h3>"
	print "<P>"
#	print "ops_items:",ops_items
#	print "ops_list:",ops_list
	print "<P>"
	print "<ul>"
	for interface in x_list:
		print "<li>%s" % (i_dict[interface])
		if 'ops_image' in ops_list:
			case_list.append('FT-DI-01-%s'%(i_dict[interface]))
		if 'ops_restore' in ops_list:
			case_list.append('FT-DI-02-%s'%(i_dict[interface]))
		if 'ops_clone' in ops_list:
			case_list.append('FT-DI-07-%s'%(i_dict[interface]))
	print "</ul>"
err_list = x_set_list(form,'err')
rm_list = x_set_list(form,'media')
rm_ops = x_set_list(form,'ops_rem')
part_list = x_set_list(form,'partition')
part_ops = x_set_list(form,'ops_par')
for p in part_list:
	if 'ops_par_image' in part_ops:
		case_list.append('FT-DI-05-%s'%(fs_dict[p]))
	if 'ops_par_restore' in part_ops:
		case_list.append('FT-DI-06-%s'%(fs_dict[p]))
	if 'ops_par_clone' in part_ops:
		case_list.append('FT-DI-09-%s'%(fs_dict[p]))
#print "<P>Case list:",case_list,"<P>"
#print "<P>rm list:",rm_list,"<P>"
#print "<P>rm ops:",rm_ops,"<P>"
for m in rm_list:
#	print "<P>media:",m,m in fs_dict,fs_dict[m],"<P>"
	if 'ops_rem_image' in rm_ops:
		case_list.append('FT-DI-03-%s'%(fs_dict[m]))
	if 'ops_rem_restore' in rm_ops:
		case_list.append('FT-DI-04-%s'%(fs_dict[m]))
	if 'ops_rem_clone' in rm_ops:
		case_list.append('FT-DI-08-%s'%(fs_dict[m]))
if form.getvalue('hash_image') == 'Yes':
	case_list.append('FT-DI-13')
if form.getvalue('hash_device') == 'Yes':
	case_list.append('FT-DI-14')
if form.getvalue('bad_sector') == 'Yes':
	case_list.append('FT-DI-15')
#print "<P>Final Case list:",case_list,"<P>"
if 'err_clone' in err_list:
	case_list.append('FT-DI-12')
if 'err_restore' in err_list:
	case_list.append('FT-DI-11')
if 'err_image' in err_list:
	case_list.append('FT-DI-10')
case_list.sort()
#print "<P>Sorted Case list:",case_list,"<P>"

print "<h3> Test Cases:</h3>"


c_list = []

#
# Check for meaningless choices
#	Requesting to ERASE on an interface that does not support ERASE, E.g., USB or FireWire
#	Requesting HPA/DCO operation on non-ATA interfaces
#
if case_list == []:
	print "<p>Warning: No test cases generated"
	print "<p>Done: %s" % now.strftime("%A, %B %d, %Y at %H:%M")
	print "</body>"
	print "</html>"
	exit(0)

print '<table border=1 cellpadding=10>'
for testcase in case_list:
	print '<tr>'
	print '<td>%s</td>' % testcase
	print '<td><a href="#%s"> %s</a></td>' % (testcase,'Test Drive Setup')
	print '<td><a href="#%s_procedures"> %s</a></td>' % (testcase,'Test Procedures')
	print '<td><a href="#%s_eval"> %s</a></td>' % (testcase,'Test Evaluation')
	print '</tr>'
print '</table>'
print '<p> <a href="#test_report"> Test Report Template</a>'
print '<HR>'
for testcase in case_list:
#	print "<P>Wrap up",testcase
	print '<HR>'
# debug
	sap_di.wrap_case(testcase,False,False)
	print '<HR>'
print "<P>"

print "<br><br><br><br><br><br><br><br><br><br><br><br>"
#print "<br><br><br><br><br><br><br><br><br><br><br><br>"
#print "<br><br><br><br><br><br><br><br><br><br><br><br>"
#print "<br><br><br><br><br><br><br><br><br><br><br><br>"
#print "<br><br><br><br><br><br><br><br><br><br><br><br>"

########################################################
#
# output test report template
#
print '<HR>'
print common_procs
print '<HR>'
sap_di.report_header(x,xv)
for testcase in case_list:
#	print "Report on",testcase
	sap_di.case_report(testcase,False,False)
print '<HR>'






print "<br><br><br><br><br><br><br><br><br><br><br><br>"
print "<br><br><br><br><br><br><br><br><br><br><br><br>"
print "<br><br><br><br><br><br><br><br><br><br><br><br>"
print "<br><br><br><br><br><br><br><br><br><br><br><br>"
print "<br><br><br><br><br><br><br><br><br><br><br><br>"

#print "<p>@(#) gen-fmp.py Version 1.2 UPDATED 03/23/10 15:12:53"
#sap_fmp.print_version()
print "<p>Done: %s" % now.strftime("%A, %B %d, %Y at %H:%M")
print "</body>"
print "</html>"
