<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>CFTT Federated Testing CD - test a Mobile Device tool</title>
<link rel="stylesheet" type="text/css" href="../css/reset.css" media="screen" />
<link rel="stylesheet" type="text/css" href="../css/main_style.css" media="screen" />
<link rel="stylesheet" type="text/css" href="../css/layout.css" media="screen" />
<style>
	table, th, td {
	   border-collapse: collapse;
	   border: 1px solid black;
	   } 
	tr {
	   border-collapse: collapse;
	   border: 2px solid black;
	   } 
</style>
</head>
<body id="menu1">
	<div id="mainWrapper">
		<div id="topBannerContainer">
			<div id="logoContainer">
  				<img src="../images/banner.png" alt="CFTT Federated Testing - NIST">
			</div>
            <!-- Menu Starts-->
			<div id="menuContainer">
                          <?php
                                include '../include/global.php';
                                print_main_horizontal_menu_contents();
                          ?>
    		</div>
            <!-- Menu Ends-->
		</div>
		<!-- TopBanner Ends-->
	  
		<!-- Main Content Starts-->	
		<div id="subContentContainer">
		  <div id="leftContent">
		    <div id="leftLinks">
<div>
<?php
include '../include/mdt-global.php';
?>
		    </div>
		    </div>
		  </div>			
		  <div id="rightContent">
			<div id="breadcrumb"><a href="../Federated_Testing_Home_Page.php" class="nav">Home</a> &gt; <a href="/mobiledevice/mdt.php" class="nav"> Mobile Device Testing Home</a> &gt; Recording Device Test Results</div>

<?php
	
$continue = 1;

// is_ftlogs_mounted() returns the path to where we should store log files (e.g.,  
// /tmp or /media/FT-LOGS). It also checks if the user has mounted their log drive.
// is_ftlogs_mounted() will return 0/false and print an error message if the 
// user's log drive is not mounted
$root = is_ftlogs_mounted(FALSE);

if (!$root) { 
	// if the user's log drive isn't mounted, don't continue
	$continue = 0;
}
	
// if the user's log drive isn't mounted, don't continue
if ($continue){
			  
	echo '<h1 style="font-size:1.8em">Recording Device Test Results (2 of 3)</h1>';
	echo '<h2 style="font-size:1.7em; color:#008000">Documenting Device Test Results</h2>';

	extract($_POST);
	// check, did the user select a device to update?
	if (isset($selected_device)){

		$have_phones = FALSE;
		$dname = sprintf ("%s/devices.txt",$root);
		if (file_exists($dname)){
			$dfile = fopen($dname,"r");
			//echo "<br>open<br>";
			$p_line = fgets($dfile);
			while (!feof($dfile)){
				//$the_phones [] = $p_line;
				$pxp = explode(';',$p_line);
				$p_sim [$pxp[0]] = trim($pxp[7]);
				// if the current device is the selected device, get its make and model
				if ($pxp[0] == $selected_device){
					$manufacturer = $pxp[1];
					$model = $pxp[2];
				}
				$p_line = fgets($dfile);
				$have_phones = TRUE;
			}
			fclose($dfile);
		}

//		echo '<!------------------------------------------------------------- -->';
//		echo '<div style="padding: 0em 1em .25em .5em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">';
		//echo 'You can use this page first to document results of acquiring a device and optionally record results of a SIM/UICC card acquisition with the tool you are testing.';

		$setup_page_overview1 = <<<XXX
		Use this page to document the results of acquiring the selected test device. For the selected device, for each entry in the '<i>Documenting Device Test Results</i>' 
XXX;
		// does this phone have a sim?
		if ($p_sim[$selected_device] == 'sim'){
			$setup_page_overview2 = "and '<i>Documenting SIM/UICC Test Results</i>' tables";	
		} else { // no sim (1 table, not 2)
			$setup_page_overview2 = "table";	
		}
		
		//$setup_page_overview3 = <<<XXX
//		 select 'As Expected', 'Partial', 'Not as Expected' or 'N/A.' You may enter testing notes in the text box provided for each entry and/or in the '<a href="#comments-and-observations"><i>General Comments and Observations</i></a>' box at the bottom of this page. Click the '<i>Update Results for Selected Device</i>' button to continue.
//XXX;
		$setup_page_overview3 = <<<XXX
		 select 'As Expected', 'Partial', 'Not as Expected' or 'N/A.' You may enter testing notes in the text box provided for each entry and/or in the '<a href="#comments-and-observations"><i>General Comments and Observations</i></a>' box at the bottom of this page. Once you're finished, click the '<i>Update Results for Selected Device</i>' button to save the results to your log drive.
XXX;
		
		$setup_page_overview = $setup_page_overview1.$setup_page_overview2.$setup_page_overview3;

		printf ("<p>%s</p>",$setup_page_overview);

		echo '<p><b>Selected Device:</b><br>';
		echo 'Manufacturer: <i>'.$manufacturer.'</i><br>';
		echo 'Model: <i>'.$model.'</i></p>';
		
		echo '<p><i>Results Key</i></p>'; 
		echo '<table class="bordered_table" style="position:relative;top:-13px;">';
		echo '<tr><th style="width:14%"><b>Result</b></th><th><b>Definition</b></th></tr>';
		echo '<tr><td><i>As Expected</i></td><td>The mobile forensic application returned expected test results – the tool acquired and reported data from the mobile device or SIM/UICC successfully.</td></tr>';
		echo '<tr><td class="alternate-header"><i>Partial</i></td><td class="alternate-header">The mobile forensic application returned some of data from the mobile device or SIM/UICC.</td></tr>';
		echo '<tr><td><i>Not as Expected</i></td><td>The mobile forensic application failed to return expected test results – the tool did not acquire or report supported data from the mobile device or SIM/UICC successfully.</td></tr>';
		echo '<tr><td class="alternate-header"><i>N/A</i></td><td class="alternate-header">Not Applicable – the mobile forensic application is unable to perform the test or the tool does not provide support for the acquisition for a particular data element.</td></tr>';
		echo '</table>';
		
		$pname = sprintf("%s/%s_results.txt",$root,$selected_device);
		if (file_exists($pname)){
			//printf ("<br>Results file is %s",$pname);
			$pfile = fopen($pname,"r");
			$init_line = fgets($pfile);
			while (!feof($pfile)){
				$x = explode(':',$init_line);
				/*
				printf ("<br>IX: %s %s",$x[0],$x[1]);
				*/
				$init_line = fgets($pfile);
				$state[$x[0]] = $x[1];
			}
			fclose ($pfile);
		} else {
			for ($ix = 0; $ix <= 53; ++$ix){
				$key = sprintf ("dev_init_%02d",$ix);
				$state[$key] = 'populated';
			}
			for ($ix = 0; $ix <= 11; ++$ix){
				$key = sprintf ("sim_init_%02d",$ix);
				$state[$key] = 'populated';
			}
		} 

		/* Get comments ********************************/
		$co_name = sprintf("%s/%s_comments.txt",$root,$selected_device);
		/*
		printf ("<br>***************** COMMENTS: %s\n",$co_name);
			printf ("<br>Comment file is %s",$co_name);
		*/
		if (file_exists($co_name)){
			$pfile = fopen($co_name,"r");
			$init_line = fgets($pfile);
			$comment = '';
			while (!feof($pfile)){
				/*
				printf ("<br>LINE: %s \n",$init_line);
				printf ("<br>COMPARE %d\n", substr_compare($init_line,'<MDC',0,4));
				*/
				if (substr_compare($init_line,'<MDC',0,4) == 0){
					$comment = '';
					$e1 = explode('>',$init_line);
					$e2 = explode('=',$e1[0]);
					/*
					printf ("<br>X: [%s] %s]\n",$e1[0],$e1[1]);
					printf ("<br>Z: [%s] %s]\n",$e2[0],$e2[1]);
					printf ("<br>HEAD: [%s] \n",$e2[1]);
					*/
				}
				else if (substr_compare($init_line,'</MDC',0,5) == 0){
					$state[$e2[1]] = $comment;
					/*
					printf ("<br>Comment (%s): %s\n",$e2[1],$comment);
					*/
				}
				else {
					$comment .= $init_line;
					/*
					printf ("<br>Content update: %s \n",$comment);
					printf ("<br>Content update done \n");
					*/
				}
				$init_line = fgets($pfile);
			}
			fclose ($pfile);
		} else {
			for ($ix = 0; $ix <= 53; ++$ix){
				$key = sprintf ("comm_md_%02d",$ix);
				$state[$key] = '';
			}
			for ($ix = 0; $ix <= 11; ++$ix){
				$key = sprintf ("comm_sc_%02d",$ix);
				$state[$key] = '';
			}
				$key = sprintf ("comm_general_%02d",$ix);
				$state[$key] = '';
		} 
		/* End Get comments ********************************/

		$klist = array_keys($state);
		/*
		echo '<br>';
		echo 'S T A T E';
		foreach ($klist as $key){
			echo '<br>';
			echo $key;
			echo ' ';
			echo $state[$key];
		}

		*/
		/*
		<tbody><tr>
		<td rowspan="10">Address Book Entries</td>
		<td>Regular Length</td>

			<td>
			<input checked="checked" name="dev_init_00" value="populated" type="radio">
			Populated</td>
			<td>
			<input name="dev_init_00" value="omitted" type="radio">
			Omitted</td>

		</tr><tr>
		<td>Maximum Length</td>

			<td>
			<input name="dev_init_01" value="populated" type="radio">
			Populated</td>
			<td>
			<input checked="checked" name="dev_init_01" value="omitted" type="radio">
			Omitted</td>

		z[] = '<td rowspan="10">Address Book Entries</td>';
		z[] = '<td>Regular Length</td>';
		z[] = '	<input  name="dev_init_00" value="populated" type="radio">';
		z[] = '<td>Maximum Length</td>';

		include '../include/mdt-setup.php';
		$z[] = '<td rowspan="10">Address Book Entries</td>';
		$z[] = '<td>Regular Length</td>';
		$z[] = '	<input %s name="dev_init_00" value="%s" type="radio">';
		$z[] = '<td>Maximum Length</td>';
		$z[] = '	<input  name="dev_init_01" value="%s" type="radio">';
		$z[] = '<td>Special Character</td>';
		$z[] = '	<input  name="dev_init_02" value="%s" type="radio">';
		$z[] = '<td>Blank Name</td>';
		$z[] = '	<input  name="dev_init_03" value="%s" type="radio">';
		$z[] = '<td>Regular Length, email</td>';
		$z[] = '	<input  name="dev_init_04" value="%s" type="radio">';
		$z[] = '<td>Regular Length, graphic</td>';
		$z[] = '	<input  name="dev_init_05" value="%s" type="radio">';
		$z[] = '<td>Regular Length, Address</td>';
		$z[] = '	<input  name="dev_init_06" value="%s" type="radio">';
		$z[] = '<td>Deleted Entry</td>';
		$z[] = '	<input  name="dev_init_07" value="%s" type="radio">';
		$z[] = '<td>Non-Latin Entry</td>';
		$z[] = '	<input  name="dev_init_08" value="%s" type="radio">';
		$z[] = '<td>Contact Groups</td>';
		$z[] = '	<input  name="dev_init_09" value="%s" type="radio">';
		*/

		$z[] = '<td rowspan="3">Acquisition </td>';
		$z[] = '<td>Acquire All</td>';
		$z[] = '	<input %s name="dev_data_00" value="%s" type="radio">';
		$z[] = '</tr><tr>';
		$z[] = '<td>Disrupted</td>';
		$z[] = '	<input %s name="dev_data_01" value="%s" type="radio">';
		$z[] = '</tr>';
		$z[] = '<tr>';
		$z[] = '<td>Notes:</td><td colspan="4">';
		$z[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_md_01">%s</textarea></td>';
		$z[] = '</tr>';
		
		$z[] = '<tr>';
		$z[] = '<td rowspan="3">Reporting</td>';
		$z[] = '<td>Preview-Pane</td>';
		$z[] = '	<input %s name="dev_data_02" value="%s" type="radio">';
		$z[] = '</tr><tr>';
		$z[] = '<td>Generated Reports</td>';
		$z[] = '	<input %s name="dev_data_03" value="%s" type="radio">';
		$z[] = '</tr>';
		$z[] = '<tr>';
		$z[] = '<td>Notes:</td><td colspan="4">';
		$z[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_md_02">%s</textarea></td>';
		$z[] = '</tr>';
		
		$z[] = '<tr>';
		$z[] = '<td rowspan="4">Equipment/User Data</td>';
		$z[] = '<td>IMEI</td>';
		$z[] = '	<input %s name="dev_data_04" value="%s" type="radio">';
		$z[] = '</tr><tr>';
		$z[] = '<td>MEID/ESN</td>';
		$z[] = '	<input %s name="dev_data_05" value="%s" type="radio">';
		$z[] = '</tr><tr>';
		$z[] = '<td>MSISDN/MIN</td>';
		$z[] = '	<input %s name="dev_data_06" value="%s" type="radio">';
		$z[] = '</tr>';
		$z[] = '<tr>';
		$z[] = '<td>Notes:</td><td colspan="4">';
		$z[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_md_03">%s</textarea></td>';
		$z[] = '</tr>';
		
		$z[] = '<tr>';
		$z[] = '<td rowspan="4">PIM Data</td>';
		$z[] = '<td>Contacts</td>';
		$z[] = '	<input %s name="dev_data_07" value="%s" type="radio">';
		$z[] = '</tr><tr>';
		$z[] = '<td>Calendar</td>';
		$z[] = '	<input %s name="dev_data_08" value="%s" type="radio">';
		$z[] = '</tr><tr>';
		$z[] = '<td>Memos/Notes</td>';
		$z[] = '	<input %s name="dev_data_09" value="%s" type="radio">';
		$z[] = '</tr>';
		$z[] = '<tr>';
		$z[] = '<td>Notes:</td><td colspan="4">';
		$z[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_md_04">%s</textarea></td>';
		$z[] = '</tr>';
		
		$z[] = '<tr>';
		$z[] = '<td rowspan="5">Stand-alone Data Files</td>';
		$z[] = '<td>Audio</td>';
		$z[] = '	<input %s name="dev_data_18" value="%s" type="radio">';
		$z[] = '</tr><tr>';
		$z[] = '<td>Graphic</td>';
		$z[] = '	<input %s name="dev_data_19" value="%s" type="radio">';
		$z[] = '</tr><tr>';
		$z[] = '<td>Video</td>';
		$z[] = '	<input %s name="dev_data_20" value="%s" type="radio">';
		$z[] = '</tr><tr>';
		$z[] = '<td>Documents</td>';
		$z[] = '	<input %s name="dev_data_33" value="%s" type="radio">';
		$z[] = '</tr>';
		$z[] = '<tr>';
		$z[] = '<td>Notes:</td><td colspan="4">';
		$z[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_md_05">%s</textarea></td>';
		$z[] = '</tr>';
		
		$z[] = '<tr>';
		$z[] = '<td rowspan="4">Call Logs</td>';
		$z[] = '<td>Incoming</td>';
		$z[] = '	<input %s name="dev_data_10" value="%s" type="radio">';
		$z[] = '</tr><tr>';
		$z[] = '<td>Outgoing</td>';
		$z[] = '	<input %s name="dev_data_11" value="%s" type="radio">';
		$z[] = '</tr><tr>';
		$z[] = '<td>Missed</td>';
		$z[] = '	<input %s name="dev_data_12" value="%s" type="radio">';
		$z[] = '</tr>';
		$z[] = '<tr>';
		$z[] = '<td>Notes:</td><td colspan="4">';
		$z[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_md_06">%s</textarea></td>';
		$z[] = '</tr>';
		
		$z[] = '<tr>';
		$z[] = '<td rowspan="3">SMS/EMS Messages</td>';
		$z[] = '<td>Incoming</td>';
		$z[] = '	<input %s name="dev_data_13" value="%s" type="radio">';
		$z[] = '</tr><tr>';
		$z[] = '<td>Outgoing</td>';
		$z[] = '	<input %s name="dev_data_14" value="%s" type="radio">';
		$z[] = '</tr>';
		$z[] = '<tr>';
		$z[] = '<td>Notes:</td><td colspan="4">';
		$z[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_md_07">%s</textarea></td>';
		$z[] = '</tr>';
		
		$z[] = '<tr>';
		$z[] = '<td rowspan="4">MMS Messages</td>';
		$z[] = '<td>Audio</td>';
		$z[] = '	<input %s name="dev_data_15" value="%s" type="radio">';
		$z[] = '</tr><tr>';
		$z[] = '<td>Graphic</td>';
		$z[] = '	<input %s name="dev_data_16" value="%s" type="radio">';
		$z[] = '</tr><tr>';
		$z[] = '<td>Video</td>';
		$z[] = '	<input %s name="dev_data_17" value="%s" type="radio">';
		$z[] = '</tr>';
		$z[] = '<tr>';
		$z[] = '<td>Notes:</td><td colspan="4">';
		$z[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_md_08">%s</textarea></td>';
		$z[] = '</tr>';

		$z[] = '<tr>';
		$z[] = '<td rowspan="2">Location Data</td>';
		$z[] = '<td>Coordinates/Geo-tagged </td>';
		$z[] = '	<input %s name="dev_data_29" value="%s" type="radio">';
		$z[] = '</tr>';
		$z[] = '<tr>';
		$z[] = '<td>Notes:</td><td colspan="4">';
		$z[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_md_09">%s</textarea></td>';
		$z[] = '</tr>';
		
		$z[] = '<tr>';
		$z[] = '<td rowspan="4">Browser/Email Data</td>';
		$z[] = '<td>Visited Sites</td>';
		$z[] = '	<input %s name="dev_data_26" value="%s" type="radio">';
		$z[] = '</tr><tr>';
		$z[] = '<td>Bookmarks</td>';
		$z[] = '	<input %s name="dev_data_27" value="%s" type="radio">';
		$z[] = '</tr><tr>';
		$z[] = '<td>Email</td>';
		$z[] = '	<input %s name="dev_data_28" value="%s" type="radio">';
		$z[] = '</tr>';
		$z[] = '<tr>';
		$z[] = '<td>Notes:</td><td colspan="4">';
		$z[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_md_10">%s</textarea></td>';
		$z[] = '</tr>';
		
		$z[] = '<tr>';
		$z[] = '<td rowspan="5">Social Media Data</td>';
		$z[] = '<td>Application 1, e.g., Facebook</td>';
		$z[] = '	<input %s name="dev_data_22" value="%s" type="radio">';
		$z[] = '</tr><tr>';
		$z[] = '<td>Application 2, e.g., Twitter</td>';
		$z[] = '	<input %s name="dev_data_23" value="%s" type="radio">';
		$z[] = '</tr><tr>';
		$z[] = '<td>Application 3, e.g., LinkedIn</td>';
		$z[] = '	<input %s name="dev_data_24" value="%s" type="radio">';
		$z[] = '</tr><tr>';
		$z[] = '<td>Application 4, e.g., Instagram</td>';
		$z[] = '	<input %s name="dev_data_25" value="%s" type="radio">';
		$z[] = '</tr>';
		$z[] = '<tr>';
		$z[] = '<td>Notes:</td><td colspan="4">';
		$z[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_md_11">%s</textarea></td>';
		$z[] = '</tr>';
						
		$z[] = '<tr>';
		$z[] = '<td rowspan="2">Other Applications of Interest</td>';
		$z[] = '<td>Other Applications of Interest</td>';
		$z[] = '	<input %s name="dev_data_21" value="%s" type="radio">';
		$z[] = '</tr>';
		$z[] = '<tr>';
		$z[] = '<td>Notes:</td><td colspan="4">';
		$z[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_md_12">%s</textarea></td>';
		$z[] = '</tr>';
		
		$z[] = '<tr>';
		$z[] = '<td rowspan="2">Non-Latin Character</td>';
		$z[] = '<td>Reported in native format</td>';
		$z[] = '	<input %s name="dev_data_30" value="%s" type="radio">';
		$z[] = '</tr>';
		$z[] = '<tr>';
		$z[] = '<td>Notes:</td><td colspan="4">';
		$z[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_md_13">%s</textarea></td>';
		$z[] = '</tr>';
		$z[] = '<tr>';
		$z[] = '<td rowspan="2">Hashing</td>';
		$z[] = '<td>Case File/ Individual Files</td>';
		$z[] = '	<input %s name="dev_data_31" value="%s" type="radio">';
		$z[] = '</tr>';
		$z[] = '<tr>';
		$z[] = '<td>Notes:</td><td colspan="4">';
		$z[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_md_14">%s</textarea></td>';
		$z[] = '</tr>';
		$z[] = '<tr>';
		$z[] = '<td rowspan="2">Case File Data Protection</td>';
		$z[] = '<td>Modify Case Data</td>';
		$z[] = '	<input %s name="dev_data_32" value="%s" type="radio">';
		$z[] = '</tr>';
		$z[] = '<tr>';
		$z[] = '<td>Notes:</td><td colspan="4">';
		$z[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_md_15">%s</textarea></td>';
		$z[] = '</tr>';
		$zz[] = '<td rowspan="3">Acquisition</td>';
		$zz[] = '<td>Acquire All</td>';
		$zz[] = '	<input %s name="sim_data_00" value="%s" type="radio">';
		$zz[] = '</tr><tr>';
		$zz[] = '<td>Disrupted</td>';
		$zz[] = '	<input %s name="sim_data_01" value="%s" type="radio">';
		$zz[] = '</tr>';
		$zz[] = '<tr>';
		$zz[] = '<td>Notes:</td><td colspan="4">';
		$zz[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_sc_01">%s</textarea></td>';
		$zz[] = '</tr>';
		$zz[] = '<tr>';
		$zz[] = '<td rowspan="5">Equipment/User Data</td>';
		$zz[] = '<td>Service Provider Name (SPN)</td>';
		$zz[] = '	<input %s name="sim_data_02" value="%s" type="radio">';
		$zz[] = '</tr><tr>';
		$zz[] = '<td>ICCID</td>';
		$zz[] = '	<input %s name="sim_data_03" value="%s" type="radio">';
		$zz[] = '</tr><tr>';
		$zz[] = '<td>IMSI</td>';
		$zz[] = '	<input %s name="sim_data_04" value="%s" type="radio">';
		$zz[] = '</tr><tr>';
		$zz[] = '<td>MSISDN</td>';
		$zz[] = '	<input %s name="sim_data_05" value="%s" type="radio">';
		$zz[] = '</tr>';
		$zz[] = '<tr>';
		$zz[] = '<td>Notes:</td><td colspan="4">';
		$zz[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_sc_02">%s</textarea></td>';
		$zz[] = '</tr>';
		$zz[] = '<tr>';
		$zz[] = '<td rowspan="5">PIM Data</td>';
		$zz[] = '<td>Abbreviated Dialing Numbers (ADNs)</td>';
		$zz[] = '	<input %s name="sim_data_06" value="%s" type="radio">';
		$zz[] = '</tr><tr>';
		$zz[] = '<td>Last Numbers Dialed (LNDs)</td>';
		$zz[] = '	<input %s name="sim_data_07" value="%s" type="radio">';
		$zz[] = '</tr><tr>';
		$zz[] = '<td>SMS Messages</td>';
		$zz[] = '	<input %s name="sim_data_08" value="%s" type="radio">';
		$zz[] = '</tr><tr>';
		$zz[] = '<td>EMS Messages</td>';
		$zz[] = '	<input %s name="sim_data_09" value="%s" type="radio">';
		$zz[] = '</tr>';
		$zz[] = '<tr>';
		$zz[] = '<td>Notes:</td><td colspan="4">';
		$zz[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_sc_03">%s</textarea></td>';
		$zz[] = '</tr>';
		$zz[] = '<tr>';
		$zz[] = '<td rowspan="3">Location Related Data</td>';
		$zz[] = '<td>LOCI</td>';
		$zz[] = '	<input %s name="sim_data_10" value="%s" type="radio">';
		$zz[] = '</tr><tr>';
		$zz[] = '<td>GPRSLOCI</td>';
		$zz[] = '	<input %s name="sim_data_11" value="%s" type="radio">';
		$zz[] = '</tr>';
		$zz[] = '<tr>';
		$zz[] = '<td>Notes:</td><td colspan="4">';
		$zz[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_sc_04">%s</textarea></td>';
		$zz[] = '</tr>';
		
		$zz[] = '<tr>';
		$zz[] = '<td rowspan="2">Case File Data Protection</td>';
		$zz[] = '<td>Modify Case Data</td>';
		$zz[] = '	<input %s name="sim_data_15" value="%s" type="radio">';
		$zz[] = '</tr>';
		$zz[] = '<tr>';
		$zz[] = '<td>Notes:</td><td colspan="4">';
		$zz[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_sc_06">%s</textarea></td>';
		$zz[] = '</tr>';
		$zz[] = '<tr>';
		$zz[] = '<td rowspan="2">Password Protected SIM/UICC Acquire</td>';
		$zz[] = '<td>Acquisition of Protected SIM/UICC</td>';
		$zz[] = '	<input %s name="sim_data_16" value="%s" type="radio">';
		$zz[] = '</tr>';
		$zz[] = '<tr>';
		$zz[] = '<td>Notes:</td><td colspan="4">';
		$zz[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_sc_07">%s</textarea></td>';
		$zz[] = '</tr>';
		$zz[] = '<tr>';
		$zz[] = '<td rowspan="3">PIN/PUK Attempts</td>';
		$zz[] = '<td>PIN attempts reported</td>';
		$zz[] = '	<input %s name="sim_data_17" value="%s" type="radio">';
		$zz[] = '</tr><tr>';
		$zz[] = '<td>PUK attempts reported</td>';
		$zz[] = '	<input %s name="sim_data_18" value="%s" type="radio">';
		$zz[] = '</tr>';
		$zz[] = '<tr>';
		$zz[] = '<td>Notes:</td><td colspan="4">';
		$zz[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_sc_08">%s</textarea></td>';
		$zz[] = '</tr>';
		$zz[] = '<tr>';
		$zz[] = '<td rowspan="2">Non-ASCII Character</td>';
		$zz[] = '<td>Non-ASCII characters</td>';
		$zz[] = '	<input %s name="sim_data_19" value="%s" type="radio">';
		$zz[] = '</tr>';
		$zz[] = '<tr>';
		$zz[] = '<td>Notes:</td><td colspan="4">';
		$zz[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_sc_09">%s</textarea></td>';
		$zz[] = '</tr>';
		$zz[] = '<tr>';
		$zz[] = '<td rowspan="2">Hashing</td>';
		$zz[] = '<td>Hashes reported for acquired data objects</td>';
		$zz[] = '	<input %s name="sim_data_20" value="%s" type="radio">';
		$zz[] = '</tr>';
		$zz[] = '<tr>';
		$zz[] = '<td>Notes:</td><td colspan="4">';
		$zz[] = '<textarea rows="5" cols="60" wrap="soft" name="comm_sc_10">%s</textarea></td>';
		$zz[] = '</tr>';
		$zz[] = '</tbody></table>';
		echo '<form method="POST" onsubmit="return ck_mobile(this)"';
		echo 'action="ft_mdt_update_results.php">';
		echo '<br><h3 style="font-size:1.6em; color:#9D0F19; "><b>Device Test Results</b></h3>';
		echo '<p><i>Documenting Device Test Results</i></p>'; 
		echo '<!------------------------------------------------------------- -->';
//		echo '<div style="padding: 0em 1em .25em .5em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">';
		echo '<div style="padding: 0em 1em 0em 0em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">';
		echo '<table class="bordered_table" style="position:relative;top:-13px;">';
		echo '<tr><th colspan="2"><b>Entry</b></th><th colspan="4"><b>Result</b></th></tr>';
		echo '<tr>';
		$ckp = 'checked=checked';
		$cko = '';
		printf ('<input type="hidden" name="selected_device" value="%s">',$selected_device);
		foreach ($z as $x){
			if (strstr($x,'textarea') == TRUE){
				$f = explode ('"',$x);
				/*
				printf ($x,"Crap".$f[7]);
				*/
				$c_key = $f[7];
				if (array_key_exists($c_key,$state)){
					printf ($x,$state[$c_key]);
				} else {
					printf ($x,'');
				}
			} else if (strstr($x,'radio') == FALSE){
				printf ("%s\n",$x);
			} else {
				/*
				$xin = explode ('"',$x);
				if (trim($state[$xin[1]]) == 'populated') $ckp = 'checked=checked';
				else $cko = 'checked=checked';
				printf ("<td>");
				printf("[%s] [%s]", $xin[1],$state[$xin[1]]);
				$q = sprintf("%s",$x);
				$qq = sprintf ($q,$ckp,"populated");
				printf ("%s %s</td>",$qq,"Populated");

				printf ("<td>");
				$q = sprintf("%s\n",$x);
				$qq = sprintf ($q,$cko,"omitted");
				printf ("%s %s</td>",$qq,"Omitted");
				printf ("</tr><tr>\n\n");
				*/
				$xin = explode ('"',$x);
				$ckp = '';
				$cko = '';
				$ck_ok = '';
				$ck_part = '';
				$ck_no = '';
				$ck_na = '';
				if (trim($state[$xin[1]]) == 'ok') $ck_ok = 'checked=checked';
				elseif (trim($state[$xin[1]]) == 'part') $ck_part = 'checked=checked';
				elseif (trim($state[$xin[1]]) == 'no') $ck_no = 'checked=checked';
				else  $ck_na = 'checked=checked';
				printf ("<td>");
				/*
				printf("[%s] [%s]", $xin[1],$state[$xin[1]]);
				*/
				$q = sprintf("%s",$x);
				$qq = sprintf ($q,$ck_ok,"ok");
				printf ("%s %s</td>",$qq,"As Expected");

				printf ("<td>");
				$q = sprintf("%s\n",$x);
				$qq = sprintf ($q,$ck_part,"part");
				printf ("%s %s</td>",$qq,"Partial");

				printf ("<td>");
				$q = sprintf("%s\n",$x);
				$qq = sprintf ($q,$ck_no,"no");
				printf ("%s %s</td>",$qq,"Not as Expected");

				printf ("<td>");
				$q = sprintf("%s\n",$x);
				$qq = sprintf ($q,$ck_na,"na");
				printf ("%s %s</td>",$qq,"N/A");
			}
		} // end foreach

		echo '</tr>';
		echo '</table>';
		//<!------------------------------------------------------------- -->
		echo '</div><br>';
		
		if ($p_sim[$selected_device] == 'sim'){
			echo '<br><h3 style="font-size:1.6em; color:#9D0F19; position:relative;top:0px;"><b>SIM/UICC Test Results</b></h3>';
			echo '<p><i>Documenting SIM/UICC Test Results</i></p>';
			echo '<!------------------------------------------------------------- -->';
	//		echo '<div style="padding: 0em 1em .25em .5em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">';
			echo '<div style="padding: 0em 1em .25em 0em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">';
			echo '<table class="bordered_table" style="position:relative;top:-13px;">';
			echo '<tr><th colspan="2"><b>Entry</b></th><th colspan="4"><b>Result</b></th></tr>';
			echo '<tr>';
			$ckp = 'checked=checked';
			$cko = '';
			foreach ($zz as $x){
				if (strstr($x,'textarea') == TRUE){
					$f = explode ('"',$x);
					/*
					printf ($x,"Crap".$f[7]);
					*/
					$c_key = $f[7];
					if (array_key_exists($c_key,$state)){
						printf ($x,$state[$c_key]);
					} else {
						printf ($x,'');
					}
				} else if (strstr($x,'radio') == FALSE){
					printf ("%s\n",$x);
				} else {
			/*
			result_options = '''
					<td>    
					<input #OK# type="radio" name="%(q)s%(id)s" value="ok">
					as Expected </td>
					<td>    
					<input #P# type="radio" name="%(q)s%(id)s" value="part">
					Partial </td>
					<td>    
					<input #NO# type="radio" name="%(q)s%(id)s" value="no">
					Not as Expected </td>
					<td>    
					<input #N# type="radio" name="%(q)s%(id)s" value="na">
					N/A </td>
					'''

					$xin = explode ('"',$x);
					$ckp = '';
					$cko = '';
					if (trim($state[$xin[1]]) == 'populated') $ckp = 'checked=checked';
					else $cko = 'checked=checked';
					printf ("<td>");
					printf("[%s] [%s]", $xin[1],$state[$xin[1]]);
					$q = sprintf("%s",$x);
					$qq = sprintf ($q,$ckp,"populated");
					printf ("%s %s</td>",$qq,"As Expected");

					printf ("<td>");
					$q = sprintf("%s\n",$x);
					$qq = sprintf ($q,$cko,"omitted");
					printf ("%s %s</td>",$qq,"Partial");

					printf ("<td>");
					$q = sprintf("%s\n",$x);
					$qq = sprintf ($q,$cko,"omitted");
					printf ("%s %s</td>",$qq,"Not as Expected");

					printf ("<td>");
					$q = sprintf("%s\n",$x);
					$qq = sprintf ($q,$cko,"omitted");
					printf ("%s %s</td>",$qq,"N/A");

			*/
					$xin = explode ('"',$x);
					$ckp = '';
					$cko = '';
					$ck_ok = '';
					$ck_part = '';
					$ck_no = '';
					$ck_na = '';
					if (trim($state[$xin[1]]) == 'ok') $ck_ok = 'checked=checked';
					elseif (trim($state[$xin[1]]) == 'part') $ck_part = 'checked=checked';
					elseif (trim($state[$xin[1]]) == 'no') $ck_no = 'checked=checked';
					else  $ck_na = 'checked=checked';
					printf ("<td>");
					/*
					printf("[%s] [%s]", $xin[1],$state[$xin[1]]);
					*/
					$q = sprintf("%s",$x);
					$qq = sprintf ($q,$ck_ok,"ok");
					printf ("%s %s</td>",$qq,"As Expected");

					printf ("<td>");
					$q = sprintf("%s\n",$x);
					$qq = sprintf ($q,$ck_part,"part");
					printf ("%s %s</td>",$qq,"Partial");

					printf ("<td>");
					$q = sprintf("%s\n",$x);
					$qq = sprintf ($q,$ck_no,"no");
					printf ("%s %s</td>",$qq,"Not as Expected");

					printf ("<td>");
					$q = sprintf("%s\n",$x);
					$qq = sprintf ($q,$ck_na,"na");
					printf ("%s %s</td>",$qq,"N/A");
				}
			} // end foreach
			echo '</tr>';
			echo '</table>';
			//<!------------------------------------------------------------- -->
			echo '</div><br>';
		}

		// print general comments/observations text input box
	    echo '<a name = comments-and-observations></a>';
		echo '<br><h3 style="font-size:1.6em; color:#9D0F19; position:relative;top:0px;"><b>General Comments and Observations</b></h3>';
		echo '<div style="padding: 0em 1em .25em 0em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">';
		$ct = <<<XXX
		<p>
		<label for="textarea">Comments and observations to include in test report:</label><br>
		<textarea wrap="soft" name="comm_general" cols="60" rows="10" id="textarea">%s</textarea>
		</p>
XXX;
		if (array_key_exists("comm_general",$state)){
			printf ($ct,$state["comm_general"]);
		}
		else {
			printf ($ct,'');
		}
		//<!------------------------------------------------------------- -->
		echo '</div><br>';
		echo '&nbsp;&nbsp;<input value="Update Results for Selected Device" name="select" type="submit">';
		echo '</form>';
	} else { // go back and select a device...
		//echo "<p style=\"font-size:1em;\"><b>Error:</b> <b><i>No device selected. Please use ";
		echo "<p><b>Error:</b> <b><i>No device selected. Please use the browser's ";
		echo "back button to return to the previous page and select the device for which ";
		echo "you want to document test results.</i></b></p>\n";
	}
}
?>       
		</div>
		<div class="push"></div>
	</div>
    <!-- Footer Starts-->
        <?php
     $fn = $_SERVER["SCRIPT_FILENAME"];
          print_footer_contents($fn);
        ?>
    <!-- Footer Ends-->

</div></body></html>
