h05744
s 00001/00001/00340
d D 3.1 01/10/11 12:40:25 jimmy 5 4
c Increment Version number to 3.1
e
s 00027/00003/00314
d D 1.4 01/07/10 11:22:15 jimmy 4 3
c add option for overwrite logfile; make default action append to logfile
e
s 00008/00005/00309
d D 1.3 01/06/12 13:58:04 jimmy 3 2
c making error message consistent
e
s 00216/00099/00098
d D 1.2 01/05/15 08:58:43 jimmy 2 1
c revisions for batch exec, commentary and minor revisions
e
s 00197/00000/00000
d D 1.1 00/11/13 13:59:45 jimmy 1 0
c date and time created 00/11/13 13:59:45 by jimmy
e
u
U
f e 0
t
T
I 1
D 2
   static char *SCCS_ID = "%Z% Version %I% Created %G% at %U%";
E 2
I 2
D 3
	static char *SCCS_ID[] = {"%Z% Version %I% Created %G% at %U%",
E 3
I 3
	static char *SCCS_ID[] = {"%Z% %M% Version %I% Created %G% at %U%",
E 3
		__DATE__,__TIME__};
E 2
/******************************************************************************
The software provided here is released by the National
Institute of Standards and Technology (NIST), an agency of
the U.S. Department of Commerce, Gaithersburg MD 20899,
USA.  The software bears no warranty, either expressed or
implied. NIST does not assume legal liability nor
responsibility for a User's use of the software or the
results of such use.

Please note that within the United States, copyright
protection, under Section 105 of the United States Code,
Title 17, is not available for any work of the United
States Government and/or for any works created by United
States Government employees. User acknowledges that this
software contains work which was created by NIST employees
and is therefore in the public domain and not subject to
copyright.  The User may use, distribute, or incorporate
this software provided the User acknowledges this via an
explicit acknowledgment of NIST-related contributions to
the User's work. User also agrees to acknowledge, via an
explicit acknowledgment, that any modifications or
alterations have been made to this software before
redistribution.
******************************************************************************/
/***** Author: Dr. James R. Lyle, NIST/SDCT/SQG ****/
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include "zbios.h"
# include <malloc.h>
# include <time.h>
I 2
/*****************************************************************
Compare two disk sectors
The assumption is that the source has been copied to the dst
It is also assumed that the diskwipe program was run with
source-fill-byte for the source disk
and dst-fill-byte for the destination disk
E 2

D 2
void print_help(char *p)
{
	static int been_here = 0;
	if (been_here) return;
	been_here = 1;
E 2
I 2
Report (in log file):
number of bytes different between src sector and dst sector
If a sector is filled by diskwipe, print the address string
that starts in the first byte of the sector
*****************************************************************/
E 2

D 2
	printf ("Usage: %s /[s|m]\n",p);
	printf ("/m\tUse master drive (default)\n");
	printf ("/s\tUse slave drive\n");
	printf ("/bios\tUse int 13 bios without extensions (default)\n");
	printf ("/xbios\tUse int 13 bios extensions\n");
	printf ("/layout\tPrint the disk layout\n");
	printf ("/?\tPrint this option list\n");
}

main (int np, char **p)
E 2
I 2
int cmp_sec (  disk_control_ptr src_dcb, /* source disk */
					disk_control_ptr dst_dcb, /* destination disk */
					unsigned long src_base,   /* base LBA of source address */
					unsigned long src_offset, /* offset to add to base */
					unsigned long dst_base,   /* ditto for dst */
					unsigned long dst_offset,
					FILE		*log            /* the log file */
)
E 2
{
D 2
	int	try_ext = 0, help = 0;
	int	status,i,j,print;
E 2
I 2
	int	src_status, /* status of source sector read */
			dst_status, /* status of dst sector read */
			i,   /* loop index */
			j, /* loop index */ 
			k, /* loop index */
			need_separator = 0, /* need to print a separator between byte blocks */
			print; /* indicates that a byte pair in the current block differs */
E 2

D 2
	static 	disk_control_ptr src_dcb;
	int		src_drive = 0x80;
E 2
I 2
	int		n_diff; /* count of number of bytes not matching */
	unsigned long src_lba,dst_lba; /* sector addresses */
	unsigned char *sb,*db; /* sector buffers */
	int		src_fill,dst_fill,zero_fill; /* flags indicating type of fill */
	unsigned char src_fill_char; /* the src fill character, if one exists */
	unsigned char dst_fill_char; /* the dst fill character, if one exists */
E 2

D 2
	static 	disk_control_ptr dst_dcb;
	int		dst_drive = 0x81,n_diff;
	unsigned long src_lba,dst_lba,src_base,src_offset,dst_base,dst_offset;
	unsigned char *sb,*db,src_fill_char,dst_fill_char;
	int		src_fill,dst_fill,zero_fill;
E 2

D 2
	FILE		*log;
	char	comment [80];
	static time_t from,till;
	static long et,tmin,min,sec,hours;

	_stklen = 2*_stklen;
	printf ("\n%s compiled at %s on %s\n", p[0],
		__TIME__,__DATE__);

	for (i = 1; i < np; i++){
		if (strcmp(p[i],"/s") == 0) {src_drive = 0x81; dst_drive = 0x80;}
		else if (strcmp (p[i],"/m")== 0) {src_drive = 0x80; dst_drive = 0x81;}
		else if (strcmp (p[i],"/?") == 0) help = 1;
		else if (strcmp (p[i],"/bios")== 0) try_ext = 0;
		else if (strcmp (p[i],"/xbios")== 0) try_ext = 1;
		else help = 1;
		if (help){
			print_help(p[0]);
			return 0;
		}
	}
	status = 1;
	printf ("Insert log floppy, type log comment and press return\n");
	printf ("Host, test\n");
	gets(comment);
	log = fopen("a:\seclog.txt","w");
	if (log == NULL) log = stdout;
   
	fprintf (log,"%s %s\ncompiled %s at %s with BCC version %x\n",
		p[0],SCCS_ID,__DATE__,__TIME__,__BORLANDC__);
	fprintf (log,"%s\n",SCCS_Z);
	fprintf (log,"Comment: %s\n",comment);

	src_dcb = open_disk (src_drive,try_ext,&status);
	printf ("Open disk status code %d\n",status);
	time(&from);

	dst_dcb = open_disk (dst_drive,try_ext,&status);
	printf ("Open disk status code %d\n",status);
	printf ("Enter src (base offset) dst (base offset): ");
	while (EOF != scanf ("%ld%ld%ld%ld",&src_base,&src_offset,
		&dst_base,&dst_offset)){
E 2
I 2
/*****************************************************************
get source and destination sectors and check read status
*****************************************************************/
E 2
		src_lba = src_base + src_offset;
		dst_lba = dst_base + dst_offset;
D 2
		status = read_lba (src_dcb,src_lba,&sb);
		status += read_lba (dst_dcb,dst_lba,&db);
		if (status) {
			printf ("Read error\n");
			continue;
E 2
I 2
		src_status = read_lba (src_dcb,src_lba,&sb);
		dst_status = read_lba (dst_dcb,dst_lba,&db);
		if (src_status) {
D 3
			printf ("Read error on source\n");
			fprintf (log,"Read error %d on source at LBA %lu\n",
E 3
I 3
			fprintf (log,"Src Read error 0x%02X at LBA %lu\n",
				src_status,src_lba); 
			printf ("Src Read error 0x%02X at LBA %lu\n",
E 3
				src_status,src_lba);
			return src_status;
		} 
		if (dst_status) {
			printf ("Read error on destination\n");
D 3
			fprintf (log,"Read error %d on destination at LBA %lu\n",
E 3
I 3
			fprintf (log,"Dst Read error 0x%02X at LBA %lu\n",
				dst_status,dst_lba); 
			printf ("Dst Read error 0x%02X at LBA %lu\n",
E 3
				dst_status,dst_lba);
			return dst_status;
E 2
		}
I 2
/*****************************************************************
Compare the source sector to the destination
*****************************************************************/
E 2
		printf ("Src %ld Dst %ld\n",src_lba,dst_lba);
		fprintf (log,"\nCompare sectors at: Src %ld (%ld+%ld) Dst %ld (%ld+%ld)\n",
			src_lba,src_base,src_offset,dst_lba,dst_base,dst_offset);
D 2
		src_fill_char = sb[26];
E 2
I 2
		src_fill_char = sb[26]; /* if there is a fill then this would be it */
E 2
		dst_fill_char = db[26];
D 2
		src_fill = 1;
E 2
I 2
		src_fill = 1; /* assume filled until shown otherwise */
E 2
		dst_fill = 1;
		for (i = 27; i < 512; i++)
			if (sb[i] != src_fill_char)
D 2
				{src_fill = 0; break;} 
E 2
I 2
				{src_fill = 0; break;} /* src not src filled */
I 4
/*****************************************************************
Check for sector completely filled with the same byte
*****************************************************************/
		if (src_fill){n_diff = 0;
			for (i = 0; i < 25; i++)
				if (sb[i] != sb[25]) n_diff ++;
			if (n_diff < 3) src_fill = 0; /* should be at least 3 diffs */
			else n_diff = 0;
		}
/*****************************************************************
*****************************************************************/
E 4
E 2
		for (i = 27; i < 512; i++)
			if (db[i] != dst_fill_char)
D 2
				{dst_fill = 0; break;}
		zero_fill = dst_fill && (dst_fill_char == '\0');
E 2
I 2
				{dst_fill = 0; break;} /* dst not dst filled */
		zero_fill = dst_fill && (dst_fill_char == '\0'); /* filled ... but with zero */
E 2
		if (zero_fill)
D 2
			for (i = 0; i < 26; i++)
E 2
I 2
			for (i = 0; i < 26; i++) /* is it really zero filled? */
E 2
				if (db[i] != '\0') {zero_fill = 0; dst_fill = 0; break;}
I 4
/*****************************************************************
Check for sector completely filled with the same byte
*****************************************************************/
		if (dst_fill){
			n_diff = 0;
			for (i = 0; i < 25; i++)
				if (db[i] != db[25]) n_diff ++;
			if (n_diff < 3) dst_fill = 0; /* should be at least 3 diffs */
		}
/*****************************************************************
*****************************************************************/
E 4
		n_diff = 0;
I 2
/*****************************************************************
Both source and dst are filled. Sectors may be same or different.
Only neet to report that sectors are filled.
*****************************************************************/
E 2
		if (src_fill && dst_fill){
			for (i = 0; i < 512; i++)
				if (db[i] != sb[i])n_diff++;
			printf ("Src filled by %02X from %s\n",src_fill_char,sb);
			fprintf (log,"Src filled by %02X from %s\n",src_fill_char,sb);
			if (zero_fill){
				printf ("Dst zero filled\n"); 
				fprintf (log,"Dst zero filled\n");
			}
			else {
				printf ("Dst filled by %02X from %s\n",dst_fill_char,db); 
				fprintf (log,"Dst filled by %02X from %s\n",dst_fill_char,db);
			}
		}
I 2
/*****************************************************************
Some byte pairs do not match, print the sectors in blocks of
16 bytes at a time. DON'T PRINT A BLOCK IF ALL BYTE PAIRS IN THE
BLOCK MATCH.
*****************************************************************/
E 2
		else 	for (i = 0; i < 512; i+= 16){
			print = 0;
			for (j = 0; j < 16; j++)
D 2
				if (sb[i+j] != db[i+j]) {n_diff++;print = 1;}
E 2
I 2
				if (sb[i+j] != db[i+j]) {n_diff++;print = 1;} /* need to print */
E 2
			if (print){
D 2
				printf ("src %3d:",i);
E 2
I 2
				if (need_separator) {
					for (k = 0; k < (4+3*16); k++)fprintf(log,"-");
					fprintf (log,"\n");
				}
				else need_separator = 1;
				printf ("src %3d:",i); /* print byte offset of first byte in block */
E 2
				fprintf (log,"Src %3d:",i);
D 2
				for (j = 0; j < 16; j++){
E 2
I 2
				for (j = 0; j < 16; j++){ /* print 16 source bytes in hex */
E 2
					printf (" %02X",sb[i+j]);
					fprintf (log," %02X",sb[i+j]);
				}
				printf ("\ndiff   :");
				fprintf (log,"\ndiff   :");
D 2
				for (j = 0; j < 16; j++){
E 2
I 2
				for (j = 0; j < 16; j++){ /* mark byte pairs that differ with asterisks */
E 2
					printf (" %2s", (sb[i+j] != db[i+j])?"**":"");
					fprintf (log," %2s", (sb[i+j] != db[i+j])?"**":"");
				}
				printf ("\n");
				printf ("Dst %3d:",i); 
				fprintf (log,"\n");
				fprintf (log,"Dst %3d:",i);
D 2
				for (j = 0; j < 16; j++){
E 2
I 2
				for (j = 0; j < 16; j++){  /* print 16 dst bytes in hex */
E 2
					printf (" %02X",db[i+j]); 
					fprintf (log," %02X",db[i+j]);
				}
				printf ("\n"); 
				fprintf (log,"\n");
			}
		}
I 2
/*****************************************************************
 log summary results
*****************************************************************/
E 2
		printf ("%d bytes different\n",n_diff); 
		fprintf (log,"%d bytes different\n\n",n_diff);
D 2
		printf ("Enter src (base offset) dst (base offset): ");
E 2
I 2
		return 0;
}

/*****************************************************************
Print usage information (command line format & options)
*****************************************************************/
void print_help(char *p)
{
	static int been_here = 0;
	if (been_here) return;
	been_here = 1;

	printf ("Usage: %s case host src-drv src-fill dst-drv dst-fill [/opts]\n",p);
	printf ("/comment \"...\"\tDescriptive comment\n");
	printf ("/sector src_lba dst_lba\tSpecify the sectors to compare\n");
D 4
	printf ("/log name.txt\tSpecify an alternate log file name\n");
E 4
I 4
	printf ("/log name.txt\tSpecify an alternate log file name\n"); 
	printf ("/new_log\tStart a new log file (default is append to old log file)\n");
E 4
	printf ("/?\tPrint this option list\n");
}

main (int np, char **p)
{
	int	help = 0;
	int	status,i;

	static 	disk_control_ptr src_dcb; /* source disk */
	int		src_drive = 0x80;

	static 	disk_control_ptr dst_dcb; /* destination disk */
	int		dst_drive = 0x81;
	unsigned long src_base,src_offset = 0,dst_base,dst_offset = 0;
	int		interactive = 1; /* assume user wants interactive mode unless
											overriden on command line */

	FILE		*log;
D 4
	char	comment [80] = "",log_file_name [80] = "A:\SECLOG.TXT";
E 4
I 4
D 5
	char	comment [80] = "",log_file_name [80] = "A:\SECLOG.TXT",*access = "a";
E 5
I 5
	char	comment [80] = "",log_file_name [80] = "A:\\SECLOG.TXT",*access = "a";
E 5
E 4
	static time_t from;

	_stklen = 2*_stklen;
	printf ("\n%s compiled at %s on %s\n", p[0],
		__TIME__,__DATE__);
	if (np < 7) help = 1;
	else {
/*****************************************************************
get source and destination drives (in hex) from command line
*****************************************************************/

		status = sscanf (p[3],"%x",&src_drive);
		if ((status != 1) || ((src_drive < 0x80) || (src_drive > 0x89))){
			printf ("src drive %s is not valid\n",p[3]);
			help = 1;
		}
		status = sscanf (p[5],"%x",&dst_drive);
		if ((status != 1) || ((dst_drive < 0x80) || (dst_drive > 0x89))){
			printf ("dst drive %s is not valid\n",p[5]);
			help = 1;
		}
		if (src_drive == dst_drive){
			help = 1;
			printf ("Source and destination drives must be different\n");
		}
E 2
	}

D 2
	time(&till);
	et = till - from;
	tmin = et/60;
	sec = et%60;
	hours = tmin/60;
	min = tmin%60;
	fprintf (log,"run start %s",ctime(&from));
	fprintf (log,"run finish %s",ctime(&till));
	fprintf (log,"elapsed time %ld:%ld:%ld\n",hours,min,sec);
	printf ("elapsed time %ld:%ld:%ld\n",hours,min,sec);
E 2
I 2
/*****************************************************************
get command line
*****************************************************************/
	for (i = 7; i < np; i++){
		if (strcmp (p[i],"/?") == 0) help = 1;
		else if (strcmp (p[i],"/log")== 0){
			i++;
			if (i >= np){
				printf ("%s: /log option requires a logfile name\n",p[0]);
				help = 1;
			} else strcpy (log_file_name,p[i]);
		}
		else if (strcmp (p[i],"/comment")== 0){
			i++;
			if (i >= np){
				printf ("%s: /comment option requires a comment\n",p[0]);
				help = 1;
			} else strcpy (comment,p[i]);
		}
I 4
		else if (strcmp (p[i],"/new_log")== 0) access = "w";
E 4
		else if (strcmp (p[i],"/sector")== 0){
			i+=2;
			if (i >= np){
D 3
				printf ("%s: /sector option requires a src and dst sector LBA addresses\n",p[0]);
E 3
I 3
				printf ("%s: /sector option requires src and dst sector LBA addresses\n",p[0]);
E 3
				help = 1;
			} else {
				sscanf (p[i-1],"%lu",&src_base);
				sscanf (p[i],"%lu",&dst_base);
				interactive = 0;
			}
		}
		else help = 1;
	}
/*****************************************************************
If there is a problem on command line, then print help message
*****************************************************************/
		if (help){
			print_help(p[0]);
			return 0;
		}
	status = 1;
/*****************************************************************
Open log file; open source and destination
*****************************************************************/
D 4
	log = log_open (log_file_name,comment,SCCS_ID,np,p);
E 4
I 4
	log = log_open (log_file_name,access,comment,SCCS_ID,np,p);
E 4
E 2

D 2
	if (status){
		printf ("error code %d in %s\n",status,p[0]);  
		fprintf (log,"error code %d in %s\n",status,p[0]);
E 2
I 2
	src_dcb = open_disk (src_drive,&status);
	printf ("Open disk status code %d\n",status);
	time(&from);

	dst_dcb = open_disk (dst_drive,&status);
	printf ("Open disk status code %d\n",status);
	log_disk (log,"Source disk",src_dcb); 
	log_disk (log,"Destination disk",dst_dcb);
/*****************************************************************
If source and destination given on command line, compare the
sectors specified. Otherwise go into interactive mode and prompt
for disk addresses (LBA). Since some compare programs sometimes
provide addresses relative to a partition, prompt for addresses
in the form of base (partition start) + offset (relative to partition
start). An absolute LBA would be entered as the base with an offset
of zero (or vice versa).
*****************************************************************/
	if (interactive){
		printf ("Enter src (base offset) dst (base offset): ");
		while (EOF != scanf ("%ld%ld%ld%ld",&src_base,&src_offset,
			&dst_base,&dst_offset)){
			status = cmp_sec (src_dcb,dst_dcb,src_base,src_offset,
						 dst_base,dst_offset,log);
			printf ("Enter src (base offset) dst (base offset): ");
		}
E 2
	}
D 2
	else {printf ("Normal exit %s\n",p[0]);
	 fprintf (log,"Normal exit %s\n",p[0]); }
E 2
I 2
	else { /* one address pair from the command line */
			status = cmp_sec (src_dcb,dst_dcb,src_base,src_offset,
						 dst_base,dst_offset,log);
	}

	 log_close(log,from);
E 2
	return 0;
}
E 1
