h20389
s 00001/00001/00518
d D 3.1 01/10/11 12:40:25 jimmy 7 6
c Increment Version number to 3.1
e
s 00001/00001/00518
d D 2.5 01/07/11 22:02:11 jimmy 6 5
c fix missing return in help message
e
s 00028/00008/00491
d D 2.4 01/07/10 11:20:40 jimmy 5 4
c add compare boot track option
e
s 00000/00000/00499
d D 2.3 01/06/12 13:58:04 jimmy 4 3
c making error message consistent
e
s 00297/00197/00202
d D 2.2 01/04/17 12:13:11 jimmy 3 2
c Add comments, revise command line.
e
s 00000/00000/00399
d D 2.1 00/10/10 15:36:02 jimmy 2 1
c adjust release number
e
s 00399/00000/00000
d D 1.1 00/10/10 15:34:56 jimmy 1 0
c date and time created 00/10/10 15:34:56 by jimmy
e
u
U
f e 0
t
T
I 1
/******************************************************************************
The software provided here is released by the National
Institute of Standards and Technology (NIST), an agency of
the U.S. Department of Commerce, Gaithersburg MD 20899,
USA.  The software bears no warranty, either expressed or
implied. NIST does not assume legal liability nor
responsibility for a User's use of the software or the
results of such use.

Please note that within the United States, copyright
protection, under Section 105 of the United States Code,
Title 17, is not available for any work of the United
States Government and/or for any works created by United
States Government employees. User acknowledges that this
software contains work which was created by NIST employees
and is therefore in the public domain and not subject to
copyright.  The User may use, distribute, or incorporate
this software provided the User acknowledges this via an
explicit acknowledgment of NIST-related contributions to
the User's work. User also agrees to acknowledge, via an
explicit acknowledgment, that any modifications or
alterations have been made to this software before
redistribution.
D 3
******************************************************************************/ 
E 3
I 3
******************************************************************************/
/***** Author: Dr. James R. Lyle, NIST/SDCT/SQG ****/
E 3
# include <stdio.h>
# include "zbios.h"
# include <string.h> 
# include <malloc.h>
# include <time.h>
D 3
static char *SCCS_ID = "%Z% Version %I% Created %G% at %U%";
E 3
I 3
static char *SCCS_ID[] = {"%Z% %M% Version %I% Created %G% at %U%",
				__DATE__,__TIME__};
/*****************************************************************
Compare two disk partitions
The assumption is that the source has been copied to the dst
It is also assumed that the diskwipe program was run with
source-fill-byte for the source disk
and dst-fill-byte for the destination disk
E 3

D 3
# define N_RANGE 15
typedef struct {unsigned long from,to;} lba_range;
typedef struct {
	int	n;
	long is_more;
	lba_range r[N_RANGE];
	} range_list,*range_ptr;
E 3
I 3
Report (in log file) the number of corresponding sectors that are the same and
the number of corresponding sectors that differ by at least one byte.
Two sectors are corresponding if one is on the source partition and
the other sector is in the same relative location on the destination
partition.
E 3

D 3
range_ptr create_range_list(void)
{
	range_ptr	p;
	p = (range_ptr) malloc (sizeof(range_list));
	p->n = 0;
	p->is_more = 0;
	return p;
}
E 3
I 3
If the destination is larger than the source, then each sector of the destination
not corresponding to a source sector is classified as follows:
zero filled
source byte filled
destination byte filled
some other fill byte
other (not filled) sectors
E 3

D 3
void add_to_range (range_ptr r, unsigned long x)
{
	int k = r->n - 1;
	if (r->n){
		if (r->r[k].to + 1 == x) r->r[k].to = x;
		else {
			k++;
			if (k >= N_RANGE){
				r->is_more++;
				return;
			}
			r->n++;
			r->r[k].from = r->r[k].to = x;
		}
	}
	else {
		r->n = 1;
		r->r[0].from = r->r[0].to = x;
	}
}
E 3
I 3
report (in log file) the number of destination sectors in each classification.
E 3

D 3
void print_range_list(FILE *log, range_ptr r)
{
	int	i,nc = 25;
E 3
I 3
Command line:
diskcmp test-case host source-disk source-fill-byte dst-disk dst-fill-byte
E 3

D 3
	for (i = 0; i < r->n; i++){
		if(i)nc += fprintf(log,", ");
		if (nc > 50){
			nc = 0;
			fprintf (log,"\n");
		}
		if (r->r[i].from == r->r[i].to)
			nc += fprintf (log,"%ld",r->r[i].from);
		else nc += fprintf (log,"%ld-%ld",r->r[i].from,r->r[i].to);
	}
	if (r->is_more) fprintf (log,". . . + %ld more\n",r->is_more);
	else fprintf (log,"\n");
}
E 3
I 3
source and destination disks are specified in hex: e.g., 80
fill bytes are two digit hex values: e.g., B4
E 3


I 3
High level design:
	decode command line
	open source and dst disks
	for each sector (address) common to both disk partitions
		read src sector
		read dst sector
		compare: increment count of equal_sectors or differing_sectors
	log results
	if src has more sectors than destination then exit
	else if src and dst are same size then exit
	else for each sector remaining on the dst
		read dst sector
		examine: count zero filled, src filled, dst filled, other filled and
			not filled sectors
	log results
*****************************************************************/

E 3

I 3

/*****************************************************************
get the absolute sector address of the start of a partition
p is the partition table entries list
ix identifies the desired partition table entry
base returns the LBA address of the start of the partition
n returns the number of sectors in the partition
*****************************************************************/
E 3
int get_partition_offset (pte_ptr p,int ix, unsigned long *base,
	unsigned long *n)
{
	unsigned long pt_base;
D 3
	int	at = 0, i;
E 3
I 3
	int	at = 1, i;
E 3
	pte_ptr	sub;

D 3

	for (i = 0; i < 4; i++){
		if (at == ix){
E 3
I 3
	for (i = 0; i < 4; i++){ /* look at each primary PTE (partition table entry) */
		if (at == ix){ /* found desired entry */
E 3
			*base = p[i].lba_start;
			*n = p[i].lba_length;
			return 0;
		}
I 3
		/* If this is an extended PTE look inside */
E 3
		at++;
		sub = p[i].next;
D 3
		pt_base = p[i].lba_start;
E 3
I 3
		pt_base = p[i].lba_start; /* get base of extended PTE */

E 3
		while(sub){
D 3
			if (at == ix){
E 3
I 3
			if (at == ix){ /* found the desired entry */
E 3
				*base = pt_base + sub->lba_start;
				*n = sub->lba_length;
				return 0;
			}
			at++;
D 3
			if ((sub->type == 0x05)
			) pt_base = p[i].lba_start + sub->lba_start;
E 3
I 3
			if ((sub->type == 0x05) /* another extended PTE */
			) pt_base = p[i].lba_start + sub->lba_start; /* move base address */
E 3
			sub = sub->next;
		}
	}
	return 1;
}

I 3
/*****************************************************************
Disk housekeeping that must be done for both source and destination disks
Open disk
get partition table
get base address of desired partition
deal with errors
write record keeping info to log file

drive is the disk to open
caption is either "source" or "destination" (for log file)
log is the log file
p is the command line
ask_for_partitions = true => do dialog to get partition index
px is the partition index (if supplied on command line)
return base -- partition base address (LBA)
return n -- number of sectors in partition
return disk -- disk control pointer to access drive
*****************************************************************/
int setup_disk (int drive, char *caption, FILE *log, char **p, int ask_for_partitions,
		 int px, unsigned long *base, unsigned long *n, disk_control_ptr *disk)
{
	int	status;
	static pte_rec pt[4];

	*disk = open_disk (drive,&status);
	if (status){
		printf ("%s could not read drive %x, status code %d\n",
			p[0],drive,status);
		fprintf (log,"%s could not read drive %x, status code %d\n",
			p[0],drive,status);
		return 1;
	}
	status = get_partition_table(*disk,pt);
I 5
	if (status){
		printf ("Could not read %s partition table on drive %x\n",caption,drive);
		fprintf (log,"Could not read %s partition table on drive %x\n",caption,drive);
		return 1;
	}
E 5
	if (ask_for_partitions){ /* ask if not given on command line */
		print_partition_table(stdout,pt,1,1);
		printf ("Select partition: ");
		scanf ("%d%",&px);
	}

	status = get_partition_offset (pt,px,base,n);
	if (status){
		printf ("Could not find %s partition %d\n",caption,px);
		return 1;
	}
	printf ("%s partition %d at %ld for %ld\n",caption,px,*base,*n);
	/* log information about disk and partition */
	log_disk (log,caption,*disk);
	print_partition_table(log,pt,1,1);
	fprintf (log,"%s partition %d at %ld for %ld\n",caption,px,*base,*n);
	return 0;
}
 
/*****************************************************************
Print usage and options
*****************************************************************/
E 3
void print_help(char *p)
{
	static int been_here = 0;
	if (been_here) return;
	been_here = 1;

D 3
	printf ("Usage: %s /[s|m]\n",p);
	printf ("/m\tUse master drive (default)\n");
	printf ("/s\tUse slave drive\n");
	printf ("/bios\tUse int 13 bios without extensions (default)\n");
	printf ("/xbios\tUse int 13 bios extensions\n");
E 3
I 3
	printf ("Usage: %s test-case host src-drive src-fill dst-drive dst-fill [/options]\n",p);
D 6
	printf ("/select src dst\tSelect partitions to compare");/*
E 6
I 6
	printf ("/select src dst\tSelect partitions to compare\n");/*
E 6
	printf ("               \tformat for src & dst P.N,\n");
	printf ("               \twhere: P is primary partition number\n");
	printf ("               \tN is sequence number\n");  */
	printf ("/comment \" ... \"\tDescriptive comment\n");
I 5
	printf ("/new_log\tStart a new log file (default is append to old log file)\n");
	printf ("/boot\tInclude Boot track in compare\n");
E 5
E 3
	printf ("/?\tPrint this option list\n");
}


I 3
/*****************************************************************
Start here
*****************************************************************/
E 3
int main(int np, char **p)
{
D 3
	int	src_drive = 0x80,dst_drive = 0x81;;
	int	try_ext = 0, help = 0;
	int	status,i;
E 3
I 3
	int	src_drive = 0x80,/* indicates source drive */
			dst_drive = 0x81; /* indicates destination drive */
	int	help = 0, /* set to true to indicate problem with command line */
			ask_for_partitions = 1; /* default is true, set to false if
											partitions given on command line */
	int	status, /* error return on I/O operations */
			i; /* loop index */
E 3
	static disk_control_block *src_disk,*dst_disk;
D 3
	static unsigned long lba = 0,feed,common,diffs = 0,
		nz,nfill,src_lba,dst_lba,
		byte_diffs = 0,match = 0,zero = 0,sfill = 0, dfill = 0,ofill = 0,other = 0;
	int	big_src = 0,big_dst = 0,is_diff;
	int	src_status,dst_status;
	static unsigned char *src_buff,*dst_buff;
	static time_t from,till;
	long et,tmin,min,sec,hours;
	FILE *log;
E 3
I 3
	static unsigned long lba = 0, /* a sector LBA address usually found as a
						loop index */
		common, /* number of sectors common to source & destination */
		diffs = 0, /* count of sectors that don't match */
		nz /* number of zero filled bytes in a sector */,
		nfill, /* number of fill bytes in a sector */
		src_lba, /* address of current sector on source */
		dst_lba,  /* address of current sector on destination */
		byte_diffs = 0, /* count of bytes that differ between src and dst */
		match = 0, /* number of matching sectors */
		/* zero .. other apply to dst sectors beyond common area */
		zero = 0, /* number of zero filled sectors */
		sfill = 0, /* number of sectors filled with src fill char */
		dfill = 0, /* number of sectors filled with dst fill char */
		ofill = 0, /* number of sectors filled with some other fill char */
		other = 0; /* number of remaining (unfilled) sectors */
	int	big_src = 0, /* true if src bigger than dst */
			big_dst = 0, /* true if dst bigger than src */
D 5
			is_diff;
E 5
I 5
			is_diff ,
			boot_track_too = 0; /* include boot track in compare */
E 5
	int	src_status,dst_status; /* I/O error returns */
	static unsigned char *src_buff,*dst_buff; /* sector buffers */
	static time_t from; /* run start time */
	FILE *log; /* log file */
E 3
	int	is_debug = 0, log_diffs = 0;
D 3
	unsigned char src_fill_char,dst_fill_char;
E 3
I 3
	unsigned char src_fill_char,dst_fill_char; /* fill characters */
E 3
	int	fill_char;
D 5
	int xxx = 10;
E 5
D 3
	int	src_px,dst_px;
	unsigned long src_base,src_n,dst_base,dst_n;
	static pte_rec src_pt[4],dst_pt[4];
	range_ptr d_r = create_range_list(),
				 z_r = create_range_list(),
				 sf_r = create_range_list(),
				 df_r = create_range_list(),
				 of_r = create_range_list(),
				 o_r = create_range_list();
	static char comment[80];
E 3
I 3
	int	src_px,dst_px; /* partition table indices from command line */
	unsigned long src_base, /* LBA address of source partition */
					  src_n, /* size (number of sectors in) source partition */
					  dst_base,dst_n; /* ditto dst */
	/* range_ptr is used to track a list of ranges. In this case the ranges
	are disk areas specified in LBA addresses */
	range_ptr d_r = create_range_list(), /* common area sectors that don't match */
				 z_r = create_range_list(), /* zero filled sectors */
				 sf_r = create_range_list(), /* sectors with src-fill */
				 df_r = create_range_list(), /* sectors with dst-fill */
				 of_r = create_range_list(), /* sectors with some other fill */
				 o_r = create_range_list(); /* other (unfilled) sectors */
D 5
	static char comment[80] = "";
E 5
I 5
	static char comment[80] = "",*access = "a";
E 5
E 3

I 3
/*****************************************************************
get start run time and decode command line
*****************************************************************/
E 3
	time(&from);
D 3
	printf ("\n%s compiled at %s on %s\n", p[0],
		__TIME__,__DATE__);
	printf ("Insert log floppy and press Enter key\n");
	scanf ("%[^\n]",comment);
	log = fopen("a:\cmpptlog.txt","w");
	if (log == NULL) log = stdout;
E 3

D 3
	if (np < 3){
		printf ("%s missing hex fill code(s), usage: %s src_fill dst_fill\n",
			p[0],p[0]);
E 3
I 3
	if (np < 7){
		printf ("%s: Missing parameters\n",p[0]);
E 3
		print_help(p[0]);
		return 1;
	}

D 3
	sscanf (p[1],"%x",&fill_char);
E 3
I 3
/*****************************************************************
get fill characters from command line
*****************************************************************/

	sscanf (p[4],"%x",&fill_char);
E 3
	src_fill_char = fill_char;
D 3
	sscanf (p[2],"%x",&fill_char);
E 3
I 3
	sscanf (p[6],"%x",&fill_char);
E 3
	dst_fill_char = fill_char;

I 3
/*****************************************************************
get options from command line
*****************************************************************/
E 3

D 3
	for (i = 3; i < np; i++){
		if (strcmp(p[i],"/s") == 0){ src_drive = 0x81; dst_drive = 0x80;}
		else if (strcmp (p[i],"/m")== 0){ src_drive = 0x80; dst_drive = 0x81;}
		else if (strcmp (p[i],"/?") == 0) help = 1;
		else if (strcmp (p[i],"/bios")== 0) try_ext = 0;
		else if (strcmp (p[i],"/xbios")== 0) try_ext = 1;
		else if (strcmp (p[i],"/debug")== 0) is_debug = 1;
		else if (strcmp (p[i],"/diffs")== 0) log_diffs = 1;
		else help = 1;
		if (help){
			print_help(p[0]);
			return 0;
E 3
I 3

	for (i = 7; i < np; i++){
		if (strcmp (p[i],"/?") == 0) help = 1; /* ask for help */
		else if (strcmp (p[i],"/select") == 0){ /* /select src_ix dst_ix */
			i = i + 2;
			if ( i >= np){
				printf ("%s /select requires two parameters: src partition index\n",
					p[0]);
				printf ("and dst partition index\n");
				help = 1;
			}
			else {
				sscanf (p[i-1],"%d",&src_px);
				sscanf (p[i],"%d",&dst_px);
				ask_for_partitions = 0; /* we got 'em so don't ask */
			}
E 3
		}
I 5
		else if (strcmp (p[i],"/new_log")== 0) access = "w"; 
		else if (strcmp (p[i],"/boot")== 0) boot_track_too = 1;
E 5
I 3
		else if (strcmp (p[i],"/comment")== 0){
			i++;
			if ( i>=np){
				printf ("%s: comment required with /comment\n",	p[0]);
				help = 1;
			}
			else strcpy (comment,p[i]);
		}
		else help = 1;
E 3
	}
D 3
	do {
	printf ("Enter src drive in hex. (80, 81) Current value %02X\n",src_drive);
	scanf("%x",&src_drive);}
	while ((src_drive < 0x80) || (src_drive >0x81));
	src_disk = open_disk (src_drive,try_ext,&status);
	if (status){
		printf ("%s could not read drive %x status code %d\n",
			p[0],src_drive,status);
		fprintf (log,"%s could not read drive %x status code %d\n",
			p[0],src_drive,status);
		return 1;
	}
	status = get_partition_table(src_disk,src_pt);
	print_partition_table(stdout,src_pt,1);
	printf ("Select partition: ");
	scanf ("%d%",&src_px);
E 3
I 3
/*****************************************************************
get source and destination drives (in hex) from command line
*****************************************************************/
E 3

D 3
	status = get_partition_offset (src_pt,src_px,&src_base,&src_n);
	printf ("Src partition %d at %ld for %ld\n",src_px,src_base,src_n);

	do {
	printf ("Enter dst drive(in hex. 80, 81)\n");
	scanf("%x",&dst_drive);}
	while ((dst_drive < 0x80) || (dst_drive > 0x81));
	dst_disk = open_disk (dst_drive,try_ext,&status);
	if (status){
		printf ("%s could not read drive %x status code %d\n",
			p[0],dst_drive,status);
		fprintf (log,"%s could not read drive %x status code %d\n",
			p[0],dst_drive,status);
		return 1;
E 3
I 3
	status = sscanf (p[3],"%x",&src_drive);
	if ((status != 1) || ((src_drive < 0x80) || (src_drive > 0x89))){
		printf ("src drive %s is not valid\n",p[3]);
		help = 1;
E 3
	}
D 3
	status = get_partition_table(dst_disk,dst_pt);
	print_partition_table(stdout,dst_pt,1);
	printf ("Select partition: ");
	scanf ("%d%",&dst_px);
	printf ("Dst partition %d\n",dst_px);
E 3
I 3
	status = sscanf (p[5],"%x",&dst_drive);
	if ((status != 1) || ((dst_drive < 0x80) || (dst_drive > 0x89))){
		printf ("dst drive %s is not valid\n",p[5]);
		help = 1;
	}
	if (src_drive == dst_drive){
		help = 1;
		printf ("Source and destination drives must be different\n");
	}
/*****************************************************************
If there is a problem on command line, then print help message
*****************************************************************/
E 3

D 3
	status = get_partition_offset (dst_pt,dst_px,&dst_base,&dst_n);
	printf ("Dst partition %d at %ld for %ld\n",dst_px,dst_base,dst_n);
E 3
I 3
	if (help){
		print_help(p[0]);
		return 0;
	} 
/*****************************************************************
Open log file, source disk and destination disk
*****************************************************************/
D 5
	log = log_open ("A:\CMPPTLOG.TXT",comment,SCCS_ID,np,p);
E 5
I 5
D 7
	log = log_open ("A:\CMPPTLOG.TXT",access,comment,SCCS_ID,np,p);
E 7
I 7
	log = log_open ("A:\\CMPPTLOG.TXT",access,comment,SCCS_ID,np,p);
E 7
E 5
	status = setup_disk (src_drive,"Source disk",log,p,ask_for_partitions,
		 src_px,&src_base, &src_n,&src_disk);
	status += setup_disk (dst_drive,"Destination disk",log,p,ask_for_partitions,
		 dst_px,&dst_base, &dst_n,&dst_disk);
	if (status) return 1;
E 3

I 3
/*****************************************************************
get ready to do the compare
see which is bigger: src or dst
*****************************************************************/
E 3
	if (src_n != dst_n){
		if ( src_n < dst_n){
			common = src_n;
			big_dst = 1;
		}
		else {
			common = dst_n;
			big_src = 1;
		}
	}
	else common = src_n;
D 3
	fprintf (log,"%s\nversion %s\ncompiled %s at %s with BCC version %x\n",
		p[0],SCCS_ID,__DATE__,__TIME__,__BORLANDC__);
	fprintf (log,"%s\n",SCCS_Z);
   fprintf (log,"Comment: %s\n",comment);
	fprintf (log,"run start %s",ctime(&from));
E 3
	printf ("Source disk fill byte %2X\n",src_fill_char);
	printf ("Destination disk fill byte %2X\n",dst_fill_char);
D 3
	feed = common/5;
	if (is_debug)feed = (feed/100)*100;
	printf ("Feed back every %ld secetors\n",feed);
E 3
	src_lba = src_base;
	dst_lba = dst_base;
I 5
	if (boot_track_too){
		common += 63;
		src_lba -= 63;
		dst_lba -= 63;
		src_base -= 63;
		dst_base -= 63;
		src_n += 63;
      dst_n += 63;
	}
E 5
	fprintf (log,"Source base sector %ld Destination base sector %ld\n",
D 3
		src_base,dst_base);
	for (lba = 0; lba < common; is_debug?(lba+=100):lba++){
E 3
I 3
		src_base,dst_base); 
/*****************************************************************
Main compare loop:
	for each sector in common
		read src sector
		read dst sector
		if match then increment match count
		else increment different count
*****************************************************************/
	for (lba = 0; lba < common; lba++){
		feedback (from,0,lba,big_dst?dst_n:common); /* give progress feedback to user */
E 3
		is_diff = 0;
D 3
		if ((lba%feed) == 0){
			printf ("%6.2f%%\n",(lba*100.0)/common);
		}
E 3
		src_status = read_lba(src_disk,src_lba++,&src_buff);
		dst_status = read_lba(dst_disk,dst_lba++,&dst_buff);
		if (src_status || dst_status){
			fprintf (log,"read error at lba %ld, src %d dst %d\n",lba,src_status,
				dst_status);
			printf ("read error at lba %ld, src %d dst %d\n",lba,src_status,
				dst_status);
			return 1;
		}
I 3
/*****************************************************************
Compare corresponding sectors
*****************************************************************/

E 3
		for (i = 0; i < 512; i++){
			if (src_buff[i] != dst_buff[i]){
				is_diff = 1;
				byte_diffs++;
			}
		}
		if (is_diff){
			diffs++;
			add_to_range (d_r,lba);
			if (log_diffs && (diffs <= 50)){
				 fprintf (log,"%12ld ",lba);
				 if ((diffs%5) == 0) fprintf (log,"\n");
			}
		}
		else {
			match++;
		}
	}
I 3
/*****************************************************************
Log results for corresponding sectors
*****************************************************************/

E 3
	if  (log_diffs && (diffs)) fprintf (log,"\n");
	fprintf (log,"Sectors compared: %12ld\n",common);
	fprintf (log,"Sectors match:    %12ld\n",match);
	fprintf (log,"Sectors differ:   %12ld\n",diffs);
	fprintf (log,"Bytes differ:     %12ld\n",byte_diffs);
D 3
	fprintf (log,"Diffs range: "); print_range_list(log,d_r);
E 3
I 3
	print_range_list(log,"Diffs range: ",d_r);
E 3
	if (big_src){
		fprintf (log,"Source (%ld) has %ld more sectors than destination (%ld)\n",
			src_n,src_n - dst_n,
			dst_n);
	}
I 3
/*****************************************************************
If the destination is larger than the source then
	look at the remainder of the destination
*****************************************************************/
E 3
	else if (big_dst){
		fprintf (log,"Source (%ld) has %ld fewer sectors than destination (%ld)\n",
			src_n,dst_n - src_n,
			dst_n);
		zero = 0;
		ofill = sfill = dfill = 0;
		other = 0;
D 3
		feed = (dst_n - common)/5;
E 3
		printf ("Destination larger than source, scanning %ld sectors\n",
			dst_n-common);
D 3
		printf ("Feed back every %ld sectors\n",feed);
E 3
		for (lba = common; lba < dst_n; is_debug?(lba+=100):lba++){
D 3
			if ((dst_n - common)%feed == 0){
				printf ("%6.2f%%\n",
					((lba - common)*100.0)/(dst_n - common));
			}
E 3
I 3
			feedback (from,0,lba,dst_n);
E 3
			dst_status = read_lba(dst_disk,dst_lba++,&dst_buff);
			nz = 0;
D 3
			nfill = 0;
E 3
I 3
			nfill = 0; 
/*****************************************************************
classify sector: count zero bytes and fill bytes
how to count fill bytes? the rule is: all bytes after
byte [23] are the same. i.e., 488 bytes of the sector are the
same. We use 480 to give some slack.
*****************************************************************/

E 3
			for (i = 0; i < 512; i++){
				if ( dst_buff[i] == 0) nz++;
				else if (dst_buff[i] == dst_buff[30]) nfill++;
			}
			if (nz == 512){zero++; add_to_range(z_r,lba);}
			else if (nfill > 480){
					if (dst_buff[30] == src_fill_char){
						sfill++;
						add_to_range(sf_r,lba);
					}
					else if (dst_buff[30] == dst_fill_char){
						dfill++;
						add_to_range(df_r,lba);
					}
					else {
						ofill++;
						add_to_range(of_r,lba);
					}
			}
			else{ other++;
				add_to_range (o_r,lba);
I 3
/*****************************************************************
A block of debug code -- should delete sometime later
*****************************************************************/
D 5

E 5
I 5
				/*
E 5
E 3
				if (xxx < 5){ chs_addr aaa;
					printf ("other %ld (%ld) ",lba,dst_lba - 1);
					lba_to_chs (dst_disk,dst_lba-1,&aaa);
					printf ("%ld/%ld/%ld ",aaa.cylinder,
						aaa.head,aaa.sector);
					printf ("status %d ",dst_status);
					printf ("This sector  %04ld/%03ld/%02ld\n",
						dst_disk->this_track.cylinder,
						dst_disk->this_track.head,
						dst_disk->this_track.sector);
					printf ("nz %d nfill %d\n",nz,nfill);
					if (nz == 1) printf ("%s\n",dst_buff);
					xxx++;
				}
				if  (log_diffs && (other <= 50)){
					 fprintf (log,"12ld",lba);
					 if (other%5 == 0) fprintf (log,"\n");
D 5
				}
E 5
I 5
				} */
E 5
			}
D 3
		}
		if  (log_diffs && (other)) fprintf (log,"\n");
		fprintf (log,"Zero fill:     %ld\n",zero);
		fprintf (log,"Src Byte fill: %ld %02X\n",sfill,src_fill_char);
		fprintf (log,"Dst Byte fill: %ld %02X\n",dfill,dst_fill_char);
		fprintf (log,"Other fill:    %ld\n",ofill);
		fprintf (log,"Other no fill: %ld\n",other);
	fprintf (log,"Zero fill range: "); print_range_list(log,z_r);
	fprintf (log,"Src fill range: "); print_range_list(log,sf_r);
	fprintf (log,"Dst fill range: "); print_range_list(log,df_r);
	fprintf (log,"Other fill range: "); print_range_list(log,of_r);
	fprintf (log,"Other not filled range: "); print_range_list(log,o_r);
E 3
I 3
		} 
/*****************************************************************
log results to log file
*****************************************************************/
	 if  (log_diffs && (other)) fprintf (log,"\n");
	 fprintf (log,"Zero fill:     %ld\n",zero);
D 5
	 fprintf (log,"Src Byte fill: %ld %02X\n",sfill,src_fill_char);
	 fprintf (log,"Dst Byte fill: %ld %02X\n",dfill,dst_fill_char);
E 5
I 5
	 fprintf (log,"Src Byte fill (%02X): %ld\n",src_fill_char,sfill);
	 if (src_fill_char == dst_fill_char )
		fprintf (log,"Dst Fill Byte same as Src Fill Byte\n");
	 else fprintf (log,"Dst Byte fill (%02X): %ld\n",dst_fill_char,dfill);
E 5
	 fprintf (log,"Other fill:    %ld\n",ofill);
	 fprintf (log,"Other no fill: %ld\n",other);
	 print_range_list(log,"Zero fill range: ",z_r);
	 print_range_list(log,"Src fill range: ",sf_r);
	 print_range_list(log,"Dst fill range: ",df_r);
	 print_range_list(log,"Other fill range: ",of_r);
	 print_range_list(log,"Other not filled range: ",o_r);
E 3
	}
D 3

	time(&till);
	et = till - from;
	tmin = et/60;
	sec = et%60;
	hours = tmin/60;
	min = tmin%60;
	fprintf (log,"run finish %s",ctime(&till));
	fprintf (log,"src drive 0x%2X (%s) %s\n",src_drive,src_drive==0x80?"master":"slave",
		try_ext?"use BIOS extensions":"no BIOS extensions");

	fprintf (log,"elapsed time %ld:%ld:%ld\n",hours,min,sec);
	fprintf (log,"Normal exit %s\n",p[0]);
	printf ("elapsed time %ld:%ld:%ld\n",hours,min,sec);
	printf ("Normal exit %s\n",p[0]);
E 3
I 3
	log_close(log,from);
E 3
	return 0;
}
E 1
