h25589
s 00000/00000/00223
d D 3.1 01/10/11 12:40:23 jimmy 10 9
c Increment Version number to 3.1
e
s 00004/00002/00219
d D 2.8 01/07/10 11:22:14 jimmy 9 8
c add option for overwrite logfile; make default action append to logfile
e
s 00031/00026/00190
d D 2.7 01/06/12 13:58:03 jimmy 8 7
c making error message consistent
e
s 00052/00024/00164
d D 2.6 01/04/06 14:33:24 jimmy 7 6
c fix problem with ident dev returns num sectors = 0
e
s 00073/00089/00115
d D 2.5 01/03/27 16:19:10 jimmy 6 5
c add test-case, host, drive and comment to command line
e
s 00004/00001/00200
d D 2.4 01/01/30 17:34:14 jimmy 5 4
c Update for writing to SCSI disks
e
s 00019/00018/00182
d D 2.3 00/10/02 11:21:22 jimmy 4 3
c convert extra disk area wipe to track I/O
e
s 00019/00016/00181
d D 2.2 00/10/02 09:08:26 jimmy 3 2
c minor updates, comments
e
s 00000/00000/00197
d D 2.1 00/09/27 13:44:51 jimmy 2 1
c switch to track based I/O
e
s 00197/00000/00000
d D 1.1 00/09/27 13:41:51 jimmy 1 0
c date and time created 00/09/27 13:41:51 by jimmy
e
u
U
f e 0
t
T
I 1
D 4
static char *SCCS_ID = "%Z% Version %I% Created %G% at %U%";
E 4
I 4
D 6
static char *SCCS_ID = "@(#) Version 2.2 Created 10/02/00 at 09:08:26";
E 6
I 6
static char *SCCS_ID[] = {"%Z% %M% Version %I% Created %G% at %U%",
				__DATE__,__TIME__};
E 6
E 4
static char *test_version = "*** TEST VERSION ";
/******************************************************************************
The software provided here is released by the National
Institute of Standards and Technology (NIST), an agency of
the U.S. Department of Commerce, Gaithersburg MD 20899,
USA.  The software bears no warranty, either expressed or
implied. NIST does not assume legal liability nor
responsibility for a User's use of the software or the
results of such use.

Please note that within the United States, copyright
protection, under Section 105 of the United States Code,
Title 17, is not available for any work of the United
States Government and/or for any works created by United
States Government employees. User acknowledges that this
software contains work which was created by NIST employees
and is therefore in the public domain and not subject to
copyright.  The User may use, distribute, or incorporate
this software provided the User acknowledges this via an
explicit acknowledgment of NIST-related contributions to
the User's work. User also agrees to acknowledge, via an
explicit acknowledgment, that any modifications or
alterations have been made to this software before
redistribution.
******************************************************************************/
I 3
/***** Author: Dr. James R. Lyle, NIST/SDCT/SQG ****/
E 3
# include <stdio.h>
# include <string.h>
# include "zbios.h"
# include <time.h>

D 6
int do_wipe(disk_control_ptr d,long n_sect,unsigned char fill,unsigned long xs)
E 6
I 6
/*****************************************************************
Write a known pattern to each sector of a disk:
	bytes 0-10	C/H/S address of the sector
	byte 11     blank character
	bytes 12-22 LBA address of the sector
	byte 23		NULL (0)
	bytes 24-511 Fill Byte
*****************************************************************/


/*****************************************************************
Wipe n_sect sectors of the disk with fill
I 7
	d describes the disk to wipe
	n_sect is the number of sectors to wipe
	fill is the fill byte
	start_time is used to estimate time remaining
	heads is used to specify an alternate disk geometry for
		the C/H/S address written to the disk (see note in main)
E 7
*****************************************************************/
int do_wipe(disk_control_ptr d,long n_sect,unsigned char fill,
D 7
	time_t start_time)
E 7
I 7
	time_t start_time, int heads)
E 7
E 6
{
D 4
	unsigned long track,cylinder,head,sector,s,hpc,spt = 63,feed_back_at;
E 4
I 4
D 7
	static unsigned long track,cylinder,head,sector,s,hpc,spt = 63,feed_back_at;
E 7
I 7
	static unsigned long track,cylinder,head,sector,s,hpc,spt = 63;
E 7
E 4
	chs_addr	at;
D 7
	char *b = (char *)&d->buffer[0][0];
D 6
	int		i,not_ok;
E 6
I 6
	int		i,not_ok,xs = 0;
E 6
	float	nf,pc = 0.0,flba;
E 7
I 7
	unsigned char *b = (unsigned char *)&d->buffer[0][0];
	int		i,not_ok;
E 7
	unsigned long from = 0, up_to = n_sect;

	for (i = 0; i < 512*63; i++) b[i] = fill;

D 7
	hpc = n_heads(d); /*
	spt = 3;
	hpc = 2;
	feed_back_at = 2;
	n_sect = 9;   */
D 3
	if (xs){from = up_to; up_to = xs;}
E 3
I 3
	if (xs){from = up_to; up_to = from + xs;}
E 3
D 6
	feed_back_at = (up_to - from)/100;
E 6
I 6
	/*feed_back_at = (up_to - from)/100;
E 6
	printf ("Wipeout from %ld up to %ld, feedback every %ld sectors\n",
D 6
		from,up_to,feed_back_at);
E 6
I 6
		from,up_to,feed_back_at);  */
E 7
I 7
	hpc = n_heads(d);
E 7
	printf ("Wipeout from %ld up to %ld\n",from,up_to);
I 7
	if (heads)printf ("Override heads: %d\n",heads);
E 7
E 6
	for (s = from; s < up_to; s++){
		track = s/spt;
		sector = s%spt + 1;
		cylinder = track/hpc;
		head = track%hpc;
		at.cylinder = cylinder;
		at.head = head;
		at.sector = sector;
D 7
		sprintf (&d->buffer[sector-1][0],
E 7
I 7
		if (heads){
			cylinder = track/heads;
			head = track%heads;
		}
D 8
		sprintf (&(d->buffer[sector-1][0]),
E 8
I 8
		sprintf ((char *)(&(d->buffer[sector-1][0])),
E 8
E 7
			"%05ld/%03ld/%02ld %012ld",cylinder,head,sector,s);
D 5
		if (sector == 63){
E 5
I 5
		if ((sector == 63) || ((s+1) == up_to)){
			if (((s+1) == up_to) && (sector != 63))
D 6
				printf ("Warning: Partial last track (%ld) written at LBA %ld\n",
E 6
I 6
				printf ("Note: Partial last track (%ld) written at LBA %ld\n",
E 6
					sector,s);
E 5
			at.sector = 1;
			not_ok = /*write_sector (d,&at,b);*/
				disk_write (d,&at);}
		else not_ok = 0;
		if (not_ok){
			printf ("At sector (%s) write error ",b);
			return not_ok;
		}
D 4
		if ((s%feed_back_at) == 0){
			flba = s;
			nf = n_sectors(d);
E 4
I 4
D 6
		if (((s-from)%feed_back_at) == 0){
			flba = s-from;
			nf = up_to - from;
E 4
			pc = (100.0*flba)/nf;
			printf ("%012ld (%3.0f%%) %s\n",s,pc,b);
		}
E 6
I 6

		feedback (start_time,from,s,up_to);
E 6
	}

	return 0;
}

I 7
/*****************************************************************
Print the command line format & options
	p is the command name
*****************************************************************/
E 7
void print_help(char *p)
{
	static int been_here = 0;
	if (been_here) return;
	been_here = 1;

D 6
	printf ("Usage: %s /[s|m]\n",p);
	printf ("/m\tUse master drive (default)\n");
	printf ("/s\tUse slave drive\n");
	printf ("/bios\tUse int 13 bios without extensions (default)\n");
D 3
	printf ("/xbios\tUse use bios extensions drive\n");
E 3
I 3
	printf ("/xbios\tUse int 13 bios extensions\n");
	printf ("/x n_extra_tracks\tWipe n_extra_tracks beyond BIOS end of disk\n");
E 6
I 6
	printf ("Usage: %s test-case host drive Fill [/options]\n",p);
	printf ("/src\tWipe a source disk\n");
	printf ("/media\tWipe a media disk\n");
	printf ("/dst\tWipe a destination disk (default)\n");
I 7
	printf ("/heads nnn\tOveride number of heads from BIOS with nnn\n");
E 7
	printf ("/comment \" ... \"\tGive a comment on command line\n");
	printf ("/noask\tSupress confirmation dialog\n");
I 9
	printf ("/new_log\tStart a new log file (default is append to old log file)\n");
E 9
E 6
E 3
	printf ("/?\tPrint this option list\n");
}


main (int np, char **p)
{
	int	drive = 0x80;
D 7
	int	try_ext = 0, help = 0,ifill;
D 6
	int	status,i,is_debug = 0;
E 6
I 6
	int	status,i,is_debug = 0,ask = 1;
E 6
	unsigned long 	ns,xs = 0;
E 7
I 7
	int	help = 0,ifill;
	int	status,i,is_debug = 0,ask = 1,hd = 0;
	unsigned long 	ns;
E 7
	static disk_control_block *dd;
	unsigned char	fill;
	char	ans[100];
D 7
	static time_t from,till;
	long et,tmin,min,sec,hours;
E 7
I 7
	static time_t from;
E 7
	FILE *log;
D 6
	char	comment[80];
E 6
I 6
D 9
	char	comment[80] = "",*log_name = "A:\\WIPEDLOG.TXT";
E 9
I 9
	char	comment[80] = "",*log_name = "A:\\WIPEDLOG.TXT",*access = "a";
E 9
E 6

D 4
	time(&from);
	if (SCCS_ID[0] == '%') SCCS_ID = test_version;
	printf ("\n%s compiled at %s on %s\n", p[0],
		__TIME__,__DATE__);
	printf ("Insert log floppy, type log comment and press the Enter key\n");
	gets(comment);
	log = fopen("a:\wipelog.txt","w");
	if (log == NULL) log = stdout;
E 4
D 7
	printf ("%s %s%s\n",p[0],ctime(&from),SCCS_ID);
E 7
I 7
	printf ("%s %s%s\n",p[0],ctime(&from),SCCS_ID[0]);
E 7
	printf ("Compiled %s %s with BCC Version %x\n",__DATE__,
		__TIME__,__BORLANDC__);

D 6
	for (i = 1; i < np; i++){
		if (strcmp(p[i],"/s") == 0) drive = 0x81;
		else if (strcmp (p[i],"/m")== 0) drive = 0x80;
		else if (strcmp (p[i],"/?") == 0) help = 1;
		else if (strcmp (p[i],"/bios")== 0) try_ext = 0;
		else if (strcmp (p[i],"/xbios")== 0) try_ext = 1;
		else if (strcmp (p[i],"/debug")== 0) is_debug = 1; 
		else if (strcmp (p[i],"/x")== 0) {
			i++;
			if (i >= np){
D 3
				printf ("%s extra sector count required\n",p[0]);
E 3
I 3
				printf ("%s extra track count required\n",p[0]);
E 3
				return 1;
			}
			sscanf (p[i],"%ld",&xs);
E 6
I 6
	if (np < 5) help = 1;
	else sscanf (p[3],"%x",&drive);
	printf ("Drive 0x%X\n",drive);
	for (i = 5; i < np; i++){
		if (strcmp (p[i],"/?") == 0) help = 1;
		else if (strcmp (p[i],"/src")== 0)log_name = "A:\\WIPESLOG.TXT";
		else if (strcmp (p[i],"/media")== 0)log_name = "A:\\WIPEMLOG.TXT";
		else if (strcmp (p[i],"/dst")== 0)log_name = "A:\\WIPEDLOG.TXT";
I 9
		else if (strcmp (p[i],"/new_log")== 0) access = "w";
E 9
		else if (strcmp (p[i],"/noask") == 0) ask = 0;
D 8
		else if (strcmp (p[i],"/comment")== 0){
			i++;
			if (i >= np){
				printf ("%s: /comment option requires a comment\n",p[0]);
				help = 1;
			} else strcpy (comment,p[i]);
E 8
I 8
		else if (strcmp (p[i],"/comment")== 0){
			i++;
			if (i >= np){
				printf ("%s: /comment option requires a comment\n",p[0]);
				help = 1;
			} else strcpy (comment,p[i]);
E 8
I 7
		} 
D 8
		else if (strcmp (p[i],"/heads")== 0){
			i++;
			if (i >= np){
				printf ("%s: /heads option requires a value\n",p[0]);
				help = 1;
			} else {sscanf (p[i],"%d",&hd);printf ("Set heads to %d\n",hd);}
/* **** NOTE about heads value
We have seen situations where the heads value obtained for the
BIOS by the interrupt 13 command 48 is off by one, i.e., the disk
has 64 heads but the value returned by the 48 command is 63. This
does not cause any problems in disk addressing since the C/H/S values
are not used, (LBA numbers are used). However, the C/H/S values written
by this program get out of sync with the real C/H/S addresses.
For example, 0/62/63 is followed by 1/0/1 (instead of 0/63/1).
This /heads option can be used the keep the values in sync with
the actual addresses.
*/
E 8
I 8
		else if (strcmp (p[i],"/heads")== 0){
			i++;
			if (i >= np){
				printf ("%s: /heads option requires a value\n",p[0]);
				help = 1;
			} else {sscanf (p[i],"%d",&hd);printf ("Set heads to %d\n",hd);}
/* **** NOTE about heads value
We have seen situations where the heads value obtained for the
BIOS by the interrupt 13 command 48 is off by one, i.e., the disk
has 64 heads but the value returned by the 48 command is 63. This
does not cause any problems in disk addressing since the C/H/S values
are not used, (LBA numbers are used). However, the C/H/S values written
by this program get out of sync with the real C/H/S addresses.
For example, 0/62/63 is followed by 1/0/1 (instead of 0/63/1).
This /heads option can be used the keep the values in sync with
the actual addresses.
*/
E 8
E 7
E 6
		}
		else help = 1;
D 6
		if (help){
			print_help(p[0]);
			return 0;
		}
E 6
	}
I 6
	if (help){
		print_help(p[0]);
		return 0;
	}
	if (SCCS_ID[0][0] == '%') SCCS_ID[0] = test_version;
D 7
	log = log_open(log_name,comment,SCCS_ID,p);
E 7
I 7
D 9
	log = log_open(log_name,comment,SCCS_ID,np,p);
E 9
I 9
	log = log_open(log_name,access,comment,SCCS_ID,np,p);
E 9
E 7
E 6
I 4
	time(&from);
D 6
	if (SCCS_ID[0] == '%') SCCS_ID = test_version;
	printf ("\n%s compiled at %s on %s\n", p[0],
		__TIME__,__DATE__);
	printf ("Insert log floppy, type log comment and press the Enter key\n");
	gets(comment);
	if (xs) log = fopen("a:\wipexlog.txt","w");
	else log = fopen("a:\wipelog.txt","w");
	if (log == NULL) log = stdout;
E 4
D 3
	if (xs) printf ("Wipeout extra sectors only\n");
E 3
I 3
	if (xs) printf ("Wipeout %ld extra sectors (%ld tracks) only\n",
D 4
		xs,xs*63);
E 4
I 4
		xs*63,xs);
E 4
E 3
	printf ("This program will erase (WIPEOUT) the %s disk OK? (y/n)?",
D 3
		drive == 0x81?"Slave":"Master");
	scanf ("%s",ans);
	if (ans[0] != 'y') return 1;
	printf ("Enter a fill byte in hex: ");
	scanf ("%x",&ifill);
	fill = ifill;
	printf ("Do you want to WIPEOUT the %s disk with %02X? (y/n)?",
		drive == 0x81?"Slave":"Master",ifill);
	scanf ("%s",ans);   printf ("ans is %s\n",ans);
	if (ans[0] != 'y') return 1;

E 3
I 3
		drive == 0x81?"Slave":"Master");
	scanf ("%s",ans);
	if (ans[0] != 'y') return 1;
	printf ("Enter a fill byte in hex: ");
	scanf ("%x",&ifill);
E 6
I 6
	sscanf (p[4],"%x",&ifill);
E 6
	fill = ifill;
D 6
	printf ("Do you want to WIPEOUT the %s disk with %02X? (y/n)?",
		drive == 0x81?"Slave":"Master",ifill);
	scanf ("%s",ans);   printf ("ans is %s\n",ans);
	if (ans[0] != 'y') return 1;
E 6
I 6
	if (ask){
		printf ("This program will erase (WIPEOUT) disk %x OK? (y/n)?",
			drive);
		scanf ("%s",ans);
		if (ans[0] != 'y') return 1;
		printf ("Do you want to WIPEOUT disk %x with %02X? (y/n)?",
			drive,ifill);
		scanf ("%s",ans);   printf ("ans is %s\n",ans);
		if (ans[0] != 'y') return 1;
	}
E 6

E 3
D 6
	printf ("drive 0x%2X (%s) %s\n",drive,drive==0x80?"master":"slave",
		try_ext?"Try BIOS extensions":"No BIOS extensions");
E 6
I 6

E 6
D 7
	dd = open_disk (drive,try_ext,&status);
E 7
I 7
	dd = open_disk (drive,&status);
I 8
	if (status){
		printf ("%s could not access drive %x status code %d\n",
			p[0],drive,status);
		fprintf (log,"%s could not access drive %x status code %d\n",
			p[0],drive,status);
		return 1;
	}
E 8
E 7
I 6
	log_disk(log,"Wipe",dd);
I 7
	if (hd){
		fprintf (log,"Override number of heads from %ld to %d\n",
			dd->disk_max.head,hd);
	}
E 7
E 6
D 8
	printf ("Open disk status code %d\n",status);
D 6
	print_dcb(dd);
E 6
I 6
	if (status) return 1;
E 8
/*	print_dcb(dd);       */
E 6
	ns = n_sectors(dd);
	if (is_debug)ns = 100;
D 4
	status = do_wipe(dd,ns,fill,xs);
E 4
I 4
D 6
	status = do_wipe(dd,ns,fill,xs*63);
E 4
	time(&till);
	et = till - from;
	tmin = et/60;
	sec = et%60;
	hours = tmin/60;
	min = tmin%60;
	fprintf (log,"%s %s\ncompiled %s at %s with BCC version %x\n",
		p[0],SCCS_ID,__DATE__,__TIME__,__BORLANDC__);
	fprintf (log,"%s\n",SCCS_Z);
D 4
   fprintf (log,"Comment: %s\n",comment);
E 4
I 4
	fprintf (log,"Comment: %s\n",comment);
E 4
	fprintf (log,"run start %s",ctime(&from));
	fprintf (log,"run finish %s",ctime(&till));
	fprintf (log,"drive 0x%2X (%s) %s\n",drive,drive==0x80?"master":"slave",
		try_ext?"use BIOS extensions":"no BIOS extensions");
D 4
	if (xs)fprintf (log,"%ld sectors wiped (%ld-%ld) with %2X\n",xs-ns,
		ns,xs,ifill);
E 4
I 4
	if (xs)fprintf (log,"%ld tracks (%ld sectors) wiped (%ld-%ld) with %2X\n",xs,xs*63,
		ns,xs*63+ns,ifill);
E 4
	else fprintf (log,"%ld sectors wiped with %2X\n",ns,ifill);

	fprintf (log,"elapsed time %ld:%ld:%ld\n",hours,min,sec);
E 6
I 6
D 7
	status = do_wipe(dd,ns,fill,from);
E 7
I 7
	status = do_wipe(dd,ns,fill,from,hd);
E 7
E 6
	if (status){
D 6
		printf ("error code %d in %s\n",status,p[0]); 
E 6
I 6
		printf ("error code %d in %s\n",status,p[0]);
E 6
		fprintf (log,"error code %d in %s\n",status,p[0]);

	}
D 6
	else{
		printf ("run start %s",ctime(&from));
		printf ("run finish %s",ctime(&till));
		printf ("Normal exit %s\n",p[0]);
		fprintf (log,"Normal exit %s\n",p[0]);

	}
E 6
I 6
	fprintf (log,"%ld sectors wiped with %2X\n",ns,ifill);
	printf ("%ld sectors wiped with %2X\n",ns,ifill);
	log_close (log,from);
E 6
	return 0;
D 3
}
E 3
I 3
}
E 3
E 1
