;****************************************************
; The software provided here is released by the National
; Institute of Standards and Technology (NIST), an agency of
; the U.S. Department of Commerce, Gaithersburg MD 20899,
; USA.  The software bears no warranty, either expressed or
; implied. NIST does not assume legal liability nor
; responsibility for a User's use of the software or the
; results of such use.
; 
; Please note that within the United States, copyright
; protection, under Section 105 of the United States Code,
; Title 17, is not available for any work of the United
; States Government and/or for any works created by United
; States Government employees. User acknowledges that this
; software contains work which was created by NIST employees
; and is therefore in the public domain and not subject to
; copyright.  The User may use, distribute, or incorporate
; this software provided the User acknowledges this via an
; explicit acknowledgment of NIST-related contributions to
; the User's work. User also agrees to acknowledge, via an
; explicit acknowledgment, that any modifications or
; alterations have been made to this software before
; redistribution.
;****************************************************
;	badx13 -- program to simulate disk I/O errors on
;	disks attached to an Intel PC via the BIOS Int 13
;		extensions for large disks.
;	Author: Dr. James R. Lyle
;	Usage: baddisk drive command error_code sector_LBA
;		drive indicates the hard drive, 80=>master,
;			81=>slave
;		command is the command code of a target command
;			(42 is read, 43 is write)
;		error_code is an "error code" to return if "command"
;			is requested for sector "sector_LBA" on "drive"
;		sector_LBA is the disk address of a target sector
;****************************************************
			.model	tiny
			version	m510
			P386
.code
cr			equ		0ah
lf			equ		0dh
doscall		equ		21h
dos_tsr		equ		3100h
get_i13		equ		3513h
set_i13		equ		2513h
print_cmd	equ		9h
cr			equ		0ah
lf			equ		0Dh
;****************************************************
; Print a message
;****************************************************
print 		MACRO	message
			lea		dx,message
			mov		ah,9
			int		21h
			ENDM
px	 		MACRO	message
			push	ax dx ds cs
			pop		ds
			lea		dx,message
			mov		ah,9
			int		21h
			pop		ds dx ax
			ENDM
;****************************************************
; Format the number in value as ASCII char in field.
; value is a double word
;****************************************************
format_long MACRO value,field
	mov		eax,value
	lea		bx,field
	call	dw_to_char
ENDM
;****************************************************
; Format the number in value as ASCII char in field.
; value is a byte
;****************************************************
format_byte MACRO value,field
	mov		eax,0
	mov		al,value
	lea		bx,field
	call	dw_to_char
ENDM

;****************************************************
;****************************************************
decode	MACRO	from ; from is a byte register with the digit pair
	mov	AH,from	; move digits to AH
	shr	AX,4	; shift left digit into low bits & right digit into AL
	shr	AL,4	; move right digit into low bits
	or	AX,3030H ; convert to ASCII, leave in AX
	ENDM
get_date MACRO	string	; get a date, put in string
	mov		AH,04H	; setup for date BIOS service
	int		1AH	; get the date mm in DH
	decode		DH	; decode the month
	mov		string,AH	; save month in string
	mov		string+1,AL
	decode		DL		; day is in DL
	mov		string+3,AH	; save day of month
	mov		string+4,AL
	decode		CL		; year is in CL
	mov		string+6,AH	; save year digits
	mov		string+7,AL
	ENDM

get_time MACRO	string			; get current time from BIOS
	mov		AH,02H		; setup for time service
	int		1AH		; get the time
	decode		CH		; hours is in CH
	mov		string,AH	; save hours
	mov		string+1,AL
	decode		CL		; minutes is in CL
	mov		string+3,AH	; save minutes
	mov		string+4,AL
	decode		DH		; seconds is in DH
	mov		string+6,AH	; save seconds
	mov		string+7,AL
	ENDM
;****************************************************
;****************************************************
			org		100h
start:
			jmp		install
;****************************************************
;	DISK REQUEST
;		AL	MBZ for write command
;		AH	Command, 42 = read, 43 = write
;		DL	Drive ID
;		DS  DAP segment
;		SI  DAP offset 
;****************************************************
;	DISK ADDRESS PACKET (DAP)
;		0	Must be 16
;		1	MBZ
;		2	# of sectors to read/write
;		3	MBZ
;		4-5 Data area segment
;		6-7	Data area offset
;		8-	Sector LBA (64 bit value)
;****************************************************
dap	struc
	dap_size	db	?
	dap_mbz1	db	?
	dap_n		db	?
	dap_mbz2	db	?
	dap_segment	dw	?
	dap_offset	dw	?
	dap_lba		dd	?
	dap_mbz3	dd	?
dap ends
do_operation:
			mov		eax,cs:axx
			mov		ebx,cs:bxx
			mov		ecx,cs:cxx
			mov		edx,cs:dxx
			jmp		CS:bios_old
new_service:
			mov		cs:axx,eax			; save registers
			mov		cs:bxx,ebx
			mov		cs:cxx,ecx
			mov		cs:dxx,edx

;			px	mess_on
;****************************************************
;			TEST: is this the target I/O request
;****************************************************
;****************************************************
;		Test if disk matches
			cmp		dl,cs:disk
			jne		do_operation		; no match, op not to target
;			px		mess_disk
;		Test if command matches
			cmp		ah,cs:cmd			; is this the target command?
			jne		do_operation		; nope, do the op
;			px		mess_cmd
;****************************************************
;****************************************************
;			mov		eax,ds:[si+dap_lba]
;			push	ds cs
;			pop		ds
;			lea		bx,lba_x
;			push	si di
;			call	dw_to_char
;			pop		di si
;			print	lba_x
;			pop		ds
;****************************************************
;			mov		eax,0
;			mov		al,ds:[si+dap_n]
;			push	ds cs
;			pop		ds
;			lea		bx,lba_x
;			push	si di
;			call	dw_to_char
;			pop		di si
;			print	lba_x
;			pop		ds
;****************************************************
;****************************************************
;	disk and operation match, now check if disk addr in range
			mov		eax,cs:target_lba	; get target disk address
			cmp		eax,ds:[si+dap_lba]
			jb		do_operation
;			px		mess_low
			mov		ebx,ds:[si+dap_lba]
			mov		ecx,0
			mov		cl,ds:[si+dap_n]
			add		ebx,ecx				; compute upper range
			cmp		eax,ebx
			jae		do_operation
;			px		mess_high
;****************************************************
; The disk, operation and address all fit, need to compute
;	adjustment to sector!
;	the number of sectors to read/write to simulate
;	the sector being bad

			mov		ebx,ds:[si+dap_lba]
			sub		eax,ebx
			mov		ds:[si+dap_n],al

			; NEED TO FIX FLAGS ON STACK
			pop		bx		; IP
			pop		cx		; CS
			pop		dx		; flags
			or		dx,01	; set carry (error flag)
			push	dx cx bx ; put it back

			mov		eax,cs:axx	
			cmp		ah,42h
			je		catch_rd
			cmp		ah,43h
			je		catch_wt
			px	got_other
			jmp		restore
catch_rd:
			px	got_read
			jmp		restore
catch_wt:
			px	got_write

restore:
			mov		eax,cs:axx	; restore registers with
			mov		ebx,cs:bxx	; I/O request parameters
			mov		ecx,cs:cxx
			mov		edx,cs:dxx
			cmp		ds:[si+dap_n],0
			je		no_need_to_call		; skip zero length op

			pushf
			call	CS:bios_old
no_need_to_call:
			mov		ah,cs:err_ret
			iret
;***************************.data
;****************************************************
; Resident data area
;****************************************************
mess_on		db		'In ISS',cr,lf,'$'
mess_high	db		'In range',cr,lf,'$'
mess_low	db		'LBA may be in range',cr,lf,'$'
mess_cmd	db		'Op match',cr,lf,'$'
mess_disk	db		'Disk match',cr,lf,'$'
got_read	db		'RD: make bad',cr,lf,'$'
got_write	db		'WT: make bad',cr,lf,'$'
got_other	db		'OT: make bad',cr,lf,'$'
bios_old 	label	dword
biosoff 	dw		0
biosseg 	dw		0
disk		db		?		; target disk
cmd			db 		?		; target command
err_ret		db		?		; error code to return
n_sectors	db		?	; # of sectors to read/write
axx			dd		?	; save register area
bxx			dd		?
cxx			dd		?
dxx			dd		?
target_lba	dd	1024

install:								; install TSR
;****************************************************
;	Look at command line
;****************************************************
			cmp		byte ptr es:[80h],1
			jle		nopram
			jmp		F
;****************************************************
;	If nothing on command line, print message and exit
;****************************************************
nopram:					;
	print	usage		;
	mov		ah,4Ch		;
	mov		al,0		;
	int		21h			; exit without going TSR
;****************************************************

;****************************************************
;	Loop to move command line to buffer
;****************************************************
F:
			print	signon
			call	extract_cmd_line
			call	echo_feedback
;****************************************************
;	Get Drive parameters	
;****************************************************
			mov		ah,08		; get parameters cmd code
			mov		dh,0		; clear DH
			mov 	dl,disk		; set the drive ID (80|81|...)
			int		13H			; Disk BIOS call
			jnc		@F			; carry flag ==> no such disk

			print	no_such_disk ; print error message
			mov		ah,4CH		; exit without TSR
			mov		al,0
			int		21h			; bye

		@@:	; disk drive OK
			get_date date		; add date to signoff line
			get_time time		; add time to signoff line

			mov		ax,get_i13			; get DISK BIOS interrupt vector
			int		doscall

			mov		biosoff,bx			; save offset of DISK handler
			mov		biosseg,es			; and segment
		
			lea		dx,new_service		; set address of new disk service
			mov		ax,set_i13			;
			int		doscall

			print	signoff			; print signoff message

;			lea		dx,usage			; calculate resident part size
			lea		dx,install			; calculate resident part size
			add		dx,110h				; don't forget PSP
			mov		cx,4
			shr		dx,cl				; size is in paragraphs!!!
			mov		ax,dos_tsr			; get ready to TSR
			int		doscall				; Now TSR

dw_to_char	proc
;	eax		value to convert
;	bx		address of buffer
	mov		si,0
	mov		di,3
@@:
	mov		edx,0
	mov		ecx,10
	div		ecx
	add		dx,'0'
	push	dx
	inc		si
	cmp		eax,0
	je		@F
	dec		di
	jnz		@B
	mov		cx,0
	mov		cl,','
	push	cx
	mov		di,3
	inc		si
	jmp		@B
@@:
	mov		di,0
@@:
	pop		dx
	mov		[bx+di],dl
	inc		di
	dec		si
	cmp		si,0
	jnz		@B
	mov		byte ptr[bx+di]," "
	add		bx,di
	ret
	endp	dw_to_char
	
char_to_dw	proc
;
;	bx -> string to convert (leading blanks are ignored)
;	result is stored in eax
;	on return bx points to blank after number
;
	mov		eax,0	; start result at zero
	mov		si,0	; si->current char in buffer
@@:					; skip over blanks
	cmp		byte ptr [bx+si],' '
	jne		@F		; done with blanks
	inc		si		; look at next character
	jmp		@B		; end blank skipping loop
@@:					; Conversion loop start
	mov		ecx,0	; clear C reg for the digit
	mov		cl,[bx+si] ; put current digit in CL
	sub		cl,'0'	; ASCII digit ==> int
	add		eax,ecx	; add this digit to current result
	inc		si		; advance to next digit
	cmp		byte ptr [bx+si],' '	; done yet?
	je		@F		; done. current char is blank
	mov		ecx,10	; get ready . . .
	mul		ecx		; multiply by 10
	jmp		@B		; go do loop again
@@:
	add		bx,si	; done. set bx to point to blank char
	ret				; result is in eax
	endp	char_to_dw

extract_cmd_line	proc
;	print	buff
	mov		ah,0
	mov		al,byte ptr es:[80h]
	mov		si,81h
	mov		di,0
@@:
	mov		bl,es:[si]
	mov		buff[di],bl
	inc		si
	inc		di
	dec		al
	jnz		@B
	mov		buff[di],' '	; command line moved to buff

;	print	buff
	lea		bx,buff+1
	call	char_to_dw
	mov		fake_drive,al
	sub		al,80
	add		al,80h
	mov		disk,al
	call	char_to_dw
	mov		fake_cmd,al
	sub		al,40
	add		al,40h
	mov		cmd,al
	call	char_to_dw
	mov		err_ret,al
	call	char_to_dw
	mov		target_lba,eax
	ret
	endp	extract_cmd_line
	
echo_feedback	proc
;	print	mess
	format_byte	err_ret,er_x
	format_byte	fake_drive,dr_x
	format_byte	fake_cmd,cd_x
	format_long	target_lba,lba_x
	mov		byte ptr [bx],'$'
	print	mess
;	print	EOL
;	format_byte	disk,dr_x
;	format_byte	cmd,cd_x
;	print	mess

	print	EOL
	print	EOL
	ret
	endp		echo_feedback

;****************************************************
; non-resident data area
;****************************************************

no_such_disk db		'Could not access disk drive (NO TSR SET)',cr,lf,'$'
signon 		db		'Monitor BIOS interrupt 13h (disk service)',cr,lf
			db		??filename,' compiled on '
			db		??date,' at ',??time,cr,lf
 			db		'@(#) Version 3.1 Created 10/11/01 at 12:41:45',cr,lf,'$'
signoff		db		'Now ('
date		db		'99/99/99 at '
time		db		'99:99:99) Going . . .  TSR',cr,lf,'$'
buff		db		'                                      ',cr,lf,'$'
fake_drive	db	?
fake_cmd		db	?
mess	db	'Return error code '
er_x	db	'   for X13 command '
cd_x	db	'   from drive '
dr_x	db	'   at LBA sector '
lba_x	db	'x,xxx,xxx,xxx,xxx'
EOL		db	cr,lf,'$'
usage		db		'Usage: badx13 drive (hex) command (hex)'
			db		' error_code (decimal) LBA (decimal)',cr,lf,'$'
			end		start
