h13799
s 00000/00000/00162
d D 3.1 01/10/11 12:40:24 jimmy 9 8
c Increment Version number to 3.1
e
s 00000/00000/00162
d D 2.7 01/08/16 16:27:11 jimmy 8 7
c Add warning for disks that do not have 63 sectors/track
e
s 00001/00001/00161
d D 2.6 01/07/10 11:19:56 jimmy 7 6
c Change logfile to append
e
s 00076/00033/00086
d D 2.5 01/05/15 15:46:12 jimmy 6 5
c major revisions to reorganize support lib
e
s 00015/00002/00104
d D 2.4 01/04/06 14:33:24 jimmy 5 4
c fix problem with ident dev returns num sectors = 0
e
s 00023/00017/00083
d D 2.3 01/03/27 16:19:10 jimmy 4 3
c add test-case, host, drive and comment to command line
e
s 00001/00000/00099
d D 2.2 00/10/02 09:08:27 jimmy 3 2
c minor updates, comments
e
s 00000/00000/00099
d D 2.1 00/09/27 13:44:51 jimmy 2 1
c switch to track based I/O
e
s 00099/00000/00000
d D 1.1 00/09/27 13:41:51 jimmy 1 0
c date and time created 00/09/27 13:41:51 by jimmy
e
u
U
f e 0
t
T
I 1
/******************************************************************************
The software provided here is released by the National
Institute of Standards and Technology (NIST), an agency of
the U.S. Department of Commerce, Gaithersburg MD 20899,
USA.  The software bears no warranty, either expressed or
implied. NIST does not assume legal liability nor
responsibility for a User's use of the software or the
results of such use.

Please note that within the United States, copyright
protection, under Section 105 of the United States Code,
Title 17, is not available for any work of the United
States Government and/or for any works created by United
States Government employees. User acknowledges that this
software contains work which was created by NIST employees
and is therefore in the public domain and not subject to
copyright.  The User may use, distribute, or incorporate
this software provided the User acknowledges this via an
explicit acknowledgment of NIST-related contributions to
the User's work. User also agrees to acknowledge, via an
explicit acknowledgment, that any modifications or
alterations have been made to this software before
redistribution.
******************************************************************************/ 
D 6
# define Z_H_ID "zbios.h %Z% Version %I% Created %G% at %U%"
E 6
I 6
# define Z_H_ID "%Z% %M% Version %I% Created %G% at %U%"
E 6
I 3
/***** Author: Dr. James R. Lyle, NIST/SDCT/SQG ****/
E 3
# include <dos.h>
# include <bios.h>
I 4
# include <time.h>
E 4
# define GET_DISK_PARMS 8
I 5
D 6
# define N_RANGE 100
E 6
I 6
# define N_RANGE 20
E 6
E 5

D 6
extern int buffer_zbios;
D 4
typedef unsigned char physical_sector[512];
typedef physical_sector physical_track[63];
E 4
I 4
typedef unsigned char physical_sector[512]; /* a sector of 512 bytes */
typedef physical_sector physical_track[63]; /* a track is an array of 63 sectors */
E 6
I 6
/******************************************************************************
A disk address in cylinder/head/sector format
******************************************************************************/
E 6
E 4
typedef struct {
D 4
	unsigned long cylinder,head,sector; } chs_addr;
E 4
I 4
	unsigned long cylinder,head,sector; } chs_addr; /* C/H/S disk address */
E 4
D 6
typedef struct disk_struct disk_control_block, *disk_control_ptr;
E 6
I 4

I 6
/******************************************************************************
Basic information (model, serial number, max user addressable sectors)
obtained by IDENTIFY_DEVICE command to a disk controler
******************************************************************************/

E 6
typedef struct {
	unsigned long max_user_sectors;
	char	serial_no[21];
	char	model_no[41];
} ide_rec, *ide_ptr;

I 6
/******************************************************************************
The disk_control_block contains all information about a disk drive
Disk geometry as seen by legacy BIOS (interrupt 13/command 0x08): logical disk
Disk geometry as seen by XBIOS (int 13/cmd 0x48): disk_max
number of sectors reported by BIOS: n_sectors
A buffer holding 63 sectors: buffer
Drive number: drive
Flag indicating XBIOS active: use_bios_x
IDE Drive information: ide_info
******************************************************************************/

typedef unsigned char physical_sector[512]; /* a sector of 512 bytes */
typedef physical_sector physical_track[63]; /* a track is an array of 63 sectors */
typedef struct disk_struct disk_control_block, *disk_control_ptr;

E 6
E 4
struct disk_struct {
	unsigned long 	n_sectors;
	chs_addr			disk_max;     /* number of cyl, number of head */
	chs_addr			logical_disk; /* max cyl, max head */
	chs_addr 		this_track;   /* cyl and head of track in buffer */
D 4
	int				drive;
	int				use_bios_x;    /* is dis > 8.4GB */
E 4
I 4
	int				drive; 			/* drive number (starts at 0x80) */
	int				use_bios_x;    /* is disk > 8.4GB */
E 4
	int				valid_sectors;  /* track buffer has data */
I 4
   ide_ptr			ide_info;		/* Model#, Serial# & max sectors */
E 4
	physical_track buffer;      /* 63 sectors (1 track) buffer[sector][byte]*/
};

I 6
/******************************************************************************
Partition table entry layout on disk
******************************************************************************/

E 6
D 4
typedef struct pts {
E 4
I 4
typedef struct pts { /* partition table layout */
E 4
	unsigned char bootid,
					  start_head,
					  start_sector,
					  start_cylinder,
					  type_code,
					  end_head,
					  end_sector,
					  end_cylinder;
	unsigned long starting_lba_sector,
					  n_sectors;
} partition_table_rec, *partition_table_pointer;
I 6
/******************************************************************************
Layout of a partition table in a boot sector
******************************************************************************/

E 6
D 4
typedef struct {
E 4
I 4
typedef struct { /* partition table in Master Boot Record */
E 4
D 6
	char	fill[446];
	partition_table_rec pe[4];
	unsigned int sig;
E 6
I 6
	char						fill[446]; /* MBR boot code */
	partition_table_rec 	pe[4];	  /* master partition table */
	unsigned int 			sig;		  /* partition table signature word 0xAA55 */
E 6
}mbr_sector,*mbr_ptr;

I 6
/******************************************************************************
Data structure to keep partition table information
******************************************************************************/

E 6
typedef struct pte_struct pte_rec, *pte_ptr;
struct pte_struct {
D 6
	pte_ptr	next;
E 6
I 6
	pte_ptr				next;
E 6
	unsigned char		is_boot,type;
D 6
	chs_addr	start,end;
	unsigned long	lba_start,lba_length;
E 6
I 6
	chs_addr				start,end;
	unsigned long		lba_start,lba_length;
E 6
};

I 5

I 6
/******************************************************************************
Data structure to track ranges of integers. The compare programs examine each
disk sector in LBA address sequence and assign each sector to a catagory, e.g.,
dst sector that differs from corresponding src sector, zero filled, src filled,
dst filled, etc. This data structure is used to track blocks of
disk sector LBA addresses for sectors that are classified in the same catagory.
******************************************************************************/

E 6
typedef struct {unsigned long from,to;} lba_range;
typedef struct { /* structure to keep a list of ranges */
D 6
	int	n;
	long is_more; /* more than N_RANGE ranges present (i.e., some not recorded) */
	lba_range r[N_RANGE];
E 6
I 6
	int			n;
	long 			is_more; /* more than N_RANGE ranges present (i.e., some not recorded) */
	lba_range 	r[N_RANGE];
E 6
	} range_list,*range_ptr;


E 5
D 4

/*
int read_disk (disk_control_ptr , chs_addr *, char *); 
int read_disk_buffer (disk_control_ptr , chs_addr *, unsigned char **);
int open_disk (int, disk_control_ptr, int);
int write_sector (disk_control_ptr, chs_addr *, char *);
int read_lba (disk_control_ptr, unsigned long, char *);
*/
E 4
D 6
int read_lba (disk_control_ptr ,unsigned long , unsigned char **);
int disk_write (disk_control_ptr, chs_addr *);
int disk_read (disk_control_ptr, chs_addr *);
D 5
disk_control_ptr open_disk (int, int, int *);
E 5
I 5
disk_control_ptr open_disk (int, int *);
E 5
void lba_to_chs (disk_control_block *,unsigned long , chs_addr *);
I 4
D 5
FILE *log_open (char *,char *,char **, char **);
E 5
I 5
FILE *log_open (char *,char *,char **, int, char **);
E 5
void log_close (FILE *,time_t);
void log_disk(FILE *, char *, disk_control_ptr);
E 6
I 6
/******************************************************************************
Function decls for zbios.cpp
******************************************************************************/

int 					read_lba (disk_control_ptr ,unsigned long , unsigned char **);
int 					disk_write (disk_control_ptr, chs_addr *);
int 					disk_read (disk_control_ptr, chs_addr *);
disk_control_ptr 	open_disk (int, int *);
void 					lba_to_chs (disk_control_block *,unsigned long , chs_addr *);
E 6
E 4

I 6
D 7
FILE 					*log_open (char *,char *,char **, int, char **);
E 7
I 7
FILE 					*log_open (char *,char *,char *,char **, int, char **);
E 7
void 					log_close (FILE *,time_t);
void 					log_disk(FILE *, char *, disk_control_ptr);
E 6

D 6
void print_dcb(disk_control_ptr);
int get_partition_table(disk_control_block *,pte_ptr );
D 4
void print_partition_table(FILE *,pte_rec *, int);
E 4
I 4
void print_partition_table(FILE *,pte_rec *, int, int);
E 4
extern char *SCCS_Z;
extern int buffer_zbios;
I 4
void feedback (time_t , unsigned long , unsigned long ,
					unsigned long );
I 5
range_ptr create_range_list(void);
void add_to_range (range_ptr, unsigned long );
void print_range_list(FILE *, char *,range_ptr);
E 6
E 5
E 4

I 6
void 			print_dcb(disk_control_ptr);
int 			get_partition_table(disk_control_block *,pte_ptr );
void 			print_partition_table(FILE *,pte_rec *, int, int);

void 			feedback (time_t, unsigned long, unsigned long, unsigned long);

range_ptr 	create_range_list(void);
void 			add_to_range (range_ptr, unsigned long );
void 			print_range_list(FILE *, char *,range_ptr);

E 6
# define is_big(d) (d)->use_bios_x
D 4
# define n_sectors(d) (d)->n_sectors
E 4
I 4
# define n_sectors(d) ((d)->ide_info?(d)->ide_info->max_user_sectors:(d)->n_sectors)
E 4
# define n_cylinders(d) (d)->disk_max.cylinder
# define n_heads(d) (d)->disk_max.head
# define n_tracks(d) ((d)->disk_max.head*(d)->disk_max.cylinder)

E 1
