h25160
s 00005/00003/00929
d D 3.1 01/10/11 12:40:23 jimmy 12 11
c Increment Version number to 3.1
e
s 00018/00012/00914
d D 2.10 01/08/16 16:27:11 jimmy 11 10
c Add warning for disks that do not have 63 sectors/track
e
s 00004/00002/00922
d D 2.9 01/07/10 11:19:55 jimmy 10 9
c Change logfile to append
e
s 00158/00075/00766
d D 2.8 01/05/15 08:58:42 jimmy 9 8
c revisions for batch exec, commentary and minor revisions
e
s 00074/00006/00767
d D 2.7 01/04/06 14:33:24 jimmy 8 7
c fix problem with ident dev returns num sectors = 0
e
s 00333/00028/00440
d D 2.6 01/03/27 16:19:11 jimmy 7 6
c add test-case, host, drive and comment to command line
e
s 00011/00002/00457
d D 2.5 01/01/24 14:10:41 jimmy 6 5
c SCSI update: create a geometry if INT 13X returns 0
e
s 00001/00000/00458
d D 2.4 00/11/13 13:56:48 jimmy 5 4
c Fixed bug: read of other than first sector of track causes confusion
e
s 00001/00000/00457
d D 2.3 00/10/02 09:08:26 jimmy 4 3
c minor updates, comments
e
s 00002/00002/00455
d D 2.2 00/09/28 10:07:15 jimmy 3 2
c add fat12 message
e
s 00000/00000/00457
d D 2.1 00/09/27 13:58:31 jimmy 2 1
c switch to track based I/O
e
s 00457/00000/00000
d D 1.1 00/09/27 13:41:51 jimmy 1 0
c date and time created 00/09/27 13:41:51 by jimmy
e
u
U
f e 0
t
T
I 1
/******************************************************************************
The software provided here is released by the National
Institute of Standards and Technology (NIST), an agency of
the U.S. Department of Commerce, Gaithersburg MD 20899,
USA.  The software bears no warranty, either expressed or
implied. NIST does not assume legal liability nor
responsibility for a User's use of the software or the
results of such use.

Please note that within the United States, copyright
protection, under Section 105 of the United States Code,
Title 17, is not available for any work of the United
States Government and/or for any works created by United
States Government employees. User acknowledges that this
software contains work which was created by NIST employees
and is therefore in the public domain and not subject to
copyright.  The User may use, distribute, or incorporate
this software provided the User acknowledges this via an
explicit acknowledgment of NIST-related contributions to
the User's work. User also agrees to acknowledge, via an
explicit acknowledgment, that any modifications or
alterations have been made to this software before
redistribution.
******************************************************************************/ 
I 4
/***** Author: Dr. James R. Lyle, NIST/SDCT/SQG ****/
E 4
# include <stdio.h>
# include "zbios.h"
# include <string.h> 
# include <malloc.h>
I 7
# include <time.h>
E 7
D 9
extern char *SCCS_Z = "support lib zbios.cpp %Z% Version %I% created %G% at %U%"\
E 9
I 9
extern char *SCCS_Z = "%Z% support lib %M% Version %I% created %G% at %U%"\
E 9
"\nsupport lib compiled "__DATE__" at "__TIME__"\n"Z_H_ID;
# define GET_DISK_PARMS 8
D 9
int buffer_zbios = 1;
E 9

I 7

/*****************************************************************
Support Library
	Probe an IDE disk for Mfg & Serial #
	Log file: open, log disk, close
	Give user progress and completion time feedback
	Disk utilities: open, read, write, convert LBA <=> C/H/S
	Partition table: get and print
*****************************************************************/

D 9
# define adapter(x) ((x)?0x0170:0x01F0)
# define drive_no(x) ((x)?0x00B0:0x00A0)
# define dev_port(x) (adapter(x)+6)
# define cmd_port(x) (adapter(x)+7)
# define id_dev 0x0EC
E 9
/*****************************************************************
Remove any leading or trailing blanks from s
*****************************************************************/

D 9
void trim(char *s)
E 9
I 9
void trim(char *s /* s is the string to trim */)
E 9
{
	int	at = strlen(s),k;

I 9
/*****************************************************************
Scan s from the end toward the beginning to find last non-blank
*****************************************************************/
E 9
	while (at){
		at--;
		if (s[at] != ' '){
D 9
			s[at+1] = '\0';
E 9
I 9
			s[at+1] = '\0'; /* snip trailing blanks */
E 9
			break;
		}
	}
D 9
	if (s[0] != ' ')return;
E 9
I 9
	if (s[0] != ' ')return; /* done if no leading blanks */
E 9
	at = 0;
D 9
	while (s[at] == ' ') at++;
E 9
I 9
	while (s[at] == ' ') at++; /* find first non-blank */
E 9
	k = 0;
D 9
	while (s[at]){
E 9
I 9
	while (s[at]){ /* move string on top of leading blanks */
E 9
		s[k++] = s[at++];
	}
D 9
	s[k] = '\0';


E 9
I 9
	s[k] = '\0'; /* terminate string */
E 9
	return;
}

/*****************************************************************
I 9
Macros for accessing IDE disk controler
adapter(0) is the primary IDE channel
adapter (1) is the secondary IDE channel
drive_no(0) is the master drive for the channel
drive_no(1) is the slave drive for the channel
dev_port and cmd_port are device registers to issue an I/O command
id_dev is the command code for IDENTIFY_DEVICE
*****************************************************************/
# define adapter(x) ((x)?0x0170:0x01F0)
# define drive_no(x) ((x)?0x00B0:0x00A0)
# define dev_port(x) (adapter(x)+6)
# define cmd_port(x) (adapter(x)+7)
# define id_dev 0x0EC
/*****************************************************************
E 9
Issue an IDENTIFY DEVICE command to an IDE disk controler to get
the disk model number and serial number.
See the ATA standard for details but the basic idea is
	use outportb to set the command registers and
	use inport to get the results.
	The command generates an interrupt, but just sleep through it.
*****************************************************************/
D 9
ide_ptr probe_ide_adapter (int adapter_no,int unit_no)
E 9
I 9
ide_ptr probe_ide_adapter (int adapter_no, /* specify IDE channel */
									int unit_no) /* identify master or slave */
E 9
{
	ide_ptr	ide = NULL;
D 9
	char	c;
	static unsigned int w[64];
	int	k;
E 9
I 9
	char	c; /* valid results return */
	static unsigned int w[64]; /* input buffer for responce to IDENTIFY_DEVICE cmd */
	int	k; /* loop index */
E 9

I 9
	/* issue the command */
E 9
	outportb(dev_port(adapter_no),drive_no(unit_no));
	outportb(cmd_port(adapter_no),id_dev);
	sleep(1); /* let somebody else answer the interrupt */
	c = inp(cmd_port(adapter_no));
D 9
	if (c != 0x58) return NULL;
E 9
I 9
	if (c != 0x58) return NULL; /* no data found */
	/* get the first 64 words, discard the remainder */
E 9
	for (k = 0; k < 64; k++)
		w[k] = inport(adapter(adapter_no));
	ide = (ide_ptr) malloc (sizeof(ide_rec));
I 9
	/* get the disk model number */
E 9
	for (k = 0; k < 20; k++){
		ide->model_no[2*k + 1] = w[k+27] & 0x00FF;
		ide->model_no[2*k] = (w[k+27]&0xFF00) >> 8;
	}
	ide->model_no[40] = '\0';
I 9
	/* get the disk serial number */
E 9
	for (k = 0; k < 10; k++){
		ide->serial_no[2*k + 1] = w[k+10] & 0x00FF;
		ide->serial_no[2*k] = (w[k+10]&0xFF00) >> 8;
	}
	ide->serial_no[20] = '\0';
	trim (ide->serial_no);
	trim (ide->model_no);
I 9
	/* get the max user addressable sectors. Note: this is only
	valid for IDE disks in LBA mode. i.e., really old disks that
	do not support LBA return ZERO */
E 9
	ide->max_user_sectors = (((unsigned long)w[61])<<16) +
									 ((unsigned long)w[60]);
	return ide;

}

/*****************************************************************
Map IDE drive number to Controler adapter/unit number.
This mapping is NOT correct in general, but works in the usual
hardware setup (80 -- 0x1F0,0; 81 -- 0x1F0,1; 82 -- 0x170,0 ; etc)
*****************************************************************/
ide_ptr probe_ide (int drive)
{
	int	adapter_no = 0,unit_no = 0,d = 0;
	static int first_time = 1;
	static ide_ptr drive_info[4] = {NULL,NULL,NULL,NULL};
	ide_ptr	info;
D 9

E 9
I 9
	/* first time probe for four disks: IDE primary & secondary for
	master and slave, i.e., disks 80-83, and save results. After first
	time just return the result for the given drive. */
E 9
	if (first_time){
		first_time = 0;
I 11
		/* try each unit of each adapter */
E 11
		for (adapter_no = 0; adapter_no < 2; adapter_no++)
			for (unit_no = 0; unit_no < 2; unit_no++){
				info = probe_ide_adapter (adapter_no,unit_no);
				if (info) drive_info[d++] = info;
			}
	}
I 11
	/* store info on drive 0x80 is position 0 of drive_info, 0x81 at 1 etc */
E 11
	drive = drive - 0x80;
	if ((drive < 0) || (drive > 3)) return NULL;
	return drive_info[drive];
}

/*****************************************************************
I 8
Create an empty list of ranges
*****************************************************************/
range_ptr create_range_list(void)
{
	range_ptr	p;
I 11
	/* allocate space for a list */
E 11
	p = (range_ptr) malloc (sizeof(range_list));
D 11
	p->n = 0;
E 11
I 11
	p->n = 0; /* list starts out empty */
E 11
	p->is_more = 0;
	return p;
}

/*****************************************************************
Add x to the list of ranges (r)
	(1) look for a range that can be expanded to include x
		 i.e., range of form a--b where b+1=x, a--b can then be
		 expanded to a--x
	(2) If an expandable range can't be found create a range of
		 the form x--x
*****************************************************************/
void add_to_range (range_ptr r, unsigned long x)
{
	int k = r->n - 1;
D 9
	if (r->n){
E 9
I 9
	if (r->n){ /* there is already at least one range */
		/* if x is one past edge of last range, expand range */
E 9
		if (r->r[k].to + 1 == x) r->r[k].to = x;
D 9
		else {
E 9
I 9
		else { /* either add new range of count total in category */
E 9
			k++;
D 9
			if (k >= N_RANGE){
				r->is_more = 1;
E 9
I 9
			if (k >= N_RANGE){ /* too many ranges, just count */
				r->is_more++;
E 9
				return;
			}
I 9
			/* add new range to list: x--x */
E 9
			r->n++;
			r->r[k].from = r->r[k].to = x;
		}
	}
D 9
	else {
E 9
I 9
	else { /* first time: set number of ranges in range list to 1 */
E 9
		r->n = 1;
I 9
		/* set range: x--x */
E 9
		r->r[0].from = r->r[0].to = x;
	}
}

D 9
void print_range_list(FILE *log, char *caption,range_ptr r)
E 9
I 9
void print_range_list(FILE *log, /* log file */
							 char *caption, /* caption for the log file */
							 range_ptr r) /* range list to print */
E 9
{
D 9
	int	i,nc = 0;
E 9
I 9
	int	i,nc = 0 /* track line length */;
E 9

	nc = fprintf (log,"%s ",caption);
	for (i = 0; i < r->n; i++){
D 11
		if(i)nc += fprintf(log,", ");
E 11
I 11
		if(i)nc += fprintf(log,", "); /* add a comma if more */
E 11
D 9
		if (nc > 50){
E 9
I 9
		if (nc > 50){ /* time for a new line */
E 9
			nc = 0;
			fprintf (log,"\n");
		}
		if (r->r[i].from == r->r[i].to)
I 9
			/* range beginning and ending points are the same */
E 9
			nc += fprintf (log,"%ld",r->r[i].from);
		else nc += fprintf (log,"%ld-%ld",r->r[i].from,r->r[i].to);
	}
	if (r->is_more) fprintf (log,". . . + %ld more\n",r->is_more);
	else fprintf (log,"\n");
}


/*****************************************************************
E 8
Start a logfile. If the logfile can't be opened use stdout
	name -- name for the logfile
I 10
	access -- "w" create new file, "a" append to old file
E 10
	comment -- Comment entry for log file
	stats[0] -- SCCS entry for program
	stats[1] -- date program compiled
	stats[2] -- time program compiled
I 8
	np -- number of command line parameters
E 8
	p[0] -- program name
	p[1] -- test case name
	p[2] -- computer host hame
*****************************************************************/
D 8
FILE	*log_open(char *name, char *comment, char **stats, char **p)
E 8
I 8
D 10
FILE	*log_open(char *name, char *comment, char **stats, int np, char **p)
E 10
I 10
FILE	*log_open(char *name, char *access, char *comment, char **stats,
	int np, char **p)
E 10
E 8
{
	FILE	*log;
I 8
	int	  i;
E 8

I 9
	/* If no comment string then prompt to insert a log floppy and type
	a comment for the log file. If there is a comment already (i.e., from
	the command line, then use the floppy disk in the drive for the log file */
E 9
	if (strlen(comment) == 0){
		printf ("Insert a log disk, type a descriptive comment and press ENTER\n");
		gets(comment);
	}
D 10
	log = fopen (name,"w");
E 10
I 10
	log = fopen (name,access);
E 10
D 9
	if (log == NULL) log = stdout;
E 9
I 9
	if (log == NULL) log = stdout; /* use stdout if no floppy */
E 9
	fprintf (log,"%s %s\ncompiled on %s at %s\n",p[0],stats[0],stats[1],stats[2]);
D 9
	fprintf (log,"%s\n",SCCS_Z);
I 8
	fprintf (log,"cmd:");
E 9
I 9
	fprintf (log,"%s\n",SCCS_Z); /* log support lib and header file version */
	fprintf (log,"cmd:"); /* copy command line to log file */
E 9
	for (i = 0; i < np; i++) fprintf (log," %s",p[i]);
	fprintf (log,"\n");
E 8
	fprintf (log,"TEST %s HOST %s\nComment: %s\n",p[1],p[2],comment);
	return log;
}


/*****************************************************************
Compute elapsed time and close a log file
*****************************************************************/
D 9
void log_close (FILE *log,time_t from)
E 9
I 9
void log_close (FILE *log, /* log file */
					 time_t from /* time program started running */)
E 9
{
D 9
	time_t	till;
	unsigned long et,tmin,min,sec,hours;
E 9
I 9
	time_t	till; /* time program finished (actually time log_close called) */
	unsigned long et, /* elapsed time (program run time: seconds of wall clock) */
					  tmin, /* total minutes running */
					  min, /* minutes for elapsed time after whole hours deducted */
					  sec, /* seconds of elapsed run time after hours & minutes */
					  hours; /* hours of elapsed time */
E 9

D 9
	time(&till);
	et = till - from;
	tmin = et/60;
	sec = et%60;
	hours = tmin/60;
	min = tmin%60;
E 9
I 9
	time(&till); /* get current time */
	et = till - from; /* elapsed time in seconds */
	tmin = et/60; /* elapsed time in minutes */
	sec = et%60; /* fraction of last minute in seconds */
	hours = tmin/60; /* hours elapsed time */
	min = tmin%60; /* fraction of last hour in whole minutes */
E 9
   
	fprintf (log,"run start %s",ctime(&from));
	fprintf (log,"run finish %s",ctime(&till));

	fprintf (log,"elapsed time %ld:%ld:%ld\n",hours,min,sec);
	fprintf (log,"Normal exit\n"); 

	printf ("elapsed time %ld:%ld:%ld\n",hours,min,sec);
	printf ("Normal exit\n");
}


/*****************************************************************
D 9
print disk geometry for a disk
E 9
I 9
print disk geometry for a disk described on disk_control_ptr d
E 9
*****************************************************************/
E 7
void print_dcb(disk_control_ptr d)
{
	printf ("Drive 0x%X %s \n",d->drive,d->use_bios_x?"Use extensions":
		"No extensions");
D 7
		printf ("int 13  bios  %04ld/%03ld/%02ld\n",
E 7
I 7
		printf ("Interrupt 13  bios  %04ld/%03ld/%02ld (max cyl/hd values)\n",
E 7
			d->logical_disk.cylinder,
			d->logical_disk.head,
			d->logical_disk.sector);
D 7
		printf ("INT 13 xbios %05ld/%03ld/%02ld\n",
E 7
I 7
		printf ("Interrupt 13  ext  %05ld/%03ld/%02ld (number of cyl/hd)\n",
E 7
			d->disk_max.cylinder,
			d->disk_max.head,
			d->disk_max.sector);
D 7
		printf ("%ld total sectors on disk\n",d->n_sectors);
E 7
I 7
		printf ("%ld total sectors accessible via BIOS\n",d->n_sectors);
E 7

}
I 7
/*****************************************************************
Record information about a disk to a log file
I 9
	Type of BIOS: Legacy or extended
	Disk geometry reported by Legacy BIOS: int 13/cmd 8 (max values)
	Disk geometry reported by XBIOS: int 13/cmd 48 (number of values)
	For IDE disks connected to a standard IDE controler:
		Disk Model number
		Disk Serial number
		for disks that support LBA: max number of user accessable sectors
		reported by the controler.
E 9
*****************************************************************/
D 9
void log_disk(FILE *log, char *caption, disk_control_ptr d)
E 9
I 9
void log_disk(FILE *log, /* log file */
				 char *caption, /* caption for log file */
				 disk_control_ptr d) /* disk to log information about */
E 9
{
	printf ("%s Drive 0x%X, BIOS: %s \n",caption,
		d->drive,d->use_bios_x?"Extensions Present":"Legacy");
	fprintf (log,"%s Drive 0x%x, BIOS: %s\n",caption,d->drive,
		(d->use_bios_x)?"Extensions Present":"Legacy");
		fprintf (log,"Interrupt 13  bios  %04ld/%03ld/%02ld (max cyl/hd values)\n",
			d->logical_disk.cylinder,
			d->logical_disk.head,
			d->logical_disk.sector);
		fprintf (log,"Interrupt 13  ext  %05ld/%03ld/%02ld (number of cyl/hd)\n",
			d->disk_max.cylinder,
			d->disk_max.head,
			d->disk_max.sector);
D 12
		fprintf (log,"%ld total sectors accessible via BIOS\n",d->n_sectors);
E 12
I 12
		fprintf (log,"%ld total number of sectors reported via interrupt 13 from the BIOS\n",
			d->n_sectors);
E 12
I 11
		if (d->logical_disk.sector != 63) fprintf (log,
			"WARNING: disk is not supported, it has other than 63 sectors per track.\n");
E 11
		if (d->ide_info){
D 12
			fprintf (log,"IDE disk: Model (%s) serial # (%s)\nMax sectors %lu\n",
				d->ide_info->model_no,d->ide_info->serial_no,
E 12
I 12
			fprintf (log,"IDE disk: Model (%s) serial # (%s)\n",
				d->ide_info->model_no,d->ide_info->serial_no);
			fprintf (log,"Max number of user addressable sectors reported by ATA identify device command %lu\n",
E 12
				d->ide_info->max_user_sectors);
		}
		else fprintf (log,"Non-IDE disk\n");
E 7

I 7
}

/*****************************************************************
Dump the command block for interrupt 13 command 48
*****************************************************************/
E 7
void dap_print (unsigned char dap[16])
{
	printf ("count %2X %2X\n",dap[0],dap[1]);
	printf ("B O:S %2X %2X %2X %2X (%02X%02X:%02X%02X)\n",
		dap[4],dap[5],dap[6],dap[7],dap[5],dap[4],dap[7],dap[6])/
	printf ("LBA   %2X %2X %2X %2X\n",dap[8],dap[9],dap[10],dap[11]);
}

I 7
/*****************************************************************
Give progress and completion time feedback to a user
	Intent is to call this on each pass of a loop that goes
	from "from" upto "to".
	start -- time the loop entered
	from  -- starting value of loop index
	at    -- current value of loop index
	to    -- terminal value of loop
*****************************************************************/
void feedback (time_t start, unsigned long from, unsigned long at,
					unsigned long to)
{
	time_t	now;
D 9
	unsigned long	n_feed = 20;
E 9
I 9
	unsigned long	every_pc = 5, n_feed = 100/every_pc; /* give feedback every n_feed% */
E 9
	unsigned long feed = (to - from)/n_feed;
D 9
	unsigned long et,hr,min,tmin,sec;
	float pc,fat,ns;
	static int first = 1;
E 9
I 9
	unsigned long et,hr,min,tmin,sec; /* estimated elapsed time */
	float pc, /* percent completed */
			fat,ns; /* number completed */
	static int first = 1; /* first time called switch */
E 9

	at++;
I 11
   if (feed == 0) feed = 1;
E 11
D 9
	if (first){
E 9
I 9
	if (first){/* first time through tell the user how often to
						expect feed back */
E 9
		first = 0;
D 9
		printf ("Feedback every %ld\n",feed);
E 9
I 9
		printf ("Feedback every %ld sectors (%ld%%) of %ld\n",feed,every_pc,
			to-from);
E 9
	}
	if (((at - from)%feed) && (at != to)) return;
	if (from)
		printf ("at %lu (%lu) of %lu (%lu) from %lu",
					at,at-from,to,to-from,from);
	else printf ("at %lu of %lu",at,to);

	fat = at - from;
	ns = to - from;
D 9
	pc = (100.00*fat)/ns;
E 9
I 9
	pc = (100.00*fat)/ns; /* pc = percent completed so far */
E 9
	time(&now);
D 9
	et = (now - start)*(ns - fat)/fat;
E 9
I 9
	et = (now - start)*(ns - fat)/fat; /* et estimates time remaining */
E 9
	tmin = et/60;
	hr = tmin/60;
	min = tmin%60;
	sec = et%60;

D 9
	printf (" %3.0f%%    %lu:%02lu:%02lu remains on %s",pc,hr,min,
E 9
I 9
	printf (" %5.1f%%    %lu:%02lu:%02lu remains on %s",pc,hr,min,
E 9
		sec,ctime(&now));
	return;
}

/*****************************************************************
Write a track (63 sectors) to disk d at address a
See the ATA BIOS extensions documents for details
*****************************************************************/

E 7
int disk_write (disk_control_ptr d, chs_addr *a)
{
	static int	error_code = 0,drive,bad_write;
	static unsigned long lba;
	static unsigned char disk_addr_packet [16];
	static unsigned int *dap_count = (unsigned int *)disk_addr_packet,
		*dap_n = (unsigned int *)&disk_addr_packet[2],
		*dap_buffer_offset = (unsigned int *)&disk_addr_packet[4],
		*dap_buffer_segment = (unsigned int *)&disk_addr_packet[6];
	static unsigned long *dap_lba = (unsigned long *)&disk_addr_packet[8],
		*dap_fill = (unsigned long *)&disk_addr_packet[12];
	static unsigned int dap_segment = FP_SEG(disk_addr_packet),
				dap_offset = FP_OFF(disk_addr_packet);


	if (d->drive == 0) return 1;
	error_code = 0;/*
	printf ("Write %d/%d/%d on drive %x\n",
		(int)a->cylinder,(int)a->head,(int)a->sector,d->drive);   */
	if (d->use_bios_x){
I 9
/*****************************************************************
Write a track (63 sectors) to disk d at address a
Using the ATA BIOS extensions
*****************************************************************/
			/* convert a to LBA */
E 9
			lba = (a->cylinder*d->disk_max.head + a->head)*63 + a->sector - 1;
			drive = d->drive;
			*dap_count = (int) 16;
I 7
			/* don't try to write past the last disk sector!!! */
E 7
D 6
			*dap_n = (int) d->valid_sectors;
E 6
I 6
			if ((lba < n_sectors(d)) && ((lba + 63) > n_sectors(d)))
					*dap_n = (int)(n_sectors(d) - lba);
			else 	*dap_n = (int) d->valid_sectors;
E 6
D 9
			*dap_buffer_offset = FP_OFF(d->buffer);
E 9
I 9
			*dap_buffer_offset = FP_OFF(d->buffer); /* data buffer address */
E 9
			*dap_buffer_segment = FP_SEG(d->buffer);
D 9
			*dap_lba = lba;
E 9
I 9
			*dap_lba = lba;  /* disk address */
E 9
			*dap_fill = (long) 0;/*
			printf ("Write to drive %x (xbios)\n",d->drive);
			dap_print(disk_addr_packet);   */
			bad_write = 0;
			error_code = 0;
			asm {
D 9
				mov ah,0x43
E 9
I 9
				mov ah,0x43         /* set write command */
E 9
D 11
				mov al,0x0
E 11
I 11
				mov al,0x0          /* MBZ */
E 11
D 9
				mov dl,BYTE PTR drive
				mov ds,dap_segment
E 9
I 9
				mov dl,BYTE PTR drive  /* set BIOS drive number */
				mov ds,dap_segment     /* set address of command block */
E 9
				mov si,dap_offset
D 9
				int 0x13
E 9
I 9
				int 0x13               /* write to disk */
E 9
				mov BYTE PTR error_code,ah
D 9
				jnc write_ok
E 9
I 9
				jnc write_ok          /* carry flag indicates error */
E 9
			}
			bad_write = 1;
			write_ok:
	}
	else { /*
	printf ("Write %d/%d/%d on drive %x\n",
		(int)a->cylinder,(int)a->head,(int)a->sector,d->drive); */
		error_code = 0;
I 9
/*****************************************************************
Write a track (63 sectors) to disk d at address a
using the ATA Legacy BIOS
*****************************************************************/
E 9
		error_code = biosdisk (_DISK_WRITE,d->drive,(int)a->head,(int)a->cylinder,
			(int)a->sector,d->valid_sectors,d->buffer);
	}
	if (error_code && d->use_bios_x) printf ("bad write %d error code %d\n",
		bad_write,error_code);
	return error_code;
}

I 7
/*****************************************************************
Read a track from disk d at address a
*****************************************************************/
E 7
int disk_read (disk_control_ptr d, chs_addr *a)
{
	static int	error_code,drive;
	static unsigned long lba;
	static unsigned char disk_addr_packet [16];
	static unsigned int *dap_count = (unsigned int *)disk_addr_packet,
		*dap_n = (unsigned int *)&disk_addr_packet[2],
		*dap_buffer_offset = (unsigned int *)&disk_addr_packet[4],
		*dap_buffer_segment = (unsigned int *)&disk_addr_packet[6];
	static unsigned long *dap_lba = (unsigned long *)&disk_addr_packet[8],
		*dap_fill = (unsigned long *)&disk_addr_packet[12];
	static unsigned int dap_segment = FP_SEG(disk_addr_packet),
				dap_offset = FP_OFF(disk_addr_packet);


	if (d->drive == 0) return 1;
	if (d->use_bios_x){
I 9
/*****************************************************************
Read a track (63 sectors) from disk d at address a
Using the ATA BIOS extensions
*****************************************************************/
			/* convert a to LBA */
E 9
		lba = (a->cylinder*d->disk_max.head + a->head)*63 + a->sector - 1;
		drive = d->drive;
		*dap_count = (int) 16;
I 7
		/* don't try to read past the end of the disk */
E 7
D 6
		*dap_n = (int) d->valid_sectors;
E 6
I 6
		if ((lba < n_sectors(d)) && ((lba + 63) > n_sectors(d)))
			  *dap_n = (int)(n_sectors(d) - lba);
		else *dap_n = (int) d->valid_sectors;
E 6
		*dap_buffer_offset = FP_OFF(d->buffer);
		*dap_buffer_segment = FP_SEG(d->buffer);
		*dap_lba = lba;
		*dap_fill = (long) 0;
		error_code = 0;
		asm {
D 9
			mov ah,0x42
			mov dl,BYTE PTR drive
			mov ds,dap_segment
E 9
I 9
			mov ah,0x42          /* set read command */
			mov dl,BYTE PTR drive  /* set BIOS drive number */
			mov ds,dap_segment    /* set address of command block */
E 9
			mov si,dap_offset
D 9
			int 0x13
E 9
I 9
			int 0x13             /* read */
E 9
			mov BYTE PTR error_code,ah
		}
	}
	else {
I 9
/*****************************************************************
Read a track (63 sectors) from disk d at address a
using the ATA Legacy BIOS
*****************************************************************/
E 9
			error_code = biosdisk (_DISK_READ,d->drive,(int)a->head,(int)a->cylinder,
				(int)a->sector,d->valid_sectors,d->buffer);
	}
	d->this_track.cylinder = a->cylinder;
	d->this_track.head = a->head;
   d->this_track.sector = a->sector;

	return error_code;
}

D 7

E 7
I 7
/*****************************************************************
Test for ATA BIOS extensions on drive
I 9
See BIOS Enhanced Disk Drive Services (EDD) for details
E 9
*****************************************************************/
E 7
int c13(int drive)
{
  int carry;
  int drive_number=drive;
  int   x13 = 0;

  unsigned int ah_register = 0;
  unsigned int bx_register = 0;
  unsigned int cx_register = 0;
	 carry=0;

	 asm{
D 11
		mov ah,0x41
E 11
I 11
		mov ah,0x41               /* test for extensions command */
E 11
		mov bx,0x55aa
		mov dl,BYTE PTR drive_number
		INT 0x13

		mov BYTE PTR ah_register,ah
		mov WORD PTR bx_register,bx
		mov WORD PTR cx_register,cx

		jnc carry_flag_not_set   /* Jump if the carry flag is clear  */
	  }                         /* If the carry flag is clear, then */
D 8
				/* the extensions exist.            */
E 8
I 8
										/* the extensions exist.            */
E 8
	 carry=1;


	 carry_flag_not_set:
	 if( (carry==0) && (bx_register==0xaa55))
		  x13 = 1;

		 return x13;
}

I 7
/*****************************************************************
Assemble a number in pieces
*****************************************************************/
E 7
unsigned long Decimal_Number(unsigned long hex1, unsigned long hex2,
			 unsigned long hex3, unsigned long hex4)
{
  return((hex1) + (hex2*256ul) +
	(hex3*65536ul) + (hex4*16777216ul));
}
I 7
/*****************************************************************
Get geometry for a disk using ATA BIOS extensions
*****************************************************************/
E 7
int Get_Hard_Drive_Parameters(int physical_drive,
D 11
	unsigned long *cylinders,
	unsigned long *heads,
D 9
	unsigned long *sectors,unsigned long  *tsl,
E 9
I 9
	unsigned long *sectors,
	unsigned long *tsl,
E 11
I 11
	unsigned long *cylinders, /* number of .. */
	unsigned long *heads,     /* number of .. */
	unsigned long *sectors,   /* number of .. */
	unsigned long *tsl,       /* number of .. */
E 11
E 9
	unsigned long *tsh)
{
  static unsigned char result_buffer[26];
  static unsigned int result_buffer_segment=FP_SEG(result_buffer);
  static unsigned int result_buffer_offset=FP_OFF(result_buffer);
  int error_code=0;
  int i;

  for (i = 1; i < 26; i++) result_buffer[i] = 0;
  result_buffer[0]=26;
  result_buffer_segment=FP_SEG(result_buffer);
  result_buffer_offset=FP_OFF(result_buffer);


	 asm {
		mov ah,0x48
		mov dl,BYTE PTR physical_drive
		mov ds,result_buffer_segment
		mov si,result_buffer_offset
		int 0x13

		mov BYTE PTR error_code,ah
		}

	 *cylinders=Decimal_Number(result_buffer[4],result_buffer[5],
		result_buffer[6],result_buffer[7]);
    *heads=Decimal_Number(result_buffer[8],result_buffer[9],
D 9
		result_buffer[10],result_buffer[11])-1;
E 9
I 9
		result_buffer[10],result_buffer[11]);
E 9
	 *sectors=Decimal_Number(result_buffer[12],result_buffer[13],
		result_buffer[14],result_buffer[15]);
		*tsl =   Decimal_Number(result_buffer[16],result_buffer[17],
		result_buffer[18],result_buffer[19]);
		*tsh =   Decimal_Number(result_buffer[20],result_buffer[21],
D 9
		result_buffer[22],result_buffer[23]);
E 9
I 9
		result_buffer[22],result_buffer[23]); /* should be zero */
E 9

  return(error_code);
}
D 7

E 7
I 7
 
/*****************************************************************
Open a disk, return a pointer to a disk_control_rec
The disk_control_rec contains a description of the disk ...
	legacy BIOS geometry
	extended BIOS geometry
	IDE or not
	number of sectors addressable
	number of sectors reported by BIOS
	IDE disk model and serial numbers
*****************************************************************/
E 7
D 8
disk_control_ptr open_disk (int drive, int try_ext, int *err)
E 8
I 8
disk_control_ptr open_disk (int drive, int *err)
E 8
{
	static unsigned char b[600];
	unsigned long cylinders = 0;
	unsigned long heads = 0;
	unsigned long sectors = 0;
	unsigned long tsl,tsh;
	disk_control_ptr d;
	int	ec;
D 9
    
E 9
I 9

	/* Get Legacy BIOS disk geometry */
E 9
	ec = biosdisk (GET_DISK_PARMS,drive,0,0,0,0,b);
I 7
	printf ("BIOS get_disk_parms %d\n",ec);
E 7
   *err = 0;
	if (ec){*err = ec; return NULL;}
	d = (disk_control_ptr) malloc (sizeof(disk_control_block));
D 9
	if (d == NULL){*err = 3000; return NULL;}
E 9
I 9
	if (d == NULL){*err = 3000; return NULL;} /* out of memory */
E 9
	d->logical_disk.head = b[3];
	d->logical_disk.sector = b[0]&0x3f;
	d->logical_disk.cylinder = ((b[0]&0xC0)<<2)|b[1];

	d->valid_sectors = 63;
D 7
	d->use_bios_x = c13(drive) && try_ext;
E 7
I 7
D 8
	d->use_bios_x = c13(drive)/* && try_ext */;
E 8
I 8
D 9
	d->use_bios_x = c13(drive);
E 9
I 9
	d->use_bios_x = c13(drive); /* test for XBIOS */
E 9
E 8
	printf ("Open disk 0x%x, of %d disks, BIOS: %s\n",drive,b[2],
		(d->use_bios_x)?"Extensions Present":"Legacy");
E 7
	d->drive = drive;
I 7
D 9
	d->ide_info = probe_ide(drive);
E 9
I 9
	d->ide_info = probe_ide(drive); /* get model and serial numbers */
E 9
	if (d->ide_info) printf ("Open %s %s %lu on drive 0x%x\n",
		d->ide_info->model_no,d->ide_info->serial_no,
		d->ide_info->max_user_sectors,drive);
D 9
	else printf ("Open SCSI disk on drive 0x%x\n",drive);
E 9
I 9
	else printf ("Open non-IDE (SCSI?) disk on drive 0x%x\n",drive);
E 9
E 7
	if (d->use_bios_x){
D 9
		ec = Get_Hard_Drive_Parameters(drive,
E 9
I 9
		ec = Get_Hard_Drive_Parameters(drive, /* get XBIOS disk geometry */
E 9
		&cylinders,&heads,&sectors,&tsl,&tsh);
D 7
		if (ec){*err = 1000 + ec; return NULL;}
E 7
I 7
		if (ec){*err = 1000 + ec;
			printf ("Disk open failed to get extended drive parameters");
			 return NULL;}
E 7
		d->disk_max.cylinder = cylinders;
		d->disk_max.head = heads;
		d->disk_max.sector = sectors;
		d->n_sectors = tsl;
		if (tsh){*err = 2000; return NULL;} /* really big disk */
I 6
		if ((cylinders == 0) || (heads == 0) || (sectors == 0)){
I 9
			/* some SCSI cards return zeros in the geometry field so
				we have to fake it */
E 9
			d->disk_max = d->logical_disk;
			d->disk_max.cylinder++;
			d->disk_max.head++;
		}
E 6
	}
D 9
	else {
E 9
I 9
	else { /* Legacy BIOS only (no XBIOS) so, fake XBIOS */
E 9
		d->disk_max = d->logical_disk;
		d->disk_max.cylinder++;
		d->disk_max.head++;
		d->n_sectors = d->disk_max.cylinder*d->disk_max.head*63;
	}
	d->this_track.cylinder = 0;
	d->this_track.head = 0;
	d->this_track.sector = 1;
	ec = disk_read (d,&d->this_track);
I 7
	*err = ec;
I 9
	/* if disk does not support LBA, fake it */
E 9
I 8
	if  (d->ide_info) if(d->ide_info->max_user_sectors < d->n_sectors)
		d->ide_info->max_user_sectors = d->n_sectors;
E 8
E 7
	return d;
}

I 7
/*****************************************************************
D 8
Convert LBA to C/H/S
E 8
I 8
Convert LBA value to C/H/S
E 8
*****************************************************************/
E 7
void lba_to_chs (disk_control_block *d,unsigned long lba, chs_addr *a)
{
	unsigned long track = lba/63;
	a->sector = lba%63 + 1;
	a->head = track%n_heads(d);
	a->cylinder = track/n_heads(d);
}

I 7
/*****************************************************************
Read sector "lba" of disk d set b to point to start of sector
I 9
(An easier interface than C/H/S)
E 9
*****************************************************************/
E 7
int read_lba (disk_control_ptr d,unsigned long lba, unsigned char **b)
{
	chs_addr	a;

	*b = (unsigned char *)&(d->buffer[lba%63][0]);
D 11
	lba_to_chs (d,lba,&a);
	if ((a.cylinder == d->this_track.cylinder) &&
		(a.head == d->this_track.head)) return 0;
E 11
I 11
	lba_to_chs (d,lba,&a);  /* convert lba to CHS */
	if ((a.cylinder == d->this_track.cylinder) && /* don't bother to do */
		(a.head == d->this_track.head)) return 0;  /* the read if already done */
E 11
I 5
	a.sector = 1;
E 5
D 11
	return disk_read(d,&a);
E 11
I 11
	return disk_read(d,&a); /* need to do the read */
E 11

}

I 7
/*****************************************************************
Get a nested partition table entry
*****************************************************************/
E 7
pte_ptr get_sub_part (disk_control_block *d,unsigned long start,
	unsigned long base,int *status)
{
	mbr_sector *mbr;
	pte_ptr	p,q;
	int 		i;
	unsigned long at = base + start;
	chs_addr a;

	lba_to_chs(d,at,&a);
	*status = disk_read (d,&a);
	mbr = (mbr_sector *)(&(d->buffer));
	if (*status) return NULL;
	if (mbr->sig == 0xAA55) {
		p = q = (pte_ptr) malloc (sizeof(pte_rec));
		for (i = 0; i < 2; i++){
			p->is_boot = mbr->pe[i].bootid;
			p->type = mbr->pe[i].type_code;
			p->lba_start = mbr->pe[i].starting_lba_sector;
			p->lba_length = mbr->pe[i].n_sectors;
			p->start.cylinder = mbr->pe[i].start_cylinder |
				 ((mbr->pe[i].start_sector&0xC0)<<2);
			p->start.head =  mbr->pe[i].start_head;
			p->start.sector = mbr->pe[i].start_sector & 0x3F;
			p->end.cylinder = mbr->pe[i].end_cylinder |
				 ((mbr->pe[i].end_sector&0xC0)<<2);
			p->end.head =  mbr->pe[i].end_head;
			p->end.sector = mbr->pe[i].end_sector & 0x3F;
			if (i == 0){
				p->next = (pte_ptr) malloc (sizeof(pte_rec));
				p = p->next;
			}
			else {
				if ((mbr->pe[1].type_code == 0x05) ||
					 (mbr->pe[1].type_code == 0x0F) ||
					 (mbr->pe[1].type_code == 0x0C)){
					p->next = get_sub_part(d,p->lba_start,base,status);
				}
				else p->next = NULL;
			}
		}
	}
	else return NULL;
	return q;
}

I 7
/*****************************************************************
Get the partition table for disk d and save in pt
*****************************************************************/
E 7
int get_partition_table(disk_control_block *d,pte_ptr pt)
{
	mbr_sector *mbr;
	chs_addr  boot = {0ul,0ul,1ul};
	int	status,i;

	status = disk_read (d,&boot);
	mbr = (mbr_sector *) &(d->buffer);
	if (status) return status;
	if (mbr->sig != 0xAA55) return -1;
	else {
		for (i = 0; i < 4; i++){
D 8
			status = disk_read (d,&boot);
E 8
I 8
			status = disk_read (d,&boot); /* really needed */
E 8
			pt[i].is_boot = mbr->pe[i].bootid;
			pt[i].type = mbr->pe[i].type_code;
			pt[i].lba_start = mbr->pe[i].starting_lba_sector;
			pt[i].lba_length = mbr->pe[i].n_sectors;
			pt[i].start.cylinder = mbr->pe[i].start_cylinder |
				 ((mbr->pe[i].start_sector&0xC0)<<2);
			pt[i].start.head =  mbr->pe[i].start_head;
			pt[i].start.sector = mbr->pe[i].start_sector & 0x3F;
			pt[i].end.cylinder = mbr->pe[i].end_cylinder |
				 ((mbr->pe[i].end_sector&0xC0)<<2);
			pt[i].end.head =  mbr->pe[i].end_head;
			pt[i].end.sector = mbr->pe[i].end_sector & 0x3F;
			if ((mbr->pe[i].type_code == 0x05) ||
				 (mbr->pe[i].type_code == 0x0F) ||
				 (mbr->pe[i].type_code == 0x0C)){
					pt[i].next = get_sub_part (d,0ul,pt[i].lba_start,&status);
					if (status) return status;
			}
			else {
				pt[i].next = NULL;
			}
		 }

	}
	return status;

}

I 7
/*****************************************************************
Map common partition type codes to an ASCII string
*****************************************************************/
E 7
char *partition_type(unsigned char code)
{
	char	*pt;

	if (code == 0) pt = "empty entry";
	else if ((code == 0x05) ||
				(code == 0x0F) ||
				(code == 0x0C)) pt = "extended";
	else if ((code == 0x04) ||
				(code == 0x06) ||
				(code == 0x0E)) pt = "Fat16";
D 3
	else if ((code == 0x0B)) pt = "Fat32";
	else if ((code == 0x0C)) pt = "Fat32 (LBA)";
E 3
I 3
	else if ((code == 0x0B)) pt = "Fat32"; 
	else if ((code == 0x01)) pt = "Fat12";
E 3
	else if ((code == 0x07)) pt = "NTFS";
	else if ((code == 0x82)) pt = "Linux swap";
	else if ((code == 0x81) ||
				(code == 0x83)) pt = "Linux";
	else pt = "other";
	return pt;
}
D 7

void print_partition_table(FILE *log,pte_rec *p, int index)
E 7
I 7
 
/*****************************************************************
Print a partition table
	full=1 -- print extended table entries too
*****************************************************************/
D 9
void print_partition_table(FILE *log,pte_rec *p, int index, int full)
E 9
I 9
void print_partition_table(FILE *log,/* output file: either log file or stdout */
						pte_rec *p, /* partition table */
						int index, /* print the index numbers */
						int full) /* print all table entries, else omit empty entries
										 and extended partition entries */
E 9
E 7
{
	int	i,j = 0;
	char	type_code;
	pte_ptr	sub;

D 7
	
E 7
I 7
D 9

E 9
I 9
	if (index) fprintf (log," N ");
	fprintf (log,"  %-9s %-9s %-11s %-11s boot Partition type\n",
   	"Start LBA","Length","Start C/H/S","End C/H/S");
E 9
E 7
	for (i = 0; i < 4; i++){
		if ((p[i].type == 0x05) ||
			 (p[i].type == 0x0F) ||
			 (p[i].type == 0x0C)) type_code = 'X';
		else type_code = 'P';
D 7
		if (index) fprintf (log,"%2d ",j++);
		fprintf (log,"%c %09ld %09ld %04ld/%03ld/%02ld %04ld/%03ld/%02ld %4s %02X",
			type_code,
			p[i].lba_start,p[i].lba_length,
			p[i].start.cylinder,p[i].start.head,p[i].start.sector,
			p[i].end.cylinder,p[i].end.head,p[i].end.sector,
			p[i].is_boot?"Boot":"",p[i].type);
		fprintf (log," %s",partition_type(p[i].type));
		fprintf(log,"\n");
E 7
I 7
		j++;
		if (full || ((type_code != 'X') && (p[i].type))){
			if (index) fprintf (log,"%2d ",j);
			fprintf (log,"%c %09ld %09ld %04ld/%03ld/%02ld %04ld/%03ld/%02ld %4s %02X",
				type_code,
				p[i].lba_start,p[i].lba_length,
				p[i].start.cylinder,p[i].start.head,p[i].start.sector,
				p[i].end.cylinder,p[i].end.head,p[i].end.sector,
				p[i].is_boot?"Boot":"",p[i].type);
			fprintf (log," %s",partition_type(p[i].type));
			fprintf(log,"\n");
		}
E 7
		sub = p[i].next;
		while(sub){
			if ((sub->type == 0x05) ||
				 (sub->type == 0x0F) ||
				 (sub->type == 0x0C)) type_code = 'x';
			else type_code = 'S';
D 7
		if (index) fprintf (log,"%2d ",j++);
			fprintf (log,"%c %09ld %09ld %04ld/%03ld/%02ld %04ld/%03ld/%02ld %4s %02X",
				type_code,
				sub->lba_start,sub->lba_length,
				sub->start.cylinder,sub->start.head,sub->start.sector,
				sub->end.cylinder,sub->end.head,sub->end.sector,
				sub->is_boot?"Boot":"",sub->type);
			fprintf (log," %s",partition_type(sub->type));
			fprintf(log,"\n");
E 7
I 7
			j++;
			if (full || ((type_code != 'x') && (sub->type))){
				if (index) fprintf (log,"%2d ",j);
					fprintf (log,"%c %09ld %09ld %04ld/%03ld/%02ld %04ld/%03ld/%02ld %4s %02X",
						type_code,
						sub->lba_start,sub->lba_length,
						sub->start.cylinder,sub->start.head,sub->start.sector,
						sub->end.cylinder,sub->end.head,sub->end.sector,
						sub->is_boot?"Boot":"",sub->type);
					fprintf (log," %s",partition_type(sub->type));
					fprintf(log,"\n");
			}
E 7
			sub = sub->next;
		}
	}
I 9
	if (full) {
		fprintf (log,"P primary partition (1-4)\n"); 
		fprintf (log,"S secondary (sub) partition\n");
		fprintf (log,"X primary extended partition (1-4)\n");
		fprintf (log,"x secondary extended partition\n");
	}
E 9
}

E 1
