h01548
s 00000/00000/00115
d D 3.1 01/10/11 12:40:24 jimmy 9 8
c Increment Version number to 3.1
e
s 00002/00000/00113
d D 2.7 01/07/20 09:01:49 jimmy 8 7
c add "cannot access disk" message to logfile
e
s 00001/00001/00112
d D 2.6 01/07/17 17:30:37 jimmy 7 6
c print partition number to log file
e
s 00004/00002/00109
d D 2.5 01/07/10 11:22:14 jimmy 6 5
c add option for overwrite logfile; make default action append to logfile
e
s 00006/00006/00105
d D 2.4 01/06/12 13:58:04 jimmy 5 4
c making error message consistent
e
s 00048/00036/00063
d D 2.3 01/05/15 08:58:42 jimmy 4 3
c revisions for batch exec, commentary and minor revisions
e
s 00002/00001/00097
d D 2.2 00/10/02 09:08:27 jimmy 3 2
c minor updates, comments
e
s 00000/00000/00098
d D 2.1 00/09/27 13:56:22 jimmy 2 1
c switch from sector to track based I/O
e
s 00098/00000/00000
d D 1.1 00/09/27 13:56:06 jimmy 1 0
c date and time created 00/09/27 13:56:06 by jimmy
e
u
U
f e 0
t
T
I 1
D 4
static char *SCCS_ID = "%Z% Version %I% Created %G% at %U%";
E 4
I 4
static char *SCCS_ID[] = {"%Z% %M% Version %I% Created %G% at %U%",
	__DATE__,__TIME__};
E 4
/******************************************************************************
The software provided here is released by the National
Institute of Standards and Technology (NIST), an agency of
the U.S. Department of Commerce, Gaithersburg MD 20899,
USA.  The software bears no warranty, either expressed or
implied. NIST does not assume legal liability nor
responsibility for a User's use of the software or the
results of such use.

Please note that within the United States, copyright
protection, under Section 105 of the United States Code,
Title 17, is not available for any work of the United
States Government and/or for any works created by United
States Government employees. User acknowledges that this
software contains work which was created by NIST employees
and is therefore in the public domain and not subject to
copyright.  The User may use, distribute, or incorporate
this software provided the User acknowledges this via an
explicit acknowledgment of NIST-related contributions to
the User's work. User also agrees to acknowledge, via an
explicit acknowledgment, that any modifications or
alterations have been made to this software before
redistribution.
******************************************************************************/
I 3
/***** Author: Dr. James R. Lyle, NIST/SDCT/SQG ****/
E 3
# include <stdio.h>
# include <string.h>
# include "zbios.h"   
# include <malloc.h>
I 4
# include <time.h>
E 4

I 4
/******************************************************************************
Print a partition table
	open disk
	open logfile
	log disk
	print partition table
	close log
******************************************************************************/
E 4

D 4
void print_help(char *p)
E 4
I 4

void print_help(char *p /* program name */)
E 4
{
	static int been_here = 0;
	if (been_here) return;
	been_here = 1;

D 4
	printf ("Usage: %s /[s|m]\n",p);
	printf ("/m\tUse master drive (default)\n");
	printf ("/s\tUse slave drive\n");
	printf ("/bios\tUse int 13 bios without extensions (default)\n");
D 3
	printf ("/xbios\tUse use bios extensions drive\n");
E 3
I 3
	printf ("/xbios\tUse int 13 bios extensions\n");
E 4
I 4
	printf ("Usage: %s test-case host drive [/options]\n",p);
	printf ("/all\tList extended partitions\n");
	printf ("/comment \" ... \"\tComment for log file\n");
I 6
	printf ("/new_log\tStart a new log file (default is append to old log file)\n");
E 6
E 4
E 3
	printf ("/?\tPrint this option list\n");
}

D 4
main (int np, char **p)
E 4
I 4
int main (int np, char **p)
E 4
{
	int	drive = 0x80;
D 4
	int	try_ext = 0, help = 0;
	int	status,i;
E 4
I 4
	int	help = 0;
	int	status,i,all = 0;
E 4
	static disk_control_block *dd;
	pte_rec		pt[4];
	FILE		*log;
D 4
	char	comment [80];
E 4
I 4
D 6
	char	comment [80] = "",log_name[20];
E 6
I 6
	char	comment [80] = "",log_name[20],*access = "a";
E 6
	time_t from;
E 4

	_stklen = 2*_stklen;
I 4
	time(&from);
E 4
	printf ("\n%s compiled at %s on %s\n", p[0],
		__TIME__,__DATE__);

D 4
	for (i = 1; i < np; i++){
		if (strcmp(p[i],"/s") == 0) drive = 0x81;
		else if (strcmp (p[i],"/m")== 0) drive = 0x80;
		else if (strcmp (p[i],"/?") == 0) help = 1;
		else if (strcmp (p[i],"/bios")== 0) try_ext = 0;
		else if (strcmp (p[i],"/xbios")== 0) try_ext = 1;
		else help = 1;
		if (help){
			print_help(p[0]);
			return 0;
E 4
I 4
/* get command line */
	if (np < 4) help = 1;
	else sscanf (p[3],"%x",&drive);
	for (i = 4; i < np; i++){
		if (strcmp(p[i],"/all") == 0) all = 1;
I 6
		else if (strcmp (p[i],"/new_log")== 0) access = "w";
E 6
		else if (strcmp(p[i],"/comment") == 0){
			i++;
			if (i < np) strcpy (comment,p[i]);
			else help = 1;
E 4
		}
I 4
		else help = 1;
E 4
	}
I 4
	if (help){
		print_help(p[0]);
		return 0;
	}
E 4
	status = 1;
D 4
	printf ("Insert log floppy, type log comment and press return\n");
	gets(comment);
	if (drive == 0x80) log = fopen("a:\mpt.txt","w");
	else log = fopen("a:\spt.txt","w");
	if (log == NULL) log = stdout;
E 4
I 4
	printf ("Drive 0x%x\n",drive);
/* open log file */
	sprintf (log_name,"A:\\pt%xlog.txt",drive);
D 6
	log = log_open (log_name,comment,SCCS_ID,np,p);
E 6
I 6
	log = log_open (log_name,access,comment,SCCS_ID,np,p);
E 6
E 4

D 4
	dd = open_disk (drive,try_ext,&status);
E 4
I 4
/* open and log disk */
	dd = open_disk (drive,&status);
I 5
	if (status) {
		printf ("%s could not access drive %X, status code %d\n",p[0],
I 8
			drive,status); 
		fprintf (log,"%s could not access drive %X, status code %d\n",p[0],
E 8
			drive,status);
		return 1;
	}
E 5
	log_disk (log,"Partition table",dd);
E 4
D 5
	printf ("Open disk status code %d\n",status);
D 4
	print_dcb(dd);
E 4
I 4
	if (status) return 1;
E 5
/* get and print partition table */
E 4
	status = get_partition_table(dd,pt);
D 4
	if (status == 0)print_partition_table(stdout,pt,1);
E 4
I 4
	if (status == 0)print_partition_table(stdout,pt,1,all);
E 4
	else if (status == -1) printf ("No partition table signature\n");
	else printf ("Error reading partition table, code %d\n",status);
D 4
	fprintf (log,"%s %s\ncompiled %s at %s with BCC version %x\n",
		p[0],SCCS_ID,__DATE__,__TIME__,__BORLANDC__);
	fprintf (log,"%s\n",SCCS_Z);
	fprintf (log,"Comment: %s\n",comment);
E 4
D 5
	if (status){
		printf ("error code %d in %s\n",status,p[0]);
	}
E 5
D 4
	else printf ("Normal exit %s\n",p[0]);
	if (status == 0)print_partition_table(log,pt,0);
E 4
I 4
D 7
	if (status == 0)print_partition_table(log,pt,0,all);
E 7
I 7
	if (status == 0)print_partition_table(log,pt,1,all);
E 7
E 4
D 5
	if (status)fprintf (log,"Error reading partition tab\n");
E 5
I 5
	if (status)fprintf (log,"Error reading partition table, code %d\n",status);
E 5
D 4
	else fprintf (log,"Normal exit %s\n",p[0]);
E 4
I 4
	log_close (log,from);
E 4
	return 0;
}
E 1
