/******************************************************************************
The software provided here is released by the National
Institute of Standards and Technology (NIST), an agency of
the U.S. Department of Commerce, Gaithersburg MD 20899,
USA.  The software bears no warranty, either expressed or
implied. NIST does not assume legal liability nor
responsibility for a User's use of the software or the
results of such use.

Please note that within the United States, copyright
protection, under Section 105 of the United States Code,
Title 17, is not available for any work of the United
States Government and/or for any works created by United
States Government employees. User acknowledges that this
software contains work which was created by NIST employees
and is therefore in the public domain and not subject to
copyright.  The User may use, distribute, or incorporate
this software provided the User acknowledges this via an
explicit acknowledgment of NIST-related contributions to
the User's work. User also agrees to acknowledge, via an
explicit acknowledgment, that any modifications or
alterations have been made to this software before
redistribution.
******************************************************************************/
static char *SCCS_ID[3] = {"@(#) sechash.cpp Version 1.1 created 12/18/01 at 13:51:30",
			__DATE__,__TIME__};
/***** Author: Dr. James R. Lyle, NIST/SDCT/SQG ****/
# include <stdio.h>
# include <dos.h>
# include "zbios.h"
# include <string.h>
# include "sha.h"
# include <time.h>
# include <malloc.h>
/*****************************************************************
Compute a SHA-1 hash of a disk subset and write the result to a logfile
	The execution model is to run diskhash to compute a (before)
	hash, use some program to access the disk, and run diskhash
	again to compute an (after) hash. If the two hash values are the
	same then the access program did not change the disk. If the
	hash values differ, then the access program changed the disk.

High level design:
	Decode command line
	open disk
	init hash
	for each disk sector
		read sector
		update hash
	log final hash value

*****************************************************************/

void print_help(char *p)
{
	static int been_here = 0;
	if (been_here) return;
	been_here = 1;

	printf ("Usage: %s test-case host drive [/options]\n",p);
	printf ("/before\tName logfile hashblog.txt (before test)\n");
	printf ("/comment \" ... \"\tGive comment on command line\n");
	printf ("/after\tName logfile hashalog.txt (after test)\n");
	printf ("\tNote that one of /before, /after or /log is required\n");
	printf ("/new_log\tStart a new log file (default is append to old log file)\n");
	printf ("/log log_file_name\tName the logfile: log_file_name\n");
	printf ("/first nnn\tStart hashing at sector LBA nnn\n");
	printf ("/last nnn\tHash sector LBA nnn and then stop\n");
	printf ("\tif nnn < 0 then omit the last nnn disk sectors from the hash\n");
	printf ("/?\tPrint this option list\n");
}
main (int np, char **p)
{
	int	drive = 0x80;
	int	help = 0;
	int	status,i,before = 0;
	static disk_control_block *dd;
	static unsigned long lba = 0,ns,first = 0,max_sector;
	static long last = 0;
	static SHA_CTX context;
	static time_t from,start_time;
	FILE *log;
	int	is_debug = 0;
	static char comment[200] = "",*access = "a",*log_file_name;
	unsigned char *buffer;

	time(&from);
	_stklen = 2*_stklen;
	printf ("\n%s compiled at %s on %s\n", p[0],
		__TIME__,__DATE__);

	if (np < 4) help = 1;
	else sscanf (p[3],"%x",&drive);
	for (i = 4; i < np; i++){
		if (strcmp (p[i],"/?") == 0) {help = 1; break;}
		else if (strcmp (p[i],"/debug")== 0) is_debug = 1;
		else if (strcmp (p[i],"/before")== 0) {
			before++;
			log_file_name = "A:\\hashblog.txt";
		}
		else if (strcmp (p[i],"/after")== 0){
			before++;
			log_file_name = "A:\\hashalog.txt";
		}
		else if (strcmp (p[i],"/new_log")== 0) access = "w";
		else if (strcmp (p[i],"/comment")== 0){
			i++;
			if (i >= np){
				printf ("%s: /comment option requires a comment\n",p[0]);
				help = 1;
			} else strcpy (comment,p[i]);
		}
		else if (strcmp (p[i],"/first")== 0){
			i++;
			if (i >= np){
				printf ("%s: /first option requires a sector number\n",p[0]);
				help = 1;
			} else {
				status = sscanf (p[i],"%lu",&first);
				if (status != 1){printf ("/first Sector number [%s] not valid\n",
					p[i]);
					help = 1;
				}
			}
		} 
		else if (strcmp (p[i],"/last")== 0){
			i++;
			if (i >= np){
				printf ("%s: /last option requires a sector number\n",p[0]);
				help = 1;
			} else {
				status = sscanf (p[i],"%lu",&last);
				if (status != 1){printf ("/last Sector number [%s] not valid\n",
					p[i]);
					help = 1;
				}
			}
		} else if (strcmp (p[i],"/log")== 0){
			i++;
			if (i >= np){
				printf ("%s: /log option requires a file name\n",p[0]);
				help = 1;
			} else {
				log_file_name = p[i];
			}
		}
		else help = 1;
	}
	if ((before != 1) && (help == 0)){
		printf ("%s must select one of /before, /after or /log\n",p[0]);
		help = 1;
	}
	if (help){
		print_help(p[0]);
		return 0;
	}
	log = log_open(log_file_name,access,
					comment,SCCS_ID,np,p);
	printf ("Hashing drive 0x%2X \n",drive);
	dd = open_disk (drive,&status);

	if (status){
		printf ("%s could not access drive %x status code %d\n",
			p[0],drive,status);
		fprintf (log,"%s could not access drive %x status code %d\n",
			p[0],drive,status);
		return 1;
	}
   log_disk (log,"Hash",dd);
	SHAInit(&context);
	ns = n_sectors(dd);
	max_sector = ns - 1;
	if (last < 0) max_sector = max_sector - last;
	else if (last > 0) max_sector = last;
	time(&start_time);
	if (is_debug) ns = 1000;
	for (lba = first; lba <= max_sector; lba++){
		status = read_lba(dd,lba,&buffer);
		SHAUpdate(&context,(unsigned char *)buffer,512*8);
			/* give user feedback on progress and estimate completion */
		feedback (from, (unsigned long) 0, lba - first,ns - first);
	}
	SHAFinal(&context);
	printf ("Disk hash (%lu sectors) [%lu,%lu] = ",max_sector + 1 - first,first,
		max_sector);
	fprintf (log,"Disk hash (%lu sectors) [%lu,%lu] = ",max_sector + 1 - first,first,
		max_sector);
	for (i = 0; i < 5; i++){
		printf ("%08lX",context.H[i]);
		fprintf (log,"%08lX",context.H[i]);
	}
	printf("\n");
	fprintf(log,"\n");
	log_close (log,from);
	return 0;
}
