h48444
s 00001/00001/00325
d D 3.1 01/10/11 12:40:22 jimmy 10 9
c Increment Version number to 3.1
e
s 00007/00003/00319
d D 2.8 01/07/10 11:22:13 jimmy 9 8
c add option for overwrite logfile; make default action append to logfile
e
s 00300/00306/00022
d D 2.7 01/06/12 13:58:03 jimmy 8 7
c making error message consistent
e
s 00102/00054/00226
d D 2.6 01/05/24 14:44:44 jimmy 7 6
c add I/O error tracking for DCFL
e
s 00007/00075/00273
d D 2.5 01/04/06 14:33:23 jimmy 6 5
c fix problem with ident dev returns num sectors = 0
e
s 00089/00097/00259
d D 2.4 01/03/27 16:19:09 jimmy 5 4
c add test-case, host, drive and comment to command line
e
s 00356/00333/00000
d D 2.3 00/11/13 15:52:31 jimmy 4 3
c fix bug in feedback report for larger dst
e
s 00011/00004/00322
d D 2.2 00/10/02 09:08:25 jimmy 3 2
c minor updates, comments
e
s 00000/00000/00326
d D 2.1 00/09/27 13:44:50 jimmy 2 1
c switch to track based I/O
e
s 00326/00000/00000
d D 1.1 00/09/27 13:41:50 jimmy 1 0
c date and time created 00/09/27 13:41:50 by jimmy
e
u
U
f e 0
t
T
I 1
D 4
/******************************************************************************
The software provided here is released by the National
Institute of Standards and Technology (NIST), an agency of
the U.S. Department of Commerce, Gaithersburg MD 20899,
USA.  The software bears no warranty, either expressed or
implied. NIST does not assume legal liability nor
responsibility for a User's use of the software or the
results of such use.

Please note that within the United States, copyright
protection, under Section 105 of the United States Code,
Title 17, is not available for any work of the United
States Government and/or for any works created by United
States Government employees. User acknowledges that this
software contains work which was created by NIST employees
and is therefore in the public domain and not subject to
copyright.  The User may use, distribute, or incorporate
this software provided the User acknowledges this via an
explicit acknowledgment of NIST-related contributions to
the User's work. User also agrees to acknowledge, via an
explicit acknowledgment, that any modifications or
alterations have been made to this software before
redistribution.
******************************************************************************/
/***** Author: Dr. James R. Lyle, NIST/SDCT/SQG ****/
static char *SCCS_ID = "%Z% Version %I% Created %G% at %U%";

# include <stdio.h>
# include <dos.h>
# include "zbios.h"
# include <string.h>
# include <time.h>
# include <malloc.h>

I 3
# define N_RANGE 100
E 3
typedef struct {unsigned long from,to;} lba_range;
typedef struct {
	int	n;
D 3
	lba_range r[10];
E 3
I 3
	long is_more;
	lba_range r[N_RANGE];
E 3
	} range_list,*range_ptr;

range_ptr create_range_list(void)
{
	range_ptr	p;
	p = (range_ptr) malloc (sizeof(range_list));
	p->n = 0;
I 3
	p->is_more = 0;
E 3
	return p;
}

void add_to_range (range_ptr r, unsigned long x)
{
	int k = r->n - 1;
	if (r->n){
		if (r->r[k].to + 1 == x) r->r[k].to = x;
		else {
			k++;
D 3
			if (k >= 10) return;
E 3
I 3
			if (k >= N_RANGE){
				r->is_more = 1;
				return;
			}
E 3
			r->n++;
			r->r[k].from = r->r[k].to = x;
		}
	}
	else {
		r->n = 1;
		r->r[0].from = r->r[0].to = x;
	}
}

void print_range_list(FILE *log, range_ptr r)
{
	int	i,nc = 0;

	for (i = 0; i < r->n; i++){
		if(i)nc += fprintf(log,", ");
		if (r->r[i].from == r->r[i].to)
			nc += fprintf (log,"%ld",r->r[i].from);
		else nc += fprintf (log,"%ld-%ld",r->r[i].from,r->r[i].to);
		if (nc > 50){
			nc = 0;
			fprintf (log,"\n");
		}
	}
D 3
	fprintf (log,"\n");
E 3
I 3
	if (r->is_more) fprintf (log,". . . + %ld more\n",r->is_more);
	else fprintf (log,"\n");
E 3
}


void print_help(char *p)
{
	static int been_here = 0;
	if (been_here) return;
	been_here = 1;

	printf ("Usage: %s /[s|m]\n",p);
	printf ("/m\tUse master drive (default)\n");
	printf ("/s\tUse slave drive\n");
	printf ("/bios\tUse int 13 bios without extensions (default)\n");
D 3
	printf ("/xbios\tUse use bios extensions drive\n");
E 3
I 3
	printf ("/xbios\tUse int 13 bios extensions\n");
E 3
	printf ("/?\tPrint this option list\n");
}
main (int np, char **p)
{
	int	src_drive = 0x80,dst_drive = 0x81;;
	int	try_ext = 0, help = 0,is_adjust = 0;
	int	status,i;
	static disk_control_block *src_disk,*dst_disk;
	unsigned long lba = 0,feed,common,diffs = 0,
		nz,nfill,
		byte_diffs = 0,match = 0,zero = 0,sfill = 0, dfill = 0,ofill = 0,other = 0;
	int	big_src = 0,big_dst = 0,is_diff;
	int	src_status,dst_status;
	static unsigned char *src_buff,*dst_buff;
	static time_t from,till;
	long et,tmin,min,sec,hours;
	FILE *log;
	int	is_debug = 0, log_diffs = 0;
	unsigned char src_fill_char,dst_fill_char;
	int	fill_char;
	char	comment[80];
	range_ptr d_r = create_range_list(),
				 z_r = create_range_list(),
				 sf_r = create_range_list(),
				 df_r = create_range_list(),
				 of_r = create_range_list(),
				 o_r = create_range_list();

	time(&from);
	printf ("\n%s compiled at %s on %s\n", p[0],
		__TIME__,__DATE__);
	src_disk = dst_disk = NULL;
	src_disk = (disk_control_block *)malloc(sizeof(disk_control_block));
	dst_disk = (disk_control_block *)malloc(sizeof(disk_control_block));
	if ((src_disk == NULL) || (dst_disk == NULL)){
		printf ("%s Malloc disk control blocks failed \n", p[0]);
		return 1;
	}

	if (np < 3){
		printf ("%s missing hex fill code(s), usage: %s src_fill dst_fill\n",
			p[0],p[0]);
		print_help(p[0]);
		return 1;
	}

	sscanf (p[1],"%x",&fill_char);
	src_fill_char = fill_char;
	sscanf (p[2],"%x",&fill_char);
	dst_fill_char = fill_char;


	for (i = 3; i < np; i++){
		if (strcmp(p[i],"/s") == 0){ src_drive = 0x81; dst_drive = 0x80;}
		else if (strcmp (p[i],"/m")== 0){ src_drive = 0x80; dst_drive = 0x81;}
		else if (strcmp (p[i],"/?") == 0) help = 1;
		else if (strcmp (p[i],"/bios")== 0) try_ext = 0;
		else if (strcmp (p[i],"/xbios")== 0) try_ext = 1;
		else if (strcmp (p[i],"/debug")== 0) is_debug = 1;
		else if (strcmp (p[i],"/adjust")== 0) is_adjust = 1;
		else if (strcmp (p[i],"/diffs")== 0) log_diffs = 1;
		else help = 1;
		if (help){
			print_help(p[0]);
			return 0;
		}
	}                     
	printf ("Insert log floppy, type a comment for the log and press Enter key\n");
	gets(comment);
	log = fopen("a:\cmplog.txt","w");
	if (log == NULL) log = stdout;
	printf ("src drive 0x%2X (%s) %s\n",src_drive,src_drive==0x80?"master":"slave",
		try_ext?"Try BIOS extensions":"No BIOS extensions");
	src_disk = open_disk (src_drive,try_ext,&status);
	if (status){
		printf ("%s could not read drive %x status code %d\n",
			p[0],src_drive,status);
		fprintf (log,"%s could not read drive %x status code %d\n",
			p[0],src_drive,status);
		return 1;
	}
	dst_disk = open_disk (dst_drive,try_ext,&status);
	if (status){
		printf ("%s could not read drive %x status code %d\n",
			p[0],dst_drive,status);
		fprintf (log,"%s could not read drive %x status code %d\n",
			p[0],dst_drive,status);
		return 1;
	}

	if (n_sectors(src_disk) != n_sectors (dst_disk)){
		if ( n_sectors(src_disk) < n_sectors (dst_disk)){
			common = n_sectors(src_disk);
			big_dst = 1;
		}
		else {
			common = n_sectors(dst_disk);
			big_src = 1;
		}
	}
	else common = n_sectors(src_disk);
	fprintf (log,"%s\nversion %s\ncompiled %s at %s with BCC version %x\n",
		p[0],SCCS_ID,__DATE__,__TIME__,__BORLANDC__);
	fprintf (log,"%s\n",SCCS_Z);
	fprintf (log,"run start %s",ctime(&from));
	fprintf (log,"Comment: %s\n",comment);
	printf ("Source disk fill byte %2X\n",src_fill_char);
	printf ("Destination disk fill byte %2X\n",dst_fill_char);
	feed = common/10;
	if (is_debug)feed = (feed/100)*100;
	printf ("Feed back every %ld secetors\n",feed);
	for (lba = 0; lba < common; is_debug?(lba+=100):lba++){
		is_diff = 0;
		if ((lba%feed) == 0){
			printf ("diskcmp %6.0f%%\n",(lba*100.0)/common);
		}
		src_status = read_lba(src_disk,lba,&src_buff);
		dst_status = read_lba(dst_disk,lba,&dst_buff);
		if (src_status || dst_status){
			fprintf (log,"read error at lba %ld, src %d dst %d\n",lba,src_status,
				dst_status);
			printf ("read error at lba %ld, src %d dst %d\n",lba,src_status,
				dst_status);
			return 1;
		}
		for (i = 0; i < 512; i++){
			if (src_buff[i] != dst_buff[i]){
				is_diff = 1;
				byte_diffs++;
			}
		}
		if (is_diff){
			diffs++;
			add_to_range (d_r,lba);
			if (log_diffs && (diffs <= 50)){
				 fprintf (log,"%12ld ",lba);
				 if ((diffs%5) == 0) fprintf (log,"\n");
			}
		}
		else {
			match++;
		}
	}
	if  (log_diffs && (diffs)) fprintf (log,"\n");
	fprintf (log,"Sectors compared: %12ld\n",common);
	fprintf (log,"Sectors match:    %12ld\n",match);
	fprintf (log,"Sectors differ:   %12ld\n",diffs);
	fprintf (log,"Bytes differ:     %12ld\n",byte_diffs);
	fprintf (log,"Diffs range: "); print_range_list(log,d_r);
	if (big_src){
		fprintf (log,"Source (%ld) has %ld more sectors than destination (%ld)\n",
			n_sectors(src_disk),n_sectors(src_disk) - n_sectors(dst_disk),
			n_sectors(dst_disk));
	}
	else if (big_dst){
		fprintf (log,"Source (%ld) has %ld fewer sectors than destination (%ld)\n",
			n_sectors(src_disk),n_sectors(dst_disk) - n_sectors(src_disk),
			n_sectors(dst_disk));
		zero = 0;
		ofill = sfill = dfill = 0;
		other = 0;
		feed = (n_sectors(dst_disk) - common)/30;
		printf ("Destination larger than source, scanning %ld sectors\n",
			n_sectors(dst_disk)-common);
		printf ("Feed back every %ld sectors\n",feed);
		for (lba = common; lba < n_sectors(dst_disk); is_debug?(lba+=100):lba++){
			if ((n_sectors(dst_disk) - common)%feed == 0){
				printf ("%6.2f%%\n",
					((lba - common)*100.0)/(n_sectors(dst_disk) - common));
			}
			dst_status = read_lba(dst_disk,lba,&dst_buff);
			nz = 0;
			nfill = 0;
			for (i = 0; i < 512; i++){
				if ( dst_buff[i] == 0) nz++;
				else if (dst_buff[i] == dst_buff[30]) nfill++;
			}
			if (nz == 512){zero++; add_to_range(z_r,lba);}
			else if (nfill > 480){
					if (dst_buff[30] == src_fill_char){
						sfill++;
						add_to_range(sf_r,lba);
					}
					else if (dst_buff[30] == dst_fill_char){
						dfill++;
						add_to_range(df_r,lba);
					}
					else {
						ofill++;
						add_to_range(of_r,lba);
					}
			}
			else{ other++;
				add_to_range (o_r,lba);
				if  (log_diffs && (other <= 50)){
					 fprintf (log,"12ld",lba);
					 if (other%5 == 0) fprintf (log,"\n");
				}
			}
		}
		if  (log_diffs && (other)) fprintf (log,"\n");
		fprintf (log,"Zero fill:     %ld\n",zero);
		fprintf (log,"Src Byte fill: %ld %02X\n",sfill,src_fill_char);
		fprintf (log,"Dst Byte fill: %ld %02X\n",dfill,dst_fill_char);
		fprintf (log,"Other fill:    %ld\n",ofill);
		fprintf (log,"Other no fill: %ld\n",other);
	fprintf (log,"Zero fill range: "); print_range_list(log,z_r);
	fprintf (log,"Src fill range: "); print_range_list(log,sf_r);
	fprintf (log,"Dst fill range: "); print_range_list(log,df_r);
	fprintf (log,"Other fill range: "); print_range_list(log,of_r);
	fprintf (log,"Other not filled range: "); print_range_list(log,o_r);
	}

	time(&till);
	et = till - from;
	tmin = et/60;
	sec = et%60;
	hours = tmin/60;
	min = tmin%60;
	fprintf (log,"run finish %s",ctime(&till));
	fprintf (log,"src drive 0x%2X (%s) %s\n",src_drive,src_drive==0x80?"master":"slave",
		try_ext?"use BIOS extensions":"no BIOS extensions");
                                                              
	fprintf (log,"dst drive 0x%2X (%s) %s\n",dst_drive,dst_drive==0x80?"master":"slave",
		try_ext?"use BIOS extensions":"no BIOS extensions");
	fprintf (log,"elapsed time %ld:%ld:%ld\n",hours,min,sec);
	fprintf (log,"Normal exit %s\n",p[0]);
	printf ("elapsed time %ld:%ld:%ld\n",hours,min,sec);
	printf ("Normal exit %s\n",p[0]);
	return 0;
}
E 4
I 4
D 8
/******************************************************************************
The software provided here is released by the National
Institute of Standards and Technology (NIST), an agency of
the U.S. Department of Commerce, Gaithersburg MD 20899,
USA.  The software bears no warranty, either expressed or
implied. NIST does not assume legal liability nor
responsibility for a User's use of the software or the
results of such use.

Please note that within the United States, copyright
protection, under Section 105 of the United States Code,
Title 17, is not available for any work of the United
States Government and/or for any works created by United
States Government employees. User acknowledges that this
software contains work which was created by NIST employees
and is therefore in the public domain and not subject to
copyright.  The User may use, distribute, or incorporate
this software provided the User acknowledges this via an
explicit acknowledgment of NIST-related contributions to
the User's work. User also agrees to acknowledge, via an
explicit acknowledgment, that any modifications or
alterations have been made to this software before
redistribution.
******************************************************************************/
/***** Author: Dr. James R. Lyle, NIST/SDCT/SQG ****/
D 5
static char *SCCS_ID = "%Z% Version %I% Created %G% at %U%";
E 5
I 5
static char *SCCS_ID[] = {"%Z% %M% Version %I% Created %G% at %U%",
	__DATE__,__TIME__};
E 5

# include <stdio.h>
# include <dos.h>
# include "zbios.h"
# include <string.h>
# include <time.h>
# include <malloc.h>

D 7
# define N_RANGE 100
E 7
I 5

E 8
I 8
/******************************************************************************
The software provided here is released by the National
Institute of Standards and Technology (NIST), an agency of
the U.S. Department of Commerce, Gaithersburg MD 20899,
USA.  The software bears no warranty, either expressed or
implied. NIST does not assume legal liability nor
responsibility for a User's use of the software or the
results of such use.

Please note that within the United States, copyright
protection, under Section 105 of the United States Code,
Title 17, is not available for any work of the United
States Government and/or for any works created by United
States Government employees. User acknowledges that this
software contains work which was created by NIST employees
and is therefore in the public domain and not subject to
copyright.  The User may use, distribute, or incorporate
this software provided the User acknowledges this via an
explicit acknowledgment of NIST-related contributions to
the User's work. User also agrees to acknowledge, via an
explicit acknowledgment, that any modifications or
alterations have been made to this software before
redistribution.
******************************************************************************/
/***** Author: Dr. James R. Lyle, NIST/SDCT/SQG ****/
static char *SCCS_ID[] = {"%Z% %M% Version %I% Created %G% at %U%",
	__DATE__,__TIME__};

# include <stdio.h>
# include <dos.h>
# include "zbios.h"
# include <string.h>
# include <time.h>
# include <malloc.h>


E 8
D 7

E 7
/*****************************************************************
Compare two disks

diskcmp test-case host source-disk source-fill-byte dst-disk dst-fill-byte

The assumption is that the source-disk has been copied to the dst-disk

High level design:
	decode command line
	open source and dst disks
	for each sector (address) common to both disks
		read src sector
		read dst sector
		compare: increment count of equal_sectors or differing_sectors
	log results
	if src has more sectors than destination then exit
	else if src and dst are same size then exit
	else for each sector remaining on the dst
		read dst sector
		examine: count zero filled, src filled, dst filled, other filled and
			not filled sectors
	log results
D 8
*****************************************************************/

E 5
D 6
typedef struct {unsigned long from,to;} lba_range;
D 5
typedef struct {
E 5
I 5
typedef struct { /* structure to keep a list of ranges */
E 5
	int	n;
D 5
	long is_more;
E 5
I 5
	long is_more; /* more than N_RANGE ranges present (i.e., some not recorded) */
E 5
	lba_range r[N_RANGE];
	} range_list,*range_ptr;
E 6

I 5
D 6
/*****************************************************************
Create an empty list of ranges
*****************************************************************/
E 5
range_ptr create_range_list(void)
{
	range_ptr	p;
	p = (range_ptr) malloc (sizeof(range_list));
	p->n = 0;
	p->is_more = 0;
	return p;
}
E 6

I 5
D 6
/*****************************************************************
Add x to the list of ranges
	(1) look for a range that can be expanded to include x
		 i.e., range of form a--b where b+1=x, a--b can then be
		 expanded to a--x
	(2) If an expandable range can't be found create a range of
		 the form x--x
*****************************************************************/
E 5
void add_to_range (range_ptr r, unsigned long x)
{
	int k = r->n - 1;
	if (r->n){
		if (r->r[k].to + 1 == x) r->r[k].to = x;
		else {
			k++;
			if (k >= N_RANGE){
				r->is_more = 1;
				return;
			}
			r->n++;
			r->r[k].from = r->r[k].to = x;
		}
	}
	else {
		r->n = 1;
		r->r[0].from = r->r[0].to = x;
	}
}

D 5
void print_range_list(FILE *log, range_ptr r)
E 5
I 5
void print_range_list(FILE *log, char *caption,range_ptr r)
E 5
{
	int	i,nc = 0;

I 5
	nc = fprintf (log,"%s ",caption);
E 5
	for (i = 0; i < r->n; i++){
		if(i)nc += fprintf(log,", ");
D 5
		if (r->r[i].from == r->r[i].to)
			nc += fprintf (log,"%ld",r->r[i].from);
		else nc += fprintf (log,"%ld-%ld",r->r[i].from,r->r[i].to);
E 5
		if (nc > 50){
			nc = 0;
			fprintf (log,"\n");
		}
I 5
		if (r->r[i].from == r->r[i].to)
			nc += fprintf (log,"%ld",r->r[i].from);
		else nc += fprintf (log,"%ld-%ld",r->r[i].from,r->r[i].to);
E 5
	}
	if (r->is_more) fprintf (log,". . . + %ld more\n",r->is_more);
	else fprintf (log,"\n");
}


E 6
void print_help(char *p)
{
	static int been_here = 0;
	if (been_here) return;
	been_here = 1;

D 5
	printf ("Usage: %s /[s|m]\n",p);
	printf ("/m\tUse master drive (default) as src\n");
	printf ("/s\tUse slave drive as src\n");
	printf ("/bios\tUse int 13 bios without extensions (default)\n");
	printf ("/xbios\tUse int 13 bios extensions\n");
	printf ("/xsrc nnn\tAdd nnn tracks beyond BIOS to src\n");
	printf ("/xdst nnn\tAdd nnn tracks beyond BIOS to dst\n");
E 5
I 5
	printf ("Usage: %s test-case host src-drive src-fill dst-drive dst-fill [/options]\n",p);
	printf ("/comment \" ... \"\tDescriptive comment\n");
E 5
	printf ("/?\tPrint this option list\n");
}
main (int np, char **p)
{
D 5
	int	src_drive = 0x80,dst_drive = 0x81;;
E 5
I 5
D 7
	int	src_drive = 0,dst_drive = 0;
E 7
I 7
	int	src_drive = 0,dst_drive = 0; /* drive numbers */
E 7
E 5
D 6
	int	try_ext = 0, help = 0;
E 6
I 6
	int	help = 0;
E 6
	int	status,i;
D 7
	static disk_control_block *src_disk,*dst_disk;
D 6
	unsigned long lba = 0,feed,common,diffs = 0,
		nz,nfill,src_ns,dst_ns,src_xt = 0,dst_xt = 0,
E 6
I 6
	unsigned long lba = 0,common,diffs = 0,
		nz,nfill,src_ns,dst_ns,
E 7
I 7
	static disk_control_block *src_disk,*dst_disk; /* disk information */
	unsigned long lba = 0, /* index for looping through disk sectors */
		common, /* number of sectors common to source and dst */
		diffs = 0, /* number of sectors that do not match */
		nz, /* number of zero bytes in current sector */
		nfill,/* number of filled bytes in current sector */
		src_ns,dst_ns, /* number of sectors on src and dst */
		/* counts: sectors that ... */
E 7
E 6
		byte_diffs = 0,match = 0,zero = 0,sfill = 0, dfill = 0,ofill = 0,other = 0;
	int	big_src = 0,big_dst = 0,is_diff;
D 7
	int	src_status,dst_status;
	static unsigned char *src_buff,*dst_buff;
D 6
	static time_t from,till;
	long et,tmin,min,sec,hours;
E 6
I 6
	static time_t from;
E 6
	FILE *log;
	int	is_debug = 0, log_diffs = 0;
	unsigned char src_fill_char,dst_fill_char;
	int	fill_char;
D 5
	char	comment[80];
E 5
I 5
	char	comment[80] = "";
E 5
	range_ptr d_r = create_range_list(),
				 z_r = create_range_list(),
				 sf_r = create_range_list(),
				 df_r = create_range_list(),
				 of_r = create_range_list(),
				 o_r = create_range_list();
E 7
I 7
	int	src_status,dst_status; /* read status codes (should be zero) */
	static unsigned char *src_buff,*dst_buff; /* current src and dst sector data */
	static time_t from; /* program start time */
	FILE *log;  /* the log file */
	int	is_debug = 0;
	unsigned char other_fill_char,src_fill_char,dst_fill_char; /* the fill characters */
	int	fill_char,other_fill_seen = 0;
	unsigned long n_src_err = 0, n_dst_err = 0; /* count of number of read errs */
	char	comment[80] = ""; /* the user comment */
								/* sectors that ... */
	range_ptr d_r = create_range_list(), /* ... differ (do not match) */
				 z_r = create_range_list(), /* ... all zeros */
				 sf_r = create_range_list(),/* ... source filled */
				 df_r = create_range_list(), /* ... dst filled */
				 of_r = create_range_list(), /* ... filled with something else */
				 o_r = create_range_list(); /* ... are not filled */
E 7

	time(&from);
D 5
	printf ("\n%s compiled at %s on %s\n", p[0],
		__TIME__,__DATE__);
E 5
	src_disk = dst_disk = NULL;
	src_disk = (disk_control_block *)malloc(sizeof(disk_control_block));
	dst_disk = (disk_control_block *)malloc(sizeof(disk_control_block));
	if ((src_disk == NULL) || (dst_disk == NULL)){
		printf ("%s Malloc disk control blocks failed \n", p[0]);
		return 1;
	}

I 7
/*****************************************************************
Get the command line
*****************************************************************/
E 7
D 5
	if (np < 3){
		printf ("%s missing hex fill code(s), usage: %s src_fill dst_fill\n",
			p[0],p[0]);
E 5
I 5
	if (np < 7){
E 5
D 7
		print_help(p[0]);
E 7
I 7
		print_help(p[0]); /* not enough parameters */
E 7
		return 1;
	}

D 5
	sscanf (p[1],"%x",&fill_char);
E 5
I 5
	sscanf (p[4],"%x",&fill_char);
E 5
	src_fill_char = fill_char;
D 5
	sscanf (p[2],"%x",&fill_char);
E 5
I 5
	sscanf (p[6],"%x",&fill_char);
E 5
	dst_fill_char = fill_char;
I 5
	sscanf (p[3],"%x",&src_drive);
	sscanf (p[5],"%x",&dst_drive);
D 7
	if ((src_drive < 0x80) || (src_drive > 0x88)){
E 7
I 7
	if ((src_drive < 0x80) || (src_drive > 0x88)){/* setup src and dst drives */
E 7
		help = 1;
		printf ("Src drive %X not valid (0x80 <= drive < 0x89)\n",src_drive);
	} 
	if ((dst_drive < 0x80) || (dst_drive > 0x88)){
		help = 1;
		printf ("Dst drive %X not valid (0x80 <= drive < 0x89)\n",src_drive);
	}
	 printf ("Src drive %x dst drive %x\n",src_drive,dst_drive);
	 printf ("Src fill 0x%02X dst fill 0x%02X\n",src_fill_char,dst_fill_char);
E 5

D 5

	for (i = 3; i < np; i++){
		if (strcmp(p[i],"/s") == 0){ src_drive = 0x81; dst_drive = 0x80;}
		else if (strcmp (p[i],"/m")== 0){ src_drive = 0x80; dst_drive = 0x81;}
		else if (strcmp (p[i],"/?") == 0) help = 1;
		else if (strcmp (p[i],"/bios")== 0) try_ext = 0;
		else if (strcmp (p[i],"/xbios")== 0) try_ext = 1;
E 5
I 5
D 7
	for (i = 7; i < np; i++){
E 7
I 7
	for (i = 7; i < np; i++){ /* optional parameters */
E 7
		if (strcmp (p[i],"/?") == 0) help = 1;
E 5
		else if (strcmp (p[i],"/debug")== 0) is_debug = 1;
D 7
		else if (strcmp (p[i],"/diffs")== 0) log_diffs = 1;
E 7
D 5
		else if (strcmp (p[i],"/xdst")== 0){
E 5
I 5
		else if (strcmp (p[i],"/comment")== 0){
E 5
			i++;
			if ( i>=np){
D 5
				printf ("%s: extra track count required with /xdst\n",
					p[0]);
E 5
I 5
				printf ("%s: comment required with /comment\n",	p[0]);
E 5
				print_help(p[0]);
				return 1;
			}
D 5
			sscanf(p[i],"%ld",&dst_xt);
E 5
I 5
			strcpy (comment,p[i]);
E 5
		}
D 5
		else if (strcmp (p[i],"/xsrc")== 0){
			i++;
			if ( i>=np){
				printf ("%s: extra track count required with /xsrc\n",
					p[0]);
				print_help(p[0]);
				return 1;
			}
			sscanf(p[i],"%ld",&src_xt);
		}
E 5
		else help = 1;
D 5
		if (help){
			print_help(p[0]);
			return 0;
		}
	}                     
	printf ("Insert log floppy, type a comment for the log and press Enter key\n");
	gets(comment);
	log = fopen("a:\cmplog.txt","w");
	if (log == NULL) log = stdout;
	printf ("src drive 0x%2X (%s) %s\n",src_drive,src_drive==0x80?"master":"slave",
		try_ext?"Try BIOS extensions":"No BIOS extensions");
E 5
I 5
	}
	if (help){
		print_help(p[0]);
		return 0;
	}
I 7
/*****************************************************************
Start log file
*****************************************************************/
E 7
D 6
	log = log_open("a:\cmplog.txt",comment,SCCS_ID,p);
E 5
	src_disk = open_disk (src_drive,try_ext,&status);
E 6
I 6
	log = log_open("a:\cmplog.txt",comment,SCCS_ID,np,p);
	src_disk = open_disk (src_drive,&status);
E 6
I 5
	log_disk(log,"Source",src_disk);
E 5
	if (status){
		printf ("%s could not read drive %x status code %d\n",
			p[0],src_drive,status);
		fprintf (log,"%s could not read drive %x status code %d\n",
			p[0],src_drive,status);
		return 1;
	}
D 6
	dst_disk = open_disk (dst_drive,try_ext,&status);
E 6
I 6
	dst_disk = open_disk (dst_drive,&status);
E 6
I 5
	log_disk(log,"Destination",dst_disk);
E 5
	if (status){
		printf ("%s could not read drive %x status code %d\n",
			p[0],dst_drive,status);
		fprintf (log,"%s could not read drive %x status code %d\n",
			p[0],dst_drive,status);
		return 1;
	}
D 5
	src_ns = n_sectors(src_disk) + 63*src_xt;
	dst_ns = n_sectors(dst_disk) + 63*dst_xt;
E 5
I 5
	src_ns = n_sectors(src_disk);
	dst_ns = n_sectors(dst_disk);
E 5

	if (src_ns != dst_ns){
		if ( src_ns < dst_ns){
			common = src_ns;
			big_dst = 1;
		}
		else {
			common = dst_ns;
			big_src = 1;
		}
	}
D 7
	else common = src_ns;
E 7
I 7
	else common = src_ns; 
/*****************************************************************
Main scan loop: read corresponding sectors and compare
*****************************************************************/
E 7
D 5
	fprintf (log,"%s\nversion %s\ncompiled %s at %s with BCC version %x\n",
		p[0],SCCS_ID,__DATE__,__TIME__,__BORLANDC__);
	fprintf (log,"%s\n",SCCS_Z);
	fprintf (log,"run start %s",ctime(&from));
	fprintf (log,"Comment: %s\n",comment);
	printf ("Source disk fill byte %2X\n",src_fill_char);
	printf ("Destination disk fill byte %2X\n",dst_fill_char);
	feed = common/10;
	if (is_debug)feed = (feed/100)*100;
	printf ("Feed back every %ld secetors\n",feed);
E 5
	for (lba = 0; lba < common; is_debug?(lba+=100):lba++){
		is_diff = 0;
D 5
		if ((lba%feed) == 0){
			printf ("diskcmp %6.0f%%\n",(lba*100.0)/common);
		}
E 5
I 5
		feedback (from,0,lba,big_dst?dst_ns:common);
E 5
		src_status = read_lba(src_disk,lba,&src_buff);
		dst_status = read_lba(dst_disk,lba,&dst_buff);
D 7
		if (src_status || dst_status){
			fprintf (log,"read error at lba %ld, src %d dst %d\n",lba,src_status,
				dst_status);
			printf ("read error at lba %ld, src %d dst %d\n",lba,src_status,
				dst_status);
			return 1;
E 7
I 7
		if (src_status){ /* if bad sectors, keep list of first 10 */
			n_src_err++;
			if (n_src_err < 11){
				fprintf (log,"src read error 0x%02X on track starting at lba %ld\n",
					src_status,lba);
				printf ("src read error 0x%02X at lba %ld\n",src_status,lba);
			}
			if (n_src_err == 11) {
				fprintf (log,"... more src read errors\n");
				printf ("... more src read errors\n");
			}
			continue;
E 7
		}
D 7
		for (i = 0; i < 512; i++){
E 7
I 7
		if (dst_status){ /* if bad sectors, keep list of first 10 */
			n_dst_err++;
			if (n_dst_err < 11){
				fprintf (log,"dst read error 0x%02X on track starting at lba %ld\n",
					dst_status,lba);
				printf ("dst read error 0x%02X at lba %ld\n",dst_status,lba);
			}
			if (n_dst_err == 11) {
				fprintf (log,"... more dst read errors\n");
				printf ("... more dst read errors\n");
			}
			continue;
		}
		for (i = 0; i < 512; i++){  /* count bytes different */
E 7
			if (src_buff[i] != dst_buff[i]){
				is_diff = 1;
				byte_diffs++;
			}
		}
D 7
		if (is_diff){
E 7
I 7
		if (is_diff){/* sectors do not match */
E 7
			diffs++;
			add_to_range (d_r,lba);
D 7
			if (log_diffs && (diffs <= 50)){
				 fprintf (log,"%12ld ",lba);
				 if ((diffs%5) == 0) fprintf (log,"\n");
			}
E 7
		}
		else {
			match++;
		}
	}
D 7
	if  (log_diffs && (diffs)) fprintf (log,"\n");
	fprintf (log,"Sectors compared: %12ld\n",common);
	fprintf (log,"Sectors match:    %12ld\n",match);
	fprintf (log,"Sectors differ:   %12ld\n",diffs);
	fprintf (log,"Bytes differ:     %12ld\n",byte_diffs);
E 7
I 7
	/* log results for corresponding sectors */
	fprintf (log,"Sectors compared: %8ld\n",common);
	fprintf (log,"Sectors match:    %8ld\n",match);
	fprintf (log,"Sectors differ:   %8ld\n",diffs);
	if (n_src_err + n_dst_err){ /* note any I/O errors */
		fprintf (log,
					 "Sectors skipped:  %8ld (due to %ld src & %ld dst I/O errors)\n",
					 n_src_err+n_dst_err,n_src_err,n_dst_err);
	}
	fprintf (log,"Bytes differ:     %8ld\n",byte_diffs);
E 7
D 5
	fprintf (log,"Diffs range: "); print_range_list(log,d_r);
E 5
I 5
	print_range_list(log,"Diffs range",d_r);
E 5
	if (big_src){
		fprintf (log,"Source (%ld) has %ld more sectors than destination (%ld)\n",
			src_ns,src_ns - dst_ns,
			dst_ns);
	}
D 7
	else if (big_dst){
E 7
I 7
	else if (big_dst){ /* examine remainder of a larger destination */
E 7
		fprintf (log,"Source (%ld) has %ld fewer sectors than destination (%ld)\n",
			src_ns,dst_ns - src_ns,
			dst_ns);
		zero = 0;
		ofill = sfill = dfill = 0;
		other = 0;
D 6
		feed = (dst_ns - common)/10;
E 6
		printf ("Destination larger than source, scanning %ld sectors\n",
			dst_ns-common);
D 5
		printf ("Feed back every %ld sectors\n",feed);
E 5
		for (lba = common; lba < dst_ns; is_debug?(lba+=100):lba++){
D 5
			if ((lba - common)%feed == 0){
				printf ("%6.2f%%\n",
					((lba - common)*100.0)/(dst_ns - common));
			}
E 5
I 5
			feedback (from,0,lba,dst_ns);
E 5
			dst_status = read_lba(dst_disk,lba,&dst_buff);
I 7
			if (dst_status){
				n_dst_err++;
				if (n_dst_err < 11){
					fprintf (log,"dst read error 0x%02X on track starting at lba %ld\n",
						dst_status,lba);
					printf ("dst read error 0x%02X at lba %ld\n",dst_status,lba);
				}
				if (n_dst_err == 11) {
					fprintf (log,"... more dst read errors\n");
					printf ("... more dst read errors\n");
				}
				continue;
			}
E 7
			nz = 0;
			nfill = 0;
			for (i = 0; i < 512; i++){
				if ( dst_buff[i] == 0) nz++;
				else if (dst_buff[i] == dst_buff[30]) nfill++;
			}
			if (nz == 512){zero++; add_to_range(z_r,lba);}
D 7
			else if (nfill > 480){
E 7
I 7
			else if (nfill > 480){  /* filled sector: figure out src, dst or other */
E 7
					if (dst_buff[30] == src_fill_char){
						sfill++;
						add_to_range(sf_r,lba);
					}
					else if (dst_buff[30] == dst_fill_char){
						dfill++;
						add_to_range(df_r,lba);
					}
					else {
						ofill++;
						add_to_range(of_r,lba);
I 7
						other_fill_seen = 1;
						other_fill_char = dst_buff[30];
E 7
					}
			}
			else{ other++;
				add_to_range (o_r,lba);
D 7
				if  (log_diffs && (other <= 50)){
					 fprintf (log,"12ld",lba);
					 if (other%5 == 0) fprintf (log,"\n");
				}
E 7
			}
		}
D 7
		if  (log_diffs && (other)) fprintf (log,"\n");
		fprintf (log,"Zero fill:     %ld\n",zero);
		fprintf (log,"Src Byte fill: %ld %02X\n",sfill,src_fill_char);
		fprintf (log,"Dst Byte fill: %ld %02X\n",dfill,dst_fill_char);
		fprintf (log,"Other fill:    %ld\n",ofill);
		fprintf (log,"Other no fill: %ld\n",other);
E 7
I 7
		/* log results of scan of extra dst sectors */
	fprintf (log,"Zero fill:          %8ld\n",zero);
	fprintf (log,"Src Byte fill (%02X): %8ld\n",src_fill_char,sfill);
	fprintf (log,"Dst Byte fill (%02X): %8ld\n",dst_fill_char,dfill);
	if (other_fill_seen)
			fprintf (log,"Other fill (%02X):    %8ld\n",other_fill_char,ofill);
	else 	fprintf (log,"Other fill:         %8ld\n",ofill);
	fprintf (log,"Other no fill:      %8ld\n",other);
E 7
D 5
	fprintf (log,"Zero fill range: "); print_range_list(log,z_r);
	fprintf (log,"Src fill range: "); print_range_list(log,sf_r);
	fprintf (log,"Dst fill range: "); print_range_list(log,df_r);
	fprintf (log,"Other fill range: "); print_range_list(log,of_r);
	fprintf (log,"Other not filled range: "); print_range_list(log,o_r);
E 5
I 5
	print_range_list (log,"Zero fill range: ",z_r);
	print_range_list (log,"Src fill range: ",sf_r);
	print_range_list (log,"Dst fill range: ",df_r);
	print_range_list (log,"Other fill range: ",of_r);
	print_range_list (log,"Other not filled range: ",o_r);
E 5
	}
I 7
	fprintf (log,"%ld source read errors, %ld destination read errors\n",
		n_src_err,n_dst_err);
E 7

D 5
	time(&till);
	et = till - from;
	tmin = et/60;
	sec = et%60;
	hours = tmin/60;
	min = tmin%60;
	fprintf (log,"run finish %s",ctime(&till));
	fprintf (log,"src drive 0x%2X (%s) %s\n",src_drive,src_drive==0x80?"master":"slave",
		try_ext?"use BIOS extensions":"no BIOS extensions");
                                                              
	fprintf (log,"dst drive 0x%2X (%s) %s\n",dst_drive,dst_drive==0x80?"master":"slave",
		try_ext?"use BIOS extensions":"no BIOS extensions");
	fprintf (log,"elapsed time %ld:%ld:%ld\n",hours,min,sec);
	fprintf (log,"Normal exit %s\n",p[0]);
	printf ("elapsed time %ld:%ld:%ld\n",hours,min,sec);
	printf ("Normal exit %s\n",p[0]);
E 5
I 5
	log_close(log,from);
E 5
	return 0;
}
E 8
I 8
*****************************************************************/



void print_help(char *p)
{
	static int been_here = 0;
	if (been_here) return;
	been_here = 1;

	printf ("Usage: %s test-case host src-drive src-fill dst-drive dst-fill [/options]\n",p);
	printf ("/comment \" ... \"\tDescriptive comment\n");
I 9
	printf ("/new_log\tStart a new log file (default is append to old log file)\n");
E 9
	printf ("/?\tPrint this option list\n");
}
main (int np, char **p)
{
	int	src_drive = 0,dst_drive = 0; /* drive numbers */
	int	help = 0;
	int	status,i;
	static disk_control_block *src_disk,*dst_disk; /* disk information */
	unsigned long lba = 0, /* index for looping through disk sectors */
		common, /* number of sectors common to source and dst */
		diffs = 0, /* number of sectors that do not match */
		nz, /* number of zero bytes in current sector */
		nfill,/* number of filled bytes in current sector */
		src_ns,dst_ns, /* number of sectors on src and dst */
		/* counts: sectors that ... */
		byte_diffs = 0,match = 0,zero = 0,sfill = 0, dfill = 0,ofill = 0,other = 0;
	int	big_src = 0,big_dst = 0,is_diff;
	int	src_status,dst_status; /* read status codes (should be zero) */
	static unsigned char *src_buff,*dst_buff; /* current src and dst sector data */
	static time_t from; /* program start time */
	FILE *log;  /* the log file */
	int	is_debug = 0;
	unsigned char other_fill_char,src_fill_char,dst_fill_char; /* the fill characters */
	int	fill_char,other_fill_seen = 0;
	unsigned long n_src_err = 0, n_dst_err = 0; /* count of number of read errs */
D 9
	char	comment[80] = ""; /* the user comment */
E 9
I 9
	char	comment[80] = "",*access = "a"; /* the user comment */
E 9
								/* sectors that ... */
	range_ptr d_r = create_range_list(), /* ... differ (do not match) */
				 z_r = create_range_list(), /* ... all zeros */
				 sf_r = create_range_list(),/* ... source filled */
				 df_r = create_range_list(), /* ... dst filled */
				 of_r = create_range_list(), /* ... filled with something else */
				 o_r = create_range_list(); /* ... are not filled */

	time(&from);
	src_disk = dst_disk = NULL;

/*****************************************************************
Get the command line
*****************************************************************/
	if (np < 7){
		print_help(p[0]); /* not enough parameters */
		return 1;
	}

	sscanf (p[4],"%x",&fill_char);
	src_fill_char = fill_char;
	sscanf (p[6],"%x",&fill_char);
	dst_fill_char = fill_char;
	sscanf (p[3],"%x",&src_drive);
	sscanf (p[5],"%x",&dst_drive);
	if ((src_drive < 0x80) || (src_drive > 0x88)){/* setup src and dst drives */
		help = 1;
		printf ("Src drive %X not valid (0x80 <= drive < 0x89)\n",src_drive);
	} 
	if ((dst_drive < 0x80) || (dst_drive > 0x88)){
		help = 1;
		printf ("Dst drive %X not valid (0x80 <= drive < 0x89)\n",src_drive);
	}
	 printf ("Src drive %x dst drive %x\n",src_drive,dst_drive);
	 printf ("Src fill 0x%02X dst fill 0x%02X\n",src_fill_char,dst_fill_char);

	for (i = 7; i < np; i++){ /* optional parameters */
		if (strcmp (p[i],"/?") == 0) help = 1;
		else if (strcmp (p[i],"/debug")== 0) is_debug = 1;
I 9
		else if (strcmp (p[i],"/new_log")== 0) access = "w";
E 9
		else if (strcmp (p[i],"/comment")== 0){
			i++;
			if ( i>=np){
				printf ("%s: comment required with /comment\n",	p[0]);
				print_help(p[0]);
				return 1;
			}
			strcpy (comment,p[i]);
		}
		else help = 1;
	}
	if (help){
		print_help(p[0]);
		return 0;
	}
/*****************************************************************
Start log file
*****************************************************************/
D 9
	log = log_open("a:\cmplog.txt",comment,SCCS_ID,np,p);
E 9
I 9
D 10
	log = log_open("a:\cmplog.txt",access,comment,SCCS_ID,np,p);
E 10
I 10
	log = log_open("a:\\cmplog.txt",access,comment,SCCS_ID,np,p);
E 10
E 9
	src_disk = open_disk (src_drive,&status);
	if (status){
		printf ("%s could not access src drive %x status code %d\n",
			p[0],src_drive,status);
		fprintf (log,"%s could not access src drive %x status code %d\n",
			p[0],src_drive,status);
		return 1;
	}
	log_disk(log,"Source",src_disk);
	dst_disk = open_disk (dst_drive,&status);
	if (status){
		printf ("%s could not access dst drive %x status code %d\n",
			p[0],dst_drive,status);
		fprintf (log,"%s could not access dst drive %x status code %d\n",
			p[0],dst_drive,status);
		return 1;
	}
	log_disk(log,"Destination",dst_disk);
	src_ns = n_sectors(src_disk);
	dst_ns = n_sectors(dst_disk);

	if (src_ns != dst_ns){
		if ( src_ns < dst_ns){
			common = src_ns;
			big_dst = 1;
		}
		else {
			common = dst_ns;
			big_src = 1;
		}
	}
	else common = src_ns; 
/*****************************************************************
Main scan loop: read corresponding sectors and compare
*****************************************************************/
	for (lba = 0; lba < common; is_debug?(lba+=100):lba++){
		is_diff = 0;
		feedback (from,0,lba,big_dst?dst_ns:common);
		src_status = read_lba(src_disk,lba,&src_buff);
		dst_status = read_lba(dst_disk,lba,&dst_buff);
		if (src_status){ /* if bad sectors, keep list of first 10 */
			n_src_err++;
			if (n_src_err < 11){
				fprintf (log,"src read error 0x%02X on track starting at lba %ld\n",
					src_status,lba);
				printf ("src read error 0x%02X at lba %ld\n",src_status,lba);
			}
			if (n_src_err == 11) {
				fprintf (log,"... more src read errors\n");
				printf ("... more src read errors\n");
			}
			continue;
		}
		if (dst_status){ /* if bad sectors, keep list of first 10 */
			n_dst_err++;
			if (n_dst_err < 11){
				fprintf (log,"dst read error 0x%02X on track starting at lba %ld\n",
					dst_status,lba);
				printf ("dst read error 0x%02X at lba %ld\n",dst_status,lba);
			}
			if (n_dst_err == 11) {
				fprintf (log,"... more dst read errors\n");
				printf ("... more dst read errors\n");
			}
			continue;
		}
		for (i = 0; i < 512; i++){  /* count bytes different */
			if (src_buff[i] != dst_buff[i]){
				is_diff = 1;
				byte_diffs++;
			}
		}
		if (is_diff){/* sectors do not match */
			diffs++;
			add_to_range (d_r,lba);
		}
		else {
			match++;
		}
	}
	/* log results for corresponding sectors */
	fprintf (log,"Sectors compared: %8ld\n",common);
	fprintf (log,"Sectors match:    %8ld\n",match);
	fprintf (log,"Sectors differ:   %8ld\n",diffs);
	if (n_src_err + n_dst_err){ /* note any I/O errors */
		fprintf (log,
					 "Sectors skipped:  %8ld (due to %ld src & %ld dst I/O errors)\n",
					 n_src_err+n_dst_err,n_src_err,n_dst_err);
	}
	fprintf (log,"Bytes differ:     %8ld\n",byte_diffs);
	print_range_list(log,"Diffs range",d_r);
	if (big_src){
		fprintf (log,"Source (%ld) has %ld more sectors than destination (%ld)\n",
			src_ns,src_ns - dst_ns,
			dst_ns);
	}
	else if (big_dst){ /* examine remainder of a larger destination */
		fprintf (log,"Source (%ld) has %ld fewer sectors than destination (%ld)\n",
			src_ns,dst_ns - src_ns,
			dst_ns);
		zero = 0;
		ofill = sfill = dfill = 0;
		other = 0;
		printf ("Destination larger than source, scanning %ld sectors\n",
			dst_ns-common);
		for (lba = common; lba < dst_ns; is_debug?(lba+=100):lba++){
			feedback (from,0,lba,dst_ns);
			dst_status = read_lba(dst_disk,lba,&dst_buff);
			if (dst_status){
				n_dst_err++;
				if (n_dst_err < 11){
					fprintf (log,"dst read error 0x%02X on track starting at lba %ld\n",
						dst_status,lba);
					printf ("dst read error 0x%02X at lba %ld\n",dst_status,lba);
				}
				if (n_dst_err == 11) {
					fprintf (log,"... more dst read errors\n");
					printf ("... more dst read errors\n");
				}
				continue;
			}
			nz = 0;
			nfill = 0;
			for (i = 0; i < 512; i++){
				if ( dst_buff[i] == 0) nz++;
				else if (dst_buff[i] == dst_buff[30]) nfill++;
			}
			if (nz == 512){zero++; add_to_range(z_r,lba);}
			else if (nfill > 480){  /* filled sector: figure out src, dst or other */
					if (dst_buff[30] == src_fill_char){
						sfill++;
						add_to_range(sf_r,lba);
					}
					else if (dst_buff[30] == dst_fill_char){
						dfill++;
						add_to_range(df_r,lba);
					}
					else {
						ofill++;
						add_to_range(of_r,lba);
						other_fill_seen = 1;
						other_fill_char = dst_buff[30];
					}
			}
			else{ other++;
				add_to_range (o_r,lba);
			}
		}
		/* log results of scan of extra dst sectors */
	fprintf (log,"Zero fill:          %8ld\n",zero);
	fprintf (log,"Src Byte fill (%02X): %8ld\n",src_fill_char,sfill);
D 9
	fprintf (log,"Dst Byte fill (%02X): %8ld\n",dst_fill_char,dfill);
E 9
I 9
	if (src_fill_char == dst_fill_char )
		fprintf (log,"Dst Fill Byte same as Src Fill Byte\n");
	else fprintf (log,"Dst Byte fill (%02X): %8ld\n",dst_fill_char,dfill);
E 9
	if (other_fill_seen)
			fprintf (log,"Other fill (%02X):    %8ld\n",other_fill_char,ofill);
	else 	fprintf (log,"Other fill:         %8ld\n",ofill);
	fprintf (log,"Other no fill:      %8ld\n",other);
	print_range_list (log,"Zero fill range: ",z_r);
	print_range_list (log,"Src fill range: ",sf_r);
	print_range_list (log,"Dst fill range: ",df_r);
	print_range_list (log,"Other fill range: ",of_r);
	print_range_list (log,"Other not filled range: ",o_r);
	}
	fprintf (log,"%ld source read errors, %ld destination read errors\n",
		n_src_err,n_dst_err);

	log_close(log,from);
	return 0;
}
E 8
E 4
E 1
