static char *SCCS_ID[] = {"@(#) partab.cpp Version 3.1 Created 10/11/01 at 12:40:24",
	__DATE__,__TIME__};
/******************************************************************************
The software provided here is released by the National
Institute of Standards and Technology (NIST), an agency of
the U.S. Department of Commerce, Gaithersburg MD 20899,
USA.  The software bears no warranty, either expressed or
implied. NIST does not assume legal liability nor
responsibility for a User's use of the software or the
results of such use.

Please note that within the United States, copyright
protection, under Section 105 of the United States Code,
Title 17, is not available for any work of the United
States Government and/or for any works created by United
States Government employees. User acknowledges that this
software contains work which was created by NIST employees
and is therefore in the public domain and not subject to
copyright.  The User may use, distribute, or incorporate
this software provided the User acknowledges this via an
explicit acknowledgment of NIST-related contributions to
the User's work. User also agrees to acknowledge, via an
explicit acknowledgment, that any modifications or
alterations have been made to this software before
redistribution.
******************************************************************************/
/***** Author: Dr. James R. Lyle, NIST/SDCT/SQG ****/
# include <stdio.h>
# include <string.h>
# include "zbios.h"   
# include <malloc.h>
# include <time.h>

/******************************************************************************
Print a partition table
	open disk
	open logfile
	log disk
	print partition table
	close log
******************************************************************************/


void print_help(char *p /* program name */)
{
	static int been_here = 0;
	if (been_here) return;
	been_here = 1;

	printf ("Usage: %s test-case host drive [/options]\n",p);
	printf ("/all\tList extended partitions\n");
	printf ("/comment \" ... \"\tComment for log file\n");
	printf ("/new_log\tStart a new log file (default is append to old log file)\n");
	printf ("/?\tPrint this option list\n");
}

int main (int np, char **p)
{
	int	drive = 0x80;
	int	help = 0;
	int	status,i,all = 0;
	static disk_control_block *dd;
	pte_rec		pt[4];
	FILE		*log;
	char	comment [80] = "",log_name[20],*access = "a";
	time_t from;

	_stklen = 2*_stklen;
	time(&from);
	printf ("\n%s compiled at %s on %s\n", p[0],
		__TIME__,__DATE__);

/* get command line */
	if (np < 4) help = 1;
	else sscanf (p[3],"%x",&drive);
	for (i = 4; i < np; i++){
		if (strcmp(p[i],"/all") == 0) all = 1;
		else if (strcmp (p[i],"/new_log")== 0) access = "w";
		else if (strcmp(p[i],"/comment") == 0){
			i++;
			if (i < np) strcpy (comment,p[i]);
			else help = 1;
		}
		else help = 1;
	}
	if (help){
		print_help(p[0]);
		return 0;
	}
	status = 1;
	printf ("Drive 0x%x\n",drive);
/* open log file */
	sprintf (log_name,"A:\\pt%xlog.txt",drive);
	log = log_open (log_name,access,comment,SCCS_ID,np,p);

/* open and log disk */
	dd = open_disk (drive,&status);
	if (status) {
		printf ("%s could not access drive %X, status code %d\n",p[0],
			drive,status); 
		fprintf (log,"%s could not access drive %X, status code %d\n",p[0],
			drive,status);
		return 1;
	}
	log_disk (log,"Partition table",dd);
/* get and print partition table */
	status = get_partition_table(dd,pt);
	if (status == 0)print_partition_table(stdout,pt,1,all);
	else if (status == -1) printf ("No partition table signature\n");
	else printf ("Error reading partition table, code %d\n",status);
	if (status == 0)print_partition_table(log,pt,1,all);
	if (status)fprintf (log,"Error reading partition table, code %d\n",status);
	log_close (log,from);
	return 0;
}
