h08247
s 00001/00001/00145
d D 3.1 01/10/11 12:40:22 jimmy 10 9
c Increment Version number to 3.1
e
s 00004/00002/00142
d D 2.8 01/07/10 11:22:14 jimmy 9 8
c add option for overwrite logfile; make default action append to logfile
e
s 00003/00003/00141
d D 2.7 01/06/12 13:58:03 jimmy 8 7
c making error message consistent
e
s 00000/00000/00144
d D 2.6 01/05/15 08:58:41 jimmy 7 6
c revisions for batch exec, commentary and minor revisions
e
s 00003/00003/00141
d D 2.5 01/04/06 14:33:23 jimmy 6 5
c fix problem with ident dev returns num sectors = 0
e
s 00057/00088/00087
d D 2.4 01/03/27 16:19:10 jimmy 5 4
c add test-case, host, drive and comment to command line
e
s 00175/00166/00000
d D 2.3 00/12/07 12:17:06 jimmy 4 3
c add ability to hash extra tracks beyond BIOS
e
s 00010/00002/00156
d D 2.2 00/10/02 09:08:26 jimmy 3 2
c minor updates, comments
e
s 00000/00000/00158
d D 2.1 00/09/27 13:44:51 jimmy 2 1
c switch to track based I/O
e
s 00158/00000/00000
d D 1.1 00/09/27 13:41:50 jimmy 1 0
c date and time created 00/09/27 13:41:50 by jimmy
e
u
U
f e 0
t
T
I 1
D 4
/******************************************************************************
The software provided here is released by the National
Institute of Standards and Technology (NIST), an agency of
the U.S. Department of Commerce, Gaithersburg MD 20899,
USA.  The software bears no warranty, either expressed or
implied. NIST does not assume legal liability nor
responsibility for a User's use of the software or the
results of such use.

Please note that within the United States, copyright
protection, under Section 105 of the United States Code,
Title 17, is not available for any work of the United
States Government and/or for any works created by United
States Government employees. User acknowledges that this
software contains work which was created by NIST employees
and is therefore in the public domain and not subject to
copyright.  The User may use, distribute, or incorporate
this software provided the User acknowledges this via an
explicit acknowledgment of NIST-related contributions to
the User's work. User also agrees to acknowledge, via an
explicit acknowledgment, that any modifications or
alterations have been made to this software before
redistribution.
******************************************************************************/
static char *SCCS_ID = "%Z% Version %I% Created %G% at %U%";
I 3
/***** Author: Dr. James R. Lyle, NIST/SDCT/SQG ****/
E 3
# include <stdio.h>
# include <dos.h>
# include "zbios.h"
# include <string.h>
# include "sha.h"
# include <time.h>
# include <malloc.h>


void print_help(char *p)
{
	static int been_here = 0;
	if (been_here) return;
	been_here = 1;

	printf ("Usage: %s /[s|m]\n",p);
	printf ("/m\tUse master drive (default)\n");
	printf ("/s\tUse slave drive\n"); 
	printf ("/bios\tUse int 13 bios without extensions (default)\n");
D 3
	printf ("/xbios\tUse use bios extensions drive\n");
E 3
I 3
	printf ("/xbios\tUse int 13 bios extensions\n");
	printf ("/before\tName logfile hashblog.txt (before test)\n");
	printf ("/before\tName logfile hashalog.txt (after test)\n");
E 3
	printf ("/?\tPrint this option list\n");
}
main (int np, char **p)
{
	int	drive = 0x80;
	int	try_ext = 0, help = 0;
D 3
	int	status,i,before = 0;
E 3
I 3
	int	status,i,before = -1;
E 3
	static disk_control_block *dd;
	static unsigned long lba = 0,feed,ns;
	static SHA_CTX context;
	static time_t from,till,start_time;
	static long et,tmin,min,sec,hours;
	float	nf,pc = 3.14,flba;
	FILE *log;
	int	is_debug = 0;
	static chs_addr	a = {0ul,0ul,1ul};
	static char comment[80];

	time(&from);
   _stklen = 2*_stklen;
	printf ("\n%s compiled at %s on %s\n", p[0],
		__TIME__,__DATE__);

	for (i = 1; i < np; i++){
		if (strcmp(p[i],"/s") == 0) drive = 0x81;
		else if (strcmp (p[i],"/m")== 0) drive = 0x80;
		else if (strcmp (p[i],"/?") == 0) help = 1;
		else if (strcmp (p[i],"/bios")== 0) try_ext = 0;
		else if (strcmp (p[i],"/xbios")== 0) try_ext = 1;
		else if (strcmp (p[i],"/debug")== 0) is_debug = 1;
		else if (strcmp (p[i],"/before")== 0) before = 1; 
		else if (strcmp (p[i],"/after")== 0) before = 0;
		else help = 1;
		if (help){
			print_help(p[0]);
			return 0;
		}
	}
I 3
	if (before < 0){
		printf ("%s must select /before or /after\n",p[0]);
		print_help(p[0]);
		return 1;
	}
E 3
	printf ("Insert log floppy, type log comment and press return\n");
	gets(comment);
	if (before) log = fopen("a:\hashblog.txt","w");
	else log = fopen("a:\hashalog.txt","w");
	if (log == NULL) log = stdout;
	printf ("drive 0x%2X (%s) %s\n",drive,drive==0x80?"master":"slave",
		try_ext?"Try BIOS extensions":"No BIOS extensions");
	dd = open_disk (drive,try_ext,&status);

	if (status){
		printf ("%s could not read drive %x status code %d\n",
			p[0],drive,status);
		fprintf (log,"%s could not read drive %x status code %d\n",
			p[0],drive,status);
		return 1;
	}
	SHAInit(&context);
	ns = n_tracks(dd);
	time(&start_time);
	if (is_debug) ns = 1000;
	feed = ns/20;
	if (feed <= 0) feed = 1;
	printf ("%ld sectors feed back %ld\n",n_sectors(dd),feed);fflush(stdout);
	for (lba = 0; lba < ns; lba++){
		a.cylinder = lba/dd->disk_max.head;
		a.head = lba%dd->disk_max.head;
		disk_read (dd, &a);
		for (i = 0; i < 63; i+=7)
			SHAUpdate(&context,(unsigned char *)&dd->buffer[i][0],512*7*8);
		if ((lba==5) || (lba%feed == 0)) {
			flba = lba;
			nf = ns;
			pc = (100.0*flba)/nf;
			time (&till);
			if (lba) et = (till - start_time)*(nf - flba)/flba;
			else et = 0;
			tmin = et/60;
			sec = et%60;
			hours = tmin/60;
			min = tmin%60;

			printf ("at %lu (%3.0f%%) %ld:%ld:%ld\n",lba,pc,hours,min,sec);
		}
	}
	SHAFinal(&context);
	printf ("Disk hash = ");
	for (i = 0; i < 5; i++)
		printf ("%08lX",context.H[i]);
		printf("\n");
	time(&till);
	et = till - from;
	tmin = et/60;
	sec = et%60;
	hours = tmin/60;
	min = tmin%60;
	fprintf (log,"%s %s\ncompiled %s at %s with BCC version %x\n",
		p[0],SCCS_ID,__DATE__,__TIME__,__BORLANDC__);
	fprintf (log,"%s\n",SCCS_Z);
   fprintf (log,"Comment: %s\n",comment);
	fprintf (log,"run start %s",ctime(&from));
	fprintf (log,"run finish %s",ctime(&till));
	fprintf (log,"drive 0x%2X (%s) %s\n",drive,drive==0x80?"master":"slave",
		try_ext?"use BIOS extensions":"no BIOS extensions");

	fprintf (log,"elapsed time %ld:%ld:%ld\n",hours,min,sec);
	fprintf (log,"Disk SHA-1 hash ");
	for (i = 0; i < 5; i++)
		fprintf (log,"%08lX",context.H[i]);
		fprintf(log,"\n");
	fprintf (log,"Normal exit %s %ld sectors hashed\n",p[0],lba*63);
	printf ("elapsed time %ld:%ld:%ld\n",hours,min,sec);
	printf ("Normal exit %s %ld sectors hashed\n",p[0],lba*63);
	return 0;
}

E 4
I 4
/******************************************************************************
The software provided here is released by the National
Institute of Standards and Technology (NIST), an agency of
the U.S. Department of Commerce, Gaithersburg MD 20899,
USA.  The software bears no warranty, either expressed or
implied. NIST does not assume legal liability nor
responsibility for a User's use of the software or the
results of such use.

Please note that within the United States, copyright
protection, under Section 105 of the United States Code,
Title 17, is not available for any work of the United
States Government and/or for any works created by United
States Government employees. User acknowledges that this
software contains work which was created by NIST employees
and is therefore in the public domain and not subject to
copyright.  The User may use, distribute, or incorporate
this software provided the User acknowledges this via an
explicit acknowledgment of NIST-related contributions to
the User's work. User also agrees to acknowledge, via an
explicit acknowledgment, that any modifications or
alterations have been made to this software before
redistribution.
******************************************************************************/
D 5
static char *SCCS_ID = "%Z% Version %I% Created %G% at %U%";
E 5
I 5
static char *SCCS_ID[] = {"%Z% %M% Version %I% Created %G% at %U%",
			__DATE__,__TIME__};
E 5
/***** Author: Dr. James R. Lyle, NIST/SDCT/SQG ****/
# include <stdio.h>
# include <dos.h>
# include "zbios.h"
# include <string.h>
# include "sha.h"
# include <time.h>
# include <malloc.h>
I 5
/*****************************************************************
Compute a SHA-1 hash of a disk and write the result to a logfile
	The execution model is to run diskhash to compute a (before)
	hash, use some program to access the disk, and run diskhash
	again to compute an (after) hash. If the two hash values are the
	same then the access program did not change the disk. If the
	hash values differ, then the access program changed the disk.
E 5

I 5
High level design:
	Decode command line
	open disk
	init hash
	for each disk sector
		read sector
		update hash
	log final hash value
E 5

I 5
*****************************************************************/

E 5
void print_help(char *p)
{
	static int been_here = 0;
	if (been_here) return;
	been_here = 1;

D 5
	printf ("Usage: %s /[s|m]\n",p);
	printf ("/m\tUse master drive (default)\n");
	printf ("/s\tUse slave drive\n"); 
	printf ("/bios\tUse int 13 bios without extensions (default)\n");
	printf ("/xbios\tUse int 13 bios extensions\n");
E 5
I 5
	printf ("Usage: %s test-case host drive [/options]\n",p);
E 5
	printf ("/before\tName logfile hashblog.txt (before test)\n");
D 5
	printf ("/before\tName logfile hashalog.txt (after test)\n");
	printf ("/x nnn\thash nnn extra tracks beyond BIOS\n");
E 5
I 5
	printf ("/comment \" ... \"\tGive comment on command line\n");
	printf ("/after\tName logfile hashalog.txt (after test)\n");
	printf ("\tNote that one of /before & /after is required\n");
I 9
	printf ("/new_log\tStart a new log file (default is append to old log file)\n");
E 9
E 5
	printf ("/?\tPrint this option list\n");
}
main (int np, char **p)
{
	int	drive = 0x80;
D 6
	int	try_ext = 0, help = 0;
E 6
I 6
	int	help = 0;
E 6
	int	status,i,before = -1;
	static disk_control_block *dd;
D 5
	static unsigned long lba = 0,feed,ns,xt = 0;
E 5
I 5
	static unsigned long lba = 0,ns;
E 5
	static SHA_CTX context;
D 5
	static time_t from,till,start_time;
	static long et,tmin,min,sec,hours;
	float	nf,pc = 3.14,flba;
E 5
I 5
	static time_t from,start_time;
E 5
	FILE *log;
	int	is_debug = 0;
D 5
	static chs_addr	a = {0ul,0ul,1ul};
	static char comment[80];
E 5
I 5
D 9
	static char comment[200] = "";
E 9
I 9
	static char comment[200] = "",*access = "a";
E 9
	unsigned char *buffer;
E 5

	time(&from);
D 5
   _stklen = 2*_stklen;
E 5
I 5
	_stklen = 2*_stklen;
E 5
	printf ("\n%s compiled at %s on %s\n", p[0],
		__TIME__,__DATE__);

D 5
	for (i = 1; i < np; i++){
		if (strcmp(p[i],"/s") == 0) drive = 0x81;
		else if (strcmp (p[i],"/m")== 0) drive = 0x80;
		else if (strcmp (p[i],"/?") == 0) help = 1;
		else if (strcmp (p[i],"/bios")== 0) try_ext = 0;
		else if (strcmp (p[i],"/xbios")== 0) try_ext = 1;
E 5
I 5
	if (np < 4) help = 1;
	else sscanf (p[3],"%x",&drive);
	for (i = 4; i < np; i++){
		if (strcmp (p[i],"/?") == 0) {help = 1; break;}
E 5
		else if (strcmp (p[i],"/debug")== 0) is_debug = 1;
		else if (strcmp (p[i],"/before")== 0) before = 1; 
		else if (strcmp (p[i],"/after")== 0) before = 0;
I 9
		else if (strcmp (p[i],"/new_log")== 0) access = "w";
E 9
D 5
		else if (strcmp (p[i],"/x")== 0){
E 5
I 5
		else if (strcmp (p[i],"/comment")== 0){
E 5
			i++;
			if (i >= np){
D 5
				printf ("%s: /x option requires track count\n",p[0]);
				print_help(p[0]);
				return 1;
			}
			scanf (p[i],"%ld",&xt);
E 5
I 5
				printf ("%s: /comment option requires a comment\n",p[0]);
				help = 1;
			} else strcpy (comment,p[i]);
E 5
		}
		else help = 1;
D 5
		if (help){
			print_help(p[0]);
			return 0;
		}
E 5
	}
D 5
	if (before < 0){
E 5
I 5
	if ((before < 0) && (help == 0)){
E 5
		printf ("%s must select /before or /after\n",p[0]);
I 5
		help = 1;
	}
	if (help){
E 5
		print_help(p[0]);
D 5
		return 1;
E 5
I 5
		return 0;
E 5
	}
D 5
	printf ("Insert log floppy, type log comment and press return\n");
	gets(comment);
	if (before) log = fopen("a:\hashblog.txt","w");
	else log = fopen("a:\hashalog.txt","w");
	if (log == NULL) log = stdout;
	printf ("drive 0x%2X (%s) %s\n",drive,drive==0x80?"master":"slave",
		try_ext?"Try BIOS extensions":"No BIOS extensions");
E 5
I 5
D 9
	log = log_open(before?"a:\hashblog.txt":"a:\hashalog.txt",
E 9
I 9
D 10
	log = log_open(before?"a:\hashblog.txt":"a:\hashalog.txt",access,
E 10
I 10
	log = log_open(before?"a:\\hashblog.txt":"a:\\hashalog.txt",access,
E 10
E 9
D 6
					comment,SCCS_ID,p);
E 6
I 6
					comment,SCCS_ID,np,p);
E 6
	printf ("Hashing drive 0x%2X \n",drive);
E 5
D 6
	dd = open_disk (drive,try_ext,&status);
E 6
I 6
	dd = open_disk (drive,&status);
E 6
I 5
D 8
   log_disk (log,"Hash",dd);
E 8
E 5

	if (status){
D 8
		printf ("%s could not read drive %x status code %d\n",
E 8
I 8
		printf ("%s could not access drive %x status code %d\n",
E 8
			p[0],drive,status);
D 8
		fprintf (log,"%s could not read drive %x status code %d\n",
E 8
I 8
		fprintf (log,"%s could not access drive %x status code %d\n",
E 8
			p[0],drive,status);
		return 1;
	}
I 8
   log_disk (log,"Hash",dd);
E 8
	SHAInit(&context);
D 5
	ns = n_tracks(dd) + xt*63;
E 5
I 5
	ns = n_sectors(dd);
E 5
	time(&start_time);
	if (is_debug) ns = 1000;
D 5
	feed = ns/20;
	if (feed <= 0) feed = 1;
	printf ("%ld sectors feed back %ld\n",ns,feed);
E 5
	for (lba = 0; lba < ns; lba++){
D 5
		a.cylinder = lba/dd->disk_max.head;
		a.head = lba%dd->disk_max.head;
		disk_read (dd, &a);
		for (i = 0; i < 63; i+=7)
			SHAUpdate(&context,(unsigned char *)&dd->buffer[i][0],512*7*8);
		if ((lba==5) || (lba%feed == 0)) {
			flba = lba;
			nf = ns;
			pc = (100.0*flba)/nf;
			time (&till);
			if (lba) et = (till - start_time)*(nf - flba)/flba;
			else et = 0;
			tmin = et/60;
			sec = et%60;
			hours = tmin/60;
			min = tmin%60;

			printf ("at %lu (%3.0f%%) %ld:%ld:%ld\n",lba,pc,hours,min,sec);
		}
E 5
I 5
		status = read_lba(dd,lba,&buffer);
		SHAUpdate(&context,(unsigned char *)buffer,512*8);
			/* give user feedback on progress and estimate completion */
		feedback (from, (unsigned long) 0, lba,ns);
E 5
	}
	SHAFinal(&context);
D 5
	printf ("Disk hash = ");
	for (i = 0; i < 5; i++)
E 5
I 5
	printf ("Disk hash (%lu sectors) = ",ns); 
	fprintf (log,"Disk hash (%lu sectors) = ",ns);
	for (i = 0; i < 5; i++){
E 5
		printf ("%08lX",context.H[i]);
D 5
		printf("\n");
	time(&till);
	et = till - from;
	tmin = et/60;
	sec = et%60;
	hours = tmin/60;
	min = tmin%60;
	fprintf (log,"%s %s\ncompiled %s at %s with BCC version %x\n",
		p[0],SCCS_ID,__DATE__,__TIME__,__BORLANDC__);
	fprintf (log,"%s\n",SCCS_Z);
   fprintf (log,"Comment: %s\n",comment);
	fprintf (log,"run start %s",ctime(&from));
	fprintf (log,"run finish %s",ctime(&till));
	fprintf (log,"drive 0x%2X (%s) %s\n",drive,drive==0x80?"master":"slave",
		try_ext?"use BIOS extensions":"no BIOS extensions");

	fprintf (log,"elapsed time %ld:%ld:%ld\n",hours,min,sec);
	fprintf (log,"Disk SHA-1 hash ");
	for (i = 0; i < 5; i++)
E 5
		fprintf (log,"%08lX",context.H[i]);
D 5
		fprintf(log,"\n");
	fprintf (log,"Normal exit %s %ld sectors hashed\n",p[0],lba*63);
	printf ("elapsed time %ld:%ld:%ld\n",hours,min,sec);
	printf ("Normal exit %s %ld sectors hashed\n",p[0],lba*63);
E 5
I 5
	}
	printf("\n");
	fprintf(log,"\n");
	log_close (log,from);
E 5
	return 0;
}
E 4
E 1
