h11645
s 00001/00001/00169
d D 3.1 01/10/11 12:40:26 jimmy 3 2
c Increment Version number to 3.1
e
s 00004/00002/00166
d D 1.2 01/07/10 11:22:13 jimmy 2 1
c add option for overwrite logfile; make default action append to logfile
e
s 00168/00000/00000
d D 1.1 01/05/15 09:01:43 jimmy 1 0
c date and time created 01/05/15 09:01:43 by jimmy
e
u
U
f e 0
t
T
I 1
/******************************************************************************
The software provided here is released by the National
Institute of Standards and Technology (NIST), an agency of
the U.S. Department of Commerce, Gaithersburg MD 20899,
USA.  The software bears no warranty, either expressed or
implied. NIST does not assume legal liability nor
responsibility for a User's use of the software or the
results of such use.

Please note that within the United States, copyright
protection, under Section 105 of the United States Code,
Title 17, is not available for any work of the United
States Government and/or for any works created by United
States Government employees. User acknowledges that this
software contains work which was created by NIST employees
and is therefore in the public domain and not subject to
copyright.  The User may use, distribute, or incorporate
this software provided the User acknowledges this via an
explicit acknowledgment of NIST-related contributions to
the User's work. User also agrees to acknowledge, via an
explicit acknowledgment, that any modifications or
alterations have been made to this software before
redistribution.
******************************************************************************/
static char *SCCS_ID[] = {"%Z% %M% Version %I% Created %G% at %U%",
			__DATE__,__TIME__};
/***** Author: Dr. James R. Lyle, NIST/SDCT/SQG ****/
# include <stdio.h>
# include "zbios.h"
# include <time.h>
# include <string.h>
# include <malloc.h>
# include <fcntl.h>
# include <io.h>
/*****************************************************************
Corrupt an image file
CORRUPT is used to corrupt an image file by changing a
single selected byte in an image file.
CORRUPT logs the original content of the selected byte,
the replacement value, the offset of the byte within the file and
the file name.


program outline

	get command line

	open the file

	read byte to change

	write back new value

	read back to confirm

	log results

*****************************************************************/

void print_help(char *p)
{
	static int been_here = 0;
	if (been_here) return;
	been_here = 1;

	printf ("Usage: %s test-case host file_name offset hex_value\n",p);
	printf ("/comment \" ... \"\tGive comment on command line\n");
I 2
	printf ("/new_log\tStart a new log file (default is append to old log file)\n");
E 2
	printf ("/?\tPrint this option list\n");
}
# define ERR -1
main (int np, char **p)
{
	int	help = 0,i, /* loop index */
			f /* file descriptor */;
	int	status /* return code for read/write operations */;
	static time_t from /* start time */;
	FILE *log /* the log file */;
D 2
	static char comment[200] = "";
E 2
I 2
	static char comment[200] = "",*access = "a";
E 2
	long	at, /* file offset (location) to make change */
			seek_return; /* return value from seek call */
	char	old_char = 'a', /* the char originally in the file */
			new_char = 'Z', /* the replacement character */
			verify_char = '0'; /* after writting, read the char back to make sure */

	time(&from);
	printf ("\n%s compiled at %s on %s\n", p[0],
		__TIME__,__DATE__);

		/* get the command line */
	if (np < 6) help = 1;
	for (i = 6; i < np; i++){
		if (strcmp (p[i],"/?") == 0) {help = 1; break;}
I 2
		else if (strcmp (p[i],"/new_log")== 0) access = "w";
E 2
		else if (strcmp (p[i],"/comment")== 0){
			i++;
			if (i >= np){
				printf ("%s: /comment option requires a comment\n",p[0]);
				help = 1;
			} else strcpy (comment,p[i]);
		}
		else help = 1;
	}
	if (help){
		print_help(p[0]);
		return 0;
	}
	/* open the file named in p[3] */
	f = open (p[3],O_RDWR);
	if (f == ERR){
		printf ("%s: Open %s failed\n",p[0],p[3]);
		return 1;
	}
	/* get the offset value */
	status = sscanf (p[4],"%ld",&at);
	if (status != 1){
		printf ("%s: Offset value (%s) is not valid\n",p[0],p[4]);
		return 1;
	}
	/* get the replacement character */
	status = sscanf (p[5],"%x",&new_char);
	if (status != 1){
		printf ("%s: Replacement value (%s) is not valid\n",p[0],p[5]);
		return 1;
	}
	/* position to read from the offset */
	seek_return = lseek (f,at,SEEK_SET);
	if (seek_return == ERR){
		printf ("%s: Offset %ld is not valid for %s\n",p[0],at,p[3]);
		return 1;
	}
	/* read the current contents */
	status = read (f,&old_char,1);
	if (status != 1){
		printf ("%s: Read failed\n",p[0]);
		return 1;
	}
	/* reset the file position */
	seek_return = lseek (f,at,SEEK_SET);
	if (seek_return == ERR){
		printf ("%s: Seek to %ld on %s after read failed\n\n",p[0],at,p[3]);
		return 1;
	}
	/* write the new (replacement) value */
	status = write (f,&new_char,1);
	if (status != 1){
		printf ("%s: Write failed\n",p[0]);
		return 1;
	}
	/* reset the file position */
	seek_return = lseek (f,at,SEEK_SET);
	if (seek_return == ERR){
		printf ("%s: Seek to %ld on %s after write failed\n",p[0],at,p[3]);
		return 1;
	}
	/* read back what was written */
	status = read (f,&verify_char,1);
	if (status != 1){
		printf ("%s: Verify read failed\n",p[0]);
		return 1;
	}
	/* it better match! */
	if (verify_char != new_char){
		printf ("%s: verify failed: char read back (0x%02X) should be (0x%02x)\n",
			p[0],old_char,new_char);
		return 1;
	}
	 /* ran OK, log results */
D 2
	log = log_open("a:\corlog.txt",comment,SCCS_ID,np,p);
E 2
I 2
D 3
	log = log_open("a:\corlog.txt",access,comment,SCCS_ID,np,p);
E 3
I 3
	log = log_open("a:\\corlog.txt",access,comment,SCCS_ID,np,p);
E 3
E 2

	fprintf (log,"Change byte %ld of file %s from 0x%02X to 0x%02X\n",
		at,p[3],old_char,new_char);
	printf ("Change byte %ld of file %s from 0x%02X to 0x%02X\n",
		at,p[3],old_char,new_char);
	log_close (log,from);
	return 0;
}
E 1
