h31947
s 00001/00001/00906
d D 3.1 01/10/11 12:40:24 jimmy 8 7
c Increment Version number to 3.1
e
s 00030/00004/00877
d D 2.6 01/07/13 13:22:05 jimmy 7 6
c Changed summary table format
e
s 00007/00003/00874
d D 2.5 01/07/10 11:22:13 jimmy 6 5
c add option for overwrite logfile; make default action append to logfile
e
s 00017/00008/00860
d D 2.4 01/06/12 13:58:05 jimmy 5 4
c making error message consistent
e
s 00397/00229/00471
d D 2.3 01/05/15 08:58:42 jimmy 4 3
c revisions for batch exec, commentary and minor revisions
e
s 00003/00003/00697
d D 2.2 00/10/12 14:49:41 jimmy 3 2
c other fill character & count reversed in printf
e
s 00000/00000/00700
d D 2.1 00/10/10 15:36:36 jimmy 2 1
c adjust release number
e
s 00700/00000/00000
d D 1.1 00/10/10 15:34:07 jimmy 1 0
c date and time created 00/10/10 15:34:07 by jimmy
e
u
U
f e 0
t
T
I 1
D 3
static char *SCCS_ID = "%Z% Version %I% Created %G% at %U%";
E 3
I 3
D 4
static char *SCCS_ID = "@(#) Version 2.1 Created 10/10/00 at 15:36:36";
E 4
I 4
static char *SCCS_ID[3] = {"%Z% %M% Version %I% created %G% at %U%",
				__DATE__,__TIME__};
E 4
E 3
/******************************************************************************
The software provided here is released by the National
Institute of Standards and Technology (NIST), an agency of
the U.S. Department of Commerce, Gaithersburg MD 20899,
USA.  The software bears no warranty, either expressed or
implied. NIST does not assume legal liability nor
responsibility for a User's use of the software or the
results of such use.

Please note that within the United States, copyright
protection, under Section 105 of the United States Code,
Title 17, is not available for any work of the United
States Government and/or for any works created by United
States Government employees. User acknowledges that this
software contains work which was created by NIST employees
and is therefore in the public domain and not subject to
copyright.  The User may use, distribute, or incorporate
this software provided the User acknowledges this via an
explicit acknowledgment of NIST-related contributions to
the User's work. User also agrees to acknowledge, via an
explicit acknowledgment, that any modifications or
alterations have been made to this software before
redistribution.
******************************************************************************/
/***** Author: Dr. James R. Lyle, NIST/SDCT/SQG ****/
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include "zbios.h"
# include <malloc.h>
# include <time.h>

D 4
# define N_RANGE 15
typedef struct {unsigned long from,to;} lba_range;
typedef struct {
	int	n;
	long is_more;
	lba_range r[N_RANGE];
	} range_list,*range_ptr;
E 4
I 4
/******************************************************************************
Compare two disks by partitions: ADJCMP
The ADJCMP program is used to compare corresponding sectors of two disks where
the corresponding sectors are located at different addresses on the source disk
and the destination disk. Some disk imaging tools optionally create a
destination with partitions aligned to disk cylinder boundaries. All the
content of the source disk is reproduced on the destination, just not at the
same location as on the source disk.
ADJCMP divides the source and destination into disk chunks. Where a disk
chunk is defined as a group of contiguous sectors as described below.
Corresponding disk chunks between the source and destination are identified and
sectors at the same location relative to the first sector of the corresponding
chunk are compared.  A disk chunk is one of the following:
 Partition defined in the partition table
 Partition boot track (the track just before the start of the partition)
 Unallocated sectors (a group of contiguous sectors not part of any partition)
ADJCMP automatically designates disk chunks found in the same order on the
source and destination as corresponding. The user may optionally do the
assignments by an interactive dialog.
A comparison report is logged for each disk chunk.
E 4

D 4
range_ptr create_range_list(void)
{
	range_ptr	p;
	p = (range_ptr) malloc (sizeof(range_list));
	p->n = 0;
	p->is_more = 0;
	return p;
}
E 4
I 4
ADJCMP command line
adjcmp case host src-drv src-fill dst-drv dst-fill [/opts]
E 4

D 4
void add_to_range (range_ptr r, unsigned long x)
{
	int k = r->n - 1;
	if (r->n){
		if (r->r[k].to + 1 == x) r->r[k].to = x;
		else {
			k++;
			if (k >= N_RANGE){
				r->is_more++;
				return;
			}
			r->n++;
			r->r[k].from = r->r[k].to = x;
		}
E 4
I 4
Parameter	Description
case			A test case identifier
host			The name of the computer running the test
src-drv		The drive number in hex. Possible values begin at 80. The drive
				where the source drive is mounted.
src-fill		A two digit hex value, used to fill each sector.
dst-drv		The drive number in hex. Possible values begin at 80. The drive
				where the destination drive is mounted.
dst-fill		A two digit hex value, used to fill each sector.
/comment ""	A comment for the test log file. If this option is not used,
				the program prompts for a log floppy to be inserted. If this option
				is used, then a log floppy is assumed to be already loaded.
/assign		Engage the user in a dialog to assign corresponding regions of the
				source and destination disks for comparison.
/?				Print a summary of command options and exit


Program outline:
get command line
layout the source disk (identify the chunks)
layout the destination disk (identify the chunks)
assign corresponding chunks
compare source to destination (chunk by chunk)
log results

Disk layout (find all the chunks):
let n = # of sectors on disk
set at = 0
while (at < n){
	if (there is a partition that starts with "at") {
		make the partition a chunk, set "at" to partition end + 1
E 4
	}
	else {
D 4
		r->n = 1;
		r->r[0].from = r->r[0].to = x;
E 4
I 4
		find first partition (or the end of the disk) that starts
		after "at". Make the space from "at" up the partition a chunk.
		set "at" to the partition start (or end of disk)
E 4
	}
}

D 4
void print_range_list(FILE *log, range_ptr r)
{
	int	i,nc = 25;
E 4

D 4
	for (i = 0; i < r->n; i++){
		if(i)nc += fprintf(log,", ");
		if (nc > 50){
			nc = 0;
			fprintf (log,"\n");
		}
		if (r->r[i].from == r->r[i].to)
			nc += fprintf (log,"%ld",r->r[i].from);
		else nc += fprintf (log,"%ld-%ld",r->r[i].from,r->r[i].to);
	}
	if (r->is_more) fprintf (log,". . . + %ld more\n",r->is_more);
	else fprintf (log,"\n");
}
E 4
I 4
******************************************************************************/
E 4



typedef struct {
	pte_ptr	pt;
	char		chunk_class; /* partition, boot track, unalloc, fill */
D 4
	unsigned long	lba_start,
						n_sectors; } layout_rec, *layout_ptr;
E 4
I 4
	unsigned long	lba_start, /* starting address of the chunk */
						n_sectors; /* size of the chunk */} layout_rec, *layout_ptr;
typedef struct { /* summary totals */
	unsigned long boot_track_diffs;   /* boot track total diffs */
	unsigned long partition_diffs; 	/* total diffs in partitions */
I 7
	unsigned long unalloc_diffs; 		/* total diffs in unallocated chunks */
E 7
	unsigned long fill_zero;         /* partition fill area zero filled */
	unsigned long fill_non_zero;     /* partition fill area not zero */
	unsigned long excess_zero;       /* unallocated areas zero filled */
	unsigned long excess_non_zero;   /* unallocated areas not zero */
I 7
	unsigned long	n_common;			/* number of sectors common to src & dst */
	unsigned long  n_common_unalloc; /* number of common unallocated sectors */
E 7
	int				n_boot_tracks;    /* number of boot tracks */
	int				n_partitions;     /* number of partitions */
I 7
	int				n_unalloc;			/* number of unallocated chunks */
E 7
	} totals_rec, *totals_ptr;
E 4

D 4
void scan_region (FILE *log, disk_control_ptr dst_disk,
	unsigned long common, unsigned long dst_n, unsigned char src_fill_char,
	unsigned char dst_fill_char)
E 4
I 4

/******************************************************************************
Examine a part of the destination disk that does not correspond to any area
on the source disk. This is either (1) the sectors of a destination chunk that
do not correspond to the source sectors of the corresponding chunk. or
(2) destination chunk of sectors not allocated to a corresponding source chunk.
To say this another way, source partitions are compared to destination partitions
that are a little larger. Sectors in (1) above are the excess destination sectors.
If the source has unallocated (i.e., not in a partition) sectors between two
partitions, the area between is treated as a partition. Sectors in (2) are the
excess sectors after the last partition on the destination.
******************************************************************************/
void scan_region (FILE *log, /* the log file */
	disk_control_ptr dst_disk, /* the destination disk */
	unsigned long common,  /* starting sector LBA address */
	unsigned long dst_n,   /* number of sectors to scan */
	unsigned char src_fill_char, /* the source fill character */
	unsigned char dst_fill_char, /* the destination fill character */
	time_t start_time, /* time the program started running */
	unsigned long *tz, /* update value: running total of zero fill sectors */
	unsigned long *tnz) /* update value: running total of non-zero sectors */
E 4
{
D 4
	range_ptr z_r = create_range_list(),
				 sf_r = create_range_list(),
				 df_r = create_range_list(),
				 of_r = create_range_list(),
				 o_r = create_range_list();
	unsigned char *dst_buff,other_fill_char = 0;
	int	  dst_status;
	unsigned long lba = 0,feed,
		nz,nfill,dst_lba,
		zero = 0,sfill = 0, dfill = 0,ofill = 0,other = 0;
	int	i; int xxx = 10, other_fill_seen = 0, new_fill = 0;
E 4
I 4
	range_ptr z_r = create_range_list(), /* range of zero fill sectors */
				 sf_r = create_range_list(), /* range of source fill sectors */
				 df_r = create_range_list(), /* range of destination fill sectors */
				 of_r = create_range_list(), /* range of other fill sectors */
				 o_r = create_range_list(); /* range of other sectors */
	unsigned char *dst_buff, /* the sector to scan */
						other_fill_char = 0; /* last other fill char seen */
	int	  dst_status; /* disk I/O status return */
	unsigned long lba = 0, /* the sector relative to start address */
						nz,  /* count of zero bytes in a sector */
						nfill, /* count of fill bytes in a sector */
						dst_lba, /* the absolute lba of sector to examine */
						zero = 0, /* number of zero sectors */
						sfill = 0, /* number of sectors filled with source byte */
						dfill = 0, /* number of sectors filled with dst byte */
						ofill = 0, /* number of sectors filled with something else */
						other = 0; /* count of other sectors */
	int				i, /* look index */
						other_fill_seen = 0, /* flag indicating fill other than src/dst */
						new_fill = 0;
E 4

D 4
   
E 4
I 4

E 4
		zero = 0;
		ofill = sfill = dfill = 0;
		other = 0;
D 4
		feed = (dst_n - common)/5;
E 4
		printf ("scanning %ld unmatched sectors: %ld--%ld\n",dst_n-common,
D 4
			common,dst_n);   
E 4
I 4
			common,dst_n);
E 4
		fprintf (log,"scanning %ld unmatched sectors: %ld--%ld\n",dst_n-common,
			common,dst_n);
D 4
		printf ("Feed back every %ld sectors\n",feed);
E 4
I 4

/******************************************************************************
Loop to scan dst_n sectors from common up to common + dst_n
******************************************************************************/
E 4
		dst_lba = common;
		for (lba = common; lba < dst_n; lba++){
D 4
			if ((dst_n - lba)%feed == 0){
				printf ("%6.2f%%\n",
					((lba - common)*100.0)/(dst_n - common));
			}
E 4
I 4
			feedback (start_time,0,dst_lba,n_sectors(dst_disk));
E 4
			dst_status = read_lba(dst_disk,dst_lba++,&dst_buff);
			if (dst_status){
D 5
				fprintf (log,"read error at %ld on dst disk\n",dst_lba-1);
E 5
I 5
				/*fprintf (log,"read error at %ld on dst disk\n",dst_lba-1); */
				fprintf (log,"dst read error 0x%02X on track starting at lba %ld\n",
					dst_status,dst_lba-1);
E 5
				exit(1);
			}
			nz = 0;
			nfill = 0;
I 4
/******************************************************************************
scan the sector, count number of zero bytes and number of fill bytes.
To count fill bytes: assume sector is filled (from diskwipe) then ...
bytes 1-27 has the sector address and the remaining bytes are the same.
so pick byte # 30 and count the number of bytes that match dst_buff[30],
if enough match (480) then call it filled. The magic constants 30 and 480
allow some room for diskwipe to be off by a few bytes.
******************************************************************************/
E 4
			for (i = 0; i < 512; i++){
				if ( dst_buff[i] == 0) nz++;
				else if (dst_buff[i] == dst_buff[30]) nfill++;
			}
D 4
			if (nz == 512){zero++; add_to_range(z_r,lba);}
			else if ((nfill > 480)&& (dst_buff[30]!= 0x00)){
					if (dst_buff[30] == src_fill_char){
E 4
I 4
			if (nz == 512){zero++; add_to_range(z_r,lba);} /* zero sector */
			else if ((nfill > 480)&& (dst_buff[30]!= 0x00)){ /* filled sector */
					if (dst_buff[30] == src_fill_char){ /* src fill */
E 4
						sfill++;
						add_to_range(sf_r,lba);
					}
D 4
					else if (dst_buff[30] == dst_fill_char){
E 4
I 4
					else if (dst_buff[30] == dst_fill_char){ /* dst fill */
E 4
						dfill++;
						add_to_range(df_r,lba);
					}
D 4
					else {
E 4
I 4
					else { /* filled with something other than src or dst!! */
E 4
						ofill++;
						add_to_range(of_r,lba);
						if (other_fill_seen){
							if (dst_buff[30] != other_fill_char) new_fill = 1;
						}
D 4
						else {
E 4
I 4
						else {  /* remember the other fill char */
E 4
							other_fill_char = dst_buff[30];
							new_fill = 0;
						}
					}
			}
D 4
			else{ other++;
E 4
I 4
			else{ other++; /* not zero and not filled */
E 4
				add_to_range (o_r,lba);
D 4
				if (xxx < 5){ chs_addr aaa;
					printf ("other %ld (%ld) ",lba,dst_lba - 1);
					lba_to_chs (dst_disk,dst_lba-1,&aaa);
					printf ("%ld/%ld/%ld ",aaa.cylinder,
						aaa.head,aaa.sector);
					printf ("status %d ",dst_status);
					printf ("This sector  %04ld/%03ld/%02ld\n",
						dst_disk->this_track.cylinder,
						dst_disk->this_track.head,
						dst_disk->this_track.sector);
					printf ("nz %d nfill %d\n",nz,nfill);
					if (nz == 1) printf ("%s\n",dst_buff); 
					fprintf (log,"other %ld (%ld) ",lba,dst_lba - 1);
					fprintf (log,"%ld/%ld/%ld ",aaa.cylinder,
						aaa.head,aaa.sector);
					fprintf (log,"status %d ",dst_status);
					fprintf (log,"This sector  %04ld/%03ld/%02ld\n",
						dst_disk->this_track.cylinder,
						dst_disk->this_track.head,
						dst_disk->this_track.sector);
					fprintf (log,"nz %d nfill %d\n",nz,nfill);
					if (nz == 1) fprintf (log,"%s\n",dst_buff);
					xxx++;}
E 4
			}
		}
I 4
/******************************************************************************
Log results
******************************************************************************/
E 4
		fprintf (log,"Zero fill:           %ld\n",zero);
		fprintf (log,"Src Byte fill (%02X): %ld\n",src_fill_char,sfill);
D 6
		fprintf (log,"Dst Byte fill (%02X): %ld\n",dst_fill_char,dfill);
E 6
I 6
		if (src_fill_char == dst_fill_char )
			fprintf (log,"Dst Fill Byte same as Src Fill Byte\n");
		else fprintf (log,"Dst Byte fill (%02X): %ld\n",dst_fill_char,dfill);
E 6
D 3
		fprintf (log,"Other fill   %c(%02X): %ld\n",new_fill?'+':' ',ofill,
			other_fill_char);
E 3
I 3
		fprintf (log,"Other fill   %c(%02X): %ld\n",new_fill?'+':' ',
			other_fill_char,ofill);
E 3
		fprintf (log,"Other no fill:        %ld\n",other);
D 4
	fprintf (log,"Zero fill range: "); print_range_list(log,z_r);
	fprintf (log,"Src fill range: "); print_range_list(log,sf_r);
	fprintf (log,"Dst fill range: "); print_range_list(log,df_r);
	fprintf (log,"Other fill range: "); print_range_list(log,of_r);
	fprintf (log,"Other not filled range: "); print_range_list(log,o_r);
E 4
I 4
	print_range_list (log,"Zero fill range: ",z_r);
	print_range_list (log,"Src fill range: ",sf_r);
	print_range_list (log,"Dst fill range: ",df_r);
	print_range_list (log,"Other fill range: ",of_r);
	print_range_list (log,"Other not filled range: ",o_r);
E 4

D 4

E 4
I 4
/******************************************************************************
Update running totals for summary
******************************************************************************/
	*tz = *tz + zero;
	*tnz = *tnz + sfill + dfill + ofill + other;
E 4
}

D 4
int cmp_region (FILE *log,
E 4
I 4
/******************************************************************************
Compare a source chunk to a destination chunk
log number of sectors compared, # match, # diff, etc
If dst is larger, (almost certain) then run scan_region on excess sectors
******************************************************************************/
int cmp_region (FILE *log, /* the log file */
	/* source parameters: disk, chunk description, fill char */
E 4
	disk_control_ptr src_disk,layout_ptr src, char src_fill,
D 4
	disk_control_ptr dst_disk,layout_ptr dst, char dst_fill)
E 4
I 4
	/* destination parameters: disk, chunk description, fill char */
	disk_control_ptr dst_disk,layout_ptr dst, char dst_fill,
	time_t start_time, /* time the program started running (for user feedback) */
	totals_ptr t) /* summary totals */
E 4
{
D 4
	unsigned char *src_buff, *dst_buff;
	int	 src_status, dst_status;
	unsigned long lba = 0,feed,common,diffs = 0,
		src_lba,dst_lba,
		byte_diffs = 0,match = 0;
	int	big_src = 0,big_dst = 0,is_diff,i;
	range_ptr d_r = create_range_list();
E 4
I 4
	unsigned char *src_buff, *dst_buff; /* sector read buffers */
	int	 src_status, dst_status;  /* disk read status return */
	unsigned long lba = 0, /* index for main loop; relative sector in partition */
					common, /* number of sectors with both a src and dst sector */
					diffs = 0, /* number of sectors that differ */
					src_lba,  /* absolute LBA of src sector */
					dst_lba,  /* absolute LBA of dst sector */
					byte_diffs = 0, /* number of bytes that differ */
					match = 0; /* number of sectors that match */
	int	big_src = 0, /* src is bigger than dst */
			big_dst = 0, /* dst is bigger than src */
			is_diff, /* src and dst do not match */
			i; /* loop index */
	range_ptr d_r = create_range_list(); /* sectors that do not match */
E 4

	if (src->n_sectors == dst->n_sectors) common = src->n_sectors;
	else if (src->n_sectors > dst->n_sectors){
		common = dst->n_sectors;
		big_src = 1;
	}
	else {
		common = src->n_sectors;
		big_dst = 1;
	}
	src_lba = src->lba_start;
	dst_lba = dst->lba_start;
D 4
	feed = common/5;
E 4
	fprintf (log,"Src base %ld Dst base %ld\n",
		src_lba,dst_lba);
D 4
	for (lba = 0; lba < common;lba++){
E 4
I 4
	for (lba = 0; lba < common;lba++){ /* main loop, scan sectors that correspond */
E 4
		is_diff = 0;
D 4
		if ((lba%feed) == 0){
			printf ("%4.0f%%\n",(lba*100.0)/common);
		}
E 4
I 4
		feedback(start_time,0,dst_lba,n_sectors(dst_disk));
E 4
		src_status = read_lba(src_disk,src_lba++,&src_buff);
		dst_status = read_lba(dst_disk,dst_lba++,&dst_buff);
D 5
		if (src_status || dst_status){
			fprintf (log,"read error at lba %ld, src %d dst %d\n",lba,src_status,
				dst_status);
			printf ("read error at lba %ld, src %d dst %d\n",lba,src_status,
				dst_status);
E 5
I 5
		if (src_status){
			fprintf (log,"src read error 0x%02X on track starting at lba %ld\n",
				src_status,lba);
			printf ("src read error 0x%02X on track starting at lba %ld\n",
				src_status,lba);
E 5
			return 1;
I 5
		}
		if (dst_status){
			fprintf (log,"dst read error 0x%02X on track starting at lba %ld\n",
				dst_status,lba);
			printf ("dst read error 0x%02X on track starting at lba %ld\n",
				dst_status,lba);
			return 1;
E 5
D 4
		}
E 4
I 4
		} /* scan the sectors, note any diffs */
E 4
		for (i = 0; i < 512; i++){
			if (src_buff[i] != dst_buff[i]){
				is_diff = 1;
				byte_diffs++;
			}
		}
D 4
		if (is_diff){
E 4
I 4
		if (is_diff){ /* rats! not a match */
E 4
			diffs++;
			add_to_range (d_r,lba);
		}
D 4
		else {
E 4
I 4
		else { /* the source and dst are the same */
E 4
			match++;
		}
D 4
	}
E 4
I 4
	} /* log results */
E 4
	fprintf (log,"Sectors compared: %12ld\n",common);
	fprintf (log,"Sectors match:    %12ld\n",match);
	fprintf (log,"Sectors differ:   %12ld\n",diffs);
	fprintf (log,"Bytes differ:     %12ld\n",byte_diffs);
D 4
	fprintf (log,"Diffs range: "); print_range_list(log,d_r);
E 4
I 4
	print_range_list(log,"Diffs range: ",d_r);
E 4
	if (big_src){
		fprintf (log,"Source (%ld) has %ld more sectors than destination (%ld)\n",
			src->n_sectors,src->n_sectors - dst->n_sectors,
			dst->n_sectors);
	}
D 4
	else if (big_dst){
E 4
I 4
	else if (big_dst){ /* dst has more sectors to examine */
E 4
		fprintf (log,"Source (%ld) has %ld fewer sectors than destination (%ld)\n",
			src->n_sectors,dst->n_sectors - src->n_sectors,
			dst->n_sectors);
		printf ("Source (%ld) has %ld fewer sectors than destination (%ld)\n",
			src->n_sectors,dst->n_sectors - src->n_sectors,
			dst->n_sectors);
D 4
		scan_region (log, dst_disk,dst_lba,dst->lba_start + dst->n_sectors,
			src_fill, dst_fill);
E 4
I 4
		if (dst->chunk_class == 'U') /* look at excess sectors in chunk */
			scan_region (log, dst_disk,dst_lba,dst->lba_start + dst->n_sectors,
				src_fill, dst_fill,start_time,
				&t->excess_zero,&t->excess_non_zero);
		else scan_region (log, dst_disk,dst_lba,dst->lba_start + dst->n_sectors,
				src_fill, dst_fill,start_time,
				&t->fill_zero,&t->fill_non_zero);
E 4
	}
I 4
/******************************************************************************
Update summary totals
******************************************************************************/
	if (dst->chunk_class == 'P'){ /* partition summary */
		t->n_partitions++;
		t->partition_diffs += diffs;
I 7
		t->n_common += common;
E 7
	}
D 7
	else if (dst->chunk_class == 'U'){ /* nothing to do for unallocated chunk */
E 7
I 7
	else if (dst->chunk_class == 'U'){ /* nothing to do for unallocated chunk */ 
		t->n_unalloc++;
		t->unalloc_diffs += diffs;
		t->n_common_unalloc += common;
E 7
	}
	else { /* boot track summary */
		t->n_boot_tracks++;
		t->boot_track_diffs += diffs;
	}
E 4
	return 0;
}

I 4
/******************************************************************************
Compare the source to the destination
Assign corresponding regions automatically
if user requests, allow user to edit assignments
For each chumk
	cmp_region
If the destination has any excess sectors: scan_region
Log summary results
******************************************************************************/
E 4
int do_compare(
I 4
	/* src parameters: disk, chunks */
E 4
		disk_control_ptr src_dcb,int src_n_regions,layout_ptr src_layout,
I 4
	/* dst parameters: disk, chunks */
E 4
		disk_control_ptr dst_dcb,int dst_n_regions,layout_ptr dst_layout,
D 4
		unsigned char src_fill, unsigned char dst_fill,FILE *log)
E 4
I 4
	/* fill characters */
		unsigned char src_fill, unsigned char dst_fill,
		FILE *log, /* log file */
		int do_dialog, /* user requests to assign corresponding chunks */
		time_t start_time) /* time the program started running */
E 4
{
	int	nm = 0,num = 0;
	static int ml[50],uml[50];
	int	ix,i,j,more = 1;
	char	ans[20];
I 4
D 7
	static totals_rec t = {0L,0L,0L,0L,0L,0L,0,0};
E 7
I 7
	static totals_rec t = {0L,0L,0L,0L,0L,0L,0L,0L,0L,0,0,0};
E 7
E 4

	if (src_n_regions <= dst_n_regions){
		nm = src_n_regions;
		for (i = 0; i < nm; i++) {uml[i] = i; ml[i] = i;}
		for (i = nm; i < dst_n_regions;i++) uml[i] = -1;
	}
	else {
		nm = dst_n_regions;
		for (i = 0; i < nm; i++) {uml[i] = i; ml[i] = i;}
		for (i = nm; i < src_n_regions;i++) ml[i] = 0;
	}

I 4
/******************************************************************************
Assign corresponding regions:
default assignment is to assume src and dst have same layout except dst may
have an extra chnuk of unallocated space at the end.
******************************************************************************/
E 4
	while (more){
		printf ("Matching regions\n%4s%10s%10s%10s%9s%10s%10s%10s\n",
		"","Start","End","Length","","Start","End","Length");
		for (i = 0; i < src_n_regions; i++){
			printf ("%2d %c %9ld %9ld %8ld => ",i,
				src_layout[i].chunk_class,src_layout[i].lba_start,
				src_layout[i].lba_start + src_layout[i].n_sectors - 1,
				src_layout[i].n_sectors);
			j = ml[i];
			printf ("%2d %c %9ld %9ld %8ld\n",j,
				dst_layout[j].chunk_class,dst_layout[j].lba_start,
				dst_layout[j].lba_start + dst_layout[j].n_sectors - 1,
				dst_layout[j].n_sectors);
		}
D 4
		printf ("OK? (y/n)\n");
		scanf ("%s", ans);
		printf ("ans %s\n",ans);
E 4
I 4
		if (do_dialog){ /* if user requested a dialog, ask if OK */
			printf ("OK? (y/n)\n");
			scanf ("%s", ans);
			printf ("ans %s\n",ans);
		}
		else ans[0] = 'y';
E 4
		if (ans[0] == 'y') more = 0;
D 4
		else {
			for (i = 0; i < dst_n_regions; i++) uml[i] = -1;
E 4
I 4
		else { /* user wants to assign chunks */
			for (i = 0; i < dst_n_regions; i++) uml[i] = -1; /* mark dst chunks free */
E 4
			printf ("\n\nMatch regions: type # of matching dst region, -1 to print list\n");
			for (i = 0; i < src_n_regions; i++){
D 4
				printf ("Find match for: ");
E 4
I 4
				printf ("Find match for: "); /* find a match for each src chunk */
E 4
				printf ("%2d %c from %ld to %ld len=%ld %8.2fMB %8.2fBMB\n",i,
					src_layout[i].chunk_class,src_layout[i].lba_start,
					src_layout[i].lba_start + src_layout[i].n_sectors - 1,
					src_layout[i].n_sectors,512.0*(float)src_layout[i].n_sectors/1000000.0,
					512.0*(float)src_layout[i].n_sectors/1048576.0);
				scanf ("%d",&ix);
D 4
				while (ix == -1){
E 4
I 4
				while (ix == -1){ /* -1 => print list of dst chunks */
E 4
					for (j = 0; j < dst_n_regions; j++){
D 4
						if (uml[j] == -1) printf ("ok ");
						else printf ("NO ");
E 4
I 4
						if (uml[j] == -1) printf ("ok "); /* available for selection */
						else printf ("NO "); /* already assigned */
E 4
						printf ("%2d %c %9ld %9ld %9ld %8.2fMB %8.2fBMB\n",j,
							dst_layout[j].chunk_class,dst_layout[j].lba_start,
							dst_layout[j].lba_start + dst_layout[j].n_sectors - 1,
							dst_layout[j].n_sectors,512.0*(float)dst_layout[j].n_sectors/1000000.0,
							512.0*(float)dst_layout[j].n_sectors/1048576.0);
					}
D 4
					printf ("Find match for: %d",i);
E 4
I 4
					printf ("Find match for: %d ",i);
E 4
					scanf("%d",&ix);
				}

				ml[i] = ix;
D 4
				if (uml[ix] != -1)
E 4
I 4
				if (uml[ix] != -1) /* dst chunk already assigned to src chunk */
E 4
					printf ("Warning dst region %d assigned to src region %d\n",
						ix,uml[ix]);
				uml[ix] = i;

			}
			nm = src_n_regions;
		}
	}
I 4
/******************************************************************************
Log chunk assignments
******************************************************************************/
E 4
		fprintf (log,"Matching regions\n");
		fprintf (log,"%4s%10s%10s%8s%8s%10s%10s%9s\n",
		"","Start","End","Length","","Start","End","Length");
		for (i = 0; i < src_n_regions; i++){
			fprintf (log,"%2d %c %9ld %9ld %8ld => ",i,
				src_layout[i].chunk_class,src_layout[i].lba_start,
				src_layout[i].lba_start + src_layout[i].n_sectors - 1,
				src_layout[i].n_sectors);
			j = ml[i];
			fprintf (log,"%2d %c %9ld %9ld %8ld\n",j,
				dst_layout[j].chunk_class,dst_layout[j].lba_start,
				dst_layout[j].lba_start + dst_layout[j].n_sectors - 1,
				dst_layout[j].n_sectors);
		}
		fprintf (log,"Unmatched destination regions\n");
		fprintf (log,"%5s%10s%10s%10s\n",
			"","Start","End","Length");
		for (j = 0; j < dst_n_regions; j++){
			if (uml[j] == -1){
				fprintf (log,"%2d%c %9ld %9ld %8ld\n",j,
					dst_layout[j].chunk_class,dst_layout[j].lba_start,
					dst_layout[j].lba_start + dst_layout[j].n_sectors - 1,
					dst_layout[j].n_sectors);
				num++;
			}
		}
I 4
/******************************************************************************
For each chunk, compare src to dst
******************************************************************************/
		fprintf (log,"Chunk class codes: b/B Boot track, P partition, U unallocated\n");
E 4
		for (i = 0; i < nm; i++){
D 4
			fprintf (log,"\nCompare region %d: src(%ld,%ld) dst (%ld,%ld)\n",
				i,src_layout[i].lba_start,src_layout[i].n_sectors,
				  dst_layout[ml[i]].lba_start,dst_layout[ml[i]].n_sectors); 
			printf ("\nCompare region %d: src(%ld,%ld) dst (%ld,%ld)\n",
				i,src_layout[i].lba_start,src_layout[i].n_sectors,
E 4
I 4
			fprintf (log,"\n===========================================\n");
			fprintf (log,"Compare region %d of %d: src(%ld,%ld,%c) dst (%ld,%ld,%c)\n",
				i,nm-1,src_layout[i].lba_start,src_layout[i].n_sectors,
				src_layout[i].chunk_class,
				  dst_layout[ml[i]].lba_start,dst_layout[ml[i]].n_sectors,
				  dst_layout[ml[i]].chunk_class);
			printf ("\nCompare region %d of %d: src(%ld,%ld) dst (%ld,%ld)\n",
				i,nm-1,src_layout[i].lba_start,src_layout[i].n_sectors,
E 4
				  dst_layout[ml[i]].lba_start,dst_layout[ml[i]].n_sectors);
			cmp_region (log,src_dcb,&src_layout[i],src_fill,
D 4
				dst_dcb,&dst_layout[ml[i]],dst_fill);
E 4
I 4
				dst_dcb,&dst_layout[ml[i]],dst_fill,start_time,&t);
E 4
		}
		if (num){
D 4
			fprintf (log,"\nExamine unmatched regions of destination\n"); 
E 4
I 4
/******************************************************************************
For each chunk of the destination that is not assigned to a src chunk
	examine the chunk for
		zero sectors
		filled sectors
		other sectors
	and count the number of each class of sector content
******************************************************************************/
			fprintf (log,"\nExamine unmatched regions of destination\n");
E 4
			printf ("\nExamine unmatched regions of destination\n");
			for (j = 0; j < dst_n_regions; j++){
				if (uml[j] == -1){
					printf ("Examine: %2d%c %9ld %9ld %8ld\n",j,
						dst_layout[j].chunk_class,dst_layout[j].lba_start,
						dst_layout[j].lba_start + dst_layout[j].n_sectors - 1,
						dst_layout[j].n_sectors);
I 4
					fprintf (log,"\n===========================================\n");
E 4
					fprintf (log,"Examine: %2d%c %9ld--%9ld %8ld\n",j,
						dst_layout[j].chunk_class,dst_layout[j].lba_start,
						dst_layout[j].lba_start + dst_layout[j].n_sectors - 1,
						dst_layout[j].n_sectors);
					scan_region (log,dst_dcb,dst_layout[j].lba_start,
D 4
						dst_layout[j].lba_start + dst_layout[j].n_sectors,src_fill,dst_fill);
E 4
I 4
						dst_layout[j].lba_start + dst_layout[j].n_sectors,src_fill,
						dst_fill,start_time,&t.excess_zero,&t.excess_non_zero);
E 4
				}
			}
		}

I 4
/******************************************************************************
Log summary results
******************************************************************************/
D 7

E 7
I 7
	/*
E 7
	fprintf (log,"Boot track summary: %d boot tracks with %ld diffs\n",
		t.n_boot_tracks,t.boot_track_diffs);
	fprintf (log,"Partition summary: %d partitions %ld diffs\n",
		t.n_partitions,t.partition_diffs);
	fprintf (log,"Partition fill area summary: %ld zero %ld other\n",
		t.fill_zero,t.fill_non_zero);
	fprintf (log,"Excess summary: %ld zero %ld other\n",
D 7
		t.excess_zero,t.excess_non_zero);
E 7
I 7
		t.excess_zero,t.excess_non_zero);  */
	fprintf (log,"\nSummary\n");
	fprintf (log,"Boot tracks %2d    %10d diffs %10lu\n",t.n_boot_tracks,
		63*t.n_boot_tracks,t.boot_track_diffs);
	fprintf (log,"Partitions  %2d    %10lu diffs %10lu\n",t.n_partitions,
		t.n_common,t.partition_diffs);
	fprintf (log,"Unallocated %2d    %10lu diffs %10lu\n",t.n_unalloc,
		t.n_common_unalloc,t.unalloc_diffs);
	fprintf (log,"Total src sectors %10lu\n",63*t.n_boot_tracks +
		t.n_common_unalloc + t.n_common);
	fprintf (log,"Partition excess  %10lu zero %10lu non-zero %10lu\n",
		t.fill_zero+t.fill_non_zero,t.fill_zero,t.fill_non_zero);
	fprintf (log,"Disk excess       %10lu zero %10lu non-zero %10lu\n",
		t.excess_zero+t.excess_non_zero,t.excess_zero,t.excess_non_zero);
	fprintf (log,"Total dst sectors %10lu\n\n",
		63*t.n_boot_tracks + t.n_common + t.n_common_unalloc +
		t.fill_zero+t.fill_non_zero + t.excess_zero+t.excess_non_zero);


E 7
E 4
	return 0;
}

D 4
pte_ptr find_min(pte_ptr pt, unsigned long max, unsigned long *lba)
E 4
I 4
/******************************************************************************
Find the next partition that starts at LBA max or later
******************************************************************************/
pte_ptr find_min(pte_ptr pt, /* The partition table*/
					 unsigned long max, /* target to find */
					 unsigned long *lba) /* start of next partition */
E 4
{
	int	i,ix;
	long min = -1;
	pte_ptr at = NULL,sub;
	unsigned long offset,start;
	*lba = 0;
	for (i = 0; i < 4; i++){
		if (pt[i].type){
			if ( (pt[i].type == 0x05) ||
				  (pt[i].type == 0x0F) ||
				  (pt[i].type == 0x0C)
				) {
				offset = 0;
				sub = &pt[i];
				ix = 0;
				start = sub->lba_start;
				while (sub){
					if(sub->type){/*
						printf ("%9ld = %9ld + %9ld + %9ld (%9ld %9ld)\n",start,sub->lba_start,
						base,offset,max,min);*/
						if (start >= max){
							if (min == -1) {
								min = start;
								*lba = start;
								at = sub;
							}
							else if (start < min){
								min = start;
								*lba = start;
								at = sub;
							}
						}
					}
					if ((sub->type == 0x05) ||
						 (sub->type == 0x0F) ||
						 (sub->type == 0x0C)) {if(ix) offset = sub->lba_start;}
					else {
							offset = 0;}
					sub = sub->next;
					ix=1;
					start =   pt[i].lba_start + offset + sub->lba_start;
/*					printf ("%9ld = %9ld + %9ld + %9ld (%9ld %9ld)*\n",start,sub->lba_start,
						pt[i].lba_start,offset,max,min);*/
				}
			}
			else {
				if (pt[i].lba_start >= max) {
					if (min == -1) {min = pt[i].lba_start;
						*lba = pt[i].lba_start; at = &pt[i];}
					else if (pt[i].lba_start < min){
						  min = pt[i].lba_start; at = &pt[i];
						  *lba = pt[i].lba_start;
					}
				}
			}
		}
	}
	return at;
}

D 4
int layout_disk (pte_ptr pt, layout_ptr lp, disk_control_ptr d)
E 4
I 4
/******************************************************************************
Examine the disk partition table and return a list of chunks
A chunk is a block of sectors that is either
(1) a partition
(2) a partition boot track
(3) the block of sectors between two partitions or
(4) the block of sectors after the last partition upto the end of the disk
******************************************************************************/
int layout_disk (pte_ptr pt, /* the partition table */
					 layout_ptr lp, /* the disk layout to return */
					 disk_control_ptr d)/* the disk containing the partition table */
E 4
{
	int	n = 0;
	int	more = 1;
	pte_ptr min_entry;
	unsigned long min = 0,alloc = 0, at;

	do { /*
		printf ("Find at least %9ld\n",min);*/
		min_entry = find_min (pt,min,&at);
/*		printf ("%s min at %ld\n",min_entry?"Entry":"No entry",at);*/
		if (min_entry){
			if (alloc < at){
				lp[n].pt = NULL;
				lp[n].lba_start = alloc;
				lp[n].n_sectors = at /*min_entry -> lba_start*/ - alloc;
				if (n) lp[n].chunk_class = 'U';
				else lp[n].chunk_class = 'B';
				n++;
			}
			lp[n].pt = min_entry;
			lp[n].lba_start = at /*min_entry -> lba_start*/;
			if ( (min_entry->type == 0x05) ||
				  (min_entry->type == 0x0F) ||
				  (min_entry->type == 0x0C)
				) {
					lp[n].n_sectors = 63;
					lp[n].chunk_class = 'b';
			}
			else {
				lp[n].chunk_class = 'P';
				lp[n].n_sectors = min_entry -> lba_length;
			}
			min = lp[n].lba_start + lp[n].n_sectors;
			alloc = min;
			n++;
		}
		else more = 0;
	} while (more);
	if (alloc < n_sectors(d)){
		lp[n].pt = NULL;
		lp[n].chunk_class = 'U';
		lp[n].lba_start = alloc;
		lp[n].n_sectors = n_sectors(d) - alloc;
		n++;
	}
	return n;
}

D 4
void print_help(char *p)
E 4
I 4
/******************************************************************************
Print the usage and options help
******************************************************************************/
void print_help(char *p /* the program name */)
E 4
{
	static int been_here = 0;
	if (been_here) return;
	been_here = 1;

D 4
	printf ("Usage: %s /[s|m]\n",p);
	printf ("/m\tUse master drive (default)\n");
	printf ("/s\tUse slave drive\n");
	printf ("/bios\tUse int 13 bios without extensions (default)\n");
	printf ("/xbios\tUse int 13 bios extensions\n");
	printf ("/layout\tPrint the disk layout\n");
E 4
I 4

	printf ("Usage: %s test-case host src-drive src-fill dst-drive dst-fill [/options]\n",p);
	printf ("/comment \" ... \"\tDescriptive comment\n");
	printf ("/layout\tPrint disk layout only (no compare)\n");
I 6
	printf ("/new_log\tStart a new log file (default is append to old log file)\n");
E 6
	printf ("/assign \tAssign corresponding regions between src and dst via dialog\n");
E 4
	printf ("/?\tPrint this option list\n");
}

main (int np, char **p)
{
D 4
	int	try_ext = 0, help = 0,layout_only = 0;
	int	status,i;
E 4
I 4
	int	help = 0,/* request command line help */
			layout_only = 0; /* print disk layout only */
	int	status,/* disk open or I/O status return */
			i; /* loop index */
			/* variables to handle fill characters */
E 4
	unsigned char src_fill = 'S',dst_fill = 'D';
	int		is_fill,id_fill;

D 4
	static 	disk_control_ptr src_dcb;
	int		src_drive = 0x80;
	pte_rec	src_pt[4];
	int		src_n_regions = 0;
	layout_ptr	src_layout = (layout_ptr)malloc(25*sizeof(layout_rec));

E 4
I 4
	/* source disk parameters */
	static 	disk_control_ptr src_dcb; /* drive information */
	int		src_drive = 0x80; /* source drive, default is Master on Primary IDE */
	pte_rec	src_pt[4]; /* partition table for source disk */
	int		src_n_regions = 0; /* number of chunks on the source */
	layout_ptr	src_layout = (layout_ptr)malloc(25*sizeof(layout_rec)); /* chunks */
   
	/* destination disk parameters */
E 4
	static 	disk_control_ptr dst_dcb;
	int		dst_drive = 0x81;
	pte_rec	dst_pt[4];
	int		dst_n_regions = 0;
	layout_ptr	dst_layout = (layout_ptr)malloc(25*sizeof(layout_rec));

D 4
	FILE		*log;
	char	comment [80];
	static time_t from,till;
	static long et,tmin,min,sec,hours;
E 4
I 4
	FILE		*log; /* log file */
D 6
	char	comment [80] = ""; /* tester (user) comment for log file */
E 6
I 6
	char	comment [80] = "",*access = "a"; /* tester (user) comment for log file */
E 6
	static time_t from; /* time program started running */
	int	assign_regions = 0; /* flag: user wants to assign corresponding chunks */
E 4

	_stklen = 2*_stklen;
D 4
	printf ("\n%s compiled at %s on %s\n", p[0],
E 4
I 4
	printf ("\n%s Version %I% compiled at %s on %s\n", p[0],
E 4
		__TIME__,__DATE__);
D 4

	for (i = 1; i < np; i++){
		if (strcmp(p[i],"/s") == 0) {src_drive = 0x81; dst_drive = 0x80;}
		else if (strcmp (p[i],"/m")== 0) {src_drive = 0x80; dst_drive = 0x81;}
E 4
I 4
/******************************************************************************
Get command line
******************************************************************************/
	if (np < 7){
		printf ("%s: Missing parameters\n",p[0]);
		help = 1;
	} else {
		sscanf (p[4],"%x",&is_fill);
		src_fill = is_fill;
		sscanf (p[6],"%x",&id_fill);
		dst_fill = id_fill;
		sscanf (p[3],"%x",&src_drive);
		sscanf (p[5],"%x",&dst_drive);
		if ((src_drive < 0x80) || (src_drive > 0x88)){
			help = 1;
			printf ("Src drive %X not valid (0x80 <= drive < 0x89)\n",src_drive);
		}
		if ((dst_drive < 0x80) || (dst_drive > 0x88)){
			help = 1;
			printf ("Dst drive %X not valid (0x80 <= drive < 0x89)\n",src_drive);
		}
		 printf ("Src drive %x dst drive %x\n",src_drive,dst_drive);
		 printf ("Src fill 0x%02X dst fill 0x%02X\n",src_fill,dst_fill);
	}
	for (i = 7; i < np; i++){
		if (strcmp(p[i],"/assign") == 0) assign_regions = 1;
E 4
		else if (strcmp (p[i],"/?") == 0) help = 1;
D 4
		else if (strcmp (p[i],"/bios")== 0) try_ext = 0;
		else if (strcmp (p[i],"/xbios")== 0) try_ext = 1; 
		else if (strcmp (p[i],"/layout")== 0) layout_only = 1;
		else help = 1;
		if (help){
			print_help(p[0]);
			return 0;
E 4
I 4
		else if (strcmp (p[i],"/layout") == 0) layout_only = 1;
I 6
		else if (strcmp (p[i],"/new_log")== 0) access = "w";
E 6
		else if (strcmp (p[i],"/comment")== 0){
			i++;
			if ( i>=np){
				printf ("%s: comment required with /comment\n",	p[0]);
				print_help(p[0]);
				return 1;
			}
			strcpy (comment,p[i]);
E 4
		}
I 4
		else help = 1;
E 4
	}
D 4
	printf ("Enter src and dst fill (in hex): ");
	scanf ("%x %x",&is_fill,&id_fill);
	src_fill = is_fill; dst_fill = id_fill;
	printf ("src %X dst %X\n",src_fill,dst_fill);

E 4
I 4
	if (help){
		print_help(p[0]);
		return 0;
	}
E 4
	status = 1;
D 4
	printf ("Insert log floppy, type log comment and press return\n");
	printf ("Host, test\n");
	scanf ("\n %[^\n]",comment);
	log = fopen("a:\cmpalog.txt","w");
	if (log == NULL) log = stdout;
E 4

D 4
	fprintf (log,"%s %s\ncompiled %s at %s with BCC version %x\n",
		p[0],SCCS_ID,__DATE__,__TIME__,__BORLANDC__);
	fprintf (log,"%s\n",SCCS_Z);
	fprintf (log,"Comment: %s\n",comment);
	fprintf (log,"src %X dst %X\n",src_fill,dst_fill);
E 4
I 4
/******************************************************************************
Start log file, open source disk and get partition table
******************************************************************************/
D 6
	log = log_open ("A:\CMPALOG.TXT",comment,SCCS_ID,np,p);
E 6
I 6
D 8
	log = log_open ("A:\CMPALOG.TXT",access,comment,SCCS_ID,np,p);
E 8
I 8
	log = log_open ("A:\\CMPALOG.TXT",access,comment,SCCS_ID,np,p);
E 8
E 6
E 4

D 4
	src_dcb = open_disk (src_drive,try_ext,&status);
	printf ("Open disk status code %d\n",status);
E 4
I 4
	src_dcb = open_disk (src_drive,&status);
	if (status){
D 5
		printf ("Open source disk %X status code %d\n",src_drive,status);
E 5
I 5
		printf ("Could not access source drive %X status code %d\n",src_drive,status);
E 5
		return 1;
	}
	log_disk (log,"Source Disk",src_dcb);
E 4
	print_dcb(src_dcb);
	status = get_partition_table(src_dcb,src_pt);

	if (status == 0){
		fprintf (log,"Source disk partition table\n");
D 4
		print_partition_table(log,src_pt,0);
		print_partition_table(stdout,src_pt,1);
E 4
I 4
		print_partition_table(log,src_pt,0,1);
		print_partition_table(stdout,src_pt,1,1);
E 4
	}
	else {
		fprintf (log,"Error reading src partition tab\n");
		if (status == -1) printf ("No partition table signature\n");
D 4
		else printf ("Error reading partition table, code %d\n",status);
E 4
I 4
		else printf ("Error code %d reading partition table\n",status);
E 4
		return 1;
	}
	time(&from);

	src_n_regions = layout_disk (src_pt,src_layout,src_dcb);
	printf ("%d regions\n",src_n_regions);
	fprintf (log,"Source disk layout: ");
	fprintf (log," %05ld/%03ld/%02ld ",
			src_dcb->disk_max.cylinder,
			src_dcb->disk_max.head,
			src_dcb->disk_max.sector);
	fprintf (log,"%ld total sectors on disk\n",src_dcb->n_sectors);
	fprintf (log,"%4s%10s%10s%10s%23s\n","","Start LBA","End LBA","Length",
		"Size: MB   (binary)");
	for (i = 0; i < src_n_regions; i++){
		printf ("%2d %c %9ld %9ld %9ld %8.2fMB %8.2fBMB\n",i,
			src_layout[i].chunk_class,src_layout[i].lba_start,
			src_layout[i].lba_start + src_layout[i].n_sectors - 1,
			src_layout[i].n_sectors,512.0*(float)src_layout[i].n_sectors/1000000.0,
			512.0*(float)src_layout[i].n_sectors/1048576.0);
		fprintf (log,"%2d %c %9ld %9ld %9ld %8.2fMB %8.2fBMB\n",i,
			src_layout[i].chunk_class,src_layout[i].lba_start,
			src_layout[i].lba_start + src_layout[i].n_sectors - 1,
			src_layout[i].n_sectors,512.0*(float)src_layout[i].n_sectors/1000000.0,
			512.0*(float)src_layout[i].n_sectors/1048576.0);
	}


D 4
	dst_dcb = open_disk (dst_drive,try_ext,&status);
	printf ("Open disk status code %d\n",status);
E 4
I 4
/******************************************************************************
Open destination disk, get partition table
******************************************************************************/
	dst_dcb = open_disk (dst_drive,&status);
	if (status){
D 5
		printf ("Open destination disk %X status code %d\n",dst_drive,status);
E 5
I 5
		printf ("Could not access destination drive %X status code %d\n",dst_drive,status);
E 5
		return 1;
	}
	log_disk (log,"Destination Disk",dst_dcb);
	print_dcb(dst_dcb);
	status = get_partition_table(dst_dcb,dst_pt);
E 4
	if (status == 0){
D 4
		print_dcb(dst_dcb);
		status = get_partition_table(dst_dcb,dst_pt);
E 4
		fprintf (log,"Destination disk partition table\n");
D 4
		print_partition_table(log,dst_pt,0);
		print_partition_table(stdout,dst_pt,1);
E 4
I 4
		print_partition_table(log,dst_pt,0,1);
		print_partition_table(stdout,dst_pt,1,1);
E 4
	}
	else {
D 4
		fprintf (log,"Error reading dst partition tab\n");
E 4
I 4
		fprintf (log,"Error reading dst partition table\n");
E 4
		if (status == -1) printf ("No partition table signature\n");
D 4
		else printf ("Error reading partition table, code %d\n",status);
E 4
I 4
		else printf ("Error code %d reading partition table\n",status);
E 4
		return 1;
	}


I 4

E 4
	dst_n_regions = layout_disk (dst_pt,dst_layout,dst_dcb);
	printf ("%d regions on 0x%X\n",dst_n_regions,dst_drive);
	fprintf (log,"Destination disk layout: ");
	fprintf (log," %05ld/%03ld/%02ld ",
			dst_dcb->disk_max.cylinder,
			dst_dcb->disk_max.head,
			dst_dcb->disk_max.sector);
	fprintf (log,"%ld total sectors on disk\n",dst_dcb->n_sectors);
	fprintf (log,"%4s%10s%10s%10s%23s\n","","Start LBA","End LBA","Length",
		"Size: MB   (binary)");
	for (i = 0; i < dst_n_regions; i++){
		printf ("%2d %c %9ld %9ld %9ld %8.2fMB %8.2fBMB\n",i,
			dst_layout[i].chunk_class,dst_layout[i].lba_start,
			dst_layout[i].lba_start + dst_layout[i].n_sectors - 1,
			dst_layout[i].n_sectors,512.0*(float)dst_layout[i].n_sectors/1000000.0,
			512.0*(float)dst_layout[i].n_sectors/1048576.0);
		fprintf (log,"%2d %c %9ld %9ld %9ld %8.2fMB %8.2fBMB\n",i,
			dst_layout[i].chunk_class,dst_layout[i].lba_start,
			dst_layout[i].lba_start + dst_layout[i].n_sectors - 1,
			dst_layout[i].n_sectors,512.0*(float)dst_layout[i].n_sectors/1000000.0,
			512.0*(float)dst_layout[i].n_sectors/1048576.0);
	}
I 4
/******************************************************************************
Do the compare
******************************************************************************/
E 4
	if (layout_only == 0)
		status = do_compare(src_dcb,src_n_regions,src_layout,dst_dcb,dst_n_regions,
D 4
		dst_layout,src_fill,dst_fill,log);
	time(&till);
	et = till - from;
	tmin = et/60;
	sec = et%60;
	hours = tmin/60;
	min = tmin%60;
	fprintf (log,"run start %s",ctime(&from));
	fprintf (log,"run finish %s",ctime(&till));
	fprintf (log,"elapsed time %ld:%ld:%ld\n",hours,min,sec);
	printf ("elapsed time %ld:%ld:%ld\n",hours,min,sec);

	if (status){
		printf ("error code %d in %s\n",status,p[0]);  
		fprintf (log,"error code %d in %s\n",status,p[0]);
	}
	else {printf ("Normal exit %s\n",p[0]);
	 fprintf (log,"Normal exit %s\n",p[0]); }
E 4
I 4
					dst_layout,src_fill,dst_fill,log,assign_regions,from);
/******************************************************************************
Close the log file
******************************************************************************/
	 log_close(log,from);
E 4
	return 0;
}
E 1
