static char *SCCS_ID[] = {"@(#) diskwipe.cpp Version 2.8 Created 07/10/01 at 11:22:14",
				__DATE__,__TIME__};
static char *test_version = "*** TEST VERSION ";
/******************************************************************************
The software provided here is released by the National
Institute of Standards and Technology (NIST), an agency of
the U.S. Department of Commerce, Gaithersburg MD 20899,
USA.  The software bears no warranty, either expressed or
implied. NIST does not assume legal liability nor
responsibility for a User's use of the software or the
results of such use.

Please note that within the United States, copyright
protection, under Section 105 of the United States Code,
Title 17, is not available for any work of the United
States Government and/or for any works created by United
States Government employees. User acknowledges that this
software contains work which was created by NIST employees
and is therefore in the public domain and not subject to
copyright.  The User may use, distribute, or incorporate
this software provided the User acknowledges this via an
explicit acknowledgment of NIST-related contributions to
the User's work. User also agrees to acknowledge, via an
explicit acknowledgment, that any modifications or
alterations have been made to this software before
redistribution.
******************************************************************************/
/***** Author: Dr. James R. Lyle, NIST/SDCT/SQG ****/
# include <stdio.h>
# include <string.h>
# include "zbios.h"
# include <time.h>

/*****************************************************************
Write a known pattern to each sector of a disk:
	bytes 0-10	C/H/S address of the sector
	byte 11     blank character
	bytes 12-22 LBA address of the sector
	byte 23		NULL (0)
	bytes 24-511 Fill Byte
*****************************************************************/


/*****************************************************************
Wipe n_sect sectors of the disk with fill
	d describes the disk to wipe
	n_sect is the number of sectors to wipe
	fill is the fill byte
	start_time is used to estimate time remaining
	heads is used to specify an alternate disk geometry for
		the C/H/S address written to the disk (see note in main)
*****************************************************************/
int do_wipe(disk_control_ptr d,long n_sect,unsigned char fill,
	time_t start_time, int heads)
{
	static unsigned long track,cylinder,head,sector,s,hpc,spt = 63;
	chs_addr	at;
	unsigned char *b = (unsigned char *)&d->buffer[0][0];
	int		i,not_ok;
	unsigned long from = 0, up_to = n_sect;

	for (i = 0; i < 512*63; i++) b[i] = fill;

	hpc = n_heads(d);
	printf ("Wipeout from %ld up to %ld\n",from,up_to);
	if (heads)printf ("Override heads: %d\n",heads);
	for (s = from; s < up_to; s++){
		track = s/spt;
		sector = s%spt + 1;
		cylinder = track/hpc;
		head = track%hpc;
		at.cylinder = cylinder;
		at.head = head;
		at.sector = sector;
		if (heads){
			cylinder = track/heads;
			head = track%heads;
		}
		sprintf ((char *)(&(d->buffer[sector-1][0])),
			"%05ld/%03ld/%02ld %012ld",cylinder,head,sector,s);
		if ((sector == 63) || ((s+1) == up_to)){
			if (((s+1) == up_to) && (sector != 63))
				printf ("Note: Partial last track (%ld) written at LBA %ld\n",
					sector,s);
			at.sector = 1;
			not_ok = /*write_sector (d,&at,b);*/
				disk_write (d,&at);}
		else not_ok = 0;
		if (not_ok){
			printf ("At sector (%s) write error ",b);
			return not_ok;
		}

		feedback (start_time,from,s,up_to);
	}

	return 0;
}

/*****************************************************************
Print the command line format & options
	p is the command name
*****************************************************************/
void print_help(char *p)
{
	static int been_here = 0;
	if (been_here) return;
	been_here = 1;

	printf ("Usage: %s test-case host drive Fill [/options]\n",p);
	printf ("/src\tWipe a source disk\n");
	printf ("/media\tWipe a media disk\n");
	printf ("/dst\tWipe a destination disk (default)\n");
	printf ("/heads nnn\tOveride number of heads from BIOS with nnn\n");
	printf ("/comment \" ... \"\tGive a comment on command line\n");
	printf ("/noask\tSupress confirmation dialog\n");
	printf ("/new_log\tStart a new log file (default is append to old log file)\n");
	printf ("/?\tPrint this option list\n");
}


main (int np, char **p)
{
	int	drive = 0x80;
	int	help = 0,ifill;
	int	status,i,is_debug = 0,ask = 1,hd = 0;
	unsigned long 	ns;
	static disk_control_block *dd;
	unsigned char	fill;
	char	ans[100];
	static time_t from;
	FILE *log;
	char	comment[80] = "",*log_name = "A:\\WIPEDLOG.TXT",*access = "a";

	printf ("%s %s%s\n",p[0],ctime(&from),SCCS_ID[0]);
	printf ("Compiled %s %s with BCC Version %x\n",__DATE__,
		__TIME__,__BORLANDC__);

	if (np < 5) help = 1;
	else sscanf (p[3],"%x",&drive);
	printf ("Drive 0x%X\n",drive);
	for (i = 5; i < np; i++){
		if (strcmp (p[i],"/?") == 0) help = 1;
		else if (strcmp (p[i],"/src")== 0)log_name = "A:\\WIPESLOG.TXT";
		else if (strcmp (p[i],"/media")== 0)log_name = "A:\\WIPEMLOG.TXT";
		else if (strcmp (p[i],"/dst")== 0)log_name = "A:\\WIPEDLOG.TXT";
		else if (strcmp (p[i],"/new_log")== 0) access = "w";
		else if (strcmp (p[i],"/noask") == 0) ask = 0;
		else if (strcmp (p[i],"/comment")== 0){
			i++;
			if (i >= np){
				printf ("%s: /comment option requires a comment\n",p[0]);
				help = 1;
			} else strcpy (comment,p[i]);
		} 
		else if (strcmp (p[i],"/heads")== 0){
			i++;
			if (i >= np){
				printf ("%s: /heads option requires a value\n",p[0]);
				help = 1;
			} else {sscanf (p[i],"%d",&hd);printf ("Set heads to %d\n",hd);}
/* **** NOTE about heads value
We have seen situations where the heads value obtained for the
BIOS by the interrupt 13 command 48 is off by one, i.e., the disk
has 64 heads but the value returned by the 48 command is 63. This
does not cause any problems in disk addressing since the C/H/S values
are not used, (LBA numbers are used). However, the C/H/S values written
by this program get out of sync with the real C/H/S addresses.
For example, 0/62/63 is followed by 1/0/1 (instead of 0/63/1).
This /heads option can be used the keep the values in sync with
the actual addresses.
*/
		}
		else help = 1;
	}
	if (help){
		print_help(p[0]);
		return 0;
	}
	if (SCCS_ID[0][0] == '%') SCCS_ID[0] = test_version;
	log = log_open(log_name,access,comment,SCCS_ID,np,p);
	time(&from);
	sscanf (p[4],"%x",&ifill);
	fill = ifill;
	if (ask){
		printf ("This program will erase (WIPEOUT) disk %x OK? (y/n)?",
			drive);
		scanf ("%s",ans);
		if (ans[0] != 'y') return 1;
		printf ("Do you want to WIPEOUT disk %x with %02X? (y/n)?",
			drive,ifill);
		scanf ("%s",ans);   printf ("ans is %s\n",ans);
		if (ans[0] != 'y') return 1;
	}


	dd = open_disk (drive,&status);
	if (status){
		printf ("%s could not access drive %x status code %d\n",
			p[0],drive,status);
		fprintf (log,"%s could not access drive %x status code %d\n",
			p[0],drive,status);
		return 1;
	}
	log_disk(log,"Wipe",dd);
	if (hd){
		fprintf (log,"Override number of heads from %ld to %d\n",
			dd->disk_max.head,hd);
	}
/*	print_dcb(dd);       */
	ns = n_sectors(dd);
	if (is_debug)ns = 100;
	status = do_wipe(dd,ns,fill,from,hd);
	if (status){
		printf ("error code %d in %s\n",status,p[0]);
		fprintf (log,"error code %d in %s\n",status,p[0]);

	}
	fprintf (log,"%ld sectors wiped with %2X\n",ns,ifill);
	printf ("%ld sectors wiped with %2X\n",ns,ifill);
	log_close (log,from);
	return 0;
}
