/* main.c

	This is the driver program for a NIST implementation of the
	Secure Hash Algorithm (SHA). This is a test implementation.

	Usage:  sha [-v] [-t] [-s [string]] [filename(s)...]

		-v : test by checking known answer from Appendix A of FIPS 180-1
		-t : perform time trial by hashing 10,000,000 bytes.
		-s [string] : perform hash of a string parameter
		[filename]: perform hash of file
*/
#pragma hdrstop
#include <condefs.h>
#include <stdio.h>
#include <time.h>
#include <fcntl.h> 
#include <string.h>  
#include <stdlib.h>
#include "sha.h"

/* Number of bytes of test data to process. */
USEUNIT("sha.cpp");
USEUNIT("Shautil.cpp");
//---------------------------------------------------------------------------
#define TEST_BYTES   10000000L
/* This should be a multiple of SHABLOCKLEN = 64. */
#define TEST_BLOCK_SIZE     (100 * SHABYTEBLOCKLEN)
#define TEST_BLOCKS     ( TEST_BYTES / TEST_BLOCK_SIZE )

/*
#define TIMEIT
*/

#ifdef LITTLE_ENDIAN
#define n1E6	1000.0
#else
#define n1E6	1000000.0
#endif
#pragma argsused
void main (argc, argv)
int argc;
char *argv[];
{
#ifdef TIMEIT
  FILE *fopen(), *fp;
  unsigned long totalbytes;
#endif
  int i,j,rv;
  unsigned long hash[5];
  double cps;

  if (argc == 1) {
	 printf("Usage:  sha [-v] [-t] [-s [string]] [filename(s)...]\n");
	 exit(1);
	 }
  else
	 for (i = 1; i < argc; i++)
		if (argv[i][0] == '-' && argv[i][1] == 's') {
		  SHAString(argv[i+1], hash);
		  for (j=0;j<5;j++) printf("%08lX ",hash[j]);
		  printf("\n");
		  i++;
		  }
		else if (strcmp (argv[i], "-t") == 0) {
		  printf("Performing 10,000,000 byte time trial...");
		  fflush(stdout);
		  clock();
		  SHATimeTrial ();
		  cps = clock();
		  printf("finished.\nSeconds to process test input: %.3f\n", cps/n1E6);
		  printf("Characters processed per second: %.3f\n",TEST_BYTES*n1E6/cps);
		  }
		else if (strcmp (argv[i], "-v") == 0) {
		  rv=SHATest();
		  }
		else {
#ifdef TIMEIT
		  /* Determine length of file */
		  if ((fp=fopen(argv[i],"r+b")) == NULL) {
			 printf("Can't open \"%s\"\n",argv[i]);
			 continue;
			 }
		  fseek(fp,0L,SEEK_END);
		  totalbytes=ftell(fp);
		  rewind(fp);
		  clock();
#endif
		  if (rv=SHAFile (argv[i],hash)) {
			 printf("Can't open \"%s\"\n",argv[i]);
			 continue;
			 }
#ifdef TIMEIT
		  cps = clock();
		  printf("\nNumber of characters processed =  %ld\n",totalbytes);
		  printf("Seconds to process test input: %.6f\n", cps/n1E6);
		  if ( (int) cps)
			 printf("Characters processed per second: %.6f\n",totalbytes*n1E6/cps);
#endif
		  for (j=0;j<5;j++) printf("%08lX ",hash[j]);
		  printf("\n");
		 }
  }
