
#include "config.h"
#include <stdio.h>
#include <time.h>
#include <memory.h>
#include <string.h>
#include "sha.h"

/* Number of bytes of test data to process. */
#define TEST_BYTES   10000000L
/* This should be a multiple of SHABLOCKLEN = 64. */
#define TEST_BLOCK_SIZE     (100 * SHABYTEBLOCKLEN)
#define TEST_BLOCKS     ( TEST_BYTES / TEST_BLOCK_SIZE )


#define	MSBITNDIGIT		0x8000
#define	LSBITNDIGIT		0x0001

/**********************************************************************
		This routine merely computes SHA of the string 'abc' and
	checks the result against the known hash of 'abc'.
**********************************************************************/
int SHATest()
{
	SHA_CTX shaContext;
	BYTE	a[20];
	int	j;

	a[0] = 0x61;
	a[1] = 0x62;
	a[2] = 0x63;
	SHAInit(&shaContext);
	SHAUpdate(&shaContext, ( BYTE * ) a, 24);
	SHAFinal(&shaContext);
   for (j=0;j<5;j++)
   	printf("%08lX ", shaContext.H[j]);

	if( shaContext.H[ 0 ] != 0xA9993E36L ||
			shaContext.H[ 1 ] != 0x4706816AL ||
			shaContext.H[ 2 ] != 0xBA3E2571L ||
			shaContext.H[ 3 ] != 0x7850C26CL ||
			shaContext.H[ 4 ] != 0x9CD0D89DL  )
   	printf("\nFailed!\n");
   else
   	printf("\nPassed!\n");
	}

/**********************************************************************

		This time trial computes the hash of data that is stored
	in memory that is comprised of 10,000,000 bytes. It uses the
	UNIX 'clock' to do the timing.

**********************************************************************/
void SHATimeTrial()
{
	SHA_CTX shaContext;
	unsigned char  data[ TEST_BLOCK_SIZE ];
	long i;
	ULONG EXTRA;

	EXTRA = (TEST_BYTES - TEST_BLOCKS*TEST_BLOCK_SIZE);
	memset( data, 0, TEST_BLOCK_SIZE );
	SHAInit( &shaContext );
	for( i = TEST_BLOCKS; i > 0; i-- )
		SHAUpdate( &shaContext, data, TEST_BLOCK_SIZE*8 );
	if (EXTRA)
		SHAUpdate( &shaContext, data, (int)EXTRA*8 );
	SHAFinal( &shaContext );
	}

/**********************************************************************
		This routine is used when hashing data stored in a file.
	It uses 'fread' to do the reading from the file. At this time
	it contains timing statements.
**********************************************************************/
int SHAFile (filename,result)
char   *filename;
ULONG *result;
{
	FILE *inFile = fopen (filename, "rb");
	SHA_CTX shaContext;
	int bytes, i;
	unsigned char data[ TEST_BLOCK_SIZE ];

	if (inFile == NULL)  return 1;
	SHAInit (&shaContext);
	while ((bytes = fread (data, 1, TEST_BLOCK_SIZE, inFile)) != 0)
		SHAUpdate (&shaContext, data, bytes*8);
	SHAFinal (&shaContext);
	fclose (inFile);
	for (i=0;i<5;i++) result[i] = shaContext.H[i];
	return 0;
	}

/**********************************************************************
		This routine is used when hashing data stored in a file.
		It appends the 32-bit date/time to the file for hashing as well.
**********************************************************************/
int SHAFileDate (filename, dt, result)
char *filename;
ULONG      dt;
ULONG *result;
{
	FILE *inFile = fopen (filename, "r+b");
	SHA_CTX shaContext;
	int bytes, i,space_left=-1;
	unsigned char data[ TEST_BLOCK_SIZE ], datetime[4];

	if (inFile == NULL) return 1;
	memcpy(datetime,(BYTE *)&dt,4);
#ifdef LITTLE_ENDIAN
byteReverse((ULONG *)datetime, 4);  /* Put in external byte order (BIG ENDIAN) */
#endif

	SHAInit (&shaContext);
	while ((bytes = fread (data, 1, TEST_BLOCK_SIZE, inFile)) != 0) {
		if (bytes < TEST_BLOCK_SIZE) {
			space_left=TEST_BLOCK_SIZE-bytes;
			if (space_left >= 4) space_left=4;
			memcpy(&data[bytes], datetime, space_left);
			bytes+=space_left;
			space_left=4-space_left;
			}
		SHAUpdate (&shaContext, data, bytes*8);
		}
	/* if file len mod block len was >= 4 (space_left=0) dt was added so skip */
	if (space_left!=0) {
		if (space_left<0) /* file len mod block len was 0 */
			SHAUpdate (&shaContext, datetime, 4*8);
		else /* file len mod block len was between 1 and 3 */
			SHAUpdate (&shaContext, &datetime[4-space_left], space_left*8);
		}
	SHAFinal (&shaContext);
	fclose (inFile);
	for (i=0;i<5;i++) result[i] = shaContext.H[i];
	return 0;
	}

/**********************************************************************
		This routine is used when hashing a string of data that is
	obtained from the standard input.
**********************************************************************/
int SHAString (inString, result)
char   *inString;
ULONG *result;
{
	SHA_CTX shaContext;
	unsigned int len = strlen (inString);
	int i;

	SHAInit (&shaContext);
	SHAUpdate (&shaContext, inString, len*8);
	SHAFinal (&shaContext);
	for (i=0;i<5;i++)
		result[i] = shaContext.H[i];
	/* zeroize for security */
	memset(&shaContext,(char)0,sizeof(shaContext));
	return 0;
	}

/**********************************************************************
		This routine is used when hashing an array
**********************************************************************/
int SHABlock (inBlock, inLen, result)
BYTE   *inBlock;
int         inLen;
ULONG *result;
{
	SHA_CTX shaContext;
	int i;

	SHAInit (&shaContext);
	SHAUpdate (&shaContext, inBlock, inLen*8);
	SHAFinal (&shaContext);

	for (i=0;i<5;i++)
		result[i] = shaContext.H[i];

	/* zeroize for security */
	memset(&shaContext,(char)0,sizeof(shaContext));

	return 0;
	}



/*****************************************
** bshr - shifts array right             *
**                   by one bit.         *
**                                       *	
** x = x / 2                             *
**                                       *
** Parameters:                           *	
**                                       *
**  x      Address of array x            *
**  l      Length array x in bytes       *	
**                                       *
******************************************/ 
void
bshr(x,l)	
 /*DIGIT *x;*/ BYTE *x;
int l;
{
 /*DIGIT */ BYTE *p;
 int c1,c2;

  p = x;
  c1 = 0;
  c2 = 0;
  while (p != x+(l/sizeof(DIGIT))-1)
  {
    if (*p & (DIGIT)LSBITNDIGIT)
       c2 = 1;
    *p >>= 1;  /* shift the word right once (ms bit = 0) */
    if (c1)
      *p |= (DIGIT)MSBITNDIGIT;
    c1 = c2;
    c2 = 0;
    p++;
  }
  *p >>= 1;  /* shift the word right once (ms bit = 0) */
   if (c1)
      *p |= (DIGIT)MSBITNDIGIT;
}

/*****************************************
** xor - xor one array into another      *
**                                       *
** Parameters:                           *
**                                       *
**  x      Address of array x            *
**  y      Address of array y            *
**  l      Amount of bytes to copy       *
**                                       *
******************************************/
void
xor(A, x, y, l)
 /*register DIGIT A[], x[], y[];  */
 register ULONG A[], x[]; register BYTE y[];
 register int l;
{
  l /= sizeof(DIGIT);
  while (l--)  A[l] = x[l] ^ y[l];
}
