/*
** wlan_bt_ecc.ex.c :
**
** Bluetooth model in Opnet
** National Institute of Standards and Technology
**
** This model was developed at the National Institute of Standards
** and Technology by employees of the Federal Government in the course
** of their official duties. Pursuant to title 17 Section 105 of the
** United States Code this software is not subject to copyright
** protection and is in the public domain. This is an experimental
** system.  NIST assumes no responsibility whatsoever for its use by
** other parties, and makes no guarantees, expressed or implied,
** about its quality, reliability, or any other characteristic.
**
** We would appreciate acknowledgement if the model is used.
**
** NIST ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION
** AND DISCLAIM ANY LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER
** RESULTING FROM THE USE OF THIS SOFTWARE.
**
** Primary Author:      ???
** Module description:  Bluetooth Common MAC Function Support
** Last Modification:   June, 20, 2002
*/


/* include the header */
#include "wlan_bt_ecc.h"


/*
 * Function : wlan_bt_ecc
 *
 * Description :
 */

void	wlan_bt_ecc (Packet *pkptr, int *pos, int num_errs, double type_of_packet)
{
  /*int		pklen;
    int		x;
    Objid		rx_ch_obid; 
    double	ecc_thresh;
    double       	ber = 0.0;
    double       	sum_bad, k;
    char		pkt_fmt[256];*/
  Boolean      	accept = OPC_TRUE;
  Boolean       var;
  
  /*********************/
  /** Modif. Olivier ***
  char	source_name[32];
  Objid src_node_objid;
  *********************/
  
  /** Determine acceptability of given packet at receiver. **/
  FIN (wlan_bt_ecc (pkptr,pos,num_errs,type_of_packet));

  /******************************************************************/
  /*						Modif. Olivier		   					*
  src_node_objid = op_topo_parent (op_pk_creation_mod_get (pkptr));
  op_ima_obj_attr_get (src_node_objid, "name", source_name);
  ******************************************************************/
  
  /* Test if bit errors can be recovered. If not, retransmission need to be done */
  var = accept_decision(pkptr, pos, num_errs,type_of_packet);
  if ( num_errs && !var )
    accept = OPC_FALSE;	/* Too much errors that can not be recovered */
  
  /* Place the Accept flag inside the packet to be computed by the MAC */
  //if (strcmp (source_name, "Server") != 0)
	  op_pk_nfd_set (pkptr, "Accept", accept);
  //else
	//  op_pk_nfd_set (pkptr, "Accept", OPC_FALSE);
  
  /*printf("the flag ACCEPT is %d \n", accept);
  printf("\n");*/

  FOUT;
}

/*
 * $Function:           pk_scrambler
 * $Description:        Take a decision wether or not the packet is valid 
 *                      by simulating error in the packet reguarding to the
 *                      BER introduced. Choose randomly errors in the packet
 *                      and validate the packet if error recovery is possible
 *                      otherwise the packet is rejected.
 * $ParamIn:            Packet : pkptr
 *                              The bluetooth packet to scramble
 * $ParamIn:            int : num_errors
 *                              The Number of errors inside this packet
 * $ParamOut:           Boolean :
 *                              The decision wether or not the packet is
 *                              accepted
 */

Boolean  accept_decision(Packet * pkptr, int *pos, int num_errors,double type_of_packet)
{
  /*int		pkt_length = op_pk_total_size_get (pkptr);*/
  Boolean	accept_flag = OPC_TRUE;
  int		i,j;
  int		current_bit;
  int		check_bit;
  /*int		t_col;*/
  int		type;
  int		access_code_errs = 0;
  int		payload_errs = 0;
  /*double       	xb,xw,xw_tw,xb_tb;
    int		start = 0;*/
  
  FIN( accept_decision(pkptr,pos,num_errors,type_of_packet) );

  if(pos != NULL)
    {
      if (type_of_packet == WLAN)
	{
	   if (num_errors > 0)
	    accept_flag = OPC_FALSE;
	     else
	    accept_flag = OPC_TRUE;

	   if (bt_message_print) printf("the flag ACCEPT for WLAN is %d \n", accept_flag);
	   FRET (accept_flag);
	}
      else
	{

	  /* Get some information over the packet */
	  op_pk_nfd_get(pkptr, "TYPE", &type);

	  
#ifdef NO_FEC
	  if (num_errors > 0)
	    accept_flag = OPC_FALSE;
#else
	  /* Apply eventually some FEC over the packet				*/
	  /* Accept the packet only if						*/
	  /*    + The number of errors is clear					*/
	  /*    + There is some errors but no double errors in a byte that	*/
	  /*            can not be corrected by the FEC				*/
	  for (i=0; i<num_errors; i++)
	    {
	      check_bit =  pos[i];			/* The current error to check */
	      
	      if ( check_bit >= ACCESS_CODE_SIZE )	/* If the error is after the access code */
		{
		  for (j=0; j<i; j++)
		    {
		      current_bit = pos[j];	/* Get the current error */
		      
		      if (check_bit < HEADER_SIZE)
			{ /* If the error is in the header, check the header */
			  if ( ((check_bit-ACCESS_CODE_SIZE)/3 ==
				(current_bit-ACCESS_CODE_SIZE)/3) &&
			       ((check_bit == current_bit-1) ||
				(check_bit == current_bit+1)) )
			    {			/* Reject the packet */
			      accept_flag = OPC_FALSE;
			      goto pk_scrambler_nxt;
			    }
			}
		      else
			{ /* If the error is in the payload, check the payload only for DM packets */
			  /* Voice packets applies the FEC but cannot reject the packet on the */
			  /* payload information (No CRC is in the voice packets) */
			  switch ( type )
			    {
			    case	HV3_TYPE:	/* No FEC applied */
			      payload_errs++;	/* update the payload error counter */
			      break;
			      
			    case	HV1_TYPE:	/* FEC 1/3 applies */
			      if ( ((check_bit-HEADER_SIZE)/3 ==
				    (current_bit-HEADER_SIZE)/3) &&
				   ((check_bit == current_bit-1) ||
				    (check_bit == current_bit+1)) )
				/* Error detected in the payload */
				payload_errs++;	/* update the payload error counter */
			      break;
			      
			    case	HV2_TYPE:	/* FEC 2/3 applies */
			      if ( ((check_bit-HEADER_SIZE)/15 ==
				    (current_bit-HEADER_SIZE)/15) )
				/* Error detected in the payload */
				payload_errs++;	/* update the payload error counter */
			      break;
			      
			    case DM1_TYPE:
			    case DM3_TYPE:
			    case DM5_TYPE:
			      /* Other traffic */
			      if ( ((check_bit-HEADER_SIZE)/15 ==	/* Error on the same */
				    (current_bit-HEADER_SIZE)/15) ) /* 15 packet of bits */
				{					/* Reject the packet */
				  accept_flag = OPC_FALSE;
				  goto pk_scrambler_nxt;
				}
			      break;

			    default:
			      accept_flag = OPC_FALSE;
			      goto pk_scrambler_nxt;
			      break;
			    }
			}
		    }
		}
	      else
		{	/* If an error occurs in the ACCESS_CODE */
		  if ( (check_bit >= SYNC) && (check_bit < TRAILER) )
		    access_code_errs++;
		  
		  /* too much errors, we can not fix it, then reject the packet */
		  if (access_code_errs > MAX_ACCESS_CODE_ERRS)
		    {
		      accept_flag = OPC_FALSE;
		      goto pk_scrambler_nxt;
		    }
		}
	    }
	pk_scrambler_nxt:
	  
#endif
	  /* Fill the number of payload errors in the packet field */
	  op_pk_nfd_set (pkptr, "Errors", payload_errs);
	  /* Return the decision */
	  /* printf("the flag ACCEPT for BT is %d \n", accept_flag);*/
	  FRET (accept_flag);
	}
    }   
  else 
    {
      /*if pos is NULL then there is no errors and the accept flag shall be true*/
      FRET (OPC_TRUE);
    }
  
}
