/*
** l2cap_support.h:
**
** Bluetooth model in Opnet
** National Institute of Standards and Technology
**
** This model was developed at the National Institute of Standards
** and Technology by employees of the Federal Government in the course
** of their official duties. Pursuant to title 17 Section 105 of the
** United States Code this software is not subject to copyright
** protection and is in the public domain. This is an experimental
** system.  NIST assumes no responsibility whatsoever for its use by
** other parties, and makes no guarantees, expressed or implied,
** about its quality, reliability, or any other characteristic.
**
** We would appreciate acknowledgement if the model is used.
**
** NIST ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION
** AND DISCLAIM ANY LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER
** RESULTING FROM THE USE OF THIS SOFTWARE.
**
** Primary Author:      Frederic Mouveaux
** Module description:  L2CAP Segmentation and Reassembly Support
** Last Modification:   January, 15th 2003 (Olivier Rebala)
*/

#ifndef __L2CAP_SUPPORT_H__
#define __L2CAP_SUPPORT_H__

/* Standard includes */
#include <opnet.h>
#include "bt_support.h"
#include "fifo_support.h"
#include "rr_support.h"

/* Define Bluetooth L2CAP packet format */
#define		BLUETOOTH_PKT_L2CAP	"L2CAP"

/* Define some constants */
#define	DM1_LENGTH	17		/* Length of a DM1 packet in bytes (inc. l2cap header) */
#define	DM3_LENGTH	121		/* Length of a DM3 packet in bytes (inc. l2cap header) */
#define	DM5_LENGTH	224		/* Length of a DM5 packet in bytes (inc. l2cap header) */
#define	DH1_LENGTH	27		/* Length of a DH1 packet in bytes (inc. l2cap header) */
#define	DH3_LENGTH	183		/* Length of a DH3 packet in bytes (inc. l2cap header) */
#define	DH5_LENGTH	339		/* Length of a DH5 packet in bytes (inc. l2cap header) */
#define	DM1_HEADER	1		/* Header size of a DM1 packet in bytes */
#define	DM3_HEADER	2		/* Header size of a DM3 packet in bytes */
#define	DM5_HEADER	2		/* Header size of a DM5 packet in bytes */
#define	DH1_HEADER	1		/* Header size of a DH1 packet in bytes */
#define	DH3_HEADER	2		/* Header size of a DH3 packet in bytes */
#define	DH5_HEADER	2		/* Header size of a DH5 packet in bytes */
#define	CRC_SIZE	2		/* Size of the CRC in bytes */
#define	FIRST_PKT_CODE	10		/* L_CH code of the first packet in a sequence */
#define	NEXT_PKT_CODE	01		/* L_CH code of the next packets in a sequence */
#define	L2CAP_HEADER	32		/* L2CAP Header in bits */

/* define a list to store the l2cap packets */
List *l2cap_bt_queue;

/* Define function prototypes */
void		l2cap_init_support ();
void		l2cap_init_parameters (double *segmentation_size, int *flag_pkt_type);
int			l2cap_segmentation (List **bt_queue, int src, Device_type device_type, int flag_packet_type);
Packet *	l2cap_reassembly (Packet * pkptr, int * number_of_bits, double * ctime);
void		l2cap_destroy_packet (Packet * pkptr);
void		l2cap_pkt_enqueue (List **bt_queue, Packet *pkptr, int queue, Device_type device_type);
void		l2cap_higher_layer_arrival (Packet *pkptr, double l2cap_seg_size);

#endif /* _L2CAP_SUPPORT_H_ */
