/*
** bt_freq_hopping.ex.c :
**
** Bluetooth model in Opnet
** National Institute of Standards and Technology
**
** This model was developed at the National Institute of Standards
** and Technology by employees of the Federal Government in the course
** of their official duties. Pursuant to title 17 Section 105 of the
** United States Code this software is not subject to copyright
** protection and is in the public domain. This is an experimental
** system.  NIST assumes no responsibility whatsoever for its use by
** other parties, and makes no guarantees, expressed or implied,
** about its quality, reliability, or any other characteristic.
**
** We would appreciate acknowledgement if the model is used.
**
** NIST ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION
** AND DISCLAIM ANY LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER
** RESULTING FROM THE USE OF THIS SOFTWARE.
**
** Primary Author:      TI
** Module description:  Bluetooth Common MAC Function Support
** Last Modification:   December, 3rd, 2002 (Olivier Rebala)
*/

#ifndef __BT_FREQ_HOPPING_H__
#define __BT_FREQ_HOPPING_H__
 
/* Standard includes */
#include <opnet.h>
#include <stdio.h>

/* define some type */
typedef unsigned char	Bt_Hop_Short;	// 8 bits integer
typedef unsigned int	Bt_Hop_Long;	// 32 bits integer

/* define some variable */
#define WORD_LENGTH_MINUS_1		31	/* word length minus one */
#define NUMBER_OF_HOPS			79	/* This model is for US&Europe Only */
#define	SEGMENT_SIZE			32	/* The segment size for this model */
#define BT_HOP_MODULO   (SEGMENT_SIZE - 1)

/* function prototypes */
Bt_Hop_Short	bt_hop_extract_short		(Bt_Hop_Long word, Bt_Hop_Short i, Bt_Hop_Short j);
Bt_Hop_Long	bt_hop_extract_long		(Bt_Hop_Long word, Bt_Hop_Short i, Bt_Hop_Short j);
Bt_Hop_Short	bt_hop_extract_even		(Bt_Hop_Long word, Bt_Hop_Short how_many_bits);
Bt_Hop_Short	bt_hop_extract_odd		(Bt_Hop_Long word, Bt_Hop_Short how_many_bits);
Bt_Hop_Short	bt_hop_connection_permute	(Bt_Hop_Short z, Bt_Hop_Long control_word);
Bt_Hop_Short	bt_hop_permute			(Bt_Hop_Short z, Bt_Hop_Short i1, Bt_Hop_Short j1, Bt_Hop_Short i2, Bt_Hop_Short j2, Bt_Hop_Short control);
Bt_Hop_Short	bt_hop_flip			(Bt_Hop_Short z, Bt_Hop_Short i, Bt_Hop_Short j);
Bt_Hop_Short	bt_hop_selection		(Bt_Hop_Long Clk, Bt_Hop_Long ULAP);

#endif /* End of  __BT_FREQ_HOPPING_H__*/
