/*
** Frequency_Allocation.ex.c :
**
** Bluetooth model in Opnet
** National Institute of Standards and Technology
**
** This model was developed at the National Institute of Standards
** and Technology by employees of the Federal Government in the course
** of their official duties. Pursuant to title 17 Section 105 of the
** United States Code this software is not subject to copyright
** protection and is in the public domain. This is an experimental
** system.  NIST assumes no responsibility whatsoever for its use by
** other parties, and makes no guarantees, expressed or implied,
** about its quality, reliability, or any other characteristic.
**
** We would appreciate acknowledgement if the model is used.
**
** NIST ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION
** AND DISCLAIM ANY LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER
** RESULTING FROM THE USE OF THIS SOFTWARE.
**
** Primary Author:      Nicolas Chevrollier
** Module description:  Bluetooth Common MAC Function Support
** Last Modification:   June, 19, 2002
*/

/* include header file */
#include "Frequency_Allocation.h"

void Frequency_Allocation ( Packet *pkptr)
{
  double U = 0.019456;        /* value of 19 time units */
  int    N;                   /* intermediate variable used to always have a value between 0 and 78 */
  int    n;                   /* intermediate variable used to work in a 0 to 19U bandwith */
  int    pk_len;              /* determine the packets length (in bits) */
  float  pk_svc_time;         /* determine the time required to complete service of the packet */
  double service_rate;        /* data rate */
  int    pk_len_max = 12000 ; /* determine the maximun time required to complete service of a wireless LAN packet */
  double DSSS_frequency;      /* frequency of transmission */
  float  pk_svc_time_max;
  
  /*parametres */
  Objid	mac_params_comp_attr_objid_FH_DS;
  Objid params_attr_objid_FH_DS;
  Objid	my_objid_FH_DS;
  WlanT_Phy_Char_Code	phy_char_flag_FH_DS;
  
  FIN ( Frequency_Allocation ( pkptr ) );

  /* object id of the surrounding processor.	*/
  my_objid_FH_DS = op_id_self ();
  
  /* Obtain the values assigned to the various attributes	*/
  op_ima_obj_attr_get (my_objid_FH_DS, "Wireless LAN Parameters", &mac_params_comp_attr_objid_FH_DS);
  params_attr_objid_FH_DS = op_topo_child (mac_params_comp_attr_objid_FH_DS, OPC_OBJTYPE_GENERIC, 0);
  
  /* Load the appropriate physical layer characteristics.	*/	
  op_ima_obj_attr_get (params_attr_objid_FH_DS, "Physical Characteristics", &phy_char_flag_FH_DS);
  
  /* Obtain the data rate */
  op_ima_obj_attr_get (params_attr_objid_FH_DS, "Data Rate", &service_rate);
  
  /*case oh frequency hopping*/
  if (phy_char_flag_FH_DS == WlanC_Frequency_Hopping)  {
    /*initialisation of variables */
    n = (int)(floor (op_sim_time()/U));  
    pk_len = op_pk_total_size_get (pkptr);
    pk_svc_time =(float)(pk_len) / (float)(service_rate);
    pk_svc_time_max =(float)(pk_len_max) / (float)(service_rate);
    
    /* N, position of frequency we have to choose in th pattern*/
    N = n % 79; 
    
    /* allocation of frequency */
    op_pk_nfd_set( pkptr,"frequency", pattern_of_frequencies [N]*1000000.0);
    
    /*compare the current time with the citrical bandwith of time [nU - pk_svc_time_max,nU] */
    if ((((float)U - pk_svc_time_max) <= (op_sim_time()-(float)(n*U))) && ((op_sim_time()-n*(float)U) <= (float)U)) {  
      if (( pk_svc_time + op_sim_time() -(float)(n*U) ) >=(float) U) {
	if (n % 79 == 78) {    
	  N = 0 ;	
	  op_pk_nfd_set( pkptr,"frequency", pattern_of_frequencies [ N]*1000000.0);
	}	
	else { 
	  op_pk_nfd_set( pkptr,"frequency", pattern_of_frequencies [ N+1]*1000000.0);
	}
      }
    }  
  }
  else
    {
      /* case of direct sequence*/
      /*obtain the frequency of tranmission */
      op_ima_obj_attr_get ( params_attr_objid_FH_DS, "DSSS Frequency",&DSSS_frequency );
      if (bt_message_print) printf("DSSS_frequency : %f\n",DSSS_frequency);
      op_pk_nfd_set( pkptr,"frequency", DSSS_frequency*1000000.0);
    }

  FOUT;
}
