/*
** $file: topo_discovery.h
**
** Bluetooth model in Opnet
** National Institute of Standards and Technology
**
** This model was developed at the National Institute of Standards
** and Technology by employees of the Federal Government in the course
** of their official duties. Pursuant to title 17 Section 105 of the
** United States Code this software is not subject to copyright
** protection and is in the public domain. This is an experimental
** system.  NIST assumes no responsibility whatsoever for its use by
** other parties, and makes no guarantees, expressed or implied,
** about its quality, reliability, or any other characteristic.
**
** We would appreciate acknowledgement if the model is used.
**
** NIST ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION
** AND DISCLAIM ANY LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER
** RESULTING FROM THE USE OF THIS SOFTWARE.
**
** Primary Author:      Frederic Mouveaux
** Module description:  Manage a list of devices for the entire topology
** Last Modification:   January, 15th 2003 (Olivier Rebala)
*/

#ifndef	__TOPO_DISCOVERY_H__
#define	__TOPO_DISCOVERY_H__

#include <opnet.h>
#include "bt_support.h"

/* The Device information */
typedef struct	st_slave_info
{
  char* name_of_slave;
  int   piconet_number;
  int   piconet_real;
  int	mac_address;
  int   address_device;
  Objid	mac_objid;
} Slave_Device;

typedef struct	st_master_info
{
  char* name_of_master;
  int   piconet_number;
  int   piconet_real;
  int   mac_address;
  int   address_device;
  Objid	mac_objid;
  List *slave_device_list;
} Master_Device;


typedef struct	st_wlan_device_info
{
  int	piconet_real;
  int	piconet_number;
  Objid	mac_objid;
  Objid node_objid;
  int	mac_address;
  int   address_device;
} Wlan_Device;

List *  master_device_list_ptr;	   /* Store the master device infos */
List *  device_list_wlan_ptr;      /* Store the Wlan device infos */
Objid	channel_objid;

Objid ** slave_mac_objid;

/* Function prototypes declaration */
void		init_topo_discovery ();
void            topo_init_master(char* name_of_slave, int piconet_number, Objid mac_objid, int piconet_read, int my_address);
Master_Device  *topo_set_master_device (char* name_of_device, int piconet_number, int piconet_read, int my_address, Objid mac_objid);
Slave_Device   *topo_set_slave_device (char* name_of_device, int piconet_number, int piconet_read, int address_device, int my_address, Objid mac_objid);
Wlan_Device    *topo_set_wlan_device (Objid mac_objid, int address_device, int piconet_read);
void            topo_discovery_error (char * fcnt, char * msg, char * opt);
int		topo_slave_device_registration (char* name_of_device, Objid mac_objid, int piconet_read, int my_address);
int	        topo_device_wlan_registration (Objid mac_objid, int my_address, int piconet_read);
void		topo_master_device_registration (char* name_of_device, Objid mac_objid, int piconet_read, int my_address);
void		topo_channel_registration (Objid channel);
Master_Device *	topo_get_master_device (int piconet_number);
Slave_Device  *	topo_get_slave_device_from_address(int address, int piconet_number);
int				topo_index_slave_from_address (int mac_address, int piconet_number);
Wlan_Device   *	topo_get_wlan_device_from_address(int address);
Objid		topo_get_channel();
int			topo_get_number_of_slaves (int piconet_number);
int             topo_get_number_of_piconet();
int             topo_get_piconet_number (int piconet_real);
int		topo_get_piconet_wlan (int piconet_real);
int             topo_choose_dest_address (int dest_address_read, int number_of_slave, int old_dest_address);
void            topo_print_device_list(int piconet_number);
void		topo_print_wlan_list ();
int     	topo_get_address_of_slave (const char* name_of_slave, int piconet_number);
void		topo_discovery_free_memory ();
/*int             topo_get_mac_addr_from_objid (int piconet_number, Objid objid);*/
/*void            topo_check_address(int address);*/
void		topo_register_slave_id ();

#endif	/* __TOPO_DISCOVERY_H__ */
