/*
** $File : slaves_management.ex.c
**
** Bluetooth model in Opnet
** National Institute of Standards and Technology
**
** This model was developed at the National Institute of Standards
** and Technology by employees of the Federal Government in the course
** of their official duties. Pursuant to title 17 Section 105 of the
** United States Code this software is not subject to copyright
** protection and is in the public domain. This is an experimental
** system.  NIST assumes no responsibility whatsoever for its use by
** other parties, and makes no guarantees, expressed or implied,
** about its quality, reliability, or any other characteristic.
**
** We would appreciate acknowledgement if the model is used.
**
** NIST ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION
** AND DISCLAIM ANY LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER
** RESULTING FROM THE USE OF THIS SOFTWARE.
**
** Primary Author:      nist
** Module description:  Bluetooth module
** Last Modification:   July, 12, 2002
**
*/


/* include header */
#include "slaves_management.h"


/*
 * Function:	mem_alloc_for_slv_req
 */

void mem_alloc_for_slv_req (void) /*memory allocation for the saves requirement*/
{
  int i,k;
  
  FIN ( mem_alloc_for_slv_req() );
  
  for ( k = 0 ; k < 4 ; k++ )
    requirement_table[k] = (int**) malloc ( 7 * sizeof(int*) );
  
  FOUT;
}


/*
 * Function:	get_traffic_type
 */

void get_traffic_type(Objid mac_objid)
{
  int *traffic_type;
  int *slave_name;
  int interval_polling_time;  
  int i = 0;
  int j;
  static call_num = 0;

  FIN( get_traffic_type() );  

  traffic_type = (int*)malloc( 5 * sizeof(int) );   
  slave_name = (int*)malloc(MAX_NAME * sizeof(int) );
  op_ima_obj_attr_get(op_topo_parent(op_id_self()), "traffic type", traffic_type);
  op_ima_obj_attr_get(op_topo_parent(op_id_self()), "polling interval", &interval_polling_time );
  op_ima_obj_attr_get(op_topo_parent(op_id_self()), "name", slave_name);


  requirement_table[0][call_num] = (int*)malloc( MAX_NAME * sizeof(int) );
  for ( j = 0 ; j < MAX_NAME ; j++ )
    {
      /* printf(" slave_name[%d] is %c \n",j,slave_name[j]);*/
      requirement_table[0][call_num][j] = slave_name[j];
    }

  printf(" requirement_table[%d][%d] is %s \n",0,call_num, requirement_table[0][call_num]);


  requirement_table[1][call_num] = (int*)malloc( 1 * sizeof(int) );
  requirement_table[1][call_num][0] = mac_objid;
  printf(" requirement_table[%d][%d][0] is %d \n",1,call_num, requirement_table[1][call_num][0]);


  requirement_table[2][call_num] = (int*)malloc( MAX_NAME * sizeof(int) );
  for ( j = 0 ; j < 5 ; j++ )
    requirement_table[2][call_num][j] = traffic_type[j];
  printf(" requirement_table[%d][%d] is %s \n",2,call_num, requirement_table[2][call_num]);
  

  requirement_table[3][call_num] = (int*)malloc( 1 * sizeof(int) );
  requirement_table[3][call_num][0] = (int)interval_polling_time;
  printf("interval_polling_time is %d \n",interval_polling_time);
  printf(" requirement_table[%d][%d][0] is %d \n",3,call_num,requirement_table[3][call_num][0]);
  

  call_num++;
  FOUT;
}

