/*
** $File : physics_rx.ex.c
**
** Bluetooth model in Opnet
** National Institute of Standards and Technology
**
** This model was developed at the National Institute of Standards
** and Technology by employees of the Federal Government in the course
** of their official duties. Pursuant to title 17 Section 105 of the
** United States Code this software is not subject to copyright
** protection and is in the public domain. This is an experimental
** system.  NIST assumes no responsibility whatsoever for its use by
** other parties, and makes no guarantees, expressed or implied,
** about its quality, reliability, or any other characteristic.
**
** We would appreciate acknowledgement if the model is used.
**
** NIST ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION
** AND DISCLAIM ANY LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER
** RESULTING FROM THE USE OF THIS SOFTWARE.
**
** Primary Author:      Amir Soltanian
** Module description:  Bluetooth physical layer
** Last Modification:   July, 9, 2002
**
*/

/* include header */
#include "physic.h"

/*
 * Function:	Demodulator_Ldid
 */

char	Demodulator_Ldid(short int n, physical_layer *PHY)
{
	char decode;
	
	FIN (Demodulator_Ldid (n, PHY));
 
	decode =	receiver (n, PHY);
	
	FRET (decode);
 }


/*
 * Function:	receiver
 *
 * Notice:		The Last Two bits were ignored in each packet.
 */

char	receiver (short int n,physical_layer *PHY)
{
	double X[Ns] , Y[Ns];
	double Xdot[Ns] , Ydot[Ns]; 
	double Phidot[Ns],Phi;
	short int i, j;
	char decod;

	FIN (receiver (n, PHY));
	
	/* If Filter */
	
	if(!n)
		{ 
		for (i = 0; i < BPLENGTH; i++)
			{
			PHY->IM[i] = 0;PHY->QM[i] = 0;
			}
		}
	
	for (i = 0; i < Ns; i++)
		{
		X[i] = 0.;
		Y[i] = 0.;
		for ( j = BPLENGTH -2; j >=0 ; j--)
			{
			PHY->IM[j+1] = PHY->IM[j];
			PHY->QM[j+1] = PHY->QM[j];
			}
		PHY->IM[0] = PHY->Inphase[i]; 
		PHY->QM[0] = PHY->Quad[i]; 
		for ( j = 0; j < BPLENGTH; j++)
			{
			X[i] += PHY->IM[j]*PHY->hr[BPLENGTH-j-1];
			Y[i] += PHY->QM[j]*PHY->hr[BPLENGTH-j-1];
			}
		}


	/* Diffrentiator */
	
	if(!n)
		{ 
		for (i = 0; i < DIFFLENGTH ; i++)
			{
			PHY->IMD[i] = 0;PHY->QMD[i] = 0;
			}
		}
	
	for (i = 0; i < Ns; i++)
		{
		Xdot[i] =0.;
		Ydot[i] =0.;
		for ( j = DIFFLENGTH-2; j >=0 ; j--)
			{
			PHY->IMD[j+1] = PHY->IMD[j];
			PHY->QMD[j+1] = PHY->QMD[j];
			}
		PHY->IMD[0] = X[i]; 
		PHY->QMD[0] = Y[i]; 
		for ( j = 0; j < DIFFLENGTH; j++)
			{
			Xdot[i] += PHY->IMD[j]*PHY->hdiff[j];
			Ydot[i] += PHY->QMD[j]*PHY->hdiff[j];
			}
		}


	/* LimiterDiscriminator */
	
	for (i = 0; i < Ns; i++)
		{
		Phidot[i] = ( X[i]*Ydot[i] - Y[i]*Xdot[i] )/( X[i]*X[i] + Y[i]*Y[i] );
		}
	
	/* Integrate and dump Fillter and detection */
	
    Phi = 0;
    for (j = 0; j < Ns; j++)
		{
		Phi += Phidot[j];
		}

	if(Phi < 0)
		{
		decod= 1;
		}
	else if(Phi>= 0)
		{
		decod= 0;
		}

    FRET (decod); 
}


/*
 * Function:	Demodulator_CCK
 */

void	Demodulator_CCK (short int n, physical_layer *PHY, int *recbit)
{
	FIN(Demodulator_CCK (n, PHY, recbit));
	
	w11receiver (n, PHY, recbit);
	
	FOUT;
}


/*
 * Function:	receiver
 *
 * Notice:		The Last Two bits were ignored in each packet.
 */

void w11receiver (short int n,physical_layer *PHY, int *decod)
{
	static 			double ph0;
	static			double IM[RSLENGTH], QM[RSLENGTH];
	unsigned short 	int i, k,d10,d32,d54,d76;

	double	X[11*8*Nscck] , Y[11*8*Nscck];
	double	x11[4][2],x33[16][2],x22[8][2],xr[32];
	double	max,ph1,ph2,ph3,ph4,ii,qq,phb;
	double	i1[4]={1,-1,0,0};
	double	q1[4]={0,0,1,-1};
	int		d1[4]={0,1,3,2};
	double	i2[4]={0,-1,0,1};
	double	q2[4]={-1,0,1,0};
	int		d2[4]={2,1,3,0};
	double	i3[4]={1,0,-1,0};
	double	q3[4]={0,1,0,-1};
	int		d3[4]={0,3,1,2};
	int 	j,t;
	double	cc;

	
	FIN (w11receiver (n, PHY, decod));
	
	
	for (i=0;i<6;i++)
		decod[i] = 0;

	for (i = 0; i < 11*8*Nscck; i++)
		{
		X[i] = 0.;
		Y[i] = 0.;
		for ( j = RSLENGTH -2; j >=0 ; j--)
			{
			IM[j+1] = IM[j];
			QM[j+1] = QM[j];
			}
		IM[0] = PHY->Inphase[i]; 
		QM[0] = PHY->Quad[i];
		for ( j = 0; j < RSLENGTH; j++)
			{
			X[i] += IM[j]*PHY->hraised[RSLENGTH-j-1];
			Y[i] += QM[j]*PHY->hraised[RSLENGTH-j-1];
			}
		}
	
	if(n==224)
		{ 
		ph0=0;
		}

	for (t = 0; t < 11; t++)
		{
		for (i = 0; i < 8; i++)
			{
			PHY->Inphase[i]=X[i*Nscck+t*32];
			PHY->Quad[i]=Y[i*Nscck+t*32];
			}
		PHY->Inphase[3]=-PHY->Inphase[3];
		PHY->Quad[3]=-PHY->Quad[3];
		PHY->Inphase[6]=-PHY->Inphase[6];
		PHY->Quad[6]=-PHY->Quad[6];
		max=0;
		for ( i = 0; i <4; i++)
			{
			for (j = 0; j < 4; j++)
				{
				x11[j][0] =(PHY->Inphase[2*j]*i1[i]-PHY->Quad[2*j]*q1[i]);
				x11[j][1] =(PHY->Inphase[2*j]*q1[i]+PHY->Quad[2*j]*i1[i]);
				x11[j][0] +=PHY->Inphase[2*j+1];
				x11[j][1] +=PHY->Quad[2*j+1];
				}
			
			for ( j = 0; j <4; j++)
				{
				x22[j][0] =(x11[0][0]*i2[j]-x11[0][1]*q2[j]);
				x22[j][1] =(x11[0][0]*q2[j]+x11[0][1]*i2[j]);
				x22[j][0] +=x11[1][0];
				x22[j][1] +=x11[1][1];
				}
			
			for ( j = 4; j <8; j++)
				{
				x22[j][0] =(x11[2][0]*i2[j-4]-x11[2][1]*q2[j-4]);
				x22[j][1] =(x11[2][0]*q2[j-4]+x11[2][1]*i2[j-4]);
				x22[j][0] +=x11[3][0];
				x22[j][1] +=x11[3][1];
				}
			
			for ( j = 0; j <4; j++)
				{
				x33[j][0] =(x22[0][0]*i3[j]-x22[0][1]*q3[j]);
				x33[j][1] =(x22[0][0]*q3[j]+x22[0][1]*i3[j]);
				x33[j][0] +=x22[4][0];
				x33[j][1] +=x22[4][1];
				}
			
			for ( j = 4; j <8; j++)
				{
				x33[j][0] =(x22[1][0]*i3[j-4]-x22[1][1]*q3[j-4]);
				x33[j][1] =(x22[1][0]*q3[j-4]+x22[1][1]*i3[j-4]);
				x33[j][0] +=x22[5][0];
				x33[j][1] +=x22[5][1];
				}
			
			for ( j = 8; j <12; j++)
				{
				x33[j][0] =(x22[2][0]*i3[j-8]-x22[2][1]*q3[j-8]);
				x33[j][1] =(x22[2][0]*q3[j-8]+x22[2][1]*i3[j-8]);
				x33[j][0] +=x22[6][0];
				x33[j][1] +=x22[6][1];
				}
			
			for ( j = 12; j <16; j++)
				{
				x33[j][0] =(x22[3][0]*i3[j-12]-x22[3][1]*q3[j-12]);
				x33[j][1] =(x22[3][0]*q3[j-12]+x22[3][1]*i3[j-12]);
				x33[j][0] +=x22[7][0];
				x33[j][1] +=x22[7][1];
				}
			
			for ( j = 0; j <32; j++)
				xr[j]=x33[j/2][j%2];
			
			for ( j = 0; j <32; j+=2)
				{
				cc=xr[j]*xr[j]+xr[j+1]*xr[j+1];
				if(cc>=max)
					{
					max=cc;
					k=j/2;
					ii=xr[j];
					qq=xr[j+1];
					ph1=atan2(xr[j+1],xr[j]);
					ph2=atan2(-q1[i],i1[i]);
					d32=d1[i];
					ph4=atan2(-q3[k%4],i3[k%4]);
					d76=d3[k%4];
					ph3=atan2(-q2[k/4],i2[k/4]);
					d54=d2[k/4];
					}
				}
			}
		
		k=(d76<<4)|(d54<<2)|d32;
		
		if(ph1<0)
			ph1+=2*PI;
		phb=ph1;
		ph1-=ph0;
		ph0=phb;
		if(ph1<0)
			ph1+=2*PI;
		if((0<=ph1) &&(ph1<PI/4))
			d10=0;
		if((7*PI/4<=ph1) &&(ph1<2*PI))
			d10=0;
		if((PI/4<=ph1) &&(ph1<3*PI/4))
			d10=2;
		if((3*PI/4<=ph1) &&(ph1<5*PI/4))
			d10=1;
		if((5*PI/4<=ph1) &&(ph1<7*PI/4))
			d10=3;

		k<<=2;
		k |=d10;

		k <<=((t*8)%16);
		decod[(t*8)/16] |= k;

		}
	
	FOUT;
}


/*
 * Function:	Demodulator_DBPSK
 */

char Demodulator_DBPSK(short int n, physical_layer *PHY)
{
	char decode;
	
	FIN (Demodulator_DBPSK (n, PHY));
	
	decode =	wreceiver (n, PHY);
	
	FRET (decode);
}


/*
 * Function:	receiver
 *
 * Notice:		The Last Two bits were ignored in each packet.
 */

char wreceiver (short int n,physical_layer *PHY)
{
	static	double D_m_1_n[5][2],D_m_1_n_1[5][2];
	static	double G_fm_n[5][2],G_bm_n[5][2];
	static	double f_m_n[5][2],b_m_n_1[5][2],b_m_n[5][2];
	static	double F_m_n_1[5],F_m_n[5],B_m_n[5],B_m_n_1[5];
	static	double g_m_n_1[5];
	
	double X[Ns] , Y[Ns];
	double Xdes, Ydes,Xdec,Ydec; 
	short int i, j;
	double yI[11],yQ[11],NrzChip[11]={1,-1,1,1,-1,1,1,1,-1,-1,-1};
	double temp;
	char decod;
	double delta=.04,lambda=.970;
	int M=3;

	
	FIN (wreceiver (n, PHY));
	
	
	if(!n)
		{ 
		for (i = 0; i < RSLENGTH; i++)
			{
			PHY->wIM[i] = 0;PHY->wQM[i] = 0;
			} 
		PHY->XMem =-44;
		PHY->YMem =-44;
		for(i = 0;i < M+1; i++)
			{
			D_m_1_n_1[i][0]=0;
			D_m_1_n_1[i][1]=0;
			b_m_n_1[i][0]=0;
			b_m_n_1[i][1]=0;
			F_m_n_1[i]=delta;
			B_m_n_1[i]=delta;
			}
		}
	
	for (i = 0; i < Ns; i++)
		{
		X[i] = 0.;
		Y[i] = 0.;
		for ( j = RSLENGTH -2; j >=0 ; j--)
			{
			PHY->wIM[j+1] = PHY->wIM[j];
			PHY->wQM[j+1] = PHY->wQM[j];
			}
		PHY->wIM[0] = PHY->Inphase[i]; 
		PHY->wQM[0] = PHY->Quad[i];
		for ( j = 0; j < RSLENGTH; j++)
			{
			X[i] += PHY->wIM[j]*PHY->hraised[RSLENGTH-j-1];
			Y[i] += PHY->wQM[j]*PHY->hraised[RSLENGTH-j-1];
			}
		}

	if(!n)
		{ 
		for (i = 0; i < Ns-DLY ; i++)
			{
			PHY->wIMD[i] = X[i+DLY];
			PHY->wQMD[i] = Y[i+DLY];
			}
		}
	else if (n)
		{
		for (i = 0; i < Ns; i++)
			{
			PHY->wIMD[i+Ns-DLY]=X[i];
			PHY->wQMD[i+Ns-DLY]=Y[i];
			}
		
		for (j = 0; j < Ns; j+=4)
			{
			b_m_n[0][0]=f_m_n[0][0]=PHY->wIMD[j];
			b_m_n[0][1]=f_m_n[0][1]=PHY->wQMD[j];
			B_m_n[0]=F_m_n[0] = lambda*F_m_n_1[0]+PHY->wIMD[j]*PHY->wIMD[j]+PHY->wQMD[j]*PHY->wQMD[j];
			g_m_n_1[0]=1;
			
			for (i = 1; i <M+1; i++)
				{
				D_m_1_n[i-1][0]= lambda*D_m_1_n_1[i-1][0]+
				(b_m_n_1[i-1][0]*f_m_n[i-1][0]+b_m_n_1[i-1][1]*f_m_n[i-1][1])/g_m_n_1[i-1];
				D_m_1_n[i-1][1]= lambda*D_m_1_n_1[i-1][1]+
				(b_m_n_1[i-1][1]*f_m_n[i-1][0]-b_m_n_1[i-1][0]*f_m_n[i-1][1])/g_m_n_1[i-1];

				G_fm_n[i][0]=-D_m_1_n[i-1][0]/B_m_n_1[i-1];
				G_fm_n[i][1]=-D_m_1_n[i-1][1]/B_m_n_1[i-1];
			
				G_bm_n[i][0]=-D_m_1_n[i-1][0]/F_m_n[i-1];
				G_bm_n[i][1]= D_m_1_n[i-1][1]/F_m_n[i-1];

				f_m_n[i][0]=f_m_n[i-1][0]+b_m_n_1[i-1][0]*G_fm_n[i][0]+b_m_n_1[i-1][1]*G_fm_n[i][1];
				f_m_n[i][1]=f_m_n[i-1][1]+b_m_n_1[i-1][1]*G_fm_n[i][0]-b_m_n_1[i-1][0]*G_fm_n[i][1];
				b_m_n[i][0]=b_m_n_1[i-1][0]+f_m_n[i-1][0]*G_bm_n[i][0]+f_m_n[i-1][1]*G_bm_n[i][1];
				b_m_n[i][1]=b_m_n_1[i-1][1]+f_m_n[i-1][1]*G_bm_n[i][0]-f_m_n[i-1][0]*G_bm_n[i][1];
				temp =D_m_1_n[i-1][0]*D_m_1_n[i-1][0]+D_m_1_n[i-1][1]*D_m_1_n[i-1][1];
				F_m_n[i]=F_m_n[i-1]-temp/B_m_n_1[i-1];
				B_m_n[i]=B_m_n_1[i-1]-temp/F_m_n[i-1];
				temp =b_m_n_1[i-1][0]*b_m_n_1[i-1][0]+b_m_n_1[i-1][1]*b_m_n_1[i-1][1];
				g_m_n_1[i]=g_m_n_1[i-1]-temp/B_m_n_1[i-1];

				yI[j/4]=f_m_n[i][0];
				yQ[j/4]=f_m_n[i][1];
				}

			for (i = 0; i <M+1; i++)
				{
				D_m_1_n_1[i][0]= D_m_1_n[i][0];
				D_m_1_n_1[i][1]= D_m_1_n[i][1];

				b_m_n_1[i][0]=b_m_n[i][0];
				b_m_n_1[i][1]=b_m_n[i][1];

				F_m_n_1[i]=F_m_n[i];
				B_m_n_1[i]=B_m_n[i];
				}
			}

		Xdes=Ydes=0;
		for (i = 0; i < 11; i++)
			{
				Xdes +=(yI[i] *NrzChip[i]);
				Ydes +=(yQ[i] *NrzChip[i]);
			}
		
		for (i = 0; i < Ns-DLY; i++)
			{
			PHY->wIMD[i] = PHY->wIMD[i+Ns];
			PHY->wQMD[i] = PHY->wQMD[i+Ns];
			}
		
		Xdec =  PHY->XMem * Xdes;//diffdecod
		Ydec =  PHY->YMem * Ydes;
		PHY->XMem = Xdes;
		PHY->YMem = Ydes;

		if(Xdec+Ydec <= 0)
			decod =1;
		else if(Xdec+Ydec > 0)
			decod = 0;
		}
		
	FRET (decod);
}


/*
 * Function:	receiver
 *
 * Notice:		The Last Two bits were ignored in each packet.
 */

char receiver_VTB (short int n,physical_layer *PHY)
{
	double X[Ns] , Y[Ns];
	double Xdot[Ns] , Ydot[Ns]; 
	double Phidot[Ns],Phi;
	short int i, j;
	char decod;

	FIN (receiver_VTB (n, PHY));
	
	/* If Filter */
	if(!n){ 
		for (i = 0; i < BPLENGTH; i++){
			PHY->IM[i] = 0;PHY->QM[i] = 0;
			}
		}
	
	for (i = 0; i < Ns; i++){
		X[i] = 0.;
		Y[i] = 0.;
		for ( j = BPLENGTH -2; j >=0 ; j--){
			PHY->IM[j+1] = PHY->IM[j];
			PHY->QM[j+1] = PHY->QM[j];
			}
		PHY->IM[0] = PHY->Inphase[i]; 
		PHY->QM[0] = PHY->Quad[i]; 
		for ( j = 0; j < BPLENGTH; j++){
			X[i] += PHY->IM[j]*PHY->hr[BPLENGTH-j-1];
			Y[i] += PHY->QM[j]*PHY->hr[BPLENGTH-j-1];
			}
	}


	/* Diffrentiator */
	
	if(!n){ 
		for (i = 0; i < DIFFLENGTH ; i++){
			PHY->IMD[i] = 0;PHY->QMD[i] = 0;
			}
		}
	
	for (i = 0; i < Ns; i++){
		Xdot[i] =0.;
		Ydot[i] =0.;
		for ( j = DIFFLENGTH-2; j >=0 ; j--){
			PHY->IMD[j+1] = PHY->IMD[j];
			PHY->QMD[j+1] = PHY->QMD[j];
			}
		PHY->IMD[0] = X[i]; 
		PHY->QMD[0] = Y[i]; 
		for ( j = 0; j < DIFFLENGTH; j++){
			Xdot[i] += PHY->IMD[j]*PHY->hdiff[j];
			Ydot[i] += PHY->QMD[j]*PHY->hdiff[j];
			}
		}


	/* LimiterDiscriminator */
	
	for (i = 0; i < Ns; i++){
		Phidot[i] = ( X[i]*Ydot[i] - Y[i]*Xdot[i] )/( X[i]*X[i] + Y[i]*Y[i] )  ;
		}
	
	/* Integrate and dump Fillter and detection */
	
    Phi = 0;
    for (j = 0; j < Ns; j++)
		{
		Phi += Phidot[j];
		}

	if(Phi < 0)
		{
		decod= 1;
		}
	else if(Phi>= 0)
		{
		decod= 0;
		}
		
	FRET (decod) ; 
}
