/*
** $File : physic.h
**
** Bluetooth model in Opnet
** National Institute of Standards and Technology
**
** This model was developed at the National Institute of Standards
** and Technology by employees of the Federal Government in the course
** of their official duties. Pursuant to title 17 Section 105 of the
** United States Code this software is not subject to copyright
** protection and is in the public domain. This is an experimental
** system.  NIST assumes no responsibility whatsoever for its use by
** other parties, and makes no guarantees, expressed or implied,
** about its quality, reliability, or any other characteristic.
**
** We would appreciate acknowledgement if the model is used.
**
** NIST ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION
** AND DISCLAIM ANY LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER
** RESULTING FROM THE USE OF THIS SOFTWARE.
**
** Primary Author:      Amir Soltanian
** Module description:  Bluetooth physical layer
** Last Modification:   July, 9, 2002 (Olivier Rebala)
**
*/

#ifndef __PHYSIC_H__
#define __PHYSIC_H__

/* Standard includes */
#include <opnet.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

/* Define some constants */
#define IB1 1
#define IB3 4
#define IB20 524288
#define MASK IB3
#define Ns 44
#define hf 1./3.
#define PI 3.141592654
#define INTPHASE 0
#define ALPHA_N_1 0
#define BPLENGTH 3*Ns-1
#define RSLENGTH 33
#define DIFFLENGTH 6 
#define Br 1.1
#define RBUF 2*Ns
#define DLY 31
#define DLY11 32
#define sensitivity -80
#define Nscck 4
#define sampleTime Ns/2-1
#define Accesslength  64
#define Spsition 0  
#define lenmax 400
#define totsamples 10


/* Define new structures */
typedef struct 
{	
  /*  Interface   */
  char sw; 
  
  /* transmitter parameters  */
  double qcoef[88];
  double a1;
  double ph;
  double Inphase[8*Ns], Quad[8*Ns];
  char diffbuf;
  double CInphase[256][8],CQuad[256][8];
  double phcck,I1B[RSLENGTH],Q1B[RSLENGTH],stateB802[RSLENGTH];

  /* channel parameters   */
  int    x1,x2,x3,x4,x5,x6;
  int    x7,x8,x9,xa,xb,xc;
  double n0,pr1;
    
  /* receiver parameters  */
  double wIM[RSLENGTH], wQM[RSLENGTH];
  double wIMD[RBUF], wQMD[RBUF];
  double IM[BPLENGTH], QM[BPLENGTH];
  double IMD[DIFFLENGTH], QMD[DIFFLENGTH];
  double hr[BPLENGTH], hdiff[11], hraised[RSLENGTH];
  double XMem,YMem;

  /*VTB*/
  double hhi[64],hhq[64];
  double Realambig[3],Imambig[3];
  double SI[4],SQ[24];
  double inphases[lenmax],quads[lenmax];
  double InphaseF[Ns],QuadF[Ns];
  
  /* Interference parameters  */
  unsigned int iseed;
  double badj[100];
  double phInt[100],stateInt802[100][RSLENGTH];
  short int TdIntBT[100];
  short int TdInt802[100];
  double a1Int[100]; 
  double AdjIntQuadB[100][2*Ns], AdjIntInphaseB[100][2*Ns];
  int IntCounter[100];
} physical_layer;


/* Function prototypes */
void initialize_physical_layer(physical_layer *, int );
void reset_physical_layer(physical_layer *, int );
void DataGen(char *, int, physical_layer * );
void DataGenVTB(char *, int, physical_layer * );
void Wlan_bt_collision(physical_layer *, char *, double **, int, char);
void Wlan_bt_collision_VTB(physical_layer *, char *, double **, int, char);
void VTB_Rayleigh(physical_layer *, char *, double **, int, char);
void Bt802_Wlan1_collision(physical_layer *, char *, double **, int, char);
void Bt802_Wlan11_collision(physical_layer *, char *, double **, int, char);
void Bt_WlanFH1_collision(physical_layer *, char *, double **, int, char);
void Interface( physical_layer *, double **);
void wInterface( physical_layer *, double **);
void wInterface11( physical_layer *, double **);
void Interfere(short int, physical_layer *, double **, int); 
void Interfere11(short int, physical_layer *, double **, int); 
void IntBypassB(physical_layer *, char *,double **,int);
void IntBypassB_VTB(physical_layer *, char *,double **,int);
void IntBypassW(physical_layer *, char *,double **,int);
void IntBypassW11(physical_layer *, char *,double **,int);
void Tx80211(char *d,double ,physical_layer *, int, int, char);
void AdjIntRead(char *,double,physical_layer *, int, int, char);
void Bypass(physical_layer *, char *, double **);
void Bypass_VTB(physical_layer *, char *, double **);
void modulator(short int, physical_layer *, char );
void Channel_AWGN(physical_layer *);
void Channel_Rayleigh(physical_layer *);
void Channel_AWGN11(physical_layer *);
void NoiseGen(physical_layer *, int);
char Demodulator_Ldid(short int, physical_layer *);
char Demodulator_DBPSK(short int, physical_layer *);
void Demodulator_CCK(short int, physical_layer *, int *);
char receiver (short int ,physical_layer *);
void wBypass(physical_layer *, char *, double **);
void w11Bypass(physical_layer *, char *, double **);
void wmodulator(short int, physical_layer *, char );
void w11modulator(short int, physical_layer *, short *);
char DiffEncode( physical_layer *, char );
char wreceiver (short int ,physical_layer *);
void w11receiver (short int ,physical_layer *, int *);
double  Uniform( physical_layer *);
void MatchFilter (physical_layer *);
void SIQTable(physical_layer *);
void Sampler (int ,physical_layer *);
void Receiver_VTB (physical_layer *,char *,double **);
void ChanRespConv(physical_layer *,double **);

#endif /* end of __PHYSIC_H__ */
