/*
** fifo_support.h:
**
** Bluetooth model in Opnet
** National Institute of Standards and Technology
**
** This model was developed at the National Institute of Standards
** and Technology by employees of the Federal Government in the course
** of their official duties. Pursuant to title 17 Section 105 of the
** United States Code this software is not subject to copyright
** protection and is in the public domain. This is an experimental
** system.  NIST assumes no responsibility whatsoever for its use by
** other parties, and makes no guarantees, expressed or implied,
** about its quality, reliability, or any other characteristic.
**
** We would appreciate acknowledgement if the model is used.
**
** NIST ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION
** AND DISCLAIM ANY LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER
** RESULTING FROM THE USE OF THIS SOFTWARE.
**
** Primary Author:      Frederic Mouveaux
** Module description:  FiFo scheduling algorithm using One queue
** Last Modification:   January, 15th 2003 (Olivier Rebala)
*/

#ifndef	__FIFO_SUPPORT_H__
#define	__FIFO_SUPPORT_H__

/* Standard includes */
#include <opnet.h>
#include "bt_support.h"

/* Subqueues definition */
typedef enum fifo_subq_value
{
	SUBQ_INPUT,
	SUBQ_INPUT_SCO
} FIFOSubq;

/* Define the number of queues */
#define		FIFO_NB_MAX_QUEUE		2

/* Function prototypes declaration */
List **		fifo_init_support ();
void		fifo_pkt_enqueue (List **fifo_bt_queue, Packet * pkptr, int subq);
void		fifo_pkt_enqueue_in_head (List **fifo_bt_queue, Packet * pkptr, int subq);
Packet *	fifo_request_pkt_to_scheduler (List **fifo_bt_queue);
Boolean		fifo_bt_queue_empty (List **fifo_bt_queue, int queue);
Packet *	fifo_pk_queue_remove (List **fifo_bt_queue, int queue, int pos_index);
Packet *	fifo_pk_queue_access (List **fifo_bt_queue, int queue, int pos_index);
void		fifo_end_free (List **fifo_bt_queue);

#endif	/* end of __FIFO_SUPPORT_H__ */
