/***********************************************************/
/*   physical.c  - contains the functions for the          */
/*                  physical layer.                        */
/***********************************************************/

#include "physic.h"



/***********************************************************/ 

void 	VTB_Rayleigh(physical_layer *PHY, char *packet,double **interface_pt,
						  int collision_number, char BypassInterfer ) {

	int i;
   	Interface(PHY,interface_pt);
	for(i = 0; i < interface_pt[1][0] ; i++) {
		modulator(i, PHY, packet[i]);
		Channel_AWGN(PHY);
		Sampler(i,PHY);
		}/*	for(i = 0; i < interface_pt[1][0] ; i++) {*/
	 Receiver_VTB (PHY,packet,interface_pt);
}   /* end */

/*******************************
Sampler
The Last Two bits were ignored in each packet.
*******************************/
void Sampler (int n,physical_layer *PHY){
	PHY->inphases[n] =PHY->Inphase[21];
	PHY->quads[n] =PHY->Quad[21];
	}

/*******************************
receiver
The Last Two bits were ignored in each packet.
*******************************/
void Receiver_VTB (physical_layer *PHY,char *packet,double **interface_pt){

	double HprimI[2*Accesslength-1] = {0}, HprimQ[2*Accesslength-1]={0};
	double bufI[Accesslength]={0}, bufQ[Accesslength]={0};
	double e[5],eMAX=0,HestI,HestQ;
	double XI[lenmax],XQ[lenmax];
	double XIBAR[24],XQBAR[24];
	short int i, j,k,dd[lenmax],Oldpath[lenmax*2],num,Ic,Ip,OldP[2]={0,0},NewP[2];
	double OldM[2]={0,10000},NewM[2],AL,AH;
	double z[2];
	int delay;
	int palen;
	
/*****************************************
IF Filter
*****************************************/
	
	palen=interface_pt[1][0];
	for (j = 0; j < 2*Accesslength-1; j++){
		bufI[0]=PHY->inphases[j+Spsition];
		bufQ[0]=PHY->quads[j+Spsition];
		for ( i = 0; i < Accesslength; i++){
			HprimI[j] += (bufI[i]*PHY->hhi[i]-bufQ[i]*PHY->hhq[i]);
			HprimQ[j] +=(bufI[i]*PHY->hhq[i]+bufQ[i]*PHY->hhi[i]);
			}/*for (short int j=0;j<BPLENGTH;j++){*/
		for ( i =Accesslength-1 ; i >=1; i--){
			bufI[i]=bufI[i-1];
			bufQ[i]=bufQ[i-1];
			}
	}/*for (short int i=0;i<totsamples-BPLENGTH;i++){*/
	for ( i = 0; i < 5; i++){
		e[i]=HprimI[i+Accesslength-1]* HprimI[i+Accesslength-1]+HprimQ[i+Accesslength-1]*HprimQ[i+Accesslength-1];
		if(e[i]>eMAX){
			k=i;
			eMAX=e[i];
			}
		}/*for (short int j=0;j<BPLENGTH;j++){*/
	delay=k;
	HestI=HprimI[Accesslength-1+k];
	HestQ=HprimQ[Accesslength-1+k];

	for ( i = 0; i < palen; i++){
		XI[i] =PHY->inphases[k+i]*PHY->Realambig[0];
		XQ[i] =PHY->quads[k+i]*PHY->Realambig[0];
		}/*for (short int j=0;j<BPLENGTH;j++){*/
	

	for ( i = 0; i < 24; i++){
		XIBAR[i] =HestI*PHY->SI[i]-HestQ*PHY->SQ[i];
		XQBAR[i] =HestI*PHY->SQ[i]+HestQ*PHY->SI[i];
		}/*for (short int j=0;j<BPLENGTH;j++){*/

 /*	if( (fp=fopen("SITABLE.c","wb"))==NULL)
		 printf("can't open iqin.dat");
    fprintf(fp,"SI and SQ=0\n");
	for(j=0;j<24;j++)
	 	   fprintf(fp," \nSI[%2d] =%8.5f, SQ[%2d] =%8.5f",j,SI[j],j,SQ[j]);
	fclose(fp);*/

	for (i = 0; i < palen-2; i++){
		for ( j = 0; j < 2; j++){
		num=OldP[j];
		z[j]=(XI[i]-XIBAR[j+num])*(XI[i]-XIBAR[j+num])
			+(XQ[i]-XQBAR[j+num])*(XQ[i]-XQBAR[j+num]);
		}
		AH=z[0]+OldM[0];
		AL=z[1]+OldM[1];
		if(AH<=AL){
			NewP[0]=OldP[0]+4;
			NewM[0]=AH;
			Oldpath[2*i]=0;;
			}
		else{
			NewP[0]=OldP[1]-4;
			NewM[0]=AL;
			Oldpath[2*i]=1;
			}
		for ( j = 0; j < 2; j++){
		num=OldP[j];
		z[j]=(XI[i]-XIBAR[j+num+2])*(XI[i]-XIBAR[j+num+2])+
			(XQ[i]-XQBAR[j+num+2])*(XQ[i]-XQBAR[j+num+2]);
		}
		AH=z[0]+OldM[0];
		AL=z[1]+OldM[1];
		if(AH<=AL){
			NewP[1]=OldP[0]+4;
			NewM[1]=AH;
			Oldpath[2*i+1]=0;
			}
		else{
			NewP[1]=OldP[1]-4;
			NewM[1]=AL;
			Oldpath[2*i+1]=1;
			}
		for ( j = 0; j < 2; j++){
			if(NewP[j]<0)
				NewP[j] +=24;
				NewP[j] %=24;
			OldP[j]=NewP[j];
			OldM[j]=NewM[j];
			}
		i=i;
		}/*	for (i = 0; i < palen*16; i++){*/
		if(OldM[0]<OldM[1])
			Ic=0;
		else 
			Ic=1;
		for(i=palen-3;i>=0;i--){
				Ip=(2*Ic+Oldpath[2*i+Ic])%2;
				dd[i] =Ic;
				Ic=Ip;
				}
		for(i=0;i<palen;i++){
				packet[i] |=(dd[i]<<(i%16));
				
				}
			

}
