/*
** wlan_bt_ecc.h :
**
** Bluetooth model in Opnet
** National Institute of Standards and Technology
**
** This model was developed at the National Institute of Standards
** and Technology by employees of the Federal Government in the course
** of their official duties. Pursuant to title 17 Section 105 of the
** United States Code this software is not subject to copyright
** protection and is in the public domain. This is an experimental
** system.  NIST assumes no responsibility whatsoever for its use by
** other parties, and makes no guarantees, expressed or implied,
** about its quality, reliability, or any other characteristic.
**
** We would appreciate acknowledgement if the model is used.
**
** NIST ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION
** AND DISCLAIM ANY LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER
** RESULTING FROM THE USE OF THIS SOFTWARE.
**
** Primary Author:      ???
** Module description:  Bluetooth Common MAC Function Support
** Last Modification:   June, 19, 2002
*/

#ifndef __WLAN_BT_ECC_H__
#define __WLAN_BT_ECC_H__

/* standard includes */
#include <opnet.h>
#include <math.h>
#include <string.h>
#include <sys/types.h>
#include <time.h>
#include <stdlib.h>                     	/* Used for random generation */
#include "bt_support.h"				/* Used for error support */
#include "topo_discovery.h"


/* Define this variable when FEC must be disabled */
/* By default, FECshould be used */
/*#define	NO_FEC  1*/

/* Define this variable when DIRECT_SEQUENCE is used for IEEE interference */
/* By default, frequency hopping is used */
#define	DIRECT_SEQUENCE


/* Define the different types of BER distribution */
/*	BER_DIST_SIMPLE,			Use the BER value as is */
/*	BER_DIST_DOUBLE,			Double the BER value every 300 bytes */
/*	BER_DIST_MARKOV,			Use a 2 state (Error Free/Error) markov machine */
/*	BER_DIST_EXPONENTIAL			Use Markov + an exp distrib with mean of the BER value */
/*	BER_DIST_COLLISION			Use Markov + packet length dependent probability to switch */
/*	BER_DIST_COLLISION_EXPONENTIAL		Use Markov + packet length dependent probability to switch */
enum ber_dist_code
{
	BER_DIST_SIMPLE,
	BER_DIST_DOUBLE,
	BER_DIST_MARKOV,
	BER_DIST_EXPONENTIAL,
	BER_DIST_COLLISION,
	BER_DIST_COLLISION_EXPONENTIAL
};

/* Define the format of the parameter input string for the distribution */
#define	BER_DIST_FMT_SIMPLE			"simple"
#define	BER_DIST_FMT_DOUBLE			"double_ber"
#define	BER_DIST_FMT_MARKOV			"markov"
#define	BER_DIST_FMT_EXPONENTIAL		"exponential"
#define	BER_DIST_FMT_COLLISION			"collision"
#define	BER_DIST_FMT_COLLISION_EXPONENTIAL	"collision_exp"

/* Define the different type of Error position */
/*	BER_ERR_RANDOM,				Use randomly chose position inside the packet */
/*	BER_ERR_CONSECUTIVE			Use consecutive errors inside the packet */
/*	BER_ERR_BIT_PROBABILITY			Use a probability for each bit of the packet */ 
enum ber_err_pos
{
	BER_ERR_RANDOM,
	BER_ERR_CONSECUTIVE,
	BER_ERR_BIT_PROBABILITY
};

/* Define the format of the parameter input string */
#define	BER_ERR_FMT_RANDOM		"random"
#define	BER_ERR_FMT_CONSECUTIVE		"consecutive"
#define	BER_ERR_FMT_BIT_PROBABILITY	"bit_probability"

/* Define some constant */
#define	ACCESS_CODE_SIZE		72	/* A bluetooth access code is 72 bits */
#define	HEADER_SIZE			126	/* A bluetooth header is 126 bits long */
#define	SYNC				4	/* Synchronization word befor the Access Code */
#define	TRAILER				68	/* Position of the trailer inside the access code */
#define	MAX_ACCESS_CODE_ERRS		6	/* Number of recoverable errors in the access code */

/* Define function prototypes */
#define pk_newtable(a)  (char*)op_prg_mem_alloc(a*sizeof(int))
Boolean accept_decision (Packet * pkptr,int *pos, int num_errors,double type_of_packet);

/* Markov probabilities */
#define	ERROR_STATE		OPC_FALSE	/* Define the error state */
#define ERROR_FREE_STATE	OPC_TRUE	/* Define the error free state */
/*static	double			pge;		/ Error to Error Free Probability */
/*static	double			peg;		/ Error Free to Error Probability */
/*static	Boolean			state = ERROR_FREE_STATE;/ Keep track of the current state */
 

/* Define the packet length for IEEE 802.11 stations */
#define	TB				pkt_length/bt_bit_rate
#define	TBi				bt_get_number_of_ts_from_type(type)*TS
#define	TW				8000/wlan_bit_rate
#define	TWi				TW+0.001802


#if defined (__cplusplus)
extern "C"
#endif

/* prototype of function */
void	wlan_bt_ecc (Packet *pkptr, int *pos, int num_errs, double type_of_packet);
Boolean  accept_decision(Packet * pkptr, int *pos, int num_errors,double type_of_packet);


#endif /* __WLAN_BT_ECC_H__ */
