/* Process model C form file: w_bt_chan_phy.pr.c */
/* Portions of this file copyright 1992-2002 by OPNET Technologies, Inc. */



/* This variable carries the header into the object file */
static const char w_bt_chan_phy_pr_c [] = "MIL_3_Tfile_Hdr_ 81A 30A modeler 7 3E25C79E 3E25C79E 1 skydiver rebala 0 0 none none 0 0 none 0 0 0 0 0 0                                                                                                                                                                                                                                                                                                                                                                                                                      ";
#include <string.h>



/* OPNET system definitions */
#include <opnet.h>

#if defined (__cplusplus)
extern "C" {
#endif
FSM_EXT_DECS
#if defined (__cplusplus)
} /* end of 'extern "C"' */
#endif


/* Header Block */

/*
** $RCSfile:
**
** Bluetooth model in Opnet
** National Institute of Standards and Technology
**
** This model was developed at the National Institute of Standards
** and Technology by employees of the Federal Government in the course
** of their official duties. Pursuant to title 17 Section 105 of the
** United States Code this software is not subject to copyright
** protection and is in the public domain. This is an experimental
** system.  NIST assumes no responsibility whatsoever for its use by
** other parties, and makes no guarantees, expressed or implied,
** about its quality, reliability, or any other characteristic.
**
** We would appreciate acknowledgement if the model is used.
**
** NIST ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION
** AND DISCLAIM ANY LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER
** RESULTING FROM THE USE OF THIS SOFTWARE.
**
** Primary Author:      $Author
** Module description:  Physical Channel Emulator
** Last Modification:   $Id:
*/
/* Standard Includes */
#include "bt_support.h"
#include "topo_discovery.h"
#include "fifo_support.h"
#include "l2cap_support.h"
#include "collision_utilities.h"
#include "wlan_bt_ecc.h"
#include <math.h>
#include "physic.h"
/* Definitions to all protocol specific parameters*/
#include "bt_wlan_support.h"

/* Interrupt code for channel */
#define INTRPT_CODE_CHANNEL		0

/* End of initialize */
#define END_INIT			(op_intrpt_code() == INTRPT_CODE_CHANNEL)

/* Transition macros */
#define PACKET_TO_TRANSMIT	( (op_intrpt_type () == OPC_INTRPT_SELF) && (op_intrpt_code () != 0) )
#define PACKET_TO_RECEIVE	(op_intrpt_type () == OPC_INTRPT_STRM)

/*operation macro*/
#ifndef			max
#define			max(a,b)				(a>b)?a:b
#endif
#ifndef			min
#define	        min(a,b)                (a>b)?b:a
#endif

/* stream wire*/
#define		LOW_LAYER_INPUT_STREAM_CH4		3

/* Define some constants */
#define     BT 			    1.0

#define     MAX_COLLISIONS   1250
/*flag for reception*/
#define     RECEPTION_ON   	100
#define     RECEPTION_OFF   101

#define     MAX_ERROR_TO_CORRECT   35  /* Maximum of errors that we can correct */


/*define a Macro for the end of simulation*/
#define SIM_END					( op_intrpt_type() == OPC_INTRPT_ENDSIM )
#define SIM_BEGIN				1

#define RANGE_OF_TIME           ( (op_sim_time() > 5.0) && (op_sim_time() < 5.05) )

/*to recognize the wlan packet*/
typedef enum WlanT_Mac_Frame_Type
	{
	WlanC_Rts  = 0x6C, /* Rts code set into the Rts control frame */
	WlanC_Cts  = 0x70, /* Cts code set into the Cts control frame */
   	WlanC_Ack  = 0x74, /* Ack code set into the Ack control frame */
   	WlanC_Data = 0x80, /* Data code set into the Data frame       */
   	WlanC_None = 0x00  /* None type 							  */
	} WlanT_Mac_Frame_Type;

typedef enum
{
	BLUETOOTH_SUBQ,
	WLAN_SUBQ
} Channel_Subq;


typedef struct
{
	Packet *pkptr;
	int		piconet;
} Packet_elt;

Channel_buffer *	channel_buffer[MAX_COLLISIONS];
double  			ch_drate;
double  			time_interval;
double  			simulation_time;
char *				start_packet;
char *				final_packet;

int      *pos;                     		  /*a Pointer to store the errors positions*/
int       num_packet ;                    /* gives the number of the packet which is being proceeced */
physical_layer  phy;                      /*to initialize the physical layer*/
int       bt_ber = 0;                     /*Bit error rate for bt */
int       wlan_ber = 0;                   /*Bit error rate for wlan */
int       bt_num_bits;                    /*the size of the BT packet in bits*/
int       wlan_num_bits;                    /*the size of the WLAN packet in bits*/
double    freq_transmission;              /*th frequency of transmission extracted from the pcket*/
int       bt_packet_number;               /*the number of bluetooth packet passed through the channel*/ 
int       wlan_packet_number;             /*the number of wlan packet passed through the channel*/ 
int       bt_collision_number;            /*the number of collisions for the bt packets*/
int       wlan_collision_number;          /*the number of collisions for the wlan packets*/
int       a;                              /*variable for fiilling randomly the packet*/
WlanT_Mac_Frame_Type   type_of_packet;    /*variable to store the type of the packet*/
double power;							  /*varaible to stock the power of the transmitter*/

/*variables for receivers and transmitters location*/
double	tx_x, tx_y, tx_z, rx_x, rx_y, rx_z;
double	dif_x, dif_y, dif_z, dot_rx_dif;
double	distance;
double	wlan_report_table[2][MAX_ERROR_TO_CORRECT];
double *bt_report_table[2][MAX_ERROR_TO_CORRECT];
int		size_packet;
int		num_errs;
int		test;

/*used to collect information (power)*/
double slave_power_test;
double master_power_test = 1.0;

/* List to store the packet */
List	*Channel_list;

/* Declare functions */
static void		bt_phy_channel_init ();
static void		wlan_bt_channel_interference (Packet * pkptr);
static void		bt_channel_pk_send ();
static int      compute_propagation_time (Packet * pkptr);
static void     construct_interference_ptr (Packet * pkptr, double type);
static void 	overlap (double interference_ptr_tmp[2][MAX_COLLISIONS], int size, int *result);
static void 	sort_interference (double interference_ptr_tmp[2][MAX_COLLISIONS], int size);
static void 	switch_element (double interference_ptr_tmp[2][MAX_COLLISIONS], int first_index, int second_index);
static void		channel_end_of_simulation ();
static void		channel_pkt_enqueue (Packet *pkptr, int piconet);
static Packet *	channel_pkt_dequeue (int piconet_number);
static void     print_interference_ptr (int packet_number, Boolean interference);
static void		bt_print_report_channel (const char * filename, const char * line1, const char * line2);
static void		bt_debug_log_file ();


/* End of Header Block */


#if !defined (VOSD_NO_FIN)
#undef	BIN
#undef	BOUT
#define	BIN		FIN_LOCAL_FIELD(last_line_passed) = __LINE__ - _block_origin;
#define	BOUT	BIN
#define	BINIT	FIN_LOCAL_FIELD(last_line_passed) = 0; _block_origin = __LINE__;
#else
#define	BINIT
#endif /* #if !defined (VOSD_NO_FIN) */



/* State variable definitions */
typedef struct
	{
	/* Internal state tracking for FSM */
	FSM_SYS_STATE
	/* State Variables */
	Objid	                  		channel_objid;
	int	                    		nb_pkt_on_channel;
	Packet *	               		previous_pkptr;
	List *	                 		device_list_ptr;
	Packet *	               		current_pkptr;
	double	                 		previous_arrival_time;
	double	                 		current_arrival_time;
	int	                    		num_collisions;
	int	                    		freq_collision_num;
	Stathandle	             		slave_power_stat;
	Stathandle	             		master_power_stat;
	Stathandle	             		master_ber_stat;
	Stathandle	             		slave_ber_stat;
	float	                  		slave_average_ber;
	float	                  		master_average_ber;
	double	                 		master_power_curve;
	double	                 		slave_power_curve;
	int	                    		debug_flag;
	int	                    		intrpt_type;
	int	                    		intrpt_strm;
	int	                    		intrpt_code;
	FILE *	                 		log_file_ptr;
	} w_bt_chan_phy_state;

#define pr_state_ptr            		((w_bt_chan_phy_state*) SimI_Mod_State_Ptr)
#define channel_objid           		pr_state_ptr->channel_objid
#define nb_pkt_on_channel       		pr_state_ptr->nb_pkt_on_channel
#define previous_pkptr          		pr_state_ptr->previous_pkptr
#define device_list_ptr         		pr_state_ptr->device_list_ptr
#define current_pkptr           		pr_state_ptr->current_pkptr
#define previous_arrival_time   		pr_state_ptr->previous_arrival_time
#define current_arrival_time    		pr_state_ptr->current_arrival_time
#define num_collisions          		pr_state_ptr->num_collisions
#define freq_collision_num      		pr_state_ptr->freq_collision_num
#define slave_power_stat        		pr_state_ptr->slave_power_stat
#define master_power_stat       		pr_state_ptr->master_power_stat
#define master_ber_stat         		pr_state_ptr->master_ber_stat
#define slave_ber_stat          		pr_state_ptr->slave_ber_stat
#define slave_average_ber       		pr_state_ptr->slave_average_ber
#define master_average_ber      		pr_state_ptr->master_average_ber
#define master_power_curve      		pr_state_ptr->master_power_curve
#define slave_power_curve       		pr_state_ptr->slave_power_curve
#define debug_flag              		pr_state_ptr->debug_flag
#define intrpt_type             		pr_state_ptr->intrpt_type
#define intrpt_strm             		pr_state_ptr->intrpt_strm
#define intrpt_code             		pr_state_ptr->intrpt_code
#define log_file_ptr            		pr_state_ptr->log_file_ptr

/* This macro definition will define a local variable called	*/
/* "op_sv_ptr" in each function containing a FIN statement.	*/
/* This variable points to the state variable data structure,	*/
/* and can be used from a C debugger to display their values.	*/
#undef FIN_PREAMBLE
#define FIN_PREAMBLE	w_bt_chan_phy_state *op_sv_ptr = pr_state_ptr;


/* Function Block */

enum { _block_origin = __LINE__ };
/*
 * $Function:		bt_phy_channel_init
 * $Description:	PHY Initialization procedure
 *					Initialize state variables
 *					Read model attribute values in
 *					 variables
 *					Discover the topology
 */

static void bt_phy_channel_init ()
	{
	int j,i,k;
	
	FIN (bt_phy_channel_init ());
		
	/* Get the objid of the process */
	channel_objid = op_id_self ();
		
	/* Get the debug attribute and message print */
	op_ima_obj_attr_get (channel_objid, "Debug flag", &debug_flag);
	op_ima_obj_attr_get (channel_objid, "Message print", &bt_message_print);
	
   	
	/* Initialize some variables */
	nb_pkt_on_channel = -1;		/* No previous packets on the PHY channel */
	previous_pkptr = OPC_NIL;	/* Keep track of the previous packet on the channel */
	interference_ptr = NULL;
	pos = NULL;
	num_packet = 0;
	bt_num_bits = 0;
	wlan_num_bits = 0;
	bt_packet_number = 0;
	wlan_packet_number = 0;
	wlan_collision_number = 0;
	bt_collision_number = 0;
	test = 0;
	master_power_curve = slave_power_curve = 1.0;

	
	/* In our case it is probably better for the previous_pkptr */
	/* to build a list of packets present at that time over the RF */
	/* see topo_discovery module in order to see the creation and */
	/* use of a list in Opnet */

	init_topo_discovery ();		/* Initialize structures for topology discovery */
	topo_channel_registration (channel_objid);	/* Register this process */

	/* Initialize channel list */
	Channel_list = op_prg_list_create ();
	
	/*Initialize structures for the physical layer*/
	printf("I initialize the physical layer... \n");
	initialize_physical_layer(&phy,MAX_COLLISIONS);
	
	
	//Stat handle initialization
	slave_power_stat = op_stat_reg("Slave Power",OPC_STAT_INDEX_NONE,OPC_STAT_LOCAL);
	slave_ber_stat = op_stat_reg("Slave BER",OPC_STAT_INDEX_NONE,OPC_STAT_LOCAL);
	master_power_stat = op_stat_reg("Master Power",OPC_STAT_INDEX_NONE,OPC_STAT_LOCAL);	
	master_ber_stat = op_stat_reg("Master BER",OPC_STAT_INDEX_NONE,OPC_STAT_LOCAL);

	
	for( i = 0 ; i < 2 ; i++ )
		{
		for( j = 0 ; j < MAX_ERROR_TO_CORRECT ; j++ )
			wlan_report_table[i][j] = 0 ;
		}
	
	
	
	
	/* Allocate some memory */
	for (i=0; i<MAX_COLLISIONS; i++)
		channel_buffer[i] = (Channel_buffer *) op_prg_mem_alloc (sizeof(Channel_buffer));
		
	
	/* Set some priorities in case a Bluetooth packet and a WLan packet need to be send */
	/* at the same simulation time */
    op_intrpt_priority_set (OPC_INTRPT_STRM, BLUETOOTH_INPUT_STREAM, 10);
    op_intrpt_priority_set (OPC_INTRPT_STRM, WLAN_INPUT_STREAM, 5);
	/* Print some information concerning this process */
	printf ("\n|-----------------------------------------------------------------------------|\n");
	printf ("| Simulation Info:\tbt_channel\n");
	printf ("| Parameters:\t\t\n");
	printf ("|-----------------------------------------------------------------------------|\n");
	
	/* init the log file pointer to NULL */
	log_file_ptr = NULL;
	
	FOUT;
	}

/*
 * $Function:		bt_phy_channel_init2
 * $Description:	PHY Initialization procedure
 *					Initialize state variables
 *					Read model attribute values in
 *					 variables
 *					when the topology is known
 */

static void bt_phy_channel_init2 ()
	{
	int i,j,k; // loop variables
	
	
	FIN ( bt_phy_channel_init2 () );
	
	number_of_piconet = topo_get_number_of_piconet ();
	
	printf ("number of piconet: %d\n", number_of_piconet);
	printf ("number of wlan: %d\n", number_of_wlan);
	
	/* Last initialization */
	for( i = 0 ; i < 2 ; i++ )
		{
		for( j = 0 ; j < MAX_ERROR_TO_CORRECT ; j++ )
			{
			bt_report_table[i][j] = (double *) op_prg_mem_alloc (number_of_piconet * sizeof(double));
			
			for (k=0; k<number_of_piconet; k++)
				bt_report_table[i][j][k] = 0.0;
			}
		}
	
	/* get the MAC Objid of each slave in the topology */
	topo_register_slave_id ();
	
	/* init the bt support */
	bt_init_bt_support ();
	
	/* Init the queue in l2cap_support */
	l2cap_init_support ();
		
	topo_print_wlan_list ();
	
	/* 
	 * The init of the channel is done
	 * We generate the interupts for the master clock of each piconet
	 */
	for (i=0; i<number_of_piconet; i++)
		op_intrpt_schedule_remote (op_sim_time() + i*TIME_SHIFT, MASTER_CLK_TIMER, topo_get_master_device (i)->mac_objid);
	
	FOUT;
	}


/*
 * $Function:		wlan_bt_channel_interference
 * $Description:	Reception of a packet from the
 *					devices. Calculate the interference
 *					over the previous packet and update
 *					some of the variables
 * $Input:			Packet * : pkptr
 *					The incoming packet
 */

static void wlan_bt_channel_interference (Packet * pkptr)	
	{
	char			fmt[256];
	double			next_creation_time;
	double          propagation_time;
	int				piconet_number;
	int				intrpt_code_channel;

	
	FIN (wlan_bt_channel_interference (pkptr));
		
	if (debug_flag == OPC_BOOLINT_ENABLED)
		bt_print_debug ("Channel function block : wlan_bt_channel_interference (pkptr)");

	
	/* The incoming packet has been queue in the corresponding subqueue */
	/* The PHY interference function need to be called on the previous */
	/* packet that is currently send over the RF. The information on the */
	/* packet can be found in the "previous_pkptr" variable */

	/* Once the PHY interference function call is done, operate an error */
	/* calculation and error correction on the previous_pkptr packet over */
	/* the current number of collided bits (basically apply the pk_scrambler */
	/* function from the bt_ecc module, but modify the function to accept a bit */
	/* start and a length instead of applying the function over the entire packet */
	/* length */

	/* A new packet has come and start to be present on the channel, we need to */
	/* add one to the number of packets present on the channel at this time */
	/* Add the new packet to the list of packets present over the RF at that time */
	/* The next part generates a self-interrupt on this process in order to deliver */
	/* the incomming packet to the destination process */
	/* Get some information on the incoming packet */
	
	op_pk_format (pkptr, fmt);						/* Get the packet format */
	op_pk_nfd_get(pkptr, "piconet", &piconet_number); /* Get the number of the current piconet */
	
	/* Compute the interrupt self code */
	intrpt_code_channel = piconet_number + 1;
	
	/* From the packet format, we need to determine if it is a Bluetooth or */
	/* Wlan packet.  */
	if ( (strcmp(fmt, BLUETOOTH_PKT_DM1) != 0) && 
		(strcmp(fmt, BLUETOOTH_PKT_DM3) != 0) &&
		(strcmp(fmt, BLUETOOTH_PKT_DM5) != 0) &&
		(strcmp(fmt, BLUETOOTH_PKT_DH1) != 0) && 
		(strcmp(fmt, BLUETOOTH_PKT_DH3) != 0) &&
		(strcmp(fmt, BLUETOOTH_PKT_DH5) != 0) &&
		(strcmp(fmt, BLUETOOTH_PKT_HV1) != 0) &&
		(strcmp(fmt, BLUETOOTH_PKT_HV2) != 0) &&
		(strcmp(fmt, BLUETOOTH_PKT_HV3) != 0) &&
		(strcmp(fmt, BLUETOOTH_PKT_POLL) != 0) &&
		(strcmp(fmt, BLUETOOTH_PKT_NULL) != 0) )
		{
		/* IN case the packet is a WLAN packet */
		op_pk_nfd_access(pkptr,"Type",&type_of_packet);
		/* Get the correct interrupt code for the wlan */
		intrpt_code_channel += number_of_piconet;
		
		if(  type_of_packet == WlanC_Data )
			{
			if (Phy_Char == DS)
				next_creation_time = ((double)op_pk_total_size_get(pkptr))/ wlan_bit_rate  +  192.0/1000000.0;
			else if (Phy_Char == FH)
				next_creation_time = ((double)op_pk_total_size_get(pkptr) + 128.0)/ wlan_bit_rate;
			
			/*next_creation_time = ((double)op_pk_total_size_get(pkptr) - 224.0)/ wlan_bit_rate  +  224.0/1000000.0;*/
			
			propagation_time = compute_propagation_time(pkptr);
			bt_generate_next_self_event(op_sim_time() + next_creation_time + propagation_time, intrpt_code_channel);
			wlan_packet_delivery[piconet_number] = OPC_TRUE;
			}
		else
			{
			if (Phy_Char == DS)
				next_creation_time = (op_pk_total_size_get(pkptr)+192.0) / 1000000.0;
			else if (Phy_Char == FH)
				next_creation_time = ((double)op_pk_total_size_get(pkptr) + 128.0)/ 1000000.0;
			
			/*next_creation_time = (double)op_pk_total_size_get(pkptr) / 1000000.0;*/
			
			propagation_time = compute_propagation_time(pkptr);
			bt_generate_next_self_event(op_sim_time() + next_creation_time + propagation_time, intrpt_code_channel);
			wlan_packet_delivery[piconet_number] = OPC_TRUE;
			}
	}
	else	
		{
		/* IN case the packet is a BT*/
		/* Program a self interrupt in order to send the packet to the other side device */
		
		next_creation_time = op_pk_total_size_get(pkptr)/ bt_bit_rate  ;
		propagation_time = compute_propagation_time(pkptr);
  		bt_generate_next_self_event(op_sim_time() + next_creation_time + propagation_time, intrpt_code_channel); 
				
		/* Set the packet delivery BUSY signal in all the bluetooth devices */
		bluetooth_packet_delivery[piconet_number] = OPC_TRUE;
		}

	FOUT;
	}

/*
 * $Function:		bt_channel_pk_send
 * $Description:	Dispatch a packet to other stations
 */

static void bt_channel_pk_send ()
{	
	Packet*						pkptr;
	int					  		dest_addr;
	int             	   		dest_addr_wlan;
	int				         	way, i,j;
	Slave_Device*				tmp_ptr;
	WlanT_Data_Header_Fields*	pk_dhstruct_ptr;
	int 					  	size_packet;
	int                      	num_errs;
	int						 	piconet_number;	 
	double						type_of_packet;
	
	const int					bypass = 0;
	const int					realDSP = 1;
	
	/* the ber compute for each packet */
	double ber_per_packet;
	
	
	FIN (bt_channel_pk_send ());

	if (debug_flag == OPC_BOOLINT_ENABLED)
		bt_print_debug ("Channel function block : bt_channel_pk_send ()");
	
	simulation_time = op_sim_time();
	if ( (pkptr = channel_pkt_dequeue (intrpt_code - 1)) == OPC_NIL)
		op_sim_end("PHY Channel Error", "Can't retreive packet information","Bluetooth Queue is empty", "");
	
	for (i=0; i<MAX_COLLISIONS; i++)
		{
		if(op_pk_id(pkptr) == channel_buffer[i]->pkt_id)
			{
			type_of_packet = channel_buffer[i]->type;
			break;
			}
		}
	
	/* From the type of the packet, determine if the packet is comming on a BLUETOOTH_INPUT_STREAM */
	/* or a WLAN_INPUT_STREAM. This is useful in order to dequeue the packet from the good subqueue */
	
	if (type_of_packet == BT)
		{		
		/* The PHY interference function need to be called on the packet that has just */
		/* been dequeued from the subqueue. The information on the packet can be found */
		/* in the "pkptr" variable */
		
		/* Once the PHY interference function call is done, operate an error */
		/* calculation and error correction on the "pkptr" packet over */
		/* the current number of collided bits (from the last processed collision */
		/* until the total length of the packet */
		
		/* A packet is just beeing send, we have to remove one from the number of packets */
		/* present over the RF from now on */
		/* Remove also the packet from the previous packet list. The packet is no longer */
		/* present in the Channel */
		
		/* WARNING  WARNING  WARNING WARNING WARNING WARNING WARNING WARNING WARNING  WARNING */
		/* The bt_ecc call here is just for test only. It has been put here for test  purpose */
		/* in order to see if the results we can get from the PHY Channel process matches the */
		/* results from before using the RX/TX pair */
		
		//bt_ecc(pkptr);

		/* This function call need to be removed when implementing the real PHY interference */
		/* generation function */
		/* WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING */

		
		/* Get some packet information */
		size_packet = op_pk_total_size_get(pkptr);				
		op_pk_nfd_get(pkptr, "AM_ADDR", &dest_addr);
		op_pk_nfd_get(pkptr, "Way", &way);
		
		/*get the number of piconet*/
		op_pk_nfd_get(pkptr, "piconet", &piconet_number);
		
		/* Forward the packet to the destination now */
		switch (way)
			{
			case MASTER_TO_SLAVE:
			if (debug_flag == OPC_BOOLINT_ENABLED)
				bt_print_debug ("case master to slave");
			
			switch (dest_addr)
				{
				case AM_ADDR_BROADCAST:	/* Broadcast Packet */
					/* Send the packet to any destination in the topology */
					for (i=0; i<NUMBER_OF_ACTIVE_STATIONS; i++)
						{
						if ( (tmp_ptr = topo_get_slave_device_from_address (i, piconet_number)) != OPC_NIL )
							{
							/* modif .Issam.E 10/05/2000*/
							
							/*to fill the pointer which will bw given to the physical layer in */
							/*order to compute the errors due to interferences and propagation */
							construct_interference_ptr (pkptr, BT);
							if (bt_message_print) printf ("| \tthe number of collisions = %d \n", num_collisions);
							
							/*construct the packets that will be given to the physical layer, */
							/*than we will compute the errors by comparing the bits flipped to the starting bitd*/
							start_packet = (char *) op_prg_mem_alloc ( size_packet * sizeof(char) );
							final_packet = (char *) op_prg_mem_alloc ( size_packet * sizeof(char) );
							
							/*to fill randomly the packet by zeros and ones*/
							for(i = 0 ; i < size_packet ; i++)
								{
								a = rand();
								start_packet[i] = a%2;
								final_packet[i] = a%2;
								}	
							
							/*call the physical layer*/
							if (test)
								Wlan_bt_collision (&phy, final_packet, interference_ptr, num_collisions, realDSP);
							else
								Wlan_bt_collision (&phy, final_packet, interference_ptr, num_collisions, bypass);

							/*compute the errors by comparing*/
							num_errs = compute_errors_number(start_packet, final_packet, size_packet);
			 
							if( num_collisions && num_errs )
								bt_collision_number++;

							/*fill up the report table*/
							if ( num_collisions < MAX_ERROR_TO_CORRECT )
								{
								freq_collision_num = num_collisions;
								for(j = 0; j <= num_collisions ; j++ )
									{
									if ( (interference_ptr[4][j] - interference_ptr[4][0]) > 5 )
										freq_collision_num--;
									}
								bt_report_table[0][freq_collision_num][piconet_number] += 1 ;
								bt_report_table[1][freq_collision_num][piconet_number] += num_errs ;
								}
							else
								{
								printf("\n|-----------------------------------------\n");
								printf("| \t\terror : num_collisions > 35\n");
								printf("|-----------------------------------------\n");
								}
							
							/* to compute the ber*/
							bt_ber = bt_ber + num_errs;
							ber_per_packet = (float)num_errs / size_packet;							
							if (bt_message_print) printf("| \tThe ber_per_packet is %e \n",ber_per_packet);
						 
							op_pk_nfd_get( pkptr,"power",&master_power_curve);
							
							op_stat_write(master_power_stat,(float)master_power_curve);
							
							/*this pointer is usefull for the FEC, it will be passed to the function */
							/*which manage the FEC, it gives the positions of the errors*/
							
							if (num_errs)
								{
								pos = (int *) op_prg_mem_alloc ( num_errs * sizeof(int) );
								pos = errors_position (pos, start_packet, final_packet, size_packet, num_errs);
								wlan_bt_ecc (pkptr, pos, num_errs, BT);
								op_prg_mem_free (pos); /* free memory */
								pos = NULL;
								}
							else
								wlan_bt_ecc (pkptr, pos, num_errs, BT);
								
							
							/*to free memory*/
							op_prg_mem_free (interference_ptr);
							op_prg_mem_free (start_packet);
							op_prg_mem_free (final_packet);
							}
						
						op_pk_deliver (pkptr, tmp_ptr->mac_address, LOWER_LAYER_INPUT_STREAM);
						}
				break;
				
				default:				/* Any other slave */
					/* Send the packet directly to the concerned node */
					/* modif .Issam.E 10/05/2000 */
					{
					construct_interference_ptr (pkptr, BT);
					if (bt_message_print) printf ("| \tThe number of collisions = %d \n", num_collisions);					
					
					start_packet = (char*)op_prg_mem_alloc( size_packet * sizeof(char) );
					final_packet = (char*)op_prg_mem_alloc( size_packet * sizeof(char) );

					for(i = 0 ; i < size_packet ; i++)
						{
						a = rand();
						start_packet[i] = a%2 ;
						final_packet[i] = a%2 ;
						}	
					

					if (test)
						Wlan_bt_collision (&phy, final_packet, interference_ptr, num_collisions, realDSP);
					else
						Wlan_bt_collision (&phy, final_packet, interference_ptr, num_collisions, bypass);

					num_errs = compute_errors_number (start_packet, final_packet, size_packet);
					
					if( num_collisions && num_errs )
						bt_collision_number++;
					
					if ( num_collisions < MAX_ERROR_TO_CORRECT )
						{
						freq_collision_num = num_collisions;
						for( j = 0; j < num_collisions ; j++ )
							{
							if ( (interference_ptr[4][j] - interference_ptr[4][0]) > 5 )
								freq_collision_num--;
							}
						bt_report_table[0][freq_collision_num][piconet_number] += 1;
						bt_report_table[1][freq_collision_num][piconet_number] += num_errs;
						}
					else
						{
						printf("\n|-----------------------------------------\n");
						printf("| \t\terror : num_collisions > 35\n");
						printf("|-----------------------------------------\n");
						}
				
					/* to compute the ber*/
					bt_ber = bt_ber + num_errs;
					ber_per_packet = (float)num_errs / size_packet;
					
					if (bt_message_print)
						{
						printf("\n|================================================\n");
						printf("| num_errs is %d \n",num_errs);
						printf("| size_packet is %d \n",size_packet);
						printf("| the ber_per_packet is %e\n",ber_per_packet);					
						printf("|================================================\n");
						}
					
					op_pk_nfd_get( pkptr,"power",&master_power_curve);
					
					op_stat_write(master_power_stat,(float)master_power_curve);
															
					if (num_errs)
						{
						pos = (int *) op_prg_mem_alloc ( num_errs * sizeof(int) );
						pos = errors_position(pos,start_packet,final_packet,size_packet,num_errs);
						wlan_bt_ecc (pkptr, pos, num_errs,BT);	
						op_prg_mem_free(pos); /* free memory */
						pos = NULL;
						}
					else
						wlan_bt_ecc (pkptr, pos, num_errs,BT);
															
					/*to free memory*/
					op_prg_mem_free(interference_ptr);
					op_prg_mem_free(start_packet);
					op_prg_mem_free(final_packet);					
					
					/*printf ("********* mac_objid of slave = %d\n",
						topo_get_slave_device_from_address(dest_addr, piconet_number)->mac_objid);*/
					op_pk_deliver (pkptr, topo_get_slave_device_from_address(dest_addr, piconet_number)->mac_objid, LOWER_LAYER_INPUT_STREAM);
					break;
					}
				}
				break;
				case SLAVE_TO_MASTER:		/* In case of an answer to the master */
					/* Forward the packet to the master of the piconet */
				/* modif .Issam.E 10/05/2000 */
					{
					if (debug_flag == OPC_BOOLINT_ENABLED)
						bt_print_debug ("case slave to master");
					
					construct_interference_ptr (pkptr, BT);
					if (bt_message_print) printf ("| \tThe number of collisions = %d \n", num_collisions);
					
					start_packet = (char *) op_prg_mem_alloc ( size_packet * sizeof(char) );
					final_packet = (char *) op_prg_mem_alloc ( size_packet * sizeof(char) );
					for(i = 0 ; i < size_packet ; i++)
						{
						a = rand ();
						start_packet[i] = a%2 ;
						final_packet[i] = a%2 ;
						}	

					if (test)
						Wlan_bt_collision (&phy, final_packet, interference_ptr, num_collisions, realDSP);
					else
						Wlan_bt_collision (&phy, final_packet, interference_ptr, num_collisions, bypass);

					num_errs = compute_errors_number (start_packet, final_packet, size_packet);

					if( num_collisions && num_errs )
						bt_collision_number++;

					/* to compute the ber*/
					if ( num_collisions < MAX_ERROR_TO_CORRECT )
						{
						freq_collision_num = num_collisions;
						for(j = 0; j < num_collisions ; j++ )
							{
							if ( (interference_ptr[4][j] - interference_ptr[4][0]) > 5 )
								freq_collision_num--;
							}
						bt_report_table[0][freq_collision_num][piconet_number] += 1 ;
						bt_report_table[1][freq_collision_num][piconet_number] += num_errs ;
						}
					else
						{
						printf("\n|-----------------------------------------\n");
						printf("| \t\terror : num_collisions > 35\n");
						printf("|-----------------------------------------\n");
						}
					
					bt_ber = bt_ber + num_errs;
					ber_per_packet = (float)num_errs / (float)size_packet;

					if (bt_message_print)
						{
						printf("\n|================================================\n");					
						printf("| num_errs is %d \n",num_errs);
						printf("| size_packet is %d \n",size_packet);
						printf("| the ber_per_packet is %e\n",ber_per_packet);
						printf("|================================================\n");
						}
					
					op_pk_nfd_get( pkptr,"power",&slave_power_curve);
					op_stat_write(slave_power_stat,(float)slave_power_curve);
											
					if (num_errs)
						{
						pos = (int *) op_prg_mem_alloc ( num_errs * sizeof(int) );
						pos = errors_position (pos, start_packet, final_packet, size_packet, num_errs);
						wlan_bt_ecc (pkptr, pos, num_errs, BT);
						op_prg_mem_free (pos); /* free memory */
						pos = NULL;
						}
					else
						wlan_bt_ecc (pkptr, pos, num_errs, BT);
					
					/*to free memory*/
					op_prg_mem_free(interference_ptr);
					op_prg_mem_free(start_packet);
					op_prg_mem_free(final_packet);
 					
					op_pk_deliver(pkptr, topo_get_master_device(piconet_number)->mac_objid, LOWER_LAYER_INPUT_STREAM);
					break;
					}
				}	
		
		/* Set the packet delivery flag to Idle for all the bluetooth devices */
		bluetooth_packet_delivery[piconet_number] = OPC_FALSE;
		}
	else
		{ /* the other case is WLAN */
			if (debug_flag == OPC_BOOLINT_ENABLED)
				bt_print_debug("case Wlan");
			
			/*get some information about the paquet*/
			op_pk_nfd_access (pkptr, "Wlan Header",	&pk_dhstruct_ptr);
			dest_addr_wlan = pk_dhstruct_ptr->address1;
			
			op_pk_nfd_get (pkptr, "piconet", &piconet_number);
			
			/********************************** Issam by the 12/14/2000 ******************************/
			construct_interference_ptr (pkptr, WLAN);
			if (bt_message_print) printf ("| \tThe number of collisions = %d \n", num_collisions);
			
			size_packet = op_pk_total_size_get(pkptr);
			
			if (Phy_Char == FH)
				size_packet += 128;
			else if (Phy_Char == DS)
				size_packet += 192;
			
			start_packet = (char*) op_prg_mem_alloc( size_packet * sizeof(char) );
			final_packet = (char*) op_prg_mem_alloc( size_packet * sizeof(char) );
			
			for(i = 0 ; i < size_packet ; i++)
				{
				a = rand();
				start_packet[i] = a%2 ;
				final_packet[i] = a%2 ;
				}
						
			if ( Phy_Char == FH )
				{
				if (test)
					Bt_WlanFH1_collision (&phy, final_packet, interference_ptr, num_collisions, realDSP);
				else
					Bt_WlanFH1_collision (&phy, final_packet, interference_ptr, num_collisions, bypass);					
				}
			
			if ( Phy_Char == DS )
				{
				if ( wlan_bit_rate == 11000000 )
					{
					if (size_packet == 304)
						{
						if (test)
							Bt802_Wlan1_collision (&phy, final_packet, interference_ptr, num_collisions, realDSP);
						else
							Bt802_Wlan1_collision (&phy, final_packet, interference_ptr, num_collisions, bypass);
						}							
					else
						{
						if (test)
							Bt802_Wlan11_collision (&phy, final_packet, interference_ptr, num_collisions, realDSP);
						else
							Bt802_Wlan11_collision (&phy, final_packet, interference_ptr, num_collisions, bypass);
						}						
					}
				
				if ( wlan_bit_rate == 1000000 )
					{
					if (test)						
						Bt802_Wlan1_collision (&phy, final_packet, interference_ptr, num_collisions, realDSP);
					else
						Bt802_Wlan1_collision (&phy, final_packet, interference_ptr, num_collisions, bypass);
					}
				}
			
			num_errs = compute_errors_number (start_packet, final_packet, size_packet);

			if( num_collisions && num_errs )
				wlan_collision_number++;
			

			if ( num_collisions < MAX_ERROR_TO_CORRECT )
				{
				freq_collision_num = num_collisions;
				for(j = 0; j < num_collisions ; j++ )
					{
					if ( (interference_ptr[4][j] - interference_ptr[4][0])*(interference_ptr[4][j] - interference_ptr[4][0]) > 25 )
						freq_collision_num--;
					}
				wlan_report_table[0][freq_collision_num] += 1 ;
				wlan_report_table[1][freq_collision_num] += num_errs ;
				}
			else
				{
				printf("\n|-----------------------------------------\n");
				printf("| \t\terror : num_collisions > 35\n");
				printf("|-----------------------------------------\n");
				}

			/* to compute the ber*/
			wlan_ber = wlan_ber + num_errs;
			ber_per_packet = (float)num_errs / (float)size_packet;

			if (num_errs)
				{
				pos = (int *) op_prg_mem_alloc ( num_errs * sizeof(int) );
				pos = errors_position (pos, start_packet, final_packet, size_packet, num_errs);
				wlan_bt_ecc (pkptr, pos, num_errs, WLAN);
				op_prg_mem_free (pos);
				pos = NULL;
				}
			else
				wlan_bt_ecc (pkptr, pos, num_errs, WLAN);

			/*to free memory*/
			op_prg_mem_free (interference_ptr);
			op_prg_mem_free (start_packet);
			op_prg_mem_free (final_packet);
			
			/**************************************** end modif ************************************/
						
			/* folow the packet to the destination */
			op_pk_deliver (pkptr, topo_get_wlan_device_from_address(dest_addr_wlan)->mac_objid, LOW_LAYER_INPUT_STREAM_CH4);

			/*to schedule one remote interruption to inform the wlan device*/
			/*that that the reception has ended*/ 
			op_intrpt_schedule_remote (op_sim_time(),RECEPTION_OFF ,topo_get_wlan_device_from_address(dest_addr_wlan)->mac_objid );

			/*set this variable false for the new round*/
			
			wlan_packet_delivery[piconet_number] = OPC_FALSE;
		}
	
	FOUT;
	}


/*modif Issam.E 10/03/2000*/
/*
 *  Function : compute_propagation_time
 *
 *  Description : calculate the propagation time of the packet sent
 *
 *  $ParamIn : Packet * pkptr
 *             pointer to the current packet
 *
 *  $ParamOut : int d_time
 *              propagation time of the packet
 */

int compute_propagation_time(Packet * pkptr)
	{
	int d_time;
	FIN( compute_propagation_time(pkptr) );
	
	if (debug_flag == OPC_BOOLINT_ENABLED)
		bt_print_debug ("Channel function block : compute_propagation_time(pkptr)");
	
	/*to get the position of the receiver and transmitter*/
	op_pk_nfd_get(pkptr,"t_x",&tx_x );
	op_pk_nfd_get(pkptr,"t_y",&tx_y );
	op_pk_nfd_get(pkptr,"r_x",&rx_x );
	op_pk_nfd_get(pkptr,"r_y",&rx_y ); 

	/*then we compute the time that takes the propagation of the packet*/ 
	d_time = sqrt( (tx_x - rx_x)*(tx_x - rx_x) + (tx_y - rx_y)*(tx_y - rx_y) ) /  (3*100000000);

	FRET(d_time);
	}


/*modif Issam.E 10/07/2000*/
static void construct_interference_ptr( Packet *pkptr, double type)
{
	double	time_packet[MAX_COLLISIONS];
	/* table for registering the number of piconet for each interferences */
	/*int		piconet_number[NUMBER_OF_PICONET + NUMBER_OF_WLAN];*/
	int		j,l;
	int		current_index;
	int 	number_of_collisions;
	double	type_packet;
	int		get_out;
	double	interference_ptr_tmp[2][MAX_COLLISIONS];
	int		result[MAX_COLLISIONS];
	Channel_buffer*	a_buffer;
	Channel_buffer* tmp_buffer;
	
	
	FIN( construct_interference_ptr (pkptr, type) );
	
	current_index = 0;
	number_of_collisions = 0;
	test = 0;
	get_out = 1;
	
	/* Initialization */
	for( j = 0 ; j <MAX_COLLISIONS  ; j++ )
		{ 
		result[j] = 0;
		interference_ptr_tmp[0][j] = 100.0;
		interference_ptr_tmp[1][j] = 100.0;
		}
		
	/*we look for the Packet in the buffer*/
	/*the information about the Packet are in the row number i */
	for( l = 0 ; l < MAX_COLLISIONS ; l++ )
		if (op_pk_id(pkptr) == channel_buffer[l]->pkt_id)
				{
				current_index = l;
				a_buffer = channel_buffer[current_index];
				break;
				}

	/*********************************************
	if (RANGE_OF_TIME)
		print_interference_ptr (i, OPC_FALSE);
	*********************************************/
	
	/*piconet_number[0] = a_buffer->piconet;*/
	time_packet[current_index] = a_buffer->delivery_time - a_buffer->pkt_size; /* current arrival of the packet */
	type_packet = a_buffer->type;
	
   	/*we look for Packets that had collision with this Packet */
	for ( j = 0; j < MAX_COLLISIONS; j++ )
		{
		tmp_buffer = channel_buffer[j];
		
		if (((type_packet == BT) && (tmp_buffer->type == BT) && (fabs(tmp_buffer->freq_transmission - a_buffer->freq_transmission) > 2.0)) ||
			((type_packet == BT) && (tmp_buffer->type == WLAN) && (fabs(tmp_buffer->freq_transmission - a_buffer->freq_transmission) > 8.0)) ||
			((type_packet == WLAN) && (tmp_buffer->type == BT) && (fabs(tmp_buffer->freq_transmission - a_buffer->freq_transmission) > 8.0)) ||
			((type_packet == WLAN) && (tmp_buffer->type == WLAN) && (fabs(tmp_buffer->freq_transmission - a_buffer->freq_transmission) > 17.0)))
				get_out = 0;

		if (get_out)
			{
			time_packet[j] = tmp_buffer->delivery_time - tmp_buffer->pkt_size;
			
			if ( ( ( time_packet[j] - time_packet[current_index] >= 0 ) && ( time_packet[j]- time_packet[current_index] <= a_buffer->pkt_size ) )||
		     ( ( time_packet[current_index] - time_packet[j] >= 0 ) && ( time_packet[current_index]- time_packet[j] <= tmp_buffer->pkt_size ) ) )
				{	
				if (a_buffer != tmp_buffer)
					{
					interference_ptr_tmp[0][number_of_collisions] = time_packet[j];
					interference_ptr_tmp[1][number_of_collisions] = tmp_buffer->delivery_time;
					/**********************************************
					if (RANGE_OF_TIME)
						print_interference_ptr (time_buffer, j, OPC_TRUE);
					**********************************************/
					number_of_collisions++;
					}
				}
		    }
		get_out = 1;
		}
	
	num_collisions = number_of_collisions;
	
	if ( num_collisions > 1)
		{
		sort_interference(interference_ptr_tmp, num_collisions);
		overlap(interference_ptr_tmp, num_collisions, result);
		
		for(j = 0; j < num_collisions ; j++)
			{
			if(result[j] > 0)
				test = 1;
			}
		}
	
	/*the number of collision is j -i + 1*/
	
	/*to allocate memory for the interference_ptr */
	interference_ptr = (double **) op_prg_mem_alloc ( 6 * sizeof(double *) ); 
	
	for(j = 0; j < 6 ; j++)
		interference_ptr[j] = (double *) op_prg_mem_alloc ( (num_collisions+1) * sizeof(double) ); 
		 
	l = 1;
	
	/*to copy the needed information from the buffer to the pointer*/
	if( num_collisions != 0 )
		{
		
		for ( j = 0; j < MAX_COLLISIONS; j++ )
			{
			tmp_buffer = channel_buffer[j];
			
			if (((type_packet == BT) && (tmp_buffer->type == BT) && (fabs(tmp_buffer->freq_transmission- a_buffer->freq_transmission) > 2.0)) ||
				((type_packet == BT) && (tmp_buffer->type == WLAN) && (fabs(tmp_buffer->freq_transmission - a_buffer->freq_transmission) > 8.0)) ||
				((type_packet == WLAN) && (tmp_buffer->type == BT) && (fabs(tmp_buffer->freq_transmission - a_buffer->freq_transmission) > 8.0)) ||
				((type_packet == WLAN) && (tmp_buffer->type == WLAN) && (fabs(tmp_buffer->freq_transmission - a_buffer->freq_transmission) > 17.0)))
				get_out = 0;
			
			if(get_out)
				{
				time_packet[j] = tmp_buffer->delivery_time - tmp_buffer->pkt_size;
		
				if ( ( ( time_packet[j] - time_packet[current_index] >= 0 ) && ( time_packet[j]- time_packet[current_index] <= a_buffer->pkt_size ) )||
				 ( ( time_packet[current_index] - time_packet[j] >= 0 ) && ( time_packet[current_index]- time_packet[j] <= tmp_buffer->pkt_size ) ) )
					{	
					if (a_buffer != tmp_buffer)
						{
						interference_ptr[0][l] = time_packet[j] - time_packet[current_index];
						interference_ptr[1][l] = tmp_buffer->pkt_size;
						interference_ptr[2][l] = tmp_buffer->type;
						interference_ptr[3][l] = tmp_buffer->power;
						interference_ptr[4][l] = tmp_buffer->freq_transmission;
						interference_ptr[5][l] = sqrt( (a_buffer->rx_x -  tmp_buffer->tx_x)*(a_buffer->rx_x - tmp_buffer->tx_x) +
							( a_buffer->rx_y - tmp_buffer->tx_y)*(a_buffer->rx_y - tmp_buffer->tx_y) );
					
						l++;
						}
					}
				}
			
			get_out = 1;
			}
		}
	
	
	 	 
	/*Set the pointer values for the main packet*/ 
	interference_ptr[0][0] = 0.0;
	interference_ptr[1][0] = a_buffer->pkt_size;
	interference_ptr[2][0] = a_buffer->type;
	interference_ptr[3][0] = a_buffer->power;
	interference_ptr[4][0] = a_buffer->freq_transmission;
	interference_ptr[5][0] = sqrt( (a_buffer->tx_x -  a_buffer->rx_x)*(a_buffer->tx_x - a_buffer->rx_x) +
		( a_buffer->tx_y -  a_buffer->rx_y)*(a_buffer->tx_y - a_buffer->rx_y) ) ;
	
		
	FOUT;
}


static void overlap(double interference_ptr_tmp[2][MAX_COLLISIONS], int size, int *result)
	{
	int i,j;
	int number_overlap;
	FIN (overlap(interference_ptr_tmp,size,result));
	
	number_overlap =0;
	for (j=0;j < size; j++)
		{
		for (i=0;i < size; i++)
			if 	((i != j) && (interference_ptr_tmp[0][i] < interference_ptr_tmp[1][j]) &&
				(interference_ptr_tmp[0][j] < interference_ptr_tmp[1][i]))
					number_overlap++;
		result[j] = number_overlap;
		}
	FOUT;
	}


static void sort_interference(double interference_ptr_tmp[2][MAX_COLLISIONS], int size)
	{	
	int i,j;
	int min;
	FIN (sort_interference(interference_ptr_tmp,size));
	
	
	for (i=0; i < size - 1; i++)
		{
		min	= i ;
		for ( j = i + 1; j < size; j ++)
			{
			if(interference_ptr_tmp[0][j] < interference_ptr_tmp[0][min])
				min = j;
			}
		
		if (i != min)
			switch_element(interference_ptr_tmp, i, min);
		}
	
	/*for (i=0;i < size ; i ++)
		{
		printf(" value interference_ptr_tmp[0][%d] = %f \n",i, interference_ptr_tmp[0][i]); 
		printf(" value interference_ptr_tmp[1][%d] = %f \n",i, interference_ptr_tmp[1][i]); 
		}*/
	
	FOUT;
	}
 
static void switch_element(double interference_ptr_tmp[2][MAX_COLLISIONS], int first_index, int second_index)
	{
	int temp_var; /* temporary variable */

	
	FIN(switch_element(interference_ptr_tmp, first_index, second_index));
	
	temp_var = interference_ptr_tmp[0][first_index];
	interference_ptr_tmp[0][first_index] = interference_ptr_tmp[0][second_index];
	interference_ptr_tmp[0][second_index] = temp_var;
	
	temp_var = interference_ptr_tmp[1][first_index];
	interference_ptr_tmp[1][first_index] = interference_ptr_tmp[1][second_index];
	interference_ptr_tmp[1][second_index] = temp_var;
	
	FOUT;
	}


/*
 * Function : channel_end_of_simulation()]
 *
 * Description
 */

static void  channel_end_of_simulation()
	{
	FILE *output;
	
	char *file_name_wlan = "Wlan_sim_report.txt";
	char **file_name;
	char *name;
	Objid file_objid, file_attr_objid;
	char buffer[1024];
	char *path;
	int i,j,number_of_piconet = topo_get_number_of_piconet();
	int lenght;
	
	FIN ( channel_end_of_simulation() );
	
	if (debug_flag == OPC_BOOLINT_ENABLED)
		bt_print_debug ("Channel function block : channel_end_of_simulation()");

	op_ima_obj_attr_get (channel_objid, "Report", &file_attr_objid);
	file_objid = op_topo_child (file_attr_objid, OPC_OBJTYPE_GENERIC,0);

	op_ima_obj_attr_get (file_objid, "path", buffer);
	
	path = (char *) op_prg_mem_alloc ( ( strlen(buffer) + 1 ) * sizeof(char) );
	strcpy(path,buffer);

	printf ("\n|-------------------------------------------------------------------------|\n");
	printf ("| Info for channel out files :\n");
	printf ("| \tpath where are the files : %s\n",path);
	printf ("|-------------------------------------------------------------------------|\n");

	if (number_of_piconet)
		file_name = (char **) op_prg_mem_alloc ( number_of_piconet * sizeof(char *) );

	for (i=0; i<number_of_piconet; i++)
		{
		file_name[i] = (char *) op_prg_mem_alloc ( 25 * sizeof(char));
		sprintf (file_name[i],"bt_sim_report_%d.txt",i);
		}
   
	
	lenght = strlen(file_name_wlan) + strlen(path) + 1;
	
	name = (char *) op_prg_mem_alloc ( lenght * sizeof(char) );
	strcpy(name,path);
	strcat(name,file_name_wlan);
	
	if( (output = fopen ( name  , "a" )) == NULL)
		op_sim_end("PHY Channel mac :",
			"In function channel_end_of_simulation()",
			"A file can t be opened\n",
			"Check the access memory");
	
	fprintf(output ,"  total bt packets %d \n",  wlan_packet_number );	
	fprintf(output ,"\t collisions \t\t packets \t\t errors \t\t average errors\n ");
		
	for ( i = 0 ; i < MAX_ERROR_TO_CORRECT ; i++ )
		{
		if ( wlan_report_table[0][i] != 0)
			{
			fprintf(output ,"\t %d \t\t %f \t\t %f \t\t %f \n", i,
				wlan_report_table[0][i],
				wlan_report_table[1][i],
				(float) wlan_report_table[1][i] / (float) wlan_report_table[0][i] );
			}
		}
	
	fclose(output);
			
	for (i=0; i<number_of_piconet; i++)
		{
		lenght = strlen(file_name[i]) + strlen(path) + 1;
		
		op_prg_mem_free (name);
		name = (char *) op_prg_mem_alloc ( lenght * sizeof(char) );
		strcpy(name,path);
		strcat(name,file_name[i]);
		
		if( (output = fopen ( name , "a" )) == NULL)
			op_sim_end("PHY Channel mac :",
				"In function channel_end_of_simulation()",
				"A file can t be opened\n",
				"Check the access memory");
		
		fprintf(output ,"  total bt packets %d \n",  bt_packet_number );
		fprintf(output ,"\t collisions \t\t packets \t\t errors \t\t average errors\n ");
		
		for ( j = 0 ; j < MAX_ERROR_TO_CORRECT ; j++ )
			{
			if ( bt_report_table[0][j][i] != 0)
				{
				fprintf(output ,"\t %d \t\t %f \t\t %f \t\t %f \n", i,
					bt_report_table[0][j][i],
					bt_report_table[1][j][i],
					(float) bt_report_table[1][j][i] / (float)bt_report_table[0][j][i] );
				}
			}
		
		fclose(output);
		}
	
	
	/* Get the size for a temporary file */
	lenght = strlen ("done.txt") + strlen(path) + 1;
	
	op_prg_mem_free (name);
	name = (char *) op_prg_mem_alloc ( lenght * sizeof(char) );
	strcpy (name, path);
	strcat (name, "done.txt");
	
	if( (output = fopen ( name , "w" )) == NULL)
			op_sim_end("PHY Channel mac :",
				"In function channel_end_of_simulation()",
				"A file can t be opened\n",
				"Check the access memory");
	
	fprintf (output, "%f\n", op_sim_time ());
	
	fclose (output);
	
	
	/* free memory */
	op_prg_mem_free (path);
	op_prg_mem_free (name);
	
	if (number_of_piconet)
		{
		for (i=0; i<number_of_piconet; i++)
			op_prg_mem_free (file_name[i]);
		
		op_prg_mem_free (file_name);
		}
	
	/* end of simulation for topo_discovery */
	//topo_discovery_free_memory ();
		
	for (i=0; i<MAX_COLLISIONS; i++)
		op_prg_mem_free (channel_buffer[i]);
	
	FOUT;
	}
/**************/

/*
 * Function : channel_pkt_enqueue
 */

static void channel_pkt_enqueue (Packet *pkptr, int piconet)
{
	Packet_elt *a_packet;
	int			debug_channel = op_prg_odb_ltrace_active ("channel");
	
	
	FIN(channel_pkt_enqueue ());
	
	/* Allocate some memory */
	a_packet = (Packet_elt *) op_prg_mem_alloc (sizeof(Packet_elt));
	
	/* fill in the structure Packet_elt */
	a_packet->piconet = piconet;
	a_packet->pkptr = pkptr;
	
	if (debug_channel)
		printf ("channel enqueue the packet in list number %d\n", a_packet->piconet);
	
	/* store the element a_packet */
	op_prg_list_insert (Channel_list, a_packet, OPC_LISTPOS_TAIL);
	
	FOUT;
}

/*
 * Function : channel_pkt_dequeue
 */

static Packet *channel_pkt_dequeue (int piconet_number)
{
	Packet_elt	*a_packet;
	Packet		*pkptr = OPC_NIL;
	int			 nb_elt = op_prg_list_size(Channel_list);
	int 		 i; /* loop variable */
	int			 debug_channel = op_prg_odb_ltrace_active ("channel");
	
	
	FIN(channel_pkt_dequeue (piconet_number));
		
	if (debug_channel) printf ("Channel try to dequeue a packet in queue number %d\n", piconet_number);
	
	/* We're looking for the good element through the list */
	for (i=0; i<nb_elt; i++)
		{
		a_packet = (Packet_elt *) op_prg_list_access (Channel_list, i);
		
		if (a_packet->piconet == piconet_number)
			{
			pkptr = a_packet->pkptr;
			op_prg_mem_free (op_prg_list_remove (Channel_list, i));
			break;
			}
		}
	
	FRET(pkptr);
}


static void print_interference_ptr (int packet_number, Boolean interference)
	{
	double start_time;
	Channel_buffer* a_buffer;
	FILE *fp;
	
	FIN(print_interference_ptr (table, packet_number));
	
	if ((fp = fopen("D:\\op_results\\trial\\interferences.txt", "a")) == NULL)
		op_sim_end ("print_interference_ptr :","Can't open the file to write","","");
	
	a_buffer = channel_buffer[packet_number];
	start_time = a_buffer->delivery_time - a_buffer->pkt_size;
	
	if (interference)
		fprintf(fp,"Interference Packet:");
	else
		fprintf(fp,"\n\n/************************************************************/");
	
	
	fprintf(fp,"\n|-----------------------------------------------------------*\n");

	fprintf(fp, "|\t Start time[packet %d] = %f\n", packet_number, start_time);
	fprintf(fp, "|\t Final time[packet %d] = %f\n",packet_number, a_buffer->delivery_time);
	fprintf(fp, "|\t size_packet[packet %d] = %f\n",packet_number, a_buffer->pkt_size);
	fprintf(fp, "|\t type_packet[packet %d] = %s\n",packet_number, (a_buffer->type == 1.0)?"BT":"WLAN");
	fprintf(fp, "|\t power[packet %d] = %f\t\t|\n", packet_number, a_buffer->power);
	fprintf(fp, "|\t frequence[packet %d] = %f\t\t|\n", packet_number, a_buffer->freq_transmission);
	fprintf(fp, "|\t distance[packet %d] = %f\t\t|\n", packet_number, a_buffer->tx_x);
	
	fprintf(fp,"|-----------------------------------------------------------*\n");
	
	fclose(fp);
		
	FOUT;
	}

/*
 *
 */

static void bt_print_report_channel (const char * filename, const char * line1, const char * line2)
{
	FILE *	fp;
	char *	name;
	
	FIN (bt_print_report_channel (filename, line1, line2));
	
	/* get the name of the file */
	name = bt_stats_get_report_name (filename);
	
	/* open the file */
	if ( (fp = fopen (name, "a")) == NULL)
		bt_mac_error ("print_report_slave ()", "Cannot open file", OPC_NIL);
	
	/* print the line in the file */
	if ((line1 != NULL) && (line1 != OPC_NIL))
		fprintf (fp, "%s\n", line1);
	
	if ((line2 != NULL) && (line2 != OPC_NIL))
		fprintf (fp, "%s\n", line2);
	
	/* close the file */
	fclose (fp);
	
	/* free the memory */
	op_prg_mem_free (name);
		
	FOUT;
}

/*
 * Function:	bt_debug_log_file()
 *
 * Description: try to redirect the standart output into
 *				the file "log_file.txt"
 *
 * No parameter
 */

static void	bt_debug_log_file ()
{
	/* boolean for redirecting the standards output */
	Boolean log_file = op_prg_odb_ltrace_active ("btlog");
	char *	filename;
	
	FIN (bt_debug_log_file ());
	
	if (log_file && (log_file_ptr == NULL))
		{
		/* get the name of the file */
		filename = bt_stats_get_report_name ("log_file.txt");
	
		if ((log_file_ptr = freopen (filename, "a", stdout)) == NULL)
			bt_mac_error ("bt_debug_log_file():", "Cannot redirected the standards output", OPC_NIL);
		}
	
	FOUT;
}

/* End of Function Block */

/* Undefine optional tracing in FIN/FOUT/FRET */
/* The FSM has its own tracing code and the other */
/* functions should not have any tracing.		  */
#undef FIN_TRACING
#define FIN_TRACING

#undef FOUTRET_TRACING
#define FOUTRET_TRACING

#if defined (__cplusplus)
extern "C" {
#endif
	void w_bt_chan_phy (void);
	Compcode w_bt_chan_phy_init (void **);
	void w_bt_chan_phy_diag (void);
	void w_bt_chan_phy_terminate (void);
	void w_bt_chan_phy_svar (void *, const char *, char **);
#if defined (__cplusplus)
} /* end of 'extern "C"' */
#endif




/* Process model interrupt handling procedure */


void
w_bt_chan_phy (void)
	{
	int _block_origin = 0;
	FIN (w_bt_chan_phy ());
	if (1)
		{
		WlanT_Data_Header_Fields*	pk_dhstruct_ptr;
		int             	  		dest_addr_wlan;
		int							piconet_number, i;
		Channel_buffer*				a_buffer;


		FSM_ENTER (w_bt_chan_phy)

		FSM_BLOCK_SWITCH
			{
			/*---------------------------------------------------------*/
			/** state (Init) enter executives **/
			FSM_STATE_ENTER_UNFORCED_NOLABEL (0, "Init", "w_bt_chan_phy () [Init enter execs]")
				{
				/* Initialize the process. Call the initialization */
				/* routine that load all the structures and performs */
				/* a topology recognition */
				
				bt_phy_channel_init ();
				
				/* Schedule a self interrupt to wait for the other processes 	*/
				/* to move to next state after registering						*/
				op_intrpt_schedule_self(op_sim_time(), 0);
				}


			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (1,w_bt_chan_phy)


			/** state (Init) exit executives **/
			FSM_STATE_EXIT_UNFORCED (0, "Init", "w_bt_chan_phy () [Init exit execs]")
				{
				}


			/** state (Init) transition processing **/
			FSM_TRANSIT_FORCE (4, state4_enter_exec, ;, "default", "", "Init", "init2")
				/*---------------------------------------------------------*/



			/** state (Idle) enter executives **/
			FSM_STATE_ENTER_UNFORCED (1, state1_enter_exec, "Idle", "w_bt_chan_phy () [Idle enter execs]")
				{
				}


			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (3,w_bt_chan_phy)


			/** state (Idle) exit executives **/
			FSM_STATE_EXIT_UNFORCED (1, "Idle", "w_bt_chan_phy () [Idle exit execs]")
				{
				/* Get the current interuption */
				intrpt_type = op_intrpt_type ();
				
				if (intrpt_type == OPC_INTRPT_STRM)
					intrpt_strm = op_intrpt_strm();
				else if (intrpt_type == OPC_INTRPT_SELF)
					intrpt_code = op_intrpt_code ();
				
				/* START DEBUG */
				bt_debug_log_file ();
				/* STOP DEBUG */
				}


			/** state (Idle) transition processing **/
			FSM_INIT_COND (PACKET_TO_RECEIVE)
			FSM_TEST_COND (PACKET_TO_TRANSMIT)
			FSM_TEST_COND (SIM_END)
			FSM_DFLT_COND
			FSM_TEST_LOGIC ("Idle")

			FSM_TRANSIT_SWITCH
				{
				FSM_CASE_TRANSIT (0, 2, state2_enter_exec, ;, "PACKET_TO_RECEIVE", "", "Idle", "Buffer")
				FSM_CASE_TRANSIT (1, 3, state3_enter_exec, ;, "PACKET_TO_TRANSMIT", "", "Idle", "Send")
				FSM_CASE_TRANSIT (2, 1, state1_enter_exec, channel_end_of_simulation();, "SIM_END", "channel_end_of_simulation()", "Idle", "Idle")
				FSM_CASE_TRANSIT (3, 1, state1_enter_exec, ;, "default", "", "Idle", "Idle")
				}
				/*---------------------------------------------------------*/



			/** state (Buffer) enter executives **/
			FSM_STATE_ENTER_FORCED (2, state2_enter_exec, "Buffer", "w_bt_chan_phy () [Buffer enter execs]")
				{
				/* Get the incomming packet and process it */
				current_pkptr = op_pk_get(intrpt_strm);
				current_arrival_time = op_sim_time();
				
				a_buffer = channel_buffer[num_packet%MAX_COLLISIONS];
				
				/* Obtain the cartesian-geocentric coordinates for both nodes.*/
				op_pk_nfd_get(current_pkptr,"t_x",&tx_x );
				op_pk_nfd_get(current_pkptr,"t_y",&tx_y );
				op_pk_nfd_get(current_pkptr,"r_x",&rx_x );
				op_pk_nfd_get(current_pkptr,"r_y",&rx_y );
				
				/* Get the number of piconet of the device which sends the packet */
				op_pk_nfd_get(current_pkptr, "piconet", &piconet_number);
				
				a_buffer->piconet = piconet_number;
				
				/*the variable time_buffer is one buffer where we stock all the information,*/
				/*we need, about the packet those information will be transfered */
				/*to the interference pointer which will be passed to the physical layer*/
				/*store the coordinate of the ransmitter and the receiver*/
				
				a_buffer->tx_x = tx_x;
				a_buffer->tx_y = tx_y;
				a_buffer->rx_x = rx_x;
				a_buffer->rx_y = rx_y;
				
				
				/*to store the transmission power*/
				op_pk_nfd_get(current_pkptr,"power", &a_buffer->power);
				
				a_buffer->pkt_id = (double) op_pk_id (current_pkptr);
				
				switch(op_intrpt_strm())
					{	
					case BLUETOOTH_INPUT_STREAM:
					
					/* DEBUG INFORMATION */
						if (op_sim_debug() && op_prg_odb_ltrace_active ("channel"))
							printf ("|\tChannel received a BT packet; the piconet number is %d\n", a_buffer->piconet);
					/* END OF DEBUG */
					
					/* When a packet is received from the Bluetooth	device */
						bt_packet_number++;
					channel_pkt_enqueue (current_pkptr, piconet_number);
					ch_drate = bt_bit_rate ;
					
					a_buffer->pkt_size = op_pk_total_size_get(current_pkptr) *1000000.0/ ch_drate;
					a_buffer->type = BT;
					
					op_pk_nfd_get (current_pkptr, "frequency", &freq_transmission);
					a_buffer->freq_transmission = freq_transmission;
				  	
					bt_num_bits = bt_num_bits + op_pk_total_size_get(current_pkptr);
				
					break;
					case	WLAN_INPUT_STREAM:
					
					/*modif .Issam.E 10/05/200*/
						{
						/* DEBUG INFORMATION */
						if (op_sim_debug() && op_prg_odb_ltrace_active ("channel"))
							printf ("|\tChannel received a WLAN packet; the piconet number is %d\n", a_buffer->piconet);
						/* END OF DEBUG */
						
						//printf(" the value of WLAN is %f \n",WLAN);
						wlan_packet_number++;
						
						/*schedule one remote interruption to set the receiver of the device busy*/
						op_pk_nfd_access (current_pkptr, "Wlan Header",	&pk_dhstruct_ptr);
						dest_addr_wlan = pk_dhstruct_ptr->address1;
						op_intrpt_schedule_remote (op_sim_time(),RECEPTION_ON,topo_get_wlan_device_from_address(dest_addr_wlan)->mac_objid );
						
						/* When a packet is received from the WLAN interface	*/
						channel_pkt_enqueue (current_pkptr, piconet_number + number_of_piconet);
						ch_drate = wlan_bit_rate ;
						op_pk_nfd_access (current_pkptr,"Type",&type_of_packet);
						
						if(type_of_packet == WlanC_Data)
							{
							if (Phy_Char == DS)
								a_buffer->pkt_size = (double)op_pk_total_size_get(current_pkptr)*1000000.0/ ch_drate + 192.0;
							else if (Phy_Char == FH)
								a_buffer->pkt_size = (double)op_pk_total_size_get(current_pkptr) + 128.0;
							}
						else
							{
							if (Phy_Char == DS)
								a_buffer->pkt_size = (double) op_pk_total_size_get(current_pkptr) + 192.0;
							else if (Phy_Char == FH)
								a_buffer->pkt_size = (double) op_pk_total_size_get(current_pkptr) + 128.0;
							}
				
						a_buffer->type = WLAN;
						
						op_pk_nfd_access(current_pkptr,"frequency",&freq_transmission);
						a_buffer->freq_transmission = freq_transmission/1000000.0;
						wlan_num_bits = wlan_num_bits + op_pk_total_size_get(current_pkptr);
						break;	
						}
					}
				
				
				a_buffer->delivery_time = current_arrival_time * 1000000.0 + a_buffer->pkt_size;
				
				
				/* increase the number of packet */
				num_packet++;
				
				/* Call the interference function */
				wlan_bt_channel_interference(current_pkptr);
				}


			/** state (Buffer) exit executives **/
			FSM_STATE_EXIT_FORCED (2, "Buffer", "w_bt_chan_phy () [Buffer exit execs]")
				{
				}


			/** state (Buffer) transition processing **/
			FSM_TRANSIT_FORCE (1, state1_enter_exec, ;, "default", "", "Buffer", "Idle")
				/*---------------------------------------------------------*/



			/** state (Send) enter executives **/
			FSM_STATE_ENTER_FORCED (3, state3_enter_exec, "Send", "w_bt_chan_phy () [Send enter execs]")
				{
				/* Ask a packet to the scheduler and if there is any	*/
				/* waiting to be transmitted, then process it thru the	*/
				/* TX */
				bt_channel_pk_send ();
				}


			/** state (Send) exit executives **/
			FSM_STATE_EXIT_FORCED (3, "Send", "w_bt_chan_phy () [Send exit execs]")
				{
				}


			/** state (Send) transition processing **/
			FSM_TRANSIT_FORCE (1, state1_enter_exec, ;, "default", "", "Send", "Idle")
				/*---------------------------------------------------------*/



			/** state (init2) enter executives **/
			FSM_STATE_ENTER_UNFORCED (4, state4_enter_exec, "init2", "w_bt_chan_phy () [init2 enter execs]")
				{
				/* Schedule a self interrupt to wait for the other processes 	*/
				/* to move to next state after registering						*/
				op_intrpt_schedule_self(op_sim_time() + 0.000001, 0);
				}


			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (9,w_bt_chan_phy)


			/** state (init2) exit executives **/
			FSM_STATE_EXIT_UNFORCED (4, "init2", "w_bt_chan_phy () [init2 exit execs]")
				{
				/* Iniatialize the process when the topologie */
				/* is known thanks to the init states */
				
				bt_phy_channel_init2 ();
				}


			/** state (init2) transition processing **/
			FSM_TRANSIT_FORCE (1, state1_enter_exec, ;, "default", "", "init2", "Idle")
				/*---------------------------------------------------------*/



			}


		FSM_EXIT (0,w_bt_chan_phy)
		}
	}

#if defined (__cplusplus)
	extern "C" { 
#endif
	extern VosT_Fun_Status Vos_Catmem_Register (const char * , int , VosT_Void_Null_Proc, VosT_Address *);
	extern VosT_Address Vos_Catmem_Alloc (VosT_Address, size_t);
	extern VosT_Fun_Status Vos_Catmem_Dealloc (VosT_Address);
#if defined (__cplusplus)
	}
#endif


Compcode
w_bt_chan_phy_init (void ** gen_state_pptr)
	{
	int _block_origin = 0;
	static VosT_Address	obtype = OPC_NIL;

	FIN (w_bt_chan_phy_init (gen_state_pptr))

	if (obtype == OPC_NIL)
		{
		/* Initialize memory management */
		if (Vos_Catmem_Register ("proc state vars (w_bt_chan_phy)",
			sizeof (w_bt_chan_phy_state), Vos_Vnop, &obtype) == VOSC_FAILURE)
			{
			FRET (OPC_COMPCODE_FAILURE)
			}
		}

	*gen_state_pptr = Vos_Catmem_Alloc (obtype, 1);
	if (*gen_state_pptr == OPC_NIL)
		{
		FRET (OPC_COMPCODE_FAILURE)
		}
	else
		{
		/* Initialize FSM handling */
		((w_bt_chan_phy_state *)(*gen_state_pptr))->current_block = 0;

		FRET (OPC_COMPCODE_SUCCESS)
		}
	}



void
w_bt_chan_phy_diag (void)
	{
	/* No Diagnostic Block */
	}




void
w_bt_chan_phy_terminate (void)
	{
	int _block_origin = __LINE__;

	FIN (w_bt_chan_phy_terminate (void))

	Vos_Catmem_Dealloc (pr_state_ptr);

	FOUT;
	}


/* Undefine shortcuts to state variables to avoid */
/* syntax error in direct access to fields of */
/* local variable prs_ptr in w_bt_chan_phy_svar function. */
#undef channel_objid
#undef nb_pkt_on_channel
#undef previous_pkptr
#undef device_list_ptr
#undef current_pkptr
#undef previous_arrival_time
#undef current_arrival_time
#undef num_collisions
#undef freq_collision_num
#undef slave_power_stat
#undef master_power_stat
#undef master_ber_stat
#undef slave_ber_stat
#undef slave_average_ber
#undef master_average_ber
#undef master_power_curve
#undef slave_power_curve
#undef debug_flag
#undef intrpt_type
#undef intrpt_strm
#undef intrpt_code
#undef log_file_ptr



void
w_bt_chan_phy_svar (void * gen_ptr, const char * var_name, char ** var_p_ptr)
	{
	w_bt_chan_phy_state		*prs_ptr;

	FIN (w_bt_chan_phy_svar (gen_ptr, var_name, var_p_ptr))

	if (var_name == OPC_NIL)
		{
		*var_p_ptr = (char *)OPC_NIL;
		FOUT;
		}
	prs_ptr = (w_bt_chan_phy_state *)gen_ptr;

	if (strcmp ("channel_objid" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->channel_objid);
		FOUT;
		}
	if (strcmp ("nb_pkt_on_channel" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->nb_pkt_on_channel);
		FOUT;
		}
	if (strcmp ("previous_pkptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->previous_pkptr);
		FOUT;
		}
	if (strcmp ("device_list_ptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->device_list_ptr);
		FOUT;
		}
	if (strcmp ("current_pkptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->current_pkptr);
		FOUT;
		}
	if (strcmp ("previous_arrival_time" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->previous_arrival_time);
		FOUT;
		}
	if (strcmp ("current_arrival_time" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->current_arrival_time);
		FOUT;
		}
	if (strcmp ("num_collisions" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->num_collisions);
		FOUT;
		}
	if (strcmp ("freq_collision_num" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->freq_collision_num);
		FOUT;
		}
	if (strcmp ("slave_power_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->slave_power_stat);
		FOUT;
		}
	if (strcmp ("master_power_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->master_power_stat);
		FOUT;
		}
	if (strcmp ("master_ber_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->master_ber_stat);
		FOUT;
		}
	if (strcmp ("slave_ber_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->slave_ber_stat);
		FOUT;
		}
	if (strcmp ("slave_average_ber" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->slave_average_ber);
		FOUT;
		}
	if (strcmp ("master_average_ber" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->master_average_ber);
		FOUT;
		}
	if (strcmp ("master_power_curve" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->master_power_curve);
		FOUT;
		}
	if (strcmp ("slave_power_curve" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->slave_power_curve);
		FOUT;
		}
	if (strcmp ("debug_flag" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->debug_flag);
		FOUT;
		}
	if (strcmp ("intrpt_type" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->intrpt_type);
		FOUT;
		}
	if (strcmp ("intrpt_strm" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->intrpt_strm);
		FOUT;
		}
	if (strcmp ("intrpt_code" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->intrpt_code);
		FOUT;
		}
	if (strcmp ("log_file_ptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->log_file_ptr);
		FOUT;
		}
	*var_p_ptr = (char *)OPC_NIL;

	FOUT;
	}

