/*
** $file: rr_support.h
**
** Bluetooth model in Opnet
** National Institute of Standards and Technology
**
** This model was developed at the National Institute of Standards
** and Technology by employees of the Federal Government in the course
** of their official duties. Pursuant to title 17 Section 105 of the
** United States Code this software is not subject to copyright
** protection and is in the public domain. This is an experimental
** system.  NIST assumes no responsibility whatsoever for its use by
** other parties, and makes no guarantees, expressed or implied,
** about its quality, reliability, or any other characteristic.
**
** We would appreciate acknowledgement if the model is used.
**
** NIST ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION
** AND DISCLAIM ANY LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER
** RESULTING FROM THE USE OF THIS SOFTWARE.
**
** Primary Author:      Frederic Mouveaux
** Module description:  RoundRobin scheduling algorithm for Bluetooth Device
** Last Modification:   January, 15th 2003 (Olivier Rebala)
*/

#ifndef	__RR_SUPPORT_H__
#define	__RR_SUPPORT_H__

/* Standard includes */
#include <opnet.h>
#include "bt_support.h"
#include "topo_discovery.h"

/* Define the number of queues */
#define		RR_NB_MAX_QUEUE		9

/* Subqueues definition */
typedef enum rr_subq_value
{
  SUBQ_BROADCAST,
  SUBQ_ACTIVE_1,
  SUBQ_ACTIVE_2,
  SUBQ_ACTIVE_3,
  SUBQ_ACTIVE_4,
  SUBQ_ACTIVE_5,
  SUBQ_ACTIVE_6,
  SUBQ_ACTIVE_7,
  SUBQ_SCO
} RRSubq;

/* The current subqueue to check for the RR */
int    * current_dest_station;

/* Function prototypes declaration */
List **		rr_init_support (int piconet_number);
void		rr_pkt_enqueue (List **rr_bt_queue, Packet * pkptr, int subq);
Packet *	rr_request_pkt_to_scheduler (List **rr_bt_queue, int piconet_number);
Packet *	rr_request_pkt_to_scheduler_with_poll (List **rr_bt_queue, int piconet_number, int number_of_slave);
Boolean		rr_bt_queue_empty (List **rr_bt_queue, int queue);
Packet *	rr_pk_queue_remove (List **rr_bt_queue, int queue, int pos_index);
Packet *	rr_pk_queue_access (List **rr_bt_queue, int queue, int pos_index);
void		rr_end_free (List **rr_bt_queue);

#endif	/* __RR_SUPPORT_H__ */
