/*
** $File : physic_channel.ex.c
**
** Bluetooth model in Opnet
** National Institute of Standards and Technology
**
** This model was developed at the National Institute of Standards
** and Technology by employees of the Federal Government in the course
** of their official duties. Pursuant to title 17 Section 105 of the
** United States Code this software is not subject to copyright
** protection and is in the public domain. This is an experimental
** system.  NIST assumes no responsibility whatsoever for its use by
** other parties, and makes no guarantees, expressed or implied,
** about its quality, reliability, or any other characteristic.
**
** We would appreciate acknowledgement if the model is used.
**
** NIST ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION
** AND DISCLAIM ANY LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER
** RESULTING FROM THE USE OF THIS SOFTWARE.
**
** Primary Author:      Amir Soltanian
** Module description:  Bluetooth physical layer
** Last Modification:   July, 9, 2002
**
*/

/* include header */
#include "physic.h"


/*
 * Function:	Channel_AWGN
 */ 

void	Channel_AWGN (physical_layer *PHY)
{
	FIN (Channel_AWGN (PHY));

	NoiseGen(PHY,0);

	FOUT;
}


/*
 * Function:	Channel_AWGN11
 */

void  Channel_AWGN11 (physical_layer *PHY)
{
	int i;

	
	FIN (Channel_AWGN11 (PHY));
	
	for (i=0;i<8;i++)
		 NoiseGen(PHY,Ns*i);

	FOUT;
}



/*
 * Function:	NoiseGen
 */

void	NoiseGen (physical_layer *PHY, int index)
{
	double m1,m2;
	double NI,NQ;
	int j;
	
	
	FIN (NoiseGen (PHY, index));
	
	
	for( j=0; j<Ns; j++)
		{
		 PHY->x1 = (171 *  PHY->x1)%30269;
		 PHY->x2 = (172 *  PHY->x2)%30307;
		 PHY->x3 = (170 *  PHY->x3)%30323;
		 m1 = fmod( ((double)(PHY->x1)/30269. + (double)(PHY->x2)/30307. + (double)(PHY->x3)/30323.), 1.);
		
		 PHY->x4 = (171 *  PHY->x4)%30269;
		 PHY->x5 = (172 *  PHY->x5)%30307;
		 PHY->x6 = (170 *  PHY->x6)%30323;
		 m2 = fmod( ((double)(PHY->x4)/30269. + (double)(PHY->x5)/30307. + (double)(PHY->x6)/30323.), 1.);
		 
		
		 NI=sqrt(-2*PHY->n0*log(m1))*cos(PI*2*m2);
		 NQ=sqrt(-2*PHY->n0*log(m1))*sin(PI*2*m2);
		 PHY->Inphase[index+j] += NI ;
		 PHY->Quad[index+j] += NQ ;
		 }
	
	FOUT;
}


/*
 * Function:	Channel_Rayleigh
 */

void	Channel_Rayleigh (physical_layer *PHY)
{
	FIN (Channel_Rayleigh (PHY));

	NoiseGen(PHY,0);
	
	FOUT;
}

/*
 * Function:	ChanRespConv
 *
 * Notice:		Convolve MODULATOR output with CHANNEL IMPULSE RESPONSE.
 */

void ChanRespConv(physical_layer *PHY,double **interface_pt)
{
	FIN (ChanRespConv (PHY, interface_pt));
	
	FOUT;
}

