/** wlan_support.h				**/

/****************************************/
/*      Copyright (c) 1987 - 2002       */
/*     by OPNET Technologies, Inc.      */
/*       (A Delaware Corporation)      	*/
/*    7255 Woodmont Av., Suite 250     	*/
/*     Bethesda, MD 20814, U.S.A.       */
/*       All Rights Reserved.          	*/
/****************************************/

/* Protect against multiple includes. 	*/
#ifndef	_WLAN_SUPPORT_H_INCLUDED_
#define _WLAN_SUPPORT_H_INCLUDED_

/** Include directives.							**/
#include <opnet.h>
 
#if defined (__cplusplus)
extern "C" {
#endif

/* Packet lengths for control frames.			*/ 
#define WLAN_FH_HEADER                          128
#define WLAN_DS_HEADER                          192

#define WLAN_ACK_LENGTH				112 		/* bits */
#define WLAN_ACK_DURATION			0.000112 	/* seconds */
#define WLAN_ACK_FH_LENGTH		        240
#define WLAN_ACK_FH_DURATION			0.000240
#define WLAN_ACK_DS_LENGTH		        304
#define WLAN_ACK_DS_DURATION			0.000304

#define WLAN_CTS_LENGTH				112			/* bits */
#define WLAN_CTS_DURATION			0.000112	/* seconds */ 
#define WLAN_CTS_FH_LENGTH			240
#define WLAN_CTS_FH_DURATION			0.000240
#define WLAN_CTS_DS_LENGTH			304
#define WLAN_CTS_DS_DURATION			0.000304

#define WLAN_RTS_LENGTH				160			/* bits */
#define WLAN_RTS_FH_LENGTH                      288
#define WLAN_RTS_DS_LENGTH                      352

#define WLAN_DEFAULT_PLCP_OVERHEAD	57			/* bits */
#define WLAN_MAN_DATA_RATE			1000000		/* bps */

/* Maximum tuple (or duplicate) buffer size (in	*/
/*  packets).									*/ 
#define WLAN_TUPLE_SIZE					100

/* Maximum data bits in MAC service data unit 	*/ 
/* received from higher layer.					*/ 
#define WLAN_MAXMSDU_LENGTH				18432 
 
/* Total size of MAC frame header and the FCS 	*/
/* field in bits for the data frames that do	*/
/* not use the "Address	4" field.				*/
#define WLANC_MSDU_HEADER_SIZE			224

/* Air propagation time taken for frame transmission */ 
/* in sec											  */ 
#define WLAN_AIR_PROPAGATION_TIME        0.000001 


/* Data structure used within WLAN Header field	*/
/* of the WLAN Data packets.					*/ 
typedef struct
    {
	int			more_frag;
	int			retry;
	int			order;
	int			tods;
	int			fromds;
	double		duration;  			/* Duration for which the channel is contended for. Network		*/
						   			/* Allocation Vector per the IEEE802.11 standard.				*/
	int			address1; 			/* Destination Address of the final recipient(s) of the frame.	*/
	int			address2; 			/* Source Address from where the frame is originated.			*/
	int			address3; 			/* Receiver Address that identifies the immediated receipient	*/
						   			/* station(s) address.											*/
	int			fragment_number;	/* Sequence control field which contains fragment number		*/
	int			sequence_number; 	/* Sequence contorl field which contains sequence number		*/
	int			address4; 			/* Transmitter Address of the station that has last transmitted	*/
									/* the frame.													*/

	int			more_data;			/*If set, indicates STA has additional packets to send */
									/* Currently only implemented for PCF*/
    } WlanT_Data_Header_Fields;

/* Data structure for header fields of the  
wireless_lan control (Rts, Cts, Ack) packet. */
typedef struct
    {
	int			more_frag;
	int			retry;
	int			order;
	int			tods;
	int			fromds;
	double		duration;  			/* Duration for which the channel is contended for. Network		*/
						   			/* Allocation Vector per the IEEE802.11 standard.				*/
	int			rx_addr; 			/* Destination Address of the final recipient(s) of the frame.	*/
	int			tx_addr; 			/* Source Address from where the frame is originated.			*/
    } WlanT_Control_Header_Fields;

/* FOR PCF Support */
/* Contention Free Paramaters structure */
/* Note that the cfp_count and cfp_period should be based on DTIMS. But DTIMS is not currently */
/* implemented and hence we will use the beacons */
typedef struct
	{
	double		cfp_count;			/* Indicates the number of beacon frames remaining till the next CFP*/
									/* If this value is set to 0, indicates the start of CFP			*/
	int			cfp_period;			/* Number of beacons to be sent between the CFPs					*/
	double		cfp_maxduration;	/* Maximum allowed length of CFP in seconds	   						*/
	double		cfp_durremaining;	/* Time in seconds remaining in the current CFP period				*/
	} WlanT_CF_Parameters;

/* Beacon body structure */
typedef struct
	{
	double 				timestamp;	/* Actual tx time of the beacon frames in seconds 	  */
	double				beacon_intv;/* Time interval between target beacon transmit times */
	WlanT_CF_Parameters	cf_par;
	} WlanT_Beacon_Body_Fields;

/*			Function Prototypes				*/
WlanT_Data_Header_Fields*		wlan_mac_pk_dhstruct_create (void); 
WlanT_Control_Header_Fields*	wlan_mac_pk_chstruct_create (void);
WlanT_Data_Header_Fields*		wlan_mac_pk_dhstruct_copy (WlanT_Data_Header_Fields* pk_dh_ptr); 
WlanT_Control_Header_Fields*	wlan_mac_pk_chstruct_copy (WlanT_Control_Header_Fields* pk_ch_ptr);
void  wlan_mac_pk_dhstruct_destroy (WlanT_Data_Header_Fields* pk_ffstruct_ptr); 
void  wlan_mac_pk_chstruct_destroy (WlanT_Control_Header_Fields* pk_sfstruct_ptr);
void  wlan_mac_pk_data_header_pkprint (void* pk_dh_ptr, PrgT_List* output_list);
void  wlan_mac_pk_control_header_pkprint (void* pk_ch_ptr, PrgT_List* output_list);

/* PCF Functions */
WlanT_Beacon_Body_Fields*		wlan_mac_pk_bbstruct_create (void);
WlanT_Beacon_Body_Fields*		wlan_mac_pk_bbstruct_copy (WlanT_Beacon_Body_Fields* pk_bb_ptr);
void wlan_mac_pk_bbstruct_destroy (WlanT_Beacon_Body_Fields* pk_bbstruct_ptr);
void wlan_mac_pk_beacon_body_pkprint (void* pk_bb_ptr, Prg_List* output_list);

#if defined (__cplusplus)
} /* end of 'extern "C" {' */
#endif

/* End if for protection against multiple includes. */
#endif /* _WLAN_SUPPORT_H_INCLUDED_ */
