/** bt_wlan_support.ex.c				**/

/****************************************/
/*      Copyright (c) 1987 - 2002		*/
/*     by OPNET Technologies, Inc.		*/
/*       (A Delaware Corporation)      	*/
/*    7255 Woodmont Av., Suite 250     	*/
/*     Bethesda, MD 20814, U.S.A.       */
/*       All Rights Reserved.          	*/
/****************************************/


/** Include directives.							**/
#include <opnet.h>
#include <string.h>
#include "bt_wlan_support.h"


/*  Variables defined for Pooled Memeory allocation.        */
static Boolean          pk_dhstruct_pmo_defined = OPC_FALSE; 
static Pmohandle        wlan_pk_dhstruct_pmh;
static Boolean          pk_chstruct_pmo_defined = OPC_FALSE; 
static Pmohandle        wlan_pk_chstruct_pmh;
static Boolean			pk_bbstruct_pmo_defined = OPC_FALSE;
static Pmohandle		wlan_pk_bbstruct_pmh;
	
/* Macro definition for string handling.                            */
#define PKPRINT_STRING_INSERT(str, contents, list)                              \
	{                                                                           \
	str = (char*) op_prg_mem_alloc ((strlen (contents) + 1) * sizeof (char));   \
	strcpy (str, contents);                                                     \
	op_prg_list_insert (list, str, OPC_LISTPOS_TAIL);                           \
	}


WlanT_Data_Header_Fields*
wlan_mac_pk_dhstruct_create ()
    {
    WlanT_Data_Header_Fields*          pk_dhstruct_ptr;
    
    /**  Allocate memory for packet field structure and initialize   **/
    /**  all components of the data structure. "Pooled" memory is    **/
    /**  used to allocate wlan packet fields data structure          **/
    /**  allocation block since they are frequently created          **/
    /**  and destroyed.                                              **/
    FIN (wlan_mac_pk_dhstruct_create ());

    /*  If the pooled memory object has not yet been defined, do    */
    /*  so now, prior to allocation.                                */
    if (pk_dhstruct_pmo_defined == OPC_FALSE)
        {
        /* Prevent redundant definition.                    */
        pk_dhstruct_pmo_defined = OPC_TRUE;

        wlan_pk_dhstruct_pmh = op_prg_pmo_define ("wlan packet Data headers fields", sizeof (WlanT_Data_Header_Fields), 1);

		/* Initialize the print procedure for the structures.       */
		op_pk_format_print_proc_set ("wlan_mac", "Wlan Header", wlan_mac_pk_data_header_pkprint);		

        }

    pk_dhstruct_ptr = (WlanT_Data_Header_Fields *) op_prg_pmo_alloc (wlan_pk_dhstruct_pmh);
 	if (pk_dhstruct_ptr == OPC_NIL)
		 {
		 op_sim_end ("Error in wlan support code:",
					 "Unable to allocate memory for wlan packet fields.",
					 OPC_NIL, OPC_NIL);
		 }
 
	 pk_dhstruct_ptr->more_frag = 0; 
	 pk_dhstruct_ptr->retry = 0; 
	 pk_dhstruct_ptr->order = 0;
	 pk_dhstruct_ptr->tods = 0;
	 pk_dhstruct_ptr->fromds = 0;
	 pk_dhstruct_ptr->duration = 0;			/* Duration for which the channel is contended 					*/
	 pk_dhstruct_ptr->address1 = 0; 		/* Destination Address of the final recipient(s) of the frame.	*/
	 pk_dhstruct_ptr->address2 = 0; 		/* Source Address from where the frame is originated.			*/
	 pk_dhstruct_ptr->address3 = 0; 		/* Receiver Address that identifies the immediated receipient	*/
	                                        /* station(s) address.											*/
	 pk_dhstruct_ptr->fragment_number = 0;	/* Sequence control field which contains fragment number		*/
	 pk_dhstruct_ptr->sequence_number = 0; 	/* Sequence contorl field which contains sequence number		*/
	 pk_dhstruct_ptr->address4 = 0; 		/* Transmitter Address of the station that has last transmitted	*/
                                        	/* the frame.													*/
	 
	 pk_dhstruct_ptr->more_data = 0;		/* Indicates STA has additional packets to send. Implemented 	*/
	 									   	/* only for PCF 												*/								
	     
	 FRET (pk_dhstruct_ptr);
    }  
 
  
WlanT_Control_Header_Fields* 
wlan_mac_pk_chstruct_create () 
    { 
    WlanT_Control_Header_Fields*          pk_chstruct_ptr; 
     
    /**  Allocate memory for packet field structure and initialize   **/ 
    /**  all components of the data structure. "Pooled" memory is    **/ 
    /**  used to allocate wlan packet fields data structure          **/ 
    /**  allocation block since they are frequently created          **/ 
    /**  and destroyed.                                              **/ 
    FIN (wlan_mac_pk_chstruct_create ()); 
 
    /*  If the pooled memory object has not yet been defined, do    */ 
    /*  so now, prior to allocation.                                */ 
    if (pk_chstruct_pmo_defined == OPC_FALSE) 
        { 
        /* Prevent redundant definition.                    */ 
        pk_chstruct_pmo_defined = OPC_TRUE; 
 
        wlan_pk_chstruct_pmh = op_prg_pmo_define ("wlan packet control header fields", sizeof (WlanT_Control_Header_Fields), 1); 

		/* Initialize the print procedure for the structures.       */
		op_pk_format_print_proc_set ("wlan_control", "Wlan Header", wlan_mac_pk_control_header_pkprint);		 
        } 
 
    pk_chstruct_ptr = (WlanT_Control_Header_Fields *) op_prg_pmo_alloc (wlan_pk_chstruct_pmh); 
 	if (pk_chstruct_ptr == OPC_NIL) 
		 { 
		 op_sim_end ("Error in wlan support code:", 
					 "Unable to allocate memory for wlan packet fields.", 
					 OPC_NIL, OPC_NIL); 
		 } 
 
    /*  Initialize all fields of the packet fields data structure   */ 
	 pk_chstruct_ptr->more_frag = 0; 
	 pk_chstruct_ptr->retry = 0; 
	 pk_chstruct_ptr->order = 0;
	 pk_chstruct_ptr->tods = 0;
	 pk_chstruct_ptr->fromds = 0;
	 pk_chstruct_ptr->duration = 0;		/* Duration for which the channel is contended 					*/
	 pk_chstruct_ptr->rx_addr = 0; 		/* Destination Address of the final recipient(s) of the frame.	*/
	 pk_chstruct_ptr->tx_addr = 0; 		/* Source Address from where the frame is originated.			*/
	 
    FRET (pk_chstruct_ptr); 
    }   
 
 
WlanT_Beacon_Body_Fields* 
wlan_mac_pk_bbstruct_create () 
    { 
    WlanT_Beacon_Body_Fields*          pk_bbstruct_ptr; 
     
    /**  Allocate memory for packet field structure and initialize   **/ 
    /**  all components of the data structure. "Pooled" memory is    **/ 
    /**  used to allocate wlan packet fields data structure          **/ 
    /**  allocation block since they are frequently created          **/ 
    /**  and destroyed.                                              **/ 
    FIN (wlan_mac_pk_bbstruct_create ()); 
 
    /*  If the pooled memory object has not yet been defined, do    */ 
    /*  so now, prior to allocation.                                */ 
    if (pk_bbstruct_pmo_defined == OPC_FALSE) 
        { 
        /* Prevent redundant definition.                    */ 
        pk_bbstruct_pmo_defined = OPC_TRUE; 
 
        wlan_pk_bbstruct_pmh = op_prg_pmo_define ("wlan packet beacon body fields", sizeof (WlanT_Beacon_Body_Fields), 1); 

		/* Initialize the print procedure for the structures.       */
		op_pk_format_print_proc_set ("wlan_beacon_body", "Beacon Body", wlan_mac_pk_beacon_body_pkprint);		 
        } 
 
    pk_bbstruct_ptr = (WlanT_Beacon_Body_Fields *) op_prg_pmo_alloc (wlan_pk_bbstruct_pmh); 
 	if (pk_bbstruct_ptr == OPC_NIL) 
		 { 
		 op_sim_end ("Error in wlan support code:", 
					 "Unable to allocate memory for wlan beacon body fields.", 
					 OPC_NIL, OPC_NIL); 
		 } 
 
    /*  Initialize all fields of the packet fields data structure   */ 
	 pk_bbstruct_ptr->timestamp = 0.0; 			/* Time stamp for becaon tx in secs								*/
	 pk_bbstruct_ptr->beacon_intv = 0.0; 		/* Beacon intervals in secs 									*/
	 pk_bbstruct_ptr->cf_par.cfp_count = 0;	
	 pk_bbstruct_ptr->cf_par.cfp_period = 0;
	 pk_bbstruct_ptr->cf_par.cfp_maxduration = 0;
	 pk_bbstruct_ptr->cf_par.cfp_durremaining = 0;			
	 
    FRET (pk_bbstruct_ptr); 
    } 



WlanT_Data_Header_Fields*
wlan_mac_pk_dhstruct_copy (WlanT_Data_Header_Fields* pk_dh_ptr)
    {
    WlanT_Data_Header_Fields*  copy_pk_dh_ptr;
 
    /**  Copy the packet field structure.    **/
    FIN (wlan_mac_pk_dhstruct_copy (pk_dh_ptr));
 
    /*  Allocate memeory for packet field structure and */
    /*  copy it.                                        */
    copy_pk_dh_ptr = (WlanT_Data_Header_Fields *) op_prg_pmo_alloc (wlan_pk_dhstruct_pmh);
 	if (copy_pk_dh_ptr == OPC_NIL)
		 {
		 op_sim_end ("Error in wlan support code:",
					 "Unable to allocate memory for copying wlan packet fields.",
					 OPC_NIL, OPC_NIL);
		 } 
	/* Copy frame control fields*/
    op_prg_mem_copy (pk_dh_ptr, copy_pk_dh_ptr, sizeof(WlanT_Data_Header_Fields));
 
    FRET (copy_pk_dh_ptr);
    } 
 

WlanT_Control_Header_Fields* 
wlan_mac_pk_chstruct_copy (WlanT_Control_Header_Fields* pk_ch_ptr) 
    { 
    WlanT_Control_Header_Fields*  copy_pk_ch_ptr; 
  
    /**  Copy the packet field structure.    **/ 
    FIN (wlan_mac_pk_chstruct_copy (pk_ch_ptr)); 
  
    /*  Allocate memeory for packet field structure and */ 
    /*  copy it.                                        */ 
    copy_pk_ch_ptr = (WlanT_Control_Header_Fields *) op_prg_pmo_alloc (wlan_pk_chstruct_pmh); 
 	if (copy_pk_ch_ptr == OPC_NIL) 
		 { 
		 op_sim_end ("Error in wlan support code:", 
					 "Unable to allocate memory for copying wlan packet fields.", 
					 OPC_NIL, OPC_NIL); 
		 } 
	/* Copy sequence control fields				*/ 
    op_prg_mem_copy (pk_ch_ptr, copy_pk_ch_ptr, sizeof(WlanT_Control_Header_Fields)); 
  
    FRET (copy_pk_ch_ptr); 
    }  
 
WlanT_Beacon_Body_Fields*
wlan_mac_pk_bbstruct_copy (WlanT_Beacon_Body_Fields* pk_bb_ptr)
    {
    WlanT_Beacon_Body_Fields*  copy_pk_bb_ptr;
 
    /**  Copy the packet field structure.    **/
    FIN (wlan_mac_pk_bbstruct_copy (pk_bb_ptr));
 
    /*  Allocate memeory for packet field structure and */
    /*  copy it.                                        */
    copy_pk_bb_ptr = (WlanT_Beacon_Body_Fields *) op_prg_pmo_alloc (wlan_pk_bbstruct_pmh);
 	if (copy_pk_bb_ptr == OPC_NIL)
		 {
		 op_sim_end ("Error in wlan support code:",
					 "Unable to allocate memory for copying wlan beacon body fields.",
					 OPC_NIL, OPC_NIL);
		 } 
	/* Copy frame control fields*/
    op_prg_mem_copy (pk_bb_ptr, copy_pk_bb_ptr, sizeof(WlanT_Beacon_Body_Fields));
 
    FRET (copy_pk_bb_ptr);
    } 

void
wlan_mac_pk_dhstruct_destroy (WlanT_Data_Header_Fields* pk_dhstruct_ptr)
    {
    /**  Deallocate the packet structure memory.     **/
    FIN (wlan_mac_pk_dhstruct_destroy (pk_dhstruct_ptr));
     
	/* Destroy frame control field structure         */
    op_prg_mem_free (pk_dhstruct_ptr);
    
    FOUT;
    } 
 

void 
wlan_mac_pk_chstruct_destroy (WlanT_Control_Header_Fields* pk_chstruct_ptr) 
    { 
    /*  Deallocate the packet structure memory.     */ 
    FIN (wlan_mac_pk_chstruct_destroy (pk_chstruct_ptr)); 
	 
	/* Destroy frame control field structure         */     
    op_prg_mem_free (pk_chstruct_ptr); 
     
    FOUT; 
    } 


void
wlan_mac_pk_bbstruct_destroy (WlanT_Beacon_Body_Fields* pk_bbstruct_ptr)
    {
    /**  Deallocate the packet structure memory.     **/
    FIN (wlan_mac_pk_bbstruct_destroy (pk_bbstruct_ptr));
     
	/* Destroy frame control field structure         */
    op_prg_mem_free (pk_bbstruct_ptr);
    
    FOUT;
    } 


void
wlan_mac_pk_data_header_pkprint (void* structure_ptr, PrgT_List* output_list)
	{
	char		temp_str[128];
	char*		alloc_str;
	WlanT_Data_Header_Fields* pk_dh_ptr;
	/** Called as part of a packet print, this procedure will	**/
	/** place the contents of the "fields" structure into a		**/
	/** printed list.											**/
	FIN (wlan_mac_pk_data_header_pkprint (structure_ptr, output_list));

    pk_dh_ptr = (WlanT_Data_Header_Fields *) structure_ptr;

	sprintf(temp_str, "      more_frag           int         %-16d(1)", pk_dh_ptr->more_frag);
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)

	sprintf(temp_str, "      retry               int         %-16d(1)", pk_dh_ptr->retry);
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)

	sprintf(temp_str, "      order               int         %-16d(1)", pk_dh_ptr->order);
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)

	sprintf(temp_str, "      tods               int         %-16d(1)", pk_dh_ptr->tods);
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)

	sprintf(temp_str, "      fromds               int         %-16d(1)", pk_dh_ptr->fromds);
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)

	sprintf(temp_str, "      duration            double         %-16.6f(16)", pk_dh_ptr->duration);
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)

	sprintf(temp_str, "      address1            int         %-16d(48)", pk_dh_ptr->address1);
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)

	sprintf(temp_str, "      address2            int       %-16d(48)", pk_dh_ptr->address2);
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)

	sprintf(temp_str, "      address3            int       %-16d(48)", pk_dh_ptr->address3);	
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)

	sprintf(temp_str, "      fragment_number     int       %-16d(32)", pk_dh_ptr->fragment_number);	
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)

	sprintf(temp_str, "      sequence_number     int       %-16d(96)", pk_dh_ptr->sequence_number);	
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)

	sprintf(temp_str, "      address4 (omitted)  int       %-16d(0)", pk_dh_ptr->address4);	
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)		
		
	sprintf(temp_str, "      more_data           int         %-16d(1)", pk_dh_ptr->more_data);
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)
		
	FOUT;
	}

void
wlan_mac_pk_control_header_pkprint (void* structure_ptr, PrgT_List* output_list)
	{
	char		temp_str[128];
	char*		alloc_str;
	WlanT_Control_Header_Fields* pk_ch_ptr;
	/** Called as part of a packet print, this procedure will	**/
	/** place the contents of the "fields" structure into a		**/
	/** printed list.											**/
	FIN (wlan_mac_pk_control_header_pkprint (structure_ptr, output_list));

	pk_ch_ptr = (WlanT_Control_Header_Fields* ) structure_ptr;

	sprintf(temp_str, "      more_frag           int         %-16d(1)", pk_ch_ptr->more_frag);
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)

	sprintf(temp_str, "      retry               int         %-16d(1)", pk_ch_ptr->retry);
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)

	sprintf(temp_str, "      order               int         %-16d(1)", pk_ch_ptr->order);
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)

	sprintf(temp_str, "      duration            double         %-16.6f(16)", pk_ch_ptr->duration);
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)

	sprintf(temp_str, "     rx_addr              int         %-16d(48)", pk_ch_ptr->rx_addr);
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)

	sprintf(temp_str, "      tx_addr             int       %-16d(48)", pk_ch_ptr->tx_addr);
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)
		
	FOUT;
	}

void
wlan_mac_pk_beacon_body_pkprint (void* structure_ptr, Prg_List* output_list)
	{
	char		temp_str[128];
	char*		alloc_str;
	WlanT_Beacon_Body_Fields* pk_bb_ptr;
	/** Called as part of a packet print, this procedure will	**/
	/** place the contents of the "fields" structure into a		**/
	/** printed list.											**/
	FIN (wlan_mac_pk_beacon_body_pkprint (structure_ptr, output_list));

	pk_bb_ptr = (WlanT_Beacon_Body_Fields* ) structure_ptr;

	sprintf(temp_str, "      timestamp               double      %-16.6f(16)", pk_bb_ptr->timestamp);
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)

	sprintf(temp_str, "      beacon interval         double      %-16.6f(16)", pk_bb_ptr->beacon_intv);
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)

	sprintf(temp_str, "      CFP count               int         %-16d(1)", pk_bb_ptr->cf_par.cfp_count);
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)

	sprintf(temp_str, "      CFP period              int         %-16d(1)", pk_bb_ptr->cf_par.cfp_period);
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)

	sprintf(temp_str, "      CFP Max Duration        double      %-16.6f(16)", pk_bb_ptr->cf_par.cfp_maxduration);
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)

	sprintf(temp_str, "      CFP Duration Remaining  double      %-16.6f(16)", pk_bb_ptr->cf_par.cfp_durremaining);
	PKPRINT_STRING_INSERT (alloc_str, temp_str, output_list)
		
	FOUT;
	}


