/* bt_wlan_rxgroup.ps.c */                                                       
/* Modified receiver group model for IEEE802.11 			*/
/* This routine is part of radio link Transceiver Pipeline 	*/


/****************************************/
/*	   Copyright (c) 1993 - 2002		*/
/*		by OPNET Technologies, Inc.		*/
/*		(A Delaware Corporation)		*/
/*	7255 Woodmont Av., Suite 250  		*/
/*     Bethesda, MD 20814, U.S.A.       */
/*			All Rights Reserved.		*/
/****************************************/

/* Modif. O. Rebala for Bluetooth devices */

#include <opnet.h>

#if defined (__cplusplus)
extern "C"
#endif
int
bt_wlan_rxgroup (Objid tx_ch_objid, Objid rx_ch_objid)	
	{
	Objid       tx_node_obid, rx_node_obid;
	double		tx_data_rate = 0.0;
	double		rx_data_rate = 0.0;
	char		tx_model_name[128];
	char        rx_model_name[128];
	char		tx_node_name[128];
	char        rx_node_name[128];
	int			rx_piconet, tx_piconet;


	/** Determine the potential for communication between	**/
	/** given transmitter and receiver channel objects.		**/
	FIN (wlan_rxgroup (tx_ch_objid, rx_ch_objid));
	
    tx_node_obid =  op_topo_parent (op_topo_parent (op_topo_parent (tx_ch_objid))); 
	rx_node_obid =  op_topo_parent (op_topo_parent (op_topo_parent (rx_ch_objid)));

    /* Station should not hear its own transmission.	*/
	if (tx_node_obid == rx_node_obid)
		{
		FRET (OPC_FALSE);
    	}
 
   	/* Only stations in the same subnet will receive the packet.	*/ 
   	if (op_topo_parent (tx_node_obid) != op_topo_parent (rx_node_obid))
		{
		FRET (OPC_FALSE);
		}

	/* Check for the same data rate for transmitter-receiver pairs. Mismatching	*/
	/* data rates, otherwise, would have been discarded during channal match.	*/
	op_ima_obj_attr_get (tx_ch_objid, "data rate", &tx_data_rate);
	op_ima_obj_attr_get (rx_ch_objid, "data rate", &rx_data_rate);
	
	if (tx_data_rate != rx_data_rate)
		{
		FRET (OPC_FALSE);
		}

	/* Get the name of the model of the node */
	op_ima_obj_attr_get (tx_node_obid, "model", tx_model_name);
	op_ima_obj_attr_get (rx_node_obid, "model", rx_model_name);
	op_ima_obj_attr_get (tx_node_obid, "name", tx_node_name);
	op_ima_obj_attr_get (rx_node_obid, "name", rx_node_name);
	
	
	/* Check if the transmitter node is a bluetooth node */
	if ( strcmp(tx_model_name, "custom_wlan_server") &&
		 strcmp (tx_model_name, "custom_wlan_wkstn") )
		{
		FRET(OPC_FALSE);
		}
	else
		op_ima_obj_attr_get (tx_node_obid, "MAC : piconet", &tx_piconet);
	
	/* Check if the receiver node is a bluetooth node */
	if ( strcmp(rx_model_name, "custom_wlan_server") &&
		 strcmp (rx_model_name, "custom_wlan_wkstn") )
		{
		FRET(OPC_FALSE);
		}
	else
		op_ima_obj_attr_get (rx_node_obid, "MAC : piconet", &rx_piconet);
	
	
	if (tx_piconet != rx_piconet)
		{
		FRET(OPC_FALSE);
		}
	
	
	printf ("\n|**************************************|\n");
	printf ("|**  Pipeline stage \"WLAN\"\n");
	printf ("|**  Couple selected :\n");
	printf ("|**  RX:\"%s\" and TX:\"%s\"\n", rx_node_name, tx_node_name);
	printf ("|**************************************|\n");
	
	/* This is a eligible receiver; return TRUE. */
	FRET (OPC_TRUE);
	}                
