/*
** bt_stats_write.h :
**
** Bluetooth model in Opnet
** National Institute of Standards and Technology
**
** This model was developed at the National Institute of Standards
** and Technology by employees of the Federal Government in the course
** of their official duties. Pursuant to title 17 Section 105 of the
** United States Code this software is not subject to copyright
** protection and is in the public domain. This is an experimental
** system.  NIST assumes no responsibility whatsoever for its use by
** other parties, and makes no guarantees, expressed or implied,
** about its quality, reliability, or any other characteristic.
**
** We would appreciate acknowledgement if the model is used.
**
** NIST ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION
** AND DISCLAIM ANY LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER
** RESULTING FROM THE USE OF THIS SOFTWARE.
**
** Primary Author:      Olivier Rebala
** Module description:  Bluetooth Common MAC Function Support
** Last Modification:   July, 24th 2002
*/

#ifndef	__BT_STATS_WRITE_H__
#define	__BT_STATS_WRITE_H__

/* Standards include */
#include <opnet.h>
#include "topo_discovery.h"

/* declare some structures to store the tcp and udp statistics */
typedef struct bt_TCP_stats_write
{
	Objid						objid;
	double						delay;
	double						bytes;
	int							nb_packet;
	struct bt_TCP_stats_write *	next;
} bt_TCP_stats;

typedef struct bt_UDP_stats_write
{
	Objid						objid;
	double						bytes;
	int							nb_packet;
	struct bt_UDP_stats_write *	next;
} bt_UDP_stats;

/* Declare some pointers to these structures */
bt_TCP_stats *	bt_tcp_stats_write;
bt_UDP_stats *  bt_udp_stats_write;

/* function prototypes */
void			bt_stats_error (char * fcnt, char * msg, char * opt);
char *			bt_stats_read_path (Objid process_id);
bt_TCP_stats *	bt_stats_init_tcp_structure ();
bt_UDP_stats *	bt_stats_init_udp_structure ();
void			bt_stats_update_tcp_stats (double delay, double bytes, int nb_packet);
void			bt_stats_update_udp_stats (double bytes, int nb_packet);
bt_TCP_stats *	bt_stats_get_tcp_stats ();
bt_UDP_stats *	bt_stats_get_udp_stats ();
void			bt_stats_tcp_end_of_simulation ();
void			bt_stats_udp_end_of_simulation ();
void			bt_stats_get_file_name (const char * file_name, const char * line1, const char * line2);
char *			bt_stats_get_report_name (const char * name_of_file);
void			bt_stats_print_report (const char * file_name, const char * header, const char * data, Boolean only_one_header);


#endif /* end of __BT_STATS_WRITE_H__ */