/* bt_rxgroup.ps.c */                                                       
/* Modified receiver group model for IEEE802.11 			*/

#include <opnet.h>

#if defined (__cplusplus)
extern "C"
#endif
	
int
bt_rxgroup (Objid tx_ch_objid, Objid rx_ch_objid)	
	{
	Objid       tx_node_obid, rx_node_obid;
	double		tx_data_rate = 0.0;
	double		rx_data_rate = 0.0;
	char		tx_model_name[128];
	char        rx_model_name[128];
	char		tx_node_name[128];
	char		rx_node_name[128];
	int			rx_piconet, tx_piconet;
	

	/** Determine the potential for communication between	**/
	/** given transmitter and receiver channel objects.		**/
	FIN (bt_rxgroup (tx_ch_objid, rx_ch_objid));
	
    tx_node_obid =  op_topo_parent (op_topo_parent (op_topo_parent (tx_ch_objid))); 
	rx_node_obid =  op_topo_parent (op_topo_parent (op_topo_parent (rx_ch_objid)));

    /* Station should not hear its own transmission.	*/
	if (tx_node_obid == rx_node_obid)
		{
		FRET (OPC_FALSE);
    	}
 
   	/* Only stations in the same subnet will receive the packet.	*/ 
   	if (op_topo_parent (tx_node_obid) != op_topo_parent (rx_node_obid))
		{
		FRET (OPC_FALSE);
		}
	
	/* Get the name of the model of the node */
	op_ima_obj_attr_get (tx_node_obid, "model", tx_model_name);
	op_ima_obj_attr_get (rx_node_obid, "model", rx_model_name);
	op_ima_obj_attr_get (tx_node_obid, "name", tx_node_name);
	op_ima_obj_attr_get (rx_node_obid, "name", rx_node_name);
	
	
	/* Check if the transmitter node is a bluetooth node */
	if ( strcmp(tx_model_name, "device_master_ip") &&
		 strcmp (tx_model_name, "device_slave_ip") )
		{
		FRET(OPC_FALSE);
		}
	else
		{
		op_ima_obj_attr_get (tx_node_obid, "Piconet number", &tx_piconet);
		}
	
	/* Check if the receiver node is a bluetooth node */
	if ( strcmp(rx_model_name, "device_master_ip") &&
		 strcmp (rx_model_name, "device_slave_ip") )
		{
		FRET(OPC_FALSE);
		}
	else
		{
		op_ima_obj_attr_get (rx_node_obid, "Piconet number", &rx_piconet);
		}
	
	/* Check if the receiver and the transmitter node belong to the same piconet */
	if (rx_piconet != tx_piconet)
		{
		FRET(OPC_FALSE);
		}

	printf ("\n|**************************************|\n");
	printf ("|**  Pipeline stage \"Bluetooth\"\n");
	printf ("|**  Couple selected :\n");
	printf ("|**  RX:\"%s\" and TX:\"%s\"\n", rx_node_name, tx_node_name);
	printf ("|**************************************|\n");

	/* This is a eligible receiver; return TRUE. */
	FRET (OPC_TRUE);
	}                
