/* Process model C form file: bt_rip_udp_v3.pr.c */
/* Portions of this file copyright 1992-2002 by OPNET Technologies, Inc. */



/* This variable carries the header into the object file */
static const char bt_rip_udp_v3_pr_c [] = "MIL_3_Tfile_Hdr_ 81A 30A op_runsim 7 3E25C666 3E25C666 1 skydiver rebala 0 0 none none 0 0 none 0 0 0 0 0 0                                                                                                                                                                                                                                                                                                                                                                                                                    ";
#include <string.h>



/* OPNET system definitions */
#include <opnet.h>

#if defined (__cplusplus)
extern "C" {
#endif
FSM_EXT_DECS
#if defined (__cplusplus)
} /* end of 'extern "C"' */
#endif


/* Header Block */

#include <udp_api.h>
#include <oms_pr.h>
#include <oms_tan.h>
#include <ip_addr_v4.h>
#include <llm_support.h>
#include <ip_with_rip_v3.h>
#include <rip_notif_log_support.h>
#include <udp_dgram_sup.h>
#include <ip_higher_layer_proto_reg_sup.h>
#include "bt_stats_write.h"

/* Stream indices for interface to network layer. */
#define UDPC_INSTRM_NETWORK				0
#define UDPC_OUTSTRM_NETWORK			0

/***** Macros *****/

/***** Typedefs *****/

/* UdpT_Tcb : Transmission Control Block */
typedef struct
	{
	/* Application and connection identification information. */
	Objid				app_objid;
	int					strm_index;

	/* Socket information. */
	UdpT_Port			local_port;

	} UdpT_Tcb;

/* Transition macros */
#define CREATE			((intrpt_type == OPC_INTRPT_REMOTE) &&			\
						(intrpt_code == UDPC_COMMAND_CREATE_PORT))
#define SEND			((intrpt_type == OPC_INTRPT_STRM) && 			\
						(intrpt_strm !=	input_strm))
#define DGRAM_ARRIVAL	((intrpt_type == OPC_INTRPT_STRM) &&			\
						(intrpt_strm == input_strm))

static UdpT_Tcb*	udp_tcb_from_port ();
static void			udp_lan_handle_get ();
static void			udp_warn (const char* msg0, const char* msg1, const char* msg2);

/* End of Header Block */


#if !defined (VOSD_NO_FIN)
#undef	BIN
#undef	BOUT
#define	BIN		FIN_LOCAL_FIELD(last_line_passed) = __LINE__ - _block_origin;
#define	BOUT	BIN
#define	BINIT	FIN_LOCAL_FIELD(last_line_passed) = 0; _block_origin = __LINE__;
#else
#define	BINIT
#endif /* #if !defined (VOSD_NO_FIN) */



/* State variable definitions */
typedef struct
	{
	/* Internal state tracking for FSM */
	FSM_SYS_STATE
	/* State Variables */
	List*	                  		tcb_list;
	Ici*	                   		net_ici_ptr;
	Ici*	                   		app_ici_ptr;
	int	                    		udp_trace_active;
	int	                    		port_id_new;
	Objid	                  		own_mod_objid;
	Objid	                  		own_node_objid;
	Prohandle	              		own_prohandle;
	OmsT_Pr_Handle	         		own_process_record_handle;
	char	                   		proc_model_name[20];
	LlmT_Lan_Handle	        		my_lanhandle;
	Boolean	                		lan_node;
	int	                    		sess_svr_id;
	int	                    		sess_wkstn_id;
	int	                    		input_strm;
	int	                    		output_strm;
	Stathandle	             		sent_packet_sec_handle;
	Stathandle	             		sent_byte_sec_handle;
	Stathandle	             		receive_packet_sec_handle;
	Stathandle	             		receive_byte_sec_handle;
	} bt_rip_udp_v3_state;

#define pr_state_ptr            		((bt_rip_udp_v3_state*) SimI_Mod_State_Ptr)
#define tcb_list                		pr_state_ptr->tcb_list
#define net_ici_ptr             		pr_state_ptr->net_ici_ptr
#define app_ici_ptr             		pr_state_ptr->app_ici_ptr
#define udp_trace_active        		pr_state_ptr->udp_trace_active
#define port_id_new             		pr_state_ptr->port_id_new
#define own_mod_objid           		pr_state_ptr->own_mod_objid
#define own_node_objid          		pr_state_ptr->own_node_objid
#define own_prohandle           		pr_state_ptr->own_prohandle
#define own_process_record_handle		pr_state_ptr->own_process_record_handle
#define proc_model_name         		pr_state_ptr->proc_model_name
#define my_lanhandle            		pr_state_ptr->my_lanhandle
#define lan_node                		pr_state_ptr->lan_node
#define sess_svr_id             		pr_state_ptr->sess_svr_id
#define sess_wkstn_id           		pr_state_ptr->sess_wkstn_id
#define input_strm              		pr_state_ptr->input_strm
#define output_strm             		pr_state_ptr->output_strm
#define sent_packet_sec_handle  		pr_state_ptr->sent_packet_sec_handle
#define sent_byte_sec_handle    		pr_state_ptr->sent_byte_sec_handle
#define receive_packet_sec_handle		pr_state_ptr->receive_packet_sec_handle
#define receive_byte_sec_handle 		pr_state_ptr->receive_byte_sec_handle

/* This macro definition will define a local variable called	*/
/* "op_sv_ptr" in each function containing a FIN statement.	*/
/* This variable points to the state variable data structure,	*/
/* and can be used from a C debugger to display their values.	*/
#undef FIN_PREAMBLE
#define FIN_PREAMBLE	bt_rip_udp_v3_state *op_sv_ptr = pr_state_ptr;


/* Function Block */

enum { _block_origin = __LINE__ };
static UdpT_Tcb*
udp_tcb_from_port (UdpT_Port loc_port) 
	{
	UdpT_Tcb*			tcb_ptr;
	int					i, list_size;

	/** Find the TCB with the given port number			**/
	/** in the TCB list.  Returns a pointer to the TCB 	**/
	/** record, or NIL if no match is found.			**/
	FIN (udp_tcb_from_port (loc_port))

	list_size = op_prg_list_size (tcb_list);
	for (i = 0; i < list_size; i++)
		{
		tcb_ptr = (UdpT_Tcb *) op_prg_list_access (tcb_list, i);
		if (loc_port == tcb_ptr->local_port)
			{
			break;
			}
		}
	if (i == list_size)
		tcb_ptr = OPC_NIL;

	FRET (tcb_ptr)
	}

static void
udp_lan_handle_get ()
	{
	List*			proc_record_handle_list_ptr;
	int				record_handle_list_size;
	OmsT_Pr_Handle	proc_record_handle;
	double			server_id;

	/**	This function obtains lan handle if it is a LAN node.	**/
	FIN (udp_lan_handle_get ());

	/*	Find out the node type from model wide process registry */
	proc_record_handle_list_ptr = op_prg_list_create ();

	oms_pr_process_discover (OPC_OBJID_INVALID, proc_record_handle_list_ptr, 
			"node objid",	OMSC_PR_OBJID,		own_node_objid, 
			"node_type", 	OMSC_PR_STRING, 	"lan_mac", 
			OPC_NIL);

	/*	Obtain the list size of the discovered processes.		*/
	record_handle_list_size = op_prg_list_size (proc_record_handle_list_ptr);
	
	if (record_handle_list_size == 1)
		{
		/*	Set a flag indicating that this is a LAN node.		*/
		lan_node = OPC_TRUE;

		/*	Obtain total number of workstations in this node.	*/
		/*	This is equal to the server id.						*/
		proc_record_handle = 
			(OmsT_Pr_Handle) op_prg_list_access (proc_record_handle_list_ptr, OPC_LISTPOS_HEAD);
		
		oms_pr_attr_get (proc_record_handle, "wkstn count", OMSC_PR_NUMBER, &server_id);
		
		sess_svr_id = (int) server_id;

		/*	Obtain lan handle from llm package.					*/
		my_lanhandle = llm_lan_handle_get (own_node_objid);
		}
	
	/* 	Deallocate no longer needed process registry 		*/
	/*	information.										*/
	while (op_prg_list_size (proc_record_handle_list_ptr))
		op_prg_list_remove (proc_record_handle_list_ptr, OPC_LISTPOS_HEAD);
	
	op_prg_mem_free (proc_record_handle_list_ptr);
	
	FOUT;
	}

static void
udp_warn (const char * msg0, const char * msg1, const char * msg2)
	{
	/** Print a warning message and resume. **/
	FIN (udp_warn (msg0, msg1, msg2));

	op_prg_odb_print_major ("Warning from UDP socket process (rip_udp_v3):",
		msg0, msg1, msg2, OPC_NIL);

	FOUT;
	}

/* End of Function Block */

/* Undefine optional tracing in FIN/FOUT/FRET */
/* The FSM has its own tracing code and the other */
/* functions should not have any tracing.		  */
#undef FIN_TRACING
#define FIN_TRACING

#undef FOUTRET_TRACING
#define FOUTRET_TRACING

#if defined (__cplusplus)
extern "C" {
#endif
	void bt_rip_udp_v3 (void);
	Compcode bt_rip_udp_v3_init (void **);
	void bt_rip_udp_v3_diag (void);
	void bt_rip_udp_v3_terminate (void);
	void bt_rip_udp_v3_svar (void *, const char *, char **);
#if defined (__cplusplus)
} /* end of 'extern "C"' */
#endif




/* Process model interrupt handling procedure */


void
bt_rip_udp_v3 (void)
	{
	int _block_origin = 0;
	FIN (bt_rip_udp_v3 ());
	if (1)
		{
		int				intrpt_type;
		int				intrpt_strm;
		int				intrpt_code;
		Ici*			ici_ptr;
		Ici*			intf_ici_ptr;
		Objid			strm_objid;
		
		UdpT_Port		local_port;
		IpT_Address		rem_addr;
		IpT_Address		intf_addr;
		int				type_of_service; 
		
		UdpT_Port		rem_port;
		int				strm_index;
		
		int				i;
		int				list_size;
		
		UdpT_Tcb*		tcb_ptr;
		
		char			msg0 [512], msg1 [512];
		
		int				port_assigned;
		
		Packet*			pkptr;
		Packet*			data_pkptr;
		
		int					conn_class;
		UdpT_Dgram_Fields*	udp_dgram_fd_ptr;
		
		int				higher_layer_protocol_type;
		int				intf_num;
		/* used for discover lower layer module ip_encap */
		List*			proc_record_handle_list_ptr;
		OmsT_Pr_Handle	process_record_handle;
		Objid			neighbor_mod_objid;
		
		/* used for collection of UDP statistics */
		double pk_size;
		double byte_load;


		FSM_ENTER (bt_rip_udp_v3)

		FSM_BLOCK_SWITCH
			{
			/*---------------------------------------------------------*/
			/** state (init) enter executives **/
			FSM_STATE_ENTER_UNFORCED_NOLABEL (0, "init", "bt_rip_udp_v3 () [init enter execs]")
				{
				
				/* Initialize the simulation notification log.	*/
				rip_notification_log_init ();
				
				tcb_list = op_prg_list_create ();
				
				net_ici_ptr = op_ici_create ("ip_encap_req_v4");
				app_ici_ptr = op_ici_create ("udp_command_v3");
				
				/* when assigning ports, start at lowest unreserved port */
				port_id_new = 255;
				
				/* Obtain the udp module's objid. */
				own_mod_objid = op_id_self ();
				
				/* Obtain the node's objid. */
				own_node_objid = op_topo_parent (own_mod_objid);
				
				/* Obtain the udp process's prohandle. */
				own_prohandle = op_pro_self ();
				
				/* Obtain the name of the process. It is the "process model" attribute of the module. */
				op_ima_obj_attr_get (own_mod_objid, "process model", proc_model_name);
				
				/* Register the process in the model-wide registry. */
				own_process_record_handle = (OmsT_Pr_Handle) oms_pr_process_register (own_node_objid, own_mod_objid, 
											own_prohandle, proc_model_name);
				
				/* Register the protocol attribute in the registry. */
				oms_pr_attr_set (own_process_record_handle, "protocol", OMSC_PR_STRING, "udp", OPC_NIL);
				
				/** Register this higher layer protocol with the label	**/
				/** "udp" and id IpC_Protocol_Udp.						**/
				
				/* Set the protocol type.							*/
				higher_layer_protocol_type = IpC_Protocol_Udp;
				
				/* Register this higher layer protocol label with	*/
				/* the given higher layer protocol type.			*/
				Ip_Higher_Layer_Protocol_Register ("udp", &higher_layer_protocol_type);
				
				/*	Initialize variable used to store lan level 	*/
				/*	model information.								*/
				lan_node 			= OPC_FALSE;
				sess_wkstn_id		= LlmC_Unspec_Wkstn_Id;
				sess_svr_id			= LlmC_Unspec_Wkstn_Id;	
				
				/* Schedule a self interrupt for ip_encap to register */
				op_intrpt_schedule_self (op_sim_time (), 0);
				
				/* Register stat handles */
				sent_packet_sec_handle		= op_stat_reg ("UDP.Traffic Sent (Packets/Sec)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
				sent_byte_sec_handle		= op_stat_reg ("UDP.Traffic Sent (Bytes/Sec)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
				receive_packet_sec_handle	= op_stat_reg ("UDP.Traffic Received (Packets/Sec)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
				receive_byte_sec_handle		= op_stat_reg ("UDP.Traffic Received (Bytes/Sec)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
				}


			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (1,bt_rip_udp_v3)


			/** state (init) exit executives **/
			FSM_STATE_EXIT_UNFORCED (0, "init", "bt_rip_udp_v3 () [init exit execs]")
				{
				/* Find the stream index connect this module to lower layer	*/
				/* module - which is udp. Obtain the process registry for  	*/
				/* the udp process model in this node						*/
				proc_record_handle_list_ptr = op_prg_list_create ();
				oms_pr_process_discover (OPC_OBJID_INVALID, proc_record_handle_list_ptr,
					"node objid",	OMSC_PR_OBJID,		own_node_objid,
					"protocol",		OMSC_PR_STRING,		"ip_encap",
					OPC_NIL);
				
				/* Assume there is only one ip_encap module in the node 	*/
				/* Get the process record handle for the udp process model	*/
				process_record_handle = (OmsT_Pr_Handle) op_prg_list_access (proc_record_handle_list_ptr, OPC_LISTPOS_HEAD);
				
				/* Obtain the module object id of the ip_encap.				*/
				oms_pr_attr_get (process_record_handle, "module objid", OMSC_PR_OBJID, &neighbor_mod_objid);
						
				/* Determine the input and output stream indices.			*/
				oms_tan_neighbor_streams_find (own_mod_objid, neighbor_mod_objid, &input_strm, &output_strm);
				
				/* Deallocate the registry list pointer.					*/
				op_prg_mem_free (proc_record_handle_list_ptr);
				}


			/** state (init) transition processing **/
			FSM_TRANSIT_FORCE (1, state1_enter_exec, ;, "default", "", "init", "idle")
				/*---------------------------------------------------------*/



			/** state (idle) enter executives **/
			FSM_STATE_ENTER_UNFORCED (1, state1_enter_exec, "idle", "bt_rip_udp_v3 () [idle enter execs]")
				{
				}


			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (3,bt_rip_udp_v3)


			/** state (idle) exit executives **/
			FSM_STATE_EXIT_UNFORCED (1, "idle", "bt_rip_udp_v3 () [idle exit execs]")
				{
				/* gather information relevant to the current interrupt */   
				udp_trace_active = op_prg_odb_ltrace_active ("udp");
				
				intrpt_type = op_intrpt_type ();
				if (intrpt_type == OPC_INTRPT_STRM)
					intrpt_strm = op_intrpt_strm ();
				else
					intrpt_code = op_intrpt_code ();
				ici_ptr = op_intrpt_ici ();
				}


			/** state (idle) transition processing **/
			FSM_INIT_COND (CREATE)
			FSM_TEST_COND (SEND)
			FSM_TEST_COND (DGRAM_ARRIVAL)
			FSM_TEST_LOGIC ("idle")

			FSM_TRANSIT_SWITCH
				{
				FSM_CASE_TRANSIT (0, 2, state2_enter_exec, ;, "CREATE", "", "idle", "CREATE")
				FSM_CASE_TRANSIT (1, 3, state3_enter_exec, ;, "SEND", "", "idle", "SEND")
				FSM_CASE_TRANSIT (2, 4, state4_enter_exec, ;, "DGRAM_ARRIVAL", "", "idle", "ARRIVE")
				}
				/*---------------------------------------------------------*/



			/** state (CREATE) enter executives **/
			FSM_STATE_ENTER_FORCED (2, state2_enter_exec, "CREATE", "bt_rip_udp_v3 () [CREATE enter execs]")
				{
				/* Read the arguments to the CREATE_PORT command. */
				op_ici_attr_get (ici_ptr, "strm_index", &strm_index);
				op_ici_attr_get (ici_ptr, "local_port", &local_port);
				
				/* Find the preexisting TCB for this port, if any.				*/
				/* If none exists, create a new TCB and add it to the			*/
				/* list.  If the port id is unspecified, assign a free port.	*/
				
				if (udp_tcb_from_port (local_port) != OPC_NIL)
					{
					/* A port with the given id is already assigned. */
					/* Return an error status code to the application. */
					if (udp_trace_active)
						op_prg_odb_print_minor ("Port assignment already exists.", OPC_NIL);
				
					/* Generate a simulation log message. */
					udp_port_err_log_write (local_port);
				
					op_ici_attr_set (ici_ptr, "status", UDPC_IND_EADDRINUSE);
					}
				
				else
					{
					if (local_port == UDPC_PORT_UNSPEC)
						/* No port was specified. */
						{
						/** determine an unassigned port. **/
						port_assigned = 1;
						while (port_assigned == 1)
							{
							if (udp_tcb_from_port (port_id_new++) == OPC_NIL)
								port_assigned = 0;
							}
						local_port = port_id_new;
						}
				
					/* If no stream index has been specified, pick a logical one. */
					if (strm_index == UDPC_STRM_INDEX_UNSPEC)
						{
						strm_objid = op_topo_connect (op_id_self (), op_intrpt_source (),
							OPC_OBJTYPE_STRM, 0);
						if (strm_objid == OPC_OBJID_INVALID)
							{
							/* Generate a simulation log message before ending the simulation. */
							udp_conf_err_log_write ();
				
							op_sim_end ("Illegal UDP CREATE_PORT command",
								"No stream connection exists from UDP process to application.", "", "");
							}
						else
							{
							op_ima_obj_attr_get (strm_objid, "src stream", &strm_index);
							op_ici_attr_set (ici_ptr, "strm_index", strm_index);
							}
						}
				
					/* This is a new port registration.			*/
					/* Create a new TCB and add it to the list. */
					tcb_ptr = (UdpT_Tcb *) op_prg_mem_alloc (sizeof (UdpT_Tcb));
					tcb_ptr->app_objid = op_intrpt_source ();
					tcb_ptr->strm_index = strm_index;
					tcb_ptr->local_port = local_port;
					op_prg_list_insert (tcb_list, tcb_ptr, OPC_LISTPOS_TAIL);
					
					/* Return a successful status code to the application. */
					op_ici_attr_set (ici_ptr, "status", UDPC_IND_SUCCESS);
					}
				
				/*	Obtain lan handle if this is a LAN node.	*/
				udp_lan_handle_get ();
				
				/*	Check if the node is LAN node.				*/
				if (lan_node == OPC_TRUE)
					{
					/*	This is a LAN node.	"Create" command is	*/		
					/*	issued either by client or server 		*/
					/*	(local port is 520 if "Create" command	*/
					/*	 is issued by RIP.)						*/
					if (local_port != 520)
						{
						/*	Get remote port from the ici.		*/
						op_ici_attr_get (ici_ptr, "rem_port", &rem_port);
				
						/*	Check if Create command is received 	*/
						/*	from server or client.					*/
						if (rem_port == -1)
							{
							/*	This command is received from the server.*/
							sess_wkstn_id = sess_svr_id;
							}
						else
							{
							sess_wkstn_id = LlmC_Unspec_Wkstn_Id;
							}
				
						/*	Register information about the	*/
						/*	new udp connection process.		*/
						if (llm_trans_new_session (my_lanhandle, &sess_wkstn_id, rem_port, local_port) == OPC_COMPCODE_FAILURE)
							{
							/* Generate a simulation log message.	*/
							udp_llm_low_level_log_write ();
							udp_warn ("Unable to create UDP connection record in the Transport Connection Table", OPC_NIL, OPC_NIL);
							}
						}
					}
				
				}


			/** state (CREATE) exit executives **/
			FSM_STATE_EXIT_FORCED (2, "CREATE", "bt_rip_udp_v3 () [CREATE exit execs]")
				{
				}


			/** state (CREATE) transition processing **/
			FSM_TRANSIT_FORCE (1, state1_enter_exec, ;, "default", "", "CREATE", "idle")
				/*---------------------------------------------------------*/



			/** state (SEND) enter executives **/
			FSM_STATE_ENTER_FORCED (3, state3_enter_exec, "SEND", "bt_rip_udp_v3 () [SEND enter execs]")
				{
				/** Encapsulate the data packet in the UDP datagram **/
				/** and send to the lower layer. **/ 
				
				data_pkptr = op_pk_get (intrpt_strm);
				
				op_ici_attr_get (ici_ptr, "rem_addr", &rem_addr);
				 
				op_ici_attr_get (ici_ptr, "rem_port", &rem_port);
				op_ici_attr_get (ici_ptr, "local_port", &local_port);
				op_ici_attr_get (ici_ptr, "connection_class", &conn_class);
				op_ici_attr_get (ici_ptr, "Type of Service", &type_of_service);
				
				/* Using the "strm_index" to identify the outgoing IP interface	*/
				/* to allow sending multicast by setting multicast major port	*/
				op_ici_attr_get (ici_ptr, "strm_index", &intf_num);
				
				/* Create and format the UDP datagram. */
				pkptr = op_pk_create_fmt ("udp_dgram_v2");
				op_pk_nfd_set (pkptr, "data", data_pkptr);
				 
				udp_dgram_fd_ptr = udp_dgram_fdstruct_create ();
				udp_dgram_fd_ptr->src_port = local_port;
				udp_dgram_fd_ptr->dest_port = rem_port;
				udp_dgram_fd_ptr->length =  op_pk_total_size_get (pkptr);
				
				op_pk_nfd_set (pkptr, "fields", udp_dgram_fd_ptr, udp_dgram_fdstruct_copy, udp_dgram_fdstruct_destroy, sizeof (UdpT_Dgram_Fields)); 
				
				/* Compute total size of packet in bits, and from that	*/
				/* Compute the byte size of this packet.				*/
				pk_size = (double) udp_dgram_fd_ptr->length;
				byte_load = (pk_size / 8.0);
				
				/* Calculate Sent Traffic statistics.  These will be	*/
				/* stored either as packets/sec or bytes/sec.			*/
				op_stat_write (sent_packet_sec_handle, 1.0);
				op_stat_write (sent_byte_sec_handle, byte_load);
				
				/* Record extra data-points to enable proper			*/
				/* computation of the "sum/time" based statistics		*/
				op_stat_write (sent_packet_sec_handle, 0.0);
				op_stat_write (sent_byte_sec_handle, 0.0);
				
				/* Format the IP ici */
				op_ici_attr_set (net_ici_ptr, "dest_addr", rem_addr); 
				op_ici_attr_set (net_ici_ptr, "connection_class", conn_class); 
				op_ici_attr_set (net_ici_ptr, "Type of Service", type_of_service);
				
				/* If this is a multicast from RIPv2, must specify the interface as multicast */
				/* This is used for RIPv2 to send its multicast over the various interfaces.  */
				if (ip_address_is_multicast (rem_addr) && rem_port == 520)
					{
					op_ici_attr_set (net_ici_ptr, "multicast_major_port", intf_num);
					}
				
				op_ici_install (net_ici_ptr);
				op_pk_send_forced (pkptr, output_strm); 
				}


			/** state (SEND) exit executives **/
			FSM_STATE_EXIT_FORCED (3, "SEND", "bt_rip_udp_v3 () [SEND exit execs]")
				{
				}


			/** state (SEND) transition processing **/
			FSM_TRANSIT_FORCE (1, state1_enter_exec, ;, "default", "", "SEND", "idle")
				/*---------------------------------------------------------*/



			/** state (ARRIVE) enter executives **/
			FSM_STATE_ENTER_FORCED (4, state4_enter_exec, "ARRIVE", "bt_rip_udp_v3 () [ARRIVE enter execs]")
				{
				/* Get the received packet. */
				pkptr = op_pk_get (input_strm);
				
				/* Compute total size of packet in bits, and from that	*/
				/* Compute the byte size of this packet.				*/
				pk_size = (double) op_pk_total_size_get (pkptr);
				byte_load = (pk_size / 8.0);
				
				/* Calculate Sent Traffic statistics.  These will be	*/
				/* stored either as packets/sec or bytes/sec.			*/
				op_stat_write (receive_packet_sec_handle, 1.0);
				op_stat_write (receive_byte_sec_handle, byte_load);
				
				/* Modif. Olivier */
				bt_stats_update_udp_stats (byte_load, 1);
				/******************/
				
				/* Record extra data-points to enable proper			*/
				/* computation of the "sum/time" based statistics		*/
				op_stat_write (receive_packet_sec_handle, 0.0);
				op_stat_write (receive_byte_sec_handle, 0.0);
				
				/* Determine the address information from the packet.	*/
				/* Note that context is switching from sender to		*/
				/* receiver, so variable names change appropriately.	*/
				op_ici_attr_get (ici_ptr, "src_addr", &rem_addr);
				
				/* Determine the type of service. It will be send to the higher layer in ICI. */
				op_ici_attr_get (ici_ptr, "Type of Service", &type_of_service);
				
				op_pk_nfd_access (pkptr, "fields", &udp_dgram_fd_ptr);
				
				rem_port = udp_dgram_fd_ptr->src_port;
				local_port = udp_dgram_fd_ptr->dest_port;
				
				if (udp_trace_active)
					{
					sprintf (msg0, "Local port: %d \t Remote Port: %d", local_port, rem_port);
					op_prg_odb_print_major ("Received UDP datagram:", msg0, OPC_NIL);
					}
				
				/* IP associates the address of the interface on which	*/
				/* this datagram was received in an ICI and sets that	*/
				/* in the packet that is forwarded to the higher layer.	*/
				/* Since UDP does not make use of this information, the	*/
				/* memory associated with it should be de-allocated.	*/
				intf_ici_ptr = op_pk_ici_get (pkptr);
				if (intf_ici_ptr != OPC_NIL)
					{
					/* Obtain the interface address from this ICI.		*/
					op_ici_attr_get (intf_ici_ptr, "interface_received", &intf_addr);
					ip_address_destroy (intf_addr);
					op_ici_destroy (intf_ici_ptr);
					}
				
				/* Obtain the interface address from the installed ICI.	*/
				/* A handle to this ICI has been obtained in the exit	*/
				/* execs of the "wait" state.							*/
				/* However, do not destroy this address, it is passed to*/
				/* application layer.									*/
				op_ici_attr_get (ici_ptr, "interface_received", &intf_addr);
				
				/* Destroy memory allocated by the interface control	*/
				/* information associated with this interrupt.			*/
				op_ici_destroy (ici_ptr);
				
				/* Find the destination TCB from the port.				*/
				tcb_ptr = udp_tcb_from_port (local_port);
				if (tcb_ptr == OPC_NIL)
					{
					/* No match was found. Discard the datagram.		*/
					if (udp_trace_active)
						{
						sprintf (msg0, "Datagram received for unknown port %d", local_port);
						op_prg_odb_print_major (msg0, "Discarding datagram.", OPC_NIL);
						}
				
					/* Generate a simulation log message. */
					udp_dgram_discard_log_write (local_port);
				
					op_pk_destroy (pkptr);
					}
				 
				else
					{
					/* A port match was found. Forward the datagram to	*/
					/* the application.									*/
					op_ici_attr_set (app_ici_ptr, "rem_addr", rem_addr); 
					op_ici_attr_set (app_ici_ptr, "Type of Service", type_of_service); 	 
					op_ici_attr_set (app_ici_ptr, "rem_port", rem_port);
					op_ici_attr_set (app_ici_ptr, "local_port", local_port);
					op_ici_attr_set (app_ici_ptr, "interface received", intf_addr);	
					op_ici_install (app_ici_ptr);
				
					op_pk_nfd_get (pkptr, "data", &data_pkptr); 
					op_pk_send (data_pkptr, tcb_ptr->strm_index);
				
					/* Destroy the UDP header.							*/
					op_pk_destroy (pkptr);  
					}
				}


			/** state (ARRIVE) exit executives **/
			FSM_STATE_EXIT_FORCED (4, "ARRIVE", "bt_rip_udp_v3 () [ARRIVE exit execs]")
				{
				}


			/** state (ARRIVE) transition processing **/
			FSM_TRANSIT_FORCE (1, state1_enter_exec, ;, "default", "", "ARRIVE", "idle")
				/*---------------------------------------------------------*/



			}


		FSM_EXIT (0,bt_rip_udp_v3)
		}
	}

#if defined (__cplusplus)
	extern "C" { 
#endif
	extern VosT_Fun_Status Vos_Catmem_Register (const char * , int , VosT_Void_Null_Proc, VosT_Address *);
	extern VosT_Address Vos_Catmem_Alloc (VosT_Address, size_t);
	extern VosT_Fun_Status Vos_Catmem_Dealloc (VosT_Address);
#if defined (__cplusplus)
	}
#endif


Compcode
bt_rip_udp_v3_init (void ** gen_state_pptr)
	{
	int _block_origin = 0;
	static VosT_Address	obtype = OPC_NIL;

	FIN (bt_rip_udp_v3_init (gen_state_pptr))

	if (obtype == OPC_NIL)
		{
		/* Initialize memory management */
		if (Vos_Catmem_Register ("proc state vars (bt_rip_udp_v3)",
			sizeof (bt_rip_udp_v3_state), Vos_Vnop, &obtype) == VOSC_FAILURE)
			{
			FRET (OPC_COMPCODE_FAILURE)
			}
		}

	*gen_state_pptr = Vos_Catmem_Alloc (obtype, 1);
	if (*gen_state_pptr == OPC_NIL)
		{
		FRET (OPC_COMPCODE_FAILURE)
		}
	else
		{
		/* Initialize FSM handling */
		((bt_rip_udp_v3_state *)(*gen_state_pptr))->current_block = 0;

		FRET (OPC_COMPCODE_SUCCESS)
		}
	}



void
bt_rip_udp_v3_diag (void)
	{
	int _block_origin = __LINE__;

	FIN (bt_rip_udp_v3_diag ())

	if (1)
		{
		int				intrpt_type;
		int				intrpt_strm;
		int				intrpt_code;
		Ici*			ici_ptr;
		Ici*			intf_ici_ptr;
		Objid			strm_objid;
		
		UdpT_Port		local_port;
		IpT_Address		rem_addr;
		IpT_Address		intf_addr;
		int				type_of_service; 
		
		UdpT_Port		rem_port;
		int				strm_index;
		
		int				i;
		int				list_size;
		
		UdpT_Tcb*		tcb_ptr;
		
		char			msg0 [512], msg1 [512];
		
		int				port_assigned;
		
		Packet*			pkptr;
		Packet*			data_pkptr;
		
		int					conn_class;
		UdpT_Dgram_Fields*	udp_dgram_fd_ptr;
		
		int				higher_layer_protocol_type;
		int				intf_num;
		/* used for discover lower layer module ip_encap */
		List*			proc_record_handle_list_ptr;
		OmsT_Pr_Handle	process_record_handle;
		Objid			neighbor_mod_objid;
		
		/* used for collection of UDP statistics */
		double pk_size;
		double byte_load;

		/* Diagnostic Block */


		BINIT
		op_prg_odb_print_major ("TCB list:", OPC_NIL);
		list_size = op_prg_list_size (tcb_list);
		for (i = 0; i < list_size; i++)
			{
			tcb_ptr = (UdpT_Tcb *) op_prg_list_access (tcb_list, i);
		
			/* Print socket information. */
			sprintf (msg0, "Port (%d) information: ", tcb_ptr->local_port);
			sprintf (msg1, "Application objid (%d), traffic through stream (%d)",
				tcb_ptr->app_objid, tcb_ptr->strm_index);
			op_prg_odb_print_major (msg0, msg1, OPC_NIL);
		
			}

		/* End of Diagnostic Block */

		}

	FOUT;
	}




void
bt_rip_udp_v3_terminate (void)
	{
	int _block_origin = __LINE__;

	FIN (bt_rip_udp_v3_terminate (void))

	Vos_Catmem_Dealloc (pr_state_ptr);

	FOUT;
	}


/* Undefine shortcuts to state variables to avoid */
/* syntax error in direct access to fields of */
/* local variable prs_ptr in bt_rip_udp_v3_svar function. */
#undef tcb_list
#undef net_ici_ptr
#undef app_ici_ptr
#undef udp_trace_active
#undef port_id_new
#undef own_mod_objid
#undef own_node_objid
#undef own_prohandle
#undef own_process_record_handle
#undef proc_model_name
#undef my_lanhandle
#undef lan_node
#undef sess_svr_id
#undef sess_wkstn_id
#undef input_strm
#undef output_strm
#undef sent_packet_sec_handle
#undef sent_byte_sec_handle
#undef receive_packet_sec_handle
#undef receive_byte_sec_handle



void
bt_rip_udp_v3_svar (void * gen_ptr, const char * var_name, char ** var_p_ptr)
	{
	bt_rip_udp_v3_state		*prs_ptr;

	FIN (bt_rip_udp_v3_svar (gen_ptr, var_name, var_p_ptr))

	if (var_name == OPC_NIL)
		{
		*var_p_ptr = (char *)OPC_NIL;
		FOUT;
		}
	prs_ptr = (bt_rip_udp_v3_state *)gen_ptr;

	if (strcmp ("tcb_list" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->tcb_list);
		FOUT;
		}
	if (strcmp ("net_ici_ptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->net_ici_ptr);
		FOUT;
		}
	if (strcmp ("app_ici_ptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->app_ici_ptr);
		FOUT;
		}
	if (strcmp ("udp_trace_active" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->udp_trace_active);
		FOUT;
		}
	if (strcmp ("port_id_new" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->port_id_new);
		FOUT;
		}
	if (strcmp ("own_mod_objid" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->own_mod_objid);
		FOUT;
		}
	if (strcmp ("own_node_objid" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->own_node_objid);
		FOUT;
		}
	if (strcmp ("own_prohandle" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->own_prohandle);
		FOUT;
		}
	if (strcmp ("own_process_record_handle" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->own_process_record_handle);
		FOUT;
		}
	if (strcmp ("proc_model_name" , var_name) == 0)
		{
		*var_p_ptr = (char *) (prs_ptr->proc_model_name);
		FOUT;
		}
	if (strcmp ("my_lanhandle" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->my_lanhandle);
		FOUT;
		}
	if (strcmp ("lan_node" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->lan_node);
		FOUT;
		}
	if (strcmp ("sess_svr_id" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->sess_svr_id);
		FOUT;
		}
	if (strcmp ("sess_wkstn_id" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->sess_wkstn_id);
		FOUT;
		}
	if (strcmp ("input_strm" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->input_strm);
		FOUT;
		}
	if (strcmp ("output_strm" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->output_strm);
		FOUT;
		}
	if (strcmp ("sent_packet_sec_handle" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->sent_packet_sec_handle);
		FOUT;
		}
	if (strcmp ("sent_byte_sec_handle" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->sent_byte_sec_handle);
		FOUT;
		}
	if (strcmp ("receive_packet_sec_handle" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->receive_packet_sec_handle);
		FOUT;
		}
	if (strcmp ("receive_byte_sec_handle" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->receive_byte_sec_handle);
		FOUT;
		}
	*var_p_ptr = (char *)OPC_NIL;

	FOUT;
	}

