/* Process model C form file: bt_mac_slave.pr.c */
/* Portions of this file copyright 1992-2002 by OPNET Technologies, Inc. */



/* This variable carries the header into the object file */
static const char bt_mac_slave_pr_c [] = "MIL_3_Tfile_Hdr_ 81A 30A modeler 7 3E2877B5 3E2877B5 1 skydiver rebala 0 0 none none 0 0 none 0 0 0 0 0 0                                                                                                                                                                                                                                                                                                                                                                                                                      ";
#include <string.h>



/* OPNET system definitions */
#include <opnet.h>

#if defined (__cplusplus)
extern "C" {
#endif
FSM_EXT_DECS
#if defined (__cplusplus)
} /* end of 'extern "C"' */
#endif


/* Header Block */

/*
** $RCSfile:
**
** Bluetooth model in Opnet
** National Institute of Standards and Technology
**
** This model was developed at the National Institute of Standards
** and Technology by employees of the Federal Government in the course
** of their official duties. Pursuant to title 17 Section 105 of the
** United States Code this software is not subject to copyright
** protection and is in the public domain. This is an experimental
** system.  NIST assumes no responsibility whatsoever for its use by
** other parties, and makes no guarantees, expressed or implied,
** about its quality, reliability, or any other characteristic.
**
** We would appreciate acknowledgement if the model is used.
**
** NIST ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION
** AND DISCLAIM ANY LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER
** RESULTING FROM THE USE OF THIS SOFTWARE.
**
** Primary Author:      Frederic Mouveaux
** Module description:  MAC Protocol in Bluetooth
** Last Modification:   May, 18, 2000
*/

/* Standard includes */
#include <stdlib.h>
#include <math.h>
#include "oms_pr.h"
#include "oms_auto_addr_support.h"
#include "bt_support.h"
#include "fifo_support.h"
#include "l2cap_support.h"
//#include "topo_discovery.h"
#include "slaves_management.h"
#include "bt_stats_write.h"

/* Define the macros for the events */

/* end of initialize */
#define END_INIT						(op_intrpt_code() == SLAVE_CLK_TIMER)

/* We are authorized to TX when we have received a packet */
/* from the master */
#define	AUTHORIZED_TO_TX				(packet_accepted_flag)

/* We are ready to transmit */
#define READY_TO_TRANSMIT               ((TIME_SLOT_PARITY_ODD) && \
	    								 (!PACKET_DELIVERY) && (AUTHORIZED_TO_TX))

/*modif issam */
#define  SIM_END                          (op_intrpt_type() == OPC_INTRPT_ENDSIM)

/*modif Issam October 23*/
/*declare some variables for transmission*/
double     freq; /*the transmission frequency*/
double   t_x,r_x,t_y,r_y;/*to store the oordinate of the nodes*/
double   transmission_power;
int      bt_pk_collided;
int      device_index;

/* Function prototypes declaration */
static void		bt_mac_sv_init ();									/* MAC Process Initilization */
static void		bt_higher_layer_pkt_arrival ();						/* L2CAP encapsulation */
static void		bt_higher_layer_sco_pkt_arrival ();					/* SCO traffic */
static void		bt_lower_layer_pkt_arrival (Packet * pkptr);		/* L2CAP reassembly */
static void		bt_packet_to_transmit ();							/* Packet transmission */
static void		bt_packet_to_receive ();							/* Packet reception */
static void 	bt_get_position (Objid objid, double* x_position, double* y_position); /* get the position of the devices */
static void     slave_end_of_simulation ();
static void 	bt_mac_free_memory ();
static void		bt_print_report_slave (const char * filename, const char * line1, const char * line2);
static void 	bt_slave_print_csv_report (int nb_pkt_received);

/* End of Header Block */


#if !defined (VOSD_NO_FIN)
#undef	BIN
#undef	BOUT
#define	BIN		FIN_LOCAL_FIELD(last_line_passed) = __LINE__ - _block_origin;
#define	BOUT	BIN
#define	BINIT	FIN_LOCAL_FIELD(last_line_passed) = 0; _block_origin = __LINE__;
#else
#define	BINIT
#endif /* #if !defined (VOSD_NO_FIN) */



/* State variable definitions */
typedef struct
	{
	/* Internal state tracking for FSM */
	FSM_SYS_STATE
	/* State Variables */
	int	                    		my_address;
	int	                    		packets_in_subqueues;
	Boolean	                		packet_accepted_flag;
	Stathandle	             		mac_access_delay_stat;
	Stathandle	             		mac_throughput_stat;
	Stathandle	             		mac_goodput_stat;
	double	                 		mac_total_pkt_bits;
	double	                 		mac_total_frame_body_bits;
	double	                 		mac_number_of_pkt_send;
	double	                 		mac_number_of_pkt_recv;
	Stathandle	             		mac_packets_send_stat;
	Stathandle	             		mac_packets_recv_stat;
	Packet *	               		retransmit_pkptr;
	Boolean	                		acknowledgement;
	Boolean	                		tx_sequence_number;
	Stathandle	             		mac_rt_attempt_stat;
	double	                 		retransmission_attempts;
	int	                    		reassembly_buffer;
	Stathandle	             		l2cap_access_delay_stat;
	Stathandle	             		l2cap_goodput_stat;
	Stathandle	             		l2cap_throughput_stat;
	double	                 		l2cap_total_pkt_bits;
	double	                 		l2cap_total_frame_body_bits;
	double	                 		l2cap_number_of_pkt_send;
	double	                 		l2cap_number_of_pkt_recv;
	Stathandle	             		l2cap_packets_send_stat;
	Stathandle	             		l2cap_packets_recv_stat;
	double	                 		reassembly_creation_time;
	Stathandle	             		mac_pkt_lost_stat;
	double	                 		mac_number_of_pkt_lost;
	int	                    		number_of_ignored_pkt;
	int	                    		mac_number_of_pkt_null;
	int	                    		mac_number_of_poll_pkt;
	Boolean	                		rx_sequence_number;
	Boolean	                		update_tx_sequence;
	Stathandle	             		sco_packets_send_stat;
	Stathandle	             		sco_packets_recv_stat;
	double	                 		sco_number_of_pkt_send;
	double	                 		sco_number_of_pkt_recv;
	Boolean	                		poll_answer;
	Stathandle	             		mac_payload_errs_stat;
	Boolean	                		null_ack;
	int	                    		tx_acknowledgement;
	double	                 		my_stat;
	int	                    		my_value;
	int	                    		total_payload_errs;
	double	                 		total_l2cap_delay;
	int	                    		piconet_number;
	int	                    		debug_flag;
	Objid	                  		my_objid;
	char *	                 		bt_device_name;
	double	                 		start_time_collect;
	OmsT_Aa_Address_Handle	 		oms_aa_handle;
	List **	                		fifo_bt_queue;
	double	                 		l2cap_segmentation_size;
	int	                    		l2cap_packet_type;
	} bt_mac_slave_state;

#define pr_state_ptr            		((bt_mac_slave_state*) SimI_Mod_State_Ptr)
#define my_address              		pr_state_ptr->my_address
#define packets_in_subqueues    		pr_state_ptr->packets_in_subqueues
#define packet_accepted_flag    		pr_state_ptr->packet_accepted_flag
#define mac_access_delay_stat   		pr_state_ptr->mac_access_delay_stat
#define mac_throughput_stat     		pr_state_ptr->mac_throughput_stat
#define mac_goodput_stat        		pr_state_ptr->mac_goodput_stat
#define mac_total_pkt_bits      		pr_state_ptr->mac_total_pkt_bits
#define mac_total_frame_body_bits		pr_state_ptr->mac_total_frame_body_bits
#define mac_number_of_pkt_send  		pr_state_ptr->mac_number_of_pkt_send
#define mac_number_of_pkt_recv  		pr_state_ptr->mac_number_of_pkt_recv
#define mac_packets_send_stat   		pr_state_ptr->mac_packets_send_stat
#define mac_packets_recv_stat   		pr_state_ptr->mac_packets_recv_stat
#define retransmit_pkptr        		pr_state_ptr->retransmit_pkptr
#define acknowledgement         		pr_state_ptr->acknowledgement
#define tx_sequence_number      		pr_state_ptr->tx_sequence_number
#define mac_rt_attempt_stat     		pr_state_ptr->mac_rt_attempt_stat
#define retransmission_attempts 		pr_state_ptr->retransmission_attempts
#define reassembly_buffer       		pr_state_ptr->reassembly_buffer
#define l2cap_access_delay_stat 		pr_state_ptr->l2cap_access_delay_stat
#define l2cap_goodput_stat      		pr_state_ptr->l2cap_goodput_stat
#define l2cap_throughput_stat   		pr_state_ptr->l2cap_throughput_stat
#define l2cap_total_pkt_bits    		pr_state_ptr->l2cap_total_pkt_bits
#define l2cap_total_frame_body_bits		pr_state_ptr->l2cap_total_frame_body_bits
#define l2cap_number_of_pkt_send		pr_state_ptr->l2cap_number_of_pkt_send
#define l2cap_number_of_pkt_recv		pr_state_ptr->l2cap_number_of_pkt_recv
#define l2cap_packets_send_stat 		pr_state_ptr->l2cap_packets_send_stat
#define l2cap_packets_recv_stat 		pr_state_ptr->l2cap_packets_recv_stat
#define reassembly_creation_time		pr_state_ptr->reassembly_creation_time
#define mac_pkt_lost_stat       		pr_state_ptr->mac_pkt_lost_stat
#define mac_number_of_pkt_lost  		pr_state_ptr->mac_number_of_pkt_lost
#define number_of_ignored_pkt   		pr_state_ptr->number_of_ignored_pkt
#define mac_number_of_pkt_null  		pr_state_ptr->mac_number_of_pkt_null
#define mac_number_of_poll_pkt  		pr_state_ptr->mac_number_of_poll_pkt
#define rx_sequence_number      		pr_state_ptr->rx_sequence_number
#define update_tx_sequence      		pr_state_ptr->update_tx_sequence
#define sco_packets_send_stat   		pr_state_ptr->sco_packets_send_stat
#define sco_packets_recv_stat   		pr_state_ptr->sco_packets_recv_stat
#define sco_number_of_pkt_send  		pr_state_ptr->sco_number_of_pkt_send
#define sco_number_of_pkt_recv  		pr_state_ptr->sco_number_of_pkt_recv
#define poll_answer             		pr_state_ptr->poll_answer
#define mac_payload_errs_stat   		pr_state_ptr->mac_payload_errs_stat
#define null_ack                		pr_state_ptr->null_ack
#define tx_acknowledgement      		pr_state_ptr->tx_acknowledgement
#define my_stat                 		pr_state_ptr->my_stat
#define my_value                		pr_state_ptr->my_value
#define total_payload_errs      		pr_state_ptr->total_payload_errs
#define total_l2cap_delay       		pr_state_ptr->total_l2cap_delay
#define piconet_number          		pr_state_ptr->piconet_number
#define debug_flag              		pr_state_ptr->debug_flag
#define my_objid                		pr_state_ptr->my_objid
#define bt_device_name          		pr_state_ptr->bt_device_name
#define start_time_collect      		pr_state_ptr->start_time_collect
#define oms_aa_handle           		pr_state_ptr->oms_aa_handle
#define fifo_bt_queue           		pr_state_ptr->fifo_bt_queue
#define l2cap_segmentation_size 		pr_state_ptr->l2cap_segmentation_size
#define l2cap_packet_type       		pr_state_ptr->l2cap_packet_type

/* This macro definition will define a local variable called	*/
/* "op_sv_ptr" in each function containing a FIN statement.	*/
/* This variable points to the state variable data structure,	*/
/* and can be used from a C debugger to display their values.	*/
#undef FIN_PREAMBLE
#define FIN_PREAMBLE	bt_mac_slave_state *op_sv_ptr = pr_state_ptr;


/* Function Block */

enum { _block_origin = __LINE__ };
/*
 * Function:		bt_mac_sv_init
 *
 * Description:		MAC Initialization procedure
 *					Initialize state variables.
 *					Read model attribute values in
 *					variables.
 *					Create global lists
 *					Register statistics handlers
 */

static void bt_mac_sv_init ()
{
	Objid					params_attr_objid;
	char					buffer[50];
	
	Objid					my_node_objid;
	

	FIN (bt_mac_sv_init ());
	
	/* Object id of this process. */
	my_objid = op_id_self ();
	
	/* Get the objid of the node */
	my_node_objid = op_topo_parent(my_objid);
	
	/* obtain the time to start collecting the results */
	op_ima_obj_attr_get (my_objid, "Report", &params_attr_objid);
	op_ima_obj_attr_get ( op_topo_child (params_attr_objid, OPC_OBJTYPE_GENERIC,0), "start time", &start_time_collect);
   	
	/* read the debug flag and the message print */
	op_ima_obj_attr_get (my_objid, "debug flag", &debug_flag) ;
	
	/* Determine the assigned MAC address. */
	op_ima_obj_attr_get (my_objid, "station address", &my_address);	/* This Device MAC address */

	/* Obtain an address handle for resolving WLAN MAC addresses.	*/
	oms_aa_handle = oms_aa_address_handle_get ("MAC Addresses", "station address");
	
	/*Get the name of the device */	
	op_ima_obj_attr_get ( op_topo_parent(my_objid), "name", buffer);

	bt_device_name = (char*)op_prg_mem_alloc( (strlen(buffer)+1) * sizeof(char) );
	strcpy(bt_device_name,buffer);

	/*get the coordinates of this node seen as transmitter*/
	bt_get_position (my_objid, &t_x, &t_y);

	/*Get the transmission power*/
	op_ima_obj_attr_get ( my_objid, "power", &transmission_power);
	
	/* Get the L2CAP segmentation parameters */
	l2cap_init_parameters (&l2cap_segmentation_size, &l2cap_packet_type);
	
	printf ("\n|----------------------------------------------------------|\n");
	printf ("| Init slave info:\n");
	printf ("| \tthe slave name is %s \n", bt_device_name);
	printf ("| \tposition of this slave : (%.2f;%.2f)\n", t_x, t_y);
	printf ("| \tthe transmission_power %.2f \n",transmission_power);
	printf ("| \t\tL2CAP segmentation size : %.2f bytes\n", l2cap_segmentation_size);
	printf ("| \t\tL2CAP packet segmentation : %s\n", (l2cap_packet_type)?"Data Medium Rate":"Data High Rate");
	printf ("|----------------------------------------------------------|\n");


	/* Initialize subqueues */
	packet_accepted_flag = OPC_FALSE;
	fifo_bt_queue = fifo_init_support ();
	retransmit_pkptr = NULL;
	acknowledgement = OPC_FALSE; tx_acknowledgement = OPC_FALSE;
	/* init the TX SEQN to false, the first transmission will change it to true */
	tx_sequence_number = OPC_FALSE;
	rx_sequence_number = OPC_FALSE;

	/* Register local statistics */
	mac_access_delay_stat	= op_stat_reg("bt_mac. MAC Access Delay (sec)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	mac_throughput_stat		= op_stat_reg("bt_mac. MAC Throughput (bit/sec)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	mac_goodput_stat		= op_stat_reg("bt_mac. MAC Goodput (bit/sec)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	mac_packets_send_stat	= op_stat_reg("bt_mac. MAC Packets send (pkt)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	mac_packets_recv_stat	= op_stat_reg("bt_mac. MAC Packets received (pkt)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	mac_rt_attempt_stat		= op_stat_reg("bt_mac. MAC Retransmission Attempts (pkt)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	mac_pkt_lost_stat		= op_stat_reg("bt_mac. MAC Packet Loss (%)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	mac_payload_errs_stat	= op_stat_reg("bt_mac. MAC Payload Errors", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	l2cap_access_delay_stat = op_stat_reg("l2cap. L2CAP Access Delay (sec)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	l2cap_throughput_stat	= op_stat_reg("l2cap. L2CAP Throughput (bit/sec)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	l2cap_goodput_stat		= op_stat_reg("l2cap. L2CAP Goodput (bit/sec)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	l2cap_packets_send_stat	= op_stat_reg("l2cap. L2CAP Packets send (pkt)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	l2cap_packets_recv_stat	= op_stat_reg("l2cap. L2CAP Packets received (pkt)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	sco_packets_send_stat	= op_stat_reg("sco. SCO Packets send (pkt)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	sco_packets_recv_stat	= op_stat_reg("sco. SCO Packets received (pkt)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);

	/* Initialize statistics */
	mac_total_pkt_bits		= mac_total_frame_body_bits = 0;
	l2cap_total_pkt_bits 	= l2cap_total_frame_body_bits = 0;
	mac_number_of_pkt_send	= mac_number_of_pkt_recv = 0;
	l2cap_number_of_pkt_send= l2cap_number_of_pkt_recv = 0;
	sco_number_of_pkt_send  = sco_number_of_pkt_recv = 0;
	retransmission_attempts = mac_number_of_pkt_lost = 0;
	number_of_ignored_pkt = mac_number_of_pkt_null = 0;
	mac_number_of_poll_pkt = 0;
	reassembly_buffer = 0;
	reassembly_creation_time = 0.0;
	poll_answer = OPC_FALSE;
	null_ack = OPC_TRUE;
	total_payload_errs = 0;
	bt_pk_collided = 0;
	total_l2cap_delay = 0;
			
	FOUT;
}


/*
 * $Function:		bt_higher_layer_pkt_arrival
 *
 * $Description:	Reception of a packet from the
 *					higher layer of this MAC.
 */

static void bt_higher_layer_pkt_arrival ()
{
	Packet *	pkptr;		/* The current packet */
	Ici *		ici_ptr;
	int			dest_addr;
	int			nb_pkt_received;
	
	
	FIN (bt_higher_layer_pkt_arrival ());
	
	if (debug_flag)
		bt_print_debug ("Slave function block : bt_higher_layer_pkt_arrival ()");

	/* Get the packet from the source */
	pkptr = op_pk_get(op_intrpt_strm());

	/* Get the ici pointer */
	ici_ptr = op_intrpt_ici ();
	
	/* Retrieve destination address from the ici set by the interface layer.	*/
	if (ici_ptr == OPC_NIL || op_ici_attr_get (ici_ptr, "dest_addr", &dest_addr) == OPC_COMPCODE_FAILURE)
		{
		/* Generate error message.	*/
		bt_mac_error ("Destination address in not valid.", OPC_NIL, OPC_NIL);
		}
	
	/* Update the number of packets received at the L2CAP level */
	if ( op_sim_time() >= start_time_collect )
		l2cap_number_of_pkt_send++;
	op_stat_write (l2cap_packets_send_stat, l2cap_number_of_pkt_send);


	/* When transmited, the packet contains the Creation Time */
	/* Of the last encapsulation, Now L2CAP segment the packet */
	/* And insert it inside the outgoing subqueue */
	/* Get the packet destination information and enqueue it for processing purpose */
	/* Update the number of packets in the different TX subqueues */

	l2cap_higher_layer_arrival (pkptr, l2cap_segmentation_size);
	nb_pkt_received = l2cap_segmentation (fifo_bt_queue, my_address, SLAVE_TYPE, l2cap_packet_type);
	packets_in_subqueues += nb_pkt_received;

		
	if (bt_message_print)
		{
		printf ("\n|--------------------------------------------------------------|\n");
		printf ("| packet in the subqueue of slave %d of piconet %d = %d\n",my_address, piconet_number, packets_in_subqueues);
		printf ("|--------------------------------------------------------------|\n");	
		}
	
	FOUT;
}


/*
 * $Function:		bt_higher_layer_sco_pkt_arrival
 *
 * $Description:	Reception of a voice packet from the
 *					higher layer of this MAC.
 */
 
static void bt_higher_layer_sco_pkt_arrival ()
{
	Packet *	pkptr;									/* The current packet */
	Packet *	new_packet;								/* The new HV packet to be created */


	FIN (bt_higher_layer_sco_pkt_arrival ());

	if (debug_flag)
		bt_print_debug ("Slave function block : bt_higher_layer_sco_pkt_arrival ()");

	/* Get the packet from the source and some information from it */
	pkptr = op_pk_get(op_intrpt_strm());

	/* Update the number of packets received at the L2CAP level */
	if ( op_sim_time() >= start_time_collect )
		sco_number_of_pkt_send++;
	op_stat_write (sco_packets_send_stat, sco_number_of_pkt_send);

	/* When transmited, the packet contains the Creation Time */
	/* Of the last encapsulation. This information will be used for stat purpose */
	/* Insert it inside the outgoing subqueue */
	switch ( (int) op_pk_total_size_get(pkptr) )
	{
		case	TSCO_RAW_HV1:
		    if ((new_packet = op_pk_create_fmt (BLUETOOTH_PKT_HV1)) == OPC_NIL) 
				bt_mac_error ("bt_higher_layer_sco_pkt_arrival", "Unable to create HV1 packet.", "");
		break;
		case	TSCO_RAW_HV2:
		    if ((new_packet = op_pk_create_fmt (BLUETOOTH_PKT_HV2)) == OPC_NIL)
				bt_mac_error ("bt_higher_layer_sco_pkt_arrival", "Unable to create HV2 packet.", "");
		break;
		case	TSCO_RAW_HV3:
		    if ((new_packet = op_pk_create_fmt (BLUETOOTH_PKT_HV3)) == OPC_NIL)
				bt_mac_error ("bt_higher_layer_sco_pkt_arrival", "Unable to create HV3 packet.", "");
		break;
	}

	/* Set packet fields */
	if (	(op_pk_nfd_set (new_packet, "AM_ADDR", my_address) == OPC_COMPCODE_FAILURE) ||
			(op_pk_nfd_set (new_packet, "Time Stamp", op_pk_creation_time_get(pkptr)) == OPC_COMPCODE_FAILURE) ||
			(op_pk_nfd_set (new_packet, "Frame Body", pkptr) == OPC_COMPCODE_FAILURE) )
		bt_mac_error ("bt_higher_layer_sco_pkt_arrival", "Unable to set voice packet fields", "");

	/* Update the number of packets in the subqueues */
	fifo_pkt_enqueue (fifo_bt_queue, new_packet, SUBQ_INPUT_SCO);
	packets_in_subqueues ++;
	
	FOUT;
}


/*
 * $Function:		bt_lower_layer_pkt_arrival
 *
 * $Description:	Reception of a packet from the
 *					lower layer of this MAC.
 *					Called by interrupt
 */

static void bt_lower_layer_pkt_arrival (Packet * pkptr)
{
	int			type, payload_errs, l2cap_last;
	Packet *	frame_body;
	Packet *	higher_layer_pkt;
	double		ctime;


	FIN (bt_lower_layer_pkt_arrival (pkptr));

	op_pk_nfd_get(pkptr,"TYPE",&type);
	op_pk_nfd_get(pkptr,"Time Stamp",&ctime);

	/* Calculate the stats for the MAC Layer */
	/* Calculate the statistics for the packet Access Delay */
	op_stat_write (mac_access_delay_stat, op_sim_time()-op_pk_creation_time_get(pkptr));


   	/* Total number of bits sent to higher layer is equivalent to a throughput	*/
	mac_total_pkt_bits += (double) op_pk_total_size_get (pkptr);
	if ( (type != NULL_TYPE) && (type != POLL_TYPE) )
		mac_total_frame_body_bits += (double) op_pk_nfd_size (pkptr,"Frame Body");

	op_stat_write (mac_throughput_stat, mac_total_pkt_bits/op_sim_time());
	op_stat_write (mac_goodput_stat, mac_total_frame_body_bits/op_sim_time());

	/* Log the number of errors inside the payload received */
	op_pk_nfd_get(pkptr, "Errors", &payload_errs);
	if(payload_errs)
		{
		bt_pk_collided++;
		op_stat_write (mac_payload_errs_stat, (double) payload_errs);
		
		total_payload_errs += payload_errs;
		/******/
		}
		
	
	/* Update the number of packets received */
	if ( op_sim_time() >= start_time_collect )
		{
		switch (type)
			{
			case NULL_TYPE:
			mac_number_of_pkt_null++;
			break;
			
			case POLL_TYPE:
			mac_number_of_poll_pkt++;
			break;
			
			default:
			mac_number_of_pkt_recv++;
			break;
			}
		}
	
	op_stat_write (mac_packets_recv_stat, mac_number_of_pkt_recv);

	/* Depending on the packet type, log different stats and do SCO or ACL */
	switch ( type )
	{
		case	POLL_TYPE:
		case	NULL_TYPE:					/* For all control traffic just discard them, */
			bt_destroy_packet(pkptr);		/* no stat to keep */
		break;								/* Note that the slave never receive NULL packets from the */
											/* Master as this one POLL the slave when no packets are */
											/* in its queues */
		case	HV1_TYPE:					/* For all the voice packets */
		case	HV2_TYPE:
		case	HV3_TYPE:
			/* Update the number of packets received */
			if ( op_sim_time() >= start_time_collect )
				sco_number_of_pkt_recv++;
			op_stat_write (sco_packets_recv_stat, sco_number_of_pkt_recv);

			/* Remove the voice information from the packet and send it to the higher layer */
			op_pk_nfd_get(pkptr, "Frame Body", &frame_body);
			op_pk_destroy(pkptr);

			op_pk_send_forced(frame_body, HIGHER_LAYER_VC_OUTPUT_STREAM);
		break;

		default:							/* For all other packet type */
			/* Operate the L2CAP reassembly */
			if ( (pkptr = l2cap_reassembly(pkptr,&reassembly_buffer,&reassembly_creation_time)) != NULL )
			{	/* A reassembly just took place */

			   	/* Total number of bits sent to higher layer is equivalent to a throughput	*/
				l2cap_total_pkt_bits += (double) op_pk_total_size_get (pkptr);
				l2cap_total_frame_body_bits += (double) op_pk_nfd_size (pkptr,"Frame Body");
				op_stat_write (l2cap_throughput_stat, l2cap_total_pkt_bits/op_sim_time());
				op_stat_write (l2cap_goodput_stat, l2cap_total_frame_body_bits/op_sim_time());

                /* Calculate the statistics for the packet Access Delay */
                op_stat_write (l2cap_access_delay_stat, op_sim_time()-reassembly_creation_time);

				/* Update the number of packets received */
				if ( op_sim_time() >= start_time_collect )
					l2cap_number_of_pkt_recv++;
				op_stat_write (l2cap_packets_recv_stat, l2cap_number_of_pkt_recv);

				/*** modif******/
				/*compute the total l2cap delay*/
				total_l2cap_delay = total_l2cap_delay + (op_sim_time()-reassembly_creation_time);
				/*****************************/
				
				/* Check whether the packet is the last L2CAP packet */
				op_pk_nfd_get (pkptr, "Last", &l2cap_last);
				
				if (l2cap_last)
					{
					/* get the higher layer packet */
					op_pk_nfd_get (pkptr, "HLPacket", &higher_layer_pkt);
									
					/* Forward the packet to the higher layer */
					op_pk_send_forced(higher_layer_pkt, HIGHER_LAYER_OUTPUT_STREAM);
					}
				
				/* Destroy packet */
				l2cap_destroy_packet (pkptr);
			}	/* If the packet has not been reassembled then, wait for the next round */
		break;
	}


	FOUT;
}


/*
 * $Function:		bt_packet_to_transmit
 *
 * $Description:	Check if there is a packet ready to TX or
 *					not. If there is any, send it to the
 *					lower layer
 */
 
static void bt_packet_to_transmit ()
{
	Packet *	pkptr = NULL;
	int			packet_type;
	char		format[8];
	double		ctime;
	
	int         dest_objid;/*to store the loaction coordinates*/
	double	    transmission_frequency;
	
	Boolean 	retransmit = OPC_FALSE;
	Boolean		transmit_debug = op_prg_odb_ltrace_active ("transmit");
	
	
	FIN (bt_packet_to_transmit ());
	
	/* Reset the packet accepted flag */
	packet_accepted_flag = OPC_FALSE;

	
	/*
	 * Voice packet traffic must be send first.
	 * then if there is a packet waiting to be retransmit, then do it,
	 * otherwise check the scheduler
	 * Make a basic check in order to determine if a packet has been
	 * dequeued. This test should not fail has we already know that
	 * there is a least one packet in the subqueues
	 * Then, transmit the packet over the RF
	 */
	
	if (fifo_bt_queue_empty(fifo_bt_queue, SUBQ_INPUT_SCO) == OPC_FALSE)		/* Check the voice queue */
		pkptr = fifo_pk_queue_remove (fifo_bt_queue, SUBQ_INPUT_SCO, OPC_QPOS_HEAD);
	else
	{
		pkptr = retransmit_pkptr;									/* Retransmit packet? */
		if (pkptr == NULL)
			pkptr = fifo_request_pkt_to_scheduler(fifo_bt_queue);	/* No -> Packets in queue? */
		else
			retransmit = OPC_TRUE;
		
		if ((pkptr == NULL) && (!null_ack))
		{
			pkptr = op_pk_create_fmt(BLUETOOTH_PKT_NULL);			/* No -> Create a NULL packet */
			op_pk_nfd_set(pkptr,"Time Stamp",op_sim_time());
			op_pk_nfd_set(pkptr,"AM_ADDR",my_address);
		}
			
	}

	if (pkptr != NULL)
	{
		/* In case of a retransmission or NULL packet, don't update the number of packets in queues */
		/* For all other traffic, like SCO or ACL, update packet in queue number */
		op_pk_format (pkptr, format);
		if (pkptr != retransmit_pkptr)
			{
			/* update the TX seqn */
			tx_sequence_number = (tx_sequence_number)?OPC_FALSE:OPC_TRUE;
			
			if ( strcmp(format, BLUETOOTH_PKT_NULL)!=0 )
				/* Update the number of packets in the different subqueues */
				packets_in_subqueues--;
			}
		
		op_pk_nfd_get (pkptr, "Time Stamp", &ctime);

		/* Set the number of clock cycle to wait for next transmission from the packet type */
		bt_set_tx_packet_delivery_clk (pkptr, piconet_number);

		/* Just before sending the packet, make sure that all the stations are */
		/* synchronized on the TX frequency. */
		bt_set_slave_transmission(pkptr, piconet_number);

		/* Update the number of packets received */
		if ( op_sim_time() >= start_time_collect )
			mac_number_of_pkt_send++;
		op_stat_write (mac_packets_send_stat, mac_number_of_pkt_send);

		/* Get the packet information, add or not the ARQ, SEQN and retransmit scheme */
		op_pk_nfd_get(pkptr, "TYPE", &packet_type);

		switch ( packet_type )
		{						/* First check the ARQ, SEQN scheme */
			/*case	POLL_TYPE:	 For POLL no ARQ, SEQN scheme is needed */
			case	NULL_TYPE:	/* This kind of packet does not affect the ARQ, and SEQN flags */
			case	HV1_TYPE:	/* Voice packets do not affect the ARQ, and SEQN either */
			case	HV2_TYPE:
			case	HV3_TYPE:
				op_pk_nfd_set(pkptr, "ARQ", tx_acknowledgement);
				op_pk_nfd_set(pkptr, "SEQN", tx_sequence_number);
			break;

			default:			
				/*
				 * All other traffic need the ARQ, and SEQN scheme
				 * Set the binary sequence number of the packet
				 * Set the acknowledgement flag inside the packet, this state was determined
				 * by the last packet reception 
				 */
				
				op_pk_nfd_set(pkptr, "ARQ", tx_acknowledgement);

				if (retransmit_pkptr)
					retransmission_attempts++;	/* this is a retransmission */

				op_pk_nfd_set(pkptr, "SEQN", tx_sequence_number);
			break;
		}

		/* Get the packet information again, for the retransmission scheme */
		/* This is to check if the packet was a NULL packet. If yes, the */
		/* retransmission scheme should not be applied to the packet */
		op_pk_nfd_get(pkptr, "TYPE", &packet_type);

		switch ( packet_type )
		{						/* Now, check the retransmit scheme */
			case	NULL_TYPE:	/* For POLL and NULL packets */
			case	POLL_TYPE:	/* or */
			case	HV1_TYPE:	/* For voice packets */
			case	HV2_TYPE:
			case	HV3_TYPE:
			break;				/* Do not retransmit packets */

			default:			/* All ACL traffic implements the retransmit scheme */
				/* Duplicate the packet to send, and store it in the retransmit storage space */
					retransmit_pkptr = op_pk_copy(pkptr);
			break;
			}

		/* Set the way the packet should go */
		op_pk_nfd_set (pkptr, "Way", SLAVE_TO_MASTER);

		/*Set the positions coordinates in the packet*/
		bt_get_position ( my_objid, &t_x, &t_y);
		op_pk_nfd_set(pkptr,"t_x",t_x);
		op_pk_nfd_set(pkptr,"t_y",t_y);
		
		dest_objid = topo_get_master_device(piconet_number)->mac_objid ;
		bt_get_position (  dest_objid , &r_x, &r_y);
				
		op_pk_nfd_set(pkptr,"r_x",r_x);
		op_pk_nfd_set(pkptr,"r_y",r_y);

		/*Set the transmission power in the packet*/
		op_pk_nfd_set(pkptr,"power",transmission_power);
		
		/*Set the number of the piconet*/
		op_pk_nfd_set(pkptr,"piconet",piconet_number);
				
		op_pk_nfd_get(pkptr,"frequency",&transmission_frequency);
		
		/* START	DEBUG INFORMATION */
		if (transmit_debug)
			{
			printf ("\n|-----------------------------------------------------------\n");
			printf ("| BlueTooth MAC TX Info (%s) number %d from piconet %d\n", bt_device_name, my_address, piconet_number);
			printf ("| \tPacket to the master at %.6f (size %.1f)\n", op_sim_time(),op_pk_total_size_get(pkptr) );
			printf ("| \tTransmission frequency: %f\n", transmission_frequency);
			printf ("| \tPacket info: %s (seqn %d; ack %d)\n", bt_print_type_packet(packet_type),
				tx_sequence_number, tx_acknowledgement);
			printf ("|-----------------------------------------------------------\n");
			}
		/* END OF	DEBUG INFORMATION */
		
		bt_print_count_packet(0, piconet_number);
			
		/* Finally forward the packet to the TX */
		op_pk_deliver(pkptr, topo_get_channel(), BLUETOOTH_INPUT_STREAM);
		
		} /* Otherwise, transmit nothing! */


	FOUT;
}


/*
 * $Function:		bt_packet_to_receive
 *
 * $Description:	Check with the Receiver algorithm
 *					if there is a packet ready to TX or
 *					not. If there is any, send it to the
 *					lower layer
 */

static void bt_packet_to_receive ()
{
	Packet *	pkptr;
	int			packet_type;
	int			dest_address;
	Boolean		accept,seqn;
	
	char	format[16];
	double	pkt_id;

	Boolean	receive_debug = op_prg_odb_ltrace_active ("receive");

	FIN (bt_packet_to_receive ());

	/* Get the packet from lower layer */
	pkptr = op_pk_get(op_intrpt_strm());
   	
	op_pk_nfd_get(pkptr, "TYPE", &packet_type);
	
	// get the packet format and the pkt_id
	op_pk_format (pkptr, format);
	pkt_id = op_pk_id(pkptr);
			
	/* Make some basic checks on the packet information */
	/* in order to make sure that this packet belong to */
	/* this station */
	op_pk_nfd_get(pkptr, "AM_ADDR", &dest_address);

	if ( (my_address != dest_address) && (AM_ADDR_BROADCAST != dest_address) )
	{
	  /* START	DEBUG INFORMATION */
	  if (receive_debug)
		  {
		  printf("\n|------------------------------------------------------------------|\n");
		  printf ( "|\tBluetooth MAC Receiver Info (Slave %d): Station received a packet at destination %d, discard it.\n", my_address, dest_address );
		  }
	  /* END OF	DEBUG INFORMATION */

	  packet_accepted_flag = OPC_FALSE;				/* Packet has been rejected */
	  op_pk_destroy (pkptr);						/* And destroy the packet, ARQ is not affected */
	}
	else /* This packet belong to this station, process it */
	{ 
	/* Set the packet accepted flag. If it is a broadcast packet, nobody can answer */
	  packet_accepted_flag = (AM_ADDR_BROADCAST != dest_address)?OPC_TRUE:OPC_FALSE;
	  
	  /* Make sure that the packet is in good shape */
	  /* Look also if it follows the sequence number scheme */
	  /* op_prg_mem_free last stored packet if acknowledged */
	  op_pk_nfd_get(pkptr, "Accept", &accept);
	  op_pk_nfd_get(pkptr, "SEQN", &seqn);
	  op_pk_nfd_get(pkptr, "ARQ", &acknowledgement);

	  /* START	DEBUG INFORMATION */
	  if (receive_debug)
		  {
		  printf ("\n|------------------------------------------------------------------|\n");
		  printf ("| \tBlueTooth MAC RX Info (%s, time %.6f).\n", bt_device_name, op_sim_time());
		  printf ("| \tPacket info: (%s, seqn %d, ack %d, %s)\n",bt_print_type_packet(packet_type),
			  seqn, acknowledgement, (accept)?"accepted":"lost");
		  }
	  /* END OF	DEBUG INFORMATION */
	  
	  /* Get packet type information */
	  op_pk_nfd_get(pkptr, "TYPE", &packet_type);

	  switch ( packet_type )
	  {												/* From the slave point of view */
		/*case	POLL_TYPE:							/* For Control traffic, do not retransmit */
		case	HV1_TYPE:							/* No retransmit scheme for voice packets either */
		case	HV2_TYPE:
		case	HV3_TYPE:
		break;

		default:									/* For all ACL traffic, retransmit scheme applies */
		  if (accept && retransmit_pkptr && acknowledgement)	 /* If the previous packet has been ACK */
		  {											/* Free the retransmission resource */
			bt_destroy_packet(retransmit_pkptr);	/* And start with a new payload in the next */
			retransmit_pkptr = NULL;				/* Transmission slot */
		  }
		break;
	  }

	  switch ( packet_type )
	  {
		/*case	POLL_TYPE:							/* The slave never receive NULL packets from Master */
		case	HV1_TYPE:							/* Control traffic, ARQ, and SEQN still as is */
		case	HV2_TYPE:							/* Voice packets have no ARQ, and SEQN scheme either */
		case	HV3_TYPE:
			if ( accept )							/* If the packet has been accepted, forward it */
				bt_lower_layer_pkt_arrival(pkptr);	/* to the upper layer, do not affect the ARQ */
			else									/* Otherwise */
			{
				if (op_sim_time() >= start_time_collect)
					mac_number_of_pkt_lost++;			/* Packet lost */
				op_stat_write (mac_pkt_lost_stat, mac_number_of_pkt_lost/(mac_number_of_pkt_lost+mac_number_of_pkt_recv));
				bt_destroy_packet(pkptr);			/* Discard it and ignore it, don't stat the packet */
			}
		break;

		default:									/* All other traffic, ARQ, SEQN is neeeded */
		  											/* Taken from specification SDL p70 */
		  if ( !accept )	/* Too many errors, the CRC and FEC failed, then Reject the packet */
			  {
			  tx_acknowledgement = OPC_FALSE;			/* Packet rejected NAK for next transmission */
			  if (op_sim_time() >= start_time_collect)
				  {
				  mac_number_of_pkt_lost++;				/* Packet lost */
				  if (receive_debug) printf ("| \tPacket lost; %f lost packets so far.\n",mac_number_of_pkt_lost);
  				  }
			  
			  op_stat_write (mac_pkt_lost_stat, mac_number_of_pkt_lost/(mac_number_of_pkt_lost+mac_number_of_pkt_recv));
			  bt_destroy_packet(pkptr);				/* Discard it */
			  if (receive_debug) printf ("| \tSlave Reject Payload (RX seqn %d, rt %x)\n", rx_sequence_number, retransmit_pkptr);
			  null_ack = OPC_FALSE;
			  }
		else
			{
			if (seqn == rx_sequence_number) /* SEQN = SEQNold */
				{	
				if (op_sim_time() >= start_time_collect)
					number_of_ignored_pkt++;
				
				tx_acknowledgement = OPC_TRUE;			/* True ACK */
				bt_destroy_packet(pkptr);				/* But ignore the Payload */
				if (receive_debug) printf ("| \tSlave Ignore Payload (RX seqn %d, rt %x) %g\n", rx_sequence_number, retransmit_pkptr, op_sim_time());
				null_ack = OPC_FALSE;
				}
			else
				{
				if (receive_debug) printf ("| \tSlave Accept Payload (RX seqn %d, rt %x) %g\n", rx_sequence_number, retransmit_pkptr, op_sim_time());// (update_tx_sequence)?"True":"False");
				
				null_ack = (packet_type == NULL_TYPE)?OPC_TRUE:OPC_FALSE;
				rx_sequence_number = (rx_sequence_number)?OPC_FALSE:OPC_TRUE;		   /* Update the sequence */
								
				tx_acknowledgement = OPC_TRUE;			/* True ACK for next packet */
				
				/* Update the number of retransmission attempts stat for the last packet */
				if (retransmission_attempts)
					{
					op_stat_write (mac_rt_attempt_stat, retransmission_attempts);
					retransmission_attempts = 0;		/* Retransmission attempts for the next packet */
					}
				/* Finally forward the packet to the MAC */
				bt_lower_layer_pkt_arrival (pkptr);
  				}
			}
		  break;
		  }
	  }

	if (receive_debug) printf("|------------------------------------------------------------------|\n");
	
	FOUT;
}


/* modif olivier */
static void bt_get_position (Objid objid, double* x_position, double* y_position)
	{
	double delta_x, delta_y;
	
	FIN (bt_get_position ( objid, x_position, y_position));
	
	op_ima_obj_attr_get ( op_topo_parent(objid), "x position", x_position);
	op_ima_obj_attr_get ( op_topo_parent(objid), "y position", y_position);
	
	op_ima_obj_attr_get ( objid, "Delta x", &delta_x);
	op_ima_obj_attr_get ( objid, "Delta y", &delta_y);
	
	*x_position += delta_x;
	*y_position += delta_y;
	
	FOUT;
	}


/*
 * Function : slave_end_of_simulation ()
 *
 * Description : end of simulation
 */

static void  slave_end_of_simulation ()
	{
	const char *stat_loss = "_pkt_loss";
	const char *stat_error = "_mac_errors";
	const char *stat_l2cap_delay = "_l2cap_delay";
	Objid file_objid, file_attr_objid,parent_objid;
	Objid file_channel_objid, file_channel_attr_objid;
	char 	name[64], label[1024] = "";
	char	results[1024] = "";
	char * 	table_label [] = {"Delta x", "Delta y", "x virtual", "y virtual",
		"data packet loss", "packet loss", "number of packets lost",
		"number of packets received","number of packets send",
		"power", "number of packets ignored",
		"number of null packets", "number of poll packets", 
		"packets in the buffer"};
	double *	numeric_result;
	Boolean *	boolean;
	double 		packet_loss, data_packet_loss, total_packet;
	double 		l2cap_delay;
	int 		i;
	char 		out_file_name[32];
	char		file_type[8], separator[3];
	
	int			label_size = sizeof(table_label)/sizeof(char *);
	Boolean		separator_on;
	
	
	FIN ( bt_end_of_simulation() );

	/* get the node objid */
	parent_objid = op_topo_parent (op_id_self());
	
	/* Allocate some memaory */
	boolean 		= (Boolean *) op_prg_mem_alloc (label_size * sizeof(Boolean));
	numeric_result 	= (double *) op_prg_mem_alloc (label_size*sizeof(double));

	/* get the report attributes */
	op_ima_obj_attr_get (op_id_self(), "Report", &file_attr_objid);
	file_objid = op_topo_child (file_attr_objid, OPC_OBJTYPE_GENERIC,0);
		
	op_ima_obj_attr_get ( file_objid, "out file name", out_file_name);
	op_ima_obj_attr_get ( file_objid, "File type", file_type);
	
	if (strcmp (out_file_name, "Auto") == 0)
		strcpy (out_file_name, bt_device_name);
	
	if (strcmp (file_type, "Default") == 0)
		{
		op_ima_obj_attr_get (topo_get_channel (), "Report", &file_channel_attr_objid);
		file_channel_objid = op_topo_child (file_channel_attr_objid, OPC_OBJTYPE_GENERIC,0);
		op_ima_obj_attr_get ( file_channel_objid, "File type", file_type);
		}

	if (strcmp (file_type, ".csv") == 0)
		strcpy (separator, ", ");
	else if (strcmp (file_type, ".txt") == 0)
		strcpy (separator, "\t\t");
	
	/* Print informations about the output files */
	printf ("\n|-------------------------------------------------------------------------|\n");
	printf ("| Info for %s out files :\n", bt_device_name);
	printf ("| \tout file basename : %s\n", out_file_name);
	printf ("|-------------------------------------------------------------------------|\n");
	
		/* get the next file name */	
	sprintf (name, "%s%s%s", out_file_name, stat_loss, file_type);

	/* Compute the packet loss*/
	total_packet = (double)(mac_number_of_pkt_lost + mac_number_of_pkt_recv + number_of_ignored_pkt + mac_number_of_pkt_null + mac_number_of_poll_pkt);
	
	if (total_packet)
		packet_loss = (double)mac_number_of_pkt_lost/total_packet;
	else
		packet_loss = 0.0;
	
	/* Compute the data packet loss*/
	total_packet = (double)(mac_number_of_pkt_lost + mac_number_of_pkt_recv + number_of_ignored_pkt);
	
	if (total_packet)
		data_packet_loss = (double)mac_number_of_pkt_lost/total_packet;
	else
		data_packet_loss = 0.0;
	
	/* Initialize separator_on to false */
	separator_on = OPC_FALSE;
	
	for (i = 0; i < label_size; i++)
		{
		/* init the numeric result */
		numeric_result[i]=-1.0;
		op_ima_obj_attr_get(file_objid,table_label[i],&boolean[i]);
	
		if (boolean[i])
			{
			sprintf (label, "%s%s%s", label, separator_on?separator:"", table_label[i]);
			separator_on = OPC_TRUE;
			}
		}
	
	bt_get_position(my_objid, &numeric_result[2], &numeric_result[3]);
	
	if (boolean[0])	op_ima_obj_attr_get (my_objid,"Delta x",&numeric_result[0]);
	if (boolean[1]) op_ima_obj_attr_get (my_objid,"Delta y",&numeric_result[1]);
	if (!boolean[2]) numeric_result[2] = -1.0;
	if (!boolean[3]) numeric_result[3] = -1.0;
	if (boolean[4]) numeric_result[4] = data_packet_loss;
	if (boolean[5]) numeric_result[5] = packet_loss;
	if (boolean[6]) numeric_result[6] = (double) mac_number_of_pkt_lost;
   	if (boolean[7]) numeric_result[7] = (double) mac_number_of_pkt_recv;
	if (boolean[8]) numeric_result[8] = (double) mac_number_of_pkt_send;
	if (boolean[9]) op_ima_obj_attr_get (my_objid,"power",&numeric_result[9]);
	if (boolean[10]) numeric_result[10] = (double) number_of_ignored_pkt;
	if (boolean[11]) numeric_result[11] = (double) mac_number_of_pkt_null;
	if (boolean[12]) numeric_result[12] = (double) mac_number_of_poll_pkt;
	if (boolean[13]) numeric_result[13] = (double) packets_in_subqueues;

	/* Initialize separator_on to false */
	separator_on = OPC_FALSE;
	
	for (i = 0; i < label_size; i++)
		{
		if (numeric_result[i] != -1.0)
			{
			sprintf (results ,"%s%s%f", results, separator_on?separator:"", numeric_result[i]);
			separator_on = OPC_TRUE;
			}
		}
	
	/* print the file */
	bt_stats_print_report (name, label, results, OPC_TRUE);

	
	/* Get the name of the file */
	sprintf (name, "%s%s%s", out_file_name, stat_error, file_type);
	
	/* get the header and the data variable */
	sprintf (label, "Error");
	sprintf (results ,"%f", (float)total_payload_errs  / (float)bt_pk_collided );
	
	/* print the file */
	bt_stats_print_report (name, label, results, OPC_TRUE);

	/* Get the next file name */
	sprintf (name, "%s%s%s", out_file_name, stat_l2cap_delay, file_type);
	
	/* Compute L2CAP delay */
	if (l2cap_number_of_pkt_recv)
		l2cap_delay = (double) total_l2cap_delay / (double) l2cap_number_of_pkt_recv;
	else
		l2cap_delay = 0.0;
	
	/* Set the header and data variable */
	sprintf (label, "L2CAP Delay%stotal L2CAP Delay%sNumber of pkt recv", separator, separator);
	sprintf (results ,"%f%s%f%s%f",l2cap_delay, separator, total_l2cap_delay, separator, l2cap_number_of_pkt_recv);
	
	/* print the file */
	bt_stats_print_report (name, label, results, OPC_TRUE);
	
	/* Free the memory */
	op_prg_mem_free (boolean);
	op_prg_mem_free (numeric_result);
	
	/* Print the TCP statitics */
	bt_stats_tcp_end_of_simulation ();
	bt_stats_udp_end_of_simulation ();
	
	bt_mac_free_memory ();
	
	FOUT;
	}

/*
 * Function : bt_mac_free_memory ()
 *
 * Description : free the memory
 */

static void bt_mac_free_memory ()
{
	FIN(bt_mac_free_memory ());
	
	op_prg_mem_free (bt_device_name);
	fifo_end_free (fifo_bt_queue);
	
	FOUT;
}

/* End of Function Block */

/* Undefine optional tracing in FIN/FOUT/FRET */
/* The FSM has its own tracing code and the other */
/* functions should not have any tracing.		  */
#undef FIN_TRACING
#define FIN_TRACING

#undef FOUTRET_TRACING
#define FOUTRET_TRACING

#if defined (__cplusplus)
extern "C" {
#endif
	void bt_mac_slave (void);
	Compcode bt_mac_slave_init (void **);
	void bt_mac_slave_diag (void);
	void bt_mac_slave_terminate (void);
	void bt_mac_slave_svar (void *, const char *, char **);
#if defined (__cplusplus)
} /* end of 'extern "C"' */
#endif




/* Process model interrupt handling procedure */


void
bt_mac_slave (void)
	{
	int _block_origin = 0;
	FIN (bt_mac_slave ());
	if (1)
		{
		/* declare some variables for the init state */
		double					mac_address;
		int                     piconet_read;
		OmsT_Pr_Handle			process_record_handle;
		Objid					my_node_objid;
		Objid					my_subnet_objid;
		Prohandle				own_prohandle;
		char					proc_model_name[256];
		
		char	line[128];


		FSM_ENTER (bt_mac_slave)

		FSM_BLOCK_SWITCH
			{
			/*---------------------------------------------------------*/
			/** state (Init) enter executives **/
			FSM_STATE_ENTER_UNFORCED_NOLABEL (0, "Init", "bt_mac_slave () [Init enter execs]")
				{
				/* Initialize the process. Call the initialization */
				/* routine that load all the structures */
				
				bt_mac_sv_init ();
				
				
				/* Schedule a self interrupt to wait for the other processes 	*/
				/* to move to next state after registering						*/
				op_intrpt_schedule_self (op_sim_time (), 0);
				}


			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (1,bt_mac_slave)


			/** state (Init) exit executives **/
			FSM_STATE_EXIT_UNFORCED (0, "Init", "bt_mac_slave () [Init exit execs]")
				{
				/* Pro-handle of this process */
				own_prohandle = op_pro_self ();
				
				/* Get the objid of the node */
				my_node_objid = op_topo_parent(my_objid);
					
				/* Get the objid of the subnet */
				my_subnet_objid = op_topo_parent(my_node_objid);
						
				/* obtain the number of piconet of the device */
				op_ima_obj_attr_get (my_objid, "piconet", &piconet_read);
				
				/* Resolve address */
				oms_aa_address_resolve (oms_aa_handle, my_objid, &my_address);
					
				mac_address = (double) my_address;
					
				/* Register this device in the topology list */
				my_address = topo_slave_device_registration (bt_device_name, my_objid, piconet_read, my_address);
				   	
				piconet_number = topo_get_piconet_number(piconet_read);
				
				/* Registration for the other layers */
				process_record_handle = (OmsT_Pr_Handle) oms_pr_process_register (my_node_objid, my_objid, own_prohandle, proc_model_name);
				
				/* Register this protocol attribute and the station address of	*/
				/* this process into the model-wide registry.					*/
				oms_pr_attr_set (process_record_handle,
					"protocol",				OMSC_PR_STRING,			"mac",
					"mac_type",				OMSC_PR_STRING,			"Bluetooth",
					"subprotocol",			OMSC_PR_NUMBER,			(double) BLUETOOTH_STA,
					"subnetid",				OMSC_PR_OBJID,			my_subnet_objid,
					"address",				OMSC_PR_NUMBER,			mac_address,
					"auto address handle",	OMSC_PR_ADDRESS,		oms_aa_handle,
					OPC_NIL);
				}


			/** state (Init) transition processing **/
			FSM_TRANSIT_FORCE (6, state6_enter_exec, ;, "default", "", "Init", "init2")
				/*---------------------------------------------------------*/



			/** state (Idle) enter executives **/
			FSM_STATE_ENTER_UNFORCED (1, state1_enter_exec, "Idle", "bt_mac_slave () [Idle enter execs]")
				{
				/* This state is a waiting state for the MAC layer	*/
				/* It waits for a packet from the higher or lower	*/
				/* layer, or another event that can occurs like the */
				/* CLK event a packet transmission or reception		*/
				}


			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (3,bt_mac_slave)


			/** state (Idle) exit executives **/
			FSM_STATE_EXIT_UNFORCED (1, "Idle", "bt_mac_slave () [Idle exit execs]")
				{
				}


			/** state (Idle) transition processing **/
			FSM_INIT_COND (PACKET_FROM_HIGHER_LAYER)
			FSM_TEST_COND (READY_TO_RECEIVE)
			FSM_TEST_COND (SLAVE_CLK_TIMER_EXPIRED)
			FSM_TEST_COND (SIM_END)
			FSM_DFLT_COND
			FSM_TEST_LOGIC ("Idle")

			FSM_TRANSIT_SWITCH
				{
				FSM_CASE_TRANSIT (0, 2, state2_enter_exec, ;, "PACKET_FROM_HIGHER_LAYER", "", "Idle", "Buffer")
				FSM_CASE_TRANSIT (1, 4, state4_enter_exec, ;, "READY_TO_RECEIVE", "", "Idle", "RX")
				FSM_CASE_TRANSIT (2, 5, state5_enter_exec, ;, "SLAVE_CLK_TIMER_EXPIRED", "", "Idle", "clock")
				FSM_CASE_TRANSIT (3, 1, state1_enter_exec, slave_end_of_simulation();, "SIM_END", "slave_end_of_simulation()", "Idle", "Idle")
				FSM_CASE_TRANSIT (4, 1, state1_enter_exec, ;, "default", "", "Idle", "Idle")
				}
				/*---------------------------------------------------------*/



			/** state (Buffer) enter executives **/
			FSM_STATE_ENTER_FORCED (2, state2_enter_exec, "Buffer", "bt_mac_slave () [Buffer enter execs]")
				{
				/* Process the incomming packet */
				switch (op_intrpt_strm())
				{
					case	HIGHER_LAYER_INPUT_STREAM:
						/* When a packet is received from the higher layer	*/
						/* process it thru the L2CAP encapsulation and		*/
						/* segmentation, then enqueue it in the different	*/
						/* subqueues for processing							*/
						bt_higher_layer_pkt_arrival ();
					break;
				
					case	HIGHER_LAYER_VC_INPUT_STREAM:
						/* When a voice packet is received from the higher */
						/* layer enqueue it in subqueues for processing	*/
						bt_higher_layer_sco_pkt_arrival ();
					break;
				}
				}


			/** state (Buffer) exit executives **/
			FSM_STATE_EXIT_FORCED (2, "Buffer", "bt_mac_slave () [Buffer exit execs]")
				{
				}


			/** state (Buffer) transition processing **/
			FSM_TRANSIT_FORCE (1, state1_enter_exec, ;, "default", "", "Buffer", "Idle")
				/*---------------------------------------------------------*/



			/** state (TX) enter executives **/
			FSM_STATE_ENTER_FORCED (3, state3_enter_exec, "TX", "bt_mac_slave () [TX enter execs]")
				{
				/*
				 * Ask a packet to the scheduler and if there is any
				 * waiting to be transmitted, then process it thru the
				 * TX
				 */
				
				/*
				 * the function bt_packet_to_transmit will be executed if
				 * the flag_backoff is off or if the current time is greater
				 * than the backoff time
				 */
				 
				bt_packet_to_transmit ();
				}


			/** state (TX) exit executives **/
			FSM_STATE_EXIT_FORCED (3, "TX", "bt_mac_slave () [TX exit execs]")
				{
				}


			/** state (TX) transition processing **/
			FSM_TRANSIT_FORCE (1, state1_enter_exec, ;, "default", "", "TX", "Idle")
				/*---------------------------------------------------------*/



			/** state (RX) enter executives **/
			FSM_STATE_ENTER_FORCED (4, state4_enter_exec, "RX", "bt_mac_slave () [RX enter execs]")
				{
				/* Get a packet from the receiver and decapsulate it	*/
				/* using the L2CAP layer */
				bt_packet_to_receive ();
				}


			/** state (RX) exit executives **/
			FSM_STATE_EXIT_FORCED (4, "RX", "bt_mac_slave () [RX exit execs]")
				{
				}


			/** state (RX) transition processing **/
			FSM_TRANSIT_FORCE (1, state1_enter_exec, ;, "default", "", "RX", "Idle")
				/*---------------------------------------------------------*/



			/** state (clock) enter executives **/
			FSM_STATE_ENTER_FORCED (5, state5_enter_exec, "clock", "bt_mac_slave () [clock enter execs]")
				{
				}


			/** state (clock) exit executives **/
			FSM_STATE_EXIT_FORCED (5, "clock", "bt_mac_slave () [clock exit execs]")
				{
				}


			/** state (clock) transition processing **/
			FSM_INIT_COND (READY_TO_TRANSMIT)
			FSM_DFLT_COND
			FSM_TEST_LOGIC ("clock")

			FSM_TRANSIT_SWITCH
				{
				FSM_CASE_TRANSIT (0, 3, state3_enter_exec, ;, "READY_TO_TRANSMIT", "", "clock", "TX")
				FSM_CASE_TRANSIT (1, 1, state1_enter_exec, ;, "default", "", "clock", "Idle")
				}
				/*---------------------------------------------------------*/



			/** state (init2) enter executives **/
			FSM_STATE_ENTER_UNFORCED (6, state6_enter_exec, "init2", "bt_mac_slave () [init2 enter execs]")
				{
				/* Schedule a self interrupt to wait for the other processes 	*/
				/* to move to next state after registering						*/
				op_intrpt_schedule_self (op_sim_time () + 0.0000001, 0);
				}


			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (13,bt_mac_slave)


			/** state (init2) exit executives **/
			FSM_STATE_EXIT_UNFORCED (6, "init2", "bt_mac_slave () [init2 exit execs]")
				{
				}


			/** state (init2) transition processing **/
			FSM_TRANSIT_FORCE (1, state1_enter_exec, ;, "default", "", "init2", "Idle")
				/*---------------------------------------------------------*/



			}


		FSM_EXIT (0,bt_mac_slave)
		}
	}

#if defined (__cplusplus)
	extern "C" { 
#endif
	extern VosT_Fun_Status Vos_Catmem_Register (const char * , int , VosT_Void_Null_Proc, VosT_Address *);
	extern VosT_Address Vos_Catmem_Alloc (VosT_Address, size_t);
	extern VosT_Fun_Status Vos_Catmem_Dealloc (VosT_Address);
#if defined (__cplusplus)
	}
#endif


Compcode
bt_mac_slave_init (void ** gen_state_pptr)
	{
	int _block_origin = 0;
	static VosT_Address	obtype = OPC_NIL;

	FIN (bt_mac_slave_init (gen_state_pptr))

	if (obtype == OPC_NIL)
		{
		/* Initialize memory management */
		if (Vos_Catmem_Register ("proc state vars (bt_mac_slave)",
			sizeof (bt_mac_slave_state), Vos_Vnop, &obtype) == VOSC_FAILURE)
			{
			FRET (OPC_COMPCODE_FAILURE)
			}
		}

	*gen_state_pptr = Vos_Catmem_Alloc (obtype, 1);
	if (*gen_state_pptr == OPC_NIL)
		{
		FRET (OPC_COMPCODE_FAILURE)
		}
	else
		{
		/* Initialize FSM handling */
		((bt_mac_slave_state *)(*gen_state_pptr))->current_block = 0;

		FRET (OPC_COMPCODE_SUCCESS)
		}
	}



void
bt_mac_slave_diag (void)
	{
	/* No Diagnostic Block */
	}




void
bt_mac_slave_terminate (void)
	{
	int _block_origin = __LINE__;

	FIN (bt_mac_slave_terminate (void))

	Vos_Catmem_Dealloc (pr_state_ptr);

	FOUT;
	}


/* Undefine shortcuts to state variables to avoid */
/* syntax error in direct access to fields of */
/* local variable prs_ptr in bt_mac_slave_svar function. */
#undef my_address
#undef packets_in_subqueues
#undef packet_accepted_flag
#undef mac_access_delay_stat
#undef mac_throughput_stat
#undef mac_goodput_stat
#undef mac_total_pkt_bits
#undef mac_total_frame_body_bits
#undef mac_number_of_pkt_send
#undef mac_number_of_pkt_recv
#undef mac_packets_send_stat
#undef mac_packets_recv_stat
#undef retransmit_pkptr
#undef acknowledgement
#undef tx_sequence_number
#undef mac_rt_attempt_stat
#undef retransmission_attempts
#undef reassembly_buffer
#undef l2cap_access_delay_stat
#undef l2cap_goodput_stat
#undef l2cap_throughput_stat
#undef l2cap_total_pkt_bits
#undef l2cap_total_frame_body_bits
#undef l2cap_number_of_pkt_send
#undef l2cap_number_of_pkt_recv
#undef l2cap_packets_send_stat
#undef l2cap_packets_recv_stat
#undef reassembly_creation_time
#undef mac_pkt_lost_stat
#undef mac_number_of_pkt_lost
#undef number_of_ignored_pkt
#undef mac_number_of_pkt_null
#undef mac_number_of_poll_pkt
#undef rx_sequence_number
#undef update_tx_sequence
#undef sco_packets_send_stat
#undef sco_packets_recv_stat
#undef sco_number_of_pkt_send
#undef sco_number_of_pkt_recv
#undef poll_answer
#undef mac_payload_errs_stat
#undef null_ack
#undef tx_acknowledgement
#undef my_stat
#undef my_value
#undef total_payload_errs
#undef total_l2cap_delay
#undef piconet_number
#undef debug_flag
#undef my_objid
#undef bt_device_name
#undef start_time_collect
#undef oms_aa_handle
#undef fifo_bt_queue
#undef l2cap_segmentation_size
#undef l2cap_packet_type



void
bt_mac_slave_svar (void * gen_ptr, const char * var_name, char ** var_p_ptr)
	{
	bt_mac_slave_state		*prs_ptr;

	FIN (bt_mac_slave_svar (gen_ptr, var_name, var_p_ptr))

	if (var_name == OPC_NIL)
		{
		*var_p_ptr = (char *)OPC_NIL;
		FOUT;
		}
	prs_ptr = (bt_mac_slave_state *)gen_ptr;

	if (strcmp ("my_address" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->my_address);
		FOUT;
		}
	if (strcmp ("packets_in_subqueues" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->packets_in_subqueues);
		FOUT;
		}
	if (strcmp ("packet_accepted_flag" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->packet_accepted_flag);
		FOUT;
		}
	if (strcmp ("mac_access_delay_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_access_delay_stat);
		FOUT;
		}
	if (strcmp ("mac_throughput_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_throughput_stat);
		FOUT;
		}
	if (strcmp ("mac_goodput_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_goodput_stat);
		FOUT;
		}
	if (strcmp ("mac_total_pkt_bits" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_total_pkt_bits);
		FOUT;
		}
	if (strcmp ("mac_total_frame_body_bits" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_total_frame_body_bits);
		FOUT;
		}
	if (strcmp ("mac_number_of_pkt_send" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_number_of_pkt_send);
		FOUT;
		}
	if (strcmp ("mac_number_of_pkt_recv" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_number_of_pkt_recv);
		FOUT;
		}
	if (strcmp ("mac_packets_send_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_packets_send_stat);
		FOUT;
		}
	if (strcmp ("mac_packets_recv_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_packets_recv_stat);
		FOUT;
		}
	if (strcmp ("retransmit_pkptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->retransmit_pkptr);
		FOUT;
		}
	if (strcmp ("acknowledgement" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->acknowledgement);
		FOUT;
		}
	if (strcmp ("tx_sequence_number" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->tx_sequence_number);
		FOUT;
		}
	if (strcmp ("mac_rt_attempt_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_rt_attempt_stat);
		FOUT;
		}
	if (strcmp ("retransmission_attempts" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->retransmission_attempts);
		FOUT;
		}
	if (strcmp ("reassembly_buffer" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->reassembly_buffer);
		FOUT;
		}
	if (strcmp ("l2cap_access_delay_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->l2cap_access_delay_stat);
		FOUT;
		}
	if (strcmp ("l2cap_goodput_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->l2cap_goodput_stat);
		FOUT;
		}
	if (strcmp ("l2cap_throughput_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->l2cap_throughput_stat);
		FOUT;
		}
	if (strcmp ("l2cap_total_pkt_bits" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->l2cap_total_pkt_bits);
		FOUT;
		}
	if (strcmp ("l2cap_total_frame_body_bits" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->l2cap_total_frame_body_bits);
		FOUT;
		}
	if (strcmp ("l2cap_number_of_pkt_send" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->l2cap_number_of_pkt_send);
		FOUT;
		}
	if (strcmp ("l2cap_number_of_pkt_recv" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->l2cap_number_of_pkt_recv);
		FOUT;
		}
	if (strcmp ("l2cap_packets_send_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->l2cap_packets_send_stat);
		FOUT;
		}
	if (strcmp ("l2cap_packets_recv_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->l2cap_packets_recv_stat);
		FOUT;
		}
	if (strcmp ("reassembly_creation_time" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->reassembly_creation_time);
		FOUT;
		}
	if (strcmp ("mac_pkt_lost_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_pkt_lost_stat);
		FOUT;
		}
	if (strcmp ("mac_number_of_pkt_lost" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_number_of_pkt_lost);
		FOUT;
		}
	if (strcmp ("number_of_ignored_pkt" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->number_of_ignored_pkt);
		FOUT;
		}
	if (strcmp ("mac_number_of_pkt_null" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_number_of_pkt_null);
		FOUT;
		}
	if (strcmp ("mac_number_of_poll_pkt" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_number_of_poll_pkt);
		FOUT;
		}
	if (strcmp ("rx_sequence_number" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->rx_sequence_number);
		FOUT;
		}
	if (strcmp ("update_tx_sequence" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->update_tx_sequence);
		FOUT;
		}
	if (strcmp ("sco_packets_send_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->sco_packets_send_stat);
		FOUT;
		}
	if (strcmp ("sco_packets_recv_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->sco_packets_recv_stat);
		FOUT;
		}
	if (strcmp ("sco_number_of_pkt_send" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->sco_number_of_pkt_send);
		FOUT;
		}
	if (strcmp ("sco_number_of_pkt_recv" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->sco_number_of_pkt_recv);
		FOUT;
		}
	if (strcmp ("poll_answer" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->poll_answer);
		FOUT;
		}
	if (strcmp ("mac_payload_errs_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_payload_errs_stat);
		FOUT;
		}
	if (strcmp ("null_ack" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->null_ack);
		FOUT;
		}
	if (strcmp ("tx_acknowledgement" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->tx_acknowledgement);
		FOUT;
		}
	if (strcmp ("my_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->my_stat);
		FOUT;
		}
	if (strcmp ("my_value" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->my_value);
		FOUT;
		}
	if (strcmp ("total_payload_errs" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->total_payload_errs);
		FOUT;
		}
	if (strcmp ("total_l2cap_delay" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->total_l2cap_delay);
		FOUT;
		}
	if (strcmp ("piconet_number" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->piconet_number);
		FOUT;
		}
	if (strcmp ("debug_flag" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->debug_flag);
		FOUT;
		}
	if (strcmp ("my_objid" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->my_objid);
		FOUT;
		}
	if (strcmp ("bt_device_name" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->bt_device_name);
		FOUT;
		}
	if (strcmp ("start_time_collect" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->start_time_collect);
		FOUT;
		}
	if (strcmp ("oms_aa_handle" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->oms_aa_handle);
		FOUT;
		}
	if (strcmp ("fifo_bt_queue" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->fifo_bt_queue);
		FOUT;
		}
	if (strcmp ("l2cap_segmentation_size" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->l2cap_segmentation_size);
		FOUT;
		}
	if (strcmp ("l2cap_packet_type" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->l2cap_packet_type);
		FOUT;
		}
	*var_p_ptr = (char *)OPC_NIL;

	FOUT;
	}

