/* Process model C form file: bt_mac_mast.pr.c */
/* Portions of this file copyright 1992-2002 by OPNET Technologies, Inc. */



/* This variable carries the header into the object file */
static const char bt_mac_mast_pr_c [] = "MIL_3_Tfile_Hdr_ 81A 30A modeler 7 3E2875E4 3E2875E4 1 skydiver rebala 0 0 none none 0 0 none 0 0 0 0 0 0                                                                                                                                                                                                                                                                                                                                                                                                                      ";
#include <string.h>



/* OPNET system definitions */
#include <opnet.h>

#if defined (__cplusplus)
extern "C" {
#endif
FSM_EXT_DECS
#if defined (__cplusplus)
} /* end of 'extern "C"' */
#endif


/* Header Block */

/*
** $RCSfile:
**
** Bluetooth model in Opnet
** National Institute of Standards and Technology
**
** This model was developed at the National Institute of Standards
** and Technology by employees of the Federal Government in the course
** of their official duties. Pursuant to title 17 Section 105 of the
** United States Code this software is not subject to copyright
** protection and is in the public domain. This is an experimental
** system.  NIST assumes no responsibility whatsoever for its use by
** other parties, and makes no guarantees, expressed or implied,
** about its quality, reliability, or any other characteristic.
**
** We would appreciate acknowledgement if the model is used.
**
** NIST ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION
** AND DISCLAIM ANY LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER
** RESULTING FROM THE USE OF THIS SOFTWARE.
**
** Primary Author:      Frederic Mouveaux
** Module description:  MAC Protocol in Bluetooth
** Last Modification:   May, 18, 2000
*/

/* Standard includes */
#include "oms_pr.h"
#include "oms_auto_addr_support.h"
#include "bt_support.h"
#include "rr_support.h"
#include "topo_discovery.h"
#include "slaves_management.h"
#include "l2cap_support.h"
#include "bt_stats_write.h"
/* Define the macros for the events */

/* We are ready to transmit */
#define READY_TO_TRANSMIT               ((!TIME_SLOT_PARITY_ODD) && \
										 (!PACKET_DELIVERY))

/*modif issam */
#define SIM_END                          (op_intrpt_type() == OPC_INTRPT_ENDSIM)

/*define some prameter*/
double   freq; /*to store the transmission frequency*/
double   t_x,r_x,t_y,r_y;/*to store the coordinate of the nodes*/
double   transmission_power;
int      bt_pkt_collided;

int      adresse = 1;

/* Function prototypes declaration */
static void		bt_mac_sv_init ();									/* MAC Process Initilization */
static void		bt_higher_layer_pkt_arrival ();						/* L2CAP encapsulation */
static void		bt_higher_layer_sco_pkt_arrival ();					/* SCO traffic */
static void		bt_lower_layer_pkt_arrival (Packet * pkptr);		/* L2CAP reassembly */
static void		bt_packet_to_transmit ();							/* Packet transmission */
static void		bt_packet_to_receive ();							/* Packet reception */
static void		bt_get_position (Objid objid, double* x_position, double* y_position); /* get the position of the devices */
static void     master_end_of_simulation ();
static int		bt_poll_dest_address ();
static void		bt_mac_free_memory ();

/* End of Header Block */


#if !defined (VOSD_NO_FIN)
#undef	BIN
#undef	BOUT
#define	BIN		FIN_LOCAL_FIELD(last_line_passed) = __LINE__ - _block_origin;
#define	BOUT	BIN
#define	BINIT	FIN_LOCAL_FIELD(last_line_passed) = 0; _block_origin = __LINE__;
#else
#define	BINIT
#endif /* #if !defined (VOSD_NO_FIN) */



/* State variable definitions */
typedef struct
	{
	/* Internal state tracking for FSM */
	FSM_SYS_STATE
	/* State Variables */
	int	                    		my_address;
	Objid	                  		my_objid;
	int*	                   		packets_in_subqueues;
	Stathandle	             		mac_access_delay_stat;
	Stathandle	             		mac_throughput_stat;
	Stathandle	             		mac_goodput_stat;
	Stathandle	             		hop_freq_stat;
	double	                 		mac_total_pkt_bits;
	double	                 		mac_total_frame_body_bits;
	Boolean	                		packet_delivery_in_progress;
	Stathandle	             		mac_packets_send_stat;
	Stathandle	             		mac_packets_recv_stat;
	double	                 		mac_number_of_pkt_send;
	double	                 		mac_number_of_pkt_recv;
	Boolean*	               		acknowledgement;
	Boolean*	               		tx_sequence_number;
	Stathandle	             		mac_rt_attempt_stat;
	double*	                		retransmission_attempts;
	int	                    		reassembly_buffer;
	Stathandle	             		l2cap_access_delay_stat;
	Stathandle	             		l2cap_goodput_stat;
	Stathandle	             		l2cap_throughput_stat;
	Stathandle	             		l2cap_packets_send_stat;
	Stathandle	             		l2cap_packets_recv_stat;
	double	                 		l2cap_number_of_pkt_send;
	double*	                		l2cap_number_of_pkt_recv;
	double	                 		l2cap_total_pkt_bits;
	double	                 		l2cap_total_frame_body_bits;
	double	                 		reassembly_creation_time;
	Stathandle	             		mac_pkt_lost_stat;
	double	                 		mac_number_of_pkt_lost;
	Boolean*	               		rx_sequence_number;
	Boolean*	               		update_tx_sequence;
	int	                    		destination_address;
	Stathandle	             		sco_packets_send_stat;
	Stathandle	             		sco_packets_recv_stat;
	double	                 		sco_number_of_pkt_send;
	double	                 		sco_number_of_pkt_recv;
	Boolean	                		poll_answer;
	Boolean	                		tx_acl;
	Stathandle	             		mac_payload_errs_stat;
	Boolean*	               		null_ack;
	Boolean*	               		tx_acknowledgement;
	int	                    		total_payload_errs;
	double*	                		total_l2cap_delay;
	int	                    		previous_dest_addr;
	Packet**	               		retransmit_pkptr;
	int	                    		piconet_number;
	int	                    		debug_flag;
	int	                    		number_of_slave;
	int	                    		dest_address_read;
	int	                    		previous_src_addr;
	Boolean*	               		txrx_ack;
	char*	                  		bt_master_name;
	int	                    		dest_addr_higher_layer;
	double	                 		start_time_collect;
	int	                    		number_of_pkt_ignored;
	int	                    		mac_number_of_pkt_null;
	Boolean	                		poll_packet_flag;
	OmsT_Aa_Address_Handle	 		oms_aa_handle;
	List **	                		rr_bt_queue;
	double	                 		l2cap_segmentation_size;
	int	                    		l2cap_packet_type;
	} bt_mac_mast_state;

#define pr_state_ptr            		((bt_mac_mast_state*) SimI_Mod_State_Ptr)
#define my_address              		pr_state_ptr->my_address
#define my_objid                		pr_state_ptr->my_objid
#define packets_in_subqueues    		pr_state_ptr->packets_in_subqueues
#define mac_access_delay_stat   		pr_state_ptr->mac_access_delay_stat
#define mac_throughput_stat     		pr_state_ptr->mac_throughput_stat
#define mac_goodput_stat        		pr_state_ptr->mac_goodput_stat
#define hop_freq_stat           		pr_state_ptr->hop_freq_stat
#define mac_total_pkt_bits      		pr_state_ptr->mac_total_pkt_bits
#define mac_total_frame_body_bits		pr_state_ptr->mac_total_frame_body_bits
#define packet_delivery_in_progress		pr_state_ptr->packet_delivery_in_progress
#define mac_packets_send_stat   		pr_state_ptr->mac_packets_send_stat
#define mac_packets_recv_stat   		pr_state_ptr->mac_packets_recv_stat
#define mac_number_of_pkt_send  		pr_state_ptr->mac_number_of_pkt_send
#define mac_number_of_pkt_recv  		pr_state_ptr->mac_number_of_pkt_recv
#define acknowledgement         		pr_state_ptr->acknowledgement
#define tx_sequence_number      		pr_state_ptr->tx_sequence_number
#define mac_rt_attempt_stat     		pr_state_ptr->mac_rt_attempt_stat
#define retransmission_attempts 		pr_state_ptr->retransmission_attempts
#define reassembly_buffer       		pr_state_ptr->reassembly_buffer
#define l2cap_access_delay_stat 		pr_state_ptr->l2cap_access_delay_stat
#define l2cap_goodput_stat      		pr_state_ptr->l2cap_goodput_stat
#define l2cap_throughput_stat   		pr_state_ptr->l2cap_throughput_stat
#define l2cap_packets_send_stat 		pr_state_ptr->l2cap_packets_send_stat
#define l2cap_packets_recv_stat 		pr_state_ptr->l2cap_packets_recv_stat
#define l2cap_number_of_pkt_send		pr_state_ptr->l2cap_number_of_pkt_send
#define l2cap_number_of_pkt_recv		pr_state_ptr->l2cap_number_of_pkt_recv
#define l2cap_total_pkt_bits    		pr_state_ptr->l2cap_total_pkt_bits
#define l2cap_total_frame_body_bits		pr_state_ptr->l2cap_total_frame_body_bits
#define reassembly_creation_time		pr_state_ptr->reassembly_creation_time
#define mac_pkt_lost_stat       		pr_state_ptr->mac_pkt_lost_stat
#define mac_number_of_pkt_lost  		pr_state_ptr->mac_number_of_pkt_lost
#define rx_sequence_number      		pr_state_ptr->rx_sequence_number
#define update_tx_sequence      		pr_state_ptr->update_tx_sequence
#define destination_address     		pr_state_ptr->destination_address
#define sco_packets_send_stat   		pr_state_ptr->sco_packets_send_stat
#define sco_packets_recv_stat   		pr_state_ptr->sco_packets_recv_stat
#define sco_number_of_pkt_send  		pr_state_ptr->sco_number_of_pkt_send
#define sco_number_of_pkt_recv  		pr_state_ptr->sco_number_of_pkt_recv
#define poll_answer             		pr_state_ptr->poll_answer
#define tx_acl                  		pr_state_ptr->tx_acl
#define mac_payload_errs_stat   		pr_state_ptr->mac_payload_errs_stat
#define null_ack                		pr_state_ptr->null_ack
#define tx_acknowledgement      		pr_state_ptr->tx_acknowledgement
#define total_payload_errs      		pr_state_ptr->total_payload_errs
#define total_l2cap_delay       		pr_state_ptr->total_l2cap_delay
#define previous_dest_addr      		pr_state_ptr->previous_dest_addr
#define retransmit_pkptr        		pr_state_ptr->retransmit_pkptr
#define piconet_number          		pr_state_ptr->piconet_number
#define debug_flag              		pr_state_ptr->debug_flag
#define number_of_slave         		pr_state_ptr->number_of_slave
#define dest_address_read       		pr_state_ptr->dest_address_read
#define previous_src_addr       		pr_state_ptr->previous_src_addr
#define txrx_ack                		pr_state_ptr->txrx_ack
#define bt_master_name          		pr_state_ptr->bt_master_name
#define dest_addr_higher_layer  		pr_state_ptr->dest_addr_higher_layer
#define start_time_collect      		pr_state_ptr->start_time_collect
#define number_of_pkt_ignored   		pr_state_ptr->number_of_pkt_ignored
#define mac_number_of_pkt_null  		pr_state_ptr->mac_number_of_pkt_null
#define poll_packet_flag        		pr_state_ptr->poll_packet_flag
#define oms_aa_handle           		pr_state_ptr->oms_aa_handle
#define rr_bt_queue             		pr_state_ptr->rr_bt_queue
#define l2cap_segmentation_size 		pr_state_ptr->l2cap_segmentation_size
#define l2cap_packet_type       		pr_state_ptr->l2cap_packet_type

/* This macro definition will define a local variable called	*/
/* "op_sv_ptr" in each function containing a FIN statement.	*/
/* This variable points to the state variable data structure,	*/
/* and can be used from a C debugger to display their values.	*/
#undef FIN_PREAMBLE
#define FIN_PREAMBLE	bt_mac_mast_state *op_sv_ptr = pr_state_ptr;


/* Function Block */

enum { _block_origin = __LINE__ };
/*
 * Function:		bt_mac_sv_init
 *
 * Description:		MAC Initialization procedure
 *					Initialize state variables.
 *					Read model attribute values in
 *					 variables.
 *					Create global lists
 *					Register statistics handlers
 */

static void bt_mac_sv_init ()
{
	Objid   file_attr_objid;
	Objid	my_node_objid;
	int     i;
	char	buffer[64];
	
	
	FIN (bt_mac_sv_init ());

	/* Object id of this process. */
	my_objid = op_id_self ();
	
	/* Get the objid of the node */
	my_node_objid = op_topo_parent(my_objid);
		
	/* get the time to start collecting the results */
	op_ima_obj_attr_get (my_objid, "Report", &file_attr_objid);
	op_ima_obj_attr_get ( op_topo_child (file_attr_objid, OPC_OBJTYPE_GENERIC,0), "start time", &start_time_collect);

	/* read the debug flag and the message print */
	op_ima_obj_attr_get (my_objid, "debug flag", &debug_flag);
	
	op_ima_obj_attr_get (my_objid, "Destination Address", &dest_address_read);
	op_ima_obj_attr_get (my_objid, "station address", &my_address);
	
	/* Obtain an address handle for resolving WLAN MAC addresses.	*/
	oms_aa_handle = oms_aa_address_handle_get ("MAC Addresses", "station address");
	
	/*Get the name of the node*/	
	op_ima_obj_attr_get ( my_node_objid, "name", buffer);

	bt_master_name = (char*) op_prg_mem_alloc( (strlen(buffer)+1) * sizeof(char) );
	strcpy (bt_master_name, buffer);
   	
	/*get the coordinates of this node seen as transmitter*/
	bt_get_position (my_objid, &t_x, &t_y);
	
	/*Get the transmission power*/
	op_ima_obj_attr_get ( my_objid, "power", &transmission_power);
	
	/* get the L2CAP parameters */
	l2cap_init_parameters (&l2cap_segmentation_size, &l2cap_packet_type);
				
	printf ("\n|--------------------------------------------------------|\n");
	printf ("| Init infos:\n");
	printf ("| \tthe master name is %s \n", bt_master_name);
	printf ("| \tthe transmission power is %.2f \n",transmission_power);
	printf ("| \tposition of the master : (%.2f;%.2f)\n", t_x, t_y);
	printf ("| \t\tL2CAP segmentation size : %.2f bytes\n", l2cap_segmentation_size);
	printf ("| \t\tL2CAP packet segmentation : %s\n", (l2cap_packet_type)?"Data Medium Rate":"Data High Rate");
	printf ("|--------------------------------------------------------|\n");

	/*memory allocation for the sequence numbers and retransmission packet*/
	tx_sequence_number 			= (Boolean*)op_prg_mem_alloc( STATION_NUMBER * sizeof(Boolean) );
	rx_sequence_number 			= (Boolean*)op_prg_mem_alloc( STATION_NUMBER * sizeof(Boolean) );
	retransmit_pkptr   			= (Packet**)op_prg_mem_alloc( STATION_NUMBER * sizeof(Packet*) );
	retransmission_attempts 	= (double*)op_prg_mem_alloc( STATION_NUMBER * sizeof(double) );
	acknowledgement    			= (Boolean *) op_prg_mem_alloc( STATION_NUMBER * sizeof(Boolean));
	tx_acknowledgement 			= (Boolean *) op_prg_mem_alloc( STATION_NUMBER * sizeof(Boolean));
	null_ack           			= (Boolean *) op_prg_mem_alloc( STATION_NUMBER * sizeof(Boolean));
	txrx_ack		   			= (Boolean *) op_prg_mem_alloc( STATION_NUMBER * sizeof(Boolean));
	packets_in_subqueues		= (int *) op_prg_mem_alloc( STATION_NUMBER * sizeof(int));
	l2cap_number_of_pkt_recv	= (double *) op_prg_mem_alloc( STATION_NUMBER * sizeof(double));
	total_l2cap_delay 			= (double *) op_prg_mem_alloc( STATION_NUMBER * sizeof(double));
	
	packet_delivery_in_progress = OPC_FALSE;
	
	for(i = 0; i < STATION_NUMBER ; i++)
		{
		retransmit_pkptr[i] = NULL;
		/* initialize the Tx seqn to false, the first transmission will change it to true! */
		tx_sequence_number[i] = OPC_FALSE;  
		rx_sequence_number[i] = OPC_FALSE; 
		txrx_ack[i] = OPC_FALSE;
		retransmission_attempts[i] = 0;
		acknowledgement[i] = OPC_FALSE;
		tx_acknowledgement[i] = OPC_FALSE;
		null_ack[i] = OPC_TRUE;
		packets_in_subqueues[i] = 0;
		l2cap_number_of_pkt_recv[i] = 0.0;
		total_l2cap_delay[i] = 0.0;
		}
	
	/* Register local statistics */
	mac_access_delay_stat	= op_stat_reg("bt_mac. MAC Access Delay (sec)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	mac_throughput_stat		= op_stat_reg("bt_mac. MAC Throughput (bit/sec)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	mac_goodput_stat		= op_stat_reg("bt_mac. MAC Goodput (bit/sec)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	mac_packets_send_stat	= op_stat_reg("bt_mac. MAC Packets send (pkt)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	mac_packets_recv_stat	= op_stat_reg("bt_mac. MAC Packets received (pkt)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	mac_rt_attempt_stat		= op_stat_reg("bt_mac. MAC Retransmission Attempts (pkt)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	mac_pkt_lost_stat		= op_stat_reg("bt_mac. MAC Packet Loss (%)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	mac_payload_errs_stat	= op_stat_reg("bt_mac. MAC Payload Errors", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	hop_freq_stat			= op_stat_reg("bt_mac. MAC Hopping Frequency Pattern (MHz)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	l2cap_access_delay_stat	= op_stat_reg("l2cap. L2CAP Access Delay (sec)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	l2cap_throughput_stat	= op_stat_reg("l2cap. L2CAP Throughput (bit/sec)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	l2cap_goodput_stat		= op_stat_reg("l2cap. L2CAP Goodput (bit/sec)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	l2cap_packets_send_stat	= op_stat_reg("l2cap. L2CAP Packets send (pkt)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	l2cap_packets_recv_stat	= op_stat_reg("l2cap. L2CAP Packets received (pkt)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	sco_packets_send_stat	= op_stat_reg("sco. SCO Packets send (pkt)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
	sco_packets_recv_stat	= op_stat_reg("sco. SCO Packets received (pkt)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);

	/* Initialize statistics */
	mac_total_pkt_bits		= mac_total_frame_body_bits = 0;
	l2cap_total_pkt_bits 	= l2cap_total_frame_body_bits = 0;
	mac_number_of_pkt_send	= mac_number_of_pkt_recv = 0;
	l2cap_number_of_pkt_send = 0;
	sco_number_of_pkt_send= sco_number_of_pkt_recv = 0;
	mac_number_of_pkt_lost = 0;
	number_of_pkt_ignored = 0;
	
	reassembly_buffer = 0;
	reassembly_creation_time = 0.0;
	total_payload_errs = 0;
	bt_pkt_collided = 0;
			
	/* Initialize the variable "fisrt packet" to FALSE */
	bt_txrx_first_packet = OPC_FALSE;
	
	FOUT;
}


/*
 * $Function:		bt_mac_sv_init2
 * $Description:	MAC Initialization procedure
 *					when the topology is known
 */

static void bt_mac_sv_init2 ()
{
    Objid	mac_params_comp_attr_objid;
	Objid	params_attr_objid;

	
	FIN( bt_mac_sv_init2 () );

	
	/* Obtain the values assigned to the various attributes	*/
	op_ima_obj_attr_get (op_id_self(), "Bluetooth MAC Parameters", &mac_params_comp_attr_objid);
	params_attr_objid = op_topo_child (mac_params_comp_attr_objid, OPC_OBJTYPE_GENERIC, 0);
	
	/* get all the information about the topology */
	number_of_slave = topo_get_number_of_slaves (piconet_number);
	destination_address = 1;
	dest_addr_higher_layer = 0;
		
	/* Print a listing of all devices belonging to the current piconet */
	topo_print_device_list(piconet_number);
	
	rr_bt_queue = rr_init_support (piconet_number);
	
	/* Init the flag to use the poll packet */
	poll_packet_flag = OPC_TRUE; // in case of the TCP traffic	
	
	FOUT;	
}



/*
 * Function:		bt_higher_layer_pkt_arrival
 * Description:		Reception of a packet from the
 *					higher layer of this MAC.
 *					This part is the L2CAP Model that
 *					encapsulate and eventually segment
 *					the packet, then   it in the
 *					subqueue for transmission process
 */

static void bt_higher_layer_pkt_arrival ()
{
	Packet *	pkptr;				/* The current packet */
	int 		i;					/* loop variable */
	int			address;			/* Destination address */
	int			dest_addr;
	Ici *		ici_ptr;
	

	FIN (bt_higher_layer_pkt_arrival ());
	
	bt_txrx_first_packet = OPC_TRUE;
	
	if (debug_flag)
		bt_print_debug ("Master function block : bt_higher_layer_pkt_arrival()");
	
	/* Choose a correct destination if the Random generation is not set */
	address = bt_poll_dest_address();
	
	/* Get the packet from the source and some information from it */
	pkptr = op_pk_get(op_intrpt_strm());
		
	/* Get the ici pointer */
	ici_ptr = op_intrpt_ici ();
	
	/* Retrieve destination address from the ici set by the interface layer.	*/
	if (ici_ptr == OPC_NIL || op_ici_attr_get (ici_ptr, "dest_addr", &dest_addr) == OPC_COMPCODE_FAILURE)
		{
		/* Generate error message.	*/
		bt_mac_error ("Destination address in not valid.", OPC_NIL, OPC_NIL);
		}
	
	address = topo_index_slave_from_address (dest_addr, piconet_number);
		
	if (!address)
		bt_mac_error ("Destination address in not valid.", "Check the configuration", OPC_NIL);
	
	/* Update the number of packets received at the L2CAP level */
	if ( op_sim_time() >= start_time_collect )
		l2cap_number_of_pkt_send++;
	
	op_stat_write (l2cap_packets_send_stat, l2cap_number_of_pkt_send);
	
	/*
	 * When transmited, the packet contains the Creation Time
	 * Of the last encapsulation. This information will be used for stat purpose
	 * Insert it inside the outgoing subqueue
	 * Get the packet destination information and enqueue it for processing purpose
     * Update the number of packets in the different TX subqueues
	 */
	l2cap_higher_layer_arrival (pkptr, l2cap_segmentation_size*8);
	packets_in_subqueues[address] += l2cap_segmentation (rr_bt_queue, address, MASTER_TYPE, l2cap_packet_type);

	if (bt_message_print)
		{
		printf ("\n|---------------------------------------------------------------------------------|\n");	
		printf ("| the higher layer function set the destination address to %d for the piconet %d\n",address, piconet_number);
		printf ("| We received a packet at %f seconds\n", op_sim_time());

		for (i=1; i<=number_of_slave; i++)
			printf ("|  There is %d packets in the subqueue %d of master\n", packets_in_subqueues[i], i);
	
		printf ("|---------------------------------------------------------------------------------|\n");
		}
	
	FOUT;
}


/*
 * $Function:		bt_higher_layer_sco_pkt_arrival
 * $Description:	Reception of a voice packet from the
 *					higher layer of this MAC.
 */
 
static void bt_higher_layer_sco_pkt_arrival ()
{
	Packet *	pkptr;									/* The current packet */
	Packet *	new_packet;								/* The new HV packet to be created */


	FIN (bt_higher_layer_sco_pkt_arrival ());

	bt_txrx_first_packet = OPC_TRUE;
	
	if (debug_flag)
		bt_print_debug ("Master function block : bt_higher_layer_sco_pkt_arrival ()");
	
	/* Choose a correct destination if the Random generation is not set */
	destination_address = topo_choose_dest_address (dest_address_read, number_of_slave, destination_address);
	
	/* Get the packet from the source and some information from it */
	pkptr = op_pk_get(op_intrpt_strm());

	/* Update the number of packets received at the L2CAP level */
	if ( op_sim_time() >= start_time_collect )
		sco_number_of_pkt_send++;
	op_stat_write (sco_packets_send_stat, sco_number_of_pkt_send);

	/* When transmited, the packet contains the Creation Time */
	/* Of the last encapsulation. This information will be used for stat purpose */
	/* Insert it inside the outgoing subqueue */
	switch ( (int) op_pk_total_size_get(pkptr) )
	{
		case	TSCO_RAW_HV1:
		    if ((new_packet = op_pk_create_fmt (BLUETOOTH_PKT_HV1)) == OPC_NIL) 
				bt_mac_error ("bt_higher_layer_sco_pkt_arrival", "Unable to create HV1 packet.", "");
		break;
		case	TSCO_RAW_HV2:
		    if ((new_packet = op_pk_create_fmt (BLUETOOTH_PKT_HV2)) == OPC_NIL)
				bt_mac_error ("bt_higher_layer_sco_pkt_arrival", "Unable to create HV2 packet.", "");
		break;
		case	TSCO_RAW_HV3:
		    if ((new_packet = op_pk_create_fmt (BLUETOOTH_PKT_HV3)) == OPC_NIL)
				bt_mac_error ("bt_higher_layer_sco_pkt_arrival", "Unable to create HV3 packet.", "");
		break;
	}

	/* Set packet fields */
	
    if (	(op_pk_nfd_set (new_packet, "AM_ADDR", destination_address) == OPC_COMPCODE_FAILURE) ||
			(op_pk_nfd_set (new_packet, "Time Stamp", op_pk_creation_time_get(pkptr)) == OPC_COMPCODE_FAILURE) ||
			(op_pk_nfd_set (new_packet, "Frame Body", pkptr) == OPC_COMPCODE_FAILURE) )
		bt_mac_error ("bt_higher_layer_sco_pkt_arrival", "Unable to set voice packet fields", "");

	/* Update the number of packets in the subqueues */
	rr_pkt_enqueue (rr_bt_queue, new_packet, SUBQ_SCO);

	packets_in_subqueues[destination_address] ++;

	FOUT;
}


/*
 * Function:		bt_lower_layer_pkt_arrival
 *
 * Description:		Reception of a packet from the
 *					lower layer of this MAC.
 *					Called by interrupt
 */

static void bt_lower_layer_pkt_arrival (Packet * pkptr)
{
	int			type, payload_errs, l2cap_last;
	Packet	*	frame_body;
	Packet	*	higher_layer_pkt;
	double		ctime;
	int			slave_address;


	FIN (bt_lower_layer_pkt_arrival (pkptr));
	
	if (debug_flag)
		bt_print_debug ("Master function block : bt_lower_layer_pkt_arrival (pkptr)");

	op_pk_nfd_get (pkptr, "TYPE", &type);
	op_pk_nfd_get (pkptr, "Time Stamp", &ctime);
	op_pk_nfd_get (pkptr, "AM_ADDR", &slave_address);

	/* Calculate the stats for the MAC Layer */
	/* Calculate the statistics for the packet Access Delay */
	op_stat_write (mac_access_delay_stat, op_sim_time()-op_pk_creation_time_get(pkptr));

   	/* Total number of bits sent to higher layer is equivalent to a throughput	*/
	mac_total_pkt_bits += (double) op_pk_total_size_get (pkptr);
	if ( (type != NULL_TYPE) && (type != POLL_TYPE) )
		mac_total_frame_body_bits += (double) op_pk_nfd_size (pkptr,"Frame Body");
	op_stat_write (mac_throughput_stat, mac_total_pkt_bits/op_sim_time());
	op_stat_write (mac_goodput_stat, mac_total_frame_body_bits/op_sim_time());

	/* Log the number of errors inside the payload received */
	op_pk_nfd_get(pkptr, "Errors", &payload_errs);
	if(payload_errs)
		{
		bt_pkt_collided++;
		op_stat_write (mac_payload_errs_stat, (double) payload_errs);
		/*modif*/
		total_payload_errs = total_payload_errs + payload_errs;
		/******/
		}
		
	/* Update the number of packets received */
	if ( op_sim_time() >= start_time_collect )
		{
		if (type != NULL_TYPE)
			mac_number_of_pkt_recv++;
		else
			mac_number_of_pkt_null++;
		}
		
	op_stat_write (mac_packets_recv_stat, mac_number_of_pkt_recv);
	
	/* Depending on the packet type, log different stats and do SCO or ACL */
	switch ( type )
	{
		case	NULL_TYPE:			/* For all type of control traffic */
		case	POLL_TYPE:			/* Just discard them, no stat to keep track */
			bt_destroy_packet(pkptr);
		break;						/* as it is the only one which is allowed to poll other devices */

		case	HV1_TYPE:			/* For all the voice packets */
		case	HV2_TYPE:
		case	HV3_TYPE:
			/* Update the number of packets received */
			if ( op_sim_time() >= start_time_collect )
				sco_number_of_pkt_recv++;
			op_stat_write (sco_packets_recv_stat, sco_number_of_pkt_recv);

			/* Remove the voice information from the packet and send it to the higher layer */
			op_pk_nfd_get(pkptr, "Frame Body", &frame_body);
			op_pk_destroy(pkptr);

			op_pk_send_forced(frame_body, HIGHER_LAYER_VC_OUTPUT_STREAM);
		break;

		default:					/* For all other packet type */
			/* Operate the L2CAP reassembly */
			if ( (pkptr = l2cap_reassembly(pkptr,&reassembly_buffer,&reassembly_creation_time)) != NULL )
			{	/* A reassembly just took place */
			   	/* Total number of bits sent to higher layer is equivalent to a throughput	*/

				l2cap_total_pkt_bits += (double) op_pk_total_size_get (pkptr);
				l2cap_total_frame_body_bits += (double) op_pk_nfd_size (pkptr,"Frame Body");
				op_stat_write (l2cap_throughput_stat, l2cap_total_pkt_bits/op_sim_time());
				op_stat_write (l2cap_goodput_stat, l2cap_total_frame_body_bits/op_sim_time());

				/* Update the number of packets received */
				if ( op_sim_time() >= start_time_collect )
					l2cap_number_of_pkt_recv[slave_address]++;

                /* Calculate the statistics for the packet Access Delay */
                op_stat_write (l2cap_access_delay_stat, op_sim_time()-reassembly_creation_time);
				
				/*** modif******/
				/*compute the total l2cap delay*/
				total_l2cap_delay[slave_address] += op_sim_time()-reassembly_creation_time;
				
				/* Check whether the packet is the last L2CAP packet */
				op_pk_nfd_get (pkptr, "Last", &l2cap_last);
				
				if (l2cap_last)
					{
					/* Get the higher layer packet */
					op_pk_nfd_get (pkptr, "HLPacket", &higher_layer_pkt);
								
					/* Forward the packet to the higher layer */
					op_pk_send_forced(higher_layer_pkt, HIGHER_LAYER_OUTPUT_STREAM);
					}
				
				/* Destroy the L2CAP Packet */
				l2cap_destroy_packet (pkptr);				
				
			}	/* If the packet has not been reassembled then, wait for the next round */
		break;
	}

	FOUT;
}


/*
 * Function:		bt_packet_to_transmit
 *
 * Description:		Check if there is a packet ready to TX or
 *					not. If there is any, send it to the
 *					lower layer
 */

static void bt_packet_to_transmit ()
{
	Packet *	pkptr = NULL;
	int			type;
	double		ctime;
	double		transmission_frequency;
	char		format[10];
	int			dest_addr;						/* The destination MAC address for POLLING packets */
	int         dest_addr_transmitter, dest_objid;/*to store the location information of the receiver and the transmitter*/
	Slave_Device *slave_ptr;
	
	double		max_alpha = 0.0;
	
	/* debugging variables */
	Boolean		transmit_debug = op_prg_odb_ltrace_active("transmit");
	
	
	FIN (bt_packet_to_transmit ());

	
	if (transmit_debug)
		{
		printf ("\n|----------------------------------------------------------------------\n");
		printf ("| %s (piconet %d) Transmission Infos at %f seconds:\n",
			topo_get_master_device (piconet_number)->name_of_master,
			piconet_number, op_sim_time());
		}
		
	/*
	 * Voice packets have the highest priority of all
	 * then Check for Broadcast packet in the broadcast queue
	 * These packet have the highest priority for ACL traffic in the Bluetooth
	 * model. When a broadcast sequence starts, it will transmit
	 * the packets until the queue is empty. When no more broadcast
	 * packets are present, the normal scheduling scheme is called.
	 */
	
	if (rr_bt_queue_empty(rr_bt_queue, SUBQ_SCO) == OPC_FALSE)			/* Check the voice queue first */
		{
		pkptr = rr_pk_queue_remove (rr_bt_queue, SUBQ_SCO, OPC_QPOS_HEAD);/* Access first pkt in subq */
		/* Update the number of packets in the different subqueues */
		op_pk_nfd_get(pkptr,"AM_ADDR",&dest_addr);
		packets_in_subqueues[dest_addr]--;
		if (transmit_debug) printf ("| \tremove a SCO packet from the queue\n");
		}
	else if ((pkptr = retransmit_pkptr[previous_src_addr]) == NULL)  // If no stored packet is pending
		{
		if (rr_bt_queue_empty(rr_bt_queue, SUBQ_BROADCAST) == OPC_FALSE)/* Check the broadcast queue */
			{
			pkptr = rr_pk_queue_remove (rr_bt_queue, SUBQ_BROADCAST, OPC_QPOS_HEAD);/* Access first pkt in broadcast subq */
			if (transmit_debug) printf("| \tA broadcast packet is sending\n");
			}
		else										/* No broadcast packet */
			{
			if (transmit_debug) printf ("|\tRequest a packet to the scheduler\n");
			
			if (poll_packet_flag)
				pkptr = rr_request_pkt_to_scheduler_with_poll(rr_bt_queue, piconet_number, number_of_slave);	/* Request a packet to the scheduler */
			else
				pkptr = rr_request_pkt_to_scheduler(rr_bt_queue, piconet_number);
			}
		
		if (pkptr != NULL)
			{
			op_pk_nfd_get(pkptr, "AM_ADDR", &dest_addr_transmitter);
			slave_ptr = topo_get_slave_device_from_address (dest_addr_transmitter, piconet_number);
			if (transmit_debug) printf("| \tDestination address of the chosen packet %d (%d)\n",dest_addr_transmitter, slave_ptr->mac_address);
			
			/* Update the number of packets in the different subqueues */
			packets_in_subqueues[dest_addr_transmitter]--;
			}
		else
			{
			if (transmit_debug) printf("| \tNo packet from broadcast and scheduler\n");
			
			dest_addr_transmitter = previous_src_addr;
			
			if ((dest_addr_transmitter) && (tx_acl) && (!null_ack[dest_addr_transmitter]))
				{
				/* Create a NULL ACL packet that will be inserted in the next slave slot */
				/* and will be used in the retransmission scheme */
				
				if (transmit_debug) printf ("| \tCreate a NULL ACL packet\n");
				pkptr = op_pk_create_fmt(BLUETOOTH_PKT_NULL);
				
				if (transmit_debug) printf("|\tDestination address of the NULL Packet : %d\n",dest_addr_transmitter);
				
				op_pk_nfd_set (pkptr, "AM_ADDR", dest_addr_transmitter);
				op_pk_nfd_set (pkptr, "Time Stamp", op_sim_time());
				}
			else if (poll_packet_flag && bt_txrx_first_packet) 
				{
				/* Create a POLL packet that will be inserted in the next slave slot */
				/* choose an address */
				
				dest_addr_transmitter = current_dest_station[piconet_number];
				
				if (dest_addr_transmitter)
					{
					pkptr = op_pk_create_fmt(BLUETOOTH_PKT_POLL);
					
					if (transmit_debug) printf("|\tCreate a POLL packet to the slave number %d\n",dest_addr_transmitter);
					
					op_pk_nfd_set (pkptr, "AM_ADDR", dest_addr_transmitter);
					op_pk_nfd_set (pkptr, "Time Stamp", op_sim_time());
					}
				}
			}
		
		tx_acl = OPC_FALSE;
		}
	else if (transmit_debug) printf ("|\tThis is a retransmission...\n");
	
	/*
	 * Make a basic check in order to determine if a packet has been
	 * dequeued. This test should not fail has we already know that
	 * there is a least one packet in the subqueues
	 * Then, transmit the packet over the RF
	 */
	
	if (pkptr != NULL)
		{
		if (pkptr == OPC_NIL)
			bt_mac_error ("bt_packet_to_transmit", "the packet is NIL", "");
				
		/* In case of a POLL packet, choose to POLL a random */
		/* station on the piconet */
		
		op_pk_format (pkptr, format);

		if (strcmp(format, BLUETOOTH_PKT_POLL) == 0)
			{
			if (bt_message_print) printf("| \tthis is a POLL packet \n");
			poll_answer = OPC_TRUE;
			}
		else
			poll_answer = OPC_FALSE;
		
		op_pk_nfd_get (pkptr, "Time Stamp", &ctime);

		/* Set the number of clock cycle to wait for next transmission from the packet type */
		bt_set_tx_packet_delivery_clk (pkptr, piconet_number);

		/* Just before sending the packet, make sure that all the stations are */
		/* synchronized on the TX frequency. */
		bt_set_master_transmission(pkptr, piconet_number);

		/* Update the number of packets received */
		if ( op_sim_time() >= start_time_collect )
			mac_number_of_pkt_send++;
		op_stat_write (mac_packets_send_stat, mac_number_of_pkt_send);

		/* Add or not the ARQ, SEQN and restransmit scheme */
		op_pk_nfd_get(pkptr, "TYPE", &type);
		
		op_pk_nfd_get(pkptr, "AM_ADDR", &dest_addr_transmitter);
		
		if (pkptr != retransmit_pkptr[previous_dest_addr])
			/* Update the TX SEQN */
			tx_sequence_number[dest_addr_transmitter] = (tx_sequence_number[dest_addr_transmitter])?OPC_FALSE:OPC_TRUE;
		
		switch ( type )			/* First check the ARQ SEQN scheme */
			{						/* This is the Master point of view */
			case	NULL_TYPE:	/* For POLL and NULL packet, no retransmission, no ARQ and SEQN */
			/*case	POLL_TYPE:	   scheme need to be send with the packet. The fields are ignored */
			case	HV1_TYPE:	/* Voice packets do not affect the ARQ, SEQN flags either */
			case	HV2_TYPE:
			case	HV3_TYPE:
			
			op_pk_nfd_set(pkptr, "ARQ", tx_acknowledgement[dest_addr_transmitter]);
			op_pk_nfd_set(pkptr, "SEQN", tx_sequence_number[dest_addr_transmitter]);
			break;
			
			default:			/* All ACL traffic and SCO must implement the ARQ, SEQN scheme */
				/* Set the binary sequence number of the packet */
				/* Set the acknowledgement flag inside the packet, this state was determined */
				/* by the last packet reception */
				op_pk_nfd_set(pkptr, "ARQ", tx_acknowledgement[dest_addr_transmitter]);
			
			if (retransmit_pkptr[previous_dest_addr])
				retransmission_attempts[previous_dest_addr]++;		/* this is a retransmission */
				
			op_pk_nfd_set(pkptr, "SEQN", tx_sequence_number[dest_addr_transmitter]);
			break;
			}
			

		switch ( type )			/* This check is for retransmission scheme */
			{
			/* For POLL and NULL packets */
			/* or */
			/* For all the voice packets */
			/* Do not retransmit packets */
			case	NULL_TYPE:			
			case	POLL_TYPE:
			case	HV1_TYPE:	
			case	HV2_TYPE:
			case	HV3_TYPE:
			break;
			
			default:			
			/* All ACL traffic implement the retransmit scheme */
			/* Duplicate the packet to send, and store it in the retransmit */
			/* storage space only for ACL */
				retransmit_pkptr[dest_addr_transmitter] = op_pk_copy(pkptr);
			break;
			}
		
		/* Set the way the packet should go */
		op_pk_nfd_set (pkptr, "Way", MASTER_TO_SLAVE);
		
		/*Set the positions coordinates in the packet*/
		bt_get_position ( my_objid, &t_x, &t_y);
		
		op_pk_nfd_set(pkptr,"t_x",t_x);
		op_pk_nfd_set(pkptr,"t_y",t_y);
		
		op_pk_nfd_get(pkptr, "AM_ADDR", &dest_addr_transmitter);
		dest_objid = topo_get_slave_device_from_address(dest_addr_transmitter, piconet_number)->mac_objid ;
		bt_get_position (  dest_objid , &r_x, &r_y);
		
		op_pk_nfd_set(pkptr,"r_x",r_x);
		op_pk_nfd_set(pkptr,"r_y",r_y);
		
		/*Set the transmission power in the packet*/
		op_pk_nfd_set(pkptr,"power",transmission_power);
		
		/*Set the number of the piconet*/
		op_pk_nfd_set(pkptr,"piconet",piconet_number);
		
		bt_print_count_packet(dest_addr_transmitter, piconet_number);
		
		
		op_pk_nfd_get(pkptr,"frequency",&transmission_frequency);
		
				
		/* START	DEBUG INFORMATION */
		if (transmit_debug)
			{
			slave_ptr = topo_get_slave_device_from_address (dest_addr_transmitter, piconet_number);
			
			printf ("| \tPacket transmit to %s (%d) at %.6f s.\n", slave_ptr->name_of_slave, slave_ptr->address_device, op_sim_time());
			printf ("| \tTransmission frequency: %f \n",transmission_frequency);
			printf ("| \tPacket info: %s (seqn %d, ack %d)\n", bt_print_type_packet(type),
				tx_sequence_number[dest_addr_transmitter], tx_acknowledgement[dest_addr_transmitter]);
			}
		/* END OF	DEBUG INFORMATION */
				
		/* Finally forward the packet to the TX */
		op_pk_deliver(pkptr, topo_get_channel(), BLUETOOTH_INPUT_STREAM);
				
		/* The last packet was a sent packet */
		txrx_ack[dest_addr_transmitter] = OPC_TRUE;
		
		/*stock the previous destination address*/
		previous_dest_addr = dest_addr_transmitter;
		} /* Otherwise, transmit nothing! */
	else
		if (transmit_debug) printf ("|\tNo transmission\n");

	if (transmit_debug) printf ("|----------------------------------------------------------------------\n");

	FOUT;
	}


/*
 * $Function:		bt_packet_to_receive
 *
 * $Description:	Check with the Receiver algorithm
 *					if there is a packet ready to TX or
 *					not. If there is any, send it to the
 *					lower layer
 */

static void bt_packet_to_receive ()
{
	Packet *	pkptr;
	Boolean		accept,seqn;
	int			type;
	int         src_addr_transmitter;
	
	char	format[16];
	double	pkt_id;

	Boolean receive_debug = op_prg_odb_ltrace_active ("receive");
	
	FIN (bt_packet_to_receive ());
	

	/* Get the packet from lower layer */
	pkptr = op_pk_get(op_intrpt_strm());
	
	// get the format of the packet and ID
	op_pk_format (pkptr, format);
	pkt_id = op_pk_id(pkptr);
	
	/*
	 * Make sure that the packet is in good shape
	 * Look also if it follows the sequence number scheme
	 * free last stored packet if acknowledged 
	 */
	op_pk_nfd_get(pkptr, "Accept", &accept);
	op_pk_nfd_get(pkptr, "SEQN", &seqn);
	op_pk_nfd_get(pkptr, "AM_ADDR", &src_addr_transmitter);
	op_pk_nfd_get(pkptr, "ARQ", &acknowledgement[src_addr_transmitter]);

	/* START	DEBUG INFORMATION */
	if (receive_debug)
		{
		printf("\n|----------------------------------------------------------------|\n");
		printf ("|\tBlueTooth MAC RX Info (%s): Packet to RX (time %.6f).\n", bt_master_name, op_sim_time());
		printf ("|\tThe packet is %s\n", (accept)?"accepted":"not accepted");
		}
	/* END OF	DEBUG INFORMATION */
	
	/* Get packet type information */
	op_pk_nfd_get(pkptr, "TYPE", &type);
	
	switch ( type )
	{											/* Still master point of view */
												/* For Control traffic do not check the ARQ and SEQN */
		case	HV1_TYPE:  if (receive_debug) printf("|  I,the master, received a hv1 packet\n");		/* Do not apply the retransmit scheme */
		break;
		case	HV2_TYPE:  if (receive_debug) printf("|  I,the master, received a hv2 packet\n");					/* for voice packets either */
		break;
		case	HV3_TYPE:  if (receive_debug) printf("|  I,the master, received a hv3 packet\n");
		break;

		default:	  /* For all other traffic, ACL do retransmit */
		
			
		if (accept && retransmit_pkptr[src_addr_transmitter] && acknowledgement[src_addr_transmitter])	/* If the previous packet has been ACK */
			{	/* Free the retransmission resource */

			bt_destroy_packet (retransmit_pkptr[src_addr_transmitter]);	/* And start with a new payload in the next */
			
			retransmit_pkptr[src_addr_transmitter] = NULL;				/* Transmission slot */
			
			if (receive_debug) printf("|  I ve destroyed the retransmitt_packet because there is no retransmission \n");
			}
		else if (receive_debug) 
			{
			printf("| \t %s retransmit packet\n",(retransmit_pkptr[src_addr_transmitter]==NULL)?"No":"There is a");
			printf("| \tacknowledgement is %d \n",acknowledgement[src_addr_transmitter]);
			}
		
		break;
	}

	switch ( type )
	{
														/* Control traffic do not need ARQ, SEQN, and */
														/* Retransmit scheme */
		case	HV1_TYPE:								/* Do not apply the retransmit scheme */
		case	HV2_TYPE:								/* for voice packets either */
		case	HV3_TYPE:
		if ( accept )								/* If the Control packet has been accepted, then */
			bt_lower_layer_pkt_arrival (pkptr);		/* Forward the packet to the MAC */
		else										/* Otherwise */
			{
			//Sleep (5000);
			if ( op_sim_time() >= start_time_collect )
				{
				mac_number_of_pkt_lost++;
				if (receive_debug) printf ("| Packet lost, %d lost packets so far.\n", mac_number_of_pkt_lost);
				}
			op_stat_write (mac_pkt_lost_stat, mac_number_of_pkt_lost/(mac_number_of_pkt_lost+mac_number_of_pkt_recv));
			bt_destroy_packet(pkptr);				/* just discard it, and ignore it */
			}
		break;

		default:										/* For all other traffic ARQ, SEQN is needed */
			tx_acl = OPC_TRUE;							/* If no traffic is present in the queues, this last packet still need an answer */
		/* Taken from specification SDL p70 */
		if ( !accept )	/* Too much errors, the CRC and FEC failed, then Reject the packet */
			{
			tx_acknowledgement[src_addr_transmitter] = OPC_FALSE;

			if ( op_sim_time() >= start_time_collect )
				mac_number_of_pkt_lost++;

				op_stat_write (mac_pkt_lost_stat, mac_number_of_pkt_lost/(mac_number_of_pkt_lost+mac_number_of_pkt_recv));
			bt_destroy_packet(pkptr);
			if (receive_debug) printf ("| \tMaster Reject Payload (pk seqn %d, rx seqn %d, ack %d, rt %x)\n", seqn, rx_sequence_number[src_addr_transmitter], acknowledgement[src_addr_transmitter], retransmit_pkptr[src_addr_transmitter]);
			null_ack[src_addr_transmitter] = OPC_FALSE;
			}
		else
			{
			if (seqn == rx_sequence_number[src_addr_transmitter]) /* SEQN = SEQNold */
				{
				if ( op_sim_time() >= start_time_collect )
					number_of_pkt_ignored++;
				tx_acknowledgement[src_addr_transmitter] = OPC_TRUE;				/* True ACK */
				bt_destroy_packet(pkptr);					/* But ignore the Payload */
				if (receive_debug) printf ("| \tMaster Ignore Payload (pk seqn %d, rx seqn %d, ack %d, rt %x) type %d\n", seqn, rx_sequence_number[ src_addr_transmitter], acknowledgement[src_addr_transmitter], retransmit_pkptr[ src_addr_transmitter], type);
				null_ack[src_addr_transmitter] = OPC_FALSE;
				}
			
			else
				{
				if (receive_debug)
					printf("| \t(pk seqn %d, rx seqn %d)\n", seqn, rx_sequence_number[src_addr_transmitter]);
				
				null_ack[src_addr_transmitter] = (type == NULL_TYPE)?OPC_TRUE:OPC_FALSE;
									/* Update the sequence */
				//if (type != NULL_TYPE)
					rx_sequence_number[src_addr_transmitter] = (rx_sequence_number[src_addr_transmitter])?OPC_FALSE:OPC_TRUE;
				
				if (receive_debug)
					printf("| \tUpdate rx seqn: %d\n", rx_sequence_number[src_addr_transmitter]);
								
				
				tx_acknowledgement[src_addr_transmitter] = OPC_TRUE;					/* True ACK for next packet? */
				/* Update the number of retransmission attempts stat for the last packet */
				if (retransmission_attempts[src_addr_transmitter])
					{
					op_stat_write (mac_rt_attempt_stat, retransmission_attempts[src_addr_transmitter]);
					retransmission_attempts[src_addr_transmitter] = 0;
					}
				/* Finally forward the packet to the MAC */
				bt_lower_layer_pkt_arrival (pkptr);
				}
			}
		}
	
	/* keep the last destination address */
	previous_src_addr = src_addr_transmitter;
	
	/* The last packet was a received packet */
	txrx_ack[src_addr_transmitter] = OPC_FALSE;
	
	if (receive_debug) printf("|----------------------------------------------------------------|\n");

	FOUT;
	}

/* modif olivier
 *
 *  Function : bt_get_position
 *
 *  Description : get the position of the device
 *
 *  $ParamIn : Objid : a_objid
 *                     objid of the node from which we want the position
 *             double* : x_position
 *                       pointer in which the position will be setted
 *             double* y_position
 */

static void bt_get_position (Objid objid, double* x_position, double* y_position)
	{
	double delta_x, delta_y;
	
	FIN (bt_get_position ( objid, x_position, y_position));
	
	/* get the position attributes */
	op_ima_obj_attr_get ( op_topo_parent(objid), "x position", x_position);
	op_ima_obj_attr_get ( op_topo_parent(objid), "y position", y_position);
	
	op_ima_obj_attr_get ( objid, "Delta x", &delta_x);
	op_ima_obj_attr_get ( objid, "Delta y", &delta_y);

	/* Compute the real position */
	*x_position += delta_x;
	*y_position += delta_y;
	
	FOUT;
	}

/*
 * Function: master_end_of_simulation
 *
 * Description: collect result in file at the end of the simulation
 *
 * No parameter
 */

static void  master_end_of_simulation ()
{
	const char *	stat_loss = "_pkt_loss";
	const char *	stat_error = "_mac_errors";
	const char *	stat_delay = "_l2cap_delay";
	Objid 			file_objid, file_attr_objid, parent_objid;
	Objid			file_channel_objid, file_channel_attr_objid;
	char 			name[1024], label[1024] = "";
	char			results[1024] = "";
	char *			table_label [] = {"Delta x", "Delta y", "x virtual", "y virtual",
					"data packet loss", "packet loss", "number of packets lost", "number of packets received","power",
					"number of packets ignored", "number of packets send", "number of null packets",
					"packets in the buffer"};
	double *		numeric_result;
	Boolean *		boolean;
	double 			packet_loss, data_pkt_loss, total_packet;
	double 			l2cap_delay;
	int				packets_in_subq = 0;
	int 			i;
	char 			out_file_name[32];
	char			file_type[8], separator[3], slave_name[32];
	Boolean			separator_on;
 
	int				label_size = sizeof(table_label)/sizeof(char *);
	
	
	FIN ( bt_end_of_simulation() );
	
	/* get the node objid of this process */
	parent_objid = op_topo_parent (op_id_self());
	
	/* Allocate some memory */
	boolean 		= (Boolean *) op_prg_mem_alloc (label_size*sizeof(Boolean));
	numeric_result 	= (double *) op_prg_mem_alloc (label_size*sizeof(double));
	
	/* We get the report attributes */
	op_ima_obj_attr_get (op_id_self(), "Report", &file_attr_objid);
	file_objid = op_topo_child (file_attr_objid, OPC_OBJTYPE_GENERIC,0);
	
	/*Get the name of out file*/
	op_ima_obj_attr_get ( file_objid, "out file name", out_file_name);
	op_ima_obj_attr_get ( file_objid, "File type", file_type);
	
	if (strcmp (out_file_name, "Auto") == 0)
		strcpy (out_file_name, bt_master_name);
		
	if (strcmp (file_type, "Default") == 0)
		{
		op_ima_obj_attr_get (topo_get_channel (), "Report", &file_channel_attr_objid);
		file_channel_objid = op_topo_child (file_channel_attr_objid, OPC_OBJTYPE_GENERIC,0);
		op_ima_obj_attr_get ( file_channel_objid, "File type", file_type);
		}

	if (strcmp (file_type, ".csv") == 0)
		strcpy (separator, ", ");
	else if (strcmp (file_type, ".txt") == 0)
		strcpy (separator, "\t\t");
	
	/* initialize separator_on to false */
	separator_on = OPC_FALSE;
	
	for (i = 0; i < label_size; i++)
		{
		/* initialize the different results to a default value: -1.0 */
		numeric_result[i] = -1.0;
		
		/* Get all the flags set on the report compound */
		op_ima_obj_attr_get (file_objid, table_label[i], &boolean[i]);
	
		/* Built the label line to display according to the chosen flags before */
		if (boolean[i])
			{
			sprintf (label, "%s%s%s", label, separator_on?separator:"", table_label[i]);
			separator_on = OPC_TRUE;
			}
		}
	
	/* Print some informations about the output results */
	printf ("\n|-------------------------------------------------------------------------|\n");
	printf ("| Info for %s out files :\n", bt_master_name);
	printf ("| \tout file basename : %s\n", out_file_name);
	printf ("|-------------------------------------------------------------------------|\n");

	/* Compute the packet loss */
	total_packet = (double)(mac_number_of_pkt_lost + number_of_pkt_ignored + mac_number_of_pkt_recv + mac_number_of_pkt_null);
	
	if (total_packet)
		packet_loss = (double)(mac_number_of_pkt_lost)/total_packet;
	else
		packet_loss = 0.0;
	
	/* Compute the data packet loss */
	total_packet = (double)(mac_number_of_pkt_lost + number_of_pkt_ignored + mac_number_of_pkt_recv);
	
	if (total_packet)
		data_pkt_loss = (double)(mac_number_of_pkt_lost)/total_packet;
	else
		data_pkt_loss = 0.0;	
	
	
	/* compute the number of packets in the buffer */
	for (i=1; i<=number_of_slave; i++)
		packets_in_subq += packets_in_subqueues[i];
	
	
	bt_get_position(my_objid, &numeric_result[2], &numeric_result[3]);
	
	if (boolean[0])	op_ima_obj_attr_get (my_objid, "Delta x", &numeric_result[0]);
	if (boolean[1]) op_ima_obj_attr_get (my_objid, "Delta y", &numeric_result[1]);
	if (!boolean[2]) numeric_result[2] = -1.0;
	if (!boolean[3]) numeric_result[3] = -1.0;
	if (boolean[4]) numeric_result[4] = data_pkt_loss;
	if (boolean[5]) numeric_result[5] = packet_loss;
	if (boolean[6]) numeric_result[6] = (double) mac_number_of_pkt_lost;
   	if (boolean[7]) numeric_result[7] = (double) mac_number_of_pkt_recv;
	if (boolean[8]) op_ima_obj_attr_get (my_objid, "power", &numeric_result[8]);
   	if (boolean[9]) numeric_result[9] = (double) number_of_pkt_ignored;
   	if (boolean[10]) numeric_result[10] = (double) mac_number_of_pkt_send;
   	if (boolean[11]) numeric_result[11] = (double) mac_number_of_pkt_null;
	if (boolean[12]) numeric_result[12] = (double) packets_in_subq;
	
	/* initialize separator_on to false */
	separator_on = OPC_FALSE; 
	
	for (i = 0; i < label_size; i++)
		{
		if (numeric_result[i] != -1.0)
			{
			sprintf (results , "%s%s%f", results, separator_on?separator:"", numeric_result[i]);
			separator_on = OPC_TRUE;
			}
		}
	
	/* get the file name */	
	sprintf (name, "%s%s%s", out_file_name, stat_loss, file_type);
	
	/* print the file */
	bt_stats_print_report (name, label, results, OPC_TRUE);
	
		
	/* get the next file name */	
	sprintf (name, "%s%s%s", out_file_name, stat_error, file_type);

	/* get the header and data */
	sprintf (label, "error");
	sprintf (results , "%f", (float)total_payload_errs * 366 / (float)bt_pkt_collided);
	
	/* print the file */
	bt_stats_print_report (name, label, results, OPC_TRUE);
	
	
	/* get the next file name */	
	sprintf (name, "%s%s%s", out_file_name, stat_delay, file_type);

	/* Get the header and data */
	sprintf (label, "");
	sprintf (results, "");
	
	separator_on = OPC_FALSE;
	
	for (i=1; i<=number_of_slave; i++)
		{
		if (l2cap_number_of_pkt_recv[i])
			l2cap_delay = total_l2cap_delay[i] / l2cap_number_of_pkt_recv[i];
		else
			l2cap_delay = 0.0;
		
		/* get the name of the slave */
		strcpy (slave_name, topo_get_slave_device_from_address(i, piconet_number)->name_of_slave);
		
		sprintf (label, "%s%sDelay %s%sPkt recv from %s", label, separator_on?separator:"", slave_name, separator, slave_name);
		sprintf (results ,"%s%s%f%s%f", results, separator_on?separator:"", l2cap_delay, separator, l2cap_number_of_pkt_recv[i]);
		
		separator_on = OPC_TRUE;
		}
	
	/* print the file */
	bt_stats_print_report (name, label, results, OPC_TRUE);
	
	/* free the memory */
	op_prg_mem_free (numeric_result);
	op_prg_mem_free (boolean);
	
	/* Print the TCP statitics */
	bt_stats_tcp_end_of_simulation ();
	bt_stats_udp_end_of_simulation ();
	
	bt_mac_free_memory();
	
	FOUT;
}


/*
 * Function : bt_poll_dest_address ()
 *
 * Description : choose a destination address according
 *               to the "Destination address" attribute
 */

static int bt_poll_dest_address ()
	{
	FIN(bt_poll_dest_address());
	
	if (dest_address_read == -1)
		{
		dest_addr_higher_layer++;
		
		if (dest_addr_higher_layer > number_of_slave)
			dest_addr_higher_layer = 1;
		}
	else
		{
		if (dest_address_read > number_of_slave)
			bt_mac_error ("bt_poll_dest_address()", "Invalid destination address", "");
			
		dest_addr_higher_layer = dest_address_read;
		}
	
	FRET(dest_addr_higher_layer);
	}


/*
 * Function:	bt_mac_free_memory
 *
 * Description:
 */

static void bt_mac_free_memory ()
{
	FIN(bt_mac_free_memory ());
	
	op_prg_mem_free (tx_sequence_number);
	op_prg_mem_free (rx_sequence_number);
	op_prg_mem_free (retransmit_pkptr);
	op_prg_mem_free (retransmission_attempts);
	op_prg_mem_free (acknowledgement);
	op_prg_mem_free (tx_acknowledgement);
	op_prg_mem_free (null_ack);
	op_prg_mem_free (txrx_ack);
	op_prg_mem_free (packets_in_subqueues);
	op_prg_mem_free (l2cap_number_of_pkt_recv);
	op_prg_mem_free (total_l2cap_delay);
	
	rr_end_free (rr_bt_queue);

	FOUT;
}

/* End of Function Block */

/* Undefine optional tracing in FIN/FOUT/FRET */
/* The FSM has its own tracing code and the other */
/* functions should not have any tracing.		  */
#undef FIN_TRACING
#define FIN_TRACING

#undef FOUTRET_TRACING
#define FOUTRET_TRACING

#if defined (__cplusplus)
extern "C" {
#endif
	void bt_mac_mast (void);
	Compcode bt_mac_mast_init (void **);
	void bt_mac_mast_diag (void);
	void bt_mac_mast_terminate (void);
	void bt_mac_mast_svar (void *, const char *, char **);
#if defined (__cplusplus)
} /* end of 'extern "C"' */
#endif




/* Process model interrupt handling procedure */


void
bt_mac_mast (void)
	{
	int _block_origin = 0;
	FIN (bt_mac_mast ());
	if (1)
		{
		/* declare some variables for the initialization state */
		int     		piconet_read;
			
		OmsT_Pr_Handle	process_record_handle;
		Objid			my_node_objid;
		Objid			my_subnet_objid;
		Prohandle		own_prohandle;
		char			proc_model_name[256];
		
		int i; // loop variable


		FSM_ENTER (bt_mac_mast)

		FSM_BLOCK_SWITCH
			{
			/*---------------------------------------------------------*/
			/** state (Init) enter executives **/
			FSM_STATE_ENTER_UNFORCED_NOLABEL (0, "Init", "bt_mac_mast () [Init enter execs]")
				{
				/* Initialize the process. Call the initialization */
				/* routine that load all the structures */
				
				bt_mac_sv_init ();
				
				/* Schedule a self interrupt to wait for the other processes 	*/
				/* to move to next state after registering						*/
				op_intrpt_schedule_self (op_sim_time (), 0);
				}


			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (1,bt_mac_mast)


			/** state (Init) exit executives **/
			FSM_STATE_EXIT_UNFORCED (0, "Init", "bt_mac_mast () [Init exit execs]")
				{
				/* Get the objid of the node */
				my_node_objid = op_topo_parent(my_objid);
					
				/* Get the onjid of the subnet */
				my_subnet_objid = op_topo_parent(my_node_objid);
				
				/* Pro-handle of this process */
				own_prohandle = op_pro_self ();
				
				/* Get the name of this process */
				op_ima_obj_attr_get (my_objid, "process model", proc_model_name);
				
				/*fill the piconet_ptr. It is a pointer where we store the master address and the addresses of its slaves*/
				op_ima_obj_attr_get (my_objid, "piconet", &piconet_read);
				
				/* Resolve address */
				oms_aa_address_resolve (oms_aa_handle, my_objid, &my_address);
				
				/* Determine the assigned MAC address. */
				topo_master_device_registration (bt_master_name, my_objid, piconet_read, my_address);
					
				piconet_number = topo_get_piconet_number(piconet_read);
				
				/* Registration for the other layers */
				process_record_handle = (OmsT_Pr_Handle) oms_pr_process_register (my_node_objid, my_objid, own_prohandle, proc_model_name);
				
				/* Register this protocol attribute and the station address of	*/
				/* this process into the model-wide registry.					*/
				oms_pr_attr_set (process_record_handle,
					"protocol",				OMSC_PR_STRING,			"mac",
					"mac_type",				OMSC_PR_STRING,			"Bluetooth",
					"subprotocol",			OMSC_PR_NUMBER,			(double) BLUETOOTH_STA,
					"subnetid",				OMSC_PR_OBJID,			my_subnet_objid,
					"address",				OMSC_PR_NUMBER,			(double) my_address,
					"auto address handle",	OMSC_PR_ADDRESS,		oms_aa_handle,
					OPC_NIL);
				
				}


			/** state (Init) transition processing **/
			FSM_TRANSIT_FORCE (6, state6_enter_exec, ;, "default", "", "Init", "init2")
				/*---------------------------------------------------------*/



			/** state (Idle) enter executives **/
			FSM_STATE_ENTER_UNFORCED (1, state1_enter_exec, "Idle", "bt_mac_mast () [Idle enter execs]")
				{
				/* This state is a waiting state for the MAC layer	*/
				/* It waits for a packet from the higher or lower	*/
				/* layer, or another event that can occurs like the */
				/* CLK event a packet transmission or reception		*/
				}


			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (3,bt_mac_mast)


			/** state (Idle) exit executives **/
			FSM_STATE_EXIT_UNFORCED (1, "Idle", "bt_mac_mast () [Idle exit execs]")
				{
				}


			/** state (Idle) transition processing **/
			FSM_INIT_COND (PACKET_FROM_HIGHER_LAYER)
			FSM_TEST_COND (READY_TO_RECEIVE)
			FSM_TEST_COND (MASTER_CLK_TIMER_EXPIRED)
			FSM_TEST_COND (SIM_END)
			FSM_DFLT_COND
			FSM_TEST_LOGIC ("Idle")

			FSM_TRANSIT_SWITCH
				{
				FSM_CASE_TRANSIT (0, 2, state2_enter_exec, ;, "PACKET_FROM_HIGHER_LAYER", "", "Idle", "Buffer")
				FSM_CASE_TRANSIT (1, 5, state5_enter_exec, ;, "READY_TO_RECEIVE", "", "Idle", "RX")
				FSM_CASE_TRANSIT (2, 3, state3_enter_exec, ;, "MASTER_CLK_TIMER_EXPIRED", "", "Idle", "Clock")
				FSM_CASE_TRANSIT (3, 1, state1_enter_exec, master_end_of_simulation ();, "SIM_END", "master_end_of_simulation ()", "Idle", "Idle")
				FSM_CASE_TRANSIT (4, 1, state1_enter_exec, ;, "default", "", "Idle", "Idle")
				}
				/*---------------------------------------------------------*/



			/** state (Buffer) enter executives **/
			FSM_STATE_ENTER_FORCED (2, state2_enter_exec, "Buffer", "bt_mac_mast () [Buffer enter execs]")
				{
				/* Get the incomming packet and process it */
				switch(op_intrpt_strm())
				{
					case	HIGHER_LAYER_INPUT_STREAM:
						/* When a packet is received from the higher layer	*/
						/* process it thru the L2CAP encapsulation and		*/
						/* segmentation, then enqueue it in the different	*/
						/* subqueues for processing							*/
						bt_higher_layer_pkt_arrival ();
					break;
				
					case	HIGHER_LAYER_VC_INPUT_STREAM:
						/* When a voice packet is received from the higher	*/
						/* layer, process it thru the SCO Unit then enqueue */
						/* it in the different subqueues for processing		*/
						bt_higher_layer_sco_pkt_arrival ();
					break;
				}
				}


			/** state (Buffer) exit executives **/
			FSM_STATE_EXIT_FORCED (2, "Buffer", "bt_mac_mast () [Buffer exit execs]")
				{
				}


			/** state (Buffer) transition processing **/
			FSM_TRANSIT_FORCE (1, state1_enter_exec, ;, "default", "", "Buffer", "Idle")
				/*---------------------------------------------------------*/



			/** state (Clock) enter executives **/
			FSM_STATE_ENTER_FORCED (3, state3_enter_exec, "Clock", "bt_mac_mast () [Clock enter execs]")
				{
				/* This is a clock state used to increment the Bluetooth */
				/* clock and synchronize the TX and RX of the packets	 */
				
				bt_clock (my_objid, piconet_number);
				
				/* if the clock was initialize, we generate the first clock event */
				/* for each slaves of the piconet */
				if (TIME_SLOT_PARITY_ODD)
					{
					for (i=1; i<=number_of_slave; i++)
						{
						/* schedule a clock interupt for each slave */
						op_intrpt_schedule_remote (op_sim_time(), SLAVE_CLK_TIMER, slave_mac_objid[piconet_number][i]);
						}
					}
				}


			/** state (Clock) exit executives **/
			FSM_STATE_EXIT_FORCED (3, "Clock", "bt_mac_mast () [Clock exit execs]")
				{
				}


			/** state (Clock) transition processing **/
			FSM_INIT_COND (READY_TO_TRANSMIT)
			FSM_DFLT_COND
			FSM_TEST_LOGIC ("Clock")

			FSM_TRANSIT_SWITCH
				{
				FSM_CASE_TRANSIT (0, 4, state4_enter_exec, ;, "READY_TO_TRANSMIT", "", "Clock", "TX")
				FSM_CASE_TRANSIT (1, 1, state1_enter_exec, ;, "default", "", "Clock", "Idle")
				}
				/*---------------------------------------------------------*/



			/** state (TX) enter executives **/
			FSM_STATE_ENTER_FORCED (4, state4_enter_exec, "TX", "bt_mac_mast () [TX enter execs]")
				{
				/* 
				 * Ask a packet to the scheduler and if there is any
				 * waiting to be transmitted, then process it thru the
				 * TX
				 */
				
				/*
				 * the function bt_packet_to_transmit will be executed if
				 * the flag_backoff is off or if the current time is greater
				 * than the backoff time
				 */
				 
				bt_packet_to_transmit ();
				}


			/** state (TX) exit executives **/
			FSM_STATE_EXIT_FORCED (4, "TX", "bt_mac_mast () [TX exit execs]")
				{
				}


			/** state (TX) transition processing **/
			FSM_TRANSIT_FORCE (1, state1_enter_exec, ;, "default", "", "TX", "Idle")
				/*---------------------------------------------------------*/



			/** state (RX) enter executives **/
			FSM_STATE_ENTER_FORCED (5, state5_enter_exec, "RX", "bt_mac_mast () [RX enter execs]")
				{
				/* Get a packet from the receiver and decapsulate it	*/
				/* using the L2CAP layer */
				bt_packet_to_receive ();
				}


			/** state (RX) exit executives **/
			FSM_STATE_EXIT_FORCED (5, "RX", "bt_mac_mast () [RX exit execs]")
				{
				}


			/** state (RX) transition processing **/
			FSM_TRANSIT_FORCE (1, state1_enter_exec, ;, "default", "", "RX", "Idle")
				/*---------------------------------------------------------*/



			/** state (init2) enter executives **/
			FSM_STATE_ENTER_UNFORCED (6, state6_enter_exec, "init2", "bt_mac_mast () [init2 enter execs]")
				{
				/* Schedule a self interrupt to wait for the other processes	*/
				/* to move to next state after registering						*/
				op_intrpt_schedule_self (op_sim_time () + 0.0000001, 0);
				}


			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (13,bt_mac_mast)


			/** state (init2) exit executives **/
			FSM_STATE_EXIT_UNFORCED (6, "init2", "bt_mac_mast () [init2 exit execs]")
				{
				/* init state 2 */
				bt_mac_sv_init2 ();
				}


			/** state (init2) transition processing **/
			FSM_TRANSIT_FORCE (1, state1_enter_exec, ;, "default", "", "init2", "Idle")
				/*---------------------------------------------------------*/



			}


		FSM_EXIT (0,bt_mac_mast)
		}
	}

#if defined (__cplusplus)
	extern "C" { 
#endif
	extern VosT_Fun_Status Vos_Catmem_Register (const char * , int , VosT_Void_Null_Proc, VosT_Address *);
	extern VosT_Address Vos_Catmem_Alloc (VosT_Address, size_t);
	extern VosT_Fun_Status Vos_Catmem_Dealloc (VosT_Address);
#if defined (__cplusplus)
	}
#endif


Compcode
bt_mac_mast_init (void ** gen_state_pptr)
	{
	int _block_origin = 0;
	static VosT_Address	obtype = OPC_NIL;

	FIN (bt_mac_mast_init (gen_state_pptr))

	if (obtype == OPC_NIL)
		{
		/* Initialize memory management */
		if (Vos_Catmem_Register ("proc state vars (bt_mac_mast)",
			sizeof (bt_mac_mast_state), Vos_Vnop, &obtype) == VOSC_FAILURE)
			{
			FRET (OPC_COMPCODE_FAILURE)
			}
		}

	*gen_state_pptr = Vos_Catmem_Alloc (obtype, 1);
	if (*gen_state_pptr == OPC_NIL)
		{
		FRET (OPC_COMPCODE_FAILURE)
		}
	else
		{
		/* Initialize FSM handling */
		((bt_mac_mast_state *)(*gen_state_pptr))->current_block = 0;

		FRET (OPC_COMPCODE_SUCCESS)
		}
	}



void
bt_mac_mast_diag (void)
	{
	/* No Diagnostic Block */
	}




void
bt_mac_mast_terminate (void)
	{
	int _block_origin = __LINE__;

	FIN (bt_mac_mast_terminate (void))

	Vos_Catmem_Dealloc (pr_state_ptr);

	FOUT;
	}


/* Undefine shortcuts to state variables to avoid */
/* syntax error in direct access to fields of */
/* local variable prs_ptr in bt_mac_mast_svar function. */
#undef my_address
#undef my_objid
#undef packets_in_subqueues
#undef mac_access_delay_stat
#undef mac_throughput_stat
#undef mac_goodput_stat
#undef hop_freq_stat
#undef mac_total_pkt_bits
#undef mac_total_frame_body_bits
#undef packet_delivery_in_progress
#undef mac_packets_send_stat
#undef mac_packets_recv_stat
#undef mac_number_of_pkt_send
#undef mac_number_of_pkt_recv
#undef acknowledgement
#undef tx_sequence_number
#undef mac_rt_attempt_stat
#undef retransmission_attempts
#undef reassembly_buffer
#undef l2cap_access_delay_stat
#undef l2cap_goodput_stat
#undef l2cap_throughput_stat
#undef l2cap_packets_send_stat
#undef l2cap_packets_recv_stat
#undef l2cap_number_of_pkt_send
#undef l2cap_number_of_pkt_recv
#undef l2cap_total_pkt_bits
#undef l2cap_total_frame_body_bits
#undef reassembly_creation_time
#undef mac_pkt_lost_stat
#undef mac_number_of_pkt_lost
#undef rx_sequence_number
#undef update_tx_sequence
#undef destination_address
#undef sco_packets_send_stat
#undef sco_packets_recv_stat
#undef sco_number_of_pkt_send
#undef sco_number_of_pkt_recv
#undef poll_answer
#undef tx_acl
#undef mac_payload_errs_stat
#undef null_ack
#undef tx_acknowledgement
#undef total_payload_errs
#undef total_l2cap_delay
#undef previous_dest_addr
#undef retransmit_pkptr
#undef piconet_number
#undef debug_flag
#undef number_of_slave
#undef dest_address_read
#undef previous_src_addr
#undef txrx_ack
#undef bt_master_name
#undef dest_addr_higher_layer
#undef start_time_collect
#undef number_of_pkt_ignored
#undef mac_number_of_pkt_null
#undef poll_packet_flag
#undef oms_aa_handle
#undef rr_bt_queue
#undef l2cap_segmentation_size
#undef l2cap_packet_type



void
bt_mac_mast_svar (void * gen_ptr, const char * var_name, char ** var_p_ptr)
	{
	bt_mac_mast_state		*prs_ptr;

	FIN (bt_mac_mast_svar (gen_ptr, var_name, var_p_ptr))

	if (var_name == OPC_NIL)
		{
		*var_p_ptr = (char *)OPC_NIL;
		FOUT;
		}
	prs_ptr = (bt_mac_mast_state *)gen_ptr;

	if (strcmp ("my_address" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->my_address);
		FOUT;
		}
	if (strcmp ("my_objid" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->my_objid);
		FOUT;
		}
	if (strcmp ("packets_in_subqueues" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->packets_in_subqueues);
		FOUT;
		}
	if (strcmp ("mac_access_delay_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_access_delay_stat);
		FOUT;
		}
	if (strcmp ("mac_throughput_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_throughput_stat);
		FOUT;
		}
	if (strcmp ("mac_goodput_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_goodput_stat);
		FOUT;
		}
	if (strcmp ("hop_freq_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->hop_freq_stat);
		FOUT;
		}
	if (strcmp ("mac_total_pkt_bits" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_total_pkt_bits);
		FOUT;
		}
	if (strcmp ("mac_total_frame_body_bits" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_total_frame_body_bits);
		FOUT;
		}
	if (strcmp ("packet_delivery_in_progress" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->packet_delivery_in_progress);
		FOUT;
		}
	if (strcmp ("mac_packets_send_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_packets_send_stat);
		FOUT;
		}
	if (strcmp ("mac_packets_recv_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_packets_recv_stat);
		FOUT;
		}
	if (strcmp ("mac_number_of_pkt_send" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_number_of_pkt_send);
		FOUT;
		}
	if (strcmp ("mac_number_of_pkt_recv" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_number_of_pkt_recv);
		FOUT;
		}
	if (strcmp ("acknowledgement" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->acknowledgement);
		FOUT;
		}
	if (strcmp ("tx_sequence_number" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->tx_sequence_number);
		FOUT;
		}
	if (strcmp ("mac_rt_attempt_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_rt_attempt_stat);
		FOUT;
		}
	if (strcmp ("retransmission_attempts" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->retransmission_attempts);
		FOUT;
		}
	if (strcmp ("reassembly_buffer" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->reassembly_buffer);
		FOUT;
		}
	if (strcmp ("l2cap_access_delay_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->l2cap_access_delay_stat);
		FOUT;
		}
	if (strcmp ("l2cap_goodput_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->l2cap_goodput_stat);
		FOUT;
		}
	if (strcmp ("l2cap_throughput_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->l2cap_throughput_stat);
		FOUT;
		}
	if (strcmp ("l2cap_packets_send_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->l2cap_packets_send_stat);
		FOUT;
		}
	if (strcmp ("l2cap_packets_recv_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->l2cap_packets_recv_stat);
		FOUT;
		}
	if (strcmp ("l2cap_number_of_pkt_send" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->l2cap_number_of_pkt_send);
		FOUT;
		}
	if (strcmp ("l2cap_number_of_pkt_recv" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->l2cap_number_of_pkt_recv);
		FOUT;
		}
	if (strcmp ("l2cap_total_pkt_bits" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->l2cap_total_pkt_bits);
		FOUT;
		}
	if (strcmp ("l2cap_total_frame_body_bits" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->l2cap_total_frame_body_bits);
		FOUT;
		}
	if (strcmp ("reassembly_creation_time" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->reassembly_creation_time);
		FOUT;
		}
	if (strcmp ("mac_pkt_lost_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_pkt_lost_stat);
		FOUT;
		}
	if (strcmp ("mac_number_of_pkt_lost" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_number_of_pkt_lost);
		FOUT;
		}
	if (strcmp ("rx_sequence_number" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->rx_sequence_number);
		FOUT;
		}
	if (strcmp ("update_tx_sequence" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->update_tx_sequence);
		FOUT;
		}
	if (strcmp ("destination_address" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->destination_address);
		FOUT;
		}
	if (strcmp ("sco_packets_send_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->sco_packets_send_stat);
		FOUT;
		}
	if (strcmp ("sco_packets_recv_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->sco_packets_recv_stat);
		FOUT;
		}
	if (strcmp ("sco_number_of_pkt_send" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->sco_number_of_pkt_send);
		FOUT;
		}
	if (strcmp ("sco_number_of_pkt_recv" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->sco_number_of_pkt_recv);
		FOUT;
		}
	if (strcmp ("poll_answer" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->poll_answer);
		FOUT;
		}
	if (strcmp ("tx_acl" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->tx_acl);
		FOUT;
		}
	if (strcmp ("mac_payload_errs_stat" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_payload_errs_stat);
		FOUT;
		}
	if (strcmp ("null_ack" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->null_ack);
		FOUT;
		}
	if (strcmp ("tx_acknowledgement" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->tx_acknowledgement);
		FOUT;
		}
	if (strcmp ("total_payload_errs" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->total_payload_errs);
		FOUT;
		}
	if (strcmp ("total_l2cap_delay" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->total_l2cap_delay);
		FOUT;
		}
	if (strcmp ("previous_dest_addr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->previous_dest_addr);
		FOUT;
		}
	if (strcmp ("retransmit_pkptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->retransmit_pkptr);
		FOUT;
		}
	if (strcmp ("piconet_number" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->piconet_number);
		FOUT;
		}
	if (strcmp ("debug_flag" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->debug_flag);
		FOUT;
		}
	if (strcmp ("number_of_slave" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->number_of_slave);
		FOUT;
		}
	if (strcmp ("dest_address_read" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->dest_address_read);
		FOUT;
		}
	if (strcmp ("previous_src_addr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->previous_src_addr);
		FOUT;
		}
	if (strcmp ("txrx_ack" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->txrx_ack);
		FOUT;
		}
	if (strcmp ("bt_master_name" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->bt_master_name);
		FOUT;
		}
	if (strcmp ("dest_addr_higher_layer" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->dest_addr_higher_layer);
		FOUT;
		}
	if (strcmp ("start_time_collect" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->start_time_collect);
		FOUT;
		}
	if (strcmp ("number_of_pkt_ignored" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->number_of_pkt_ignored);
		FOUT;
		}
	if (strcmp ("mac_number_of_pkt_null" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mac_number_of_pkt_null);
		FOUT;
		}
	if (strcmp ("poll_packet_flag" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->poll_packet_flag);
		FOUT;
		}
	if (strcmp ("oms_aa_handle" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->oms_aa_handle);
		FOUT;
		}
	if (strcmp ("rr_bt_queue" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->rr_bt_queue);
		FOUT;
		}
	if (strcmp ("l2cap_segmentation_size" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->l2cap_segmentation_size);
		FOUT;
		}
	if (strcmp ("l2cap_packet_type" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->l2cap_packet_type);
		FOUT;
		}
	*var_p_ptr = (char *)OPC_NIL;

	FOUT;
	}

