/* Process model C form file: bt_gna_clsvr_mgr.pr.c */
/* Portions of this file copyright 1992-2002 by OPNET Technologies, Inc. */



/* This variable carries the header into the object file */
static const char bt_gna_clsvr_mgr_pr_c [] = "MIL_3_Tfile_Hdr_ 81A 30A op_runsim 7 3E25C669 3E25C669 1 skydiver rebala 0 0 none none 0 0 none 0 0 0 0 0 0                                                                                                                                                                                                                                                                                                                                                                                                                    ";
#include <string.h>



/* OPNET system definitions */
#include <opnet.h>

#if defined (__cplusplus)
extern "C" {
#endif
FSM_EXT_DECS
#if defined (__cplusplus)
} /* end of 'extern "C"' */
#endif


/* Header Block */

#include <stdio.h>
#include <string.h>

#include <tpal.h>
#include <tpal_api.h>
#include <gna_mgr.h>
#include <gna_support.h>
#include <gna_ace_support_v3.h>
#include <app_bgutil_notif_log_support.h>
#include <oms_pr.h>
#include <oms_data_def.h>
#include <gna_serv_intf.h>
#include <oms_bgutil.h>
#include <oms_dist_support.h>
#include <oms_resource_defs.h>
#include <ip_igmp_support.h>
#include <ip_addr_v4.h>
#include <ip_rte_v4.h>
#include <ip_qos_support.h>
#include <oms_dim_stat_support.h>

/***** Macro definitions *****/

/* Code to deifne interrupt code used to schedule	*/
/* self-interrupt for lower layer synchronization.	*/
#define	GNAC_LOWER_LAYER_INIT_INTRPT_COUNT	3
#define	GNAC_LOWER_LAYER_INIT_WAIT			-1
#define	GNAC_SELF_INIT_START				-2
#define GNAC_REGISTRATION_WAIT				-3

/* Interrupt for initial lower layer initialization	*/
#define	INIT_WAIT 		(intrpt_type == OPC_INTRPT_SELF && intrpt_code == GNAC_LOWER_LAYER_INIT_WAIT)
#define	INIT_COMPLETE	(intrpt_type == OPC_INTRPT_SELF && intrpt_code == GNAC_SELF_INIT_START)

/* Repetitions types */
#define GnaT_RepType_Serial 			0
#define GnaT_RepType_Concurrent 		1
#define All_Profiles 					-1

/* A variable whih indicates that the remotely started profile 			*/
/* will be ended as soon as the first profile cycle is over - in other	*/
/* words the number of repetitions for this profile is explicitly set   */
/* to 0.																*/
#define Kill_Immediately				1

/* Specifies a code for the remote process interrupt that 	*/
/* would be sent from a custom manager on a different		*/
/* node indicating that a profile must be started on this	*/
/* node.													*/
#define GnaC_Custom_Remote_Destination	-10

/* To have both server and client functionality on the 		*/
/* net_app_serv the session space has been divided			*/
#define NASC_MAX_SESS_ID		1073741823

/* This offset is used for separating the interrupt code    */
/* space between interrupts for spawning new profiles and   */
/* ending those profiles. 									*/
/* 1. For non-lan models: any interrupt code N	from 0 to 	*/
/* GNAC_PROFILE_END_OFFSET - 1 will be used for spawning 	*/
/* Nth profile, while an interrupt code from				*/
/* GNAC_PROFILE_END_OFFSET to NASC_MAX_SESS_ID - 1 will be  */
/* used to indicate that the Nth profile has ended.			*/	
/* 2. For lan models: any interrupt code N	from 0 to 		*/
/* GNAC_PROFILE_END_OFFSET - 1 will be used for spawning 	*/
/* a profile, while an interrupt code from					*/
/* GNAC_PROFILE_END_OFFSET to NASC_MAX_SESS_ID - 1 will be  */
/* used to indicate that a profile has ended. Each client	*/
/* in lan model is given a profile index that will sent as	*/
/* a code.													*/
#define GNAC_PROFILE_END_OFFSET     		100000000

/* Maximum number of service types availabe.		*/
#define	NASC_NUM_APPS			12

/* ### NOTE: these constants must agree with the sizes of the arrays below... */
#define NASC_NUM_SERVICES		8
#define NASC_MAX_NAME_STRLEN	128

/* Define the values for unspecified overhead and 	*/
/* processing speeds.								*/
#define NASC_OVERHEAD_UNSPEC	-1.0
#define NASC_PR_SPEED_UNSPEC	-1.0
#define NASC_INVALID 			-1000 

#define			Invoked_Profile_Duration		0.0000001

/****** Transition conditions ******/
#define ARRIVAL			((intrpt_type == OPC_INTRPT_STRM) && (sess_type != GNAC_SESSION_TYPE_ACTIVE) && \
						 (Wait_To_Arrival == OPC_TRUE))

#define SVC_COMPL		(intrpt_type == OPC_INTRPT_PROCESS && intrpt_code == OMSC_JOB_COMPLETE)

#define OPEN_IND		(intrpt_type == OPC_INTRPT_REMOTE  && intrpt_code == TPALC_EV_IND_OPEN)
							  
#define CLOSE_IND		((intrpt_type == OPC_INTRPT_REMOTE) && \
						 (intrpt_code == TPALC_EV_IND_CLOSE || intrpt_code == TPALC_EV_IND_ABORT))

#define CLI_REQUEST		(intrpt_type == OPC_INTRPT_REMOTE  && intrpt_code == GNAC_MODEL_REQUEST_TIME)

#define REMOTE_PROFILE	(intrpt_type == OPC_INTRPT_PROCESS && intrpt_code == 0)

#define PROFILE_START	((intrpt_type == OPC_INTRPT_SELF) && (intrpt_code >= 0) && \
						 (intrpt_code < GNAC_PROFILE_END_OFFSET))
	
#define PROFILE_DESTROY	(intrpt_type == OPC_INTRPT_SELF && intrpt_code >= GNAC_PROFILE_END_OFFSET)

#define DISPATCH		app_intrpt_dispatch ();

#define RTRV_COMPLETE	(intrpt_type == OPC_INTRPT_PROCESS && intrpt_code == GnaC_Http_Rtrv_Complete)

#define CLOSE_CONN		(intrpt_type == OPC_INTRPT_SELF && intrpt_code >= 0)

#define CLIENT_CLOSED	(intrpt_type == OPC_INTRPT_PROCESS && intrpt_code == GnaC_Http_Client_Closed)

#define ACE_REQ			(intrpt_type == OPC_INTRPT_PROCESS &&  ( intrpt_code == GnaC_ACE_Network_Tiers_Info_Req || intrpt_code == GnaC_ACE_Task_Cli_Spawn_Req || intrpt_code == GnaC_ACE_Task_Cli_Destroy_Req ))


/* Define constants for the cache hit and miss outcomes */
#define NASC_CACHE_MISS			0
#define NASC_CACHE_HIT			1

int							global_cache_misses;
int							global_cache_hits;
int							global_cache_reqs;

/***** Global Variables *****/
int								nas_global_server_load = 0;
int								nas_global_server_active = 0;
double							nas_global_proc_time = 0.0;
int								nas_num_servers = 0;
static int						trace_active;
PrgT_String_Hash_Table* 		global_task_defs_hash_table_ptr = OPC_NIL;

/* ACE Global variable */
List*							network_ace_tiers_lptr = OPC_NIL;

/* GnaT_Service: Description of a network service */
typedef struct
	{
	char*						name;
	char*						protocol;
	int							port;
	double						pop;
	int							type_of_service;

	/* The following element is used to store supported	*/
	/* RSVP profiles.									*/
	GnaT_Rsvp_Config_Params*	rsvp_params_ptr;	
	} GnaT_Service;

/* GnaT_Serv_Session: Record of a server session */
typedef struct
	{
	Ici*					ici_ptr;
	List					job_list;
	GnaT_Service*			serv_ptr;
	int						cmd_issued;
	int						session_id;
	Evhandle				next_evhandle;
	List					ev_list;
	int						sess_type;

    /* Flag preserving the tpal CLOSE indication.               */
	Boolean					received_close_indication;

    /* Flag indicating whether the application CLOSE CMD has    */
    /* been received or not. This will be used to send a close  */
    /* confirmation packet. Note that the application close is  */
    /* different than the TPAL close. The application close is  */
    /* initiated first and then the TPAL CLOSE is initiated.    */
    Boolean                 appl_close_rcvd;

	/* Flag set when the server has spawned a gna_client process*/
	/* keep a count of whether the server session be cleaned on */
	/* getting a TPALC_CLOSE_IND or kept till the flag is reset */
	Boolean					invoked_client_exists;

	/* Number of jobs in concurrent mode which tells the server */
	/* whether to remove the session or not on close indication */
	int						total_jobs;

	/* The dimensioned statistics for each session is stored 	*/
	/* here so that even if multiple sessions are open the stat	*/
	/* handle are not lost.										*/ 
	Stathandle*				RESPONSE_GEN_TIME;
	int						appl_index;

	/* Specifies whether the close command was already received by	*/
	/* the current server session and is so the close confirm at	*/
	/* least the statistics for multi-tier application are not		*/
	/* written again.												*/
	Boolean 				close_already_rcvd;

	/* The previous source and destination address keeps the last	*/
	/* transaction record's source-destination pairs.				*/
	char*					prev_src_addr; 
	char*					prev_dest_addr;

	/* Indicates the Application Type of the current server session */
	GnaT_Application_Type	app_type;
	
	/* Application name */
	char					app_name [256];
	} GnaT_Serv_Session;


static const char* NasC_Service_Names [NASC_NUM_SERVICES] = 
	{
	"Custom Application",
	"DB Entry Application",
	"DB Query Application",
	"Email",
	"Ftp",
	"Http",
	"Print",
	"Remote Login",
	};	

/* The Enumnerated type indicates the type of the job in the*/
/* server queue especially for the scripted application		*/
typedef enum
	{
	NasC_Request_Processing,
	NasC_Response_Processing,
	NasC_Client_Invocation,
	NasC_Client_Indication
	} NasC_Job_Type;

/* The Profile Statistics List keeps track of all 	*/
/* the profiles in the past that had used the 		*/
/* services of the current server. All these are	*/
/* recorded in the same statistics.					*/
typedef struct
	{
	char*					profile_name;
	Stathandle				server_traffic_send_stat;
	Stathandle				server_traffic_received_stat;
	Stathandle				response_gen_time_stat;
	} NasT_Profile_Stat_Rec;

/* GnaT_Job: Record of a job to be processed */
typedef struct
	{
	GnaT_Application_Type	app_type;
	double					last_update_time;
	char					app_name [256];
	double					service_time;
	Boolean					use_cpu_process_time;
	Packet*					result;
	int						resp_count;
	int						command;
	double					duration;
	int						cli_sess_id;
	NasC_Job_Type			type;
	List*					resp_size_lptr;
	int						end_marker;
	Prohandle				source_prohandle;
	int						phase_index;
	int						task_index;
	int						type_of_request;	/* Indicate whether the packet received by server	*/
												/* is a query or an entry.							*/
	OmsT_Resource_Job_Id	job_id;				
	} GnaT_Job;

/* The processing mode of the net_app_serv : Either Time Sharing or Concurrent 	*/
/* In time sharing the CPU is divided amoung the present active jobs and also  	*/
/* the background utilization. In the concurrent mode the CPU executes a job	*/
/* in its defined service time irrespective of the other jobs in the system		*/
typedef enum
	{
	NasC_Simulate_Contention,
	NasC_Contention_Already_Modeled
	} NasC_Contention_Mode;

/* The record keeps account of session_id, sess_ptr and transaction profile		*/
/* along with the start_time and the stat ptr. It is initailed when the server	*/
/* schedules a job in the "arrv" state and after the expiry of the job in the	*/
/* "compl" state, it schedules an intrpt for the gna_cli invocation.			*/
typedef struct
	{
	int								session_id;
	GnaT_Cli_Mgr_Session*			sess_ptr;
	GnaT_Serv_Session*				serv_sess_ptr;
	int 							type_of_service;
	
	/* Specifies if the statistics have to be written by this node.	*/
	Boolean							stat_write_enable;

	/* Time required to complete the first request generation 	*/
	double							req_gen_time;
	} GnaT_SerCli_Info;

/* GnaT_Pending_Job: All jobs that are pending a response 	*/
/* from the origin server.									*/
typedef struct
	{
	Packet*					req_pk;
	GnaT_Serv_Session* 		sess_ptr;
	int						pkt_id;
	} GnaT_Pending_Job;

/* Server info structure, used for HTTP*/
typedef struct
     {
	 char*	server_name;
	 int 	repeats_left;
	 List*  objects_queued_lptr;
	 List*	server_session_lptr;
	 List*	send_objects_lptr;
     } Server_Status_Desc;


 typedef struct
     {
	 int		object_index;
	 int		number_of_objects;
	 double		size;
     } Queued_Object_Desc;

 typedef struct 
     {
	 double 		   	key_id;
	 OmsT_Dt_Key   		session_key;
     } Key_Desc;

 /* Contains info about all profiles enabled at */
 /* node, in order to avoid duplicative profile */
 /* spawning. For self-started profiles, profile*/ 
 /* index is set to -1.							*/
typedef struct
	{
	char* 		profile_name_ptr;
	int			profile_index;
	int			application_index;
	int			local_profile_index;
	} Enabled_Profiles_Desc;

/* Contains stathandles for each application */
typedef struct
	{
	char					app_name_type [36];
	char					app_name [256]	;
	OmsT_Dim_Stat_Handle				pkts_rcvd_stat_handle;					
	OmsT_Dim_Stat_Handle				pkts_sent_stat_handle;
	OmsT_Dim_Stat_Handle				bytes_rcvd_stat_handle;
	OmsT_Dim_Stat_Handle				bytes_sent_stat_handle;
	OmsT_Dim_Stat_Handle				num_sessions_stat_handle;
	OmsT_Dim_Stat_Handle				num_jobs_stat_handle;
	OmsT_Dim_Stat_Handle				service_time_stat_handle;
	Distribution*			overhead_distribution;
	double					processing_speed;
	Stathandle				g_pkts_rcvd_stat_handle;					
	Stathandle				g_pkts_sent_stat_handle;
	Stathandle				g_bytes_rcvd_stat_handle;
	Stathandle				g_bytes_sent_stat_handle;
	
	/* Database specific stats 	*/
	/* Stats for Queries 		*/
	OmsT_Dim_Stat_Handle				dbq_pkts_rcvd_stat_handle;					
	OmsT_Dim_Stat_Handle				dbq_pkts_sent_stat_handle;
	OmsT_Dim_Stat_Handle				dbq_bytes_rcvd_stat_handle;
	OmsT_Dim_Stat_Handle				dbq_bytes_sent_stat_handle;
	OmsT_Dim_Stat_Handle				dbq_num_jobs_stat_handle;
	OmsT_Dim_Stat_Handle				dbq_service_time_stat_handle;
	Stathandle				dbq_g_pkts_rcvd_stat_handle;					
	Stathandle				dbq_g_pkts_sent_stat_handle;
	Stathandle				dbq_g_bytes_rcvd_stat_handle;
	Stathandle				dbq_g_bytes_sent_stat_handle;
	
	/* Stats for Entries		*/
	OmsT_Dim_Stat_Handle				dbe_pkts_rcvd_stat_handle;					
	OmsT_Dim_Stat_Handle				dbe_pkts_sent_stat_handle;
	OmsT_Dim_Stat_Handle				dbe_bytes_rcvd_stat_handle;
	OmsT_Dim_Stat_Handle				dbe_bytes_sent_stat_handle;
	OmsT_Dim_Stat_Handle				dbe_num_jobs_stat_handle;
	OmsT_Dim_Stat_Handle				dbe_service_time_stat_handle;		
	Stathandle				dbe_g_pkts_rcvd_stat_handle;					
	Stathandle				dbe_g_pkts_sent_stat_handle;
	Stathandle				dbe_g_bytes_rcvd_stat_handle;
	Stathandle				dbe_g_bytes_sent_stat_handle;
	} GnaT_App_Stat_Info;

/* Contains stathandles for each application */
typedef struct
	{   
	Stathandle				g_pkts_rcvd_stat_handle;					
	Stathandle				g_pkts_sent_stat_handle;
	Stathandle				g_bytes_rcvd_stat_handle;
	Stathandle				g_bytes_sent_stat_handle;
	
	/* Database stats */
	Stathandle				dbe_g_pkts_rcvd_stat_handle;					
	Stathandle				dbe_g_pkts_sent_stat_handle;
	Stathandle				dbe_g_bytes_rcvd_stat_handle;
	Stathandle				dbe_g_bytes_sent_stat_handle;	
	Stathandle				dbq_g_pkts_rcvd_stat_handle;					
	Stathandle				dbq_g_pkts_sent_stat_handle;
	Stathandle				dbq_g_bytes_rcvd_stat_handle;
	Stathandle				dbq_g_bytes_sent_stat_handle;	
	} GnaT_App_Glob_Stat_Info;

typedef enum
	{
	Pkts_Sent = 0,
	Pkts_Rcvd,
	Bytes_Sent,
	Bytes_Rcvd,
	Num_Jobs,
	Num_Sess,
	Task_Proc_Time
	} GnaT_Stat_Type;

/* Server functions prototypes */
static void						gna_clsvr_mgr_conf_read ();
static void						gna_clsvr_mgr_open (GnaT_Service* serv_ptr);
static GnaT_Job*				gna_clsvr_mgr_job_create (GnaT_Application_Type app_type, char* app_name, int type_of_request);
static void						gna_clsvr_mgr_job_destroy (GnaT_Job* job_ptr);
static void						gna_clsvr_mgr_stats_update (GnaT_Application_Type app_type, char* app_name_ptr, GnaT_Stat_Type stat_type, double, double, int type_of_request);
static void						gna_clsvr_mgr_list_print ();
static void						gna_clsvr_mgr_sess_list_print ();
static void 					gna_clsvr_mgr_serv_id_assign ();
static Compcode 				gna_clsvr_mgr_session_cleanup (GnaT_Serv_Session* app_id, 
									Boolean job_completion_recomputation_required);
static Boolean 					gna_clsvr_mgr_segment_insert (Packet **pk_ptr);
static Compcode 				gna_clsvr_mgr_session_cleanup (GnaT_Serv_Session* app_id, 
									Boolean job_completion_recomputation_required);

static GnaT_Application_Type 	gna_clsvr_mgr_port_to_apptype (GnaT_App port_name);

/* Client function prototypes */
static GnaT_Nam_Profile* 		gna_client_profile_parser (GnaT_Profile_Desc*, Boolean same_lan_profile, Boolean, int);
static void 					gna_client_actual_servers_parse (Objid, char*, GnaT_Nam_Appl* );
static void 					gna_nam_profiles_start (int profile_index);
static void 					gna_profiles_spawn ();
static void						gna_client_params_parse ();
static void						gna_passive_video_client_spawn ();
static void 					gna_passive_voice_client_spawn ();
static void 					app_intrpt_dispatch (void);
static void 					gna_nam_supported_sources_parse ();
static void						gna_client_nam_error (const char* msg1, const char* msg2, const char* msg3);
static void						gna_multicast_addresses_register ();
static Boolean					nam_app_mcast_addr_validate (IpT_Address ip_grp_addr);
static GnaT_Rsvp_Config_Params*	client_nam_rsvp_params_read (Boolean rsvp_status, char* outbound_flow_ptr, char* inbound_flow_ptr, int type_of_request);
static Boolean					gna_client_object_is_lan (void);
static void						gna_llm_init ();
static int						gna_clsvr_mgr_find_smallest_profile_index (void);
static double					gna_clsvr_mgr_service_time_compute (Packet* pk_ptr, char* app_name_ptr, 
																	GnaT_Application_Type app_type, double response_size, 
																	double pk_size, int type_of_request, Boolean* use_cpu_processing_time);
static void						gna_clsvr_mgr_close_packet_send (GnaT_Serv_Session*	  sess_ptr);
static void 					gna_clsvr_mgr_custom_app_prepare (GnaT_Nam_Appl* nam_appl_ptr, Boolean same_lan_profile, 
											Boolean remote_invokation, int lan_profile_index);
static Boolean					gna_clsvr_mgr_indirect_custom_app_check (Packet* pk_ptr, GnaT_Serv_Session* sess_ptr);

/***** Init function prototypes *****/
static void						gna_clsvr_mgr_sv_init ();

/***** ACE function prototypes  *****/
char*								gna_clsvr_mgr_my_address_get ();
static void 						gna_clsvr_mgr_ace_tiers_register ();
static List*						gna_clsvr_mgr_ace_tiers_get ();
static void							gna_ace_reg_tiers_list_free (List* registered_tiers_lptr);
static GnaT_Ace_Dest_Prefs*			gna_clsvr_mgr_dest_prefs_get ();
static List*						gna_clsvr_mgr_dest_addrs_get (Objid dest_pref_objid);
static GnaT_Ace_Network_Tier_Info* 	gna_clsvr_mgr_network_ace_tier_get (char* tier_name);
static Compcode						gna_clsvr_mgr_network_ace_tier_list_insert (List* registered_tiers_lptr);
static int							gna_ace_listening_port_select ();
static void							gna_ace_global_stats_hash_tables_create ();

/***** ACE trace functions *******/
static void					    gna_ace_cli_spawn_trace_print(Ici* gna_ace_conn_open_req_ici_ptr);

/***** Error reporting function prototypes *****/
static void						gna_clsvr_mgr_warn (const char* msg1);
static void						gna_clsvr_mgr_error (const char* msg1);

/***** Web Caching functions */
static int						gna_clsvr_mgr_cache_find_server_index (List* server_lptr, char* server_name);
static void						gna_clsvr_mgr_cache_contact_server (Packet* pk_ptr, GnaT_Serv_Session* sess_ptr);
static void						gna_clsvr_mgr_cache_spawn_session (GnaT_Cli_Mgr_Session* sess_ptr, int sess_command, int server_index, 
									int http_command, List* inline_objects_list, double req_size, GnaT_Nam_Appl* appl_info_ptr, int pkt_id);
static void						gna_custom_nam_mgr_notify (Prohandle, int, int, int);
static void						gna_clsvr_mgr_process_close (Packet* pk_ptr, GnaT_Serv_Session* sess_ptr);
static void						gna_clsvr_mgr_cache_update_cache_stats ();	
static int						gna_clsvr_mgr_cache_data_in_cache ();
static void						gna_clsvr_mgr_process_request (Packet* pk_ptr, GnaT_Serv_Session* sess_ptr);
static void						gna_clsvr_mgr_stat_initialize (char* app_type, char* app_name, int index, double, double);
static GnaT_Cli_Mgr_Session*	gna_clsvr_mgr_cache_connection_check (int server_index);
static void						gna_clsvr_mgr_cache_server_request_check (Packet* pk_ptr, GnaT_Serv_Session* sess_ptr);

/* End of Header Block */


#if !defined (VOSD_NO_FIN)
#undef	BIN
#undef	BOUT
#define	BIN		FIN_LOCAL_FIELD(last_line_passed) = __LINE__ - _block_origin;
#define	BOUT	BIN
#define	BINIT	FIN_LOCAL_FIELD(last_line_passed) = 0; _block_origin = __LINE__;
#else
#define	BINIT
#endif /* #if !defined (VOSD_NO_FIN) */



/* State variable definitions */
typedef struct
	{
	/* Internal state tracking for FSM */
	FSM_SYS_STATE
	/* State Variables */
	int	                    		lower_layer_init_intrpt_count;
	Objid	                  		my_objid;
	int	                    		my_process_id;
	Objid	                  		my_tpal_objid;
	double	                 		current_sim_time;
	char*	                  		my_tpal_address;
	List*	                  		task_mgr_list_ptr;
	List*	                  		cli_info_list_ptr;
	int	                    		client_sess_id;
	int	                    		no_of_act_sess;
	NasC_Contention_Mode	   		processing_mode;
	List	                   		serv_list;
	List	                   		sess_list;
	int	                    		num_active_sess;
	int	                    		sess_list_size;
	Sbhandle	               		segmentation_buf_handle;
	Sbhandle	               		reassembly_buf_handle;
	double	                 		app_segment_size;
	double	                 		proc_speed [NASC_NUM_APPS];
	Distribution*	          		overhead_dist [NASC_NUM_APPS];
	int	                    		server_id;
	LlmT_Lan_Handle	        		my_lan_handle;
	Boolean	                		close_conf_already_rcvd;
	int	                    		cli_sess_list_size;
	int	                    		sess_id;
	List*	                  		rsvp_profile_table_ptr;
	GnaT_Nam_Desc*	         		nam_profiles_ptr;
	double	                 		sim_duration;
	Boolean	                		ace_spec_log_written;
	GnaT_Global_Info*	      		global_information_ptr;
	int	                    		rlogin_max_stat_index;
	int	                    		database_max_stat_index;
	int	                    		http_max_stat_index;
	int	                    		print_max_stat_index;
	int	                    		ftp_max_stat_index;
	int	                    		video_max_stat_index;
	int	                    		voice_max_stat_index;
	int	                    		email_max_stat_index;
	int	                    		custom_max_stat_index;
	List*	                  		sources_lptr;
	List*	                  		active_profiles_lptr;
	OmsT_Resource_Handle	   		cpu_resource_hndl;
	double	                 		application_segment_size;
	Boolean	                		custom_stats_registered;
	Boolean	                		node_is_lan;
	LlmT_Lan_Handle	        		sess_lan_handle;
	int	                    		sess_wkstn_id;
	int	                    		number_of_wkstns;
	Objid	                  		my_node_id;
	int	                    		last_wkstn_id;
	double	                 		remote_end_time;
	OmsT_Pr_Handle	         		process_record_handle;
	int	                    		mtu_sv;
	double	                 		hit_rate_thresh;
	List*	                  		pending_job_lptr;
	int	                    		cache_hits;
	int	                    		cache_misses;
	int	                    		cache_reqs;
	Stathandle	             		CACHE_HIT_RATE_SH;
	Stathandle	             		CACHE_HIT_RATE_GSH;
	int	                    		http_version;
	int	                    		send_buffer_size;
	GnaT_Http_Desc*	        		http_params_ptr;
	OmsT_Dt_Handle	         		session_record_handle;
	Server_Status_Desc**	   		server_info_array_ptr;
	List*	                  		servers_lptr;
	Boolean	                		web_caching_enabled;
	Boolean	                		custom_passive_session_registered;
	Stathandle	             		SERV_NUM_SESS;
	Stathandle	             		SERV_NUM_JOBS;
	Stathandle	             		SERV_SERVICE_TIME;
	Stathandle	             		SERV_GLOBAL_SERVICE_TIME;
	Stathandle	             		SERV_GLOBAL_NUM_SESS;
	List*	                  		disabled_profiles_lptr;
	List*	                  		called_video_client_shared_mem_ptr;
	List*	                  		called_voice_client_shared_mem_ptr;
	PrgT_String_Hash_Table*			server_stats_hash_table_ptr;
	PrgT_String_Hash_Table*			server_global_stats_hash_table_ptr;
	int	                    		stat_indexes_table [NASC_NUM_APPS];
	OmsT_Server_Job_Table_Handle			job_table_hndl;
	Prohandle	              		my_prohandle;
	char*	                  		my_node_addr;
	Boolean	                		ace_ltrace_active;
	List*	                  		ace_ports_in_use_lptr;
	GnaT_Ace_Dest_Prefs*	   		ace_dest_prefs_ptr;
	GnaT_App_Mod_Mem*	      		gna_clsvr_app_mod_mem_ptr;
	Objid	                  		transport_protocol_objid;
	} bt_gna_clsvr_mgr_state;

#define pr_state_ptr            		((bt_gna_clsvr_mgr_state*) SimI_Mod_State_Ptr)
#define lower_layer_init_intrpt_count		pr_state_ptr->lower_layer_init_intrpt_count
#define my_objid                		pr_state_ptr->my_objid
#define my_process_id           		pr_state_ptr->my_process_id
#define my_tpal_objid           		pr_state_ptr->my_tpal_objid
#define current_sim_time        		pr_state_ptr->current_sim_time
#define my_tpal_address         		pr_state_ptr->my_tpal_address
#define task_mgr_list_ptr       		pr_state_ptr->task_mgr_list_ptr
#define cli_info_list_ptr       		pr_state_ptr->cli_info_list_ptr
#define client_sess_id          		pr_state_ptr->client_sess_id
#define no_of_act_sess          		pr_state_ptr->no_of_act_sess
#define processing_mode         		pr_state_ptr->processing_mode
#define serv_list               		pr_state_ptr->serv_list
#define sess_list               		pr_state_ptr->sess_list
#define num_active_sess         		pr_state_ptr->num_active_sess
#define sess_list_size          		pr_state_ptr->sess_list_size
#define segmentation_buf_handle 		pr_state_ptr->segmentation_buf_handle
#define reassembly_buf_handle   		pr_state_ptr->reassembly_buf_handle
#define app_segment_size        		pr_state_ptr->app_segment_size
#define proc_speed              		pr_state_ptr->proc_speed
#define overhead_dist           		pr_state_ptr->overhead_dist
#define server_id               		pr_state_ptr->server_id
#define my_lan_handle           		pr_state_ptr->my_lan_handle
#define close_conf_already_rcvd 		pr_state_ptr->close_conf_already_rcvd
#define cli_sess_list_size      		pr_state_ptr->cli_sess_list_size
#define sess_id                 		pr_state_ptr->sess_id
#define rsvp_profile_table_ptr  		pr_state_ptr->rsvp_profile_table_ptr
#define nam_profiles_ptr        		pr_state_ptr->nam_profiles_ptr
#define sim_duration            		pr_state_ptr->sim_duration
#define ace_spec_log_written    		pr_state_ptr->ace_spec_log_written
#define global_information_ptr  		pr_state_ptr->global_information_ptr
#define rlogin_max_stat_index   		pr_state_ptr->rlogin_max_stat_index
#define database_max_stat_index 		pr_state_ptr->database_max_stat_index
#define http_max_stat_index     		pr_state_ptr->http_max_stat_index
#define print_max_stat_index    		pr_state_ptr->print_max_stat_index
#define ftp_max_stat_index      		pr_state_ptr->ftp_max_stat_index
#define video_max_stat_index    		pr_state_ptr->video_max_stat_index
#define voice_max_stat_index    		pr_state_ptr->voice_max_stat_index
#define email_max_stat_index    		pr_state_ptr->email_max_stat_index
#define custom_max_stat_index   		pr_state_ptr->custom_max_stat_index
#define sources_lptr            		pr_state_ptr->sources_lptr
#define active_profiles_lptr    		pr_state_ptr->active_profiles_lptr
#define cpu_resource_hndl       		pr_state_ptr->cpu_resource_hndl
#define application_segment_size		pr_state_ptr->application_segment_size
#define custom_stats_registered 		pr_state_ptr->custom_stats_registered
#define node_is_lan             		pr_state_ptr->node_is_lan
#define sess_lan_handle         		pr_state_ptr->sess_lan_handle
#define sess_wkstn_id           		pr_state_ptr->sess_wkstn_id
#define number_of_wkstns        		pr_state_ptr->number_of_wkstns
#define my_node_id              		pr_state_ptr->my_node_id
#define last_wkstn_id           		pr_state_ptr->last_wkstn_id
#define remote_end_time         		pr_state_ptr->remote_end_time
#define process_record_handle   		pr_state_ptr->process_record_handle
#define mtu_sv                  		pr_state_ptr->mtu_sv
#define hit_rate_thresh         		pr_state_ptr->hit_rate_thresh
#define pending_job_lptr        		pr_state_ptr->pending_job_lptr
#define cache_hits              		pr_state_ptr->cache_hits
#define cache_misses            		pr_state_ptr->cache_misses
#define cache_reqs              		pr_state_ptr->cache_reqs
#define CACHE_HIT_RATE_SH       		pr_state_ptr->CACHE_HIT_RATE_SH
#define CACHE_HIT_RATE_GSH      		pr_state_ptr->CACHE_HIT_RATE_GSH
#define http_version            		pr_state_ptr->http_version
#define send_buffer_size        		pr_state_ptr->send_buffer_size
#define http_params_ptr         		pr_state_ptr->http_params_ptr
#define session_record_handle   		pr_state_ptr->session_record_handle
#define server_info_array_ptr   		pr_state_ptr->server_info_array_ptr
#define servers_lptr            		pr_state_ptr->servers_lptr
#define web_caching_enabled     		pr_state_ptr->web_caching_enabled
#define custom_passive_session_registered		pr_state_ptr->custom_passive_session_registered
#define SERV_NUM_SESS           		pr_state_ptr->SERV_NUM_SESS
#define SERV_NUM_JOBS           		pr_state_ptr->SERV_NUM_JOBS
#define SERV_SERVICE_TIME       		pr_state_ptr->SERV_SERVICE_TIME
#define SERV_GLOBAL_SERVICE_TIME		pr_state_ptr->SERV_GLOBAL_SERVICE_TIME
#define SERV_GLOBAL_NUM_SESS    		pr_state_ptr->SERV_GLOBAL_NUM_SESS
#define disabled_profiles_lptr  		pr_state_ptr->disabled_profiles_lptr
#define called_video_client_shared_mem_ptr		pr_state_ptr->called_video_client_shared_mem_ptr
#define called_voice_client_shared_mem_ptr		pr_state_ptr->called_voice_client_shared_mem_ptr
#define server_stats_hash_table_ptr		pr_state_ptr->server_stats_hash_table_ptr
#define server_global_stats_hash_table_ptr		pr_state_ptr->server_global_stats_hash_table_ptr
#define stat_indexes_table      		pr_state_ptr->stat_indexes_table
#define job_table_hndl          		pr_state_ptr->job_table_hndl
#define my_prohandle            		pr_state_ptr->my_prohandle
#define my_node_addr            		pr_state_ptr->my_node_addr
#define ace_ltrace_active       		pr_state_ptr->ace_ltrace_active
#define ace_ports_in_use_lptr   		pr_state_ptr->ace_ports_in_use_lptr
#define ace_dest_prefs_ptr      		pr_state_ptr->ace_dest_prefs_ptr
#define gna_clsvr_app_mod_mem_ptr		pr_state_ptr->gna_clsvr_app_mod_mem_ptr
#define transport_protocol_objid		pr_state_ptr->transport_protocol_objid

/* This macro definition will define a local variable called	*/
/* "op_sv_ptr" in each function containing a FIN statement.	*/
/* This variable points to the state variable data structure,	*/
/* and can be used from a C debugger to display their values.	*/
#undef FIN_PREAMBLE
#define FIN_PREAMBLE	bt_gna_clsvr_mgr_state *op_sv_ptr = pr_state_ptr;


/* Function Block */

enum { _block_origin = __LINE__ };
/***** State variable initialization. *****/

static void
gna_clsvr_mgr_sv_init ()
	{
	List*				proc_record_handle_list_ptr;
	OmsT_Pr_Handle		temp_process_record_handle;
	char				tpal_address [256];
	char				proc_model_name [256];
	int					i;
	Objid				temp_objid;
	
	/** Inializes state variables used by this process.	**/
	FIN (gna_clsvr_mgr_sv_init ());

	/* Obtain self prohandle */
	my_prohandle = op_pro_self ();

	/*	Register the server application. */
	op_ima_obj_attr_get (my_objid, "process model", proc_model_name);
	my_process_id = op_pro_id (my_prohandle);
	process_record_handle = (OmsT_Pr_Handle) oms_pr_process_register (
		my_node_id, my_objid, my_prohandle, proc_model_name);
	
	/* Locate the TPAL module. It must have registered	*/
	/* in the process registry.							*/
	proc_record_handle_list_ptr = op_prg_list_create ();

	/* Obtain the process handles by matching the specific descriptors			*/
	oms_pr_process_discover (OPC_OBJID_INVALID, proc_record_handle_list_ptr,
		"node objid",	OMSC_PR_OBJID,		my_node_id,
		"protocol",		OMSC_PR_STRING,		"tpal",
		OPC_NIL);

	/* Each workstation can have only one TPAL module.	*/
	if (op_prg_list_size (proc_record_handle_list_ptr) == 1)
		{
		temp_process_record_handle = (OmsT_Pr_Handle) op_prg_list_remove (proc_record_handle_list_ptr, OPC_LISTPOS_TAIL);

		/* Obtain the module objid of the tpal module	*/
		oms_pr_attr_get (temp_process_record_handle, "module objid", OMSC_PR_OBJID, &my_tpal_objid);
	
		/* Deallocate the memory allocated for holding the record handle	*/
		while (op_prg_list_size (proc_record_handle_list_ptr) > 0)
			op_prg_list_remove (proc_record_handle_list_ptr, OPC_LISTPOS_HEAD);
		op_prg_mem_free (proc_record_handle_list_ptr);	
		}
	else
		{
		gna_clsvr_mgr_error ("No or more than one process(es) exist with their protocols as TPAL.");
		}

	/* Obtain the address assigned to the TPAL layer.	*/
	op_ima_obj_attr_get (my_tpal_objid, "Address", tpal_address);
	my_tpal_address = (char *) op_prg_mem_alloc ((strlen (tpal_address) + 1) * sizeof (char));
	strcpy (my_tpal_address, tpal_address);
	
	/* Create a service resource for generating service times.	*/
	cpu_resource_hndl = Oms_Resource_Handle_Get (my_node_id, my_objid, "CPU");
	job_table_hndl = Oms_Server_Get_Job_Table_Handle (my_node_id);
	
	/* Set flag to indicate whether the node is a lan model.	*/
	node_is_lan = gna_client_object_is_lan ();
	/* Set the address of the node in which this process exists */ 
	my_node_addr = gna_clsvr_mgr_my_address_get ();

	/* Create a list to store the ACE ports numbers which are     */
	/* currently in use. This is is passed to each ACE cli when   */
	/* it is created. When the cli is done using a port, it frees */
	/* the port number from this list thus allowing ports to be   */
	/* recycled. This helps to keep the port numbers unique       */
	ace_ports_in_use_lptr = op_prg_list_create ();
	
	/* Set ACE trace info */
	if (op_prg_odb_ltrace_active ("gna") || op_prg_odb_ltrace_active ("gna_ace"))
		ace_ltrace_active = OPC_TRUE;
	else
		ace_ltrace_active = OPC_FALSE;

	ace_spec_log_written = OPC_FALSE;
	
	/* Initiate server stats hash table */ 
	server_stats_hash_table_ptr = prg_string_hash_table_create (30, 256);
	server_global_stats_hash_table_ptr = prg_string_hash_table_create (30, 256);
  
	/* Create module memory to contain a hash table used	*/
	/* to create HTTP  response time stats.				*/
	gna_clsvr_app_mod_mem_ptr = (GnaT_App_Mod_Mem *) op_prg_mem_alloc (sizeof (GnaT_App_Mod_Mem));
	
	
	/* For Application Bgutil Traffic */
	gna_clsvr_app_mod_mem_ptr->node_bgutil_hndl 	= OPC_NIL;
	gna_clsvr_app_mod_mem_ptr->app_bgutil_capable 	= OPC_TRUE;
	
	/* For HTTP applications */
	gna_clsvr_app_mod_mem_ptr->next_http_obj_stat_index = 0;
	gna_clsvr_app_mod_mem_ptr->http_obj_stat_htable_ptr = (PrgT_String_Hash_Table *) OPC_NIL;
	
	/* For Voice application */
    gna_clsvr_app_mod_mem_ptr->voice_next_bgutil_flow_ete_index        	= 0;
	gna_clsvr_app_mod_mem_ptr->voice_bgutil_ete_stathndl_ptr			= (Stathandle *) OPC_NIL;
    gna_clsvr_app_mod_mem_ptr->voice_bgutil_flow_ete_hash_table_ptr	  	= (PrgT_String_Hash_Table *) OPC_NIL;
	
	/* For Video application */
    gna_clsvr_app_mod_mem_ptr->video_next_bgutil_flow_ete_index        	= 0;
	gna_clsvr_app_mod_mem_ptr->video_bgutil_ete_stathndl_ptr			= (Stathandle *) OPC_NIL;
    gna_clsvr_app_mod_mem_ptr->video_bgutil_flow_ete_hash_table_ptr	  	= (PrgT_String_Hash_Table *) OPC_NIL;
	
	/* For Custom applications.	*/
	gna_clsvr_app_mod_mem_ptr->next_cust_art_stat_index 			 	= 0;
	gna_clsvr_app_mod_mem_ptr->cust_art_stat_htable_ptr 				= (PrgT_String_Hash_Table *) OPC_NIL;
	
	/** For ACE applications.	**/
	gna_clsvr_app_mod_mem_ptr->ace_task_list_ptr 						= op_prg_list_create ();

	/* Initialize the pending event list */
	op_prg_list_init (&(gna_clsvr_app_mod_mem_ptr->pending_event_list));
	
	/* Install module memory.	*/
	op_pro_modmem_install (gna_clsvr_app_mod_mem_ptr);
			
	/* Initialize stat indexes for each application */
	for (i = 0; i < NASC_NUM_APPS; i++)
		stat_indexes_table [i] = 0;
	
	/* Get the object ID of the 'Transport Protocol' attribute.	*/
	op_ima_obj_attr_get (my_objid, "Transport Protocol", &temp_objid);
	transport_protocol_objid = op_topo_child (temp_objid, OPC_OBJTYPE_GENERIC, 0);
	
	FOUT;
	}

/***** ACE application only: Supported tier / passive connection handling *****/

char*
gna_clsvr_mgr_my_address_get ()
	{
	char		my_addr [512];
	char*		return_value;

	/* This function return the address of the node in which this process exists */
	/* The user of this function is eventually responsible for deallocating the  */
	/* memory of the returned string											 */
	FIN (gna_clsvr_mgr_my_address_get ());
	
	/* Get the name */
	op_ima_obj_attr_get (my_tpal_objid, "Address", my_addr);
	
	/* Allocate memory for return value.	*/
	return_value = (char *) op_prg_mem_alloc ((strlen (my_addr) + 1) * sizeof (char));
	strcpy (return_value, my_addr);
	
	FRET (return_value);
	} /* End gna_clsvr_mgr_my_address_get ()*/

static void
gna_clsvr_mgr_ace_tiers_register ()
	{
	List*							registered_tiers_lptr;

	/** This function registers the ACE tiers for which this node **/
	/** is registered in a global list. This list is eventually   **/
	/** used by gna_ace_task_mgr to coordinate ACE traffic flow   **/
	FIN (gna_clsvr_mgr_ace_tiers_register ());
	
	/* Get the list of ACE tiers for which this node is registered */
	registered_tiers_lptr = gna_clsvr_mgr_ace_tiers_get ();

	/* Enter the tierinformation in the global list */
	gna_clsvr_mgr_network_ace_tier_list_insert (registered_tiers_lptr);
	
	/* Free memory for the registered_tiers_lptr since we no longer need it */
	gna_ace_reg_tiers_list_free (registered_tiers_lptr);
	
	FOUT;
	
	}/* End gna_clsvr_mgr_ace_tiers_register () */


static void
gna_ace_reg_tiers_list_free (List* registered_tiers_lptr)
	{
	int								num_reg_tiers;
	GnaT_Ace_Tier_Config*			tier_config_ptr;
	int								i;
	
	/* This function frees the list of registered tiers */
	FIN(gna_ace_reg_tiers_list_free ());
	
	/* Get the number of registered tiers */
	num_reg_tiers = op_prg_list_size (registered_tiers_lptr);
	
	/* Loop thru each member and free its memory     */
	/* Note that we shpuld not free the char* memory */
	/* of the tier name member                       */
	for (i = num_reg_tiers ; i < 0; i--)
		{
		/* Get the tier config info */
		tier_config_ptr = (GnaT_Ace_Tier_Config *) op_prg_list_remove (registered_tiers_lptr, i);
		
		/* Free its memory */
		op_prg_mem_free (tier_config_ptr);
		}
	
	/* Free the list */
	op_prg_list_free (registered_tiers_lptr);
	
	FOUT;
	}/* End gna_ace_reg_tiers_list_free () */ 


static Compcode
gna_clsvr_mgr_network_ace_tier_list_insert (List* registered_tiers_lptr)
	{
	int								num_reg_tiers;
	int								num_network_reg_tiers;
	int								i;
	char*							tier_name;
	GnaT_Ace_Network_Tier_Info*		tier_info_ptr;
	GnaT_Ace_Node_Info*      		node_info_ptr;
	GnaT_Ace_Tier_Config*			tier_config_ptr;

	/* This function inserts the information about the tiers for */
	/* which this node is registered into a global list 		 */
	FIN(gna_clsvr_mgr_ace_tier_list_insert ());
	
	/* Get the number of registered tiers */
	num_reg_tiers = op_prg_list_size (registered_tiers_lptr);
	
	/* Enter each tier for which this node is registerd in the global list */
	for (i =0 ; i < num_reg_tiers; i++)
		{
		/* Get the tier config info */
		tier_config_ptr = (GnaT_Ace_Tier_Config *) op_prg_list_access (registered_tiers_lptr, i);
		
		/* Get the DS in the global list which stores info for this tier */
		tier_info_ptr = gna_clsvr_mgr_network_ace_tier_get (tier_config_ptr->tier_name);
	
		if (tier_info_ptr == OPC_NIL)
			{
			/* This is the first time this tier is detected in the network */
			/* Create a new DS to store the info						   */
			tier_info_ptr = (GnaT_Ace_Network_Tier_Info *) op_prg_mem_alloc (sizeof (GnaT_Ace_Network_Tier_Info));
			tier_info_ptr->clsvr_hndl_lptr = op_prg_list_create ();
			
			/* Set the tier name of the DS */
			strcpy (tier_info_ptr->tier_name, tier_config_ptr->tier_name);
			
			op_prg_list_insert (network_ace_tiers_lptr, tier_info_ptr, OPC_LISTPOS_TAIL);  
			}
		
		/* Alloc memory to store this node in the tier info */
		node_info_ptr = (GnaT_Ace_Node_Info *) op_prg_mem_alloc (sizeof (GnaT_Ace_Node_Info));
		
		/* Set its process hndl and addr to point to this process on this node */
		node_info_ptr->clsvr_hndl = op_pro_self ();
		node_info_ptr->node_addr = my_node_addr;
		node_info_ptr->popularity = tier_config_ptr->popularity;
		node_info_ptr->app_module_id = my_objid;
		node_info_ptr->cpu_resource_handle = cpu_resource_hndl;
			
		op_prg_list_insert (tier_info_ptr->clsvr_hndl_lptr, node_info_ptr, OPC_LISTPOS_TAIL);
		}
	
	FRET(OPC_COMPCODE_SUCCESS);
	}/* End gna_clsvr_mgr_ace_tier_list_insert () */

static GnaT_Ace_Network_Tier_Info*
gna_clsvr_mgr_network_ace_tier_get (char* tier_name)
	{
	int								num_network_reg_tiers;
	int								i;
	GnaT_Ace_Network_Tier_Info*		tier_info_ptr;
	
	/* This function locates the DS in the global list which */
	/* contains info about a particular tier 				 */
	FIN (gna_clsvr_mgr_network_ace_tier_get());
	
	num_network_reg_tiers = op_prg_list_size (network_ace_tiers_lptr);
	
	for (i=0; i < num_network_reg_tiers; i++)
		{
		tier_info_ptr = (GnaT_Ace_Network_Tier_Info *) op_prg_list_access (network_ace_tiers_lptr, i);
		
		if (strcmp(tier_info_ptr->tier_name, tier_name) == 0)
			FRET (tier_info_ptr);
		}
	
	FRET(OPC_NIL)
	}/* End gna_clsvr_mgr_network_ace_tier_get () */


static List*
gna_clsvr_mgr_ace_tiers_get ()
	{
	List*					registered_tiers_lptr;
	Objid					tier_info_objid;
	int						atc_tier_info_count;
	int					   	i_th_tier_info;
	Objid				   	i_th_tier_info_objid;
	char					tier_name_tmp [256];
	GnaT_Ace_Tier_Config*	tier_config_ptr;
	
	/** This function parses the ACE Tier Configuration attribute     **/
	/** and creates a list of tiers for which this node is registered **/
	FIN(gna_clsvr_mgr_ace_tiers_get ());
	
	registered_tiers_lptr = op_prg_list_create ();
		
	/* Obtain the object identifier of the compound attribute 	*/
	/* ("ACE Tier Configuration") used for specifiying the		*/
	/* different tiers this node represents.					*/
	op_ima_obj_attr_get (my_objid, "ACE Tier Configuration", &tier_info_objid);
	
	/* Obtain the number of tiers this node is configured to	*/
	/* represent.												*/
	atc_tier_info_count = op_topo_child_count (tier_info_objid, OPC_OBJTYPE_GENERIC);

	/* Loop through all the tier specifications.	*/
	for (i_th_tier_info = 0; i_th_tier_info < atc_tier_info_count; i_th_tier_info++)
		{
		/* Alloc memory to store info about this tier config */
		tier_config_ptr = (GnaT_Ace_Tier_Config *) op_prg_mem_alloc (sizeof (GnaT_Ace_Tier_Config));
			
		/* Access the i_th tier specification.		*/
		i_th_tier_info_objid = op_topo_child (tier_info_objid, OPC_OBJTYPE_GENERIC, i_th_tier_info);
			
		/* Obtain the tier name.	*/
		op_ima_obj_attr_get (i_th_tier_info_objid, "Tier Name", tier_name_tmp);
		
		/* Alloc memory to store the tier name */
		tier_config_ptr->tier_name = (char *) op_prg_mem_alloc (strlen(tier_name_tmp) + 1);
		
		/* Store the tier name */
		strcpy(tier_config_ptr->tier_name, tier_name_tmp);
		
		/* Obtain the Popularity */
		op_ima_obj_attr_get (i_th_tier_info_objid, "Popularity", &(tier_config_ptr->popularity));
		
		prg_list_insert(registered_tiers_lptr, tier_config_ptr, OPC_LISTPOS_TAIL);
		
		}
	
	FRET(registered_tiers_lptr);
	
	} /* End gna_clsvr_mgr_ace_tiers_get () */

static GnaT_Ace_Dest_Prefs*
gna_clsvr_mgr_dest_prefs_get ()
	{
	GnaT_Ace_Dest_Prefs*			dest_prefs_ptr;
	Objid							dest_prefs_objid;
	Objid							ith_dest_pref_objid;
	int								dest_prefs_count;
	int								i;
	GnaT_Ace_Dest_Prefs_Info*	   	dest_pref_info_ptr;
	char							dest_pref_tier_name_tmp [256];
	
	/** This function parses the Destination Preferences attribute  **/
	/** and creates a list of dest prefs for this node 				**/
	FIN(gna_clsvr_mgr_dest_prefs_get ());
	
	/* Alloc memory to store the dest prefs */
	dest_prefs_ptr = (GnaT_Ace_Dest_Prefs *) op_prg_mem_alloc (sizeof (GnaT_Ace_Dest_Prefs));
	
	/* Mark it as unsanitized which means that we have not yet confirmed       */
	/* that these dest prefs are pointing to nodes that actually support this  */
	/* ace tier. Sanitization is done the first time this node is chosen to    */
	/* represent a particular tier by the ACE application                      */
	dest_prefs_ptr->sanitized = OPC_FALSE;
		
	/* Create a list to store the individual dest prefs for various tiers */
    dest_prefs_ptr->dest_prefs_info_lptr = op_prg_list_create ();
		
	/* Obtain the object identifier of the compound attribute ("Destination Preferences") */
	op_ima_obj_attr_get (my_objid, "Destination Preferences", &dest_prefs_objid);
	
	/* Obtain the number of dest prefs for this node 	*/
	dest_prefs_count = op_topo_child_count (dest_prefs_objid, OPC_OBJTYPE_GENERIC);
	
	/* Loop through all the dest prefs.	*/
	for (i = 0; i < dest_prefs_count ; i++)
		{
		/* Access the i_th dest specification.		*/
		ith_dest_pref_objid = op_topo_child (dest_prefs_objid, OPC_OBJTYPE_GENERIC, i);
			
		/* Obtain the tier name.	*/
		op_ima_obj_attr_get (ith_dest_pref_objid, "Symbolic Name", dest_pref_tier_name_tmp);
		
		/* Alloc memory to store this dest pref */
		dest_pref_info_ptr = (GnaT_Ace_Dest_Prefs_Info *) op_prg_mem_alloc (sizeof (GnaT_Ace_Dest_Prefs_Info));
		
		/* Alloc memory to store the dest pref tier name */
		dest_pref_info_ptr->dest_tier_name = (char *) op_prg_mem_alloc ((strlen (dest_pref_tier_name_tmp) + 1) * sizeof (char));
		
		/* Set it */
		strcpy(dest_pref_info_ptr->dest_tier_name, dest_pref_tier_name_tmp);
		
        /* Obtain the destination addresses for this dest tier name */
		dest_pref_info_ptr->dest_addr_lptr = gna_clsvr_mgr_dest_addrs_get (ith_dest_pref_objid);
		
		/* Insert it in the list of dest prefs */ 
		op_prg_list_insert(dest_prefs_ptr->dest_prefs_info_lptr, dest_pref_info_ptr, OPC_LISTPOS_TAIL);
		
		}
	
	FRET(dest_prefs_ptr);
	
	} /* End gna_clsvr_mgr_dest_prefs_get () */

static List*
gna_clsvr_mgr_dest_addrs_get (Objid dest_pref_objid)
	{
	List*							dest_addrs_lptr;
	Objid							dest_addrs_objid;
	Objid							ith_dest_addr_objid;
	int								dest_addrs_count;
	int								i;
	GnaT_Ace_Dest_Pref_Addr*	   	dest_pref_addr_ptr;
	char							dest_node_addr_tmp [256];
	
	/** This function parses the Destination Preferences attribute  **/
	/** and creates a list of dest prefs for this node 				**/
	FIN(gna_clsvr_mgr_dest_addrs_get ());
	
	dest_addrs_lptr = op_prg_list_create ();
		
	/* Obtain the object identifier of the compound attribute ("Actual Name") */
	op_ima_obj_attr_get (dest_pref_objid, "Actual Name", &dest_addrs_objid);
	
	/* Obtain the number of dest addrs for this dest pref	*/
	dest_addrs_count = op_topo_child_count (dest_addrs_objid, OPC_OBJTYPE_GENERIC);
	
	/* Loop through all the dest prefs.	*/
	for (i = 0; i < dest_addrs_count ; i++)
		{
		/* Access the i_th dest specification.		*/
		ith_dest_addr_objid = op_topo_child (dest_addrs_objid, OPC_OBJTYPE_GENERIC, i);
			
		/* Obtain the addr.	*/
		op_ima_obj_attr_get (ith_dest_addr_objid, "Name", dest_node_addr_tmp);
		
		/* Alloc memory to store this dest addr */
		dest_pref_addr_ptr = (GnaT_Ace_Dest_Pref_Addr *) op_prg_mem_alloc (sizeof (GnaT_Ace_Dest_Pref_Addr));
		
		/* Alloc memory to store the dest pref tier name */
		dest_pref_addr_ptr->dest_node_addr = (char *) op_prg_mem_alloc ((strlen (dest_node_addr_tmp) + 1) * sizeof (char));
		
		/* Set it */
		strcpy(dest_pref_addr_ptr->dest_node_addr, dest_node_addr_tmp);
		
		/* Obtain the selection weight of this address.	*/
		op_ima_obj_attr_get (ith_dest_addr_objid, "Selection Weight", &(dest_pref_addr_ptr->selection_weight));
		
		/* Insert it in the list of dest prefs */ 
		op_prg_list_insert(dest_addrs_lptr, dest_pref_addr_ptr, OPC_LISTPOS_TAIL);
		
		}
	
	FRET(dest_addrs_lptr);
	
	} /* End gna_clsvr_mgr_dest_addrs_get () */

static int
gna_ace_listening_port_select ()
	{
	int*		new_port_ptr;
	int*		in_use_port_ptr;
	int			num_ports_in_use;
	Boolean		port_in_use;
	int			i;
	
	/* This function selects a unique port for the */
	/* ACE client process to listen on             */
	FIN(gna_ace_listening_port_select ());
	
	/* Alloc memory to store the chosen port number */
    new_port_ptr = (int *) op_prg_mem_alloc (sizeof (int));
	
	/* Assign the base ACE port */
	*new_port_ptr = GnaC_ACE_Passive_Port;
	
	/** Check if this port is in use, if so increment it by 1 and check again **/
	
	/* Get the number of ports currently in use */
	num_ports_in_use = op_prg_list_size (ace_ports_in_use_lptr);
	
	/* Initialize marker */
	port_in_use = OPC_TRUE;
	while (port_in_use)
		{
	    /* Loop thru the list of ports in use */ 	
		for (i =0; i < num_ports_in_use; i++)
			{
			/* Get a port in use */
			in_use_port_ptr = (int *) op_prg_list_access (ace_ports_in_use_lptr, i);
			
			/* Check if this is the one we are trying to use */
			if ( *new_port_ptr == *in_use_port_ptr)
				{
				/* Increment the new port */
			    *new_port_ptr = *new_port_ptr + 1;
				
				/* Break out of the loop */
				break;
				}
			}
		
		if ( i == num_ports_in_use)
			/* new port is not already in use */
			port_in_use = OPC_FALSE;
		}
		
	/* Insert the new port in the list of ports in use */
	op_prg_list_insert (ace_ports_in_use_lptr, new_port_ptr, OPC_LISTPOS_TAIL);
	
	FRET(*new_port_ptr);
	}/* End gna_ace_listening_port_select ()*/


/** ACE trace functions **/
static void
gna_ace_cli_spawn_trace_print(Ici* gna_ace_conn_open_req_ici_ptr)
	{
	Prohandle*					ace_task_mgr_hndl_ptr;
	GnaT_Ace_Conn_Info* 		ace_conn_info_ptr;
	GnaT_Ace_Action_Handle* 	gna_ace_action_hndl_ptr;
	int							next_proc_step;
	
	FIN(gna_ace_cli_spawn_trace_print());
	
	op_ici_attr_get (gna_ace_conn_open_req_ici_ptr, "task_mgr_hndl_ptr", &ace_task_mgr_hndl_ptr);
	op_ici_attr_get (gna_ace_conn_open_req_ici_ptr, "conn_info_ptr", &ace_conn_info_ptr);
	op_ici_attr_get (gna_ace_conn_open_req_ici_ptr, "next_proc_step", &next_proc_step);
	op_ici_attr_get (gna_ace_conn_open_req_ici_ptr, "gna_ace_action_hndl_ptr", &gna_ace_action_hndl_ptr);

	printf("\n\n ------ ACE TRACE -------\n");
	printf(" *ACE Task Client spawned* \n");
	printf(" Current Simulation Time: %f\n", op_sim_time ());
	printf(" ACE Task Mgr Proc ID: %d\n", op_pro_id (*ace_task_mgr_hndl_ptr));

	if (next_proc_step ==1)
		printf(" ACE Task Cli Proc ID: %d\n", op_pro_id (ace_conn_info_ptr->src_cli_hndl));
	else if (next_proc_step ==2)
		printf(" ACE Task Cli Proc ID: %d\n", op_pro_id (ace_conn_info_ptr->dest_cli_hndl));
		
	printf(" Clsvr Mgr Proc ID: %d\n", op_pro_id (my_prohandle));
	printf(" Action ID: %d\n", gna_ace_action_hndl_ptr->action_id);
	printf(" -------------------------\n");
	
	FOUT;
	}/* End gna_ace_cli_spawn_trace_print() */

			
/***** Process a close command from the client	*****/

static void
gna_custom_nam_mgr_notify (Prohandle source_prohandle, int task_index, int phase_index, int mgr_command)
	{
	Ici*						mgr_ici_ptr;
	  
	/* This function installs an ici with a proper command */
	/* and schedules a process interrupt at the manager.	 */
	FIN (gna_custom_nam_mgr_notify ());
	
	/* Check for validity of the source */
	if (op_pro_valid (source_prohandle))
		{
		/* Install ici forthe manager invocation */
		mgr_ici_ptr = op_ici_create ("gna_custom_cli_info");
		if (op_ici_attr_set (mgr_ici_ptr, "task_index", task_index)  == OPC_COMPCODE_FAILURE ||
			op_ici_attr_set (mgr_ici_ptr, "phase_index", phase_index)  == OPC_COMPCODE_FAILURE)			
			{
			gna_clsvr_mgr_error ("Unable to set up ICI.");
			}
	
		/* Tell the manager that the head page was processed */
		op_ici_install (mgr_ici_ptr);
		op_intrpt_schedule_process (source_prohandle, current_sim_time, mgr_command);
		op_ici_install (OPC_NIL);
		}
	
	FOUT;
	}

static void
gna_clsvr_mgr_process_close (Packet* pk_ptr, GnaT_Serv_Session* sess_ptr)
	{
	GnaT_Application_Type	app_type;

	/** This function processes a close cammand that was sent 	**/
	/** by the client.  It will forward a close comamnd to TPAL	**/
	/** to close the session and connection.					**/
	FIN (gna_clsvr_mgr_process_close (pk_ptr, sess_ptr));
	
	/* Set the flag indicating that the close command for the   */
	/* current session has been received. This will help in     */
	/* preventing the sending of CLOSE confirm when there are   */
	/* jobs scheduled in server queue for the current session.  */
	sess_ptr->appl_close_rcvd = OPC_TRUE;

	/* Get the application type from the gna packet				*/
	if (op_pk_fd_get (pk_ptr, 0, &app_type) == OPC_COMPCODE_FAILURE)
		gna_clsvr_mgr_error ("Unable to get service type field from received packet");

	/* It's unusual for a client to send data after a command.		*/
	/*  It may be harmless, but a bug for the default GNA client.	*/
	/* Set an optional breakpoint for this unusual event.			*/
	if (sess_ptr->cmd_issued)
		op_prg_odb_bkpt ("net_app_serv.data-after-command");

	/* If service type is not a valid one issue an error.			*/	
	if (app_type > (NASC_NUM_APPS - 1))
		gna_clsvr_mgr_error ("Invalid service type carried by received packet.");
        
	/* We choose not to model the service time for the CLOSE packet by itself.	*/
	/* It depends upon the sending client application to specify how CLOSE is	*/	
	/* explicitly send a "1 byte" close command packet.							*/
	
	/* Destroy the previous packet so that the system does not run out of memory 	*/
	op_pk_destroy (pk_ptr);
	
	/* Install the session ICI as the close confimation packet has to be sent		*/
	op_ici_install (sess_ptr->ici_ptr);

	/* Send a close confirmation packet to the client node which initiated it.		*/
	pk_ptr = op_pk_create_fmt ("gna");

	/* Close Confirm packet has been set to a minimum size of 64 bits as some lower	*/
	/* layers like TCP require a minimum of 8 bytes segment to transmit data.		*/
	op_pk_total_size_set (pk_ptr, 64);
	op_pk_nfd_set (pk_ptr, "command", TPALC_CMD_CLOSE_CONFIRM);
	
	/* As all the information has been added to the packet, send it to TPAL			 */
	op_pk_send_forced (pk_ptr, 0);
	
	FOUT;
	}


static GnaT_Cli_Mgr_Session*
gna_clsvr_mgr_cache_connection_check (int server_index)
	{
	Key_Desc*					key_info_ptr = OPC_NIL;
	int							key_list_size;
	int							key_index;
	List*						server_sessions_lptr;
	GnaT_Cli_Mgr_Session*		return_sess_ptr = OPC_NIL;	
	Boolean						Connection_Found = OPC_FALSE;
	char						msg1 [256];

	/* This function should search for a connection already */
	/* open to a server with a given name. 				   */
	/* It returns a session pointer for the gna_http_cli which    */
	/* has a TCP connection open to the server.			   */
	FIN (gna_clsvr_mgr_cache_connection_check (server_index));
	
	/* Check if any connections are open to this server */
	server_sessions_lptr = server_info_array_ptr [server_index]->server_session_lptr;	
	  
	if (server_sessions_lptr != OPC_NIL)
		{
		key_list_size = op_prg_list_size (server_sessions_lptr);
		
		for (key_index = 0; key_index < key_list_size; key_index++)
			{
			/* Get the key from the list of keys of sessions open to this server */		
			key_info_ptr = (Key_Desc *) op_prg_list_access (server_sessions_lptr, key_index);
			return_sess_ptr = (GnaT_Cli_Mgr_Session *) oms_dt_item_info_get (session_record_handle, key_info_ptr->session_key);	
			break;				
			}
		}
	FRET (return_sess_ptr);		
	}	
	

/***** Contact the origin server to get the required data     	*****/
static void
gna_clsvr_mgr_cache_contact_server (Packet* pk_ptr, GnaT_Serv_Session* sess_ptr)
	{
	char*					temp_str;
	int						i;
	int						server_index;
	GnaT_Cli_Mgr_Session*	http_sess_ptr;
	Queued_Object_Desc*		inline_object_ptr;
	int						mgr_command;
	int						cli_command;
	GnaT_Nam_Appl*			temp_appl_info_ptr;
	GnaT_Pending_Job*		pend_job_ptr;
	double					req_size;
	
	/** This function will contact the specified server for the		**/
	/** request data contained in the request packet.				**/
	FIN (gna_clsvr_mgr_cache_contact_server (pk_ptr));
	
	op_pk_nfd_access (pk_ptr, "dest server name", &temp_str);
	server_index = gna_clsvr_mgr_cache_find_server_index (servers_lptr, temp_str);
	
	http_version = HTTP11;
	cli_command =  HTTP_RTRV;
	
	/* Check if connection is already open to that server */
	http_sess_ptr = gna_clsvr_mgr_cache_connection_check (server_index);	
	
	/* In case, there is a session already open and we don't want */
	/* to open another one, stop.								  */
	if ((http_sess_ptr != OPC_NIL) && (sess_ptr == OPC_NIL))
		FOUT;
	
	/* Connection is not opened, open new connection */
	if (http_sess_ptr == OPC_NIL)
		{
		mgr_command = NEW_CONNECTION;	
		}
	else		
		{
		/* Reuse old connection */
		mgr_command = REUSE_CONNECTION;
		}
		
	/* Get application info 										*/
	op_pk_nfd_access (pk_ptr, "application_info", &temp_appl_info_ptr);
	
	if (sess_ptr != OPC_NIL)
		{		
		/* Get request size */
		req_size = op_pk_total_size_get (pk_ptr);
	
		/* Set packet info 												*/
		inline_object_ptr = (Queued_Object_Desc*) op_prg_mem_alloc (sizeof (Queued_Object_Desc));
		op_pk_nfd_access (pk_ptr, "response size", &inline_object_ptr->size);
		inline_object_ptr->number_of_objects = 1;
	
		/* Insert the object in the server inline object list 			*/
		op_prg_list_insert (server_info_array_ptr [server_index]->send_objects_lptr, inline_object_ptr, OPC_LISTPOS_TAIL);			
	
		/* Create a pending job element and insert it into the pending 	*/
		/* jobs pending jobs list so that we can process it later.	   	*/
		pend_job_ptr = (GnaT_Pending_Job *) op_prg_mem_alloc (sizeof (GnaT_Pending_Job));
		pend_job_ptr->req_pk = pk_ptr;
		pend_job_ptr->sess_ptr = sess_ptr;
		pend_job_ptr->pkt_id = op_pk_id (pk_ptr);
		op_prg_list_insert (pending_job_lptr, pend_job_ptr, OPC_LISTPOS_TAIL);
					
		/* Establish a session to the local server 						*/
		gna_clsvr_mgr_cache_spawn_session (http_sess_ptr, mgr_command, server_index, cli_command, 
			server_info_array_ptr [server_index]->send_objects_lptr, req_size, temp_appl_info_ptr, pend_job_ptr->pkt_id);				
		}
	else
		{
		/* Open a new session */
		gna_clsvr_mgr_cache_spawn_session (http_sess_ptr, mgr_command, server_index, cli_command, 
										   OPC_NIL, 0, temp_appl_info_ptr, 0);
		}
	
	FOUT;
	}

static void
gna_clsvr_mgr_cache_spawn_session (GnaT_Cli_Mgr_Session* sess_ptr, int sess_command, int server_index,
							int http_command, List* inline_objects_list, double req_size, 
							GnaT_Nam_Appl*	appl_info_ptr, int pkt_id)
	{
	GnaT_Cli_Http_Params*		http_cli_params_ptr;
	Key_Desc*					key_info_ptr;
	int							signal_command = HTTP_NO_SIGNAL;
	int							send_pkts;
	int							max_connections;
	Queued_Object_Desc*			queued_object_ptr = OPC_NIL;
	char						msg1 [256];
	int							number_of_inline_objects;
	int							number_of_queued_objects;
	int							object_count;
	int							number_of_send_objects;
	List*						send_lptr;
	GnaT_Http_Request*			http_req_ptr;
	
	/** This function opens a client TCP  session. If the session pointer 	**/
	/** is NIL, then a new session is started, otherwise the session		**/
	/** is reused.														 	**/
	FIN (gna_clsvr_mgr_cache_spawn_session (sess_ptr, sess_command, server_index, 
							http_command, inline_objects_list, req_size, GnaT_Nam_Appl*  appl_info_ptr));
	   		 
	/* Create a structure which contains info about the http session */
	http_cli_params_ptr = (GnaT_Cli_Http_Params*) op_prg_mem_alloc (sizeof (GnaT_Cli_Http_Params));		
	
	/* No connections to this server are established as of now */
	/* Open a new connection now.  							  */
	if ((sess_command == NEW_CONNECTION) || (sess_ptr == OPC_NIL))
		{
		/* Create a session record for the client*/
		sess_ptr = (GnaT_Cli_Mgr_Session *) op_prg_mem_alloc (sizeof (GnaT_Cli_Mgr_Session));
		sess_ptr->prohndl = op_pro_create ("gna_http_cli", OPC_NIL);
		sess_ptr->sess_type = GNAC_SESSION_TYPE_ACTIVE;
		sess_ptr->objects_queued_lptr = op_prg_list_create ();
		key_info_ptr = (Key_Desc*) op_prg_mem_alloc (sizeof (Key_Desc));
	
		/* Insert the record in the session record handle */
		http_cli_params_ptr->sess_key = oms_dt_item_insert (session_record_handle, sess_ptr);			
   	
		key_info_ptr->session_key = http_cli_params_ptr->sess_key;
		http_cli_params_ptr->sess_handle = session_record_handle;
		http_cli_params_ptr->mgr_prohndle = op_pro_self ();
	
		/* Insert the key in the server key array */
		op_prg_list_insert (server_info_array_ptr [server_index]->server_session_lptr, 
						key_info_ptr, OPC_LISTPOS_TAIL);								    
		}
	
	/* Inform manager about received packets */
	signal_command = HTTP_SIGNAL_CACHE;				   

	if (inline_objects_list != OPC_NIL)
		{	
		/* Send request to the server */
		/* Create a list of object sizes which will be passed to the http client */		 
		send_lptr = op_prg_list_create ();
		
		/* Recalculate the size of the send list */
		number_of_send_objects = op_prg_list_size (inline_objects_list);
		
		/* Construct inline send list for the http client */
		for (object_count = 0; object_count < number_of_send_objects; object_count++)
			{
			/* Allocate memory for size entry */
			http_req_ptr = (GnaT_Http_Request*) op_prg_mem_alloc (sizeof (GnaT_Http_Request));
			
			/* Get object info */
			queued_object_ptr = (Queued_Object_Desc*) op_prg_list_remove (inline_objects_list, OPC_LISTPOS_HEAD);
			
			/* Set object size */
			http_req_ptr->size = queued_object_ptr->size;			   
			strcpy (http_req_ptr->group_name, "Not Used For Stats");
			
			/* Insert object is the send list */
			op_prg_list_insert (send_lptr, http_req_ptr, OPC_LISTPOS_TAIL);
			
			/* Free memory */
			op_prg_mem_free (queued_object_ptr);
			}		
			
		/* Reinitialize the list, just in case.. */
		op_prg_list_init (inline_objects_list);
		
		http_cli_params_ptr->packet_sizes_lptr = send_lptr;		
		http_cli_params_ptr->exp_req_size = req_size;
		http_cli_params_ptr->cache_pkt_id = pkt_id;
		}
	else
		{
		http_cli_params_ptr->packet_sizes_lptr = OPC_NIL;
		http_cli_params_ptr->exp_req_size = 0;
		http_cli_params_ptr->cache_pkt_id = 0;
		}
	
	/* Set the name of the server, http type and size */
	http_cli_params_ptr->server_name = (char*) op_prg_mem_copy_create (server_info_array_ptr [server_index]->server_name,
																	sizeof (char) * (strlen (server_info_array_ptr [server_index]->server_name) + 1));
	http_cli_params_ptr->app_info_ptr = appl_info_ptr;
	http_cli_params_ptr->serv_index = server_index;
	http_cli_params_ptr->command = http_command;
	http_cli_params_ptr->signal = signal_command;
	http_cli_params_ptr->end_time = OPC_DBL_INFINITY;

	/* Invoke the http client */
	op_pro_invoke (sess_ptr->prohndl, http_cli_params_ptr);
   	
	FOUT;   	
	}

/***** Find the server index of the intended server 			*****/
static int
gna_clsvr_mgr_cache_find_server_index (List* server_lptr, char* server_name)
	{
	int 							list_size;
	int								index, i;
	char*							temp_server_name;
	Boolean  						Server_Found = OPC_FALSE;
	Server_Status_Desc**			temp_server_info_array_ptr = OPC_NIL;
	char*							new_server_name;
	   
	/** This function parses takes in the tpal name of the server **/
	/** and assigns it an index in the array for direct lookup.   **/
	/** It also makes sure that server names are not specified 	  **/
	/** more than once.											  **/
	FIN (gna_clsvr_mgr_cache_find_server_index (server_lptr, server_name));	   

	/* Search throught the list of specified server names */
	list_size = op_prg_list_size (server_lptr);
	for (i = 0; i < list_size; i++)
		{
		temp_server_name = (char *) op_prg_list_access (server_lptr, i);
		if (!strcmp (temp_server_name, server_name))
			{
			index = i;
			Server_Found = OPC_TRUE;
			break;
			}
		}		
		
	/* The given server name was not specified yet. Allocate additional */
	/* memory for the server info array and insert the server in there.	*/ 
	if (Server_Found == OPC_FALSE)
		{
		new_server_name = (char *) op_prg_mem_alloc (sizeof (char) * (strlen (server_name) + 1));
		strcpy (new_server_name, server_name);
		op_prg_list_insert (server_lptr, new_server_name, OPC_LISTPOS_TAIL);				
		index = op_prg_list_size (server_lptr);
	
		/* If there is more than one server specified so far, copy memory */
		if (index > 1)
			{
			temp_server_info_array_ptr = (Server_Status_Desc**) op_prg_mem_alloc (index * sizeof (Server_Status_Desc*));
			op_prg_mem_copy (server_info_array_ptr, temp_server_info_array_ptr, (index-1)* sizeof (Server_Status_Desc*));
			op_prg_mem_free (server_info_array_ptr);
			server_info_array_ptr = temp_server_info_array_ptr;			
			}
		/* This is the first server entered in the array, */
		/* so let's allocate memory for the array 		  */
		else
			{
			server_info_array_ptr = (Server_Status_Desc**) op_prg_mem_alloc (index * sizeof (Server_Status_Desc*));
			}
			
		/* Set parameters in the server info array */
		server_info_array_ptr [index - 1] =(Server_Status_Desc*) op_prg_mem_alloc (sizeof (Server_Status_Desc)); 
		
		/* Initialize server info */
		server_info_array_ptr [index - 1]->server_name = (char*) op_prg_mem_copy_create (server_name, sizeof (char) *(strlen (server_name)+1));			
		server_info_array_ptr [index - 1]->server_session_lptr = op_prg_list_create ();
		server_info_array_ptr [index - 1]->objects_queued_lptr = op_prg_list_create (); 
		server_info_array_ptr [index - 1]->repeats_left = 0;
		server_info_array_ptr [index - 1]->send_objects_lptr = op_prg_list_create ();
			
		/* Convert from list index to array index */
		index--;
		}
	
	FRET (index);
	}


/***** Update the cache statistics *****/
static void
gna_clsvr_mgr_cache_update_cache_stats ()
	{
	
	/** Update the cache specific statistics.  							**/
	FIN (gna_clsvr_mgr_cache_update_cache_stats ());
		
	op_stat_write (CACHE_HIT_RATE_SH, (double)cache_hits/cache_reqs);
	op_stat_write (CACHE_HIT_RATE_GSH, (double)global_cache_hits/global_cache_reqs);
	
	FOUT;
	}


/***** Calculate whether there was a hit or miss in the cache *****/

static int
gna_clsvr_mgr_cache_data_in_cache ()
	{
	double		dist_outcome;
	
	FIN (gna_clsvr_mgr_cache_data_in_cache ());
	
	if (trace_active)
		op_prg_odb_print_major ("Looking up data in the cache", OPC_NIL);
	
	dist_outcome = op_dist_uniform (100.0);
	
	/* Determine if there has been a cache hit.  If the outcome from a	*/
	/* unifrom ditribution from 0 to 100 is less than or equal to the 	*/
	/* threshold there has been a hit.  This effectively models a		*/
	/* random chance of a hit based on the user inputs.					*/
	if (dist_outcome <= hit_rate_thresh)
		{
		if (trace_active)
			op_prg_odb_print_minor ("Data is present in cache, respond to client", OPC_NIL);
		
		FRET (NASC_CACHE_HIT);
		}
	else
		{
		if (trace_active)
			op_prg_odb_print_minor ("Data is not present in the cache, contact the origin server", OPC_NIL);
		
		FRET (NASC_CACHE_MISS);
		}
	}


/***** Process an in incomming application request *****/
static void
gna_clsvr_mgr_process_request (Packet* pk_ptr, GnaT_Serv_Session* sess_ptr)
	{
	Packet*					response_pk_ptr;
	List*					resp_size_lptr = OPC_NIL;
	Prohandle*				read_in_prohandle_ptr;
	GnaT_Application_Type	app_type;
	GnaT_Job*				job_ptr = OPC_NIL;
	int						recompute = 0;
	int						command;
	int						echo;
	int						response_count;
	int						cur_session_jobs;
	double					response_size;
	double					service_time;
	double					service_overhead;
	double					pk_size;
	double*					temp_size;
	int						type_of_request = GnaC_Unspec;
	int						task_index;
	int						phase_index;
	int						end_marker;
	Boolean					use_cpu_processing_time;
	char*					app_name_ptr;
	GnaT_App_Stat_Info*		app_info_ptr;

	/** Processes the request represented by pk_ptr and	**/
	/** processes it according to information in the pkt**/
	FIN (gna_clsvr_mgr_process_request (pk_ptr, sess_ptr));

	/* Get the size of the segment/packet. Later on, this will be	*/
	/* used update the statistics on bytes received per second.		*/
	pk_size = op_pk_total_size_get (pk_ptr);	
		
	/* Get the application type from the gna packet				*/
	if (op_pk_nfd_get (pk_ptr, "type_of_request", &type_of_request) == OPC_COMPCODE_FAILURE)
		gna_clsvr_mgr_error ("Unable to get type_of_request field from received packet");
	
	/* Get the application type from the gna packet				*/
	if (op_pk_fd_get (pk_ptr, 0, &app_type) == OPC_COMPCODE_FAILURE)
		gna_clsvr_mgr_error ("Unable to get service type field from received packet");
	
	/* Obtain the command sent in the packet. The command contains	*/
	/* information about the type of the packet (Data, Close command*/
	/* or the Close Confirm). This is a deciding factor in the state*/
	/* transitions.													*/
	if (op_pk_nfd_get (pk_ptr, "command",  &command) == OPC_COMPCODE_FAILURE)
		gna_clsvr_mgr_error ("Unable to get command field from received packet.");

	if (command == TPALC_CMD_CLOSE)
        {
        /* Set the flag indicating that the close command for the   */
        /* current session has been received. This will help in     */
        /* preventing the sending of CLOSE confirm when there are   */
        /* jobs scheduled in server queue for the current session.  */
        sess_ptr->appl_close_rcvd = OPC_TRUE;
        }

	/* It's unusual for a client to send data after a command.		*/
	/*  It may be harmless, but a bug for the default GNA client.	*/
	/* Set an optional breakpoint for this unusual event.			*/
	if (sess_ptr->cmd_issued)
		op_prg_odb_bkpt ("net_app_serv.data-after-command");

	/* Get the size of the whole packet in bits to calculate the	*/
	/* time required to service this packet. 						*/
	pk_size = op_pk_total_size_get (pk_ptr);

	/* If service type is not a valid one issue an error.			*/	
	if (app_type > (NASC_NUM_APPS - 1))
		gna_clsvr_mgr_error ("Invalid service type carried by received packet.");

	/* Fetch the response count form the incoming packet to 		*/
	/* determine whether a response needs to be generated or not	*/
	if (op_pk_nfd_get (pk_ptr, "response count", &response_count) == OPC_COMPCODE_FAILURE)
		gna_clsvr_mgr_error ("Unable to get response count field from received packet.");

	/* Fetch the echo required form the incoming packet to 			*/
	/* determine whether a echo needs to be generated or not		*/		
	if (op_pk_nfd_get (pk_ptr, "echo required", &echo) == OPC_COMPCODE_FAILURE)
		gna_clsvr_mgr_error ("Unable to get response count field from received packet.");

	/* If an echo of the request is to be sent, send it as the first*/
	/* first response. Note that the echo is of the same size as the*/
	/* the request packet.											*/ 
	/* If the request requires a response, get the response size	*/        
	/* Make a copy of the request packet thereby retaining the 		*/
	/* the stamp time of the request. This stamp time is later used */
	/* by the client to calculate the response time.				*/
	if (echo)
		{
		/* Create the response packet containing the stamp time of	*/
		/* the original packet. This is done to record the end to	*/
		/* end delay for the packet.								*/
		response_pk_ptr = op_pk_copy (pk_ptr);

		/* Initialize the response size in bits to be equal to the	*/
		/* incoming packet size. Note that the packet size was		*/
		/* calculated.								 				*/
		response_size = pk_size;
		}

	/* An explicit response has to be sent back after modeling the 	*/
	/* service time delay for each packet.							*/
	else if (response_count-- > 0)
		{
		/* Fetch the response count form the incoming packet to 	*/
		/* determine whether a response needs to be generated or not*/
		if (op_pk_nfd_get (pk_ptr, "response size", &response_size) == OPC_COMPCODE_FAILURE)
			gna_clsvr_mgr_error ("Unable to get response infomation field from received packet.");
	
		if (op_pk_nfd_is_set (pk_ptr, "list of sizes"))
			{
			if (op_pk_nfd_access (pk_ptr, "list of sizes", &resp_size_lptr) == OPC_COMPCODE_FAILURE)
			gna_clsvr_mgr_error ("Unable to get response infomation field from received packet.");
			}

		/* Get the size of the responce packet */
		if (resp_size_lptr != OPC_NIL)
			{
			temp_size = (double *) op_prg_list_remove (resp_size_lptr, OPC_LISTPOS_HEAD);	
			response_size = *temp_size * 8.0; 		
			op_prg_mem_free (temp_size);
			}		

		/* Create the response packet containing the stamp time of	*/
		/* the original packet. This is done to record the end to	*/
		/* end delay for the packet.								*/
		response_pk_ptr = op_pk_copy (pk_ptr);

		/* Set the size of the response packet to the response size */
		/* sent by the sender										*/
		op_pk_total_size_set (response_pk_ptr, response_size);
		}
	else
		{
		/* As no Response has to be sent back, the response			*/
		/* packet pointer is marked OPC_NIL							*/
		response_pk_ptr = OPC_NIL;

		/* Set the response size to be equal to zero.				*/
		/* This will make the response time for the close packets	*/
		/* to be equal to zero, as the close packets come with a 	*/
		/* response count of zero. The application that will be		*/
		/* affected is only db_query as it is the only application	*/
		/* that could have a reponse count of zero and would use	*/
		/* the response size to calculate the service comnpletion	*/
		/* time.													*/
		response_size = 0.0;
		}
	
	/* Obtain the jobs in the current server session. This would    */
    /* be useful to decide whether to send the CLOSE confirm if the */
    /* CLOSE CMD is received from the other side and no response is */
    /* required.                                                    */
        
	/* From the job list size obtain the current number of jobs */
	/* for the current server session.                          */
	cur_session_jobs =  op_prg_list_size (&sess_ptr->job_list);
        
	/* We choose not to model the service time for the CLOSE packet by itself.	*/
	/* It depends upon the sending client application to specify how CLOSE is	*/
	/* modeled: 1) using close command as part of the data packet, or 			*/
	/*          2) explicitly send a "1 byte" close command packet.				*/
	if ((response_size == 0 || response_pk_ptr == OPC_NIL) && (pk_size == 8) && (command == TPALC_CMD_CLOSE))
		{
		/* Destroy the previous packet so that the system does not run out of memory 	*/
		op_pk_destroy (pk_ptr);

		/* Close session */
		gna_clsvr_mgr_close_packet_send (sess_ptr);
		}	
	else 			
		{		
		/* Obtain app name from the packet */
		/* Get the application name from the gna packet				*/
		if (op_pk_nfd_access (pk_ptr, "app name", &app_name_ptr) == OPC_COMPCODE_FAILURE)
			gna_clsvr_mgr_error ("Unable to get application name from received packet");
		
		/* Compute service time for the packet */
		service_time = gna_clsvr_mgr_service_time_compute (pk_ptr, app_name_ptr, app_type, 
														   response_size, pk_size, type_of_request,
														   &use_cpu_processing_time);
		
		/* Update the packet count statistics and the byte count 		*/
		/* statistics (based on the packet size).						*/
		gna_clsvr_mgr_stats_update (app_type, app_name_ptr, Bytes_Rcvd, pk_size / 8.0, 0, type_of_request);
		gna_clsvr_mgr_stats_update (app_type, app_name_ptr, Pkts_Rcvd,  0, 0, type_of_request);
				
		/* Schedule a job, only if the packet received was a data packet with no 		*/
		/* command, non zero service tiem and a valid response packet to be generated	*/
		if (((service_time >= 0.0) || (command != 0)) && (response_pk_ptr != OPC_NIL))
			{
			/* Create a new job and add it to the session job list. */
			job_ptr = gna_clsvr_mgr_job_create (app_type, app_name_ptr, type_of_request);
			op_prg_list_insert (&sess_ptr->job_list, job_ptr, OPC_LISTPOS_TAIL);

			/* Fill in the job information which would be required 	*/
			/* by the gna_clsvr_mgr_compl_recompute procedure and at the time	*/
			/* of job completion to generate response of particular	*/
			/* size and with particular command						*/
			job_ptr->service_time 		= service_time;
			job_ptr->resp_count 		= response_count;
			job_ptr->result 			= response_pk_ptr;
			job_ptr->command 			= command;
			job_ptr->duration 			= current_sim_time ;
			job_ptr->cli_sess_id 		= 0;
			job_ptr->type				= NasC_Response_Processing;
			
			/* This is a custom application */
			if (app_type == GnaC_App_Type_Custom_Application)  
				{		   						
				/* Get the end marker for the currently processed phase */
				op_pk_nfd_get (pk_ptr, "end marker", &job_ptr->end_marker);
				
				/* Indicate whether CPU processing time or explicitly specified */
				/* time should be used.											*/
				job_ptr->use_cpu_process_time = use_cpu_processing_time;
				
				/* Check whether a reply about phase completion will be required */
				/* back to the custom manager.									 */
		   		if ((job_ptr->end_marker == GnaC_Dispatch_From_Dest) ||
					(job_ptr->end_marker == GnaC_Arrival_At_Dest ))
			  		{
					/* Obtain task, phase index and manager prohandle of the custom manager */
					op_pk_nfd_get (pk_ptr, 		"task index", 		&job_ptr->task_index);
					op_pk_nfd_get (pk_ptr, 		"phase index", 		&job_ptr->phase_index);
					op_pk_nfd_access (pk_ptr, 	"source prohandle", &read_in_prohandle_ptr);						
					job_ptr->source_prohandle = *read_in_prohandle_ptr;
					}
				
				/* Inform the source about the arrival of the last transaction, if */
				/* it is required.												   */
				if (job_ptr->end_marker == GnaC_Arrival_At_Dest )
				   {
				    gna_custom_nam_mgr_notify (job_ptr->source_prohandle, job_ptr->task_index, job_ptr->phase_index, GnaC_Custom_Remote_Destination);
				   }
				}
			
			/* If the client provided a list with specified sizes for the response */
			/* packets, copy the list into the job structure.					   */
			if (resp_size_lptr != OPC_NIL)
				{
				if (op_prg_list_size (resp_size_lptr) > 0)
					{
					job_ptr->resp_size_lptr = op_prg_list_create ();
					op_prg_list_elems_copy (resp_size_lptr, job_ptr->resp_size_lptr); 					
					}
				}
			else
				{
				job_ptr->resp_size_lptr = OPC_NIL;			
				}
			
			/* Insert the job into the processor	*/	
			job_ptr->job_id = Oms_Resource_Job_Insert (cpu_resource_hndl, op_pro_self (),
									 sess_ptr, job_ptr->service_time );
			}
		else
			{
			/* If the processing time is 0.0 and no response is required, the job is done. */
			op_stat_write (SERV_SERVICE_TIME, 0.0);

			/* Check if the the source needs to be notified */
			if (app_type == GnaC_App_Type_Custom_Application)  
				{
				/* Get the end marker for the currently processed phase */
				op_pk_nfd_get (pk_ptr, "end marker", &end_marker);
				
				/* Obtain task, phase index and manager prohandle of the custom manager */
				op_pk_nfd_get (pk_ptr, 		"task index", 		&task_index);
				op_pk_nfd_get (pk_ptr, 		"phase index", 		&phase_index);
				op_pk_nfd_access (pk_ptr, 	"source prohandle", &read_in_prohandle_ptr);	
				
				if (end_marker == GnaC_Arrival_At_Dest )
					{
					gna_custom_nam_mgr_notify (*read_in_prohandle_ptr, task_index, phase_index, GnaC_Custom_Remote_Destination);
					}
				}
			
			/* Call the function to write the individual application server performance     */
			/* statistics. Here the statistics of concern is the Task Processing Time       */
			gna_clsvr_mgr_stats_update (app_type, app_name_ptr, Task_Proc_Time,  0, current_sim_time, 0); 
			
			
			/* Check whether the session needs to be closed */
			if (command == TPALC_CMD_CLOSE)
				{
				gna_clsvr_mgr_close_packet_send (sess_ptr);
			}
			}
						  
		/* We're done with the request packet; destroy it. 		*/
		op_pk_destroy (pk_ptr);
		}
	
	FOUT;
	}
	
static void
gna_clsvr_mgr_close_packet_send (GnaT_Serv_Session*	  sess_ptr)
	{
	Packet* pk_ptr;

	FIN (gna_clsvr_mgr_close_packet_send (GnaT_Serv_Session*	  sess_ptr));

	/* Install the session ICI as the close confimation packet has to be sent		*/
	op_ici_install (sess_ptr->ici_ptr);

    /* Send a close confirmation packet. */
	pk_ptr = op_pk_create_fmt ("gna");

	op_pk_total_size_set (pk_ptr, 64);
	op_pk_nfd_set (pk_ptr, "command", TPALC_CMD_CLOSE_CONFIRM);

	/* Now send the packet. */
	op_pk_send (pk_ptr, 0);

	/* Reset the application close received flag to prevent     */
	/* 	sending of multiple close confirms.                     */
	sess_ptr->appl_close_rcvd = OPC_FALSE;
	
	FOUT;
	}

static double
gna_clsvr_mgr_service_time_compute (Packet* pk_ptr, char* app_name_ptr, 
									GnaT_Application_Type app_type, double response_size, 
									double pk_size, int type_of_request, Boolean* use_cpu_processing_time)
	{
	GnaT_App_Stat_Info*		app_info_ptr;
	double					service_time = 0.0;
	double					service_overhead = 0.0;
	char*					custom_app_name = OPC_NIL;
	
	/* Computes service time for the application */
	FIN (gna_clsvr_mgr_service_time_compute ());
			
	/* Calculate the time required to service this packet. This is 	*/
	/* the no load service time, i.e., when there are there are no 	*/
	/* pending jobs at the server. In case of Custom 			    */
	/* application service time is explicitly provided in the		*/
	/* transaction profile so the calculations is not required		*/
	/* However, it is possible to specify a special value for 		*/
	/* interresponse delay called "Use Server CPU", which will cause*/
	/* the processing time to be calculated the regular way.		*/
	app_info_ptr =  (GnaT_App_Stat_Info*) prg_string_hash_table_item_get (server_stats_hash_table_ptr, app_name_ptr);
	
	if (app_info_ptr != OPC_NIL)
		{
		/* If this application is custom application, treat service time */
		/* calculation differently.										 */
		if (app_type == GnaC_App_Type_Custom_Application)  
			{
			/* Get explicit delay for this custom app packet */
			op_pk_nfd_get (pk_ptr, "response delay", &service_time);			
			
			/* Check if the special value "Use Server CPU" 	is used 	*/
			/* In this case, we want to use CPU processing time instead	*/
			/* of explicitly specified service time.				   	*/		
			if (service_time < 0)
				{
				service_overhead = op_dist_outcome (app_info_ptr->overhead_distribution);
				service_time = (service_overhead + response_size / (app_info_ptr->processing_speed * 8));
				*use_cpu_processing_time = OPC_TRUE;
				}
			else
				*use_cpu_processing_time = OPC_FALSE;
			}	
		else
			{
			/* Check if this application is using backend custom application */
			/* In this case, service time will be 0.						 */
			
			/* Get the name of the custom app used for this object */
			op_pk_nfd_access (pk_ptr, "custom app name", &custom_app_name);
			
			/* This application is not using back-end custom app */
			if ((custom_app_name == OPC_NIL) ||
				(!strcmp (custom_app_name, "Not Used")))
				{			
				/* This application is not CUSTOM Application */
				/* Proceed calculating normal server response */
				/* times.									  */
				service_overhead = op_dist_outcome (app_info_ptr->overhead_distribution);
			
				if (app_type == GnaC_App_Type_Ftp_Get 											||
					app_type == GnaC_App_Type_Email_Recv 										||
					(app_type == GnaC_App_Type_Database && type_of_request == GnaC_Query)		||
					app_type == GnaC_App_Type_Http )
					{
					service_time = (service_overhead + response_size / (app_info_ptr->processing_speed * 8));
					}		
				else	
					{
				   	service_time = (service_overhead + pk_size / (app_info_ptr->processing_speed * 8));
					}
				}
			else				
				{
				/* This application is using back-end custom app */
				/* No additional delay at the server.			 */
				service_time = 0.0;
				}
			}
		}
   
	FRET (service_time);
	}
	

/************************************************/
/***** Statistic registration functions *********/
/************************************************/

static void
gna_clsvr_mgr_conf_read ()
	{
	GnaT_Service*           serv_ptr;
    Objid                   comp_attr_objid;
    Objid                   prtcl_cattr_id;
    Objid                   trns_ptrcl_attr_id;
    Objid                   service_attr_objid;
    Objid                   sconf_comp_attr_id;
    Objid                   server_conf_objid;
    int                     num_services = 0;
    int                     status;
    double                  popularity;
    double                  overhead;
    char                    protocol [64] = "none";
	int						serv_index;
	char					msg[128];
	List*					server_list_ptr;
	OmsPrT_Server_Entry*	server_entry_ptr;
	char					server_name [128];
	Boolean					trace_is_active, rsvp_status;
	Objid 					multi_task_table_objid;
	Objid					multi_task_row_objid, comp_objid;
	Objid					rsvp_objid, rsvp_list_prof_objid;
	int						table_index;
	Objid					profile_objid;
	char					temp_profile_str [256];
	char*					profile_ptr;
	char					tpal_name [256];
	int						application_index;
	GnaT_ApType				application_name;
	int						number_of_services;
	char					application_name_ptr [255];
	char*					ith_application_name_ptr;
	GnaT_Application_Desc*	application_desc_ptr;
	List*					all_application_names_lptr;
	Boolean					all_services_enabled	= OPC_FALSE;
	int						all_services_row;
	double					p_speed;
	
	FIN (gna_clsvr_mgr_conf_read ());

	/* Check for an ODB trace label. */
	trace_is_active = op_prg_odb_ltrace_active ("gna") || op_prg_odb_ltrace_active ("net_app_serv");

	/* Create a list of OmsPrT_Server_Entry elements.			*/
	server_list_ptr = op_prg_list_create ();

	/* The servers are configured through a compund attribute 	*/
	/* Before reading in the configurations of the different 	*/
	/* services (done in the loop that follows) get the attr id	*/
	/* of the compund compound attribute.						*/
	op_ima_obj_attr_get (my_objid, "Services", &sconf_comp_attr_id);

	/* Get number of services registered in this server.	*/
	number_of_services = op_topo_child_count (sconf_comp_attr_id, OPC_OBJTYPE_GENERIC);

	/* Loop through all services to check whether "All Services" is	*/
	/* defined. If it is, all applications defined in application	*/
	/* configuration objects in the network will be enabled in this	*/
	/* server.														*/
	for (application_index = 0; application_index < number_of_services; application_index++)
		{
		/* Obtain the server configuration compound attribute objid for the ith application. */
		server_conf_objid = op_topo_child (sconf_comp_attr_id, OPC_OBJTYPE_GENERIC, application_index);
		op_ima_obj_attr_get (server_conf_objid, "Name", &application_name_ptr);
		
		/* Check whether "All Services" is configured in server.	*/
		if (strcmp (application_name_ptr, "All Services") == 0)
			{
			/* Get the list of applications defined in all application configuration objects.	*/
			all_application_names_lptr = (List *) oms_data_def_entry_access ("Application Names", "All Services");

			/* Set a flag indicating that all services are enabled.	*/
			all_services_enabled = OPC_TRUE;
			
			/* Get row in which "All Services" is specified in server.	*/
			all_services_row = application_index;
			
			if (all_application_names_lptr != OPC_NIL)
				{
			/* Get the number of services when "All Services" is chosen.	*/
			number_of_services = op_prg_list_size (all_application_names_lptr);
				}
			else
				{
				number_of_services = 0;
				}
			
			break;
			}
		}
	
	/* The Transport protocols are set inside the compound 		*/
	/* attribute "Transport Protocols". The id of this compund  */
	/* attribute is used to get the values of the transport 	*/
	/* protocols for individual applications.					*/
	op_ima_obj_attr_get (my_objid, "Transport Protocol", &trns_ptrcl_attr_id);
	prtcl_cattr_id = op_topo_child (trns_ptrcl_attr_id, OPC_OBJTYPE_GENERIC, 0); 
	
   	/* Before reading Service parameters, read RSVP Reservation parameters - the list of supported profiles.	*/
	rsvp_profile_table_ptr = op_prg_list_create ();
	rsvp_profile_table_ptr = rsvp_app_sup_profile_read (my_objid);

	/* Loop through all the services. */
	for (application_index = 0; application_index < number_of_services; application_index++)
		{
		/* check whether "All Services" is enabled.	*/
		if (all_services_enabled == OPC_TRUE)
			{
			/* Read "All Services" parameters for the first application.	*/
			/* Parameters (Processing speed...) will be the same for all.	*/
			if (application_index == 0)
				{
				/* Obtain the server configuration compound attribute objid for "All Services". */
				server_conf_objid = op_topo_child (sconf_comp_attr_id, OPC_OBJTYPE_GENERIC, all_services_row);
				op_ima_obj_attr_get (server_conf_objid, "Description", &service_attr_objid);
				}
			
			/* Get ith application defined in whole network.	*/
			ith_application_name_ptr = (char *) op_prg_list_access (all_application_names_lptr, application_index);
			strcpy (application_name_ptr, ith_application_name_ptr);
			}
		else
			{
			/* Obtain the server configuration compound attribute objid for the ith application. */
			server_conf_objid = op_topo_child (sconf_comp_attr_id, OPC_OBJTYPE_GENERIC, application_index);
			op_ima_obj_attr_get (server_conf_objid, "Name", &application_name_ptr);
			op_ima_obj_attr_get (server_conf_objid, "Description", &service_attr_objid);
			}
		
		comp_attr_objid	= op_topo_child (service_attr_objid, OPC_OBJTYPE_GENERIC, 0);
		op_ima_obj_attr_get (comp_attr_objid, "Processing Speed", &p_speed);				
		op_ima_obj_attr_get (comp_attr_objid, "Overhead", &overhead);

		/* Get type of application (email, ftp ...) corresponding to symbolic application name.	*/
		application_desc_ptr = (GnaT_Application_Desc *) oms_data_def_entry_access ("Application Descriptions", application_name_ptr);

		/* Get the application type (email, ftp ...) if the symbolic application is defined.	*/		
		if (application_desc_ptr == OPC_NIL)
			{
			application_name = (GnaT_ApType) -1;
			gna_missing_service_log_write (application_name_ptr);
			}
		else
			{
			application_name = application_desc_ptr->application_type;
			}

		switch (application_name)
			{
			case GnaT_ApType_Rlogin:
				{
				serv_index = Rlogin;
		
				/* Use the compound attribute object id to get 		*/
				/* the transport protocol for this application.		*/
				op_ima_obj_attr_get (prtcl_cattr_id, "Remote Login Transport", protocol);

				/* Check if the status of the service in this node	*/
				op_ima_obj_attr_get (comp_attr_objid, "Service Status", &status);
				
				/* If the service is disabled in this node, do not	*/
				/* do read in any other configuration parameters 	*/
				/* for this service.								*/
				if (status == OPC_FALSE)
					continue;

				/* Configure stats for this application */
				gna_clsvr_mgr_stat_initialize ("Remote Login", application_name_ptr, stat_indexes_table [GnaT_ApType_Rlogin], p_speed, overhead);					

				/* Increase stat index */
				stat_indexes_table [GnaT_ApType_Rlogin]++;
				}
				break;


			case GnaT_ApType_Email:
				{
				serv_index = Email;

				/* Use the compound attribute object id to get 		*/
				/* the transport protocol for this application.		*/
				op_ima_obj_attr_get (prtcl_cattr_id, "Email Transport", protocol);

				/* Check if the status of the service in this node	*/
				op_ima_obj_attr_get (comp_attr_objid, "Service Status", &status);
				
				/* If the service is disabled in this node, do not	*/
				/* do read in any other configuration parameters 	*/
				/* for this service.								*/
				if (status == OPC_FALSE)
					continue;

				/* Configure stats for this application */
				gna_clsvr_mgr_stat_initialize ("Email", application_name_ptr, stat_indexes_table [GnaT_ApType_Email], p_speed, overhead);	

				/* Increase stat index */
				stat_indexes_table [GnaT_ApType_Email]++;
				}
				break;

			case GnaT_ApType_Ftp:
				{
				serv_index = Ftp;

				/* Use the compound attribute object id to get 		*/
				/* the transport protocol for this application.		*/
				op_ima_obj_attr_get (prtcl_cattr_id, "Ftp Transport", protocol);

				/* Check if the status of the service in this node	*/
				op_ima_obj_attr_get (comp_attr_objid, "Service Status", &status);
				
				/* If the service is disabled in this node, do not	*/
				/* do read in any other configuration parameters 	*/
				/* for this service.								*/
				if (status == OPC_FALSE)
					continue;

				/* Configure stats for this application */
				gna_clsvr_mgr_stat_initialize ("Ftp", application_name_ptr, stat_indexes_table [GnaT_ApType_Ftp], p_speed, overhead);	
				
				/* Increase stat index */
				stat_indexes_table [GnaT_ApType_Ftp]++;
				}
				break;
			
			case GnaT_ApType_Dbase:
				{
				serv_index = Database;

				/* Use the compound attribute object id to get 		*/
				/* the transport protocol for this application.		*/
				op_ima_obj_attr_get (prtcl_cattr_id, "Database Transport", protocol);

				/* Check if the status of the service in this node	*/
				op_ima_obj_attr_get (comp_attr_objid, "Service Status", &status);
				
				/* If the service is disabled in this node, do not	*/
				/* do read in any other configuration parameters 	*/
				/* for this service.								*/
				if (status == OPC_FALSE)
					continue;

				/* Configure stats for this application */
				gna_clsvr_mgr_stat_initialize ("DB", application_name_ptr, stat_indexes_table [GnaT_ApType_Dbase], p_speed, overhead);					

				/* Increase stat index */
				stat_indexes_table [GnaT_ApType_Dbase]++;				
				}
				break;


			case GnaT_ApType_Custom:
				{
				serv_index = Cust_App;
				
				/* Indicate that statistics for custom application have */
			    /* been selected already.								*/
				custom_stats_registered = OPC_TRUE;

				/* Use the compound attribute object id to get 		*/
				/* the transport protocol for this application.		*/
				op_ima_obj_attr_get (prtcl_cattr_id, "Custom Application Transport", protocol);

				/* Obtain the server configuration compound attribute objid. */
				/*op_ima_obj_attr_get (server_conf_objid, "Custom Application", &service_attr_objid);
				comp_attr_objid	= op_topo_child (service_attr_objid, OPC_OBJTYPE_GENERIC, 0);*/

				/* Check if the status of the service in this node	*/
				op_ima_obj_attr_get (comp_attr_objid, "Service Status", &status);
				
				/* If the service is disabled in this node, do not	*/
				/* do read in any other configuration parameters 	*/
				/* for this service.								*/
				if (status == OPC_FALSE)
					continue;

				/* Configure stats for this application */
				gna_clsvr_mgr_stat_initialize ("Custom Application", application_name_ptr, stat_indexes_table [GnaT_ApType_Custom], p_speed, overhead);

				/* Increase stat index */
				stat_indexes_table [GnaT_ApType_Custom]++;
				}
				break;

			case GnaT_ApType_Http:
				{
				serv_index = Http;

				/* Use the compound attribute object id to get 		*/
				/* the transport protocol for this application.		*/
				op_ima_obj_attr_get (prtcl_cattr_id, "Http Transport", protocol);
				
				/* Check if the status of the service in this node	*/
				op_ima_obj_attr_get (comp_attr_objid, "Service Status", &status);
				
				/* If the service is disabled in this node, do not	*/
				/* do read in any other configuration parameters 	*/
				/* for this service.								*/
				if (status == OPC_FALSE)
					continue;

				/* Configure stats for this application */
				gna_clsvr_mgr_stat_initialize ("Http", application_name_ptr, stat_indexes_table [GnaT_ApType_Http], p_speed, overhead);

				/* Increase stat index */
				stat_indexes_table [GnaT_ApType_Http]++;
				}
				break;

			case GnaT_ApType_Print:
				{
				serv_index = Print;

				/* Use the compound attribute object id to get 		*/
				/* the transport protocol for this application.		*/
				op_ima_obj_attr_get (prtcl_cattr_id, "Print Transport", protocol);

				/* Check if the status of the service in this node	*/
				op_ima_obj_attr_get (comp_attr_objid, "Service Status", &status);
				
				/* If the service is disabled in this node, do not	*/
				/* do read in any other configuration parameters 	*/
				/* for this service.								*/
				if (status == OPC_FALSE)
					continue;

				/* Configure stats for this application */
				gna_clsvr_mgr_stat_initialize ("Print", application_name_ptr, stat_indexes_table [GnaT_ApType_Print], p_speed, overhead);

				/* Increase stat index */
				stat_indexes_table [GnaT_ApType_Print]++;
				}
				break;
				
			case GnaT_ApType_Voice:
				{
				serv_index = Voice;

				/* Use the compound attribute object id to get 		*/
				/* the transport protocol for this application.		*/
				op_ima_obj_attr_get (prtcl_cattr_id, "Voice Transport", protocol);
				
				/* Check the status of the service in this node	*/
				op_ima_obj_attr_get (comp_attr_objid, "Service Status", &status);
				
				/* if the Service Status of Voice has been set to disabled	*/
				/* then dont register the service.							*/
				if (status == OPC_FALSE)
					continue;				
				}
				break;
			
			case GnaT_ApType_Video:
				{
				serv_index = Video;

				/* Use the compound attribute object id to get 		*/
				/* the transport protocol for this application.		*/
				op_ima_obj_attr_get (prtcl_cattr_id, "Video Conferencing Transport", protocol);
				
				/* Check the status of the service in this node	*/
				op_ima_obj_attr_get (comp_attr_objid, "Service Status", &status);
				
				/* if the Service Status of Video has been set to disabled	*/
				/* then dont register the service.							*/
				if (status == OPC_FALSE)
					continue;				
			   	}
				break;				

			default:
				break;
			}
				
		/*	Create entries if the protocol is not set to NONE.	*/
		if ((strcmp (protocol, "none") != 0) && (application_name != -1))
			{
			/* Increment the number of services this server 	*/
			/* supports.										*/
			num_services++;

			/* Create a new service record and add it to the list. */
			serv_ptr = (GnaT_Service*) op_prg_mem_alloc (sizeof (GnaT_Service));
			if (serv_ptr == OPC_NIL)
				gna_clsvr_mgr_error ("Unable to allocate service record.");
			op_prg_list_insert (&serv_list, serv_ptr, OPC_LISTPOS_TAIL);

			/* Allocate space for the application name and copy the name into the client record. */
			serv_ptr->name = (char *) op_prg_mem_alloc (strlen (application_name_ptr) * sizeof (char) + 1);
			strcpy (serv_ptr->name, application_name_ptr);

			/* Allocate space for the protocol name and set the name. */
			serv_ptr->protocol = (char *) op_prg_mem_alloc (strlen (protocol) + 1);
			strcpy (serv_ptr->protocol, protocol);
		
			/* Set a port for each service. */
			serv_ptr->port = serv_index;
				
			/* Get the popularity for each service. */
			if (op_ima_obj_attr_get (comp_attr_objid, "Selection Weight", &popularity) == OPC_COMPCODE_FAILURE)
				gna_clsvr_mgr_error ("Unable to get popularity from attribute.");

			/* Set the popularity. */
			serv_ptr->pop = popularity;

			/* Get the type of service for each service. */
			if (op_ima_obj_attr_get (comp_attr_objid, "Type of Service", 
				&(serv_ptr->type_of_service)) == OPC_COMPCODE_FAILURE)
				{
				gna_clsvr_mgr_error ("Unable to get type of service from attribute.");
				}

			if (application_name != GnaT_ApType_Print)
				{
				/** This application may support RSVP.	**/
				/* Allocate memory for RSVP configuration parameters.	*/
				serv_ptr->rsvp_params_ptr = (GnaT_Rsvp_Config_Params*) op_prg_mem_alloc (sizeof (GnaT_Rsvp_Config_Params));

				serv_ptr->rsvp_params_ptr->profile_list_ptr = rsvp_app_profile_list_from_name_get (rsvp_profile_table_ptr, application_name);
    			}

			/* Allocate memory for specifying service entry record.	*/
			server_entry_ptr = (OmsPrT_Server_Entry*) op_prg_mem_alloc (sizeof (OmsPrT_Server_Entry));

			if (server_entry_ptr == OPC_NIL)
				{
				gna_clsvr_mgr_error ("Unable to allocate memory for Service Record");
				}
	
			/*	Fill in the elements of the server entry data structure.	*/
			/*	Check to make sure the name is unique and less than 48 characters.	*/
			sprintf (server_name, "%d.%s", my_objid, serv_ptr->name);
	
			strcpy (server_entry_ptr->server_name, server_name);
			strcpy (server_entry_ptr->server_protocol, protocol);
			server_entry_ptr->server_type = serv_index;
			server_entry_ptr->server_socket_num = serv_index;
	
			if (strlen (server_name) > 48)
				{
				gna_clsvr_mgr_warn ("Server name is too long for use in `OmsPrT_Server_Entry.");
				op_prg_mem_free (server_entry_ptr);
				}
			else
				{
				op_prg_list_insert (server_list_ptr, server_entry_ptr, OPC_LISTPOS_TAIL);
				if (trace_is_active)
					{
					sprintf (msg, "Added service record: %s", serv_ptr->name);
					op_prg_odb_print_major (msg, OPC_NIL);
					}
				}

			}
		}

	/* If there are any services supported on this server register them the	*/
	/* the process registry.												*/
	if (num_services > 0)
		{
		if (trace_is_active)
			op_prg_odb_print_major ("Registering Server in Process Registry.", OPC_NIL);       					

		oms_pr_attr_set (process_record_handle,
				"Protocol", OMSC_PR_STRING, "server",
				OPC_NIL);

		/* Get tpal name */
		op_ima_obj_attr_get (my_tpal_objid, "Address", tpal_name);

		oms_pr_attr_set (process_record_handle,
				"TPAL Address", OMSC_PR_STRING, tpal_name,
				OPC_NIL);

		oms_pr_attr_set (process_record_handle,
				"Server Registry", OMSC_PR_ADDRESS, server_list_ptr,
				OPC_NIL);
		}

	FOUT;
	}

static void
gna_clsvr_mgr_cache_server_request_check (Packet* pk_ptr, GnaT_Serv_Session* sess_ptr)
	{
	GnaT_Application_Type			app_type;
	
	/* Performs a check on wether cache server request is valid */
	FIN (gna_clsvr_mgr_cache_server_request_check (pk_ptr, sess_ptr));
	
	/* Get the application type from the gna packet				*/
	if (op_pk_fd_get (pk_ptr, 0, &app_type) == OPC_COMPCODE_FAILURE)
			gna_clsvr_mgr_error ("Unable to get service type field from received packet");
		
	/* Since the cache server has ethernet working in the promiscious listening */
	/* mode, it will get packets from all other currently enabled applications	*/
	/* However, caching is only relevant for HTTP applications, so other 		*/
	/* application packets should be destroyed.									*/
	if (app_type == GnaC_App_Type_Http)
		{		
		/* Determine if there was a cache hit or miss based on the	*/
		/* Cache Hit Rate input.									*/
		if (gna_clsvr_mgr_cache_data_in_cache ())
			{
			/* There was a cache hit, process this request normally */
			gna_clsvr_mgr_process_request (pk_ptr, sess_ptr);
				
			/* Update the cache hit counters						*/
			cache_hits++;
			global_cache_hits++;
			}
		else
		   {
		   /* There was a cache miss, contact the origin server 	*/
		   /* for the data											*/
		   /* Spawn a new client session to contact the origin 	*/
		   /* server for the requested data.						*/
		   gna_clsvr_mgr_cache_contact_server (pk_ptr, sess_ptr);
		   
		   /* Update the cache miss counters						*/
		   cache_misses++;
		   global_cache_misses++;
		   }
		cache_reqs++;
		global_cache_reqs++;
		
		/* Update the cache statistics								*/
		gna_clsvr_mgr_cache_update_cache_stats ();
		}
	 else
		 {
		 /* This is not an HTTP application packet, so get rid of it */
		 op_pk_destroy (pk_ptr);
		 }
	FOUT;
	}

static Boolean
gna_clsvr_mgr_indirect_custom_app_check (Packet* pk_ptr, GnaT_Serv_Session* sess_ptr)
	{
	GnaT_Application_Type			app_type;
	char*							custom_app_name = OPC_NIL;
	GnaT_Nam_Appl*					temp_appl_info_ptr = OPC_NIL;
	GnaT_Nam_Appl* 					nam_appl_ptr = OPC_NIL;
	GnaT_Application_Comp*			comp_application_ptr = OPC_NIL;
	Prohandle						custom_mgr_prohandle;
	Boolean							custom_app_req_sent = OPC_FALSE;
	int								incoming_req_id;
	int								hit_rate;
	double							dist_outcome;
	GnaT_Pending_Job*				pend_job_ptr;	
	GnaT_Profile_Desc* 				profile_desc_ptr;
	char							new_profile_name [256];
	GnaT_Application_Desc *			temp_app_desc_ptr = OPC_NIL;
	GnaT_Custom_Desc*				custom_desc_ptr = OPC_NIL;
	GnaT_Phase_Desc*				phase_desc_ptr = OPC_NIL;
	char*							first_phase_source = OPC_NIL;
	int								task_index, task_count;
	static	int						app_index = 0;
	static 	int						cust_app_index =0;
	int*							custom_index_ptr;
	void*							dummy_argument;
	static PrgT_String_Hash_Table*	app_indexes_hash_table_ptr = OPC_NIL;
	
	/* Start custom application on this node as a result of request by */
	/* some other application - http, ftp, email, etc.				   */
	FIN (gna_clsvr_mgr_indirect_custom_app_check (pk_ptr, sess_ptr));
	
	if (app_indexes_hash_table_ptr == OPC_NIL)
		app_indexes_hash_table_ptr = prg_string_hash_table_create (100, 500);
	
	/* Get application type and make sure this is not custom application */
	if (op_pk_fd_get (pk_ptr, 0, &app_type) == OPC_COMPCODE_FAILURE)
			gna_clsvr_mgr_error ("Unable to get service type field from received packet");
	
	if ((app_type != GnaC_App_Type_Custom_Application)&& 
		(op_pk_nfd_is_set (pk_ptr, "custom app name")))
		{	
		/* Get the name of the task used for this object */
		op_pk_nfd_access (pk_ptr, "custom app name", &custom_app_name);
	
		/* Get application info 										*/
		op_pk_nfd_access (pk_ptr, "application_info", &temp_appl_info_ptr);
				
		/* Get execution probability for this application */
		op_pk_nfd_get (pk_ptr, "hit rate", &hit_rate);

		/* Make sure that valid custom app name is specified */
	 	if (strcmp (custom_app_name, "Not Used"))
			{
			/* Get information about application */
			temp_app_desc_ptr = (GnaT_Application_Desc *) 
					oms_data_def_entry_access ("Application Descriptions", custom_app_name);
			
			/* Check whether execution should be scheduled */
			dist_outcome = op_dist_uniform (100.0);
			
			if ((temp_app_desc_ptr != OPC_NIL) &&
				(dist_outcome <= hit_rate))
				{					
				/* Create compound application information */
				comp_application_ptr = (GnaT_Application_Comp *) op_prg_mem_alloc (sizeof (GnaT_Application_Comp));
				comp_application_ptr->application_ptr = temp_app_desc_ptr;
				
				/* Check if new profile needs to be created */
				sprintf (new_profile_name, "BACKEND--%s", custom_app_name); 
				profile_desc_ptr = (GnaT_Profile_Desc*) oms_data_def_entry_access ("Profile Descriptions", new_profile_name);
		
				/* This profile has not been created yet. Create a new profile */
				if (profile_desc_ptr == OPC_NIL)
					{
					profile_desc_ptr = (GnaT_Profile_Desc *) op_prg_mem_alloc (sizeof (GnaT_Profile_Desc));
					profile_desc_ptr->profile_name_ptr = (char *) op_prg_mem_alloc (strlen (new_profile_name) + 1);
					strcpy (profile_desc_ptr->profile_name_ptr, new_profile_name);
					profile_desc_ptr->applications_ptr = (GnaT_Application_Comp **) op_prg_mem_alloc (sizeof (GnaT_Application_Comp *)); 	 
					profile_desc_ptr->applications_ptr [0] =  comp_application_ptr;  
					profile_desc_ptr->appl_row_count = 1;
					oms_data_def_entry_insert ("Profile Descriptions", profile_desc_ptr->profile_name_ptr, profile_desc_ptr);
					}
				
				/* Valid custom app has been specified */
				custom_app_req_sent = OPC_TRUE;		
			
				/* Create a pending job element and insert it into the pending 	*/
				/* jobs pending jobs list so that we can process it later.	   	*/
				pend_job_ptr = (GnaT_Pending_Job *) op_prg_mem_alloc (sizeof (GnaT_Pending_Job));
				pend_job_ptr->req_pk = pk_ptr;
				pend_job_ptr->sess_ptr = sess_ptr;
				incoming_req_id = op_pk_id (pk_ptr);
				pend_job_ptr->pkt_id = incoming_req_id;
				op_prg_list_insert (pending_job_lptr, pend_job_ptr, OPC_LISTPOS_TAIL);
								
				/* Create custom manager */
				custom_mgr_prohandle = op_pro_create ("gna_custom_mgr", OPC_NIL);
		
				/* Allocate memory for the NAM application structure and fill in info */
				nam_appl_ptr = (GnaT_Nam_Appl*) op_prg_mem_alloc (sizeof (GnaT_Nam_Appl));
				nam_appl_ptr->application_comp_ptr      = comp_application_ptr;
				nam_appl_ptr->global_info_ptr           = global_information_ptr;
				nam_appl_ptr->stat_index                = -1;
				nam_appl_ptr->profile_name_ptr          = profile_desc_ptr->profile_name_ptr;
				nam_appl_ptr->wkstn_id                  = -1;
				nam_appl_ptr->lan_handle                = sess_lan_handle;;
				nam_appl_ptr->supported_sources_lptr 	= sources_lptr;
				nam_appl_ptr->application_row_index		= 0;
				nam_appl_ptr->rep_index					= app_index;
				nam_appl_ptr->cpu_resource_handle 		= cpu_resource_hndl;
				nam_appl_ptr->job_table_handle			= job_table_hndl;
				nam_appl_ptr->profile_end_time 			= 100000000;
				nam_appl_ptr->invoked_from_clsvr_mgr	= OPC_TRUE;
				nam_appl_ptr->pkt_id 					= incoming_req_id;
				nam_appl_ptr->supported_sources_lptr 	= op_prg_list_create ();
				
				/* Increment app index */
				app_index++;
				
				/* Set sources for this application */
				custom_desc_ptr = (GnaT_Custom_Desc*) comp_application_ptr->application_ptr->application_desc_ptr;	
				task_count = custom_desc_ptr->task_row_count;
				for (task_index = 0; task_index < task_count; task_index++)
					{
					phase_desc_ptr = (GnaT_Phase_Desc*) custom_desc_ptr->task_desc_ptr[task_index]->phase_desc_ptr [0];					
					first_phase_source = (char*) op_prg_mem_alloc ((strlen (phase_desc_ptr->source_name_ptr) +1) * sizeof (char));
					strcpy (first_phase_source , phase_desc_ptr->source_name_ptr);
					op_prg_list_insert (nam_appl_ptr->supported_sources_lptr, first_phase_source, OPC_LISTPOS_HEAD);
					}
				
				/* Set duration to the end of last task */
				nam_appl_ptr->application_duration 		= -1000;
		
				/* Continue parsing custom application parameters */
				gna_clsvr_mgr_custom_app_prepare (nam_appl_ptr, OPC_TRUE, OPC_FALSE, 0);
				
				/* Get custom application stat index */
				custom_index_ptr = (int*) prg_string_hash_table_item_get (app_indexes_hash_table_ptr, custom_app_name);
				if (custom_index_ptr == OPC_NIL)
					{
					custom_index_ptr = (int*) op_prg_mem_alloc (sizeof (int));					
	 				*custom_index_ptr = cust_app_index;
					cust_app_index++;
					prg_string_hash_table_item_insert (app_indexes_hash_table_ptr, custom_app_name,
													   custom_index_ptr, &dummy_argument);
					}
				
				/* Override stat index */
				nam_appl_ptr->stat_index = *custom_index_ptr;
				
				/* Invoke custom manager */
				op_pro_invoke (custom_mgr_prohandle, nam_appl_ptr);	
				}			
			}
		}
	FRET (custom_app_req_sent);
	}


static void
gna_clsvr_mgr_custom_app_prepare (GnaT_Nam_Appl* nam_appl_ptr, Boolean same_lan_profile, 
								  Boolean remote_invokation, int lan_profile_index)
	{
   	Objid  				   		symbolic_objid = -1;
	char						protocol_name_ptr [255];
   	GnaT_ApType           		type_value;
	GnaT_Application_Desc*  	appl_desc_ptr = OPC_NIL;	   
   	GnaT_Custom_Desc*			cust_appl_ptr = OPC_NIL;
	void*						temp_appl_ptr = OPC_NIL;
	GnaT_Service*				serv_ptr;
	Ici*						ici_ptr;
	OmsPrT_Server_Entry* 		server_entry_ptr = OPC_NIL;	
	char						server_name [128];
	List*						server_list_ptr;
	char						msg[128];
	
	/* Parses custom application parameters on this node */
	/* and opens a passive session if necessary.		 */
	FIN (gna_clsvr_mgr_custom_app_prepare (GnaT_Nam_Appl* nam_appl_ptr, Boolean same_lan_profile, 
								  Boolean remote_invokation, int lan_profile_index));
	
	/* Initialize the hash table used for storing parsed tasks */
	if (global_task_defs_hash_table_ptr == OPC_NIL)
		{
		global_task_defs_hash_table_ptr = prg_string_hash_table_create (100, 500);
		}
				
	/* Get the transport protocol.	*/
	op_ima_obj_attr_get (transport_protocol_objid, "Custom Application Transport", protocol_name_ptr);
	nam_appl_ptr->transport_protocol = (char *) op_prg_mem_alloc (strlen (protocol_name_ptr) * sizeof (char) + 1);
	strcpy (nam_appl_ptr->transport_protocol, protocol_name_ptr);
				
	/* Get the name of the symbolic server */
	appl_desc_ptr = nam_appl_ptr->application_comp_ptr->application_ptr;
	cust_appl_ptr = (GnaT_Custom_Desc *) appl_desc_ptr->application_desc_ptr;
	
	/* Set the ACE task list inbformation.  */
	nam_appl_ptr->custom_ace_task_lptr = gna_clsvr_app_mod_mem_ptr->ace_task_list_ptr;	
	nam_appl_ptr->profile_rep_index	 = lan_profile_index;
			  								
	/* Set statistic index for couple <profile/application>.	*/
	nam_appl_ptr->stat_index = custom_max_stat_index;
				
	/* Parse RSVP parameters.	*/
	nam_appl_ptr->rsvp_parameters_ptr = client_nam_rsvp_params_read (cust_appl_ptr->rsvp_status, 
							cust_appl_ptr->outbound_flow_ptr, cust_appl_ptr->inbound_flow_ptr, GnaC_App_Type_Custom_Application);
				
	/* Keep the same statistic index if the node is a lan.	*/
	if (same_lan_profile == OPC_FALSE)
		{
		custom_max_stat_index += cust_appl_ptr->task_row_count;
		}
	
	if (remote_invokation == OPC_FALSE)
		{		
		/* Make sure stats are not registered twise */
		if (custom_stats_registered == OPC_FALSE)
			{						
			/* Indicate that statistics for custom application have */
			/* been selected already.								*/
			custom_stats_registered = OPC_TRUE;
			
			/* Configure stats for this application */
			gna_clsvr_mgr_stat_initialize ("Custom Application", appl_desc_ptr->application_name_ptr, stat_indexes_table [GnaT_ApType_Custom], 1, 0);
			
			/* Increase stat index */
			stat_indexes_table [GnaT_ApType_Custom]++;
			}
		
		/* Make sure only one passive session is spawned for custom application */
		if (custom_passive_session_registered == OPC_FALSE)
			{
			/* Indicate the the passive session for custom is already registered */
			/* This avoids multiple spawned passive sessions.					 */
			custom_passive_session_registered = OPC_TRUE;						
						
			/* Spawn a passive session for custom application only */
			/* Create an ICI for service registration. */
			ici_ptr = op_ici_create ("tpal_serv_reg");				
			if (ici_ptr == OPC_NIL)
				gna_clsvr_mgr_error ("Unable to create ICI for service registration.");
			
			/* Create a new service record and add it to the list. */
			serv_ptr = (GnaT_Service *) op_prg_mem_alloc (sizeof (GnaT_Service));
			
			/* Allocate space for the application name and copy the name into the client record. */
			serv_ptr->name = (char *) op_prg_mem_alloc (strlen (appl_desc_ptr->application_name_ptr) * sizeof (char) + 1);
			strcpy (serv_ptr->name, appl_desc_ptr->application_name_ptr);
			
			/* Allocate space for the protocol name and set the name. */
			serv_ptr->protocol = (char *) op_prg_mem_alloc (strlen (protocol_name_ptr) + 1);
			strcpy (serv_ptr->protocol, protocol_name_ptr);
			
			/* Set a port for each service. */
			serv_ptr->port = Cust_App;			   
			
			/* Set the popularity. */
			serv_ptr->pop = 10;
			
			/* Allocate memory for specifying service entry record.	*/
			server_entry_ptr = (OmsPrT_Server_Entry *) op_prg_mem_alloc (sizeof (OmsPrT_Server_Entry));
			
			if (server_entry_ptr == OPC_NIL)
				{
				gna_clsvr_mgr_error ("Unable to allocate memory for Service Record");
				}
	
			/*	Fill in the elements of the server entry data structure.	*/
			/*	Check to make sure the name is unique and less than 48 characters.	*/
			sprintf (server_name, "%d.%s", my_objid, serv_ptr->name);
			
			strcpy (server_entry_ptr->server_name, server_name);
			strcpy (server_entry_ptr->server_protocol, protocol_name_ptr);
			server_entry_ptr->server_type = Cust_App;
			server_entry_ptr->server_socket_num = Cust_App;
			
			/* Create a list of OmsPrT_Server_Entry elements.			*/
			server_list_ptr = op_prg_list_create ();
			
			if (strlen (server_name) > 48)
				{
				gna_clsvr_mgr_warn ("Server name is too long for use in `OmsPrT_Server_Entry.");
				op_prg_mem_free (server_entry_ptr);
				}
			else
				{
				op_prg_list_insert (server_list_ptr, server_entry_ptr, OPC_LISTPOS_TAIL);
				if (trace_active)
					{
					sprintf (msg, "Added service record: %s", serv_ptr->name);
					op_prg_odb_print_major (msg, OPC_NIL);
					}
				}
			
			if (trace_active)
				op_prg_odb_print_major ("Registering Passive Custom Application in Process Registry.", OPC_NIL);
			
			
			oms_pr_attr_set (process_record_handle,
				"Protocol", OMSC_PR_STRING, "client",
				OPC_NIL);
			
			oms_pr_attr_set (process_record_handle,
				"TPAL Address", OMSC_PR_STRING, my_tpal_address,
				OPC_NIL);
			
			oms_pr_attr_set (process_record_handle,
				"Server Registry", OMSC_PR_ADDRESS, server_list_ptr,
				OPC_NIL);
			
			/* Set the service parameters. */
			if (op_ici_attr_set (ici_ptr, "Protocol", protocol_name_ptr) == OPC_COMPCODE_FAILURE ||
				op_ici_attr_set (ici_ptr, "Service Name", serv_ptr->name) == OPC_COMPCODE_FAILURE ||
				op_ici_attr_set (ici_ptr, "Port", serv_ptr->port) == OPC_COMPCODE_FAILURE ||
				op_ici_attr_set (ici_ptr, "Popularity", serv_ptr->pop) == OPC_COMPCODE_FAILURE)
				{
				gna_clsvr_mgr_error ("Unable to set ICI attributes for server registration.");
				}
			
			/* Issue the registration command. */
			op_ici_install (ici_ptr);
			op_intrpt_force_remote (TPALC_CMD_SERV_REG, my_tpal_objid);
			
			gna_clsvr_mgr_open (serv_ptr);			
			op_ici_destroy (ici_ptr);
			}	
		}
	FOUT;
	}

static void
gna_clsvr_mgr_stat_initialize (char* app_type, char* app_name, int index, double processing_speed, double overhead)
	{
	GnaT_App_Stat_Info* 		stat_info_ptr;
	GnaT_App_Glob_Stat_Info*	g_stat_info_ptr;
	char						full_stat_name[64];
	char						g_app_type [64];
	void*						dummy_argument;					
	
	/** Registers statistics for each application */
	FIN (gna_clsvr_mgr_stat_initialize ());
	
	/* Allocate memory for the stat structure */
	stat_info_ptr = (GnaT_App_Stat_Info*) op_prg_mem_alloc (sizeof (GnaT_App_Stat_Info));
	strcpy (stat_info_ptr->app_name, app_name);
	strcpy (stat_info_ptr->app_name_type, app_type);
	
	sprintf (full_stat_name, "%s %s", "Server", app_type);
	stat_info_ptr->bytes_rcvd_stat_handle = Oms_Dim_Stat_Reg (my_objid, full_stat_name, 
		"Traffic Received (bytes/sec)",app_name, OPC_STAT_LOCAL);
	Oms_Dim_Stat_Annotate (stat_info_ptr->bytes_rcvd_stat_handle, app_name);
			
	stat_info_ptr->pkts_rcvd_stat_handle = Oms_Dim_Stat_Reg (my_objid, full_stat_name, 
		"Traffic Received (packets/sec)", app_name, OPC_STAT_LOCAL);
	Oms_Dim_Stat_Annotate (stat_info_ptr->pkts_rcvd_stat_handle, app_name);
	
	/* Make sure we don't register Traffic Sent statistics for print application */
	if (strcmp (app_type, "Print"))
		{
		stat_info_ptr->bytes_sent_stat_handle = Oms_Dim_Stat_Reg (my_objid, full_stat_name, 
			"Traffic Sent (bytes/sec)", app_name, OPC_STAT_LOCAL);
		Oms_Dim_Stat_Annotate (stat_info_ptr->bytes_sent_stat_handle, app_name);
		
		/* Register local statistics */
		stat_info_ptr->pkts_sent_stat_handle = Oms_Dim_Stat_Reg (my_objid, full_stat_name, 
			"Traffic Sent (packets/sec)", app_name, OPC_STAT_LOCAL);
		Oms_Dim_Stat_Annotate (stat_info_ptr->pkts_sent_stat_handle, app_name);
		}
   
	stat_info_ptr->num_sessions_stat_handle = Oms_Dim_Stat_Reg (my_objid, full_stat_name, 
		"Load (sessions/sec)", app_name, OPC_STAT_LOCAL);
	Oms_Dim_Stat_Annotate (stat_info_ptr->num_sessions_stat_handle, app_name);
				
	stat_info_ptr->num_jobs_stat_handle = Oms_Dim_Stat_Reg (my_objid, full_stat_name, 
		"Load (requests/sec)", app_name, OPC_STAT_LOCAL);
	Oms_Dim_Stat_Annotate (stat_info_ptr->num_jobs_stat_handle, app_name);
	
	stat_info_ptr->service_time_stat_handle = Oms_Dim_Stat_Reg (my_objid, full_stat_name, 
		"Task Processing Time (sec)", app_name, OPC_STAT_LOCAL);
	Oms_Dim_Stat_Annotate (stat_info_ptr->service_time_stat_handle, app_name);
	
	/* Register stats query and entry stats for database application */
	if (!strcmp (app_type, "DB"))
		{
		sprintf (full_stat_name, "%s %s", "Server", "DB Entry");
		stat_info_ptr->dbe_bytes_rcvd_stat_handle = Oms_Dim_Stat_Reg (my_objid, full_stat_name, 
			"Traffic Received (bytes/sec)", app_name, OPC_STAT_LOCAL);
		Oms_Dim_Stat_Annotate (stat_info_ptr->dbe_bytes_rcvd_stat_handle, app_name);
		
		stat_info_ptr->dbe_pkts_rcvd_stat_handle = Oms_Dim_Stat_Reg (my_objid, full_stat_name, 
			"Traffic Received (packets/sec)", app_name, OPC_STAT_LOCAL);
		Oms_Dim_Stat_Annotate (stat_info_ptr->dbe_pkts_rcvd_stat_handle, app_name);
		
		stat_info_ptr->dbe_bytes_sent_stat_handle = Oms_Dim_Stat_Reg (my_objid, full_stat_name, 
			"Traffic Sent (bytes/sec)", app_name, OPC_STAT_LOCAL);
		Oms_Dim_Stat_Annotate (stat_info_ptr->dbe_bytes_sent_stat_handle, app_name);
		
		stat_info_ptr->dbe_pkts_sent_stat_handle = Oms_Dim_Stat_Reg (my_objid, full_stat_name, 
			"Traffic Sent (packets/sec)", app_name, OPC_STAT_LOCAL);
		Oms_Dim_Stat_Annotate (stat_info_ptr->dbe_pkts_sent_stat_handle, app_name);
		
		stat_info_ptr->dbe_num_jobs_stat_handle = Oms_Dim_Stat_Reg (my_objid, full_stat_name, 
			"Load (requests/sec)", app_name, OPC_STAT_LOCAL);
		Oms_Dim_Stat_Annotate (stat_info_ptr->dbe_num_jobs_stat_handle, app_name);
		
		stat_info_ptr->dbe_service_time_stat_handle = Oms_Dim_Stat_Reg (my_objid, full_stat_name, 
			"Task Processing Time (sec)", app_name, OPC_STAT_LOCAL);
		Oms_Dim_Stat_Annotate (stat_info_ptr->dbe_service_time_stat_handle, app_name);
		
		sprintf (full_stat_name, "%s %s", "Server", "DB Query");
		stat_info_ptr->dbq_bytes_rcvd_stat_handle = Oms_Dim_Stat_Reg (my_objid, full_stat_name, 
			"Traffic Received (bytes/sec)", app_name, OPC_STAT_LOCAL);
		Oms_Dim_Stat_Annotate (stat_info_ptr->dbq_bytes_rcvd_stat_handle, app_name);
		
		stat_info_ptr->dbq_pkts_rcvd_stat_handle = Oms_Dim_Stat_Reg (my_objid, full_stat_name, 
			"Traffic Received (packets/sec)", app_name, OPC_STAT_LOCAL);
		Oms_Dim_Stat_Annotate (stat_info_ptr->dbq_pkts_rcvd_stat_handle, app_name);
		
		stat_info_ptr->dbq_bytes_sent_stat_handle = Oms_Dim_Stat_Reg (my_objid, full_stat_name, 
			"Traffic Sent (bytes/sec)", app_name, OPC_STAT_LOCAL);
		Oms_Dim_Stat_Annotate (stat_info_ptr->dbq_bytes_sent_stat_handle, app_name);
		
		stat_info_ptr->dbq_pkts_sent_stat_handle = Oms_Dim_Stat_Reg (my_objid, full_stat_name, 
			"Traffic Sent (packets/sec)", app_name, OPC_STAT_LOCAL);
		Oms_Dim_Stat_Annotate (stat_info_ptr->dbq_pkts_sent_stat_handle, app_name);
		
		stat_info_ptr->dbq_num_jobs_stat_handle = Oms_Dim_Stat_Reg (my_objid, full_stat_name, 
			"Load (requests/sec)", app_name, OPC_STAT_LOCAL);
		Oms_Dim_Stat_Annotate (stat_info_ptr->dbq_num_jobs_stat_handle, app_name);
		
		stat_info_ptr->dbq_service_time_stat_handle = Oms_Dim_Stat_Reg (my_objid, full_stat_name, 
			"Task Processing Time (sec)", app_name, OPC_STAT_LOCAL);
		Oms_Dim_Stat_Annotate (stat_info_ptr->dbq_service_time_stat_handle, app_name);
		}
	
	/* Check if HTTP is used, in this case, capital letters are used for global stat */
	if (!strcmp (app_type, "Http"))
		{				
		strcpy (g_app_type, "HTTP");
		}
	else
		{
		strcpy (g_app_type, app_type);			
		}
	
	/* Register global statistics */
	/* Check whether global stats have been already registered for this type of application */
	g_stat_info_ptr =  (GnaT_App_Glob_Stat_Info*) prg_string_hash_table_item_get (server_global_stats_hash_table_ptr, g_app_type);
	
	/* The global statistic for this application type has not been registered yet */
	if (g_stat_info_ptr == OPC_NIL)
		{
		g_stat_info_ptr = (GnaT_App_Glob_Stat_Info*) op_prg_mem_alloc (sizeof (GnaT_App_Glob_Stat_Info));
		
		/* Register stats query and entry stats for database application */
		if (!strcmp (app_type, "DB"))
			{
			sprintf (full_stat_name, "%s.%s", "DB Entry", "Traffic Sent (packets/sec)");
			g_stat_info_ptr->dbe_g_pkts_sent_stat_handle = op_stat_reg (full_stat_name, OPC_STAT_INDEX_NONE, OPC_STAT_GLOBAL);
		
			sprintf (full_stat_name, "%s.%s", "DB Entry", "Traffic Sent (bytes/sec)");
			g_stat_info_ptr->dbe_g_bytes_sent_stat_handle = op_stat_reg (full_stat_name, OPC_STAT_INDEX_NONE, OPC_STAT_GLOBAL);			
			
			sprintf (full_stat_name, "%s.%s", "DB Entry", "Traffic Received (packets/sec)");
			g_stat_info_ptr->dbe_g_pkts_rcvd_stat_handle = op_stat_reg (full_stat_name, OPC_STAT_INDEX_NONE, OPC_STAT_GLOBAL);					
				
			sprintf (full_stat_name, "%s.%s", "DB Entry", "Traffic Received (bytes/sec)");
			g_stat_info_ptr->dbe_g_bytes_rcvd_stat_handle = op_stat_reg (full_stat_name, OPC_STAT_INDEX_NONE, OPC_STAT_GLOBAL);
			
			sprintf (full_stat_name, "%s.%s", "DB Query", "Traffic Sent (packets/sec)");
			g_stat_info_ptr->dbq_g_pkts_sent_stat_handle = op_stat_reg (full_stat_name, OPC_STAT_INDEX_NONE, OPC_STAT_GLOBAL);
		
			sprintf (full_stat_name, "%s.%s", "DB Query", "Traffic Sent (bytes/sec)");
			g_stat_info_ptr->dbq_g_bytes_sent_stat_handle = op_stat_reg (full_stat_name, OPC_STAT_INDEX_NONE, OPC_STAT_GLOBAL);			
			
			sprintf (full_stat_name, "%s.%s", "DB Query", "Traffic Received (packets/sec)");
			g_stat_info_ptr->dbq_g_pkts_rcvd_stat_handle = op_stat_reg (full_stat_name, OPC_STAT_INDEX_NONE, OPC_STAT_GLOBAL);					
				
			sprintf (full_stat_name, "%s.%s", "DB Query", "Traffic Received (bytes/sec)");
			g_stat_info_ptr->dbq_g_bytes_rcvd_stat_handle = op_stat_reg (full_stat_name, OPC_STAT_INDEX_NONE, OPC_STAT_GLOBAL);						
			}
		else
			{
			/* Make sure we don't register Traffic Sent statistic for print application */
			if (strcmp (app_type, "Print"))
				{
				sprintf (full_stat_name, "%s.%s", g_app_type, "Traffic Sent (packets/sec)");
				g_stat_info_ptr->g_pkts_sent_stat_handle = op_stat_reg (full_stat_name, OPC_STAT_INDEX_NONE, OPC_STAT_GLOBAL);
		
				sprintf (full_stat_name, "%s.%s", g_app_type, "Traffic Sent (bytes/sec)");
				g_stat_info_ptr->g_bytes_sent_stat_handle = op_stat_reg (full_stat_name, OPC_STAT_INDEX_NONE, OPC_STAT_GLOBAL);			
				}
		
			sprintf (full_stat_name, "%s.%s", g_app_type, "Traffic Received (packets/sec)");
			g_stat_info_ptr->g_pkts_rcvd_stat_handle = op_stat_reg (full_stat_name, OPC_STAT_INDEX_NONE, OPC_STAT_GLOBAL);					
				
			sprintf (full_stat_name, "%s.%s", g_app_type, "Traffic Received (bytes/sec)");
			g_stat_info_ptr->g_bytes_rcvd_stat_handle = op_stat_reg (full_stat_name, OPC_STAT_INDEX_NONE, OPC_STAT_GLOBAL);
			}
								
		/* Insert structure into the hash table, lookup key = app_type */
		prg_string_hash_table_item_insert (server_global_stats_hash_table_ptr, g_app_type, g_stat_info_ptr, &dummy_argument);
		}
					
	/* Treat DB application differently, since it writes to */
	/* multiple group names.								*/
	if (!strcmp (app_type, "DB"))
		{
		stat_info_ptr->dbe_g_pkts_sent_stat_handle  = g_stat_info_ptr->dbe_g_pkts_sent_stat_handle; 
		stat_info_ptr->dbe_g_pkts_rcvd_stat_handle = g_stat_info_ptr->dbe_g_pkts_rcvd_stat_handle;
		stat_info_ptr->dbe_g_bytes_sent_stat_handle = g_stat_info_ptr->dbe_g_bytes_sent_stat_handle;
		stat_info_ptr->dbe_g_bytes_rcvd_stat_handle = g_stat_info_ptr->dbe_g_bytes_rcvd_stat_handle;
		stat_info_ptr->dbq_g_pkts_sent_stat_handle  = g_stat_info_ptr->dbq_g_pkts_sent_stat_handle; 
		stat_info_ptr->dbq_g_pkts_rcvd_stat_handle = g_stat_info_ptr->dbq_g_pkts_rcvd_stat_handle;
		stat_info_ptr->dbq_g_bytes_sent_stat_handle = g_stat_info_ptr->dbq_g_bytes_sent_stat_handle;
		stat_info_ptr->dbq_g_bytes_rcvd_stat_handle = g_stat_info_ptr->dbq_g_bytes_rcvd_stat_handle;
		}
	else
		{
		/* Set the stathandle for this application */
		stat_info_ptr->g_pkts_sent_stat_handle  = g_stat_info_ptr->g_pkts_sent_stat_handle; 
		stat_info_ptr->g_pkts_rcvd_stat_handle = g_stat_info_ptr->g_pkts_rcvd_stat_handle;
		stat_info_ptr->g_bytes_sent_stat_handle = g_stat_info_ptr->g_bytes_sent_stat_handle;
		stat_info_ptr->g_bytes_rcvd_stat_handle = g_stat_info_ptr->g_bytes_rcvd_stat_handle;
		}
	
	/* Store overhead for this application */
	if (overhead > 0.0)	
		stat_info_ptr->overhead_distribution = op_dist_load ("normal", overhead, (overhead*overhead)/100.0);
	else
		stat_info_ptr->overhead_distribution = op_dist_load ("constant", overhead, 0.0);
	
	/* Store processing speed for this application */
	stat_info_ptr->processing_speed = processing_speed;
	
	/* Insert application in the hash table */	
	prg_string_hash_table_item_insert (server_stats_hash_table_ptr, app_name, stat_info_ptr, &dummy_argument);
			
	FOUT;
	}

static void
gna_clsvr_mgr_stats_update (GnaT_Application_Type app_type, char* app_name_ptr, GnaT_Stat_Type stat_type, double v1, double v2, int type_of_request)
	{
	GnaT_App_Stat_Info* 		app_info_ptr;
	char						temp [255];
	
	FIN (gna_clsvr_mgr_stats_update (GnaT_Application_Type app_type, char* app_name_ptr, GnaT_Stat_Type stat_type, double v1, double v2, int type_of_request));
	
	/* Get info about this application */	
	app_info_ptr =  (GnaT_App_Stat_Info*) prg_string_hash_table_item_get (server_stats_hash_table_ptr, app_name_ptr);
	
	/* Write out both local and global stats */
	if ((app_info_ptr != OPC_NIL) && (app_type != GnaC_App_Type_Video_Conferencing) && (app_type != GnaC_App_Type_Voice))
		{		
		switch (stat_type)
			{
			case  Pkts_Rcvd:
				{
				Oms_Dim_Stat_Write (app_info_ptr->pkts_rcvd_stat_handle,  1.0);
				Oms_Dim_Stat_Write (app_info_ptr->pkts_rcvd_stat_handle,  0.0);

				if (app_type == GnaC_App_Type_Database)
					{
					if (type_of_request == GnaC_Query)
						{
						Oms_Dim_Stat_Write (app_info_ptr->dbq_pkts_rcvd_stat_handle,  1.0);
						Oms_Dim_Stat_Write (app_info_ptr->dbq_pkts_rcvd_stat_handle,  0.0);
						op_stat_write (app_info_ptr->dbq_g_pkts_rcvd_stat_handle,  1.0);
						op_stat_write (app_info_ptr->dbq_g_pkts_rcvd_stat_handle,  0.0);
						}
					else
						{
						Oms_Dim_Stat_Write (app_info_ptr->dbe_pkts_rcvd_stat_handle,  1.0);
						Oms_Dim_Stat_Write (app_info_ptr->dbe_pkts_rcvd_stat_handle,  0.0);
						op_stat_write (app_info_ptr->dbe_g_pkts_rcvd_stat_handle,  1.0);
						op_stat_write (app_info_ptr->dbe_g_pkts_rcvd_stat_handle,  0.0);
						}
					}
				else
					{
					op_stat_write (app_info_ptr->g_pkts_rcvd_stat_handle,  1.0);
					op_stat_write (app_info_ptr->g_pkts_rcvd_stat_handle,  0.0);
					}
				
				break;
				}
				
			case  Pkts_Sent:
				{
				if (app_type != GnaC_App_Type_Print)
					{			
					Oms_Dim_Stat_Write (app_info_ptr->pkts_sent_stat_handle,  1.0);
					Oms_Dim_Stat_Write (app_info_ptr->pkts_sent_stat_handle,  0.0);
					
					if (app_type == GnaC_App_Type_Database)
						{
						if (type_of_request == GnaC_Query)
							{
							Oms_Dim_Stat_Write (app_info_ptr->dbq_pkts_sent_stat_handle,  1.0);
							Oms_Dim_Stat_Write (app_info_ptr->dbq_pkts_sent_stat_handle,  0.0);
							op_stat_write (app_info_ptr->dbq_g_pkts_sent_stat_handle,  1.0);
							op_stat_write (app_info_ptr->dbq_g_pkts_sent_stat_handle,  0.0);					
							}
						else
							{
							Oms_Dim_Stat_Write (app_info_ptr->dbe_pkts_sent_stat_handle,  1.0);
							Oms_Dim_Stat_Write (app_info_ptr->dbe_pkts_sent_stat_handle,  0.0);
							op_stat_write (app_info_ptr->dbe_g_pkts_sent_stat_handle,  1.0);
							op_stat_write (app_info_ptr->dbe_g_pkts_sent_stat_handle,  0.0);					
							}
						}
					else
						{
						op_stat_write (app_info_ptr->g_pkts_sent_stat_handle,  1.0);
						op_stat_write (app_info_ptr->g_pkts_sent_stat_handle,  0.0);
						}
					}
				break;
				}
			
			case  Bytes_Rcvd:
				{				
				Oms_Dim_Stat_Write (app_info_ptr->bytes_rcvd_stat_handle,  v1);
				Oms_Dim_Stat_Write (app_info_ptr->bytes_rcvd_stat_handle,  0.0);							
				
				if (app_type == GnaC_App_Type_Database)
					{
					if (type_of_request == GnaC_Query)
						{
						Oms_Dim_Stat_Write (app_info_ptr->dbq_bytes_rcvd_stat_handle,  v1);
						Oms_Dim_Stat_Write (app_info_ptr->dbq_bytes_rcvd_stat_handle,  0.0);
						op_stat_write (app_info_ptr->dbq_g_bytes_rcvd_stat_handle,  v1);
						op_stat_write (app_info_ptr->dbq_g_bytes_rcvd_stat_handle,  0.0);	
						}
					else
						{
						Oms_Dim_Stat_Write (app_info_ptr->dbe_bytes_rcvd_stat_handle,  v1);
						Oms_Dim_Stat_Write (app_info_ptr->dbe_bytes_rcvd_stat_handle,  0.0);
						op_stat_write (app_info_ptr->dbe_g_bytes_rcvd_stat_handle,  v1);
						op_stat_write (app_info_ptr->dbe_g_bytes_rcvd_stat_handle,  0.0);	
						}
					}
				else
					{
					op_stat_write (app_info_ptr->g_bytes_rcvd_stat_handle,  v1);
					op_stat_write (app_info_ptr->g_bytes_rcvd_stat_handle,  0.0);	
					}
				
				break;
				}
				
			case  Bytes_Sent:
				{
				if (app_type != GnaC_App_Type_Print)
					{
					Oms_Dim_Stat_Write (app_info_ptr->bytes_sent_stat_handle,  v1);
					Oms_Dim_Stat_Write (app_info_ptr->bytes_sent_stat_handle,  0.0);					
					
					if (app_type == GnaC_App_Type_Database)
						{
						if (type_of_request == GnaC_Query)
							{
							Oms_Dim_Stat_Write (app_info_ptr->dbq_bytes_sent_stat_handle,  v1);
							Oms_Dim_Stat_Write (app_info_ptr->dbq_bytes_sent_stat_handle,  0.0);
							op_stat_write (app_info_ptr->dbq_g_bytes_sent_stat_handle,  v1);
							op_stat_write (app_info_ptr->dbq_g_bytes_sent_stat_handle,  0.0);
							}
						else
							{
							Oms_Dim_Stat_Write (app_info_ptr->dbe_bytes_sent_stat_handle,  v1);
							Oms_Dim_Stat_Write (app_info_ptr->dbe_bytes_sent_stat_handle,  0.0);
							op_stat_write (app_info_ptr->dbe_g_bytes_sent_stat_handle,  v1);
							op_stat_write (app_info_ptr->dbe_g_bytes_sent_stat_handle,  0.0);
							}
						}
					else
						{
						op_stat_write (app_info_ptr->g_bytes_sent_stat_handle,  v1);
						op_stat_write (app_info_ptr->g_bytes_sent_stat_handle,  0.0);
						}
					}
				break;
				}	
			
			
			case Num_Jobs:
				{
				Oms_Dim_Stat_Write (app_info_ptr->num_jobs_stat_handle, v1);
				
				if (app_type == GnaC_App_Type_Database)
					{
					if (type_of_request == GnaC_Query)
						{
						Oms_Dim_Stat_Write (app_info_ptr->dbq_num_jobs_stat_handle,  v1);
						}
					else
						{
						Oms_Dim_Stat_Write (app_info_ptr->dbe_num_jobs_stat_handle,  v1);					
						}
					}		
				break;
				}
			
			case Num_Sess:
				{
				Oms_Dim_Stat_Write (app_info_ptr->num_sessions_stat_handle, v1);			
				break;
				}
			
			case Task_Proc_Time:
				{
				Oms_Dim_Stat_Write_T (app_info_ptr->service_time_stat_handle, v1, v2);
				
				if (app_type == GnaC_App_Type_Database)
					{
					if (type_of_request == GnaC_Query)
						{
						Oms_Dim_Stat_Write_T (app_info_ptr->dbq_service_time_stat_handle, v1, v2);					
						}
					else
						{
						Oms_Dim_Stat_Write_T (app_info_ptr->dbe_service_time_stat_handle, v1, v2);				
						}
					}		
				break;
				}
								
			default:
				{
				break;
				}
			}
		}
	FOUT;
	}	
/************************************************************************************/

static void
gna_clsvr_mgr_open (GnaT_Service* serv_ptr)
	{
	GnaT_Serv_Session*	sess_ptr;
	char				msg [512];

	static Pmohandle	sess_pmh;
	static int			sess_defined = 0;

	/** Listen for an incoming connection on the given service. **/
	FIN (gna_clsvr_mgr_open (serv_ptr));

	/*	Print trace that the new service has been opened 	*/
	if (trace_active)
		{
		sprintf (msg, "Opening new service (%s) on %s port %d with tos %d",
			serv_ptr->name, serv_ptr->protocol, serv_ptr->port, serv_ptr->type_of_service);
		op_prg_odb_print_major (msg, OPC_NIL);
		} 

	/* Define the memory type, if it hasn't been already. */
	if (!sess_defined)
		{
		sess_pmh = op_prg_pmo_define ("GNA server session structure",
			sizeof (GnaT_Serv_Session), 16);
		sess_defined = 1;
		}

	/* Allocate and initialize a session structure. */
	sess_ptr = (GnaT_Serv_Session*) op_prg_pmo_alloc (sess_pmh);
	if (sess_ptr == OPC_NIL)
		gna_clsvr_mgr_error ("Unable to allocate GNA server session structure.");

	op_prg_list_init (&sess_ptr->job_list);

	if (processing_mode == NasC_Contention_Already_Modeled)
		op_prg_list_init (&sess_ptr->ev_list);

	/* Assign the service registration record for the new service */
	sess_ptr->serv_ptr 		= serv_ptr;

	sess_ptr->cmd_issued 	= 0;
	sess_ptr->session_id 	= sess_id;
	sess_ptr->sess_type 	= GNAC_SESSION_TYPE_PASSIVE;
	sess_ptr->received_close_indication = OPC_FALSE;
	sess_ptr->total_jobs 	= 0;
	sess_ptr->invoked_client_exists = OPC_FALSE;
	sess_ptr->close_already_rcvd 	= OPC_FALSE;
	sess_ptr->prev_src_addr	= OPC_NIL;
	sess_ptr->prev_dest_addr = OPC_NIL;
	sess_ptr->appl_close_rcvd = OPC_FALSE;
	strcpy (sess_ptr->app_name, serv_ptr->name);

	/* Obtain the application type from the name of the Application. This 	*/
	/* will be useful in writing the statistics for individual application	*/
	/* in terms od server performance on the server.						*/
	sess_ptr->app_type = gna_clsvr_mgr_port_to_apptype ((GnaT_App) serv_ptr->port);

	/* Set the flag which will indicate the passive session for custom application is already spawned */
	if (sess_ptr->app_type == GnaC_App_Type_Custom_Application)
		{
		custom_passive_session_registered = OPC_TRUE;
		}

	/*	Increment session id so that next session has unique session index.	*/
	sess_id++;

	/* The data space of the sess_id is now divided equally between the     */
	/* sess_id and the cli_sess_id											*/
	if (sess_id > NASC_MAX_SESS_ID)
		sess_id = 0;

	/* Set up the request ICI. Set type of service in the ICI. This info	*/
	/* will be passed in ICIs to TCP module (for TCP applications) or to	*/
	/* TPAL (for UDP applications) and then it will be compared with type	*/
	/* of service set by client.											*/ 
	sess_ptr->ici_ptr = op_ici_create ("tpal_req");
	if (sess_ptr->ici_ptr == OPC_NIL)
		gna_clsvr_mgr_error ("Unable to allocate TPAL ICI for session.");
	if (op_ici_attr_set (sess_ptr->ici_ptr, "flags", TPALC_OPT_PASSIVE) 					== OPC_COMPCODE_FAILURE ||
		op_ici_attr_set (sess_ptr->ici_ptr, "Application ID", sess_ptr) 					== OPC_COMPCODE_FAILURE ||
		op_ici_attr_set (sess_ptr->ici_ptr, "Remote Address", TpalC_Host_Unspec)			== OPC_COMPCODE_FAILURE ||
		op_ici_attr_set (sess_ptr->ici_ptr, "Remote Port", TpalC_Port_Unspec) 				== OPC_COMPCODE_FAILURE ||
		op_ici_attr_set (sess_ptr->ici_ptr, "Service", serv_ptr->name) 						== OPC_COMPCODE_FAILURE ||
		op_ici_attr_set (sess_ptr->ici_ptr, "Sess Type", sess_ptr->sess_type) 				== OPC_COMPCODE_FAILURE ||
		op_ici_attr_set (sess_ptr->ici_ptr, "Local Port", serv_ptr->port) 					== OPC_COMPCODE_FAILURE ||
		op_ici_attr_set (sess_ptr->ici_ptr, "Protocol", serv_ptr->protocol) 				== OPC_COMPCODE_FAILURE ||
		op_ici_attr_set (sess_ptr->ici_ptr, "Application Type", sess_ptr->app_type) 		== OPC_COMPCODE_FAILURE ||
		op_ici_attr_set (sess_ptr->ici_ptr, "Type of Service", serv_ptr->type_of_service) 	== OPC_COMPCODE_FAILURE ||
		op_ici_attr_set (sess_ptr->ici_ptr, "RSVP Parameters", sess_ptr->serv_ptr->rsvp_params_ptr) 	== OPC_COMPCODE_FAILURE)
		{
		gna_clsvr_mgr_error ("Unable to set up TPAL ICI for OPEN command.");
		}

	/* Install the ICI and issue the command. */
	op_ici_install (sess_ptr->ici_ptr);
	op_intrpt_force_remote (TPALC_CMD_OPEN, my_tpal_objid);

	/* Now add the session to the list and increment session list size. */
	op_prg_list_insert (&sess_list, sess_ptr, OPC_LISTPOS_TAIL);
	sess_list_size++;
	
	FOUT;
	}


/***** Job Management *****/
static GnaT_Job*
gna_clsvr_mgr_job_create (GnaT_Application_Type app_type, char* app_name_ptr, int type_of_request)
	{
	GnaT_Job*			job_ptr;
	static Pmohandle	job_pmh;
	static int			job_defined = 0;

	/** Create a new job record structure. **/
	FIN (gna_clsvr_mgr_job_create (app_type));

	/* Define the memory type if necessary. */
	if (!job_defined)
		{
		job_pmh = op_prg_pmo_define ("GNA server job structure", sizeof (GnaT_Job), 16);
		job_defined = 1;
		}

	/* Allocate and initialize a job structure. */
	job_ptr = (GnaT_Job *) op_prg_pmo_alloc (job_pmh);

	if (job_ptr == OPC_NIL)
		{
		gna_clsvr_mgr_error ("Unable to allocate GNA server job structure.");
		}

	job_ptr->app_type 			= app_type;
	strcpy (job_ptr->app_name, app_name_ptr);
	job_ptr->service_time 		= 0.0;
	job_ptr->last_update_time 	= -1.0;
	job_ptr->result 			= OPC_NIL;
	job_ptr->command 			= 0;
	job_ptr->type_of_request	=  type_of_request;

	/* Record the statistics of the creation of job	*/
	op_stat_write (SERV_NUM_JOBS, 1.0);

	/* Write the statistics for the individual application's job count */
	gna_clsvr_mgr_stats_update (job_ptr->app_type, job_ptr->app_name, Num_Jobs, 1.0, 0.0, job_ptr->type_of_request);

	FRET (job_ptr);
	}


static void
gna_clsvr_mgr_job_destroy (GnaT_Job* job_ptr)
	{
	/** Deallocate the given job structure and its contents. **/
	FIN (gna_clsvr_mgr_job_destroy (job_ptr));
	
	/* If the result packet is non-NIL, destroy it. */
	if (job_ptr->result != OPC_NIL)
		op_pk_destroy (job_ptr->result);

	/* Free the response size list if not empty */
	if (job_ptr->resp_size_lptr != OPC_NIL)
		{
		while (op_prg_list_size (job_ptr->resp_size_lptr))
			op_prg_list_remove (job_ptr->resp_size_lptr, OPC_LISTPOS_HEAD);
		op_prg_mem_free (job_ptr->resp_size_lptr);
		
		/* Set the list pointer to indicate that it does not exist.	*/
		job_ptr->resp_size_lptr = OPC_NIL;
		}
	
	/* Record the statistics of the death the current job	*/
	op_stat_write (SERV_NUM_JOBS, 0);

	/* Write the statistics for the individual application's job count */
	gna_clsvr_mgr_stats_update (job_ptr->app_type, job_ptr->app_name, Num_Jobs, 0.0, 0.0, job_ptr->type_of_request);

	/* We've freed the contents.  Now free the structure itself. */
	op_prg_mem_free (job_ptr);

	FOUT;
	}


/***** Diagnostic Functions *****/
static void
gna_clsvr_mgr_list_print ()
	{
	int				i, list_size;
	GnaT_Service*	serv_ptr;

	/** Print the list of services. **/
	FIN (gna_clsvr_mgr_list_print ());

	list_size = op_prg_list_size (&serv_list);
	for (i = 0; i < list_size; i++)
		{
		serv_ptr = (GnaT_Service*) op_prg_list_access (&serv_list, i);
		if (serv_ptr != OPC_NIL)
			printf ("(%20s) %s port %d: popularity %g\n",
				serv_ptr->name, serv_ptr->protocol, serv_ptr->port, serv_ptr->pop);
		}

	FOUT;
	}


static void
gna_clsvr_mgr_sess_list_print ()
	{
	int					i;
	GnaT_Serv_Session*	sess_ptr;

	/** Print the list of sessions. **/
	FIN (gna_clsvr_mgr_sess_list_print ());

	for (i = 0; i < sess_list_size; i++)
		{
		sess_ptr = (GnaT_Serv_Session*) op_prg_list_access (&sess_list, i);
		if (sess_ptr != OPC_NIL)
			{
			/* Print general session information. */
			printf ("%20s ->  %s local port %4d: Type of service: %25s, %d jobs queued\n",
				sess_ptr->serv_ptr->name, sess_ptr->serv_ptr->protocol,
				sess_ptr->serv_ptr->port, 
				ip_qos_tos_value_to_tos_name_convert ((OmsT_Qm_Tos) sess_ptr->serv_ptr->type_of_service), 
				op_prg_list_size (&sess_ptr->job_list));
			}
		}

	FOUT;
	}

static void 
gna_clsvr_mgr_serv_id_assign ()
	{
	List*				proc_record_handle_list_ptr;
	int					record_handle_list_size;
	OmsT_Pr_Handle		temp_process_record_handle;
	double				dbl_server_id;

	/** Assigns server identifier randomly and creates a 		**/
	/**	record in the active workstation list only if this 		**/
	/**	is a LAN node.											**/
	FIN (gna_clsvr_mgr_serv_id_assign ());

	/*	Find out the node type from model wide process registry */
	proc_record_handle_list_ptr = op_prg_list_create ();

	oms_pr_process_discover (OPC_OBJID_INVALID, proc_record_handle_list_ptr, 
			"node objid",	OMSC_PR_OBJID,		my_node_id, 
			"node_type", 	OMSC_PR_STRING, 	"lan_mac", 
			OPC_NIL);

	/*	Obtain the list size of the discovered processes.		*/
	record_handle_list_size = op_prg_list_size (proc_record_handle_list_ptr);

	if (record_handle_list_size == 1)
		{
		/*	Set a flag indicating that this is a LAN node.		*/
		node_is_lan = OPC_TRUE;

		temp_process_record_handle = (OmsT_Pr_Handle) op_prg_list_access (proc_record_handle_list_ptr, OPC_LISTPOS_HEAD);

		/* 	Obtain total number of workstations in this LAN node.*/
		/*	Server id is same as total number of workstations.	*/
		oms_pr_attr_get (temp_process_record_handle, "wkstn count", OMSC_PR_NUMBER, &dbl_server_id);
		server_id = (int) dbl_server_id;

		/*	Obtain lan handle from llm package.					*/
		my_lan_handle = llm_lan_handle_get (my_node_id);

		/*	Call procedure from llm package to create a record 	*/
		/*	for the server in the wkstn list for the LAN.		*/
		llm_random_wkstn_id_assign (my_lan_handle, &server_id);

		/* 	Deallocate no longer needed process registry 		*/
		/*	information.										*/
		while (op_prg_list_size (proc_record_handle_list_ptr))
			op_prg_list_remove (proc_record_handle_list_ptr, OPC_LISTPOS_HEAD);
		op_prg_mem_free (proc_record_handle_list_ptr);
		}

	FOUT;
	}

static Compcode
gna_clsvr_mgr_session_cleanup (GnaT_Serv_Session* app_id, Boolean job_completion_recomputation_required)
	{
	int 				i, j;
	GnaT_Serv_Session* 	sess_ptr;
	GnaT_Job*		   	job_ptr;
	Evhandle*			ev_handle_ptr;
	GnaT_Pending_Job*	pend_job_ptr;
	void* 				temp_sess_ptr;		
	
	/** The function removes all active jobs for the current session and finally	**/
	/** deletes the session. In the special case of a multi-tier application, this	**/
	/** may not be necessarily true. Note that for this application, if the server	**/
	/** receives CLOSE command for a job which it was processing, it retains this	**/
	/** information so that when the job completes, it can take appropriate action	**/
	/** (for example, cleaning up the current session rceord.)						**/
	FIN (gna_clsvr_mgr_session_cleanup (app_id, job_completion_recomputation_required));

	/* Scan through the session list and remove the session record for	*/
	/* from the session list.											*/
	for (i = 0; i < sess_list_size; i++)
		{
		/* Obtain the session pointer for the ith element form the list */
		sess_ptr = (GnaT_Serv_Session *) op_prg_list_access (&sess_list, i);

		/* If the current session pointer matches the session pointer 	*/
		/* obtained from the ICI, then enter the if condition			*/
		if (sess_ptr->session_id  == app_id->session_id)
			{
			/*  Check if service completion is scheduled.   */
			if (processing_mode == NasC_Simulate_Contention)
				{
				if (op_ev_valid (sess_ptr->next_evhandle) != OPC_FALSE)
					{
					/*  Cancel the event as the session has been closed.    */
					if (op_ev_equal (sess_ptr->next_evhandle, op_ev_current ()) == OPC_FALSE)
						op_ev_cancel (sess_ptr->next_evhandle);
					}
				}
			else
				{
				/* Loop through the event list of pending events for the*/
				/* session in question.									*/
				while (op_prg_list_size (&sess_ptr->ev_list) > 0)
					{
					/* Remove the evhandle being stored as a elemnet in	*/
					/* session event list.								*/
					ev_handle_ptr = (Evhandle *) op_prg_list_remove (&sess_ptr->ev_list, OPC_LISTPOS_HEAD);

					/* If the event is still valid then cancel the event*/
					/* before actually freeing the evhandle memory.		*/
					if (op_ev_valid (*ev_handle_ptr) != OPC_FALSE)
						op_ev_cancel (*ev_handle_ptr);

					/* As the event handle element has been removed 	*/
					/* from the list and the corresponding event has 	*/
					/* cancelled, free the memory associated with this	*/
					/* element.											*/
					op_prg_mem_free (ev_handle_ptr);
					}

				/* Free the memory assciated with List as the session	*/
				/* has to be destroyed.									*/
				op_prg_list_free (&sess_ptr->ev_list);
				}

			/* Deallocate the internal ICI. Note that there is an ICI for	*/
			/* session which contains lower layer (e.g., TPAL) handle.		*/
			if (sess_ptr->ici_ptr != OPC_NIL)
				op_ici_destroy (sess_ptr->ici_ptr);

			/* Destroy all jobs enqueued for this session. */
			while (op_prg_list_size (&sess_ptr->job_list) > 0)
				{
				/* We will be destroying a session for which a job  */
				/* is in progress. Set a flag to recompute the job  */
				/* completion times with this session removed.      */
				job_completion_recomputation_required = OPC_TRUE;

				/* Obtain a handle on the HOL job for this session. */
				job_ptr = (GnaT_Job *) op_prg_list_remove (&sess_ptr->job_list, OPC_LISTPOS_HEAD);
				
				/* Terminate jobs related to that session.	*/
				Oms_Resource_Job_Terminate (job_ptr->job_id, &temp_sess_ptr);
				
				if (job_ptr != OPC_NIL)
					gna_clsvr_mgr_job_destroy (job_ptr);
				}

			/* Remove the current session from the list	*/
			/* and reduce the list size.				*/
			sess_ptr = (GnaT_Serv_Session *) op_prg_list_remove (&sess_list, i);
			sess_list_size--;

			if (sess_ptr->prev_src_addr != OPC_NIL || sess_ptr->prev_dest_addr != OPC_NIL)
				{
				op_prg_mem_free (sess_ptr->prev_dest_addr);
				op_prg_mem_free (sess_ptr->prev_src_addr);
				}

			/* Call the function to update statistics	*/
			/* for server performance of invidual appl.	*/
			/* The statitics of concern presently is	*/
			/* the number of active sessions.			*/
			gna_clsvr_mgr_stats_update (sess_ptr->app_type, sess_ptr->app_name, Num_Sess, (double) no_of_act_sess, 0,0);
			
			/* Remove the session from the pending session list if */
			/* it is on it. Otherwise this could cause problem     */
			/* when this session is a web cache session and closed */
			/* by the client.                                      */
			for (j=0; j < op_prg_list_size (pending_job_lptr); j++)
				{
				/* Get the pending job pointer from the list */
				pend_job_ptr = (GnaT_Pending_Job *) op_prg_list_access (pending_job_lptr, j);
				
				if (pend_job_ptr->sess_ptr == sess_ptr)
					{
					/* Remove the session from the pending job list     */
					pend_job_ptr = (GnaT_Pending_Job *) op_prg_list_remove (pending_job_lptr, j);
					j--;
					
					/* Deallocate any memory associated with the pending */
					/* job data strucutre.                               */
					op_pk_destroy (pend_job_ptr->req_pk);
					op_prg_mem_free (pend_job_ptr);

					if (trace_active)
						op_prg_odb_print_minor ("Closing state in gna_clsvr_mgr\n",
							"session closed but on the pending job list.\n",OPC_NIL);										
					}
				}
					 
			/* Free session.	*/
			op_prg_mem_free (sess_ptr);
			
			/* Update the session count and statistics.	*/
			no_of_act_sess--;
			op_stat_write (SERV_NUM_SESS, no_of_act_sess);

			break;
			}
		}

	/* A session was successfully removed.	*/
	FRET (OPC_COMPCODE_SUCCESS); 
	}


static Boolean
gna_clsvr_mgr_segment_insert (Packet** pk_ptr)
	{
	Boolean proc_required = OPC_FALSE;

	/** The function inserts the segment into reassembly buffer		**/
	/** and then if the buffer has completely formed packets then	**/
	/** set the proc_required flag to TRUE. 						**/
	FIN (gna_clsvr_mgr_segment_insert (*pk_ptr));

	/*  Packet is a segment from a SAR buffer. Insert it in a   */
	/*  reassembly buffer until complete packet is received.    */
	op_sar_rsmbuf_seg_insert (reassembly_buf_handle, *pk_ptr);

	/* Check if there is a completly formed packet inside the   */
	/* buffer.                                                  */
	if (op_sar_rsmbuf_pk_count (reassembly_buf_handle) > 0)
		{
		/*  Set a flag to indicate that the packet requires     */
		/*  further processing (e.g., updating statistics,      */
		/*  processing the request, etc.)                       */
		proc_required = OPC_TRUE;

		/*  Insertion of the previous segment caused a packet   */
		/*  completion. Remove this packet.                     */
		*pk_ptr = op_sar_rsmbuf_pk_remove (reassembly_buf_handle);

		/*  Generate trace info, if requested.                  */
		if (trace_active)
			{
			op_prg_odb_print_major ("Received request:", OPC_NIL);
			op_pk_print (*pk_ptr);
			}
		}
	FRET (proc_required);
	}


static GnaT_Application_Type 
gna_clsvr_mgr_port_to_apptype (GnaT_App port_type)
	{
	int				result = -1;

	/** This function returns application type based on the 	**/
	/** based on the port on which this application registered. **/
	FIN (gna_clsvr_mgr_port_to_apptype (GnaT_App	app_type));

	switch (port_type)
		{
		case Ftp:
			{
			result = GnaC_App_Type_Ftp_Get;
			break;
			}
		
		case Rlogin:
			{
			result = GnaC_App_Type_Remote_Login;
			break;
			}
			
		case Email:
			{
			result = GnaC_App_Type_Email_Recv;
			break;
			}
		
		case Video:
			{
			result = GnaC_App_Type_Video_Conferencing;
			break;
			}
			
		case Database:
			{
			result = GnaC_App_Type_Database;
			break;
			}
			
		case Print:
			{
			result = GnaC_App_Type_Print;
			break;
			}
			
		case Cust_App:
			{
			result = GnaC_App_Type_Custom_Application;
			break;
			}
			
		case Voice:
			{
			result = GnaC_App_Type_Voice;
			break;
			}
			
		case Http:
			{
			result = GnaC_App_Type_Http;
			break;
			}
			
		default:
			{
			gna_clsvr_mgr_warn ("Unknown application type.");
			break;
			}
		}
	
	FRET ((GnaT_Application_Type) result);
	}

/*************** Client functions specified below ************************/
static void
gna_client_params_parse ()
	{
	Objid	    	   		appl_comp_objid;
    Objid					profile_objid;
	int     	    		num_of_profiles;
    int         			profile_index;
	GnaT_Profile_Desc* 		profile_desc_ptr;
	char					profile_name [255];
	Boolean					ok_to_schedule = OPC_FALSE;
	Enabled_Profiles_Desc*	enabled_profile_ptr = OPC_NIL;
	int     	    		total_num_of_profiles = 0;
    int         			wkstn_index, number_of_clients;
	Boolean					same_lan_profile;
	int						nam_index = 0;
	
	/** This function parses through the profiles specified     **/
	/** at the client. For each profile supported by the client **/
	/** it calls a parsing function 'gna_client_profile_parser' **/
	FIN (gna_client_params_parse ());

	/* Initialize notification logs.	*/
	gna_notification_log_init ();
	app_bgutil_notification_log_init ();

	/* Initialise llm capability.	*/
	gna_llm_init ();
		
	/* Obtain simulation duration */
	sim_duration = gna_sim_duration_get (OPC_FALSE);

	/* Parse supported sources */
	gna_nam_supported_sources_parse ();

	/* Distinguish between LAN case and single node case since      */
	/* a same profile is parsed many times in LAN case.				*/
	if (node_is_lan == OPC_TRUE)
		{
	    /* Get the compound object for the profile description */
		op_ima_obj_attr_get (my_objid, "LAN Supported Profiles", &appl_comp_objid);

		/* Find the number of profile entries */
		num_of_profiles = op_topo_child_count (appl_comp_objid, OPC_OBJTYPE_GENERIC);		
		
		/* Loop through the profile list and compute the compounded number	*/
		/* of clients.														*/
		for (profile_index = 0; profile_index < num_of_profiles; profile_index ++)
			{
			/* Get number of clients for profile.	*/
			profile_objid = op_topo_child (appl_comp_objid, OPC_OBJTYPE_GENERIC, profile_index);
			op_ima_obj_attr_get (profile_objid, "Number of Clients", &number_of_clients);
		
			/* Check whether the application is applicable to the entire LAN.	*/
			if (number_of_clients == -1)
				{
				number_of_clients = number_of_wkstns;
				}
			
			/* Update compounded number of clients.	*/
			total_num_of_profiles += number_of_clients;		   
			}
		}
	else
		{
		/* Get the compound object for the profile description */
		op_ima_obj_attr_get (my_objid, "Supported Profiles", &appl_comp_objid);

		/* Find the number of profile entries */
		num_of_profiles = op_topo_child_count (appl_comp_objid, OPC_OBJTYPE_GENERIC);		
		
		/* Each workstation is having the same profile. So multiply	*/
		/* number of defined profiles with number of workstations.	*/
		total_num_of_profiles = num_of_profiles;
		}
	
    /* Get the application segment size */
    op_ima_obj_attr_get (my_objid, "Segment Size", &application_segment_size);
	
	/* Create a structure containing global information and that	*/
	/* will be accessible by all applications in this node.			*/
	global_information_ptr = (GnaT_Global_Info*) op_prg_mem_alloc (sizeof (GnaT_Global_Info));

	/* Set Global information in table.	*/
	global_information_ptr->local_tpal_objid = my_tpal_objid;
	global_information_ptr->segment_size	 = application_segment_size;
		
	if (num_of_profiles != 0)
		{
		/* Allocate memory for NAM structure.   */
		nam_profiles_ptr = (GnaT_Nam_Desc *) op_prg_mem_alloc (sizeof (GnaT_Nam_Desc )); 
		nam_profiles_ptr->profile_ptr = (GnaT_Nam_Profile**) op_prg_mem_alloc (total_num_of_profiles * sizeof (GnaT_Nam_Profile*));
		nam_profiles_ptr->number_of_profiles = total_num_of_profiles; 
		

		/* Set the maximum statistic index to 0, since no stats have been		*/
		/* registered yet. There will be one index for each application/profile	*/
		/* couple.																*/
		rlogin_max_stat_index 	= 0;
		database_max_stat_index = 0;
		http_max_stat_index 	= 0;
		print_max_stat_index 	= 0;
		ftp_max_stat_index 		= 0;
		video_max_stat_index 	= 0;
		voice_max_stat_index 	= 0;
		custom_max_stat_index 	= 0;

    	/* Call the profile parser to read each of the profiles     */
    	for (profile_index = 0; profile_index < num_of_profiles; profile_index++)
			{
			profile_objid = op_topo_child (appl_comp_objid, OPC_OBJTYPE_GENERIC, profile_index);
			op_ima_obj_attr_get (profile_objid, "Profile Name", profile_name);
			
			
			/* Create an enabled profile structure and insert it into the list of */
			/* active profiles.													  */
			enabled_profile_ptr = (Enabled_Profiles_Desc*) op_prg_mem_alloc (sizeof (Enabled_Profiles_Desc));
			enabled_profile_ptr->profile_name_ptr = (char *) op_prg_mem_alloc (strlen (profile_name) + 1);
			strcpy (enabled_profile_ptr->profile_name_ptr, profile_name);
			enabled_profile_ptr->profile_index = -1;
			enabled_profile_ptr->application_index = -1;
			op_prg_list_insert (active_profiles_lptr, enabled_profile_ptr, OPC_LISTPOS_TAIL); 

			profile_desc_ptr = (GnaT_Profile_Desc *) oms_data_def_entry_access ("Profile Descriptions", profile_name);

			/* Parse the profile if this profile has been defined. */
			if (profile_desc_ptr != OPC_NIL)
				{		
				/* Get number of clients for this profile.	*/
				if (node_is_lan == OPC_TRUE)
					{
					/* Get number of clients using this profile in lan.	*/
					op_ima_obj_attr_get (profile_objid, "Number of Clients", &number_of_clients);
					
					/* Check whether the application is applicable to the entire LAN.	*/
					if (number_of_clients == -1)
						{
						number_of_clients = number_of_wkstns;
						}
					}
				else
					{
					/* This is not a lan node. There is only one client per profile.	*/
					number_of_clients = 1;
					}
				
				/* Parse the profile as many times as clients defined for this profile.	*/	
				for (wkstn_index = 0; wkstn_index < number_of_clients; wkstn_index ++)
					{
					/* Set a flag indicating that profile generated         */
					/* belong to same lan but different clients.            */
					/* The profile will not not aggregate statistic but     */
					/* use the same one if flag is set.                                     */
					if (wkstn_index == number_of_clients - 1)
						{
						/* Unset flag for the last client of profile in LAN     */
						/* (or the only client if node is workstation.          */
						same_lan_profile = OPC_FALSE;
						}
					else
						{
						/* Set flag if there are more than one client in        */
						/* profile (LAN case).                                                          */
						same_lan_profile = OPC_TRUE;
						}
					
					/* Parse profile. Note that there will be a distinct    */
					/* profile for each     client in LAN case.                                     */      
					nam_profiles_ptr->profile_ptr [nam_index] = 
					gna_client_profile_parser (profile_desc_ptr, same_lan_profile, OPC_FALSE, nam_index);
					
					/* Increment nam index. (represents profile index) */
					nam_index++;
					}
                                
				/* Set a flag to indicate that there is at least one profile    */
				/* and that scheduling function can be called.                                  */
				ok_to_schedule = OPC_TRUE;
				}
			else
				{
				/* Profile has been defined.    */
				nam_profiles_ptr->profile_ptr [profile_index] = OPC_NIL;
				
				/* Write a notification log to tell that profile has    */
				/* not been defined in profile configuration object.    */
				if (strcmp (profile_name, "None") != 0)
					{
					gna_missing_profile_log_write (profile_name);
					}
				}
			}
		
		/* schedule the initial start times for each profile */	  
		if (ok_to_schedule)
			{
			gna_nam_profiles_start (All_Profiles);		  
			}
		}
	else
		{
		/* No profile has been defined. */
		nam_profiles_ptr = OPC_NIL;
		}

    FOUT;
	}

static GnaT_Nam_Profile*
gna_client_profile_parser (GnaT_Profile_Desc* profile_ptr, Boolean same_lan_profile, 
							Boolean remote_invokation, int lan_profile_index)
	{
   	int 					   	i;
	int							j = 0;
   	Objid  				   		symbolic_objid = -1;
   	char*						server_name_ptr;
	char						protocol_name_ptr [255];
   	GnaT_Application_Comp*  	appl_comp_ptr = OPC_NIL;
   	GnaT_Application_Desc*  	appl_desc_ptr = OPC_NIL;
   	GnaT_ApType           		type_value;
   	GnaT_Nam_Appl*				nam_appl_ptr = OPC_NIL;
   	GnaT_Nam_Profile*			nam_profile_ptr = OPC_NIL;
   	GnaT_Custom_Desc*			cust_appl_ptr = OPC_NIL;
	GnaT_Email_Desc*			email_appl_ptr = OPC_NIL;
	GnaT_Dbase_Desc*			database_appl_ptr = OPC_NIL;
	GnaT_Video_Desc*			video_appl_ptr = OPC_NIL;
	GnaT_Ftp_Desc*				ftp_appl_ptr = OPC_NIL;
	GnaT_Rlogin_Desc*			rlogin_appl_ptr = OPC_NIL;
	GnaT_Print_Desc*			print_appl_ptr = OPC_NIL;
	GnaT_Voice_Desc*			voice_appl_ptr = OPC_NIL;
	GnaT_Http_Desc*				http_appl_ptr = OPC_NIL;
	void*						temp_appl_ptr = OPC_NIL;
	GnaT_Service*				serv_ptr;
	Ici*						ici_ptr;
	OmsPrT_Server_Entry* 		server_entry_ptr = OPC_NIL;	
	char						server_name [128];
	List*						server_list_ptr;
	char						msg[128];
	Objid						dest_preferences_objid;
	 
   	/** This function takes in a pointer to the profile and then searches **/
   	/** through it to find out if any symbolic names in the profile need  **/
   	/** to be replace by the actual names specified at the client. 		  **/
   	/** A structure is created for each application such as e-mail, ftp,  **/
   	/** or http. This structure holds a list of all profiles that make 	  **/
   	/** use of these applications, along with some other application- 	  **/
   	/** specific information. Each representative structure is inserted   **/
   	/** in an array, from which it can be retrieved based on the type 	  **/
   	/** of application. These application structures are passed to  	  **/
   	/** Application Manager (AM) so it can schedule the appropriate  	  **/
   	/** sessions.														  **/
   	FIN (gna_client_profile_parser (profile_ptr, dest_preferences_objid, same_lan_profile, lan_profile_index ))
	 
	/* Get destination preferences attribute object ID.	*/
	op_ima_obj_attr_get (my_objid, "Destination Preferences", &dest_preferences_objid);			
		
	/* Allocate memory for the new nam profile structure and fill it in. */
	nam_profile_ptr = (GnaT_Nam_Profile*) op_prg_mem_alloc (sizeof (GnaT_Nam_Profile));   
	nam_profile_ptr->profile_desc_ptr = profile_ptr;
	nam_profile_ptr->application_ptr = (GnaT_Nam_Appl **) op_prg_mem_alloc (profile_ptr->appl_row_count * sizeof (GnaT_Nam_Appl*));
	nam_profile_ptr->number_of_applications = profile_ptr->appl_row_count;
	nam_profile_ptr->profile_name_ptr = profile_ptr->profile_name_ptr;

	/* Loop through the applications specified for this profile */
   	for (i =0; i < profile_ptr->appl_row_count; i++)
		{
		appl_comp_ptr = profile_ptr->applications_ptr [i];
		appl_desc_ptr = appl_comp_ptr->application_ptr;

		/* Check to see if this profile uses any applications  */
		/* if (appl_desc_ptr->application_desc_ptr != OPC_NIL)	*/
		if (appl_desc_ptr != OPC_NIL)
			{
			/* Allocate memory for the NAM application structure and fill in info */
            nam_appl_ptr = (GnaT_Nam_Appl*) op_prg_mem_alloc (sizeof (GnaT_Nam_Appl));
            nam_appl_ptr->application_comp_ptr      = appl_comp_ptr;
            nam_appl_ptr->global_info_ptr           = global_information_ptr;
            nam_appl_ptr->stat_index                = -1;
            nam_appl_ptr->profile_name_ptr          = nam_profile_ptr->profile_name_ptr;
            nam_appl_ptr->wkstn_id                  = -1;
            nam_appl_ptr->lan_handle                = sess_lan_handle;;
            nam_appl_ptr->supported_sources_lptr 	= sources_lptr;
			nam_appl_ptr->application_row_index		= i;
			nam_appl_ptr->cpu_resource_handle 		= cpu_resource_hndl;
			nam_appl_ptr->job_table_handle			= job_table_hndl;
			nam_appl_ptr->invoked_from_clsvr_mgr	= OPC_FALSE;
			
			/* Read the type of application (ftp, email, http, etc ) */
			type_value = appl_desc_ptr->application_type;
				
			switch (type_value)
				{
				case GnaT_ApType_Custom:
					{				
					/* Parse various custom application parameters */
					gna_clsvr_mgr_custom_app_prepare (nam_appl_ptr, same_lan_profile, remote_invokation, lan_profile_index);			
					break;
					}
					 
				case GnaT_ApType_Dbase:
					{
					/* Get the transport protocol.	*/
					op_ima_obj_attr_get (transport_protocol_objid, "Database Transport", protocol_name_ptr);
					nam_appl_ptr->transport_protocol = (char *) op_prg_mem_alloc (strlen (protocol_name_ptr) * sizeof (char) + 1);
					strcpy (nam_appl_ptr->transport_protocol, protocol_name_ptr);

					/* Get the name of the symbolic server */
					database_appl_ptr = (GnaT_Dbase_Desc *) appl_desc_ptr->application_desc_ptr;				
					server_name_ptr = database_appl_ptr->symb_server_ptr;

					/* Set statistic index for couple <profile/application>.	*/
					nam_appl_ptr->stat_index = database_max_stat_index;
				
					/* Keep the same statistic index if the node is a lan.	*/
					if (same_lan_profile == OPC_FALSE)
						{
						database_max_stat_index ++;
						}
				
					/* Parse RSVP parameters.	*/
					nam_appl_ptr->rsvp_parameters_ptr = client_nam_rsvp_params_read (database_appl_ptr->rsvp_status, 
							database_appl_ptr->outbound_flow_ptr, database_appl_ptr->inbound_flow_ptr, GnaC_App_Type_Database);
					break;
					}
				
				case GnaT_ApType_Email:
					{
					/* Get the transport protocol.	*/
					op_ima_obj_attr_get (transport_protocol_objid, "Email Transport", protocol_name_ptr);
					nam_appl_ptr->transport_protocol = (char *) op_prg_mem_alloc (strlen (protocol_name_ptr) * sizeof (char) + 1);
					strcpy (nam_appl_ptr->transport_protocol, protocol_name_ptr);

					/* Get the name of the symbolic server */
					email_appl_ptr = (GnaT_Email_Desc *) appl_desc_ptr->application_desc_ptr;				
					server_name_ptr = email_appl_ptr->symb_server_ptr;

					/* Set statistic index for couple <profile/application>.	*/
					nam_appl_ptr->stat_index = email_max_stat_index;
				
					/* Keep the same statistic index if the node is a lan.	*/
					if (same_lan_profile == OPC_FALSE)
						{				
						email_max_stat_index ++;
						}
				
					/* Parse RSVP parameters.	*/
					nam_appl_ptr->rsvp_parameters_ptr = client_nam_rsvp_params_read (email_appl_ptr->rsvp_status, 
						email_appl_ptr->outbound_flow_ptr, email_appl_ptr->inbound_flow_ptr, GnaC_App_Type_Email_Send);
					break;
					}

				
				case GnaT_ApType_Ftp:
					{
					/* Get the transport protocol.	*/
					op_ima_obj_attr_get (transport_protocol_objid, "Ftp Transport", protocol_name_ptr);
					nam_appl_ptr->transport_protocol = (char *) op_prg_mem_alloc (strlen (protocol_name_ptr) * sizeof (char) + 1);
					strcpy (nam_appl_ptr->transport_protocol, protocol_name_ptr);
				
					/* Get the name of the symbolic server */
					ftp_appl_ptr = (GnaT_Ftp_Desc *) appl_desc_ptr->application_desc_ptr;				
					server_name_ptr = ftp_appl_ptr->symb_server_ptr;

					/* Set statistic index for couple <profile/application>.	*/
					nam_appl_ptr->stat_index = ftp_max_stat_index;
				
					/* Keep the same statistic index if the node is a lan.	*/
					if (same_lan_profile == OPC_FALSE)
						{				
						ftp_max_stat_index ++;
						}
				
					/* Parse RSVP parameters.	*/
					nam_appl_ptr->rsvp_parameters_ptr = client_nam_rsvp_params_read (ftp_appl_ptr->rsvp_status, 
							ftp_appl_ptr->outbound_flow_ptr, ftp_appl_ptr->inbound_flow_ptr, GnaC_App_Type_Ftp_Get);
					break;
					}   
				
				case GnaT_ApType_Http:
					{
					/* Get the transport protocol.	*/
					op_ima_obj_attr_get (transport_protocol_objid, "Http Transport", protocol_name_ptr);
					nam_appl_ptr->transport_protocol = (char *) op_prg_mem_alloc (strlen (protocol_name_ptr) * sizeof (char) + 1);
					strcpy (nam_appl_ptr->transport_protocol, protocol_name_ptr);
				
					/* Get the name of the symbolic server */
					http_appl_ptr = (GnaT_Http_Desc *) appl_desc_ptr->application_desc_ptr;	
				
					/* If this is HTTP, parse page description instead 		  */
					/* Header page is always the first one in the description */
					server_name_ptr = http_appl_ptr->page_desc_ptr [0]->location_server;
				
					/* Set statistic index for couple <profile/application>.	*/
					nam_appl_ptr->stat_index = http_max_stat_index;
				
					nam_appl_ptr->tcp_mtu = mtu_sv;
							   				
					/* Keep the same statistic index if the node is a lan.	*/
					if (same_lan_profile == OPC_FALSE)
						{
						http_max_stat_index ++;
						}
				
					/* Parse RSVP parameters.	*/
					nam_appl_ptr->rsvp_parameters_ptr = client_nam_rsvp_params_read (http_appl_ptr->rsvp_status, 
							http_appl_ptr->outbound_flow_ptr, http_appl_ptr->inbound_flow_ptr, GnaC_App_Type_Http);		
					break;
					}

				
				case GnaT_ApType_Rlogin:
					{
					/* Get the transport protocol.	*/
					op_ima_obj_attr_get (transport_protocol_objid, "Remote Login Transport", protocol_name_ptr);
					nam_appl_ptr->transport_protocol = (char *) op_prg_mem_alloc (strlen (protocol_name_ptr) * sizeof (char) + 1);
					strcpy (nam_appl_ptr->transport_protocol, protocol_name_ptr);
	
					/* Get the name of the symbolic server */
					rlogin_appl_ptr = (GnaT_Rlogin_Desc *) appl_desc_ptr->application_desc_ptr;				
					server_name_ptr = rlogin_appl_ptr->symb_server_ptr;

					/* Set statistic index for couple <profile/application>.	*/
					nam_appl_ptr->stat_index = rlogin_max_stat_index;
				
					/* Keep the same statistic index if the node is a lan.	*/
					if (same_lan_profile == OPC_FALSE)
						{
						rlogin_max_stat_index ++;
						}
				
					/* Parse RSVP parameters.	*/
					nam_appl_ptr->rsvp_parameters_ptr = client_nam_rsvp_params_read (rlogin_appl_ptr->rsvp_status, 
							rlogin_appl_ptr->outbound_flow_ptr, rlogin_appl_ptr->inbound_flow_ptr, GnaC_App_Type_Remote_Login);
					break;
					}
				
				case GnaT_ApType_Print:
					{
					/* Get the transport protocol.	*/
					op_ima_obj_attr_get (transport_protocol_objid, "Print Transport", protocol_name_ptr);
					nam_appl_ptr->transport_protocol = (char *) op_prg_mem_alloc (strlen (protocol_name_ptr) * sizeof (char) + 1);
					strcpy (nam_appl_ptr->transport_protocol, protocol_name_ptr);
				
					/* Get the name of the symbolic server */
					print_appl_ptr = (GnaT_Print_Desc*) appl_desc_ptr->application_desc_ptr;				
					server_name_ptr = print_appl_ptr->symb_server_ptr;

					/* Set statistic index for couple <profile/application>.	*/
					nam_appl_ptr->stat_index = print_max_stat_index;
				
					/* Keep the same statistic index if the node is a lan.	*/
					if (same_lan_profile == OPC_FALSE)
						{				
						print_max_stat_index ++;
						}
				
					/* Parse RSVP parameters.	*/
					nam_appl_ptr->rsvp_parameters_ptr = client_nam_rsvp_params_read (print_appl_ptr->rsvp_status, 
						print_appl_ptr->outbound_flow_ptr, print_appl_ptr->inbound_flow_ptr, GnaC_App_Type_Print);				
					break;
					}	
				
				case GnaT_ApType_Video:
					{
					/* Get the transport protocol.	*/
					op_ima_obj_attr_get (transport_protocol_objid, "Video Conferencing Transport", protocol_name_ptr);
					nam_appl_ptr->transport_protocol = (char *) op_prg_mem_alloc (strlen (protocol_name_ptr) * sizeof (char) + 1);
					strcpy (nam_appl_ptr->transport_protocol, protocol_name_ptr);

					/* Get the name of the symbolic server */
					video_appl_ptr = (GnaT_Video_Desc *) appl_desc_ptr->application_desc_ptr;				
					server_name_ptr = video_appl_ptr->symb_server_ptr;

					/* Set statistic index for couple <profile/application>.	*/
					nam_appl_ptr->stat_index = video_max_stat_index;
				
					/* Keep the same statistic index if the node is a lan.	*/
					if (same_lan_profile == OPC_FALSE)
						{
						video_max_stat_index++;
						}
				
					/* Parse RSVP parameters.	*/
					nam_appl_ptr->rsvp_parameters_ptr = client_nam_rsvp_params_read (video_appl_ptr->rsvp_status, 
							video_appl_ptr->outbound_flow_ptr, video_appl_ptr->inbound_flow_ptr, GnaC_App_Type_Video_Conferencing);				
					break;
					}
				
				case GnaT_ApType_Voice:
					{
					/* Get the transport protocol.	*/
					op_ima_obj_attr_get (transport_protocol_objid, "Voice Transport", protocol_name_ptr);
					nam_appl_ptr->transport_protocol = (char *) op_prg_mem_alloc (strlen (protocol_name_ptr) * sizeof (char) + 1);
					strcpy (nam_appl_ptr->transport_protocol, protocol_name_ptr);
				
					/* Get the name of the symbolic server */
					voice_appl_ptr = (GnaT_Voice_Desc *) appl_desc_ptr->application_desc_ptr;				
					server_name_ptr = voice_appl_ptr->symb_server_ptr;

					/* Set statistic index for couple <profile/application>.	*/
					nam_appl_ptr->stat_index = voice_max_stat_index;
				
					/* Keep the same statistic index if the node is a lan.	*/
					if (same_lan_profile == OPC_FALSE)
						{
						voice_max_stat_index++;
						}
					
			
					/* Parse RSVP parameters.	*/
					nam_appl_ptr->rsvp_parameters_ptr = client_nam_rsvp_params_read (voice_appl_ptr->rsvp_status, 
							voice_appl_ptr->outbound_flow_ptr, voice_appl_ptr->inbound_flow_ptr, GnaC_App_Type_Voice);
					break;
					}
					
				default:
					{
					/* Application type is unknown.	*/
					gna_client_nam_error ("Application type is unknown", "", "");
					break;
					}
			   }
			
			/* Get mappings between symbolic and real destinations */
			if (type_value != GnaT_ApType_Custom) 
				gna_client_actual_servers_parse (dest_preferences_objid, server_name_ptr, nam_appl_ptr);						
			
			nam_profile_ptr->application_ptr [j] = nam_appl_ptr;
			j++;
			}
		else
			{
			/* This application is not defined.	*/
			nam_profile_ptr->number_of_applications--;

			/* A notification log has already been written when parsing	*/
			/* profile in profile configuration object.					*/
			}	  
		}
	FRET (nam_profile_ptr);
	}

static void
gna_client_actual_servers_parse (Objid symbolic_objid, char* server_name_ptr, GnaT_Nam_Appl* nam_appl_ptr)
	{								 
	int 						name_count;
	int							symbolic_count;
	int							count;
	Objid 						temp_objid;
	Objid						actual_names_comp_objid;
	char						temp_name [255];
	char						temp_symb_name [255];
	double						total_weight = 0.0;
	GnaT_Application_Server*	server_ptr = OPC_NIL;
   
	/* This function parses the names of the real destinations which replace */
	/* the symbolic server names at each client. These real destinations are */
	/* added to the AM application structure.								*/
	FIN (gna_client_actual_servers_parse (symblolic_objid, server_name_ptr, nam_appl_ptr));

	/* Find the number of the symbolic bindings */
	symbolic_count = op_topo_child_count (symbolic_objid, OPC_OBJTYPE_GENERIC);				
  
	/* Loop through each symbolic binding and get all bindings to the real destination names */
	for (name_count = 0; name_count < symbolic_count; name_count++)
		{
		temp_objid = op_topo_child (symbolic_objid, OPC_OBJTYPE_GENERIC, name_count);
		op_ima_obj_attr_get (temp_objid, "Symbolic Name", temp_symb_name);
	
		/* An entry is found for a specified symbolic name */
		if (!strcmp (temp_symb_name, server_name_ptr))
			{												  		 
			op_ima_obj_attr_get (temp_objid, "Actual Name", &actual_names_comp_objid);
			
			nam_appl_ptr->server_count = op_topo_child_count (actual_names_comp_objid, OPC_OBJTYPE_GENERIC);
			
			/* Before allocating memory for actual server names, make sure that	*/
			/* There is at least one actual server name defined for the			*/
			/* symbolic server name.											*/
			if (nam_appl_ptr->server_count != 0)
				{
				nam_appl_ptr->appl_servers_ptr = (GnaT_Application_Server**) op_prg_mem_alloc 
					(nam_appl_ptr->server_count * sizeof (GnaT_Application_Server*));
				}
			
			/* Get attributes of the real destinations */
			for (count = 0; count < nam_appl_ptr->server_count; count++)
			    {
				temp_objid = op_topo_child (actual_names_comp_objid, OPC_OBJTYPE_GENERIC, count);
									  
				/* Allocate memory for the structure which holds info about */
				/* real destination servers.								*/
				server_ptr = (GnaT_Application_Server*) 
				  op_prg_mem_alloc (sizeof (GnaT_Application_Server));
														  					  
				op_ima_obj_attr_get (temp_objid, "Name", temp_name);
				server_ptr->server_name = (char *) op_prg_mem_alloc (strlen (temp_name) + 1);
				strcpy (server_ptr->server_name, temp_name);
				op_ima_obj_attr_get (temp_objid, "Selection Weight", &server_ptr->selection_weight);
												
				/* Calculate the total weight*/
				total_weight += server_ptr->selection_weight;
				
				/* Insert servers info structure into the profile structure, which later */
				/* will get inserted into the AM structure.							     */
				nam_appl_ptr->appl_servers_ptr [count] = server_ptr;
				}

			/* Normalize the weights on the servers */
			for (count = 0; count < nam_appl_ptr->server_count; count++)
			    {
				nam_appl_ptr->appl_servers_ptr [count]->selection_weight = 
				  nam_appl_ptr->appl_servers_ptr [count]->selection_weight/total_weight;
				}
									  
			break;
			}
		}

	FOUT;
	}

static void
gna_nam_profiles_start (int profile_index)
	{
	int 			ith_profile_index;
	int				code;
	double 			start_time;
	int				starting_index;
	int			  	max_profile_index;

	FIN (gna_nam_profiles_start (profile_index));

	/* If no profiles have been defined in the client, no profile	*/
	/* manager will be spawned.										*/
	if (nam_profiles_ptr != OPC_NIL)
		{
		
		/* Go through the loop only once if the specific profile index */
		/* is specified 											   */
		if (profile_index != All_Profiles)
			{
			starting_index = profile_index;
			max_profile_index = profile_index + 1;
			}
		else
			{
			starting_index = 0;
			max_profile_index = nam_profiles_ptr->number_of_profiles;
			}
			
		for (ith_profile_index = starting_index; ith_profile_index < max_profile_index; ith_profile_index++)
			{
			/* Determine start time for this profile if this profile is defined. */
			if (nam_profiles_ptr->profile_ptr [ith_profile_index] != OPC_NIL)
				{				  
				if (nam_profiles_ptr->profile_ptr [ith_profile_index]->longevity == Kill_Immediately)
					  start_time = 0.0;
				  else
					  start_time = oms_dist_outcome (nam_profiles_ptr->profile_ptr [ith_profile_index]->profile_desc_ptr->start_time_dist_handle);				  				  
				  
				/* Make sure start time is less then sim_duration */
				if (start_time < sim_duration)
					{
					/* Set the interrupt code equal to the profile index */
					code = ith_profile_index;  										
					
					/* Schedule interrupt for the beginnning of the profile */
					op_intrpt_schedule_self (current_sim_time  + start_time, code);

					/* Determine the number of repetitions of this profile */
					if (nam_profiles_ptr->profile_ptr [ith_profile_index]->profile_desc_ptr->number_of_repetitions_dist_handle != OPC_NIL)
						{
						nam_profiles_ptr->profile_ptr [ith_profile_index]->rep_index = 
							(int) oms_dist_outcome (nam_profiles_ptr->profile_ptr [ith_profile_index]->profile_desc_ptr->number_of_repetitions_dist_handle) + 1;	
						}
					else
						{
						/* This means that the number of repetitions is infinite.	*/
						nam_profiles_ptr->profile_ptr [ith_profile_index]->rep_index = OPC_INT_INFINITY;
						}
					}
				}						
			}
		}

	FOUT;
	}


static void
gna_next_profile_schedule (int code)
	{
	double 				profile_duration = 0.0;
	double 				interepetition_time = 0.0;
	double				next_profile_intrpt_time = 0.0;
	GnaT_Nam_Profile*	cur_profile_ptr = OPC_NIL;
	int					interrupt_end_code;
   
	FIN (gna_next_profile_schedule ());
	
	/* Get the correct type of profile based on the code */	
	cur_profile_ptr = nam_profiles_ptr->profile_ptr [code];
  
	/* Check if the number of repetitions of this profile has not been exceeded */
	if (cur_profile_ptr->rep_index > 0)
		{    
		/* Calculate the intrpt code for destroying the profile */
		interrupt_end_code = GNAC_PROFILE_END_OFFSET  + code; 
						  
		/* Set profile duration depending of whether this profile is remotely invoked or not */
		if (cur_profile_ptr->longevity != Kill_Immediately)
			{
			if (cur_profile_ptr->profile_desc_ptr->duration_dist_handle != OPC_NIL)
				{
				profile_duration = oms_dist_outcome (cur_profile_ptr->profile_desc_ptr->duration_dist_handle);								
				}
			else
				{
				profile_duration = sim_duration;								
				}
			/* Schedule the end of this profile */
			op_intrpt_schedule_self (current_sim_time  + profile_duration, interrupt_end_code);
			}
		else
			{
			/* If the profile was invoked, then its end time is already */
			/* represented by remote_end_time.							*/
			profile_duration = remote_end_time;		   
			}
		
		/* Set the duration of this profile */
		cur_profile_ptr->profile_duration = profile_duration;
			   	 
		/* Reduce the rep index */
		cur_profile_ptr->rep_index--;
	  
		/* Calculate the start of the next profile if this is Concurrent Mode */
		if ((cur_profile_ptr->profile_desc_ptr->repetition_pattern == GnaT_RepType_Concurrent) &&
			(cur_profile_ptr->rep_index > 0))																		   
			{		   
			/* Calculate the duration of interepetition time */
			interepetition_time = oms_dist_outcome (cur_profile_ptr->profile_desc_ptr->inter_repetition_dist_handle);
		 
			next_profile_intrpt_time = current_sim_time  + interepetition_time;  
		 
			/* Schedule a self interrupt for the beginning of the next profile */
			/* if it is within the duration of the simulation.			     */
			if (next_profile_intrpt_time < sim_duration)
				{
				op_intrpt_schedule_self (next_profile_intrpt_time, code); 
				}
			}
		}
	FOUT;
	}

static void
gna_profile_spawn (int code)
	{
	GnaT_Nam_Profile*					cur_profile_ptr = OPC_NIL;
	Prohandle 							profile_mngr_handle;
	GnaT_Nam_Profile_Shared_Mem*		shared_memory_ptr; 

	/* This function takes an interrupt code as an input and */
	/* spawns a corresponding profile manager.				*/
	FIN (gna_profile_spawn (code));
	 
	/* Get the correct type of profile based on the code */
	cur_profile_ptr = nam_profiles_ptr->profile_ptr [code];
	
	if (cur_profile_ptr->longevity == Kill_Immediately)
		{
		cur_profile_ptr->invoked_remotely = OPC_TRUE;	   
		}	
	else
  		cur_profile_ptr->invoked_remotely = OPC_FALSE;

	/* Create the shared memory with the profile manager.	*/
	shared_memory_ptr = (GnaT_Nam_Profile_Shared_Mem*) op_prg_mem_alloc (sizeof (GnaT_Nam_Profile_Shared_Mem));
	shared_memory_ptr->profile_information_ptr = cur_profile_ptr;
   
	/* Create a new child process for the profile manager */
	profile_mngr_handle = op_pro_create ("gna_profile_mgr", shared_memory_ptr);	
	 
	/* Invoke profile manager */
	op_pro_invoke (profile_mngr_handle, OPC_NIL);

	FOUT;
	}


static void
gna_profile_destroy (int code)
	{
	int	 	 				profile_index;
	GnaT_Nam_Profile*		cur_profile_ptr = OPC_NIL;
	double 					profile_duration = 0.0;
	double 					interepetition_time = 0.0;
	double					next_profile_intrpt_time = 0.0;
	int						active_size;
	int						i;
	Enabled_Profiles_Desc*	profile_desc_ptr;
	int*					disabled_profile_index_ptr = OPC_NIL;
	

	/** This function takes an interrupt code as an input and   **/
	/** destroys the profile which corresponds to the interrupt **/
	/** code. In addition, if the repetition mode for that      **/
	/** profile is serial, a beggining of a new profile is      **/
	/** scheduled, as the old profile is destroyed.			   **/
	FIN (gna_profile_destroy (intrpt_code));
   
	/*Calculate the index of the profile to be destroyed */ 
	profile_index = code - GNAC_PROFILE_END_OFFSET;
		
	/* Schedule the next profile if this is Serial mode */
	cur_profile_ptr = nam_profiles_ptr->profile_ptr [profile_index];
		
  	if (cur_profile_ptr->longevity == Kill_Immediately)
		{
		/* Remove the name from the active profiles list */
		if (active_profiles_lptr != OPC_NIL)
			{						
			active_size = op_prg_list_size (active_profiles_lptr);
			for (i = 0; i < active_size; i++)
				{
				profile_desc_ptr = (Enabled_Profiles_Desc *) op_prg_list_access (active_profiles_lptr, i);
				if (!strcmp (profile_desc_ptr->profile_name_ptr, cur_profile_ptr->profile_name_ptr))
					{
					disabled_profile_index_ptr = (int*) op_prg_mem_alloc (sizeof (int));
					*disabled_profile_index_ptr = profile_desc_ptr->local_profile_index;
					op_prg_list_insert (disabled_profiles_lptr, disabled_profile_index_ptr, OPC_LISTPOS_TAIL);
					
					profile_desc_ptr = (Enabled_Profiles_Desc *) op_prg_list_remove (active_profiles_lptr, i);
					op_prg_mem_free (profile_desc_ptr);
					break;
					}
				}
			}		
		}
			   
	/* Check if the number of repetitions of this profile has not exceeded */
  else if ((cur_profile_ptr->rep_index > 0) && 
		(cur_profile_ptr->profile_desc_ptr->repetition_pattern == GnaT_RepType_Serial))
		{    
		/* Calculate the duration of interepetition time */
		interepetition_time = oms_dist_outcome (cur_profile_ptr->profile_desc_ptr->inter_repetition_dist_handle);

		/* Calculate the start of the next profile if this is Serial Mode*/
		next_profile_intrpt_time = current_sim_time  + interepetition_time;
			
		/* Schedule a self interrupt for the beginning of the next profile */
		/* if it is within the duration of the simulation.			     */
		if (next_profile_intrpt_time < sim_duration)
			{	   
			op_intrpt_schedule_self (next_profile_intrpt_time, profile_index);
			}
		}

	FOUT;
	}
	

void
gna_passive_video_client_spawn ()
	{
	Ici*					ici_ptr = OPC_NIL;
	Prohandle				video_prohndl;
	char					protocol [10];
	
	/** Spawns a new gna_cli process in passive mode. Currently	**/
	/** the only application that uses this effectivly is the	**/
	/** "Voice" application.									**/
	FIN (gna_passive_video_client_spawn ());

	/* Create an ICI for service registration. */
	ici_ptr = op_ici_create ("tpal_serv_reg");
	if (ici_ptr == OPC_NIL)
		{
		gna_client_nam_error ("Unable to create ICI for service registration.", "", "");
		}

	/* Get the transport protocol.	*/
	op_ima_obj_attr_get (transport_protocol_objid, "Video Conferencing Transport", protocol);
	
	/* Set the service parameters. */
	if (op_ici_attr_set (ici_ptr, "Protocol", protocol) == OPC_COMPCODE_FAILURE ||
	op_ici_attr_set (ici_ptr, "Service Name", GNAC_APP_VIDEO) == OPC_COMPCODE_FAILURE ||
	op_ici_attr_set (ici_ptr, "Port", Video) == OPC_COMPCODE_FAILURE ||
	op_ici_attr_set (ici_ptr, "Popularity", 10.0) == OPC_COMPCODE_FAILURE)
		{
		gna_client_nam_error ("Unable to set ICI attributes for video application registration.", "", "");
		}
			
	/* The server type is communicated to TPAL. TPAL uses this information  */
	/* during server selection. This is mainly used to avoid call loopbacks */
	/* in a stand alone node.												*/
	if (op_ici_attr_set (ici_ptr, "Server Type", TpalC_Standalone_Server) == OPC_COMPCODE_FAILURE) 
		{
		gna_client_nam_error ("Unable to set ICI attribute Server Type during voice application registration.", "", "");
		}

	/* Issue the registration command to tpal */
	op_ici_install (ici_ptr);
	op_intrpt_force_remote (TPALC_CMD_SERV_REG, my_tpal_objid);

	/* We're done with the service registration ICI. */
	op_ici_destroy (ici_ptr);

	/* Create a gna_cli process and get the process handle	*/
	video_prohndl = op_pro_create ("gna_video_called_mgr", called_video_client_shared_mem_ptr);
	if (op_pro_valid (video_prohndl) == OPC_FALSE)
		{
		gna_client_nam_error ("Unable to create client process.", "", "");
		}
		
	/* Tag the process being spawned for debugging purposes */
	op_pro_tag_set (video_prohndl, "Passive");

	/*  Invoke the GNA Client process for initialization.  Pass the client session info */
	if (op_pro_invoke (video_prohndl, &my_tpal_objid) == OPC_COMPCODE_FAILURE)
		gna_client_nam_error ("Unable to invoke client session process for initialization.", "", "");

	FOUT;
	}

void
gna_passive_voice_client_spawn ()
	{
	Ici*					ici_ptr = OPC_NIL;

	Prohandle				voice_prohndl;
	char					protocol [10];
	
	/** Spawns a new gna_cli process in passive mode. Currently	**/
	/** the only application that uses this effectivly is the	**/
	/** "Voice" application.									**/
	FIN (gna_passive_client_spawn ());

	/* Create an ICI for service registration. */
	ici_ptr = op_ici_create ("tpal_serv_reg");
	if (ici_ptr == OPC_NIL)
		{
		gna_client_nam_error ("Unable to create ICI for service registration.", "", "");
		}
	
	/* Get the transport protocol.	*/
	op_ima_obj_attr_get (transport_protocol_objid, "Voice Transport", protocol);
	
	/* Set the service parameters. */
	if (op_ici_attr_set (ici_ptr, "Protocol", protocol) == OPC_COMPCODE_FAILURE ||
	op_ici_attr_set (ici_ptr, "Service Name", GNAC_APP_VOICE) == OPC_COMPCODE_FAILURE ||
	op_ici_attr_set (ici_ptr, "Port", Voice) == OPC_COMPCODE_FAILURE ||
	op_ici_attr_set (ici_ptr, "Popularity", 10.0) == OPC_COMPCODE_FAILURE)
		{
		gna_client_nam_error ("Unable to set ICI attributes for voice application registration.", "", "");
		}
			
	/* The server type is communicated to TPAL. TPAL uses this information  */
	/* during server selection. This is mainly used to avoid call loopbacks */
	/* in a stand alone node.												*/
	if (op_ici_attr_set (ici_ptr, "Server Type", TpalC_Standalone_Server) == OPC_COMPCODE_FAILURE) 
		{
		gna_client_nam_error ("Unable to set ICI attribute Server Type during voice application registration.", "", "");
		}

	/* Issue the registration command to tpal */
	op_ici_install (ici_ptr);
	op_intrpt_force_remote (TPALC_CMD_SERV_REG, my_tpal_objid);

	/* We're done with the service registration ICI. */
	op_ici_destroy (ici_ptr);

	/* Create a voice client process and get the process handle	*/
	voice_prohndl = op_pro_create ("gna_voice_called_mgr", called_voice_client_shared_mem_ptr);
	if (op_pro_valid (voice_prohndl) == OPC_FALSE)
		gna_client_nam_error ("Unable to create client process.", "", "");
		
	/* Tag the process being spawned for debugging purposes */
	op_pro_tag_set (voice_prohndl, "Passive");

	/*  Invoke the GNA Client process for initialization.  Pass the client session info */
	if (op_pro_invoke (voice_prohndl, &my_tpal_objid) == OPC_COMPCODE_FAILURE)
		gna_client_nam_error ("Unable to invoke client session process for initialization.", "", "");

	FOUT;
	}

void
app_intrpt_dispatch (void)
    {
    Ici*                    ici_ptr;
    GnaT_Cli_Mgr_Session*   sess_ptr = OPC_NIL;

    /** Dispatch this interrupt to the appropriate child process.   **/
    /** All communication with TPAL is handled by the child         **/
    /** processes.  am will process the self-interrupts, and the    **/
    /** remote interrupts, while the remainder will be dispatched.  **/
    FIN (app_intrpt_dispatch ());

    /*  Get the session record pointer from the accompanying ICI.   */
    /*  All interrupts destined for the GNA client process would    */
    /*  an associated ICI.  The Application ID holds the session    */
    /*  record pointer.                                             */
    ici_ptr = op_intrpt_ici ();
    if (ici_ptr == OPC_NIL ||
        op_ici_attr_get (ici_ptr, "Application ID", &sess_ptr) == OPC_COMPCODE_FAILURE ||
        sess_ptr == OPC_NIL)
        {
        gna_client_nam_error ("Unable to get application ID from ICI accompanying interrupt.", "", "");
        FOUT;
        }

    /*  Invoke the session process using the process handle from    */
    /*  the session record.                                         */
    if (op_pro_invoke (sess_ptr->prohndl, OPC_NIL) == OPC_COMPCODE_FAILURE)
        gna_client_nam_error ("Could not invoke session process to handle received interrupt.", "", "");
    
    FOUT;
    }

static Boolean
nam_app_mcast_addr_validate (IpT_Address ip_grp_addr)
	{
	int			addr_int_component_1 = IP_ADDRESS_COMPONENT (ip_grp_addr,0);
	int			addr_int_component_2 = IP_ADDRESS_COMPONENT (ip_grp_addr,1);
	int			addr_int_component_3 = IP_ADDRESS_COMPONENT (ip_grp_addr,2);
	Boolean		status=OPC_FALSE;

	/** Validates the given multicast address. A valid		**/
	/** application layer multicast address is a Class D	**/
	/** address, which lies between 224.0.1.0 and			**/
	/** 239.255.255.255. Class D addresses between 224.0.0.0**/
	/** and 224.0.0.255 are reserved						**/
	FIN (nam_app_mcast_addr_validate (ip_grp_addr));

	/* The multicast address is valid if the 1st component	*/
	/* is greater than 224, or if the 2nd component is 		*/
	/* greater than 0, or if atleast the 3rd component is	*/
	/* greater than 0										*/
	if ((addr_int_component_1 > 224) || 
		(addr_int_component_2 > 0)	 ||
		(addr_int_component_3 > 0))
		{
		status = OPC_TRUE;
		}

	FRET (status);
	}


static void
gna_multicast_addresses_register ()
	{
	Objid				multicast_spec_comp_attr_objid, ip_objid;
	Objid				supported_entry_objid, i_th_app_objid, mcast_addr_contents_objid;
	int					num_mcast_applications, record_handle_list_size, i_th_app;
	int					index, count;
	List*				proc_record_handle_list_ptr;
	OmsT_Pr_Handle		temp_process_record_handle;
	char				address [32];
	Ici*				mcast_join_ici_ptr;
	Ici*				mcast_leave_ici_ptr;
	IpT_Address			supported_mcast_addr;
	double				joining_time;
	List*				ip_intf_table_lptr;
	IpT_Interface_Info*	ip_table_ptr;
	List**				list_pptr;
	int					application_port;
	double				leaving_time;
	

	/** Register multicast addresses for voice and video application.	**/
	/** This client will join some multicasting groups at specified		**/
	/** time and will be able to receive multicasting traffic.			**/
	FIN (gna_multicast_addresses_register ());
	
	/* The following code is used to obtain the ip module's interface	*/
	/* table needed to initialize this process.							*/

	/* Obtain the process record handle of the ip process residing in the local node.	*/
	proc_record_handle_list_ptr = op_prg_list_create ();
	oms_pr_process_discover (OPC_OBJID_INVALID,		proc_record_handle_list_ptr,
		"node objid", 		OMSC_PR_OBJID, 			my_node_id,
		"protocol", 		OMSC_PR_STRING, 		"ip",
		OPC_NIL);
	
	/* Obtain simulation duration */
	sim_duration = gna_sim_duration_get (OPC_FALSE);

	/* An error should be generated if there are more than one ip processes	*/
	/* in the local node.													*/
	record_handle_list_size = op_prg_list_size (proc_record_handle_list_ptr);
	if (record_handle_list_size > 1)
		{
		op_sim_end ("Error: Several ip processes found in the local node.", "", "", "");
		}

	/* It is also possible that there is no IP process in this node. In this	*/
	/* case the record_handle_list_size will be zero. Attempt to read			*/
	/* the list only if the size is 1 (the surrounding node contains IP).		*/
	else if (record_handle_list_size == 1)
		{
		/* Obtain IP's process record handle.	*/
		temp_process_record_handle = (OmsT_Pr_Handle) op_prg_list_access (proc_record_handle_list_ptr, OPC_LISTPOS_HEAD);

		/* Get the Objid of the IP module.		*/
		oms_pr_attr_get (temp_process_record_handle, 
			"module objid",		OMSC_PR_OBJID,		&ip_objid,
			OPC_NIL);
		
		/* Get the IP interface table	*/
		oms_pr_attr_get (temp_process_record_handle,
						"address",			OMSC_PR_ADDRESS,	&list_pptr,
						OPC_NIL);
		
		ip_intf_table_lptr = *list_pptr;
		
		if ((ip_intf_table_lptr != OPC_NIL) && (op_prg_list_size (ip_intf_table_lptr) > 0))
			{
			ip_table_ptr = (IpT_Interface_Info*) op_prg_list_access (ip_intf_table_lptr, OPC_LISTPOS_HEAD);
					
			mtu_sv = ip_table_ptr->mtu - 40; 
			}
		else
			{
			/* This is an unconnected node. No need to do	*/
			/* anything more.								*/
			FOUT;
			}
		}

	/* Read the registered multicast list, and register the addresses. */
	op_ima_obj_attr_get (my_objid, "Multicasting Specification", &multicast_spec_comp_attr_objid);
	num_mcast_applications = op_topo_child_count (multicast_spec_comp_attr_objid, OPC_OBJTYPE_GENERIC);

	/* If the surrounding node is a non-IP node, then multicasting is	*/
	/* not supported. Ignore any multicasting specification.			*/
	if (record_handle_list_size != 1)
		{
		/* Setting the multicast application count to zero will have	*/
		/* the effect of ignoring any multicast traffic generation.		*/
		num_mcast_applications = 0;
		}
	else
		{
		/* Go over the list, parse each of them and finally register them   */
		/* in the IP-wide attribute database.								*/
		for (i_th_app = 0; i_th_app < num_mcast_applications; i_th_app++)
			{
			/* Obtain the i_th specification.   */
			i_th_app_objid = op_topo_child (multicast_spec_comp_attr_objid, OPC_OBJTYPE_GENERIC, i_th_app);
	 
			/* Parse the supported source address information.	*/
			op_ima_obj_attr_get (i_th_app_objid, "Membership Addresses", &mcast_addr_contents_objid);
			op_ima_obj_attr_get (i_th_app_objid, "Joining Time", &joining_time);
			
			/* Parse the Leaving Time along with the Join time */
			op_ima_obj_attr_get (i_th_app_objid, "Leaving Time", &leaving_time);
			
			/* Parse the supported application port information along with the address information */
			op_ima_obj_attr_get (i_th_app_objid, "Application Name", &application_port);
			
			count = op_topo_child_count (mcast_addr_contents_objid, OPC_OBJTYPE_GENERIC);
			for (index = 0; index < count; index++)
				{
				supported_entry_objid = op_topo_child (mcast_addr_contents_objid, OPC_OBJTYPE_GENERIC, index);
				op_ima_obj_attr_get (supported_entry_objid, "Supported Multicast Addresses", address);
				supported_mcast_addr = ip_address_create (address);

				/* Validate the multicast address								*/
				if ((ip_address_is_multicast (supported_mcast_addr) == OPC_TRUE) &&
					(nam_app_mcast_addr_validate (supported_mcast_addr) == OPC_TRUE) &&
					(application_port != IP_MCAST_NO_PORT))
					{
					/** The address is a valid application layer multicast address	**/
	
					/* Create an ICI -- the destruction of this ICI will be handled	*/
					/* by the receiving process (i.e., IP).							*/
					/* create an ici for joining the multicast group, and create	*/
					/* one for leaving.												*/
					mcast_join_ici_ptr = op_ici_create ("ip_rte_req_v4");
					mcast_leave_ici_ptr = op_ici_create ("ip_rte_req_v4");

					/* Set the fields of the ICI for joining the group				*/
					op_ici_attr_set (mcast_join_ici_ptr, "multicast_major_port", 0);
					op_ici_attr_set (mcast_join_ici_ptr, "multicast_minor_port", 0);					
					op_ici_attr_set (mcast_join_ici_ptr, "multicast_group_address", supported_mcast_addr);					
					op_ici_attr_set (mcast_join_ici_ptr, "type", IpC_Rte_Mcast_Ici);					
					op_ici_attr_set (mcast_join_ici_ptr, "mcast_type", IpC_Igmp_Host_Join_Req);
					op_ici_attr_set (mcast_join_ici_ptr, "multicast_application_port", application_port);
					

					/* Set the fields of the ICI for leaving the group				*/
 					op_ici_attr_set (mcast_leave_ici_ptr, "multicast_major_port", 0);
					op_ici_attr_set (mcast_leave_ici_ptr, "multicast_minor_port", 0);
					op_ici_attr_set (mcast_leave_ici_ptr, "multicast_group_address", supported_mcast_addr);
					op_ici_attr_set (mcast_leave_ici_ptr, "type", IpC_Rte_Mcast_Ici);
					op_ici_attr_set (mcast_leave_ici_ptr, "mcast_type", IpC_Igmp_Host_Leave_Req);
					op_ici_attr_set (mcast_leave_ici_ptr, "multicast_application_port", application_port);
					

					/* If the joining time occurs before the leaving time, then		*/
					/* everything is normal, and proceed to register the multicast	*/
					/* address.  However, if the leave time occurs before the join	*/
					/* time, then don't join or leave this multicast address and	*/
					/* print an error message in the simulation log.				*/
					if (joining_time < leaving_time)
						{
					
						/* If the join time for this multicast group is set for before	*/
						/* the simulation ends, then schedule an interrupt with the IP	*/
						/* module at the joining time.  If the join time for this		*/
						/* multicast group is set for after the simulation ends, then	*/
						/* don't schedule an interrupt, and put an error message in		*/
						/* simulation log.												*/
						if (joining_time < sim_duration)
							{
							/* Install the joining multicast ICI	*/
							op_ici_install (mcast_join_ici_ptr);

							/* Register this multicast address with IP module */
							op_intrpt_schedule_remote (joining_time, 0, ip_objid);
					
							/* Deinstall the ICI	*/
							op_ici_install (OPC_NIL);
					

							/* If the leave time for this multicast group is set for	*/
							/* before the simulation ends, then schedule an interrupt	*/
							/* with the IP module at the leave time.  If the leave time	*/
							/* for this group is set for after the simulation ends, then*/
							/* don't schedule an interrupt.								*/
							if (leaving_time < sim_duration)
								{
								/* Install the leaving multicast ICI */
								op_ici_install (mcast_leave_ici_ptr);
					
								/* Deregister this multicast address with IP module */
								op_intrpt_schedule_remote (leaving_time, 0, ip_objid);
					
								/* Deinstall the ICI	*/
								op_ici_install (OPC_NIL);					
								}
							}
						else
							{
							/* Invalid join time given to join this multicast address		*/
						
							/* Report a log message and don't join the multicast address	*/
							gna_mcast_join_time_invalid_log_write (address, joining_time);
							}
						}
					else
						{
						/* Leave time specified occurs before join time, so don't join		*/
						/* or leave this multicast address.									*/
						
						/* Report a log message and don't join or leave the mcast address	*/
						gna_mcast_leave_time_invalid_log_write (address, leaving_time);
						}
					}
				else
					{
					/** Invalid application layer multicast address				**/

					/* Report a log message and don't register the multicast address	*/
					gna_mcast_addr_invalid_log_write (address);
					}
				}
			}
		}

	FOUT;
    }

static GnaT_Rsvp_Config_Params*
client_nam_rsvp_params_read (Boolean rsvp_status, char* outbound_flow_ptr, char* inbound_flow_ptr, int type_of_request)
	{
	GnaT_Rsvp_Config_Params*	rsvp_params_ptr;
	GnaT_Rsvp_Profile_Tspec*	tspec_defs_ptr;
	List*						rsvp_all_profile_list_ptr;

	/** Obtains  RSVP Parameters from the interface.					**/
	/** The parameters are stored in session_info_ptr data structure.	**/
	FIN (client_nam_rsvp_params_read (rsvp_status, outbound_flow_ptr, inbound_flow_ptr, type_of_request));

	/* Only if RSVP is enabled, read RSVP parameters. 	*/
	/* Otherwise set them to OPC_NIL and return.		*/
	if (rsvp_status == OPC_FALSE)
		{
		/** RSVP Parameters were not configured.	**/

		FRET (OPC_NIL);
		}
	else
		{
		/** RSVP Parameters were configured.	**/
		
		/* Allocate memory for RSVP Parameters. This data structure will be 		*/
		/* later inserted into ICI sent to TPAL.									*/
		rsvp_params_ptr = (GnaT_Rsvp_Config_Params *) op_prg_mem_alloc (sizeof (GnaT_Rsvp_Config_Params));

		if (rsvp_params_ptr == OPC_NIL)
			{
			/* Write a simulation log and abort the simulation.	*/
			gna_client_nam_error ("Unable to allocate memory for RSVP parameters", "", "");
			}

		/* Search the database to find traffic parameters based on profile name for outbound flow.	*/
		tspec_defs_ptr = (GnaT_Rsvp_Profile_Tspec *) oms_data_def_entry_access ("RSVP Flow Specification", outbound_flow_ptr);

		if (tspec_defs_ptr == OPC_NIL)
			{
			/** There is no matching traffic specification profile.		**/
			
			/* Set the traffic parameters to have the default values.	*/
			tspec_defs_ptr = (GnaT_Rsvp_Profile_Tspec *) oms_data_def_entry_access ("RSVP Flow Specification", "Tspec_Std_Dft");
			
			if (tspec_defs_ptr == OPC_NIL)
				{
				/** The database does not have entry for RSVP Flow Specification.				**/
				/** This implies that no QoS Configuration object is present in the network.	**/
				/** Write a log message and ignore RSVP Parameters.								**/
				rsvp_app_no_qos_config_object_log ();
				
				FRET (OPC_NIL);
				}
			
			/* Write a notification message to inform the user	*/
			/* about the missing flow specification.			*/
			rsvp_app_no_tspec_profile_log (outbound_flow_ptr);
			}
		
		/* Set TSPEC in RSVP parameters.			*/
		rsvp_params_ptr->out_tspec_ptr = tspec_defs_ptr->tspec_ptr;

		/* Search the database to find traffic parameters based on profile name for inbound flow.	*/
		tspec_defs_ptr = (GnaT_Rsvp_Profile_Tspec*) oms_data_def_entry_access ("RSVP Flow Specification", inbound_flow_ptr);

		if (tspec_defs_ptr == OPC_NIL)
			{
			/** There is no matching traffic specification profile.		**/
						
			/* Set the traffic parameters to have the default values.	*/
			tspec_defs_ptr = (GnaT_Rsvp_Profile_Tspec*) oms_data_def_entry_access ("RSVP Flow Specification", "Tspec_Std_Dft");

			/* Write a notification message to inform the user	*/
			/* about the missing flow specification.			*/
			rsvp_app_no_tspec_profile_log (inbound_flow_ptr);
			}

		/* Set TSPEC in RSVP parameters.			*/
		rsvp_params_ptr->in_tspec_ptr = tspec_defs_ptr->tspec_ptr;

		/* Read RSVP supported profiles for all applications.	*/
		rsvp_all_profile_list_ptr = rsvp_app_sup_profile_read (my_objid);

		/* Get profile for this application.	*/
		rsvp_params_ptr->profile_list_ptr = rsvp_app_profile_list_get (rsvp_all_profile_list_ptr, type_of_request);

		/* Return RSVP parameters to insert into ICI when opening TPAL connection.	*/
		FRET (rsvp_params_ptr);
		}
	}

static void 
gna_nam_supported_sources_parse ()
    {
	Objid		symbolic_objid;
	Objid		temp_objid;		 
	int			i;
	int			symbolic_count;
	char		temp_symb_name [256];
	char*		supported_source;

	FIN (gna_custom_mgr_supported_sources_parse ());
		
	op_ima_obj_attr_get (my_objid, "Source Preferences", &symbolic_objid);
	
	/* Find the number of the symbolic bindings */
	symbolic_count = op_topo_child_count (symbolic_objid, OPC_OBJTYPE_GENERIC);		
	
	/* Initiate state list pointer to supported sources at this node */
	sources_lptr = op_prg_list_create ();

	for (i = 0; i < symbolic_count; i++)
	  {	
		temp_objid = op_topo_child (symbolic_objid, OPC_OBJTYPE_GENERIC, i);
		op_ima_obj_attr_get (temp_objid, "Symbolic Name", temp_symb_name);		
		supported_source = (char *) op_prg_mem_alloc (strlen (temp_symb_name) + 1);
		strcpy (supported_source, temp_symb_name);		
		op_prg_list_insert (sources_lptr, supported_source, OPC_LISTPOS_TAIL);
	  }
	FOUT;
	}


static void
gna_client_nam_error (const char* msg1, const char* msg2, const char* msg3)
	{
	/** Generates an error and exits simulation.	**/
	FIN (gna_client_nam_error (msg1, msg2, msg3));

	op_sim_end ("Error in client nam process:", msg1, msg2, msg3);

	FOUT;
	}


static Boolean
gna_client_object_is_lan (void)
	{
	List*				proc_record_handle_list_ptr;
	int					record_handle_list_size = 0;
	Boolean				lan_node;
	
	/** Return whether object is lan or not.	**/
	FIN (gna_client_object_is_lan (void));

	/* Initialize variable.	*/
	lan_node = OPC_FALSE;
	
	/*	Find out node type from model wide 		*/
	/*	process registry. Obtain the process	*/
	/* 	record handle of the lan module that 	*/
	/*	resides in the local node. 				*/
	proc_record_handle_list_ptr = op_prg_list_create ();
	oms_pr_process_discover (OPC_OBJID_INVALID, proc_record_handle_list_ptr, 
				"node objid",		OMSC_PR_OBJID,		my_node_id,
				"node_type",		OMSC_PR_STRING,		"lan_mac",
				OPC_NIL);
				
	record_handle_list_size = op_prg_list_size (proc_record_handle_list_ptr);
				
	if (record_handle_list_size != 0)
		{
		/*	This is a lan node.Call procedure from the LLM package to assign 	*/
		/*	workstation identifier on which this session 	*/
		/*	is opened.										*/
		/* llm_random_wkstn_id_assign (sess_lan_handle, &sess_wkstn_id);*/

		/*	This is a lan node.												*/	
		/*	Record the workstation id in the global variable which will		*/
		/*	be used to find out the workstion id assigned to the latest		*/
		/* 	session.														*/
		lan_node = OPC_TRUE;
		}
					
	/* Deallocate the list pointer. */
	op_prg_mem_free (proc_record_handle_list_ptr);

	FRET (lan_node);
	}

/* $llm$ */
static void
gna_llm_init ()
	{
	List*						proc_record_handle_list_ptr;
	int							record_handle_list_size = 0;
	OmsT_Pr_Handle				temp_process_record_handle;
	double						wkstn_count;

	FIN (gna_llm_init ());

	/*	Initialize workstation identifier and 	*/
	/*	the flag that represents this node as 	*/
	/*	a LAN node.								*/
	sess_wkstn_id = LlmC_Unspec_Wkstn_Id;
	last_wkstn_id = 0;
   
	/*	Find out the total number of workstation in this LAN node from model	*/
	/*	wide process registry. First find out the process handle for the		*/
	/*	LAN process.															*/
	proc_record_handle_list_ptr = op_prg_list_create ();
	oms_pr_process_discover (OPC_OBJID_INVALID, proc_record_handle_list_ptr, 
			"node_type", 	OMSC_PR_STRING, 	"lan_mac", 
			"node objid",	OMSC_PR_OBJID,		my_node_id, 
			OPC_NIL);
	
	/*	Obtain the list size of the discovered processes.						*/
	record_handle_list_size = op_prg_list_size (proc_record_handle_list_ptr);

	if (record_handle_list_size != 0)
		{
		/* Get lan handle.	*/
		sess_lan_handle = llm_lan_handle_get (my_node_id);	
		
		temp_process_record_handle = (OmsT_Pr_Handle) 
			op_prg_list_access (proc_record_handle_list_ptr, OPC_LISTPOS_HEAD);

		/* 	Obtain total number of workstations in this LAN node. Server id		*/
		/*	is same as total number of workstations.							*/
		oms_pr_attr_get (temp_process_record_handle, "wkstn count", OMSC_PR_NUMBER, &wkstn_count);
		number_of_wkstns = (int)wkstn_count;
		node_is_lan = OPC_TRUE;
		
		/* 	Deallocate no longer needed process registry information.			*/
		while (op_prg_list_size (proc_record_handle_list_ptr))
			op_prg_list_remove (proc_record_handle_list_ptr, OPC_LISTPOS_HEAD);
	
		op_prg_mem_free (proc_record_handle_list_ptr);

		}
	else
		{
		/*	If the list size is zero then that means the process model's module	*/
		/*	resides in a multiple MAC type LAN model (i.e. the node model does	*/
		/*	contain an llm_mac module, but the llm client and server sit over	*/
		/*	the top of a regular IP router). In these models the total number	*/
		/*	of workstations is defined as an extended attribute of the client	*/
		/*	module, and renamed as "Number of Workstations" at the node level.	*/		
		/*	Retrieve the value of this attribute.								*/
		/*op_ima_obj_attr_get (my_objid, "Number of Workstations", &number_of_wkstns);*/
		number_of_wkstns = 1;
		node_is_lan = OPC_FALSE;		
		}
	
	FOUT;
	}

static int
gna_clsvr_mgr_find_smallest_profile_index (void)
	{
	int						active_profile_list_size;
	int						disabled_profiles_list_size;
	int						profile_index;
	int						min_profile_index = 0;
	int*					temp_profile_index;
	int						removing_list_index = 0;
	Boolean					match_found = OPC_FALSE;
	
	FIN (gna_clsvr_mgr_find_smallest_profile_index (void));
	
	if (active_profiles_lptr != OPC_NIL)
		{
		active_profile_list_size = op_prg_list_size (active_profiles_lptr);
		disabled_profiles_list_size = op_prg_list_size (disabled_profiles_lptr);
		
		/* Initialize min_profile_index */
		min_profile_index = active_profile_list_size - 1;
				
		removing_list_index = disabled_profiles_list_size - 1;
			
		/* Loop through all enabled profiles */
		for (profile_index = 0; profile_index < disabled_profiles_list_size; profile_index++)
			{
			temp_profile_index = (int *) op_prg_list_access (disabled_profiles_lptr, profile_index);
						
			if (*temp_profile_index < min_profile_index)
				{
				min_profile_index = *temp_profile_index;
				removing_list_index = profile_index;
				match_found = OPC_TRUE;
				}				
			}
		/* Remove the index from the list of disabled profiles */
		if ((disabled_profiles_list_size > 0) &&
			(match_found == OPC_TRUE))
			{
			temp_profile_index = (int *) op_prg_list_remove (disabled_profiles_lptr, removing_list_index);
			op_prg_mem_free (temp_profile_index);
			}
		}
	FRET (min_profile_index);
	}



/***** Error handling functions. *****/	
static void
gna_clsvr_mgr_warn (const char* msg1)
	{
	/** Print a warning message and resume. **/
	FIN (gna_clsvr_mgr_warn (msg1));
	
	op_prg_odb_print_major ("Warning from GNA client-server application manager (gna_clsvr_mgr):", msg1, OPC_NIL, OPC_NIL, OPC_NIL);
    
	FOUT;
	}

static void
gna_clsvr_mgr_error (const char* msg1)
	{
	/** Prints an error message and exit simulation.	**/
	FIN (gna_clsvr_mgr_error (msg1));
	
	op_sim_end ("Error in GNA client-server application manager (gna_clsvr_mgr):", msg1, OPC_NIL, OPC_NIL);
	
	FOUT;
	}


/* End of Function Block */

/* Undefine optional tracing in FIN/FOUT/FRET */
/* The FSM has its own tracing code and the other */
/* functions should not have any tracing.		  */
#undef FIN_TRACING
#define FIN_TRACING

#undef FOUTRET_TRACING
#define FOUTRET_TRACING

#if defined (__cplusplus)
extern "C" {
#endif
	void bt_gna_clsvr_mgr (void);
	Compcode bt_gna_clsvr_mgr_init (void **);
	void bt_gna_clsvr_mgr_diag (void);
	void bt_gna_clsvr_mgr_terminate (void);
	void bt_gna_clsvr_mgr_svar (void *, const char *, char **);
#if defined (__cplusplus)
} /* end of 'extern "C"' */
#endif




/* Process model interrupt handling procedure */


void
bt_gna_clsvr_mgr (void)
	{
	int _block_origin = 0;
	FIN (bt_gna_clsvr_mgr ());
	if (1)
		{
		/* Interrupt handling variables.	*/
		int						intrpt_code = OPC_INT_INVALID;
		int						intrpt_type = OPC_INT_INVALID;
		int						sess_type = OPC_INT_INVALID;
		Ici*					ici_ptr = OPC_NIL;
		Evhandle				evh;
		List*					resp_size_lptr = OPC_NIL;
		double					pk_size = OPC_DBL_INVALID;
		double					service_time = OPC_DBL_INVALID;
		double					service_overhead = OPC_DBL_INVALID;
		int						i, list_size;
		int						index = OPC_INT_INVALID;
		int						recompute = 0;
		int						command = OPC_INT_INVALID;
		int						echo = OPC_INT_INVALID;
		int						response_count = OPC_INT_INVALID;
		double					response_size = OPC_DBL_INVALID;
		GnaT_Application_Type	app_type;	
		Packet*					response_pk_ptr = OPC_NIL;
		char					msg [512];
		Packet*					pk_ptr = OPC_NIL;
		GnaT_Service*			serv_ptr = OPC_NIL;
		GnaT_Serv_Session*		sess_ptr = OPC_NIL;
		GnaT_Job*				job_ptr = OPC_NIL;
		Boolean 				job_completion_recomputation_required = OPC_FALSE;
		Boolean					further_processing_required = OPC_FALSE;
		GnaT_Cli_Mgr_Session*	cli_sess_ptr = OPC_NIL;
		GnaT_Cli_Mgr_Session* 	temp_sess_ptr = OPC_NIL;
		char*					server_address_ptr = OPC_NIL;
		char*					profile_name = OPC_NIL;
		int						active_size = OPC_INT_INVALID;
		Boolean					Profile_Enabled = OPC_FALSE;
		char*					temp_prof_name = OPC_NIL;
		GnaT_Profile_Desc* 		profile_desc_ptr = OPC_NIL;
		int						profile_number = OPC_INT_INVALID;
		GnaT_Nam_Profile**		temp_profile_ptr = OPC_NIL;
		char*					active_profile_ptr = OPC_NIL;
		double*					temp_size = OPC_NIL;
		Boolean					Wait_To_Arrival = OPC_TRUE;
		double					response_delay = OPC_DBL_INVALID;
		Prohandle*				read_in_prohandle_ptr = OPC_NIL;
		char*					temp_name = OPC_NIL;
		int						type_of_request = GnaC_Unspec;
		double					cur_sim_time = OPC_DBL_INVALID;
		int						cur_session_jobs = OPC_INT_INVALID;
		Boolean					service_already_open;
		GnaT_Service*			temp_serv_ptr;
		int						open_service_index;
		
		Queued_Object_Desc*				queued_object_ptr;
		Queued_Object_Desc*				inline_object_ptr;
		int	   							serv_index;
		OmsT_Dt_Key						session_key;
		GnaT_Cli_Mgr_Session*			session_ptr = OPC_NIL;
		Boolean							Page_Over;
		int								cli_command;
		int								mgr_command;
		int								signal_command;
		Key_Desc*						key_info_ptr;
		List*							temp_sessions_lptr;	
		Ici*							cli_ici_ptr = OPC_NIL;
		GnaT_Pending_Job*				pend_job_ptr;
		Enabled_Profiles_Desc*			enabled_profile_ptr = OPC_NIL;
		int								number_of_jobs;
		int								job;
		OmsT_Resource_Job_Id			job_id;
		int								profile_repetition_index;
		int								appl_row_index;
		int								repetition_index;
		GnaT_Ace_Task_Rec*				task_record_ptr;
		Ici*							intrpt_iciptr;
		int								new_profile_index;
		int								smallest_available_profile_index;
		int								max_profile_index;
		GnaT_App_Stat_Info*				app_info_ptr;
		List*							clsvr_hndl_lptr;
		Ici*							ace_req_ici_ptr;
		Prohandle*						ace_task_mgr_hndl_ptr;
		Prohandle*						ace_task_cli_hndl_ptr;
		Prohandle						ace_task_cli_hndl;
		GnaT_Ace_Conn_Info*				ace_conn_info_ptr;
		int								ace_next_proc_step;
		int								ace_listening_port;
		GnaT_Ace_Clsvr_Cli_Info*		clsvr_to_ace_cli_argmem_ptr;
		char*							ace_stat_annotation_str;
		int								pkt_id;
		Boolean							run_custom_app;
		


		FSM_ENTER (bt_gna_clsvr_mgr)

		FSM_BLOCK_SWITCH
			{
			/*---------------------------------------------------------*/
			/** state (wait) enter executives **/
			FSM_STATE_ENTER_UNFORCED (0, state0_enter_exec, "wait", "bt_gna_clsvr_mgr () [wait enter execs]")
				{
				}


			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (1,bt_gna_clsvr_mgr)


			/** state (wait) exit executives **/
			FSM_STATE_EXIT_UNFORCED (0, "wait", "bt_gna_clsvr_mgr () [wait exit execs]")
				{
				/** The server process can be operating in two modes, depending on	**/
				/** whether it supports the Custom MTA service.						**/
				/**  1. Support MTA: In this mode, it can be acting as a server (to	**/
				/**     model remote client to server transactions) or as a client	**/
				/**     session manager to to manage spawned client processes which	**/
				/**     communicate with other servers.								**/
				/**  2. Does not support MTA: Only acts as server. Here it just		**/
				/**     provides service back to the source end clients. There		**/
				/**     exists session for each of the remote clients.				**/
				
				/* Get the current simulation time */
				current_sim_time = op_sim_time ();
				
				/*	Check for an ODB trace label.			*/
				trace_active = op_prg_odb_ltrace_active ("gna") || op_prg_odb_ltrace_active ("client_server");
				
				/*	Get interrupt parameters.				*/
				intrpt_type = op_intrpt_type ();
				
				if (intrpt_type != OPC_INTRPT_STRM)
					{
					intrpt_code = op_intrpt_code ();
					}
				else
					{
					intrpt_code = NASC_INVALID;
					}
				
				/* We want to go to Arrival state from Wait state in all cases 	*/
				/* except when this a video or voice session.					*/
				Wait_To_Arrival = OPC_TRUE;
				
				switch (intrpt_type)
					{
					case OPC_INTRPT_PROCESS:
					case OPC_INTRPT_SELF:
					case OPC_INTRPT_ENDSIM:
					  /* Do nothing. */
					  break;
				
					case OPC_INTRPT_REMOTE:
					case OPC_INTRPT_STRM:
						{
						/* Extract the session information from this interrupt.	*/
						/* The lower layer (or a client process spawned by this	*/
						/* server) installs this information in the ICI 		*/
						/* associated with this interrupt.						*/
						ici_ptr = op_intrpt_ici ();
						if ((ici_ptr == OPC_NIL) ||
							(op_ici_attr_get (ici_ptr, "Application ID", 	&sess_ptr)  == OPC_COMPCODE_FAILURE) 	||
							(op_ici_attr_get (ici_ptr, "Sess Type",      	&sess_type) == OPC_COMPCODE_FAILURE)	||
							(op_ici_attr_get (ici_ptr, "Application Type",  &app_type)  == OPC_COMPCODE_FAILURE))
							{
							gna_clsvr_mgr_error ("Unable to get session information from ICI.");
							}
						
						/* Check if this interrupt is for the case when this	*/
						/* server process is acting as the manager for spawned	*/
						/* client processes (to talk to other client/server		*/
						/* processes)											*/
						if (((sess_type == GNAC_SESSION_TYPE_ACTIVE)) ||
							((app_type == GnaC_App_Type_Video_Conferencing) && (intrpt_code != TPALC_EV_IND_OPEN)) ||
							((app_type == GnaC_App_Type_Voice) 				&& (intrpt_code != TPALC_EV_IND_OPEN)) ||
							(app_type == GnaC_App_Type_Ace))
							{
							/* Even when the server is acting as the manager,	*/
							/* it handles two cases where the interrupt is for	*/
							/* itself (i.e., the server):						*/
							/*  1. A session termination (this interrupt is		*/
							/*     scheduled by the managed client.)			*/
							/*  2. Modeling request time delay (again this is	*/
							/*     scheduled by the managed client) -- this		*/
							/*     facilitates modeling of the server busy		*/
							/*     condition for modelign the request delays.	*/
						   
							if ((intrpt_code == GNAC_IND_SESS_OPEN_FAILED) || (intrpt_code == GNAC_IND_SESS_CLOSED) 
								|| (intrpt_code == GNAC_MODEL_REQUEST_TIME))
								{
								/* Do nothing. The transition conditions will	*/
								/* figure out how to transition.				*/
								cli_sess_ptr = (GnaT_Cli_Mgr_Session *) sess_ptr;
								}
							else
								{
								/* Invoke the session process using the process	*/
								/* handle from the session record.				*/
								cli_sess_ptr = (GnaT_Cli_Mgr_Session *) sess_ptr;
								
								/* Check whether the client process is still alive.	*/
								if (cli_sess_ptr != OPC_NIL)
									{
									if (op_pro_valid (cli_sess_ptr->prohndl) == OPC_TRUE)
										{
										if (op_pro_invoke (cli_sess_ptr->prohndl, OPC_NIL) == OPC_COMPCODE_FAILURE)
											{
											gna_clsvr_mgr_error ("Could not invoke session process to handle received interrupt.");
											}
										}
									}
								else
									{
									/* Process model doesn't exist any more.	*/
									if (intrpt_type == OPC_INTRPT_STRM)
										{
										/* If interrupt is stream interrupt, destroy packet.	*/
										op_pk_destroy (op_pk_get (op_intrpt_strm ()));
										}
									}
				
								/* Reset the interrupt codes to avoid any	*/
								/* transition condition errors.				*/
								intrpt_type = NASC_INVALID;
								intrpt_code = NASC_INVALID;
								
								/* If this is a video or voice session, do not go into arrival */
								/* state.													   */
								if ((app_type == GnaC_App_Type_Video_Conferencing) ||
									(app_type == GnaC_App_Type_Voice))
									{
									Wait_To_Arrival = OPC_FALSE;
									}
								}
							}
						
						break;
						}
				
					default:
						{
						gna_clsvr_mgr_error ("Received unexpected interrupt in wait state.");
						break;
						}
					}
				}


			/** state (wait) transition processing **/
			FSM_INIT_COND (OPEN_IND)
			FSM_TEST_COND (CLOSE_IND)
			FSM_TEST_COND (SVC_COMPL)
			FSM_TEST_COND (PROFILE_START)
			FSM_TEST_COND (PROFILE_DESTROY)
			FSM_TEST_COND (REMOTE_PROFILE)
			FSM_TEST_COND (RTRV_COMPLETE)
			FSM_TEST_COND (ARRIVAL)
			FSM_TEST_COND (CLIENT_CLOSED)
			FSM_TEST_COND (ACE_REQ)
			FSM_DFLT_COND
			FSM_TEST_LOGIC ("wait")

			FSM_TRANSIT_SWITCH
				{
				FSM_CASE_TRANSIT (0, 3, state3_enter_exec, ;, "OPEN_IND", "", "wait", "open")
				FSM_CASE_TRANSIT (1, 4, state4_enter_exec, ;, "CLOSE_IND", "", "wait", "close")
				FSM_CASE_TRANSIT (2, 2, state2_enter_exec, ;, "SVC_COMPL", "", "wait", "svc_compl")
				FSM_CASE_TRANSIT (3, 6, state6_enter_exec, ;, "PROFILE_START", "", "wait", "spawn_profile")
				FSM_CASE_TRANSIT (4, 7, state7_enter_exec, ;, "PROFILE_DESTROY", "", "wait", "destroy_profile")
				FSM_CASE_TRANSIT (5, 8, state8_enter_exec, ;, "REMOTE_PROFILE", "", "wait", "remote_profile")
				FSM_CASE_TRANSIT (6, 9, state9_enter_exec, ;, "RTRV_COMPLETE", "", "wait", "rtrv_complete")
				FSM_CASE_TRANSIT (7, 11, state11_enter_exec, ;, "ARRIVAL", "", "wait", "arrival")
				FSM_CASE_TRANSIT (8, 10, state10_enter_exec, ;, "CLIENT_CLOSED", "", "wait", "client_closed")
				FSM_CASE_TRANSIT (9, 12, state12_enter_exec, ;, "ACE_REQ", "", "wait", "ace")
				FSM_CASE_TRANSIT (10, 0, state0_enter_exec, ;, "default", "", "wait", "wait")
				}
				/*---------------------------------------------------------*/



			/** state (start) enter executives **/
			FSM_STATE_ENTER_UNFORCED (1, state1_enter_exec, "start", "bt_gna_clsvr_mgr () [start enter execs]")
				{
				/* Obtain this module's object id */
				my_objid = op_id_self ();
				my_node_id = op_topo_parent (my_objid);
				
				/* Initialize all the state variables for this module.	*/
				gna_clsvr_mgr_sv_init ();
				
				/* Schedule a self-interrupt to allow:					*/
				/*   1. All ACE tiers (application processes) to spawn	*/
				/*      spawn passive connections.						*/
				/*   2. All Servers register their services.			*/
				evh = op_intrpt_schedule_self (op_sim_time (), GNAC_REGISTRATION_WAIT);
				
				/* Generate error if the lower layer synchronization event	*/
				/* event not be scheduled.									*/
				if (op_ev_valid (evh) == OPC_FALSE)
					gna_clsvr_mgr_error ("Unable to schedule self interrupt to initialize itself.");
				
				/* Read in the cache hit rate and store it for future use.		*/
				op_ima_obj_attr_get (op_id_self (), "Cache Hit Rate", &hit_rate_thresh);
				
				if (hit_rate_thresh >= 0.0)
					web_caching_enabled = OPC_TRUE;
				else
					web_caching_enabled = OPC_FALSE;
				
				/* Create the pending jobs list 							   	*/
				pending_job_lptr = op_prg_list_create ();
				
				/* Initialize server list */
				servers_lptr = op_prg_list_create (); 
				
				session_record_handle = oms_dt_table_create ("HTTP Session records", 1000); 
				
				/* Initialize a variable which indicates whether custom */
				/* application has already registered a passive session	*/
				custom_passive_session_registered = OPC_FALSE;
				
				/* Initialize cache counters.									*/
				cache_reqs = 0;
				cache_hits = 0;
				cache_misses = 0;
				global_cache_reqs = 0;
				global_cache_hits = 0;
				global_cache_misses = 0;
				
				/* Register cache statistics								 	*/
				CACHE_HIT_RATE_SH = op_stat_reg ("Cache.Hit Rate", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);
				CACHE_HIT_RATE_GSH = op_stat_reg ("Cache.Hit Rate", OPC_STAT_INDEX_NONE, OPC_STAT_GLOBAL);
				
				/* Create a list that will contain mapping	*/
				/* source object ID for voice application	*/
				/* and statistic index. Voice and video		*/
				/* statistics are collected on a per		*/
				/* source-dest basis and are annotated.		*/
				called_video_client_shared_mem_ptr = op_prg_list_create ();
				called_voice_client_shared_mem_ptr = op_prg_list_create ();
				
				/* Create a global list to store the ace tiers info */
				if (network_ace_tiers_lptr == OPC_NIL)
					network_ace_tiers_lptr = op_prg_list_create ();
				
				/* Register ACE tier information in the global list */
				gna_clsvr_mgr_ace_tiers_register ();
				
				/* Parse and store the Dest Prefs so that they can be used by ACE */
				ace_dest_prefs_ptr = gna_clsvr_mgr_dest_prefs_get ();
				}


			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (3,bt_gna_clsvr_mgr)


			/** state (start) exit executives **/
			FSM_STATE_EXIT_UNFORCED (1, "start", "bt_gna_clsvr_mgr () [start exit execs]")
				{
				/** Performs server initialization procedures.		**/
				
				/* Register multicasting groups.	*/
				gna_multicast_addresses_register ();
				
				/* Check for an ODB trace label.					*/
				trace_active = op_prg_odb_ltrace_active ("gna") || op_prg_odb_ltrace_active ("client_server");
				
				/* Initialize the service and session lists.		*/
				op_prg_list_init (&serv_list);
				op_prg_list_init (&sess_list);
				
				/* Activate the list of active profiles */
				active_profiles_lptr = op_prg_list_create ();
				disabled_profiles_lptr = op_prg_list_create ();
				
				/* Initialize variable which indicates whether 		*/
				/* statistics for custom application have been		*/
				/* registered at this node.							*/
				custom_stats_registered = OPC_FALSE;
				
				/* Initialize the values of the processing speeds	*/
				/* as "unspecified". These values checked against	*/
				/* when the services are added and will be used to	*/
				/* prevent specifying the same application more		*/
				/* than once.										*/
				for (i = 0; i < NASC_NUM_APPS; i++)
					{
					proc_speed [i] = NASC_PR_SPEED_UNSPEC;
					overhead_dist [i] = OPC_NIL;
					}
				
				/* Also get the max size of the segment that could be handed	*/
				/* the lower layer.												*/
				op_ima_obj_attr_get (my_objid, "Segment Size", &app_segment_size);
				
				
				/* Create and initialize the reassembly buffer which will hold the	*/
				/* application data segments till a complete application packet can	*/
				/* be created and processed.										*/
				reassembly_buf_handle = op_sar_buf_create (OPC_SAR_BUF_TYPE_REASSEMBLY, OPC_SAR_BUF_OPT_DEFAULT);
				
				/* Initialize Stats */
				
				SERV_NUM_SESS = op_stat_reg ("Server Performance.Load (tasks/sec)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);		
				
				/* This statistics represents the number of new jobs arrived at the server queue every second.	*/
				SERV_NUM_JOBS = op_stat_reg ("Server Performance.Load (requests/sec)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);		
				
				SERV_SERVICE_TIME = op_stat_reg ("Server Performance.Task Processing Time (sec)", OPC_STAT_INDEX_NONE, OPC_STAT_LOCAL);		
				
				/* Increment the number of total servers */
				nas_num_servers++;
				
				/*	Initialize server identifier.				*/
				server_id = 0;
				
				/*	Initialize session identifier.				*/
				sess_id = 0;
				
				/*	Initialize client session identifier.		*/
				client_sess_id = NASC_MAX_SESS_ID;
				
				/*	Initialize session list size.				*/
				sess_list_size = 0;
				
				/*	Initialize session list size.				*/
				cli_sess_list_size = 0;
				
				/* Get the current time.	*/
				cur_sim_time = op_sim_time ();
				
				/* If the size of the response packet is more than the maxomum segment size		*/
				/* chop the packet and send it as segments. Though it is a just matter of 		*/
				/* chopping the packets and reassembling them at the other end, we'll still use	*/
				/* the capabilities of the SAR package to make the code comprehensible.			*/
				segmentation_buf_handle = op_sar_buf_create (OPC_SAR_BUF_TYPE_SEGMENT, OPC_SAR_BUF_OPT_PK_BNDRY);
				
				/* Read in the configuration from the server configuration compound attribute. */
				gna_clsvr_mgr_conf_read ();
				
				/* Create an ICI for service registration. */
				ici_ptr = op_ici_create ("tpal_serv_reg");
				if (ici_ptr == OPC_NIL)
					gna_clsvr_mgr_error ("Unable to create ICI for service registration.");
				
				/* 	Get the lan handle if this is a LAN node.	*/
				gna_clsvr_mgr_serv_id_assign ();
				
				/* Get the number of services configured in server.	*/
				list_size = op_prg_list_size (&serv_list);
					
				/* Loop though all services and register them.	*/
				for (i = 0; i < list_size; i++)
					{
					/* Get the ith service.	*/
					serv_ptr = (GnaT_Service *) op_prg_list_access (&serv_list, i);
						
					if (serv_ptr != OPC_NIL)
						{
						/* If this node is a client, it has the capability of using		*/
						/* voice and video, and opening these services needs to be done	*/
						/* seperately from other services.  Check for these two			*/
						/* services individually.										*/
						switch (serv_ptr->port)
							{
							case Video:
								{
								/* Set flag indicating whether service is already open.	*/
								service_already_open = OPC_FALSE;
									
								/* Check whether the service has already been open before.	*/
								/* it might happen if "Light Video" and "Heavy Video" are	*/
								/* configured.												*/
								for (open_service_index = 0; open_service_index < i; open_service_index++)
									{
									/* Get the ith open service.	*/
									temp_serv_ptr = (GnaT_Service *) op_prg_list_access (&serv_list, open_service_index);				
							
									/* Check if a previous service has been opened with the	*/
									/* same transport protocol and some local port. If it	*/
									/* happens, do not open it again.						*/
									if ((strcmp (temp_serv_ptr->protocol, serv_ptr->protocol) == 0) &&
										(temp_serv_ptr->port == serv_ptr->port))
										{
										service_already_open = OPC_TRUE;
										break;
										}
									}
								if (!service_already_open)
									gna_passive_video_client_spawn ();
								}
								break;
												
							case Voice:
								{
								/* Set flag indicating whether service is already open.	*/
								service_already_open = OPC_FALSE;
									
								/* Check whether the service has already been open before.	*/
								/* it might happen if "Light Voice" and "Heavy Voice" are	*/
								/* configured.												*/
								for (open_service_index = 0; open_service_index < i; open_service_index++)
									{
									/* Get the ith open service.	*/
									temp_serv_ptr = (GnaT_Service *) op_prg_list_access (&serv_list, open_service_index);				
							
									/* Check if a previous service has been opened with the	*/
									/* same transport protocol and some local port. If it	*/
									/* happens, do not open it again.						*/
									if ((strcmp (temp_serv_ptr->protocol, serv_ptr->protocol) == 0) &&
										(temp_serv_ptr->port == serv_ptr->port))
										{
										service_already_open = OPC_TRUE;
										break;
										}
									}
								if (!service_already_open)				
									gna_passive_voice_client_spawn ();									
								}
								break;
							
							default:
								{
								/* Set the service parameters. */
								if (op_ici_attr_set (ici_ptr, "Protocol", serv_ptr->protocol) == OPC_COMPCODE_FAILURE ||
								op_ici_attr_set (ici_ptr, "Service Name", serv_ptr->name) == OPC_COMPCODE_FAILURE ||
								op_ici_attr_set (ici_ptr, "Port", serv_ptr->port) == OPC_COMPCODE_FAILURE ||
								op_ici_attr_set (ici_ptr, "Popularity", serv_ptr->pop) == OPC_COMPCODE_FAILURE)
									{
									gna_clsvr_mgr_error ("Unable to set ICI attributes for server registration.");
									}
				
								if (node_is_lan)
									{
									if (op_ici_attr_set (ici_ptr, "Server Type", TpalC_LLM_Server) == OPC_COMPCODE_FAILURE)
										{
										gna_clsvr_mgr_error ("Unable to set ICI attributes during application registration.");
										}
									}
								else
									{
									if (op_ici_attr_set (ici_ptr, "Server Type", TpalC_Standalone_Server) == OPC_COMPCODE_FAILURE)
										{
										gna_clsvr_mgr_error ("Unable to set ICI attributes during application registration.");
										}
									}
				
								/* Issue the registration command. */
								op_ici_install (ici_ptr);
								op_intrpt_force_remote (TPALC_CMD_SERV_REG, my_tpal_objid);
				
								/* Set flag indicating whether service is already open.	*/
								service_already_open = OPC_FALSE;
									
								/* Check whether the service has already been open before.	*/
								/* it might happen if "Light HTTP" and "Heavy HTTP" are		*/
								/* configured on server.									*/
								for (open_service_index = 0; open_service_index < i; open_service_index++)
									{
									/* Get the ith open service.	*/
									temp_serv_ptr = (GnaT_Service *) op_prg_list_access (&serv_list, open_service_index);				
							
									/* Check if a previous service has been opened with the	*/
									/* same transport protocol and some local port. If it	*/
									/* happens, do not open it again.						*/
									if ((strcmp (temp_serv_ptr->protocol, serv_ptr->protocol) == 0) &&
										(temp_serv_ptr->port == serv_ptr->port))
										{
										service_already_open = OPC_TRUE;
										break;
										}
									}
							
								/* Start a server session if service has not been opened before. */
								if (service_already_open == OPC_FALSE)
									{
									gna_clsvr_mgr_open (serv_ptr);
									}
								}
						
							break;
							}
						}
					}
					
				/* We're done with the service registration ICI. */
				op_ici_destroy (ici_ptr);
				
				/* Parse profiles and applications.	*/
				gna_client_params_parse ();
				
				
				
				}


			/** state (start) transition processing **/
			FSM_TRANSIT_FORCE (0, state0_enter_exec, ;, "default", "", "start", "wait")
				/*---------------------------------------------------------*/



			/** state (svc_compl) enter executives **/
			FSM_STATE_ENTER_FORCED (2, state2_enter_exec, "svc_compl", "bt_gna_clsvr_mgr () [svc_compl enter execs]")
				{
				/** This state marks the completion of a job that this server has been	**/
				/** processing. Next, it works on generating a response for the just	**/
				/** processed request. It also schedules processing of pending jobs, if	**/
				/** any. 																**/
				
				/* print debugging message, if enabled.	*/
				if (trace_active)
					op_prg_odb_print_major ("Job finished", OPC_NIL);
				
				/* Get an ici from the recource manager */
				ici_ptr = op_intrpt_ici ();
				
				/* Get session pointer from the ici installed by the resource package. */
				if ((ici_ptr == OPC_NIL) ||
					(op_ici_attr_get (ici_ptr, "job data", &sess_ptr) 	== OPC_COMPCODE_FAILURE) ||
					(op_ici_attr_get (ici_ptr, "job id", &job_id) 		== OPC_COMPCODE_FAILURE))			
				   {
				   gna_clsvr_mgr_error ("Unable to get session information from ICI.");
				   }
				
				if (sess_ptr == OPC_NIL)
					 gna_clsvr_mgr_error ("Unable to get completed session information from session list.");
				
				/* Get number of pending jobs for session.	*/
				number_of_jobs = op_prg_list_size (&sess_ptr->job_list);
				
				/* Loop thorugh the list of jobs and find the completed job.	*/
				for (job = 0; job < number_of_jobs; job ++)
					{
					/* Access ith job record.	*/
					job_ptr = (GnaT_Job *) op_prg_list_access (&sess_ptr->job_list, job);
					if (job_ptr == OPC_NIL)
						gna_clsvr_mgr_error ("Unable to get completed job from job list.");
					
					/* Check whether job IDs match.	*/
					if (Oms_Resource_Job_Id_Equal (job_id, job_ptr->job_id) == OPC_TRUE)
						{
						/* This job is completed.	*/
						break;
						}
					}
				
				/* Destroy job ID.	*/
				op_prg_mem_free (job_id);
				
				/* Destroy ICI */
				op_ici_destroy (ici_ptr);
				
				/* Get the type of request (entry or query) of received packet.	*/
				type_of_request = job_ptr->type_of_request;
				
				/* The session cleanup was unsuccessful and so the normal processing on	*/
				/* completion of the current job is started. This includes generating a */
				/* response packet if requested or scheduling remaining jobs in the list*/
				
				/* Install the ICI for the session. 									*/
				op_ici_install (sess_ptr->ici_ptr);
				
				/* If a response packet is to be sent, do so. The request				*/
				/* might require more than one response.If so, the additional			*/
				/* responses must be processed before the job is finished.				*/
				if (job_ptr->result != OPC_NIL)
					{
					/* Reserve the response packet. 									*/
					pk_ptr = job_ptr->result;
						
					/* If there is another response is required, create it and 			*/
					/* store in the job information data structure.			   			*/
					/* The response count always carries the remaning number of 		*/
					/* responses to be sent and so should be decremented if a 			*/
					/* response has been created and stored as the result.				*/
					if (job_ptr->resp_count-- > 0)
						{
						/* Store a copy of the first response as the second				*/
						/* response. The response is created as a copy in order 		*/
						/* to retain the stamp time of the request packet.				*/
						job_ptr->result = op_pk_copy (pk_ptr);
				
						/* Fetch the response size from the packet serviced. Use this 	*/
						/* response size for subsequent response packets also           */
						if (op_pk_nfd_get (pk_ptr, "response size", &response_size) == OPC_COMPCODE_FAILURE)
							gna_clsvr_mgr_error ("Unable to get response infomation field from received packet.");
				
						/* DB. if list of sizes is specified, use its values */
						if (job_ptr->resp_size_lptr != OPC_NIL)
							{
							if (op_prg_list_size (job_ptr->resp_size_lptr) > 0)
								{
								temp_size = (double *) op_prg_list_remove (job_ptr->resp_size_lptr, OPC_LISTPOS_HEAD);
								response_size = *temp_size * 8.0;				  
								op_prg_mem_free (temp_size);
								}
							}
				
						/* Set the size of the response packet. */
						op_pk_total_size_set (job_ptr->result, response_size);
							
						/* Compute the service time for this packet, unless	the application */
						/* is custom.														*/
						/* For custom application service time computation, see code below	*/
						app_info_ptr =  (GnaT_App_Stat_Info*) prg_string_hash_table_item_get (server_stats_hash_table_ptr, job_ptr->app_name);
						
						/* For custom application service time computation, see code below	*/
						if (app_info_ptr != OPC_NIL)
							{
							/* This is not custom application */
						if (job_ptr->app_type != GnaC_App_Type_Custom_Application)  
							{
								service_time = response_size / (app_info_ptr->processing_speed * 8.0);
							job_ptr->service_time = service_time;
							}
						else
							{
							/* This is custom application. Check whether cpu or explicit */
							/* processing times are used.								 */
							if (job_ptr->use_cpu_process_time == OPC_TRUE)
								{
									service_time = response_size / (app_info_ptr->processing_speed * 8.0);
								job_ptr->service_time = service_time;
								}
							}
							}
							
						/* Reset the last update time to the current time.				*/
						job_ptr->last_update_time = current_sim_time ;						
						}
					else
						{
						/* No more responses are required. this job is complete. 		*/
						job_ptr->result = OPC_NIL;
							
						/* Check to see if this is the last response count, and if yes, */
						/* and end marker is "Dispatch From Destination", interrupt the */
						/* source to tell it that phase is over.						*/
						if (job_ptr->end_marker == GnaC_Dispatch_From_Dest )
							{
							gna_custom_nam_mgr_notify (job_ptr->source_prohandle, 
													   job_ptr->task_index,
													   job_ptr->phase_index, 
													   GnaC_Custom_Remote_Destination);
							
							/* Reinstall the ici */
							op_ici_install (sess_ptr->ici_ptr);
							}
						}
				
					if (trace_active)
						op_prg_odb_print_minor ("Sending response", OPC_NIL);
				
				    response_size = op_pk_total_size_get (pk_ptr);
				
					/* Make sure response size is greater than 0 */
					if (response_size <= 0)
						{
						response_size = 16.0;
						
						/* Set the response packet size to be the request size */
						op_pk_total_size_set (pk_ptr, response_size);
						}
					
					
					/* Update the statistics for packets and bytes sent from this node	*/
					gna_clsvr_mgr_stats_update (job_ptr->app_type, job_ptr->app_name, Bytes_Sent, response_size/8.0, 0, type_of_request);
				
					/* Loop through to remove segments of the original application 		*/
					/* packet and send them out to the lower layer.						*/
					if (response_size > app_segment_size)
						{
						/* Insert the packet into the segmentation buffer and pull out 	*/
						/* segments of size specified by the attribute segment size.	*/
						op_sar_segbuf_pk_insert (segmentation_buf_handle, pk_ptr, 0);
				
						while (response_size > 0)
							{
							/* If the response size is greater than the maximum segment	*/
							/* size insert the big packet into the segmentation buffer 	*/
							/* and remove segments of size equal to the segment size. If*/
							/* the available number of bits is lesser than the segment	*/
							/* size, the remove will return only the remaining bit.		*/
							pk_ptr = op_sar_srcbuf_seg_remove (segmentation_buf_handle, app_segment_size);
				
							/* Update the pk_size remaining to reflect the reduced size.*/
							response_size -= app_segment_size;
				
							/* Update the packet count statistics.						*/		
							gna_clsvr_mgr_stats_update (job_ptr->app_type, job_ptr->app_name, Pkts_Sent, 1, 0, type_of_request);
				
							/*	Send the packet to TPAL, and on to the server. 			*/
							op_pk_send (pk_ptr, 0);
							}
						}
					else
						{
						/* The packet size is less than the segment size and can be 	*/
						/* sent without any segmentation on to the server. 				*/
						op_pk_send (pk_ptr, 0);			
				
						/* Update the packet count statistics.							*/		
						gna_clsvr_mgr_stats_update (job_ptr->app_type, job_ptr->app_name, Pkts_Sent, 1, 0, type_of_request);	
						}
					}
				
				/* If the job's complete, clean up. */
				if (job_ptr->result == OPC_NIL)
					{
					/* Deallocate response size list */
					if (job_ptr->resp_size_lptr != OPC_NIL)
						{
						
						while (op_prg_list_size (job_ptr->resp_size_lptr))
							op_prg_list_remove (job_ptr->resp_size_lptr, OPC_LISTPOS_HEAD);
						op_prg_mem_free (job_ptr->resp_size_lptr);
						
						/* Set the list pointer to indicate that it does not exist.	*/
						job_ptr->resp_size_lptr = OPC_NIL;
						}
					
					/* Obtain the jobs in the current server session. This would    */
					/* be useful to decide whether to send the CLOSE confirm if the */
					/* CLOSE CMD is received from the other side and no response is */
					/* required.                                                    */
					
					/* From the job list size obtain the current number of jobs */
					/* for the current server session.                          */
					cur_session_jobs =  op_prg_list_size (&sess_ptr->job_list);
				
				    /* If there is no pending job for the current session which has */
				    /* already received a CLOSE from the peer application, then send*/
				    /* the close confirmation packet to acknowledge the application */
				    /* close.                                                       */
					if (sess_ptr->appl_close_rcvd == OPC_TRUE &&
						(cur_session_jobs == 1 || job_ptr->command == TPALC_CMD_CLOSE))
				        {
				        gna_clsvr_mgr_close_packet_send (sess_ptr);
				        }
					
					/* Write out actual service time of this job, remove the job	*/
					/* record from the list and deallocate it.						*/
					op_stat_write (SERV_SERVICE_TIME, current_sim_time  - job_ptr->duration);
				
					/* Call the function to write the individual application server performance     */
					/* statistics. Here the statistics of concern is the Task Processing Time       */
					gna_clsvr_mgr_stats_update (job_ptr->app_type, job_ptr->app_name, Task_Proc_Time, current_sim_time  - job_ptr->duration, current_sim_time, type_of_request);	
					
					/* Remove job.	*/
					op_prg_list_remove (&sess_ptr->job_list, job);
					gna_clsvr_mgr_job_destroy (job_ptr);
					} 
				/* Job is not done yet. Schedule next job */
				else
					{
					/* Recompute the job scheduling time if the processing mode is Simulate Contention.		*/
					/* Insert the job into the processor	*/		   
					job_ptr->job_id = Oms_Resource_Job_Insert (cpu_resource_hndl, op_pro_self (),
											  sess_ptr, job_ptr->service_time);
					}
				
				
				
				
				
				
				
				}


			/** state (svc_compl) exit executives **/
			FSM_STATE_EXIT_FORCED (2, "svc_compl", "bt_gna_clsvr_mgr () [svc_compl exit execs]")
				{
				
				}


			/** state (svc_compl) transition processing **/
			FSM_TRANSIT_FORCE (0, state0_enter_exec, ;, "default", "", "svc_compl", "wait")
				/*---------------------------------------------------------*/



			/** state (open) enter executives **/
			FSM_STATE_ENTER_FORCED (3, state3_enter_exec, "open", "bt_gna_clsvr_mgr () [open enter execs]")
				{
				/** This state handles remote interrupt from the lower layer.	**/
				/** This interrupt could denote:								**/
				/**   1. Request from a remote client to connect to one of the	**/
				/**      services supported by this server,						**/
				/**   2. Open confirmation from the remote server (via the		**/
				/**      underlying networtk through this node's tranport		**/
				/**      protocol adaptation layer (TPAL) -- this case occurs	**/
				/**      only when this node supports Custom MTA				**/
				/**      and is an intermediate node in the transaction profile	**/
				/**      for the given specification.							**/
				/** When 1. occurs, we need to simply open a new "passive"		**/
				/** session so that new sessions may be accepted. In 2., there	**/
				/** is no need for this as the existing passive session is 		**/
				/** still intact.												**/
				
				/** This state is executed when a remote client tries to	**/
				/** connect to one of the services registered by this		**/
				/** client application node.								**/
				
				/* Check whether ODB trace is active.	*/
				trace_active = op_prg_odb_ltrace_active ("client_server");
					
				/* Update the number of tasks per second. */
				++no_of_act_sess;
				op_stat_write (SERV_NUM_SESS, no_of_act_sess);
													
				/* Call the function to update statistics   */
				/* for server performance of invidual appl. */
				/* The statitics of concern presently is    */
				/* the number of active sessions.           */
				gna_clsvr_mgr_stats_update (sess_ptr->app_type, sess_ptr->app_name, Num_Sess, (double)no_of_act_sess, 0, 0);;
					
				/* If it is a passive client, another passive client is		*/
				/* spawned in case another remote client wants to connect	*/
				/* also to one of the services registered by this passive	*/
				/* client.													*/
				
				if (sess_type == GNAC_SESSION_TYPE_PASSIVE)
					{
					/* Open another	instance of that service so the next 	*/
					/* client can connect too. 								*/
					if (trace_active)
						{
						op_prg_odb_print_major ("Remote Client Connected to Passive Client", OPC_NIL);
						op_prg_odb_print_major ("Spawn Another Passive Client", OPC_NIL);
						}
						
					cli_sess_ptr = (GnaT_Cli_Mgr_Session *) sess_ptr;
						
					/* Spawn a new passive video client to replace the one	*/
					/* in use.												*/
					if (app_type == GnaC_App_Type_Video_Conferencing)
						{
						gna_passive_video_client_spawn ();
						}
				
					/* Spawn a new passive voice client to replace the one	*/
					/* in use.												*/		
					if (app_type == GnaC_App_Type_Voice)
						{
				
						gna_passive_voice_client_spawn ();
						}
				
					/* Open another	instance of that service so the next client can connect again 		*/
					/* if different from voice or video or ACE application.For ACE, there is no 		*/
					/* passive session running by default. The ACE task mgr opens passive connections 	*/
					/* exactly at the time when it is necessary to setup connections between clients    */
					if ((app_type != GnaC_App_Type_Video_Conferencing) && (app_type != GnaC_App_Type_Voice) &&  (app_type != GnaC_App_Type_Ace))
						{
						/* Open another	instance of that service.	*/
						gna_clsvr_mgr_open (sess_ptr->serv_ptr);
						}
					}
				}


			/** state (open) exit executives **/
			FSM_STATE_EXIT_FORCED (3, "open", "bt_gna_clsvr_mgr () [open exit execs]")
				{
				}


			/** state (open) transition processing **/
			FSM_TRANSIT_FORCE (0, state0_enter_exec, ;, "default", "", "open", "wait")
				/*---------------------------------------------------------*/



			/** state (close) enter executives **/
			FSM_STATE_ENTER_FORCED (4, state4_enter_exec, "close", "bt_gna_clsvr_mgr () [close enter execs]")
				{
				/** The close state is invoked when the passive server session gets a 	**/
				/** close confirmation from the TPAL. The idea here is to remove all	**/
				/** the memory associated with current session so that the system does	**/
				/** run out of memory. 													**/
				
				/* This function would check if the session has to be terminated*/
				/* It does not terminate the session only if it is a scripted   */
				/* application session and there is a processing job yet to be  */
				/* completed. Anyhow it does not affect the performance of the  */
				/* system at all as the TPAL has already closed the connection  */
				gna_clsvr_mgr_session_cleanup (sess_ptr, job_completion_recomputation_required);	
				
				/* Destroy the indication ICI (created by TPAL)                 */
				if (ici_ptr != OPC_NIL)
					op_ici_destroy (ici_ptr);
				}


			/** state (close) exit executives **/
			FSM_STATE_EXIT_FORCED (4, "close", "bt_gna_clsvr_mgr () [close exit execs]")
				{
				
				}


			/** state (close) transition processing **/
			FSM_TRANSIT_FORCE (0, state0_enter_exec, ;, "default", "", "close", "wait")
				/*---------------------------------------------------------*/



			/** state (init) enter executives **/
			FSM_STATE_ENTER_UNFORCED (5, state5_enter_exec, "init", "bt_gna_clsvr_mgr () [init enter execs]")
				{
				/* The initialization of this process model relies on	*/
				/* the completion of initialization of lower layers.	*/
				if (lower_layer_init_intrpt_count < GNAC_LOWER_LAYER_INIT_INTRPT_COUNT)
					{	
					/* Schedule a self-interrupt to allow lower layers	*/
					/* to be configured.								*/
					evh = op_intrpt_schedule_self (0.0, GNAC_LOWER_LAYER_INIT_WAIT);
					
					/* Generate error if the lower layer synchronization event	*/
					/* event not be scheduled.									*/
					if (op_ev_valid (evh) == OPC_FALSE)
						gna_clsvr_mgr_error ("Unable to schedule self interrupt to wait for lower layer initialization.");
				
					/* Increment the count of initialization interrupts	*/
					/* observed.										*/
					lower_layer_init_intrpt_count++;
					}
				else
					{
					/* Schedule an interrupt to move on to performing	*/
					/* its own initialization.							*/
					evh = op_intrpt_schedule_self (op_sim_time (), GNAC_SELF_INIT_START);
				
					/* Generate error if the lower layer synchronization event	*/
					/* event not be scheduled.									*/
					if (op_ev_valid (evh) == OPC_FALSE)
						gna_clsvr_mgr_error ("Unable to schedule self interrupt to initialize itself.");
					
					/* Initialize the index used of identifying custom managers */
					global_custom_mgr_index = 0;
					}
				}


			/** blocking after enter executives of unforced state. **/
			FSM_EXIT (11,bt_gna_clsvr_mgr)


			/** state (init) exit executives **/
			FSM_STATE_EXIT_UNFORCED (5, "init", "bt_gna_clsvr_mgr () [init exit execs]")
				{
				/*	Get interrupt parameters.				*/
				intrpt_type = op_intrpt_type ();
				intrpt_code = op_intrpt_code ();
				}


			/** state (init) transition processing **/
			FSM_INIT_COND (INIT_COMPLETE)
			FSM_TEST_COND (INIT_WAIT)
			FSM_TEST_LOGIC ("init")

			FSM_TRANSIT_SWITCH
				{
				FSM_CASE_TRANSIT (0, 1, state1_enter_exec, ;, "INIT_COMPLETE", "", "init", "start")
				FSM_CASE_TRANSIT (1, 5, state5_enter_exec, ;, "INIT_WAIT", "", "init", "init")
				}
				/*---------------------------------------------------------*/



			/** state (spawn_profile) enter executives **/
			FSM_STATE_ENTER_FORCED (6, state6_enter_exec, "spawn_profile", "bt_gna_clsvr_mgr () [spawn_profile enter execs]")
				{
				/** Start application profile.	**/
				
				/* Schedule an interrupt for the next profile */
				gna_next_profile_schedule (intrpt_code);
				
				/* Start a profile manager for a profile which index matches the */
				/* interrupt code.												 */
				gna_profile_spawn (intrpt_code);
				}


			/** state (spawn_profile) exit executives **/
			FSM_STATE_EXIT_FORCED (6, "spawn_profile", "bt_gna_clsvr_mgr () [spawn_profile exit execs]")
				{
				}


			/** state (spawn_profile) transition processing **/
			FSM_TRANSIT_FORCE (0, state0_enter_exec, ;, "default", "", "spawn_profile", "wait")
				/*---------------------------------------------------------*/



			/** state (destroy_profile) enter executives **/
			FSM_STATE_ENTER_FORCED (7, state7_enter_exec, "destroy_profile", "bt_gna_clsvr_mgr () [destroy_profile enter execs]")
				{
				/** Destroy application profile.	*/
				gna_profile_destroy (intrpt_code);
				}


			/** state (destroy_profile) exit executives **/
			FSM_STATE_EXIT_FORCED (7, "destroy_profile", "bt_gna_clsvr_mgr () [destroy_profile exit execs]")
				{
				}


			/** state (destroy_profile) transition processing **/
			FSM_TRANSIT_FORCE (0, state0_enter_exec, ;, "default", "", "destroy_profile", "wait")
				/*---------------------------------------------------------*/



			/** state (remote_profile) enter executives **/
			FSM_STATE_ENTER_FORCED (8, state8_enter_exec, "remote_profile", "bt_gna_clsvr_mgr () [remote_profile enter execs]")
				{
				/** This state is entered when the server recieves a process interrupt from **/
				/** a remote custom manager, telling it to start a profile which containts  **/
				/** custom application in it. If the specified profile is enabled on this   **/
				/** server, then we do nothing, however, if it is not enabled, we need to   **/
				/** start it for one profile duration.										**/
				
				/* Get the ici assosiated with the process interrupt.*/
				ici_ptr = op_intrpt_ici ();
				
				/* Get the profile name and the end time of the profile */
				if ((ici_ptr == OPC_NIL) ||
					(op_ici_attr_get (ici_ptr, "Profile Name", &profile_name) == OPC_COMPCODE_FAILURE) ||
					(op_ici_attr_get (ici_ptr, "End Time", &remote_end_time) == OPC_COMPCODE_FAILURE) ||
					(op_ici_attr_get (ici_ptr, "application repetition index", &repetition_index) == OPC_COMPCODE_FAILURE )||
					(op_ici_attr_get (ici_ptr, "profile repetition index", &profile_repetition_index) == OPC_COMPCODE_FAILURE) ||
					(op_ici_attr_get (ici_ptr, "application row index", &appl_row_index)== OPC_COMPCODE_FAILURE))
				   gna_clsvr_mgr_warn( "Could not get info from ICI");
				
				/* Destroy ici */
				if (ici_ptr != OPC_NIL)
					op_ici_destroy (ici_ptr);
				
				/* Check if the remotely specified profile is already enabled */
				/* on this node.											  */
				if (active_profiles_lptr != OPC_NIL)
					{
					active_size = op_prg_list_size (active_profiles_lptr);
					for (i = 0; i < active_size; i++)
						{
						enabled_profile_ptr = (Enabled_Profiles_Desc *) op_prg_list_access (active_profiles_lptr, i);
						if ((!strcmp (enabled_profile_ptr->profile_name_ptr, profile_name)) &&
							(enabled_profile_ptr->application_index == repetition_index) &&
							(enabled_profile_ptr->profile_index == profile_repetition_index))
							{
							/* Print a warning */
							if (trace_active)
								{
								sprintf (msg, "Profile %s appl_index =%d prof_index=%d is already enabled at this node", 
										 profile_name, repetition_index, profile_repetition_index);
								
								gna_clsvr_mgr_warn (msg);
								}
							
							/* Set the flag to true */
							Profile_Enabled = OPC_TRUE;
							break;
							}
						}
					}
				
				/* Profile is not enabled on this node 		  */
				/* We need to start the profile on this node. */
				if (!Profile_Enabled)
					{
					/* Reset the max custom stat index */
					custom_max_stat_index = 0;
					
					/* Obtain the pointer to profile description from global registry */
					profile_desc_ptr = (GnaT_Profile_Desc *) oms_data_def_entry_access ("Profile Descriptions", profile_name);
				  	
					/* Calculate the maximum profile index 			 */
					/* In case no profiles are enabled, set it to -1 */
					/* Also, free the list of disabled profiles, just*/
					/* in case.										 */
					if ((active_profiles_lptr != OPC_NIL) &&
						(op_prg_list_size (active_profiles_lptr) > 0))
						{
						max_profile_index = op_prg_list_size (active_profiles_lptr) - 1;
						
						/* Calculate the smallest available profile index */
						smallest_available_profile_index = gna_clsvr_mgr_find_smallest_profile_index ();	
						}
					else 
						{
						max_profile_index = -1;
						if (disabled_profiles_lptr != OPC_NIL)
							op_prg_list_free (disabled_profiles_lptr);
						}
					
					
					if (profile_desc_ptr != OPC_NIL)
						{
						/* If there are no profiles specified at this node */
						/* allocate memory for new profile structures.	   */
						if (nam_profiles_ptr == OPC_NIL)
							nam_profiles_ptr = (GnaT_Nam_Desc *) op_prg_mem_alloc (sizeof (GnaT_Nam_Desc )); 	 
						
						/* Check whether there are any profiles currently active at this node */
						if ((nam_profiles_ptr->profile_ptr == OPC_NIL) ||
							(max_profile_index < 0))										
							{
							if (nam_profiles_ptr->profile_ptr == OPC_NIL)
								nam_profiles_ptr->profile_ptr = (GnaT_Nam_Profile**) op_prg_mem_alloc (sizeof (GnaT_Nam_Profile*));
						 
							/* Insert the profile name into the list of enabled profiles */
							/* Insert the profile name into the list of enabled profiles */
							enabled_profile_ptr = (Enabled_Profiles_Desc*) op_prg_mem_alloc (sizeof (Enabled_Profiles_Desc));
							enabled_profile_ptr->profile_name_ptr = (char *) op_prg_mem_alloc (strlen (profile_name) + 1);
							strcpy (enabled_profile_ptr->profile_name_ptr, profile_name);
							enabled_profile_ptr->profile_index = profile_repetition_index;
							enabled_profile_ptr->application_index = repetition_index;
							enabled_profile_ptr->local_profile_index = 0;
							op_prg_list_insert (active_profiles_lptr, enabled_profile_ptr, OPC_LISTPOS_TAIL);
							
							/* Set the new profile index */
							new_profile_index = 0;
							}
						/* There already have enabled profiles at this node, but not the specified one  */
						/* We need to reallocate memory, in order to specify the new profile entry.	   */
						else
							{			
							/* If smallest index is also the maximum index, then we need to allocate */
							/* more memory for this profile.										 */
							if (smallest_available_profile_index == max_profile_index)
								{
								new_profile_index = max_profile_index + 1;
								temp_profile_ptr = (GnaT_Nam_Profile**) op_prg_mem_alloc ((new_profile_index + 1) * sizeof (GnaT_Nam_Profile*));
								op_prg_mem_copy (nam_profiles_ptr->profile_ptr, temp_profile_ptr, (new_profile_index) * sizeof (GnaT_Nam_Profile*));
								op_prg_mem_free (nam_profiles_ptr->profile_ptr);
								nam_profiles_ptr->profile_ptr = temp_profile_ptr;
								}
							else
								new_profile_index = smallest_available_profile_index;
							
							/* Insert the profile name into the list of enabled profiles */
							enabled_profile_ptr = (Enabled_Profiles_Desc*) op_prg_mem_alloc (sizeof (Enabled_Profiles_Desc));
							enabled_profile_ptr->profile_name_ptr = (char *) op_prg_mem_alloc (strlen (profile_name) + 1);
							strcpy (enabled_profile_ptr->profile_name_ptr, profile_name);
							enabled_profile_ptr->profile_index = profile_repetition_index;
							enabled_profile_ptr->application_index = repetition_index;
							enabled_profile_ptr->local_profile_index = new_profile_index;
							op_prg_list_insert (active_profiles_lptr, enabled_profile_ptr, OPC_LISTPOS_TAIL);		   			
							}
						
						/* Parse the newly specified profile */
						nam_profiles_ptr->profile_ptr [new_profile_index] = 
						gna_client_profile_parser (profile_desc_ptr, OPC_FALSE, OPC_TRUE, new_profile_index);
				
						/* Set the longevity to "Kill Immediately", which means that profile 	*/
						/* will be ended as soon as the first profile cycle is over - in other	*/
						/* words the number of repetitions for this profile is explicitly set   */
						/* to 0.																*/
						nam_profiles_ptr->profile_ptr [new_profile_index]->longevity = Kill_Immediately;
						nam_profiles_ptr->profile_ptr [new_profile_index]->custom_app_row_index = appl_row_index;
					   	nam_profiles_ptr->profile_ptr [new_profile_index]->appl_rep_index = repetition_index;
						nam_profiles_ptr->profile_ptr [new_profile_index]->profile_duration = remote_end_time;
						
						nam_profiles_ptr->profile_ptr [new_profile_index]->profile_name_ptr = (char *) op_prg_mem_alloc (strlen (profile_name) + 1);
						strcpy (nam_profiles_ptr->profile_ptr [new_profile_index]->profile_name_ptr, profile_name);
						
						/* Start the new profile */
						gna_nam_profiles_start (new_profile_index);
						
						/* Schedule the end of the invoked profile 	*/
						/* Since we do not care about repeatability	*/
						/* of this profile, we'll schedule the end	*/
						/* of it right away, with some small delay	*/
						op_intrpt_schedule_self (op_sim_time() + Invoked_Profile_Duration, GNAC_PROFILE_END_OFFSET + new_profile_index);
						}
					}
				}


			/** state (remote_profile) exit executives **/
			FSM_STATE_EXIT_FORCED (8, "remote_profile", "bt_gna_clsvr_mgr () [remote_profile exit execs]")
				{
				
				}


			/** state (remote_profile) transition processing **/
			FSM_TRANSIT_FORCE (0, state0_enter_exec, ;, "default", "", "remote_profile", "wait")
				/*---------------------------------------------------------*/



			/** state (rtrv_complete) enter executives **/
			FSM_STATE_ENTER_FORCED (9, state9_enter_exec, "rtrv_complete", "bt_gna_clsvr_mgr () [rtrv_complete enter execs]")
				{
				/** This state is entered when a client finishes the retrieval of all **/
				/** specified inline objects. If there are any objects still queued   **/
				/** for this session, then they should be retreived.				  **/
				/** This state is used to process HTTP 1.1 requests					  **/
				
				/* Get the ici assosiated with the process interrupt.*/
				cli_ici_ptr = op_intrpt_ici ();
				
				/* Get info from the ICI */
				if (op_ici_attr_get (cli_ici_ptr, "pkt_id", &pkt_id) == OPC_COMPCODE_FAILURE )
					printf ("Could not get information from ICI\n");
				
				/* Destroy ICI */
				op_ici_destroy (cli_ici_ptr);
				
				/* Find the pending job associated with this client seesion and 	   	*/
				/* complete the original tranascation.								*/
				list_size = op_prg_list_size (pending_job_lptr);
				
				for (i = 0; i < list_size; i++)
					{
					pend_job_ptr = (GnaT_Pending_Job *) op_prg_list_access (pending_job_lptr, i);
					
					if (pend_job_ptr->pkt_id == pkt_id)
						{
						/* This is the pending job that corresponds to the cliebt	*/
						/* job that just finished processing send the response to 	*/
						/* client.													*/
						pend_job_ptr = (GnaT_Pending_Job *) op_prg_list_remove (pending_job_lptr, i);
						if (pend_job_ptr->req_pk != OPC_NIL) 
							gna_clsvr_mgr_process_request (pend_job_ptr->req_pk, pend_job_ptr->sess_ptr);
					   		
						op_prg_mem_free (pend_job_ptr);
						break;
						}
					}
				}


			/** state (rtrv_complete) exit executives **/
			FSM_STATE_EXIT_FORCED (9, "rtrv_complete", "bt_gna_clsvr_mgr () [rtrv_complete exit execs]")
				{
				}


			/** state (rtrv_complete) transition processing **/
			FSM_TRANSIT_FORCE (0, state0_enter_exec, ;, "default", "", "rtrv_complete", "wait")
				/*---------------------------------------------------------*/



			/** state (client_closed) enter executives **/
			FSM_STATE_ENTER_FORCED (10, state10_enter_exec, "client_closed", "bt_gna_clsvr_mgr () [client_closed enter execs]")
				{
				/** This state is entered when a TCP session is closed   		**/
				/** If HTTP 1.0 is used, we need to spawn a new session.  		**/
				
				/* Get the ici assosiated with the process interrupt.*/
				cli_ici_ptr = op_intrpt_ici ();
				
				/* Get information from ICI */
				if (op_ici_attr_get (cli_ici_ptr, "server_index", &serv_index) 	== OPC_COMPCODE_FAILURE ||
					op_ici_attr_get (cli_ici_ptr, "session_key", &session_key) == OPC_COMPCODE_FAILURE )
					 printf ("Could not get information from ICI\n");
				
				/* Destroy ICI 											 		*/
				op_ici_destroy (cli_ici_ptr);
				
				/* Get the list of sessions connected to the appropriate server */
				temp_sessions_lptr = server_info_array_ptr [serv_index]->server_session_lptr;
				
				/* Go through the list, until the 'closed' session is found 	*/
				/* and remove it from the list. 								*/
				if (temp_sessions_lptr != OPC_NIL)
					{
					list_size = op_prg_list_size (temp_sessions_lptr);
					for (i =0; i < list_size; i ++)
						{
						key_info_ptr = (Key_Desc *) op_prg_list_access (temp_sessions_lptr, i);
						if (key_info_ptr->session_key == session_key)
							{
							key_info_ptr = (Key_Desc *) op_prg_list_remove (temp_sessions_lptr, i);
							op_prg_mem_free (key_info_ptr);
							break;
							}
						}
					}
				}


			/** state (client_closed) exit executives **/
			FSM_STATE_EXIT_FORCED (10, "client_closed", "bt_gna_clsvr_mgr () [client_closed exit execs]")
				{
				
				}


			/** state (client_closed) transition processing **/
			FSM_TRANSIT_FORCE (0, state0_enter_exec, ;, "default", "", "client_closed", "wait")
				/*---------------------------------------------------------*/



			/** state (arrival) enter executives **/
			FSM_STATE_ENTER_FORCED (11, state11_enter_exec, "arrival", "bt_gna_clsvr_mgr () [arrival enter execs]")
				{
				/** The server process has received a packet sent by the client.	**/
				/** Details on how to treat this packet are contained in the packet	**/
				/** This information includes the type of application the request	**/
				/** belongs to, if the request needs to be replied with a eresponse,**/
				/** the response size and response count. The last packet of the	**/
				/** request usually has a CLOSE command embedded in it and the		**/
				/** server responds with a CLOSE CONFIRM.							**/
				
				/* Once the server receives the packet it checks for the 		*/
				/* application type and computes the time required to service 	*/
				/* packet. If the request requires a response a copy of the 	*/
				/* original packet is made and the size of the packet is set 	*/
				/* to be equal to the response size. The copying of the packet 	*/
				/* retains the stamp time of the request packet and this info	*/
				/* is used by the client to calculate the response time when 	*/
				/* the response reaches the client. 							*/
				
				/* This is the Server Passive session processing.					*/
				/* Get the new packet in the arrival state and check its validity	*/
				
				pk_ptr = op_pk_get (op_intrpt_strm ());
				if (pk_ptr == OPC_NIL)
					{
					gna_clsvr_mgr_error ("Unable to get packet.");
					}
				
				/* Insert the packet into the reassemble buffer. Do it only if 	*/
				/* the received packet is a segment of larger packet.			*/			
				else if (op_sar_pk_is_segment (pk_ptr) == OPC_TRUE)
					{
					further_processing_required = gna_clsvr_mgr_segment_insert (&pk_ptr);	
					}
				else
					{
					/*	The received packet is self-contained. Set a flag to	*/
					/*	indicate that the packet requires further processing	*/
					/*	(e.g., updating statistics, processing the request,.)	*/
					
					/* Obtain the command sent in the packet. The command contains	*/
					/* information about the type of the packet (Data, Close command*/
					/* or the Close Confirm). This is a deciding factor in the state*/
					/* transitions.													*/
					if (op_pk_nfd_get (pk_ptr, "command",  &command) == OPC_COMPCODE_FAILURE)
						gna_clsvr_mgr_error ("Unable to get command field from received packet.");
				
					/* Get the size of the segment/packet. Later on, this will be	*/
					/* used update the statistics on bytes received per second.		*/
					pk_size = op_pk_total_size_get (pk_ptr) / 8.0;	
				
					/* Check if this packet is an explicit close packet from the 	*/
					/* application. If it is, don't perform further processing		*/
					/* and close the connection.									*/
					if ((pk_size == 1) && (command == TPALC_CMD_CLOSE))
						{
						gna_clsvr_mgr_process_close (pk_ptr, sess_ptr);
						further_processing_required = OPC_FALSE;
						}
					/* This packet is not an explicit application close packet.		*/
					else
						{	
						further_processing_required = OPC_TRUE;
						}
					}
				
				/* Since a complete packet has arrived or is formed from the 	*/
				/* segments, the packet has to be processed to record the stats	*/
				/* related to the packet's application and also to generate 	*/
				/* responses if required.										*/	
				if (further_processing_required == OPC_TRUE)
					{
					/* Check if this application is a front end for custom application 		*/
					/* in the back-end. If yes, this function will start running 	   		*/
					/* custom application and queue the request until custom application	*/
					/* is finished. Then, request will be sent back to the client.			*/
					run_custom_app = gna_clsvr_mgr_indirect_custom_app_check (pk_ptr, sess_ptr);		
						
					/* No custom application at the back-end */
					/* Continue processing as usual			 */
					if (run_custom_app == OPC_FALSE)
						{	
						/* Check if this server is acting as a web caching server */
						if (web_caching_enabled)
							{
							gna_clsvr_mgr_cache_server_request_check (pk_ptr, sess_ptr);
							}					
						else
							{
							/* This server is not a web caching server */
							/* Process request normally.			   */
							gna_clsvr_mgr_process_request (pk_ptr, sess_ptr);
							}
						}
					}
				
				
				
				}


			/** state (arrival) exit executives **/
			FSM_STATE_EXIT_FORCED (11, "arrival", "bt_gna_clsvr_mgr () [arrival exit execs]")
				{
				
				}


			/** state (arrival) transition processing **/
			FSM_TRANSIT_FORCE (0, state0_enter_exec, ;, "default", "", "arrival", "wait")
				/*---------------------------------------------------------*/



			/** state (ace) enter executives **/
			FSM_STATE_ENTER_FORCED (12, state12_enter_exec, "ace", "bt_gna_clsvr_mgr () [ace enter execs]")
				{
				/* Get the ici */
				ace_req_ici_ptr = op_intrpt_ici();
						
				/* Get the information from the ici */
				/* Which task_mgr is requesting this info ? */
				op_ici_attr_get (ace_req_ici_ptr, "task_mgr_hndl_ptr", &ace_task_mgr_hndl_ptr);
						
				switch (intrpt_code)
					{
					case GnaC_ACE_Network_Tiers_Info_Req:
						{
						/* gna_ace_task_mgr is requesting a list of the nodes on the network */
						/* that are registered as a particular tier.						 */
						
						/* Update the ici */
						op_ici_attr_set (ace_req_ici_ptr, "network_ace_tiers_lptr", network_ace_tiers_lptr);
										
						/* Install the ici and schedule an interrupt to pass the info*/
						op_ici_install(ace_req_ici_ptr);
						op_intrpt_schedule_process (*ace_task_mgr_hndl_ptr, op_sim_time (), GnaC_ACE_Network_Tiers_Info_Req);
						
						break;
						}
					
					case GnaC_ACE_Task_Cli_Spawn_Req:
						{
						/* gna_ace_task_mgr is requesting that an ACE client be spawned */
				
						/* Get the conn_info_ptr from the ici */
						op_ici_attr_get (ace_req_ici_ptr, "conn_info_ptr", &ace_conn_info_ptr);
				
						/* Get the next proc step so we can identify the conn_open stage we are in */
						op_ici_attr_get (ace_req_ici_ptr, "next_proc_step", &ace_next_proc_step);
						
						/* Get the string for annotating stats */
						op_ici_attr_get (ace_req_ici_ptr, "stat_annotation_str", &ace_stat_annotation_str);
										
						/* Spawn an ACE client with the ace_task_mgr_hndl_ptr as parmem */
						/* so that the task cli knows which task mgr family its part of */
						ace_task_cli_hndl = op_pro_create("gna_ace_task_cli", ace_task_mgr_hndl_ptr);
						
						/* Set a tag for identification */
						op_pro_tag_set (ace_task_cli_hndl, my_node_addr); 
						
						/** Invoke the client so it can initialize itself		 **/
						
						/* Allocate memory to pass argument memory */
						clsvr_to_ace_cli_argmem_ptr = (GnaT_Ace_Clsvr_Cli_Info*) op_prg_mem_alloc (sizeof (GnaT_Ace_Clsvr_Cli_Info));
								
						/* Set the ace_conn_info_ptr as argmem so that the ace_cli */
						/* knows which connection it will be part of eventually    */
						clsvr_to_ace_cli_argmem_ptr->conn_info_ptr = ace_conn_info_ptr;
										
						/* Set the CPU resource handle which will be used by ACE */
						/* to model contention 									 */
						clsvr_to_ace_cli_argmem_ptr->cpu_resource_handle = cpu_resource_hndl;
										
						/* Set the stat annotation string so that the client knows */
						/* how to search the hash table                            */
						clsvr_to_ace_cli_argmem_ptr->stat_annotation_str = ace_stat_annotation_str;
						
						/* Update the conn_info_ptr */
						if ( ace_next_proc_step == 1)
							{
							/* Set the "src" fields of the conn_info_ptr */ 
						    ace_conn_info_ptr->src_cli_hndl = ace_task_cli_hndl;
							ace_conn_info_ptr->src_cli_node_addr = my_node_addr;
							
							/* This client will create an active connection, it doesnt need a listening port */
							clsvr_to_ace_cli_argmem_ptr->ports_in_use_lptr = OPC_NIL;
							}
						else if (ace_next_proc_step == 2)
							{
							/* Set the "dest" fields of the conn_info_ptr */ 
						    ace_conn_info_ptr->dest_cli_hndl = ace_task_cli_hndl;
							ace_conn_info_ptr->dest_cli_node_addr = my_node_addr;
							
							/* This client will create a passive connection */
							/* Choose a port for the client to listen on    */
							ace_listening_port = gna_ace_listening_port_select ();
							
							/* Set the listening port of the conn_info_ptr so     */
							/* that the ace cli will know which port to listen on */
							ace_conn_info_ptr->dest_cli_listening_port = ace_listening_port;
							
							/* Pass the list of ports which are currently in use     */
							/* The task cli will free the port once it is not in use */
							/* This way ports can be recycled                        */
							clsvr_to_ace_cli_argmem_ptr->ports_in_use_lptr = ace_ports_in_use_lptr;
				
							/* Register the ACE application service on this port */
							tpal_service_register (my_node_id, ace_conn_info_ptr->trans_protocol, "ACE", ace_listening_port, 10);
							}
				
						/* Set the ace_conn_info_ptr as argmem so it knows which */
						/* connection it will be part of eventually   			 */
						op_pro_invoke (ace_task_cli_hndl, clsvr_to_ace_cli_argmem_ptr);
						
						/* Free argument memory */
						op_prg_mem_free (clsvr_to_ace_cli_argmem_ptr);		
						
						/* Install the ici and schedule an interrupt to pass the info*/
						op_ici_install (ace_req_ici_ptr);
						op_intrpt_schedule_process (*ace_task_mgr_hndl_ptr, op_sim_time (), GnaC_ACE_Feedback);
						
						if (ace_ltrace_active)
							gna_ace_cli_spawn_trace_print(ace_req_ici_ptr);
				
						break;
						}
					
					case GnaC_ACE_Task_Cli_Destroy_Req:
						{
						/* Which task_cli needs to be destroyed ? */
						op_ici_attr_get (ace_req_ici_ptr, "task_cli_hndl_ptr", &ace_task_cli_hndl_ptr);
					
						/* Schedule an interrupt for the task_cli to destroy itself */
						op_intrpt_schedule_process (*ace_task_cli_hndl_ptr, op_sim_time (), GnaC_ACE_Done);
						
						break;
						}
					
					default :
						break;
					}
				}


			/** state (ace) exit executives **/
			FSM_STATE_EXIT_FORCED (12, "ace", "bt_gna_clsvr_mgr () [ace exit execs]")
				{
				}


			/** state (ace) transition processing **/
			FSM_TRANSIT_FORCE (0, state0_enter_exec, ;, "default", "", "ace", "wait")
				/*---------------------------------------------------------*/



			}


		FSM_EXIT (5,bt_gna_clsvr_mgr)
		}
	}

#if defined (__cplusplus)
	extern "C" { 
#endif
	extern VosT_Fun_Status Vos_Catmem_Register (const char * , int , VosT_Void_Null_Proc, VosT_Address *);
	extern VosT_Address Vos_Catmem_Alloc (VosT_Address, size_t);
	extern VosT_Fun_Status Vos_Catmem_Dealloc (VosT_Address);
#if defined (__cplusplus)
	}
#endif


Compcode
bt_gna_clsvr_mgr_init (void ** gen_state_pptr)
	{
	int _block_origin = 0;
	static VosT_Address	obtype = OPC_NIL;

	FIN (bt_gna_clsvr_mgr_init (gen_state_pptr))

	if (obtype == OPC_NIL)
		{
		/* Initialize memory management */
		if (Vos_Catmem_Register ("proc state vars (bt_gna_clsvr_mgr)",
			sizeof (bt_gna_clsvr_mgr_state), Vos_Vnop, &obtype) == VOSC_FAILURE)
			{
			FRET (OPC_COMPCODE_FAILURE)
			}
		}

	*gen_state_pptr = Vos_Catmem_Alloc (obtype, 1);
	if (*gen_state_pptr == OPC_NIL)
		{
		FRET (OPC_COMPCODE_FAILURE)
		}
	else
		{
		/* Initialize FSM handling */
		((bt_gna_clsvr_mgr_state *)(*gen_state_pptr))->current_block = 10;

		FRET (OPC_COMPCODE_SUCCESS)
		}
	}



void
bt_gna_clsvr_mgr_diag (void)
	{
	int _block_origin = __LINE__;

	FIN (bt_gna_clsvr_mgr_diag ())

	if (1)
		{
		/* Interrupt handling variables.	*/
		int						intrpt_code = OPC_INT_INVALID;
		int						intrpt_type = OPC_INT_INVALID;
		int						sess_type = OPC_INT_INVALID;
		Ici*					ici_ptr = OPC_NIL;
		Evhandle				evh;
		List*					resp_size_lptr = OPC_NIL;
		double					pk_size = OPC_DBL_INVALID;
		double					service_time = OPC_DBL_INVALID;
		double					service_overhead = OPC_DBL_INVALID;
		int						i, list_size;
		int						index = OPC_INT_INVALID;
		int						recompute = 0;
		int						command = OPC_INT_INVALID;
		int						echo = OPC_INT_INVALID;
		int						response_count = OPC_INT_INVALID;
		double					response_size = OPC_DBL_INVALID;
		GnaT_Application_Type	app_type;	
		Packet*					response_pk_ptr = OPC_NIL;
		char					msg [512];
		Packet*					pk_ptr = OPC_NIL;
		GnaT_Service*			serv_ptr = OPC_NIL;
		GnaT_Serv_Session*		sess_ptr = OPC_NIL;
		GnaT_Job*				job_ptr = OPC_NIL;
		Boolean 				job_completion_recomputation_required = OPC_FALSE;
		Boolean					further_processing_required = OPC_FALSE;
		GnaT_Cli_Mgr_Session*	cli_sess_ptr = OPC_NIL;
		GnaT_Cli_Mgr_Session* 	temp_sess_ptr = OPC_NIL;
		char*					server_address_ptr = OPC_NIL;
		char*					profile_name = OPC_NIL;
		int						active_size = OPC_INT_INVALID;
		Boolean					Profile_Enabled = OPC_FALSE;
		char*					temp_prof_name = OPC_NIL;
		GnaT_Profile_Desc* 		profile_desc_ptr = OPC_NIL;
		int						profile_number = OPC_INT_INVALID;
		GnaT_Nam_Profile**		temp_profile_ptr = OPC_NIL;
		char*					active_profile_ptr = OPC_NIL;
		double*					temp_size = OPC_NIL;
		Boolean					Wait_To_Arrival = OPC_TRUE;
		double					response_delay = OPC_DBL_INVALID;
		Prohandle*				read_in_prohandle_ptr = OPC_NIL;
		char*					temp_name = OPC_NIL;
		int						type_of_request = GnaC_Unspec;
		double					cur_sim_time = OPC_DBL_INVALID;
		int						cur_session_jobs = OPC_INT_INVALID;
		Boolean					service_already_open;
		GnaT_Service*			temp_serv_ptr;
		int						open_service_index;
		
		Queued_Object_Desc*				queued_object_ptr;
		Queued_Object_Desc*				inline_object_ptr;
		int	   							serv_index;
		OmsT_Dt_Key						session_key;
		GnaT_Cli_Mgr_Session*			session_ptr = OPC_NIL;
		Boolean							Page_Over;
		int								cli_command;
		int								mgr_command;
		int								signal_command;
		Key_Desc*						key_info_ptr;
		List*							temp_sessions_lptr;	
		Ici*							cli_ici_ptr = OPC_NIL;
		GnaT_Pending_Job*				pend_job_ptr;
		Enabled_Profiles_Desc*			enabled_profile_ptr = OPC_NIL;
		int								number_of_jobs;
		int								job;
		OmsT_Resource_Job_Id			job_id;
		int								profile_repetition_index;
		int								appl_row_index;
		int								repetition_index;
		GnaT_Ace_Task_Rec*				task_record_ptr;
		Ici*							intrpt_iciptr;
		int								new_profile_index;
		int								smallest_available_profile_index;
		int								max_profile_index;
		GnaT_App_Stat_Info*				app_info_ptr;
		List*							clsvr_hndl_lptr;
		Ici*							ace_req_ici_ptr;
		Prohandle*						ace_task_mgr_hndl_ptr;
		Prohandle*						ace_task_cli_hndl_ptr;
		Prohandle						ace_task_cli_hndl;
		GnaT_Ace_Conn_Info*				ace_conn_info_ptr;
		int								ace_next_proc_step;
		int								ace_listening_port;
		GnaT_Ace_Clsvr_Cli_Info*		clsvr_to_ace_cli_argmem_ptr;
		char*							ace_stat_annotation_str;
		int								pkt_id;
		Boolean							run_custom_app;
		

		/* Diagnostic Block */


		BINIT
		/* Print the contents of the service and session lists. */
		gna_clsvr_mgr_list_print ();
		printf ("\n");
		gna_clsvr_mgr_sess_list_print ();

		/* End of Diagnostic Block */

		}

	FOUT;
	}




void
bt_gna_clsvr_mgr_terminate (void)
	{
	int _block_origin = __LINE__;

	FIN (bt_gna_clsvr_mgr_terminate (void))

	if (1)
		{
		/* Interrupt handling variables.	*/
		int						intrpt_code = OPC_INT_INVALID;
		int						intrpt_type = OPC_INT_INVALID;
		int						sess_type = OPC_INT_INVALID;
		Ici*					ici_ptr = OPC_NIL;
		Evhandle				evh;
		List*					resp_size_lptr = OPC_NIL;
		double					pk_size = OPC_DBL_INVALID;
		double					service_time = OPC_DBL_INVALID;
		double					service_overhead = OPC_DBL_INVALID;
		int						i, list_size;
		int						index = OPC_INT_INVALID;
		int						recompute = 0;
		int						command = OPC_INT_INVALID;
		int						echo = OPC_INT_INVALID;
		int						response_count = OPC_INT_INVALID;
		double					response_size = OPC_DBL_INVALID;
		GnaT_Application_Type	app_type;	
		Packet*					response_pk_ptr = OPC_NIL;
		char					msg [512];
		Packet*					pk_ptr = OPC_NIL;
		GnaT_Service*			serv_ptr = OPC_NIL;
		GnaT_Serv_Session*		sess_ptr = OPC_NIL;
		GnaT_Job*				job_ptr = OPC_NIL;
		Boolean 				job_completion_recomputation_required = OPC_FALSE;
		Boolean					further_processing_required = OPC_FALSE;
		GnaT_Cli_Mgr_Session*	cli_sess_ptr = OPC_NIL;
		GnaT_Cli_Mgr_Session* 	temp_sess_ptr = OPC_NIL;
		char*					server_address_ptr = OPC_NIL;
		char*					profile_name = OPC_NIL;
		int						active_size = OPC_INT_INVALID;
		Boolean					Profile_Enabled = OPC_FALSE;
		char*					temp_prof_name = OPC_NIL;
		GnaT_Profile_Desc* 		profile_desc_ptr = OPC_NIL;
		int						profile_number = OPC_INT_INVALID;
		GnaT_Nam_Profile**		temp_profile_ptr = OPC_NIL;
		char*					active_profile_ptr = OPC_NIL;
		double*					temp_size = OPC_NIL;
		Boolean					Wait_To_Arrival = OPC_TRUE;
		double					response_delay = OPC_DBL_INVALID;
		Prohandle*				read_in_prohandle_ptr = OPC_NIL;
		char*					temp_name = OPC_NIL;
		int						type_of_request = GnaC_Unspec;
		double					cur_sim_time = OPC_DBL_INVALID;
		int						cur_session_jobs = OPC_INT_INVALID;
		Boolean					service_already_open;
		GnaT_Service*			temp_serv_ptr;
		int						open_service_index;
		
		Queued_Object_Desc*				queued_object_ptr;
		Queued_Object_Desc*				inline_object_ptr;
		int	   							serv_index;
		OmsT_Dt_Key						session_key;
		GnaT_Cli_Mgr_Session*			session_ptr = OPC_NIL;
		Boolean							Page_Over;
		int								cli_command;
		int								mgr_command;
		int								signal_command;
		Key_Desc*						key_info_ptr;
		List*							temp_sessions_lptr;	
		Ici*							cli_ici_ptr = OPC_NIL;
		GnaT_Pending_Job*				pend_job_ptr;
		Enabled_Profiles_Desc*			enabled_profile_ptr = OPC_NIL;
		int								number_of_jobs;
		int								job;
		OmsT_Resource_Job_Id			job_id;
		int								profile_repetition_index;
		int								appl_row_index;
		int								repetition_index;
		GnaT_Ace_Task_Rec*				task_record_ptr;
		Ici*							intrpt_iciptr;
		int								new_profile_index;
		int								smallest_available_profile_index;
		int								max_profile_index;
		GnaT_App_Stat_Info*				app_info_ptr;
		List*							clsvr_hndl_lptr;
		Ici*							ace_req_ici_ptr;
		Prohandle*						ace_task_mgr_hndl_ptr;
		Prohandle*						ace_task_cli_hndl_ptr;
		Prohandle						ace_task_cli_hndl;
		GnaT_Ace_Conn_Info*				ace_conn_info_ptr;
		int								ace_next_proc_step;
		int								ace_listening_port;
		GnaT_Ace_Clsvr_Cli_Info*		clsvr_to_ace_cli_argmem_ptr;
		char*							ace_stat_annotation_str;
		int								pkt_id;
		Boolean							run_custom_app;
		

		/* Termination Block */


		BINIT
		{
		/* Destroy the segmentation buffer and reassembly */
		/* buffer and free the memory.					  */
		op_sar_buf_destroy (segmentation_buf_handle);
		op_sar_buf_destroy (reassembly_buf_handle);
		}

		/* End of Termination Block */

		}
	Vos_Catmem_Dealloc (pr_state_ptr);

	FOUT;
	}


/* Undefine shortcuts to state variables to avoid */
/* syntax error in direct access to fields of */
/* local variable prs_ptr in bt_gna_clsvr_mgr_svar function. */
#undef lower_layer_init_intrpt_count
#undef my_objid
#undef my_process_id
#undef my_tpal_objid
#undef current_sim_time
#undef my_tpal_address
#undef task_mgr_list_ptr
#undef cli_info_list_ptr
#undef client_sess_id
#undef no_of_act_sess
#undef processing_mode
#undef serv_list
#undef sess_list
#undef num_active_sess
#undef sess_list_size
#undef segmentation_buf_handle
#undef reassembly_buf_handle
#undef app_segment_size
#undef proc_speed
#undef overhead_dist
#undef server_id
#undef my_lan_handle
#undef close_conf_already_rcvd
#undef cli_sess_list_size
#undef sess_id
#undef rsvp_profile_table_ptr
#undef nam_profiles_ptr
#undef sim_duration
#undef ace_spec_log_written
#undef global_information_ptr
#undef rlogin_max_stat_index
#undef database_max_stat_index
#undef http_max_stat_index
#undef print_max_stat_index
#undef ftp_max_stat_index
#undef video_max_stat_index
#undef voice_max_stat_index
#undef email_max_stat_index
#undef custom_max_stat_index
#undef sources_lptr
#undef active_profiles_lptr
#undef cpu_resource_hndl
#undef application_segment_size
#undef custom_stats_registered
#undef node_is_lan
#undef sess_lan_handle
#undef sess_wkstn_id
#undef number_of_wkstns
#undef my_node_id
#undef last_wkstn_id
#undef remote_end_time
#undef process_record_handle
#undef mtu_sv
#undef hit_rate_thresh
#undef pending_job_lptr
#undef cache_hits
#undef cache_misses
#undef cache_reqs
#undef CACHE_HIT_RATE_SH
#undef CACHE_HIT_RATE_GSH
#undef http_version
#undef send_buffer_size
#undef http_params_ptr
#undef session_record_handle
#undef server_info_array_ptr
#undef servers_lptr
#undef web_caching_enabled
#undef custom_passive_session_registered
#undef SERV_NUM_SESS
#undef SERV_NUM_JOBS
#undef SERV_SERVICE_TIME
#undef SERV_GLOBAL_SERVICE_TIME
#undef SERV_GLOBAL_NUM_SESS
#undef disabled_profiles_lptr
#undef called_video_client_shared_mem_ptr
#undef called_voice_client_shared_mem_ptr
#undef server_stats_hash_table_ptr
#undef server_global_stats_hash_table_ptr
#undef stat_indexes_table
#undef job_table_hndl
#undef my_prohandle
#undef my_node_addr
#undef ace_ltrace_active
#undef ace_ports_in_use_lptr
#undef ace_dest_prefs_ptr
#undef gna_clsvr_app_mod_mem_ptr
#undef transport_protocol_objid



void
bt_gna_clsvr_mgr_svar (void * gen_ptr, const char * var_name, char ** var_p_ptr)
	{
	bt_gna_clsvr_mgr_state		*prs_ptr;

	FIN (bt_gna_clsvr_mgr_svar (gen_ptr, var_name, var_p_ptr))

	if (var_name == OPC_NIL)
		{
		*var_p_ptr = (char *)OPC_NIL;
		FOUT;
		}
	prs_ptr = (bt_gna_clsvr_mgr_state *)gen_ptr;

	if (strcmp ("lower_layer_init_intrpt_count" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->lower_layer_init_intrpt_count);
		FOUT;
		}
	if (strcmp ("my_objid" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->my_objid);
		FOUT;
		}
	if (strcmp ("my_process_id" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->my_process_id);
		FOUT;
		}
	if (strcmp ("my_tpal_objid" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->my_tpal_objid);
		FOUT;
		}
	if (strcmp ("current_sim_time" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->current_sim_time);
		FOUT;
		}
	if (strcmp ("my_tpal_address" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->my_tpal_address);
		FOUT;
		}
	if (strcmp ("task_mgr_list_ptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->task_mgr_list_ptr);
		FOUT;
		}
	if (strcmp ("cli_info_list_ptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->cli_info_list_ptr);
		FOUT;
		}
	if (strcmp ("client_sess_id" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->client_sess_id);
		FOUT;
		}
	if (strcmp ("no_of_act_sess" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->no_of_act_sess);
		FOUT;
		}
	if (strcmp ("processing_mode" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->processing_mode);
		FOUT;
		}
	if (strcmp ("serv_list" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->serv_list);
		FOUT;
		}
	if (strcmp ("sess_list" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->sess_list);
		FOUT;
		}
	if (strcmp ("num_active_sess" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->num_active_sess);
		FOUT;
		}
	if (strcmp ("sess_list_size" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->sess_list_size);
		FOUT;
		}
	if (strcmp ("segmentation_buf_handle" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->segmentation_buf_handle);
		FOUT;
		}
	if (strcmp ("reassembly_buf_handle" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->reassembly_buf_handle);
		FOUT;
		}
	if (strcmp ("app_segment_size" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->app_segment_size);
		FOUT;
		}
	if (strcmp ("proc_speed" , var_name) == 0)
		{
		*var_p_ptr = (char *) (prs_ptr->proc_speed);
		FOUT;
		}
	if (strcmp ("overhead_dist" , var_name) == 0)
		{
		*var_p_ptr = (char *) (prs_ptr->overhead_dist);
		FOUT;
		}
	if (strcmp ("server_id" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->server_id);
		FOUT;
		}
	if (strcmp ("my_lan_handle" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->my_lan_handle);
		FOUT;
		}
	if (strcmp ("close_conf_already_rcvd" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->close_conf_already_rcvd);
		FOUT;
		}
	if (strcmp ("cli_sess_list_size" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->cli_sess_list_size);
		FOUT;
		}
	if (strcmp ("sess_id" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->sess_id);
		FOUT;
		}
	if (strcmp ("rsvp_profile_table_ptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->rsvp_profile_table_ptr);
		FOUT;
		}
	if (strcmp ("nam_profiles_ptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->nam_profiles_ptr);
		FOUT;
		}
	if (strcmp ("sim_duration" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->sim_duration);
		FOUT;
		}
	if (strcmp ("ace_spec_log_written" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->ace_spec_log_written);
		FOUT;
		}
	if (strcmp ("global_information_ptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->global_information_ptr);
		FOUT;
		}
	if (strcmp ("rlogin_max_stat_index" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->rlogin_max_stat_index);
		FOUT;
		}
	if (strcmp ("database_max_stat_index" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->database_max_stat_index);
		FOUT;
		}
	if (strcmp ("http_max_stat_index" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->http_max_stat_index);
		FOUT;
		}
	if (strcmp ("print_max_stat_index" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->print_max_stat_index);
		FOUT;
		}
	if (strcmp ("ftp_max_stat_index" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->ftp_max_stat_index);
		FOUT;
		}
	if (strcmp ("video_max_stat_index" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->video_max_stat_index);
		FOUT;
		}
	if (strcmp ("voice_max_stat_index" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->voice_max_stat_index);
		FOUT;
		}
	if (strcmp ("email_max_stat_index" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->email_max_stat_index);
		FOUT;
		}
	if (strcmp ("custom_max_stat_index" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->custom_max_stat_index);
		FOUT;
		}
	if (strcmp ("sources_lptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->sources_lptr);
		FOUT;
		}
	if (strcmp ("active_profiles_lptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->active_profiles_lptr);
		FOUT;
		}
	if (strcmp ("cpu_resource_hndl" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->cpu_resource_hndl);
		FOUT;
		}
	if (strcmp ("application_segment_size" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->application_segment_size);
		FOUT;
		}
	if (strcmp ("custom_stats_registered" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->custom_stats_registered);
		FOUT;
		}
	if (strcmp ("node_is_lan" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->node_is_lan);
		FOUT;
		}
	if (strcmp ("sess_lan_handle" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->sess_lan_handle);
		FOUT;
		}
	if (strcmp ("sess_wkstn_id" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->sess_wkstn_id);
		FOUT;
		}
	if (strcmp ("number_of_wkstns" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->number_of_wkstns);
		FOUT;
		}
	if (strcmp ("my_node_id" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->my_node_id);
		FOUT;
		}
	if (strcmp ("last_wkstn_id" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->last_wkstn_id);
		FOUT;
		}
	if (strcmp ("remote_end_time" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->remote_end_time);
		FOUT;
		}
	if (strcmp ("process_record_handle" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->process_record_handle);
		FOUT;
		}
	if (strcmp ("mtu_sv" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->mtu_sv);
		FOUT;
		}
	if (strcmp ("hit_rate_thresh" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->hit_rate_thresh);
		FOUT;
		}
	if (strcmp ("pending_job_lptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->pending_job_lptr);
		FOUT;
		}
	if (strcmp ("cache_hits" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->cache_hits);
		FOUT;
		}
	if (strcmp ("cache_misses" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->cache_misses);
		FOUT;
		}
	if (strcmp ("cache_reqs" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->cache_reqs);
		FOUT;
		}
	if (strcmp ("CACHE_HIT_RATE_SH" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->CACHE_HIT_RATE_SH);
		FOUT;
		}
	if (strcmp ("CACHE_HIT_RATE_GSH" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->CACHE_HIT_RATE_GSH);
		FOUT;
		}
	if (strcmp ("http_version" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->http_version);
		FOUT;
		}
	if (strcmp ("send_buffer_size" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->send_buffer_size);
		FOUT;
		}
	if (strcmp ("http_params_ptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->http_params_ptr);
		FOUT;
		}
	if (strcmp ("session_record_handle" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->session_record_handle);
		FOUT;
		}
	if (strcmp ("server_info_array_ptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->server_info_array_ptr);
		FOUT;
		}
	if (strcmp ("servers_lptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->servers_lptr);
		FOUT;
		}
	if (strcmp ("web_caching_enabled" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->web_caching_enabled);
		FOUT;
		}
	if (strcmp ("custom_passive_session_registered" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->custom_passive_session_registered);
		FOUT;
		}
	if (strcmp ("SERV_NUM_SESS" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->SERV_NUM_SESS);
		FOUT;
		}
	if (strcmp ("SERV_NUM_JOBS" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->SERV_NUM_JOBS);
		FOUT;
		}
	if (strcmp ("SERV_SERVICE_TIME" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->SERV_SERVICE_TIME);
		FOUT;
		}
	if (strcmp ("SERV_GLOBAL_SERVICE_TIME" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->SERV_GLOBAL_SERVICE_TIME);
		FOUT;
		}
	if (strcmp ("SERV_GLOBAL_NUM_SESS" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->SERV_GLOBAL_NUM_SESS);
		FOUT;
		}
	if (strcmp ("disabled_profiles_lptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->disabled_profiles_lptr);
		FOUT;
		}
	if (strcmp ("called_video_client_shared_mem_ptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->called_video_client_shared_mem_ptr);
		FOUT;
		}
	if (strcmp ("called_voice_client_shared_mem_ptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->called_voice_client_shared_mem_ptr);
		FOUT;
		}
	if (strcmp ("server_stats_hash_table_ptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->server_stats_hash_table_ptr);
		FOUT;
		}
	if (strcmp ("server_global_stats_hash_table_ptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->server_global_stats_hash_table_ptr);
		FOUT;
		}
	if (strcmp ("stat_indexes_table" , var_name) == 0)
		{
		*var_p_ptr = (char *) (prs_ptr->stat_indexes_table);
		FOUT;
		}
	if (strcmp ("job_table_hndl" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->job_table_hndl);
		FOUT;
		}
	if (strcmp ("my_prohandle" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->my_prohandle);
		FOUT;
		}
	if (strcmp ("my_node_addr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->my_node_addr);
		FOUT;
		}
	if (strcmp ("ace_ltrace_active" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->ace_ltrace_active);
		FOUT;
		}
	if (strcmp ("ace_ports_in_use_lptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->ace_ports_in_use_lptr);
		FOUT;
		}
	if (strcmp ("ace_dest_prefs_ptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->ace_dest_prefs_ptr);
		FOUT;
		}
	if (strcmp ("gna_clsvr_app_mod_mem_ptr" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->gna_clsvr_app_mod_mem_ptr);
		FOUT;
		}
	if (strcmp ("transport_protocol_objid" , var_name) == 0)
		{
		*var_p_ptr = (char *) (&prs_ptr->transport_protocol_objid);
		FOUT;
		}
	*var_p_ptr = (char *)OPC_NIL;

	FOUT;
	}

