/*
** Frequency_Allocation.h :
**
** Bluetooth model in Opnet
** National Institute of Standards and Technology
**
** This model was developed at the National Institute of Standards
** and Technology by employees of the Federal Government in the course
** of their official duties. Pursuant to title 17 Section 105 of the
** United States Code this software is not subject to copyright
** protection and is in the public domain. This is an experimental
** system.  NIST assumes no responsibility whatsoever for its use by
** other parties, and makes no guarantees, expressed or implied,
** about its quality, reliability, or any other characteristic.
**
** We would appreciate acknowledgement if the model is used.
**
** NIST ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION
** AND DISCLAIM ANY LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER
** RESULTING FROM THE USE OF THIS SOFTWARE.
**
** Primary Author:      Nicolas Chevrollier
** Module description:  Bluetooth Common MAC Function Support
** Last Modification:   June, 19, 2002
*/

#ifndef __FREQUENCY_ALLOCATION_H__
#define __FREQUENCY_ALLOCATION_H__

/* Standard includes */
#include <stdio.h>
#include <opnet.h>
#include "bt_support.h"
#include "bt_wlan_support.h"
#include <math.h>

typedef enum WlanT_Phy_Char_Code
{
  WlanC_Frequency_Hopping,			
  WlanC_Direct_Sequence,				
  WlanC_Infra_Red					
} WlanT_Phy_Char_Code;

double pattern_of_frequencies[79];

void Frequency_Allocation ( Packet *pkptr);

#endif /* end of __FREQUENCY_ALLOCATION_H__ */
