// This software was developed at the National Institute of Standards 
// and Technology by employees of the Federal Government in the course 
// of their official duties. Pursuant to title 17 Section 105 of the 
// United States Code this software is not subject to copyright 
// protection and is in the public domain. 
// 
// We would appreciate acknowledgement if the software is used.



// File: programargs.cpp
// Last modified: 27 April 2001
// Author(s):
//   T. A. Hall
//   Wireless Communications Technologies Group
//   National Institute of Standards and Technology
//   100 Bureau Drive, STOP 8920
//   Gaithersburg, MD 20899-8920
//   timhall@nist.gov
//

#include <math.h>
#include <stdlib.h>
#include <string.h>
#include "util.h"
#include "programargs.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

ProgramArgs::ProgramArgs(int argc,
                         char* argv[])
{
    _ASSERTE(argc > 0);
    _ASSERTE(argv != null);
    m_argc = argc;
    m_argv = argv;
}

ProgramArgs::~ProgramArgs()
{

}

int ProgramArgs::count() {
    return m_argc;
}

const char* ProgramArgs::programName() {
    return m_argv[0];
}

bool ProgramArgs::findOption(const char* option) {
    for (int i=0; i<m_argc; ++i) {
        if (strcmp(option, m_argv[i]) == 0) {
            return true;
        }
    }
    return false;
}

// Return the parameter for a given option as a string
const char*
ProgramArgs::getParameter(const char* option,
                          const char* sdef) {
    for (int i=0; i<m_argc; ++i) {
        if (strcmp(option, m_argv[i]) == 0) {
            if (i < (m_argc-1)) {
                return m_argv[i+1];
            }
        }
    }
    return sdef;
}

// Return the parameter for a given option as an integer
int
ProgramArgs::getIntParameter(const char* option,
                             int idef) {
    const char* param = getParameter(option, null);
    return ((param != null) ? atoi(param) : idef);
}

// Return the parameter for a given option as a double
double
ProgramArgs::getDoubleParameter(const char* option,
                                double ddef) {
    const char* param = getParameter(option, null);
    return ((param != null) ? atof(param) : ddef);
}
