#!/usr/bin/python

# import the following modules
import string
import commands
import sys
import os.path

# getresult returns the output of the btint program
# I had trouble getting pipes to work under win32, so
# the Windows version writes output to a file, which
# is read and returned
def getresult(cmd, isWin32):
  if isWin32:
    cmd = string.join((cmd,"-o","tmp.out"))
    os.system(cmd)
    fout = open("tmp.out","r")
    result = fout.read()
    fout.close()
    os.remove("tmp.out")
  else:
    result = commands.getoutput(cmd)
  return result

# Set the working directory to be the one in which the script is run
usedir = os.path.dirname(sys.argv[0])
os.chdir(usedir)

# Open the output file
if len(sys.argv) == 2:
  outname = sys.argv[1]
else:
  outname = "test-results.out"
outf = open(outname,"w")

# Determine platform
if sys.platform == "win32":
  isWin32 = 1
else:
  isWin32 = 0

# packet length (in bits) and packet count are the same
# for all cases
pktlen = 176
pktcount = 2000

progname = './btint'
progbase = string.join((progname,'-c',str(pktcount),'-l',str(pktlen),'-BER'))

#########################################################
# Case I: Bluetooth system with WLAN (1Mb/s) interference
#########################################################
CNR = 30  # 30 dB

casebase = string.join((progbase,"-d BT -i 802.11 -EbNo",str(CNR)))
print casebase
outf.write("Bluetooth with IEEE802.11 (1 Mb/s) interference.\n")
outf.write("------------------------------------------------\n")

for CIR in range(-16,-15):
  print "CIR=",CIR,":"
  outf.write("CIR=%d\n" % (CIR))
  for df in range(1):
    runarg = string.join((casebase,'-CIR',str(CIR),'-f',str(df)))
    result = getresult(runarg,isWin32)
    print result,
    outf.write("%s, "%(result))
  print
  outf.seek(-2,2)
  outf.write("\n\n\n")

print "--------------------------------------------------"
print

##########################################################
# Case II: WLAN (1Mb/s) system with Bluetooth interference
##########################################################
CNR = 35  # 35 dB

casebase  = string.join((progbase,"-d 802.11 -i BT -EbNo",str(CNR)))
print casebase
outf.write("IEEE 802.11 1 Mb/s with Bluetooth interference.\n")
outf.write("-----------------------------------------------\n")

for CIR in range(-19,-18):
  print "CIR=",CIR,":"
  outf.write("CIR=%d\n" % (CIR))
  for df in range(1):
    runarg = string.join((casebase,'-CIR',str(CIR),'-f',str(df)))
    result = getresult(runarg,isWin32)
    print result,
    outf.write("%s, " % (result))
  print
  outf.seek(-2,2)
  outf.write("\n\n\n")

print "--------------------------------------------------"
print

############################################################
# Case III: WLAN (11Mb/s) system with Bluetooth interference
############################################################
CNR = 35  # 35 dB

casebase  = string.join((progbase,"-d 802.11 -bd 11 -i BT -EbNo", str(CNR)))
print casebase
outf.write("IEEE 802.11 (11 Mb/s) with Bluetooth interference.\n")
outf.write("--------------------------------------------------\n")

for CIR in range(-6,5):
  print "CIR=",CIR,":"
  outf.write("CIR=%d\n" % (CIR))
  for df in range(11):
    runarg = string.join((casebase,'-CIR',str(CIR),'-f',str(df)))
    result = getresult(runarg,isWin32)
    print result,
    outf.write("%s, " % (result))
  print
  outf.seek(-2,2)
  outf.write("\n\n\n")

