c*********************************************************************
c 
c defining the variables
c
c********************************************************************* 

$large
	implicit double precision(a-h,o-z)
        character *44 properties
	character *32 conduct,diffus
	character *26 absorlen
	character *28 brkstrs
	character *27 yngmod
	character *45 expncoef
	character *45 geometry
	character *23 thckns
	character *25 shading
	character *18 halfw
	character *13 coeffs
	character *45 heatcoeff1
	character *32 ambtemp
	character *24 emisglass
	character *38 emssamb
	character *28 varflux
	character *26 noptflx
	character *44 headflx
	character *31 vartemp
	character *33 noptemp
	character *54 headtemp
	character *50 headh2
	character *39 varh2
	character *41 nopth2
	character *48 headeps2
	character *24 vareps2
	character *32 nopteps2
	character *21 numerpars
	character *36 maxerr
	character *25 timestep
	character *24 maxrun
	character *32 outinterval
	character *12 input,output,output1
	character *1 ich,ich1,isav,ioutput,idef
	character *1 ifil
	dimension w(1005),uf1(1005),uf2(1005),uf3(1005)
	dimension t1(1005),t2(1005),q1(1005),q2(1005),aj(1005),ug3(1005)
	dimension u(1005),t1g(1005),t2g(1005),tamb(100)
	dimension dambt(100),temp2(1005),temp1(1005)
c	dimension uuf1(1005),uuf2(1005),uuf3(1005),uug3(1005)
        dimension p(100),dimtime(100),tfirex(1005),
     1	avgt(1005),xy(10),ivar(10),dh2(10),th2(10),teps2(10),deps2(10)
	common /kern/g,g11,uf1,uf2,uf3,ug3,pi,nk,h2(1005),epsi(1005)
	common /newt/ error
	common /lin/ ak,tc,al
c
c
c aio = Io
c beta = reciprocal of absorption coefficient
c ak   = thermal conductivity
c alpha= thermal diffusivity
c al   = thickness of the glass
c h1   = heat transfer coeff on un-exposed side
c h2   = heat transfer coeff on exposed side
c tfirex= ambient temp on exposed side
c tinf = ambient temp on unexposed side
c t2i  = ambient temp on exposed side (initially)
c eps  = emissivity of glass
c epsi = emissivity of surroundings ( un-exposed side)
c nk   = no of terms for series in kernels
c nt   = no of time steps
c dt   = size of the time step
c error= error allowed in the soln of eqn using newton's method
c errmax = error allowed between solns of time step sizes
c p    = dimensional flame radiation flux
c tamb = dimensional ambient temp of exposed side

        nk=3

c*********************************************************************
c        TITLE OF THE PROGRAM
c*********************************************************************

        write(*,301)
301     format(20x,'BREAK1- VERSION 1.0')
        write(*,302)
302     format(15x,'A. A. Joshi and P. J. Pagni')
	write(*,303)
303     format(10x,'Department of Mechanical Engineering')
	write(*,304)
304     format(10x,'University of California at Berkeley')
	write(*,305)
305     format(20x,'Berkeley, CA 94720')
	
        write(*,15453)
        write(*,1545)
1545    format(1x,'This program calculates the temperature history of th
     1e surfaces')
	write(*,15451)
15451   format(1x,'of a glass window for given fire parameters.')
	write(*,15452)
15452   format(1x,'The calculations are stopped when the glass breaks.')
        write(*,15453)
15453   format(1x,'')
        write(*,15453)
	write(*,16793)
16793   format(1x,'Hit RETURN to continue')
	write(*,15453)
	read(*,*)

c*****************************************************************
c        DISCLAIMER
c*****************************************************************

	write(*,401)
401     format(1x,'*****************************************************
     1*******')
	write(*,402)
402     format(1x,'*  Warning: Read the disclaimer before using this pro
     1gram  *')
	write(*,403)
403     format(1x,'*  --------------------------------------------------
     1----  *')
        write(*,404)
404     format(1x,'*  This program was developed under grants from the    
     1      *')
	write(*,4041)
4041    format(1x,'*  National Institute of Standards and Technology, ho
     1wever *')
	write(*,4042)
4042    format(1x,'*  no certification or applicability is implied.  Man
     1y     *')
	write(*,405)
405     format(1x,'*  assumptions are made concerning the physical prope
     1rties *')
	write(*,4051)
4051    format(1x,'*  of glass and the phenomenology of breakage. Only y
     1ou are*')
	write(*,406)
406     format(1x,'*  responsible for your calculations with this progra
     1m. Use*')  
	write(*,408)
408     format(1x,'*  should be restricted to predicting when ordinary
     1glass *')
	write(*,409)
409     format(1x,'*  in ordinary windows may break under the assumption
     1s in  *')
	write(*,410)
410     format(1x,'*  your choice of input parameters.  Do not use the 
     1      *')
	write(*,411)
411     format(1x,'*  program to calculate conditions under which glass
     1 will *')
	write(*,412)
412     format(1x,'*  not break.  The properties of a particular piece o
     1f     *')
	write(*,413)
413     format(1x,'*  glass and the accuracy of each set of input are bo
     1th    *')
	write(*,414)
414     format(1x,'*  sufficiently uncertain that no confidence can be p
     1laced *')
	write(*,415)
415     format(1x,'*  in any calculation which predicts that a window wi
     1ll    *')
	write(*,420)
420     format(1x,'*  not break.                                        
     1      *')
	write(*,401)
	write(*,16793)
	read(*,*)


        write(*,15453)
        write(*,15455)
15455   format(1x,'Please write ''y'' for yes and ''n'' for no')
        write(*,15456)
15456   format(1x,'for every question.')
        write(*,15491)
	write(*,15453)
111     write(*,1547)
1547    format(1x,'Do you want to use the default values for properties,
     1 geometry,')
        write(*,15471)
15471   format(1x,'fire and numerical parameters?(y/n)')
	read(*,101,err=111)idef
  101   format (a1)
	t=0.d0

	if(idef.eq.'y'.or.idef.eq.'n')then
	 continue
	else
	 go to 111
	endif

	if(idef.eq.'n')then 
1411     write(*,15461)
15461   format(1x,'Do you want to change the default values interactivel
     1y or read in from')
	  write(*,15462)
15462     format(1x,'a pre-existing file?(y/n)')
          write(*,15453)
	  write(*,15463)
15463    format(1x,'NOTE: To read in values from a file, you have to use
     1 a file saved in a') 
	 write(*,15464)
15464    format(1x,'previous run and if needed change the data according 
     1 to the format specified in')
	 write(*,10546)
10546    format(1x,'Table I of the manual.')
        
	 write(*,15465)
15465    format(1x,'y=change default values interactively, n=read from a 
     1 file')
          read(*,101,err=1411)ifil
	      if(ifil.eq.'y'.or.ifil.eq.'n')then
	        continue
	      else
	        go to 1411
	      endif
	 if(ifil.eq.'y')go to 1108
2496     write(*,15472)
15472  format(1x,'Please write the file name (must be in DOS format)')
         read(*,10001)input
10001    format (a12)
	 open(unit=12,file=input)
c	iaccess=access(input,"read")
c	if(iaccess.eq.0)then
c	open(unit=12,file=input)
ci	else
cj	write(*,2497)input
c2497    format(1x,'File = ',a12,' does not exist')
c	go to 2496
c	endif


c*****************************************************************************
c            
c          READ INPUTS FROM A FILE
c
c******************************************************************************
	read(12,61)properties
61      format(a44)
	read(12,62)conduct,ak
62      format(a32,e12.4)
	read(12,63)diffus,alpha
63      format(a32,e12.4)
	read(12,64)absorlen,beta
64      format(a26,e12.4)
	read(12,65)brkstrs,sigmab
65      format(a28,e12.4)
	read(12,66)yngmod,youngs
66      format(a27,e12.4)
	read(12,67)expncoef,betal
67      format(a45,e12.4)
	read(12,68)geometry
68      format(a19)
	read(12,69)thckns,al
69      format(a23,f8.4)
        read(12,691)shading,sl
691     format(a25,f8.4)
        read(12,692)halfw,h
692     format(a18,f8.4)
        read(12,693)coeffs
693     format(a13)
	read(12,71)heatcoeff1,h1
71      format(a45,f7.2)
	read(12,72)ambtemp,tinf
72      format(a32,f7.1)
	read(12,73)emisglass,eps
73      format(a24,f6.2)
        read(12,74)emssamb,epsi1
74      format(a38,f6.2)
	read(12,75)varflux
75      format(a28)
	read(12,76)noptflx,iendp
76      format(a38,i3)
        read(12,761)headflx
761     format(a44)
	do 77 i=1,iendp
77      read(12,1537)j,dimtime(j),p(j)
        read(12,78)vartemp
78      format(a31)
	read(12,79)noptemp,iendt
79      format(a45,i3)
        read(12,80)headtemp
80      format(a54)
	do 81 i=1,iendt
81      read(12,1537)j,dambt(j),tamb(j)
        read(12,760)varh2
760     format(a39)
	read(12,759)nopth2,iendh
759     format(a53,i3)
        read(12,758)headh2
758     format(a50)
	do 762 i=1,iendh
762     read(12,1537)j,th2(j),dh2(j)
        read(12,851)vareps2
851     format(a24)
        read(12,765)nopteps2,iende
765     format(a44,i3)
        read(12,763)headeps2
763     format(a48)
	do 764 i=1,iende
764     read(12,1537)j,teps2(j),deps2(j)
        read(12,82)numerpars
82      format(a21)
	read(12,83)maxerr,errmax
83      format(a36,f10.6)
	read(12,84)timestep,dtime
84      format(a25,f7.3)
        read(12,841)maxrun,runmax
841     format(a24,f8.2)
        read(12,842)outinterval,toutput
842     format(a32,f7.2)

	

	go to 113
	endif

c*******************************************************************************
c
c            SET UP THE DEFAULT VALUES
c
c******************************************************************************

1108    ak=.76d0
	alpha=3.6d-7
	beta=.001d0
	youngs=70.d9
	betal=9.5d-6
	sigmab=47.d6
        al=.00635d0
	sl=0.015d0
	h=.5d0
	h1=10.d0
	eps=1.d0
	epsi1=1.d0
	t2i=300.d0
	tinf=300.d0
	dt=.00893
	t=0.d0
	errmax=1.d-4
	runmax=250.d0
	toutput=10.d0
	dtime=1.d0
	dimtime(1)=0.d0
	dimtime(2)=1000.d0
	dambt(1)=0.d0
	dambt(2)=10.d0
	dambt(3)=20.d0
	dambt(4)=30.d0
	dambt(5)=40.d0
	dambt(6)=50.d0
	dambt(7)=60.d0
	dambt(8)=70.d0
	dambt(9)=80.d0
	dambt(10)=90.d0
	dambt(11)=100.d0
	dambt(12)=110.d0
	dambt(13)=120.d0
	dambt(14)=140.d0
	dambt(15)=160.d0
	dambt(16)=180.d0
	dambt(17)=200.d0
	p(1)=0.d0
	p(2)=0.d0
	tamb(1)=300.d0
	tamb(2)=303.30d0
	tamb(3)=303.96
	tamb(4)=304.6
	tamb(5)=305.57
	tamb(6)=306.85
	tamb(7)=308.2
	tamb(8)=310.09
	tamb(9)=312.64
	tamb(10)=315.5
	tamb(11)=319.56
	tamb(12)=325.19
	tamb(13)=331.73
	tamb(14)=353.71
	tamb(15)=388.29
	tamb(16)=437.97
	tamb(17)=831.07
	th2(1)=0.d0
	th2(2)=1000.d0
	dh2(1)=50.d0
	dh2(2)=50.d0
	teps2(1)=0.d0
	teps2(2)=1000.d0
	deps2(1)=1.0d0
	deps2(2)=1.0d0
	iendp=2
	iendh=2
	iendt=17
	iende=2
	ich1='n'
	icoun=0
	ibr=0
	 if(idef.eq.'y')go to 9926
	 if(ifil.eq.'y')then
          ich1='y'
          go to 9927
         endif



113     write(*,1548)
1548    format(1x,'Would you like to change any input data?(y/n)')
	read(*,101,err=113)ich1
	if(ich1.eq.'y'.or.ich1.eq.'n')then
	continue
	else
	go to 113
	endif
	if(ich1.eq.'n')go to 9926
9927    if(ich1.eq.'y')then
         write(*,15453)

c***********************************************************************
c
c         CHOICES FOR THE MENU
c
c***********************************************************************

  22	write(*,7701)
7701    format(1x,'To change the input in any of the following sections, 
     1enter the item number')
	write(*,7703)
7703    format(1x,'of your choice')
        write(*,15453)
        write(*,7704)
7704    format(1x,'1)NO MORE CHANGES')
        write(*,7705)
7705    format(1x,'2)CHANGE PROPERTIES OF GLASS')
	write(*,7706)
7706    format(1x,'3)CHANGE GEOMETRY OF THE WINDOW')
        write(*,77061)
77061   format(1x,'4)CHANGE COEFFICIENTS')
	write(*,77063)
77063   format(1x,'5)CHANGE FLAME RADIATION')
	write(*,77062)
77062   format(1x,'6)CHANGE GAS TEMPERATURE')
        write(*,77763)
77763   format(1x,'7)CHANGE HEAT TRANSFER COEFF. ON HOT LAYER SIDE')
        write(6,77764)
77764   format(1x,'8)CHANGE EMISSIVITY OF HOT LAYER')
	write(*,7707)
7707    format(1x,'9)CHANGE NUMERICAL PARAMETERS')
c       write(*,7708)
7708    format(1x,'10)CHANGE OUTPUT OPTIONS')
        write(*,15453)
        read(*,*,err=22)itmenu
	if(itmenu.eq.1)go to 9926
	if(itmenu.eq.2)go to 4421
	if(itmenu.eq.3)go to 4423
	if(itmenu.eq.4)go to 10518
	if(itmenu.eq.5)go to 1101
	if(itmenu.eq.6)go to 1100
	if(itmenu.eq.7)go to 11000
	if(itmenu.eq.8)go to 21000
	if(itmenu.eq.9)go to 4424
c	if(itmenu.eq.10)go to 4430
	if(itmenu.le.0.or.itmenu.gt.10)go to 22
        endif
2211    continue
        write(*,15453)

c************************************************************************
c
c     PHYSICAL PROPERTIES OF GLASS
c
c************************************************************************

4421	iflag1=0
         ich1='y'
40421    write(*,1549)
1549    format(1x,'PHYSICAL AND MECHANICAL PROPERTIES OF GLASS')
        write(*,15491)
15491   format(1x,'--------------------')
c  read the physical properties of glass
	write(*,1550)ak
1550    format(1x,'1.Thermal conductivity [W/mK]=',e12.4)
	write(*,1551)alpha
1551    format(1x,'2.Thermal diffusivity [m^2/s]=',e12.4)
	write(*,1552)beta
1552    format(1x,'3.Absorption length [m]=',e12.4)
        write(*,15592)sigmab
15592   format(1x,'4.Breaking stress [N/m^2]=',e12.4)
        write(*,15593)youngs
15593   format(1x,'5.Youngs modulus [N/m^2]=',e12.4)
	write(*,15594)betal
15594   format(1x,'6.Linear coefficient of expansion [/deg C]='
     1 ,e12.4)
        write(*,15453)
	if(iflag1.eq.1)go to 115
4422       write(*,15514)
15514      format(1x,'Write item numbers and values you wish to change s
     1eparated by comma.')
	   write(*,10514)
10514   format(1x,'Hit the RETURN or ENTER key after entering each pair. 
     1 End your entry series') 
	   write(*,10515)
10515   format(1x,'by typing any 2 characters. (e.g. 1,.76 RETURN 2,3.6e
     1-7 RETURN EN)')
            i=1
10516      read(*,*,err=40421)ivar(i),xy(i)
        if(ivar(i).le.0.or.ivar(i).gt.6)go to 4422
           if(ivar(i).eq.1)ak=xy(i)
     	   if(ivar(i).eq.2)alpha=xy(i)
           if(ivar(i).eq.3)beta=xy(i)
	   if(ivar(i).eq.4)sigmab=xy(i)
	   if(ivar(i).eq.5)youngs=xy(i)
	   if(ivar(i).eq.6)betal=xy(i)
	   i=i+1
	   iflag1=1
	   go to 10516
115     write(*,15551)
           read(*,101,err=115)ich
	if(ich.eq.'y'.or.ich.eq.'n')then
	continue
	else
	go to 115
	endif
	   if(ich.eq.'y')go to 4422
	   if(ich.eq.'n')go to 9927

c**********************************************************************
c
c                    WINDOW GEOMETRY
c
c**********************************************************************

4423	   iflag1=0
           ich1='y'
44231       write(*,15521)
15521   format(1x,'GEOMETRY')
        write(*,15491)
        write(*,15522)al
15522   format(1x,'1.Glass thickness [m]=',f8.4)
        write(*,1523)sl
1523   format(1x,'2.Shading thickness [m]=',f8.4)
        write(*,15231)h
15231  format(1x,'3.Half-width [m]=',f8.4)
       write(*,15453)
 
	 if(iflag1.eq.1)go to 1115
4122       write(*,15514)
	   write(*,10514)
	   write(*,11515)
11515   format(1x,'by typing any 2 characters. (e.g. 1,.00635 RETURN 2,.
     102 RETURN EN)')
11516      read(*,*,err=44231)ivar(i),xy(i)
        if(ivar(i).le.0.or.ivar(i).gt.3)go to 4122
           if(ivar(i).eq.1)al=xy(i)
     	   if(ivar(i).eq.2)sl=xy(i)
           if(ivar(i).eq.3)h=xy(i)
	   i=i+1
	   iflag1=1
	   go to 11516

1115     write(*,15551)
           read(*,101,err=115)ich
	if(ich.eq.'y'.or.ich.eq.'n')then
	continue
	else
	go to 1115
	endif

	 if(ich.eq.'y')go to 4122
	 if(ich.eq.'n')go to 9927

c*********************************************************************
c
c            COEFFICIENTS
c
c*********************************************************************


10518   iflag1=0
        ich1='y'
191     write(*,10560)
10560   format(1x,'COEFFICIENTS')
        write(*,15491)
        write(*,15531)h1
15531   format(1x,'1.Heat transfer coeff, unexposed [W/m^2-K]=',
     1f7.2)
        write(*,15541)tinf
15541   format(1x,'2.Ambient temp, unexposed [K]=',f7.1)
	write(*,1555)eps
1555    format(1x,'3.Emissivity of glass =',f6.2)
	write(*,15542)epsi1
15542   format(1x,'4.Emissivity of ambient (unexposed) =',f6.2)
        write(*,15453)
	if(iflag1.eq.1)go to 117
4425       write(*,15514)
	   write(*,10514)
	   write(*,10513)
10513   format(1x,'"EN". (e.g. 1,50. RETURN 2,10. RETURN EN)')
            i=1
10517      read(*,*,err=191)ivar(i),xy(i)
	   if(ivar(i).le.0.or.ivar(i).gt.4)go to 4425
	   if(ivar(i).eq.1)h1=xy(i)
	   if(ivar(i).eq.2)tinf=xy(i)
	   if(ivar(i).eq.3)eps=xy(i)
	   if(ivar(i).eq.4)epsi1=xy(i)
	   i=i+1
	   iflag1=1
	   go to 10517
117        write(*,15551)
	   read(*,101,err=117)ich
	   if(ich.eq.'y'.or.ich.eq.'n')then
	   continue
	   else
	   go to 117
	   endif
	   if(ich.eq.'y')go to 4425
	   if(ich.eq.'n')go to 9927

c**********************************************************************
c
c              FLAME RADIATION 
c
c**********************************************************************

1101    iflag1=0
        ich1='y'
        write(*,15453)
458     write(*,10288)
10288    format(1x,'FLAME RADIATION')
         write(*,15491)
	 write(*,15453)
           write(*,15523)
15523   format(1x,'This program can handle time varying flame radiation
     1flux. The flux')
	  write(*,14523)
14523   format(1x,'is specified with values at discrete intervals of tim
     1e. The program')
	  write(*,14524)
14524   format(1x,'then linearly interpolates the flux between time inte
     1rvals.')
         write(*,15491)
119	 write(*,15351)
15351  format(1x,'Values for flux are')
5554    write(*,1536)
1536   format(5x,'point #',5x,'time [s]',13x,'flux [W/m^2]')
1122     do 123 i=1,iendp
123      write(*,1537)i,dimtime(i),p(i)
1537    format(5x,i5,4x,f12.2,10x,f12.2)
        write(*,15453)
	if(iflag1.eq.1)go to 118
        write(*,15453)
9981      write(*,103)
103     format(1x,'What type of change would you like to make?')
	  write(*,104)
104    format(1x,'1. Add time/s')
	  write(*,105)
105    format(1x,'2. Alter data')
          write(*,1051)
1051   format(1x,'3. Enter new data')
	   read(*,*,err=9981)ichoice
	   if(ichoice.le.0.or.ichoice.gt.3)go to 9981
	    if(ichoice.eq.3)go to 127
	    if(ichoice.eq.2)then
24          write(*,108)
108    format(1x,'Which point would you like to be altered?')
	     read(*,*,err=24)i
        write(*,15453)
25       write(*,15362)
15362    format(1x,'Enter time in secs and flux in W/m^2 separated by a 
     1comma.') 
	     read(*,*,err=25)dimtime(i),p(i)
	     iflag1=1
	     go to 5554
	     endif
         if(ichoice.eq.1)go to 1029
127       i=1
1029      write(*,15362)
         write(*,15486)
15486    format(1x,'Hit the "RETURN" or "ENTER" key after entering each 
     1pair. End your')
	  write(*,15487)
15487    format(1x,'entry series by typing any 2 characters. (e.g. 0,100
     100. RETURN EN)')
122      read(*,*,err=221)dimtime(i),p(i)
         i=i+1
	  go to 122
221      iendp=i-1
	  iflag1=1
	  go to 5554
118      write(*,15551)
15551   format(1x,'Would you like to make any more changes in this secti
     1on?(y/n)')
         read(*,101,err=118)ich
	 if(ich.eq.'y'.or.ich.eq.'n')then
	 continue
	 else
	 go to 118
	 endif
	 if(ich.eq.'n')go to 9927
	  if(ich.eq.'y')go to 9981


c*************************************************************************
c
c               GAS TEMPERATURE
c
c*************************************************************************

1100    iflag1=0
        ich1='y'
	write(*,10289)
10289   format(1x,'GAS TEMPERATURE')
	write(*,15491)
        write(*,15453)
	write(*,10290)
10290   format(1x,'This program can handle time varying hot ambient temp
     1erature. The')
	write(*,10291)
10291   format(1x,'temperature is specified with values at discrete inte
     1rvals of time.')
	 write(*,10292)
10292   format(1x,'The program then linearly interpolates the temperatur
     1e between time')
	 write(*,10293)
10293    format(1x,'intervals.')
4442     write(*,15641)
15641  format(1x,'Values for hot layer temp are')
4443    write(*,1563)
1563   format(5x,'point #',5x,'time [s]',13x,'temperature [K]')
1222     do 124 i=1,iendt
124      write(*,1537)i,dambt(i),tamb(i)
        write(*,15453)
         if(iflag1.eq.1)go to 1291
1223     write(*,103)
         write(*,104)
	 write(*,105)
1027	 write(*,1051)
         read(*,*,err=1027)ichoice
	 if(ichoice.le.0.or.ichoice.gt.3)go to 1027
	 if(ichoice.eq.3)go to 1127
	  if(ichoice.eq.2)then
1111	  write(*,108)
	  read(*,*,err=1111)i
178	  write(*,9000)
9000     format(1x,'Enter time in [s] and temperature in [K] separated b
     1y a comma.') 
	  read(*,*,err=178)dambt(i),tamb(i)
	  iflag1=1
	  go to 4443
	  endif
	  if(ichoice.eq.1)go to 1030
1127	 i=1
1030     write(*,9000)
	  write(*,9001)
9001     format(1x,'Hit the "RETURN" or the "ENTER" key after entering e
     1ach pair. ')
          write(*,10281)
10281     format(1x,'End your entry series by typing any 2 characters. (
     1eg. 0.,300. RETURN EN)')
126	 read(*,*,err=241)dambt(i),tamb(i)
         i=i+1
	 go to 126
241      iendt=i-1
         iflag1=1
	 go to 4443
1291      write(*,15551)
	  read(*,101,err=1291)ich
	 if(ich.eq.'y'.or.ich.eq.'n')then
	 continue
	 else
	 go to 1291
	 endif
	  if(ich.eq.'y')go to 1223
          if(ich.eq.'n')go to 9927


c*******************************************************************
c
c          HEAT TRANSFER COEFFICIENT
c
c*******************************************************************

11000    iflag1=0
        ich1='y'
	write(*,1289)
1289    format(1x,'HEAT TRANSFER COEFF ON HOT LAYER SIDE')
	write(*,15491)
        write(*,15453)
	write(*,1290)
1290   format(1x,'This program can handle time varying heat transfer co
     1efficient. The')
	write(*,2291)
2291   format(1x,'coefficient is specified with values at discrete inte
     1rvals of time.')
	 write(*,1292)
1292   format(1x,'The program then linearly interpolates the coefficien
     1t between time')
	 write(*,1293)
1293    format(1x,'intervals.')
44442     write(*,25641)
25641  format(1x,'Values for heat transfer coeff. are')
44443    write(*,2563)
2563   format(5x,'point #',5x,'time [s]',13x,'h2 [W/m^2-K]')
2222     do 3241 i=1,iendh
3241      write(*,1537)i,th2(i),dh2(i)
        write(*,15453)
         if(iflag1.eq.1)go to 3291
2223     write(*,103)
         write(*,104)
	 write(*,105)
2027	 write(*,1051)
         read(*,*,err=2027)ichoice
	 if(ichoice.le.0.or.ichoice.gt.3)go to 2027
	 if(ichoice.eq.3)go to 2127
	  if(ichoice.eq.2)then
2111	  write(*,108)
	  read(*,*,err=2111)i
278	  write(*,8001)
8001     format(1x,'Enter time in [s] and h2 in [W/m^2-K] separated by a
     1 comma.') 
	  read(*,*,err=278)th2(i),dh2(i)
	  iflag1=1
	  go to 44443
	  endif
	  if(ichoice.eq.1)go to 2030
2127	 i=1
2030     write(*,9000)
	  write(*,9002)
9002     format(1x,'Hit the "RETURN" or the "ENTER" key after entering e
     1ach pair. ')
          write(*,20281)
20281     format(1x,'End your entry series by typing any 2 characters. (
     1eg. 0.,300. RETURN EN)')
226	 read(*,*,err=4241)th2(i),dh2(i)
         i=i+1
	 go to 226
4241      iendh=i-1
         iflag1=1
	 go to 44443
3291      write(*,15551)
	  read(*,101,err=3291)ich
	 if(ich.eq.'y'.or.ich.eq.'n')then
	 continue
	 else
	 go to 3291
	 endif
	  if(ich.eq.'y')go to 2223
          if(ich.eq.'n')go to 9927


c***********************************************************************
c
c              EMISSIVITY OF THE HOT LAYER
c
c***********************************************************************

21000    iflag1=0
        ich1='y'
	write(*,2289)
2289    format(1x,'EMISSIVITY OF THE HOT LAYER')
	write(*,15491)
        write(*,15453)
	write(*,2290)
2290   format(1x,'This program can handle time varying emissivity. The 
     1')
	write(*,4291)
4291   format(1x,'emissivity is specified with values at discrete inte
     1rvals of time.')
	 write(*,2292)
2292   format(1x,'The program then linearly interpolates the emissivit
     1y between time')
	 write(*,2293)
2293    format(1x,'intervals.')
54442     write(*,35641)
35641  format(1x,'Values for emissivity are')
54443    write(*,3563)
3563   format(5x,'point #',5x,'time [s]',13x,'emissivity')
3222     do 5241 i=1,iende
5241      write(*,1537)i,teps2(i),deps2(i)
        write(*,15453)
         if(iflag1.eq.1)go to 5291
3223     write(*,103)
         write(*,104)
	 write(*,105)
3027	 write(*,1051)
         read(*,*,err=3027)ichoice
	 if(ichoice.le.0.or.ichoice.gt.3)go to 3027
	 if(ichoice.eq.3)go to 3127
	  if(ichoice.eq.2)then
3111	  write(*,108)
	  read(*,*,err=3111)i
378	  write(*,5001)
5001     format(1x,'Enter time in [s] and emissivity separated by a
     1 comma.') 
	  read(*,*,err=378)teps2(i),deps2(i)
	  iflag1=1
	  go to 54443
	  endif
	  if(ichoice.eq.1)go to 3030
3127	 i=1
3030     write(*,9000)
	  write(*,7002)
7002     format(1x,'Hit the "RETURN" or the "ENTER" key after entering e
     1ach pair. ')
          write(*,30281)
30281     format(1x,'End your entry series by typing any 2 characters. (
     1eg. 0.,300. RETURN EN)')
326	 read(*,*,err=6241)teps2(i),deps2(i)
         i=i+1
	 go to 326
6241      iende=i-1
         iflag1=1
	 go to 54443
5291      write(*,15551)
	  read(*,101,err=5291)ich
	 if(ich.eq.'y'.or.ich.eq.'n')then
	 continue
	 else
	 go to 5291
	 endif
	  if(ich.eq.'y')go to 3223
          if(ich.eq.'n')go to 9927


c*****************************************************************
c
c             NUMERICAL PARAMETERS
c
c***************************************************************** 


4424      iflag1=0
          ich1='y'
44204    write(*,1556)
1556    format(1x,'NUMERICAL PARAMETERS')
        write(*,15491)
	write(*,1557)errmax
1557    format(1x,'1.Maximum fractional error in soln=',f10.6)
	write(*,1559)dtime
1559    format(1x,'2.Size of time step [s]=',f7.3)
         write(*,1560)runmax
1560    format(1x,'3.Maximum run time [s]=',f8.2)
	 write(*,1561)toutput
1561    format(1x,'4.Time interval for output [s]=',f7.2)	 
        write(*,15453)
        if(iflag1.eq.1)go to 129
26	write(*,15514)
        write(*,10514)
	write(*,10520)
10520   format(1x,'by typing any 2 characters (e.g. 1,1.e-4 RETURN EN)')
	i=1
44203	read(*,*,err=44204)ivar(i),xy(i)
	if(ivar(i).le.0.or.ivar(i).gt.4)go to 26
	if(ivar(i).eq.1)errmax=xy(i)
	if(ivar(i).eq.2)dtime=xy(i)
	if(ivar(i).eq.3)runmax=xy(i)
	if(ivar(i).eq.4)toutput=xy(i)
	i=i+1
	iflag1=1
	go to 44203

129     write(*,15551)
	read(*,101,err=129)ich
	 if(ich.eq.'y'.or.ich.eq.'n')then
	 continue
	 else
	 go to 129
	 endif
	if(ich.eq.'y')go to 26
	if(ich.eq.'n')go to 9927


4430    tfire=t2i
        t2i=tamb(1)
        write(*,15453)






9926     error=1.d-6
	dt=dtime*alpha/al**2.d0
	nk=3
        sig=5.67d-8
        write(*,15453)
28      write(*,8853)
8853    format(1x,'Would you like to save your input data in a file?(y/n
     1)')
        read(*,101,err=28)isav
	if(isav.eq.'y')then
29	write(*,8854)
8854    format(1x,'What would you like to call it?(must be in DOS format
     1)')

	read(*,10001,err=29)output
	open(unit=15,file=output)

c**********************************************************************
c
c             SAVE INPUT DATA IN A FILE
c
c**********************************************************************

	write(15,1549)
	write(15,1550)ak
	write(15,1551)alpha
	write(15,1552)beta
	write(15,15592)sigmab
	write(15,15593)youngs
	write(15,15594)betal
	write(15,15521)
	write(15,15522)al
	write(15,1523)sl
	write(15,15231)h
	write(15,10560)
	write(15,15531)h1
	write(15,15541)tinf
	write(15,1555)eps
	write(15,15542)epsi1
	write(15,41)
41      format(1x,'FLAME RADIATION')
        write(15,42)iendp
42      format(1x,'Number of points used for flux input:',i3)
	write(15,1536)
	do 43 i=1,iendp
43      write(15,1537)i,dimtime(i),p(i)
	write(15,44)
44      format(1x,'GAS TEMPERATURE')
	write(15,45)iendt
45      format(1x,'Number of points used for temperature input:',i3)
	write(15,1563)
	do 46 i=1,iendt
46      write(15,1537)i,dambt(i),tamb(i)
        write(15,491)
491     format(1x,'HEAT TRANSFER COEFF. ON HOT LAYER SIDE')
	write(15,492)iendh
492     format(1x,'Number of points used for heat transfer coeff input:'
     1,i3)
	write(15,2563)
	do 493 i=1,iendh
493     write(15,1537)i,th2(i),dh2(i)
	write(15,494)
494      format(1x,'EMISSIVITY OF HOT LAYER')
	write(15,495)iende
495      format(1x,'Number of points used for emissivity input:',i3)
        write(15,3563)
	do 496 i=1,iende
496      write(15,1537)i,teps2(i),deps2(i)
        write(15,1556)
	write(15,1557)errmax
	write(15,1559)dtime
	write(15,1560)runmax
	write(15,1561)toutput
	endif

730	 write(*,729)
729      format(1x,'Would you like to save the output in a file?(y/n)
     1')
	 read(*,101,err=730)ioutput
	  if(ioutput.eq.'n'.or.ioutput.eq.'y')then
	  continue
	  else
	  go to 730
	  endif

	   if(ioutput.eq.'y')then
	   write(*,8854)
           read(*,10001)output1
	   open(unit=21,file=output1)
	   endif



	write(*,220)
220     format(1x,'Begin run')
        write(*,15453)
	write(*,16791)
16791   format(21x,'TEMPERATURE HISTORY')
	write(*,16792)
16792   format(21x,'-------------------')
        write(*,1679)
1679    format(6x,'Time',7x,'Exposed',5x,
     1  'Unexposed',5x,'Theta',6x,'Tau'/,7x,'(s)',9x,'T(K)'
     2  ,9x,'T(K)',5x,'(Average)',/)

c initial temperature distribution
         t2i=tamb(1)
         call init(ak,sig,eps,al,h1,h2(1),tinf,t2i,r,ti)
        sig=5.67d-8
        
c constants in this problem

        pi=4.d0*datan(1.d0)
	g=beta/al
	g11=1.d0/g
	tc=sigmab/(betal*youngs)
	comm=eps*sig*al/ak
	ca=(h2(1)*al*(tfirex(1)-ti)+sig*al*(epsi(1)*tfirex(1)**4.d0
     1     -eps*sig*al*ti**4.d0))/(ak*tc)
	cb=-(h2(1)*al+4.d0*eps*sig*(ti**3.d0)*al)/ak
	cc=-6.d0*comm*tc*(ti**2.d0)
	cd=-4.d0*comm*(tc**2.d0)*ti
	ce=-comm*tc**3.d0
	cf=(h1*al*(ti-tinf)-epsi1*sig*al*tinf**4.d0
     1     +eps*sig*al*ti**4.d0)/(ak*tc)
	cg=(h1*al+4.d0*eps*sig*ti**3.d0*al)/ak
	tcrit=60.d0/tc
        nt=runmax/dtime+1



         tf=(nt-1)*dt
	 tf1=tf+dt
	 time=0.d0
	 iendpa=iendp+1
	 dimtime(iendpa)=tf1*al**2.d0/alpha
	 p(iendpa)=p(iendp)
	 do 1001 k=1,nt
	  do 2001 i=2,iendpa
2001      if(time.le.dimtime(i).and.time.ge.dimtime(i-1))
     1call linear(dimtime(i-1),dimtime(i),p(i-1),p(i),time,aaj)
	  aj(k)=aaj/(ak*tc/al)
1001     time=time+dtime

	  time=0.d0

         iendta=iendt+1
	 dambt(iendta)=tf1*al**2.d0/alpha
	 tamb(iendta)=tamb(iendt)
	 do 6001 k=1,nt
	  do 7001 i=2,iendta
7001      if(time.le.dambt(i).and.time.ge.dambt(i-1))
     1call linear(dambt(i-1),dambt(i),tamb(i-1),tamb(i),time
     1     ,tfirex(k))
6001     time=time+dtime

	 time=0.d0

	 iendha=iendh+1
	 th2(iendha)=tf1*al**2.d0/alpha
	 dh2(iendha)=dh2(iendh)
	 do 6002 k=1,nt
	  do 7009 i=2,iendha
7009      if(time.le.th2(i).and.time.ge.th2(i-1))
     1call linear(th2(i-1),th2(i),dh2(i-1),dh2(i),time,h2(k))
6002     time=time+dtime

         time=0.d0

	 iendea=iende+1
	 teps2(iendea)=tf1*al**2.d0/alpha
	 deps2(iendea)=deps2(iende)
	 do 6003 k=1,nt
	  do 7003 i=2,iendea
7003      if(time.le.teps2(i).and.time.ge.teps2(i-1))call
     1linear(teps2(i-1),teps2(i),deps2(i-1),deps2(i),time,epsi(k))
6003     time=time+dtime

	ca=(h2(1)*al*(tfirex(1)-ti)+sig*al*(epsi(1)*tfirex(1)**4.d0
     1     -eps*ti**4.d0))/(ak*tc)
	cb=-(h2(1)*al+4.d0*eps*sig*(ti**3.d0)*al)/ak


         iflag=0
	t2(1)=0
	t1(1)=r*al/tc
	time=al**2.d0*t/alpha
	temp2(1)=t2(1)*tc+ti
	temp1(1)=t1(1)*tc+ti
	write(*,7757)time,temp2(1),temp1(1),avgt(1),t
3333    format(3(f12.4))
	if(ioutput.eq.'y')then

c********************************************************************
c
c           SAVE OUTPUT IN A FILE
c
c********************************************************************

	write(21,1549)
	write(21,15453)
	write(21,1550)ak
	write(21,1551)alpha
	write(21,1552)beta
	write(21,15592)sigmab
	write(21,15593)youngs
	write(21,15594)betal
	write(21,15453)
	write(21,15521)
	write(21,15453)
	write(21,15522)al
	write(21,1523)sl
	write(21,15231)h
	write(21,15453)
	write(21,10560)
	write(21,15453)
	write(21,15531)h1
	write(21,15541)tinf
	write(21,1555)eps
	write(21,15542)epsi1
	write(21,15453)
	write(21,41)
	write(21,15453)
        write(21,42)iendp
	write(21,1536)
	do 431 i=1,iendp
431     write(21,1537)i,dimtime(i),p(i)
	write(21,15453)
	write(21,44)
        write(21,15453)
	write(21,45)iendt
	write(21,1563)
	do 461 i=1,iendt
461     write(21,1537)i,dambt(i),tamb(i)
	write(21,15453)
        write(21,491)
	write(21,15453)
	write(21,492)iendh
	write(21,2563)
        do 441 i=1,iendh
441     write(21,1537)i,th2(i),dh2(i)
	write(21,15453)
        write(21,494)
	write(21,15453)
	write(21,495)iende
	write(21,3563)
        do 451 i=1,iende
451     write(21,1537)i,teps2(i),deps2(i)
        write(21,15453)
        write(21,1556)
        write(21,15453)
	write(21,1557)errmax
	write(21,1559)dtime
	write(21,1560)runmax
	write(21,1561)toutput
        endif
	if(ioutput.eq.'y')write(21,15453)
	if(ioutput.eq.'y')write(21,16791)
	if(ioutput.eq.'y')write(21,16792)
	if(ioutput.eq.'y')write(21,1679)
	if(ioutput.eq.'y')write(21,7757)time,temp2(1),temp1(1),avgt(1),t

c initialize comparison values to 0
	do 1333 i=1,nt
	t1g(i)=0.d0
1333    t2g(i)=0.d0

c call subroutine for kernels
1228    u(1)=0.d0
	do 4221 k=2,nt,1+1*iflag
4221    u(k)=(float(k-1)*dt)**.5d0

        call kernel(u,nt,iflag)
333     format(1x,5(d12.6,2x))
	go to 2345



c  start calculation of temp

        
2345	taumax=runmax*alpha/al**2.d0
        nto=runmax/toutput+1

        t=0

c   evaluate the multiplication factor

	if(h/al.le.10.d0)then
	ff=1.d0/(.5d0*dtanh(sl/al)+.5d0*al/(sl+h)*(dlog(dcosh(
     1h/al))-dlog(dcosh(sl/al))))
	else
	ff=1.d0/(.5d0*dtanh(sl/al)+.5d0*al/(sl+h)*(dlog(.5d0)
     1+h/al-dlog(dcosh(sl/al))))
	endif
	
        du=dt**.5d0

c    evaluate weights for numerical integration

        do 10 k=2,nt
	i=k-1
        w(1)=1.d0
        w(k)=(float(k-1))**.5d0-(float(k-2))**.5d0
         do 2 j=2,k-1
2        w(j)=(float(j))**.5d0-(float(j-2))**.5d0

	q2(i)=ca+cb*t2(i)+cc*t2(i)**2.d0+cd*t2(i)**3.d0+ce*t2(i)**4.d0
	q1(i)=cf+cg*t1(i)-cc*t1(i)**2.d0-cd*t1(i)**3.d0-ce*t1(i)**4.d0

c defining the function of time change of incoming radiative flux

	t=t+dt


c defining the change in ambient temp on exposed side

	ca=(h2(k)*al*(tfirex(k)-ti)+sig*al*(epsi(k)*tfirex(k)**4.d0
     1   -eps*ti**4.d0))/(ak*tc)
	cb=-(h2(k)*al+4.d0*eps*sig*(ti**3.d0)*al)/ak
	 a=0.d0
	 b=0.d0
	 do 20 j=2,k
	 a=a+w(j)*(uf1(j)*q1(k+1-j)+uf2(j)*q2(k+1-j))
20       b=b+w(j)*(-uf2(j)*q1(k+1-j)-uf1(j)*q2(k+1-j))
	 
	 do 1421 j=1,k
	 a=a+w(j)*((uf2(j)+uf1(j))*r*al/tc
     1     +g11*uf3(j)*aj(k+1-j))
1421     b=b+w(j)*((-uf1(j)-uf2(j))*r*al/tc
     1     +g11*ug3(j)*aj(k+1-j))



         ak1=du*a
	 ak2=du*b+r*al/tc
	 y=du*uf2(1)*w(1)
	 z=-du*uf2(1)*w(1)
	 x1=y*ca
	 x2=(cb-1.d0/y)*y
	 x3=cc*y
	 x4=cd*y
	 x5=ce*y
	 y1=z*cf
	 y2=(cg-1.d0/z)*z
         y3=-cc*z
	 y4=-cd*z
	 y5=-ce*z
  
	 t2guess=t2(k-1)
	 t1guess=t2(k-1)
	 call newton(ak1,x1,x2,x3,x4,x5,t2guess)
	 call newton(ak2,y1,y2,y3,y4,y5,t1guess)

         if(t2guess.lt.0.d0)t2guess=0
         t2(k)=t2guess
	 if(t1guess.lt.t1(1))t1guess=t1(1)
	 t1(k)=t1guess
	 chi=(1.d0-derfc(t**.5d0))/2.d0
	 avgt(k)=(t1(k)+t2(k))*chi
	 time=t*al**2.d0/alpha


	 temp2(k)=t2(k)*tc+ti
	 temp1(k)=t1(k)*tc+ti
7757    format(5x,f5.1,5x,f8.1,5x,f8.1,5x,f6.3,5x,f6.3)

        do 6543 i=1,nto
	diff=time-i*toutput
	if(diff.lt.0)diff=-diff
	if(diff.le..001.and.ioutput.eq.'y')
     1write(21,7757)time,temp2(k),temp1(k),
     1  avgt(k),t
6543  	if(diff.le..001d0) 
     1	write(*,7757)time,temp2(k),temp1(k),avgt(k),t
	if(avgt(k).ge.ff)then
	ibr=1
      	write(*,7757)time,temp2(k),temp1(k),avgt(k),t
      	if(ioutput.eq.'y')write(21,7757)
     1time,temp2(k),temp1(k),avgt(k),t
	go to 1330
	endif
    	q2(k)=ca+cb*t2(k)+cc*t2(k)**2.d0+cd*t2(k)**3.d0+ce*t2(k)**4.d0
        q1(k)=cf+cg*t1(k)-cc*t1(k)**2.d0-cd*t1(k)**3.d0-ce*t1(k)**4.d0

10      continue
        
        go to 1330



c check the diff between values of 2 different time steps

c         err=0.d0
c        do 1229 j=1,nt/2+1
c	if(t2(2*j-1).gt.1)then
c	diff=(t2g(j)-t2(2*j-1))/t2(2*j-1)
c	else
c	diff=t2g(j)-t2(2*j-1)
c	endif
c	if(diff.lt.0)diff=-diff
c1229    if(diff.gt.err)err=diff

c if diff between values at diff time steps is too big, reduce time step
cc  and re-do calculations for smaller time step
c
c        if(err.lt.errmax)go to 1330
c	dt=dt/2.d0
c	nt=(nt-1)*2+1
c        iflag=1
c
c if error bound condition not met
c
c	do 1331 k=1,nt/2+1
c	kk=2*k-1
c	u(kk)=u(k)
c	uuf1(kk)=uf1(k)
c	uuf2(kk)=uf2(k)
c	uuf3(kk)=uf3(k)
c	uug3(kk)=ug3(k)
c	t2g(k)=t2(k)
c1331    t1g(k)=t1(k)
c
c	 do 1354 k=1,nt/2+1
c	 kk=2*k-1
c	 uf1(kk)=uuf1(kk)
c	 uf2(kk)=uuf2(kk)
c	 uf3(kk)=uuf3(kk)
c1354     ug3(kk)=uug3(kk)
c	iter=iter+1
c	if(iter.eq.3)go to 1330
c	go to 1228
    
	    


1330	if(ibr.eq.1)then
        avgtinit=(temp2(1)+temp1(1))/2.d0
	avgtbr=(temp2(k)+temp1(k))*chi+ti*(1.d0-2.d0*chi)
	avgtdelt=avgtbr-avgtinit
	timec=al**2.d0/alpha 
	tempc=sigmab/(betal*youngs)
         write(*,8121)time
	 write(*,15453)
	 write(*,1667)timec,tempc 
1667     format(1x,'tau = t/tc, tc = ',f5.1,' s, Avg. theta = (Tav-Ti)/T
     1c, Tc = ',f5.1,' K')
	 write(*,1668)ff
	 write(*,1666)avgtinit,avgtdelt,avgtbr
1666     format(1x,'Avg. T init  = ',f5.1,' K, Avg. Delta T = ',f5.1,
     1' K, Avg. T break = ',f5.1,' K')
1668     format(1x,'g = ',f5.3) 
         if(ioutput.eq.'y')then
	  write(21,8121)time
8121      format(1x,'Window breaks at time = ',f8.2,'  [s]')
          write(21,15453)
	  write(21,1667)timec,tempc
	  write(21,1668)ff
	  write(21,1666)avgtinit,avgtdelt,avgtbr
   	 endif
        else
	 tfdim=tf*al**2.d0/alpha
	 write(*,8123)tfdim
	 if(ioutput.eq.'y')write(21,8123)tfdim
8123    format(1x,'Window did not break in run time of',f8.2,' [s]
     1')
	 if(ioutput.eq.'y')write(21,15453)
	 if(ioutput.eq.'y')write(21,1667)timec,tempc
	 if(ioutput.eq.'y')write(21,1668)g
        endif
	write(*,15453)
	write(*,15453)
	close(unit=10)
	close(unit=11)
	close(unit=20)
	close(unit=12)
	close(unit=15)
	close(unit=21)
	close(unit=22)
914       write(*,913)
913     format(1x,'Would you like to run the program again?(y/n)')
          read(*,101,err=914)ich
	   if(ich.eq.'n'.or.ich.eq.'y')then
	   continue
	   else
	   go to 914
	   endif
	    if(ich.eq.'n')go to 1332
	    if(ich.eq.'y')go to 111
      
1332      stop
	end


c*******************************************************************
c
c               FUNCTION DERFC
c
c******************************************************************

      FUNCTION DERFC(D)
      implicit double precision(a-h,o-z)
      IF(D.LT.0.)THEN
        DERFC=1.d0+GAMMP(.5d0,D**2)
      ELSE
        DERFC=1.d0-GAMMP(.5d0,D**2)
      ENDIF
      RETURN
      END

c******************************************************************
c
c        FUNCTION GAMMLN
c
c******************************************************************

      FUNCTION GAMMLN(XX)
      implicit double precision(a-h,o-z)
      dimension cof(6)
      DATA COF,STP/76.18009173D0,-86.50532033D0,24.01409822D0,
     *    -1.231739516D0,.120858003D-2,-.536382D-5,2.50662827465D0/
      DATA HALF,ONE,FPF/0.5D0,1.0D0,5.5D0/
      X=XX-ONE
      TMP=X+FPF
      TMP=(X+HALF)*DLOG(TMP)-TMP
      SER=ONE
      DO 11 J=1,6
        X=X+ONE
        SER=SER+COF(J)/X
11    CONTINUE
      GAMMLN=TMP+DLOG(STP*SER)
      RETURN
      END

c********************************************************************
c
c         FUNCTION GAMMP
c
c********************************************************************

      FUNCTION GAMMP(A,X)
      implicit double precision(a-h,o-z)
      IF(X.LT.0..OR.A.LE.0.)PAUSE
      IF(X.LT.A+1.)THEN
        CALL GSER(GAMSER,A,X,GLN)
        GAMMP=GAMSER
      ELSE
        CALL GCF(GAMMCF,A,X,GLN)
        GAMMP=1.-GAMMCF
      ENDIF
      RETURN
      END

c*********************************************************************
c
c               SUBROUTINE GCF
c
c**********************************************************************

      SUBROUTINE GCF(GAMMCF,A,X,GLN)
      implicit double precision(a-h,o-z)
      PARAMETER (ITMAX=100,EPS=3.d-7)
      GLN=GAMMLN(A)
      GOLD=0.
      A0=1.
      A1=X
      B0=0.
      B1=1.
      FAC=1.
      DO 11 N=1,ITMAX
        AN=FLOAT(N)
        ANA=AN-A
        A0=(A1+A0*ANA)*FAC
        B0=(B1+B0*ANA)*FAC
        ANF=AN*FAC
        A1=X*A0+ANF*A1
        B1=X*B0+ANF*B1
        IF(A1.NE.0.)THEN
          FAC=1./A1
          G=B1*FAC
          IF(ABS((G-GOLD)/G).LT.EPS)GO TO 1
          GOLD=G
        ENDIF
11    CONTINUE
      PAUSE 'A too large, ITMAX too small'
1     GAMMCF=dEXP(-X+A*dLOG(X)-GLN)*G
      RETURN
      END

c******************************************************************
c 
c          SUBROUTINE GSER
c
c******************************************************************

      SUBROUTINE GSER(GAMSER,A,X,GLN)
      implicit double precision (a-h,o-z)
      PARAMETER (ITMAX=1000,EPS=3.d-7)
      GLN=GAMMLN(A)
      IF(X.LE.0.)THEN
        IF(X.LT.0.)PAUSE
        GAMSER=0.
        RETURN
      ENDIF
      AP=A
      SUM=1./A
      DEL=SUM
      DO 11 N=1,ITMAX
        AP=AP+1.
        DEL=DEL*X/AP
        SUM=SUM+DEL
        IF(ABS(DEL).LT.ABS(SUM)*EPS)GO TO 1
11    CONTINUE
      PAUSE 'A too large, ITMAX too small'
1     GAMSER=SUM*DEXP(-X+A*DLOG(X)-GLN)
      RETURN
      END

c**************************************************************
c
c subroutine to calculate initial temperature
c
c**************************************************************

	  subroutine init(ak,sig,eps,al,h1,h2,tinf,t2i,r,ti)
	  implicit double precision(a-h,o-z)
          dimension tti(2)

          tti(1)=(tinf+t2i)/2.d0
1         r=(h2*(t2i-tti(1))+sig*eps*(t2i**4.d0-tti(1)**4.d0))/(-ak)
	  tti(2)=(-r*(ak+h1*al)+h1*tinf-sig*eps*((tti(1)+r*al)
     1          **4.d0-tinf**4.d0))/h1
	  res=(tti(2)-tti(1))/tti(2)
	  if(res.le.0)res=-res
	  if(res.ge.0.001d0)then
	  tti(1)=tti(2)*.1d0+tti(1)*.9d0
	  go to 1
	  endif
	  ti=tti(2)
	  return
	  end

c*******************************************************************
c 
c subroutine for linear interpolation
c
c******************************************************************** 

	   subroutine linear(a,b,c,d,e,f)
	   implicit double precision(a-h,o-z)
	   common /lin/ ak,tc,al

	   f=c+(e-a)*(d-c)/
     1            (b-a)

           return
	   end

c*******************************************************************
c
c          SUBROUTINE FOR EVALUATING KERNELS
c
c*******************************************************************

	subroutine kernel(u,nn,iflag)
	implicit double precision(a-h,o-z)

        dimension uf1(1005),uf2(1005),uf3(1005),ug1(1005),
     1  ug2(1005),ug3(1005),u(1005)
	common /kern/g,g11,uf1,uf2,uf3,ug3,pi,nk,h2(1005),epsi(1005)



        uf1(1)=0.d0
	uf2(1)=1.d0/pi**.5d0
	ug1(1)=-uf2(1)
	ug2(1)=-uf1(1)
	uf3(1)=0.d0
	ug3(1)=0.d0



	bbb=-g*(dexp(-g11)-1.d0)

	do 1001 k=2,nn,1+1*iflag



c    long time solution

        rtu=.05d0
        if(u(k).le.rtu) go to 1000


        aa=0
	do 1 i=1,nk
1       aa=aa+dexp(-(i*pi*u(k))**2.d0)*(-1.d0)**i

	uf1(k)=-u(k)*(1.d0+2.d0*aa)
	ug2(k)=-uf1(k)

	bb=0
	do 2 i=1,nk
2       bb=bb+dexp(-(i*pi*u(k))**2.d0)

	uf2(k)=u(k)*(1.d0+2.d0*bb)
	ug1(k)=-uf2(k)



          d=0 
	  e=0
	  do 3 i=1,nk
	  d=((-1.d0)**i*dexp(-g11)-1.d0)*2.d0
     1      /((-(i*pi)**2.d0-g11**2.)*g)
 3        e=e+d*dexp(-(i*pi*u(k))**2.d0)
   
	uf3(k)=u(k)*(bbb+e)

          d=0 
	  e=0
	  do 4 i=1,nk
	  d=(dexp(-g11)-(-1.d0)**i)*2.d0
     1      /((-(i*pi)**2.d0-g11**2.)*g)
 4        e=e+d*dexp(-(i*pi*u(k))**2.d0)
   
	ug3(k)=u(k)*(bbb+e)
      
	go to 2000

c   short time solution

1000    aa=0
	do 7 i=0,nk
7       aa=aa+dexp(-(2.d0*i+1.d0)**2.d0/(4.d0*u(k)**2.d0))
 
	uf1(k)=-2.d0*aa/(pi**.5d0)
	ug2(k)=-uf1(k)

        bb=0
	do 8 i=1,nk
8       bb=bb+dexp(-(2.d0*i)**2.d0/(4.d0*u(k)**2.d0))

        uf2(k)=(1.d0+2.d0*bb)/(pi)**0.5d0
	ug1(k)=-uf2(k)


	a=dexp((u(k)/g)**2.d0)
        bb=u(k)/g
	b=-dexp(bb**2.d0)/2.d0*
     1    (derfc(-bb)-derfc(bb))

          c=0
	  d=0
	  e=0
	  f=0
	  do 9 i=0,nk
	  cc=(2.d0*i+1)/(2.d0*u(k))

	  d=d+dexp(-(2.d0*i+1.d0)/g)*derfc(cc-bb)-
     1      dexp((2.d0*i+1.d0)/g)*derfc(cc+bb)

 9        continue
          do 10 i=1,nk
	  dd=i/u(k)

	  f=f+dexp(-2.d0*i/g)*derfc(dd-bb)-
     1      dexp(2.d0*i/g)*derfc(dd+bb)
10        continue

          uf3(k)=u(k)*(a+b+dexp(-g11)*d*a-a*f)

          ug3(k)=u(k)*(dexp(-g11)*(a-b+a*f)-a*d)
2000      continue

1001      continue
          return
	  end

c************************************************************************
c
c              SUBROUTINE FOR FINDING ROOTS OF THE EQUATION
c
c*********************************************************************** 


         subroutine newton(ak,c1,c2,c3,c4,c5,guess)
	 implicit double precision(a-h,o-z)
	 common /newt/ error
	 dimension x(2)

         x(1)=guess
	 it=0
1        it=it+1
	 f=ak+c1+c2*x(1)+c3*x(1)**2.d0
     1     +c4*x(1)**3.d0+c5*x(1)**4.d0
	
	 dfdx=c2+2.d0*c3*x(1)+3.d0*c4*x(1)**2.d0
     1        +4.d0*c5*x(1)**3.d0

	 x(2)=x(1)-f/dfdx

         if(x(2).le.1d-8)then
	 check=x(2)-x(1)
	 else
	 check=(x(2)-x(1))/x(2)
	 endif
	 if(check.lt.0)check=-check

	  if(check.ge.error)then
	   x(1)=x(2)
	    if(it.ge.100)go to 2
	    go to 1
          endif

	  go to 4
2         write(6,100)
100       format(1x,'iteration limit exceeded')
4         guess=x(2)
	  return
	  end


