/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.framework;

import java.io.IOException;
import java.io.InputStream;

public final class ChunkyByteArray
extends InputStream {
    private static final int CHUNK_SHIFT = 14;
    private static final int CHUNK_SIZE = 16384;
    private static final int CHUNK_MASK = 16383;
    private static final int INITIAL_CHUNK_COUNT = 64;
    private InputStream fInputStream;
    private byte[][] fData = new byte[64][];
    private int fLength;
    private int fOffset;

    public ChunkyByteArray(InputStream inputStream) throws IOException {
        this.fInputStream = inputStream;
        this.fill();
    }

    public int read() throws IOException {
        if (this.fData == null) {
            if (this.fInputStream == null) {
                return -1;
            }
            return this.fInputStream.read();
        }
        byte by = this.fData[0][this.fOffset];
        if (++this.fOffset == this.fLength) {
            this.fData = null;
            if (this.fLength < 16384) {
                this.fInputStream = null;
            }
        }
        return by;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.fLength - this.fOffset;
        if (n3 == 0) {
            if (this.fInputStream == null) {
                return -1;
            }
            return this.fInputStream.read(byArray, n, n2);
        }
        if (n2 <= 0) {
            return 0;
        }
        byte[] byArray2 = this.fData[0];
        if (n2 >= n3) {
            n2 = n3;
            if (this.fLength < 16384) {
                this.fInputStream = null;
            }
        }
        if (byArray == null) {
            this.fOffset += n2;
            return n2;
        }
        int n4 = n + n2;
        do {
            byArray[n++] = byArray2[this.fOffset++];
        } while (n < n4);
        return n2;
    }

    public void rewind() {
        this.fOffset = 0;
    }

    private void fill() throws IOException {
        int n = this.fLength >> 14;
        byte[] byArray = new byte[16384];
        this.fData[n] = byArray;
        int n2 = 0;
        int n3 = 16384;
        int n4 = 0;
        do {
            if ((n4 = this.fInputStream.read(byArray, n2, n3)) == -1) {
                byArray[n2] = -1;
                this.fInputStream.close();
                this.fInputStream = null;
                return;
            }
            if (n4 <= 0) continue;
            this.fLength += n4;
            n2 += n4;
            n3 -= n4;
        } while (n3 > 0);
    }

    public byte byteAt(int n) {
        int n2 = n >> 14;
        int n3 = n & 0x3FFF;
        try {
            return this.fData[n2][n3];
        }
        catch (NullPointerException nullPointerException) {
            try {
                if (n3 == 0) {
                    this.fill();
                    return this.fData[n2][n3];
                }
                return 0;
            }
            catch (IOException iOException) {
                return 0;
            }
        }
    }

    public boolean atEOF(int n) {
        return n > this.fLength;
    }

    public void checkEOF(int n) {
        if (n > this.fLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }
}

