/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dom;

import com.ibm.xml.dom.DOMExceptionImpl;
import com.ibm.xml.dom.DocumentImpl;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class NodeImpl
implements Node,
NodeList,
Cloneable,
Serializable {
    static final long serialVersionUID = 2815829867052120872L;
    public static final short ELEMENT_DEFINITION_NODE = -1;
    protected DocumentImpl ownerDocument;
    protected NodeImpl parentNode;
    protected NodeImpl previousSibling;
    protected NodeImpl nextSibling;
    protected String name;
    protected String value;
    protected boolean readOnly;
    protected Object userData;
    protected NodeImpl firstChild;
    protected NodeImpl lastChild;
    protected transient boolean syncChildren;
    protected transient boolean syncData;
    int changes;
    protected static int[] kidOK = new int[13];

    protected NodeImpl(DocumentImpl documentImpl, String string, String string2) {
        this.ownerDocument = documentImpl != null ? documentImpl : (DocumentImpl)this;
        this.name = string;
        this.value = string2;
    }

    public NodeImpl() {
    }

    public abstract short getNodeType();

    public String getNodeName() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.name;
    }

    public void setNodeValue(String string) {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        this.value = string;
    }

    public String getNodeValue() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.value;
    }

    public Node appendChild(Node node) throws DOMException {
        return this.insertBefore(node, null);
    }

    public Node cloneNode(boolean bl) {
        NodeImpl nodeImpl;
        if (this.syncData) {
            this.synchronizeData();
        }
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        try {
            nodeImpl = (NodeImpl)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        nodeImpl.readOnly = false;
        nodeImpl.parentNode = null;
        nodeImpl.previousSibling = null;
        nodeImpl.nextSibling = null;
        nodeImpl.firstChild = null;
        nodeImpl.lastChild = null;
        if (bl) {
            NodeImpl nodeImpl2 = (NodeImpl)this.getFirstChild();
            while (nodeImpl2 != null) {
                nodeImpl.appendChild(nodeImpl2.cloneNode(true));
                nodeImpl2 = (NodeImpl)nodeImpl2.getNextSibling();
            }
        }
        return nodeImpl;
    }

    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public Node getNextSibling() {
        return this.nextSibling;
    }

    public Node getPreviousSibling() {
        return this.previousSibling;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public boolean hasChildNodes() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.firstChild != null;
    }

    public NodeList getChildNodes() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this;
    }

    public Node getFirstChild() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.firstChild;
    }

    public Node getLastChild() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.lastChild;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        if (!(node instanceof NodeImpl) || node.getOwnerDocument() != this.ownerDocument && (this.getNodeType() != 9 || node.getOwnerDocument() != (Document)((Object)this))) {
            throw new DOMExceptionImpl(4, null);
        }
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        NodeImpl nodeImpl = (NodeImpl)node;
        boolean bl = true;
        NodeImpl nodeImpl2 = this.parentNode;
        while (bl && nodeImpl2 != null) {
            bl = nodeImpl != nodeImpl2;
            nodeImpl2 = nodeImpl2.parentNode;
        }
        if (!bl) {
            throw new DOMExceptionImpl(3, null);
        }
        if (node2 != null && node2.getParentNode() != this) {
            throw new DOMExceptionImpl(8, null);
        }
        if (nodeImpl.getNodeType() == 11) {
            Node node3 = nodeImpl.getFirstChild();
            while (node3 != null) {
                NodeImpl nodeImpl3 = this;
                if ((kidOK[nodeImpl3.getNodeType()] & 1 << node3.getNodeType()) == 0 && !false) {
                    throw new DOMExceptionImpl(3, null);
                }
                node3 = node3.getNextSibling();
            }
            while (nodeImpl.hasChildNodes()) {
                this.insertBefore(nodeImpl.getFirstChild(), node2);
            }
        } else {
            Node node4 = this;
            NodeImpl nodeImpl4 = nodeImpl;
            if ((kidOK[node4.getNodeType()] & 1 << nodeImpl4.getNodeType()) == 0 && !false) {
                throw new DOMExceptionImpl(3, null);
            }
            node4 = nodeImpl.getParentNode();
            if (node4 != null) {
                node4.removeChild(nodeImpl);
            }
            nodeImpl4 = node2 == null ? this.lastChild : ((NodeImpl)node2).previousSibling;
            nodeImpl.parentNode = this;
            nodeImpl.previousSibling = nodeImpl4;
            if (nodeImpl4 == null) {
                this.firstChild = nodeImpl;
            } else {
                nodeImpl4.nextSibling = nodeImpl;
            }
            nodeImpl.nextSibling = (NodeImpl)node2;
            if (node2 == null) {
                this.lastChild = nodeImpl;
            } else {
                ((NodeImpl)node2).previousSibling = nodeImpl;
            }
        }
        this.changed();
        return nodeImpl;
    }

    public Node removeChild(Node node) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        if (node != null && node.getParentNode() != this) {
            throw new DOMExceptionImpl(8, null);
        }
        NodeImpl nodeImpl = (NodeImpl)node;
        NodeImpl nodeImpl2 = nodeImpl.previousSibling;
        NodeImpl nodeImpl3 = nodeImpl.nextSibling;
        if (nodeImpl2 != null) {
            nodeImpl2.nextSibling = nodeImpl3;
        } else {
            this.firstChild = nodeImpl3;
        }
        if (nodeImpl3 != null) {
            nodeImpl3.previousSibling = nodeImpl2;
        } else {
            this.lastChild = nodeImpl2;
        }
        nodeImpl.parentNode = null;
        nodeImpl.nextSibling = null;
        nodeImpl.previousSibling = null;
        this.changed();
        return nodeImpl;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        this.insertBefore(node, node2);
        return this.removeChild(node2);
    }

    public int getLength() {
        int n = 0;
        NodeImpl nodeImpl = this.firstChild;
        while (nodeImpl != null) {
            ++n;
            nodeImpl = nodeImpl.nextSibling;
        }
        return n;
    }

    public Node item(int n) {
        NodeImpl nodeImpl = this.firstChild;
        int n2 = 0;
        while (n2 < n && nodeImpl != null) {
            nodeImpl = nodeImpl.nextSibling;
            ++n2;
        }
        return nodeImpl;
    }

    public void setReadOnly(boolean bl, boolean bl2) {
        if (this.syncData) {
            this.synchronizeData();
        }
        this.readOnly = bl;
        if (bl2) {
            if (this.syncChildren) {
                this.synchronizeChildren();
            }
            NodeImpl nodeImpl = this.firstChild;
            while (nodeImpl != null) {
                if (!(nodeImpl instanceof EntityReference)) {
                    nodeImpl.setReadOnly(bl, true);
                }
                nodeImpl = nodeImpl.nextSibling;
            }
        }
    }

    public boolean getReadOnly() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.readOnly;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public Object getUserData() {
        return this.userData;
    }

    protected void synchronizeChildren() {
    }

    protected void synchronizeData() {
    }

    protected void changed() {
        ++this.changes;
        if (this.parentNode != null) {
            this.parentNode.changed();
        }
    }

    protected static boolean isKidOK(Node node, Node node2) {
        return (kidOK[node.getNodeType()] & 1 << node2.getNodeType()) != 0;
    }

    public String toString() {
        return "[" + this.getNodeName() + ": " + this.getNodeValue() + "]";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.syncData) {
            this.synchronizeData();
        }
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        objectOutputStream.defaultWriteObject();
    }

    static {
        NodeImpl.kidOK[9] = 1410;
        NodeImpl.kidOK[1] = 442;
        NodeImpl.kidOK[5] = 442;
        NodeImpl.kidOK[6] = 442;
        NodeImpl.kidOK[11] = 442;
        NodeImpl.kidOK[2] = 40;
        NodeImpl.kidOK[12] = 0;
        NodeImpl.kidOK[4] = 0;
        NodeImpl.kidOK[3] = 0;
        NodeImpl.kidOK[8] = 0;
        NodeImpl.kidOK[7] = 0;
        NodeImpl.kidOK[10] = 0;
    }
}

